\begindata{text, 268689368}
\textdsversion{12}
\template{default}
\majorheading{
Maintaining VUI for Andrew and the PC

}
\center{Mark Chance

CMU-ITC

8 March 1988

}
\heading{Introduction}


This document describes the development and maintenance procedures currently 
in use for the Andrew Mail System program called VUI (Visual User Interface).  
Although it describes VUI, the same procedures could be used for other 
applications such as CUI.  To successfully accomplish the tasks described 
here, the reader should be somewhat familiar with RCS (see \italic{help rcs}), 
AMS and VUI functions (see \italic{help ams} and \italic{help vui}), pcserver, 
Unix, and C compilers.  The Andrew commands I have included here are current 
as of this writing, though they may change as the ITC changes software 
maintenance procedures.



\heading{Initial Set Up

}
\subheading{Workstation side

}Create two directories for sources.  Link one directory to itc/ams/libs, the 
other to itc/ams/vui.


\example{mkdir ~/ams/libs

mkdir ~/ams/vui

cd ~/ams/libs

rcslink itc/ams/libs

rcsupdate

cd ~/ams/vui

rcslink itc/ams/vui

rcsupdate

}
\subheading{PC Side

}Use pcserver to login to your home directory, /cmu/msdos/ibmpc as F: and 
/usr/andrew as I:.  Make your home directory the current disk/directory.  
Establish the proper path and any environment variables so that the C compiler 
will run properly.



\heading{Compiling}


I usually build and test the program on the workstation first because of the 
faster building turnaround time.  Then when the program has stabilized, I 
build a PC version. To make an executable rt version of the program issue the 
following command:\example{


make vuin}


The RCS commands for checking out and in files are co and ci.  See the Unix 
manual or the man pages for details.


\subheading{Libraries

}On your workstation, run rcsupdate in the libs directory or make any 
necessary changes.  Run makePCbat in libs.  Then on your PC make ams/libs the 
current directory and run the batch file generated by makePCbat.  Look through 
the output to verify you got a valid libcuisnap.lib.


\example{cd ~/ams/libs

rcsupdate

makePCbat}


When you have a good copy of libcuisnap.lib, copy it into 
/cmu/msdos/ibmpc/lib.

\subheading{Applications

}Make any changes or updates to the files in ~/ams/vui, run makePCbat and 
execute the batch file on the PC.  Look through the output and verify you got 
a valid vui.exe.  Caution: the PC batch system does not stop when a program 
has a bad return code.  Unfortunately this means that if a compile step has a 
problem, the link step will attempt to continue.  If it happens to pick up an 
old object file, the changes you expect will not have been included.


\example{cd ~/ams/vui

makePCbat

}
The final step of the batch file copies vui.exe to your local disk.  To assist 
in debugging, pressing Alt-F1 (or Esc ! on a workstation) initiates a tracing 
facility that writes out diagnostic messages to a file called vui.bug in the 
current directory.  One technique I have found handy on occasion is to execute 
\typewriter{"tail -f vui.bug"} in a typescript to see messages as they are put 
into vui.bug.  Also running gdb or dbx on the workstation can be useful.


A convention that has served quite well is to keep a current version number in 
VUIVERS.h and increment the minor version number each time a new copy is 
released to /usr/andy/bin or /cmu/msdos/ibmpc/exp/common.



\heading{Documentation

}
Help files exist for use in the program.  These are stored in RCS in the 
helptexts subdirectory of itc/ams/vui.  The scheme for these files is that 
there is a file whose name contains a number which corresponds to a command 
number as found in vuimenus.h.  For those situations in the program where the 
user is not on a command menu,  there is a help file with a more descriptive 
name.


There are also help and tutorial files in the vui directory.  These should be 
updated whenever there are major updates to the program.



\heading{Releasing


}On the workstation side the release process works the same as for any other 
program (currently 'wash itc/ams/vui').  For the PC side, releasing means 
placing a copy of vui.exe in /cmu/msdos/ibmpc/exp/common.  A "campus release" 
for the PC would mean copying into /cmu/msdos/ibmpc/common.  After doing this 
an announcement should be put in the andrew.ms.pcmsgs and/or andrew.ms.vui 
bulletin boards describing the new features and bug fixes.  The Academic 
Computing group also appreciates developers monitoring org.advisor.helpbox.ams 
and org.advisor.helpbox.pc.ams bboards.



\heading{Notes

}
\subheading{error 2000: stack overflow

}The PC puts all local variables on the stack.  You can adjust the stack size 
after linking by using the exemod program on the PC.

\example{exemod vui.exe /STACK xxxx

}If you make the value xxxx too large you will get the stack overflow message 
immediately upon loading the vui program.  If you reduce it slightly you may 
get error: insufficient environment space.  This means you are very close, and 
should reduce the value just a bit more.


\subheading{Other PC libraries

}The makefile links in two libraries not previously mentioned.  These are 
snapl.lib and unixl.lib.  Currently these live in /cmu/msdos/ibmpc/lib and are 
maintained by Larry Raper.


\subheading{Miscellaneous PC specifics

}
Because the PC considers int != long, you have to be careful with functions 
that return longs and functions that have longs as arguments.  To assure these 
are properly declared cast any function arguments that are constants and 
should be pointers or longs.  Also declare at the beginning of a module any 
library or server functions that return long.


There are modifications to standard Microsoft include files that I have made.  
These include:

\leftindent{pwd.h copied from Andrew:/usr/include

sys/param.h condensed from Andrew:/usr/include

sys/socket.h copied from Andrew:/usr/include/sys

netinet/in.h copied from Andrew:/usr/include/netinet (1)

sys/types.h got definitions added for sys/socket.h (1)

sys/stat.h got '#include <sys/types.h>' added (1)

errno.h got several new codes added

sys/file.h copied from Andrew:/usr/include

sys/time.h from PC:include

}

Note 1: These modifications only for compiling snap functions.  If you can use 
snap?.lib files, these changes are not necessary.


\heading{Appendix A: Andrew Utilities

}
\subheading{The makePCbat shell script

}This shell script currently lives in ams/vui.  Its purpose is to 
automatically perform some conversions between file types and commands on the 
PC and those that Unix uses.


There is an occasional problem with makePCbat in that the PC batch file 
interpreter only allows ~250 characters per line.  The link step can be 
longer.  To correct this I edit the batch file on the workstation and remove 
all the .obj and .lib file extensions.  When not too many things change from 
compile to compile, you can just re-use the batch file or edit it slightly to 
do what you want.



\heading{Appendix B: PC Utilities

}
\subheading{The addlib program

}This is a simple program which accepts the syntax of the Unix ar command, and 
generates the proper Microsoft Library Manager operations.


\heading{Document Change History


}Created 12/87 by M. Chance

Updated 1/88 by M. Chance - reflect status of upgrading to Microsoft C Version 
5.00

Updated 3/88 by M. Chance - don't use rinsepc/PCwash, rather use makePCbat 
which is simpler.

\enddata{text,268689368}
