\begindata{text,270270256}
\textdsversion{12}
\template{default}
\define{sans
}
\define{concat
}
\flushright{7 December 1989}



\italic{\{\{Future: This version of the manual includes planned but 
non-existent features.  These are delimited by double curly brackets so they 
can be removed to form the manual itself.\}\}}




\majorheading{Ness User's Manual}


\center{by Wilfred J. Hansen}


\indent{\flushright{\smaller{_________________________________


Information Technology Center,

Carnegie Mellon University


Copyright IBM Corporation 1988, 1989

__________________________________


}}
Ness is a programming language for the Andrew ToolKit.  You may encounter it 
as a program in a file with the extension .n or as an inset which shows as a 
scrollbar and contains text beginning, "\bold{NESS} - This inset is a Ness 
script."


This document describes usage of Ness scripts and programs for those who 
encounter them in documents or applications or wish to run stand-alone Ness 
programs.   Authors should read this document to be able to test their 
creations and to understand user expectations.  This document also describes 
the other documents available for Ness.



   1. Ness scripts in documents and applications

   2. Possible surprises when using Ness

   3. Ness menu options

   4. Standalone execution

   5. Message-line execution

   6. Known Bugs

   7. Authors


\smaller{CAVEAT: This manual describes an early version of the Ness language 
and system.  You are invited to contribute suggestions for change to the 
author (wjh+@andrew.cmu.edu) or the bboard (andy.ness).  But please realize 
that your suggestions and those of others may evolve the language enough to 
force you to revise or abandon programs written to this document.

}}\bold{
}\formatnote{.bp}


        Copyright IBM Corporation 1988, 1989 - All Rights Reserved        


\smaller{Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided that 
the above copyright notice appear in all copies and that both that copyright 
notice and this permission notice appear in supporting documentation, and that 
the name of IBM not be used in advertising or publicity pertaining to 
distribution of the software without specific, written prior permission.


\smaller{IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL IBM 
BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION 
OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

}
/* $Header: /afs/andrew.cmu.edu/usr13/wjh/h/atk/ness/doc/RCS/nessuser.d,v 1.1 
89/09/13 10:38:05 wjh Exp Locker: wjh $ */

/* $ACIS:$ */

/* $Source: /afs/andrew.cmu.edu/itc/sm/releases/X.V11R5/ftp/src/atk/ness/doc/RCS/nessuser.d,v $ */

/* $Log: nessuser.d,v $
Revision 1.3  1990/09/16  21:19:54  wjh
see atk/ness/objects/changes.sept.90
 Revision 1.2  89/12/12  15:04:37  ghoti sync with MIT 
tape

Revision 1.2  89/12/07  12:15:46  xguest added author's name  Revision 1.1 
 89/12/07  11:51:10  xguest Initial revision

Revision 1.1  89/10/11  09:27:19  wjh Initial revision  */

}\formatnote{.bp}


\bold{Guide to Ness manuals}


The following manuals describe various aspects of Ness and its use.  If you 
are interacting with an environment developed with Ness--whether reading a 
document or running an application or Ness standalone program, you can get 
help in this manual.  If you want to write Ness programs you can start with 
the Tutorial and then read the Language Reference Manual, the Function 
Reference Manual, and the Author's Manual.  The parenthesized names show the 
name of the file in /usr/andrew/doc/ness.  


Note:  See the \bold{Ness Language Reference Manual} for a list of the changes 
to the language for December, 1989.

\description{
}\bold{Ness User's Manual}  (nessuser.doc)

\leftindent{Everything you need to know to use Ness programs or deal with 
documents and applications that contain Ness scripts.  See other documents if 
you want to write scripts.}


\bold{Ness: A Short Tutorial}   (nesstut.doc)

\leftindent{An instructional introduction to the language;  includes a 
description of the demonstration programs in /usr/andrew/lib/ness/demos.}


\bold{Ness Author's Reference Manual}  (nessauth.doc)

\leftindent{Description of how to use Ness to enhance documents, build 
applications, or run stand-alone programs.

}
\bold{Ness Language Reference Manual}  (nessman.doc)

\leftindent{Full description of the Ness language itself; the forms of 
programs, statements, expressions, and so on.

}
\bold{Ness Function Reference Manual}  (nessfunc.doc)

\leftindent{Describes the set of functions that can be called from Ness, 
including those in /usr/andrew/lib/ness/.

}
\bold{Ness Hacker's Guide}  (nesshack.doc)

\leftindent{Describes various advanced topics:  how to call methods and access 
variables in objects;  writing insets so Ness scripts can best make use of 
them;  using Ness objects directly from other applications;  extending the 
keyboard with Ness functions.

}

\formatnote{.bp}


This manual describes how to use applications and documents written with Ness. 
 It will explain what to expect and what to do.  Ness \italic{programs} reside 
in their own files and process other files.  Ness \italic{scripts} reside 
within a document or application and extend and influence the behavior of 
other insets.  In addition, you can execute Ness statements by typing them 
into the message line.



\section{1. Ness scripts in documents and applications}


When you see a Ness inset in a document or application it will be appear to be 
an inset having a scroll bar and containing text.  The text begins: 
 "\bold{Ness} - This inset is a Ness script."  This script will do nothing 
until you "empower" it; this process compiles the script and attaches it to 
whatever objects it modifies so they do something other than their normal 
behavior.


Somewhere around the script the author should have put some explanation of 
what this script will do when empowered.  Read it and decide if you want that 
behavior or would prefer to leave the script inactive.  Beware:  since Ness is 
a programming language, a Ness program can do anything.  When you execute any 
program--whether written in C, cT, Ness, Hypercard, or whatever--its author 
may have included instructions to delete your files or send them to 
unauthorized readers.  Thus you should exercise care when using programs 
provided by others, no matter what language the program is written in.  This 
problem is somewhat trickier with Ness because programs can come in documents 
as well as being executed from a typescript;  however, the problem is somewhat 
easier with Ness because Ness provides a tool to aid you in reviewing a 
program to see if it has any harmful statements.


The text at the beginning within a Ness inset is a standard piece of text that 
wraps all Ness scripts.  It begins with a warning of the dangers of executing 
programs from strangers and continues with the text of the script as written 
by the author.   After the script, the standard wrapper text continues by 
describing your options for choosing to ignore, analyze, or empower the 
program.  You select these options by clicking the buttons at the end of the 
script.  Your options are:


\indent{\bold{Ignore the Ness script}


Simply do nothing further with the Ness inset and the program inside it will 
not execute; it will not even be compiled


\begindata{raster,270054160}
2 0 68266 68266 0 0 297 21
bits 270054160 297 21
zx |
7fZVg |
40zu01g |
40zu01g |
40j7eje0h18zh	01g |
40je7i0180h18	o06g30j0ck01g |
40jc3i0180h18	o06g30j0ck01g |
40je00e1e3703	c70d80f8f1b83a	3c6c70c63c03cf	9e7cf1b70f1b9f
 3cj01g |
40j781f333b81	8d8f81b999dc6e	767cd8c6760766	3331d9dd!9dcc
 76j01g |
40j1e33033181	98cc0318198cc6	66618cc660!06	0331"9998cc60
 j01g |
40j07301f3181	98cc0318f98cc6	7e618cc63c03c6	1f31f9999f98cc
 3cj01g |
40j0330333181	98cc0319998cc6	60618cc60ege6	333181999818cc
 0ej01g |
40jc3!33318198	cc0319998cc660	618cc606g6633	3181999818cc06
 j01g |
40jee1f3f3181	8d8c01b9f98c6e	7660d8ee760766	bf35d9999d98cd
 76j01g |
40j7c0e1db181	870cgd8ed8c3e	3c6070763c03c3	1d98f1998f18c6
 3cj01g |
40u06y01g |
40ucey01g |
40u7cy01g |
40zu01g |
7fZVg |
zx |
\enddata{raster, 270054160}
\view{rasterview,270054160,6,0,0}

This button compiles the script and generates an error message for each 
potentially dangerous statement.  You can then review the possible problems by 
choosing the NextDanger option from the Ness menu.  Understand, however, that 
the compiler has a quite paranoic idea of what is dangerous.  Any statement 
form or function call is flagged if any instance of this form or function 
might conceivably modify either some of the text currently being edited or 
some one or more of your files.  Thus the flag does not really mean that this 
particular instance of the statement form or function call will actually be 
damaging.


\begindata{raster,270140380}
2 0 68266 68266 0 0 297 20
bits 270140380 297 20
zx |
7fZVg |
40zu01g |
40zu01g |
40i30g0180k06	h03m0cc0g30j06	i01g |
40i30g3180k06	h03g03k0ccc06	30j06g30g01g |
40i78g3180k06	h03g03k!0c0630	l30g01g |
40i48637db838	6c1b!703e3cg03	01e7c1b70fgf0	7cdf0fb70fgf0
 71b66c7cg01g |
40icc6331dc6c	7c1d!d86e76g!03	b301dd9d81d8dc	cc063b9d81d8f9
 f67630g01g |
40icc63318cc6	6019998cc666g	!033301!998199	8ccc063199!81
 99866330g01g |
40h018663318c	c66019998cc67e	0f8303f301999f	81f98ccc06319f
 80f181866330g	01g |
40h01fe63318c	c66019998cc660	g"030199980181	8ccc063198g39
 81866330g01g |
40h018663318c	c66019998cc660	g"030199980181	8ccc063198g19
 99866330g01g |
40h!0377358c6c	601998d86e76g	!03b341999d81	d8dccd06b19d81
 d8f9867634g01	g |
40h!033b198c38	60199870363cg	03f9e181998fg	f06cc603318fg
 f071867c18g01	g |
40zr60h01g |
40zr60h01g |
40zr60h01g |
40zu01g |
7fZVg |
\enddata{raster, 270140380}
\view{rasterview,270140380,7,0,0}

The warning notice is removed from the Ness script and the text of the script 
is made read/write.  Modifications will not affect the script stored in the 
file unless you save the file.


\begindata{raster,270399016}
2 0 68266 68266 0 0 297 21
bits 270399016 297 21
zx |
7fZVg |
40zu01g |
40zu01g |
43f8n30k0co01	c0180cj30g01g |
43o!30h03018c	o!03180cj3001	81g |
43o!30h03018c	o!0318l0181g |
4301b71b038ccc	f1b0g307db631	e7c3edc3c03c1c	319b1c3c01c787
 db8c7807838db3	63e1g |
4301dd9d86cccd	d9f0g3031f633	b3018ee7607636	319f3e76036303
 1dccec0ec7cfb3	b181g |
43f99998cc6ccd	9980g30318633	03018c66!6063	3198!66063303
 18ccc0!0ccc33	1981g |
43019998cc66d9	f980f830318631	e3018c67e03c63	3198607e063303
 18cc78078c0c33	1981g |
43019998cc66d9	8180g30318630	73018c66g0e63	3198!60063303
 18cc1c01cc0c33	1981g |
43019998cc6331	8180g30318630	33018c66g0663	31986660063303
 18cc0cg!cc3319	81g |
4301999d86c331	d980g30358773	b341ac67607636	3b983e76036303
 58ccec0ec7cc33	b1a1g |
43f9999f038330	f180g301983b1	e180cc63c03c1c	1d981c3c01c301
 98cc7807838c33	e0c1g |
40h18zp03g01g |
40h18zp03g01g |
40h18zp03g01g |
40zu01g |
7fZVg |
zx |
\enddata{raster, 270399016}
\view{rasterview,270399016,8,0,0}

When you click on this button, the script is compiled and any buttons or other 
insets it controls will begin operating under direction of the script.  When 
the compilation is completed, the word "Done" will appear in the message line. 
 If there is a compilation error, the error will appear in the message line 
and the script will not be activated.

}

If you want a simpler interface to empowering Ness scripts, you can put in 
your preferences file the option:


\leftindent{*.NessUseDialogBoxInsteadOfWarning: on}


For a description of this option, see the Ness Hacker's Guide.


Sometimes when you want to use a script or program, the author will have used 
some functions written in Ness and installed in a private library.  If you 
trust the author and want to use the program, you will have to add this 
library to your "NessPath" preference in ~/preferences.  The element of trust 
goes beyond this program because as long as the other directory is in the 
Nesspath, the owner of that directory can conceivably override functions so 
that existing programs will work differently.  (This is exactly the same as 
listing a directory in your CLASSPATH.)  The form of the NessPath preference 
is


\leftindent{<program-name>.NessPath:/usr/andrew/lib/ness:<other-directory-name>\
}


The <program-name> can be simply an asterisk (*) to have the path apply to all 
programs.  The list after the colon can be any colon-separated list of 
directory names.  Directories earlier in the list will override later entries 
in the list, so the example shows the standard library first in order to 
prevent other directories from overriding standard Ness-defined functions like 
sort_records().



\section{2. Possible surprises when using Ness}


Surprises may occur when using Ness.  In this section I will do my best to 
prepare you for them.  (But, sigh, when they actually occur you will have 
forgotten you read this.)


The first time any Ness is compiled in any given editor, it will take a 
longish time because it needs to fetch various pieces of the program.  If the 
script utilizes calls on methods or instance variables for objects, an even 
longer time will be taken while the descriptions of the various relevant 
classes are parsed (from the .ch files).  


Some unreclaimed resources are utilized for each compilation.  If you do 
numerous lengthy compiles, Ness will fail.  You can start another editor on 
the same document and continue.


Sometimes an incorrect Ness program will get in an endless loop.  If this is a 
script in a document or application, you can terminate the execution by typing 
\bold{control-G}.  This will cause an execution-time error; see the next item.


If any error occurs during execution, the script is disabled.  This means that 
any objects which were formerly under control of the script now revert to 
their normal behavior.  You cannot restart the script until you have modifed 
the text of the Ness script and recompiled.  (You may have to go into author 
mode to modify the script.  The simplest and safest modification is simply to 
type space and backspace.)


Ness scripts can utilize library functions written in Ness and these may 
occassionally have compilation errors.  These are exposed to you by abruptly 
bringing up a window with the title \bold{NessLibrary} and a view of the 
offending error.  Unless you are the author, this may not be useful, so you 
can just type control-X-control-D in the window and it will go away.  If 
possible you should contact the author of the script and mention that the 
problem occurred.


Whenever an error occurs in executing a Ness script, the offending portion of 
the script is highlighted.  If possible you should make a note of which 
portion this is and send it along with the error message from the message line 
to the script author.  You can make a copy of the piece of script and mark the 
highlighted portion with >> and << .  It may also be useful to send the number 
of the line having the error; first record the error message from the message 
line and then type ESC-shift-N to get the line number.  Send error message, 
portion of script and line number to the script author together with a 
description as best you can remember of what you did just before the error 
occurred.  If this is an embedded script, the author can be found by selecting 
the "Show Origin" option from the Ness menu card.


If the script author has made a mistake, it is possible that there  is a "bus 
error" or "segmentation fault" during Ness execution.  If so, Ness indicates 
in the message line:


	! ! !   Disasterous Ness error in this function.   Quit soon.   !!!!!!!!!!


and continues execution.  In most cases it is actually safe to continue 
editting after this message has occurred because the error itself did nothing 
harmful.  You should not, however, continue to use the Ness script until you 
have checked with the author of the script.  



\section{3. Ness menu options}


When you click in a Ness inset, it posts a menu card entitled "Ness."  The 
following options will appear on the card when they are reasonable to select:


\bold{Next Error}


Appears after a compilation has detected an error.  Each time you select this 
option, the next error is highlighted and a brief description of the error 
appears in the message line.  After showing the last error, the next click 
gives the message "No more errors;"  if you again select the option, the 
selection goes back to the first error and the cycle begins anew.  (Key 
binding: control-X-control-N)


\bold{Next Danger}


This option is exactly the same as "Next Error,"  but appears after choosing 
the "Scan for danger" option.  It cycles through all statements which are 
potentially dangerous.  (Key binding: control-X-control-N)


\bold{Show Origin}


Always available.  Displays in the message line the date of the last 
legitimate modification of this script and the name user.  (This information 
can easily be forged, so it should be relied on only as a tool for determining 
which version of a script you may happen to have.)  


\bold{Scan for danger}


Always available if you have selected Author mode.  This option initiates a 
compilation in the special mode which highlights all potentially dangersous 
statements.  After the compilation is complete, you can select the "Next 
Danger" option repeatedly to see all the potentially dangerous statements.


\bold{Empower-compile}


Available if you have selected the Author mode and have not compiled the 
script since it was last changed.  Initiates a compilation.  After the 
compilation, any buttons or other insets extended by the script are active and 
will call on operations in the script.


\bold{Do main()}


If a script has a function with the name "main", this option will call it.  If 
the script has yet to be compiled, this option will first Empower-compile it. 
  (Keybinding: control-X-control-E.  The key sequence 
control-U-control-X-control-E will first prompt for the name of a function to 
execute.)


\bold{Add warning}


If the text of the Ness inset is read-write (author mode) this option appears. 
 When selected it makes the text read-only and wraps around it the warning 
message that appears to users by default.  Authors may wish to use this option 
to see what the script will look like to users.


\bold{Author mode}


After the warning message has been wrapped around the script, it is read-only 
and the "Author mode" option appears in the menu.  If selected, this option 
removes the warning message wrapper and makes the text of the script 
read-write.



\section{4. Standalone execution}


The command "nessrun" (in /usr/andrew/bin) compiles a Ness program from a file 
and executes it by looking for a function named "main" and calling it.  The 
text on the command line after the name of the Ness file is concatenated 
together and passed as the single argument to main().  


The full format of the nessrun command is


	nessrun  [optional switches]   \italic{nessProgramName}.n   \italic{arguments 
to ness program}


By convention, filenames for Ness programs end in ".n".


\{\{Future: If not an absolute pathname, the ness-program-name is sought in 
the directories listed in the NessPath preference.\}\}


The two possible switches are -d and -f.  A "-d" switch before the 
nessProgramName will cause nessrun to print the generated object code after 
compilation.  The "-f" switch causes the program to fork after compilation and 
before execution.  This is most useful when the program uses launchApplication 
to start an interactive program.


One example of a Ness program is /usr/andrew/lib/ness/wc.n.  When invoked for 
stand-alone execution, it counts the words in a file and prints the count. 
 For instance:


\leftindent{% \bold{nessrun  /usr/andrew/lib/ness/wc.n 
 /usr/andrew/doc/ness/nessuser.doc}

Compile okay.  Elapsed time is 4836 msec.

The text of nessuser.doc has 2757 words

Execution okay.  Elapsed time is 9352 msec.

}

A Ness script may begin with 


	#!/usr/andrew/bin/nessrun


If the file it is in is made executable with something like


	chmod +x filename.n


then you can execute the Ness program just by typing its name to the shell.


The security considerations described in Section 1 do not apply to execution 
with nessrun.  If you are executing a Ness script you got from someone else, 
the situation is exactly the same as if you are executing a program from 
someone else.




\section{5. Message-line execution}


In message-line execution mode, Ness prompts for a statement sequence and 
executes it.  To get this behavior, add the following to your 
 \concat{~}/.atkinit,  \concat{~}/.ezinit, or other  \concat{~}/.XXXinit file:


\leftindent{addkey ness-dostmt  \\e\\e  view}


Once this is in effect (that is, for all subsequently started editors), 
ESC-ESC will prompt you with "Ness:";  respond by typing one or more Ness 
statements.  When you hit return, the statement(s) are executed.


This is one way to invoke arbitrary proctable functions.  For instance, select 
some text in a document, type ESC-ESC, and enter the statement


	textview_uppercase_word()


All letters in the selected text will become uppercase.  The proctable 
functions are the ones which can be bound to keys with the addkey and addmenu 
options of the .XXXinit file; however, in Ness they are spelled with 
underlines instead of minus signs.


With ESC-ESC you can also call functions defined in the Ness library, 
/usr/andrew/lib/ness/.  For instance, wc.n in that library includes this 
function

\smaller{
\example{function wc_showcount() \leftindent{

TellUser(textimage(wc_countwords(\leftindent{\leftindent{

currentselection(currentinset))));}}}

end function;}

}
To execute wc_showcount(), select some text, type ESC-ESC, and give the 
command "wc_showcount()".


\{\{Future: In addition to ESC-ESC, a proctable entry point is provided for 
the binding of ESC-x.  This prompts for a function name--with completion--and 
then prompts interactively for the arguments.\}\}



\heading{6. Known Bugs}


There may be up to three copies of a library routine in memory: one loaded 
with ness-load, one loaded as a library routine, and one being edited.  There 
is no checking so that changes in one are reflected in another.  


The order of compilation of library routines and the main routine is crucial. 
 It is safest to save the files and start a new Ness.


Dokeys(x, string) will cause an error if string contains a sequence which is 
the operand of an on-keys.


When control-G or any other run-time error occurs, execution is stymied until 
the script is modified.  It ought to be possible to continue execution so 
other portions of the script can be used.



\heading{7. Authors}


The initial language design and implementation was done by Wilfred J. Hansen. 
 Definition of the string subexpression notation was done by Hansen at the 
Computing Science Department, University of Glasgow, in conjunction with Bruce 
and Judy Sherwood and David Andersen who remained at Carnegie Mellon and 
implemented a version of the string algebra in the cT authoring system.


Runtime support of cels and arbiters was developed by Tom Neuendorfer, as 
described in the ADEW documents.


I am grateful for comments received from the following.  Most comments have 
resulted in some (perhaps subtle, perhaps not expected) change to the 
language.


\indent{Tom Neuendorffer, William Lott, Miles Bader, Paul Crumley, Zalman 
Stern, Ayami Ogura, Judy Jackson, Ted Anderson, Bob Glickstein, Michael 
Portuesi, Adam Stoller, Nathaniel Borenstein, Jenny Robertson, Chris Neuwirth, 
Chris Thyberg, George Baggot, Brad Myers, Richard Chung}



\enddata{text,270270256}
