## ###################################################################### ##
##         Copyright IBM Corporation 1988,1991 - All Rights Reserved      ##
##        For full copyright information see:'andrew/config/COPYRITE'     ##
## ###################################################################### ##

# awk script to list all modules and entry points from a library which are
# needed (via transitive closure) for a given list of basic entry points

# the input to this awk script should be generated by:  nm -go /lib/libc.a | tr : " "

# data structures used here:
#
#  definer[entry-point-name] = module-name
#  epcount = # entry-point-name's seen so far
#  ep[k] = k'th entry-point-name
#  refcount[entry-point-name] = number of references by wanted modules
#  referrer[entry-point-name.k] = k'th module-name with an undefined reference to this entry-point-name
#  want[module-name] = "Y" if this module wanted

# search output of nm and set up definers and referrers

/ [ATDBCEGSR] / {
    if (definer[$5] == "") {
	definer[ep[epcount++] = $5] = $2;
	allocation[$5] = "0x" $3;
    }
}

/ U / {
    referrer[$4 "." refcount[$4]++] = $2;
}

# postprocessing

END {


# Specify which entry points we MUST include
# If the module contains static data to be shared between
# instantiations ( e.g. malloc/free arena ptrs ) IT MUST BE HERE
# Also, if the symbol is gp relative in any object in the program
# ( our shared library archives contain objects with .sbss & .sdata ),
# it must be here or it can't be referenced
#
# To compare to a System V shared library: This is the IMPORT list!
#
# We DON'T WANT transitive closure.

# Edit this list to add entry points.

## General purpose stuff for all modules
  want[definer["environ"]] = "Y";
  want[definer["malloc"]] = "Y";
  want[definer["free"]] = "Y";
  want[definer["calloc"]] = "Y";
  want[definer["realloc"]] = "Y";
  want[definer["cfree"]] = "Y";
  want[definer["errno"]] = "Y";
  want[definer["_ctype"]] = "Y";
  want[definer["_iob"]] = "Y";
  want[definer["_curbrk"]] = "Y";
  want[definer["_minbrk"]] = "Y";
#  BEGIN ADDED SGI
  want[definer["sproc"]] = "Y";
  want[definer["_sproced"]] = "Y";
  want[definer["_sprocmonstart"]] = "Y";
  want[definer["_us_rsthread_stdio"]] = "Y";
#  END ADDED SGI
## Stuff for the class system
  want[definer["class_RoutineStruct"]] = "Y";
  want[definer["class_Error"]] = "Y";
  want[definer["ProgramName"]] = "Y";
#  want[definer["class_Header"]] = "Y";
  want[definer["class_NewObject"]] = "Y";
  want[definer["class_Load"]] = "Y";
  want[definer["class_IsLoaded"]] = "Y";
  want[definer["class_Lookup"]] = "Y";
  want[definer["class_IsType"]] = "Y";
  want[definer["class_IsTypeByName"]] = "Y";
  want[definer["class_EnterInfo"]] = "Y";
  want[definer["class_SetClassPath"]] = "Y";
  want[definer["class_PrependClassPath"]] = "Y";
  want[definer["class_GetEText"]] = "Y";

#
# To compare to a System V shared library: This is the IMPORT list!
# We DON'T WANT transitive closure.
#
## now take transitive closure of wanted modules
#
#    for (needmore = "Y"; needmore == "Y"; needmore = "N") {
#	for ( i = 0; i < epcount; i++) {
#	    if (want[definer[ep[i]]] != "Y") {
#		want[definer[ep[i]]] = "N";
#		for ( j = 0; j < refcount[ep[i]]; j++ ) {
#		    if (want[referrer[ep[i] "." j]] == "Y") {
#			want[definer[ep[i]]] = "Y";
#			needmore = "Y";
#			break;
#		    }
#		}
#	    }
#	}
#    }

# write out all wanted module name and entry points

    for ( i = 0 ; i < epcount ; i++)
	if (want[definer[ep[i]]] == "Y")
	    printf "%s %s %d\n", definer[ep[i]], ep[i], allocation[ep[i]];
}
