.TH ImportCmd 3U "10 August 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
ImportCmd \- import a graphical component
.SH SYNOPSIS
.B #include <Unidraw/Commands/import.h>
.SH DESCRIPTION
ImportCmd imports a graphical image from a file into the drawing being
edited.  ImportCmd supports the following file formats: TIFF;
PostScript generated by pgmtops, ppmtops, and idraw; X bitmap format;
and Unidraw format.
.SH PUBLIC OPERATIONS
.TP
.B "ImportCmd(ControlInfo*, FileChooser* = nil)"
.ns
.TP
.B "ImportCmd(Editor* = nil, FileChooser* = nil)"
Create a new ImportCmd instance, optionally supplying the FileChooser
that will prompt the user to specify the file to import.  After the
user specifies the file, ImportCmd reads it, creates an appropriate
graphical component, and pastes it into the component being edited in
the enclosing editor.
.TP
.B "static GraphicComp* Import(const char*)"
.ns
.TP
.B "static GraphicComp* TIFF_Image(const char*)"
.ns
.TP
.B "static GraphicComp* PGM_Image(const char*)"
.ns
.TP
.B "static GraphicComp* PPM_Image(const char*)"
.ns
.TP
.B "static GraphicComp* XBitmap_Image(const char*)"
Operations for reading data from various file formats and creating an
appropriate graphical component.  TIFF_Image, PGM_Image, PPM_Image,
and XBitmap_Image assume that the specified file is in the
corresponding format.  Import is more general: it determines the
format from the file and then calls one of the other functions.
.SH PROTECTED OPERATIONS
.TP
.B "void Init(FileChooser*)"
Specify the FileChooser instance (stored in the \fI_dialog\fP
protected member) explicitly.  This operation does \fInot\fP delete
the existing instance, if any.
.TP
.B "GraphicComp* PostDialog()"
Post the FileChooser and return the graphical component created from
the user-specified file, if any.
.SH SEE ALSO
Catalog(3U), Command(3U), FileChooser(3I), GraphicComp(3U), bitmap(1),
idraw(1), pgmtops(1), ppmtops(1)
