.\" $XConsortium: ParseCT.man,v 1.1 91/10/08 15:11:29 rws Exp $
.\" Copyright 1990 by OMRON Corp.  All Rights Reserved.
.TH _XParseISOEncoding 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
_XParseISOEncoding \- parse compound text encoding(ISO 2022)
.SH SYNOPSIS
.B Status _XParseISOEncoding\f2(ct_str, ct_bytes, scanned_bytes, isoinfo)
.br
.B char \f2*ct_str\f3;
.br
.B int \f2ct_bytes\f3;
.br
.B int \f2*scanned_bytes\f3;
.br
.B ISOStateInfo \f2*isoinfo\f3;
.br
.SH ARGUMENTS
.IP \fIct_str\fP 1i 
In: CT string.
.br
.IP \fIct_bytes\fP 1i 
In: length of CT strings, counted in bytes.
.br
.IP \fIscanned_bytes\fP 1i 
Out: Number of CT bytes has scanned.
.br
.IP \fIisoinfo\fP 1i
Out: the information about CT encoding.
.br
.SH DESCRIPTION
The
.B _XParseISOEncoding 
parses escape control sequence of compound text(ISO 2022), then
return the following information about it to isoinfo:
.IP "" 2
a. number of code bytes.
.IP
b. mininum & maximun of encoding. (0x21, 0x7E) for 94-GL; (0xA0, 0xFF)
for 96-GR; (0xA1, 0xFE) for 94-GR.
.PP
The data type of isoinfo is defined:
 typedef struct {
     int              code_bytes;
     unsigned char    code_min, code_max;
 } ISOStateInfo;
.PP
All error status are defined to be less than zero, i.e.:
.IP "" 2
#define Success          0
.IP
#define BadBuffer       -1
.IP
#define BadTerminate    -2
.IP
#define BadEncoding     -3
.PP
The ct_str points to the escape sequence of string, the ct_bytes
is the length of ct_str in bytes.  The function will also return
the scanned number of bytes of ct_str to the variable scanned_bytes.
.PP
The CT encoding non-registered by X is treated as BadEncoding.
.SH RETURNED VALUE
The
.B _XParseISOEncoding will return the following values:
.TP
.B Success
successful parsing.
.TP
.B BadTerminate
CT string was terminated uncompletely.
.TP
.B BadEncoding
wrong escape sequence of the CT encoding.
.SH SEE ALSO
Refer to "CT and WC" for CT definition.
