#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Ximd/IMdkit.h>
#include <X11/Ximd/XimpData.h>

#define DEFAULT_IMNAME "sampleIM"
#define DEFAULT_LOCALE "ja_JP"

static Bool conv_state = False;
static unsigned long ximp_type = 0;

static XIMStyle Styles[] = {
    XIMPreeditPosition|XIMStatusArea,
    XIMPreeditPosition|XIMStatusNothing,
    XIMPreeditArea|XIMStatusArea,
    XIMPreeditNothing|XIMStatusNothing,
    0
};

static XIMTriggerKey OnKeys[] = {
    {XK_space, ShiftMask, ShiftMask},
    {XK_space, ControlMask, ControlMask},
    {0L, 0L, 0L}
};

static XIMTriggerKey OffKeys[] = {
    {XK_space, ShiftMask, ShiftMask},
    {XK_space, ControlMask, ControlMask},
    {0L, 0L, 0L}
};

static void _test_commit(
#if NeedFunctionPrototypes
	XIMS, long, char*
#endif
);

MyGetICValuesHandler(ims, call_data)
XIMS ims;
XIMPICValuesStruct *call_data;
{
    GetIC(call_data);
    return True;
}

MySetICValuesHandler(ims, call_data)
XIMS ims;
XIMPICValuesStruct *call_data;
{
    SetIC(call_data);
    return True;
}

#define ROOM 256

/***********************************************
 *                                             *
 * MyResetEventHandler:                        *
 * So far, we have no drawing functions and no *
 * engines for sampleIM, so we must have a     *
 * 'fake' function to emulate the reset        *
 * operation.                                  *
 *                                             *
 ***********************************************/

MyResetEventHandler(ims, call_data)
XIMS ims;
XIMPResetStruct *call_data;
{
#ifdef DEBUG
    int length;
    register int i;
#endif
    unsigned char	text[ROOM];
    char  *reset_str = "ꥻåȥڥ졼η̤ʸǤ";
    memset(&text, 0, ROOM);
    text[0] = 0x1b; /* Esc */
    strcat(text, "$)B"); /* "Esc $ ) B" is designator of JISX0208-1983 */
    strcat(text, reset_str); /* "Esc $ ) B" is designator of JISX0208-1983 */
#ifdef DEBUG
    length = strlen(text);
    for(i = 0; i < length; i++)
	printf(" : %x ", text[i]);
    printf("\n");
    fflush(NULL);
#endif
    call_data->ctext = (char *)&text;
}

MyCreateICHandler(ims, call_data)
XIMS ims;
XIMPICValuesStruct *call_data;
{
    ximp_type = call_data->ximp_type_mask;
    CreateIC(call_data);
    return True;
}

static void
_test_commit(XIMS xims, long icid, char *commit_str)
{
    Display	*display = ((XIMPCore)xims->protocol)->display;
    unsigned char	text[ROOM];
    XIMPCommitStringStruct	call_data;
#ifdef DEBUG
    int length;
    register int i;
#endif

    memset(&text, 0, ROOM);
    text[0] = 0x1b; /* Esc */
    strcat(text, "$)B"); /* "Esc $ ) B" is designator of JISX0208-1983 */
    strcat(text, commit_str);
#ifdef DEBUG
    length = strlen(text);
    for(i = 0; i < length; i++)
	printf(" : %x ", text[i]);
    printf("\n");
    fflush(NULL);
#endif
    call_data.icid = icid;
    call_data.ctext = (char *)&text;
    IMCommitString(xims, (XPointer)&call_data);
}


/***********************************************
 *                                             *
 * MyForwardEventHandler:                      *
 * So far, we have no engines for sampleIM, so *
 * we must have a 'fake' function to emulate   *
 * the commit string from IMServer. It is done *
 * by '_test_commit()' function.               *
 *                                             *
 ***********************************************/

static Bool
isRegisterd(Display *display, unsigned int keycode, unsigned int state)
{
    KeySym	ksym;
    register int	i;
    XIMTriggerKey	*pointer = (conv_state ? &OffKeys[0] : &OnKeys[0]);
    ksym = XKeycodeToKeysym(display, keycode, 0);

    for(; pointer->keysym; pointer++) {
	if((pointer->keysym == ksym) &&
	   ((state & pointer->modifier_mask) == pointer->modifier)) {
		return True;
	}
    }
    return False;
}

MyForwardEventHandler(ims, call_data)
XIMS ims;
XIMPKeyPressStruct *call_data;
{
    XIMPCore	core = (XIMPCore)ims->protocol;
    Display	*display = core->display;
    KeyCode	kcode = XKeysymToKeycode(display, XK_k);
    char	*commit_str = "ϳʸȤ IM С줿ΤǤ";

    if(isRegisterd(display, call_data->keycode, call_data->state)) {
	conv_state = (conv_state ? False : True);
	printf("conversion state is %s\n", (conv_state ? "True" : "False"));
	IMForwardEvent(ims, call_data);
	fflush(NULL);
	return True;
    }
    switch(core->cur_type) {
      case XIMP_FE_TYPE1:
      default:
	if((call_data->keycode == kcode) &&
	   (call_data->state == ControlMask)) {
	    _test_commit(ims, call_data->icid, commit_str);
	} else {
	    printf("Keycode is %d IMServer consumed\n", call_data->keycode);
	    fflush(NULL);
	}
	break;
      case XIMP_BE_TYPE2:
	if(conv_state) {
	    if((call_data->keycode == kcode) &&
	       (call_data->state == ControlMask)) {
		_test_commit(ims, call_data->icid, commit_str);
	    } else {
		printf("Keycode is %d IMServer consumed\n", call_data->keycode);
		fflush(NULL);
	    }
	} else {
	    printf("Keycode is %d Send back to client\n", call_data->keycode);
	    fflush(NULL);
	    IMForwardEvent(ims, call_data);
	}
	break;
    }

    return True;
}

MyExtensionHandler(ims, call_data)
XIMS ims;
IMPProtocol *call_data;
{
    Display	*display = ((XIMPCore)ims->protocol)->display;
    XIMPExtensionStruct *extension =
		(XIMPExtensionStruct*)&(call_data->extension);
    Atom win_a = XInternAtom(display,
				    "_XIMP_EXT_XIMP_STATUSWINDOW", False);
    Atom bf_a = XInternAtom(display,
				    "_XIMP_EXT_XIMP_BACK_FRONT", False);
    Atom conv_a = XInternAtom(display,
				    "_XIMP_EXT_XIMP_CONVERSION", False);
    if(extension->ext_atom == win_a) {
    } else if(extension->ext_atom == bf_a) {
    } else if(extension->ext_atom == conv_a) {
	if(extension->data1) { /* Conversion set */
	    conv_state = (Bool)extension->data2;
	} else { /* Conversion get */
	    extension->data1 = conv_state;
	    extension->data2 = (long)(-1); /* Ignored */
	}
    }
}

MyProtoHandler(ims, call_data)
XIMS ims;
IMPProtocol *call_data;
{
    switch (call_data->type) {
      case XIMP_CREATE4:
	MyCreateICHandler(ims, call_data);
	break;
      case XIMP_REG_KEY_PRESSED4:
      case XIMP_BEGIN3:
	conv_state = True;
	break;
      case XIMP_DESTROY4:
	break;
      case XIMP_SETVALUE4:
	MySetICValuesHandler(ims, call_data);
	break;
      case XIMP_GETVALUE4:
	MyGetICValuesHandler(ims, call_data);
	break;
      case XIMP_KEYPRESS4:
      case XIMP_KEYPRESS3:
	MyForwardEventHandler(ims, call_data);
	break;
      case XIMP_RESET4:
	MyResetEventHandler(ims, call_data);
	break;
      case XIMP_SETFOCUS4:
      case XIMP_UNSETFOCUS4:
	break;
      case XIMP_CREATE3:
	MyCreateICHandler(ims, call_data);
	break;
      case XIMP_DESTROY3:
	break;
      case XIMP_SETVALUE3:
	MySetICValuesHandler(ims, call_data);
	break;
      case XIMP_GETVALUE3:
	MyGetICValuesHandler(ims, call_data);
	break;
      case XIMP_RESET3:
	MyResetEventHandler(ims, call_data);
	break;
      case XIMP_SETFOCUS3:
      case XIMP_UNSETFOCUS3:
	break;
      case XIMP_EXTENSION4:
      case XIMP_EXTENSION3:
	MyExtensionHandler(ims, call_data);
	break;
    }
}

MyXEventHandler(ims, event)
XIMS ims;
XEvent *event;
{
    switch (event->type) {
      case DestroyNotify:
	break;
      case KeyPress:
	break;
      default:
	break;
    }
}

unsigned long	imptype[] = {
    XIMP_BE_TYPE1,
    XIMP_FE_TYPE1,
    XIMP_BE_TYPE2,
    XIMP_FE_TYPE2,
    XIMP_FE_TYPE3,
    XIMP_SYNC_BE_TYPE1,
    XIMP_SYNC_BE_TYPE2,
};

char *ximp_version = NULL;

main(argc, argv)
int argc;
char **argv;
{
    Display *dpy = XOpenDisplay("");
    char *imname = NULL;
    XIMS ims;
    XIMStyles *input_styles, *styles2;
    XIMTriggerKeys *on_keys, *off_keys, *trigger2;
    XIMPTypeRec ximp_type, *ximp_type_ret;
    Window im_window = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy),
					    0, 0, 1, 1, 1, 0, 0);
    register int i;
    Bool use_trigger = False;
    Bool use_tcp = False;
    long filter_mask = KeyPressMask;
    char *transport;
    XVaNestedList *nest_list;
    XVaNestedList *ext_list;
    long back_front = 0;

    ximp_type.types = &imptype[0];
    ximp_type.num_of_types = sizeof(imptype)/ sizeof(imptype[0]);

    for (i = 1; i < argc; i++) {
	if (!strcmp(argv[i], "-name")) {
	    imname = argv[++i];
	} else if (!strcmp(argv[i], "-dynamic")) {
	    use_trigger = True;
	} else if (!strcmp(argv[i], "-tcp")) {
	    use_tcp = True;
	} else if (!strcmp(argv[i], "-kl")) {
	    filter_mask = (KeyPressMask|KeyReleaseMask);
	} else if (!strcmp(argv[i], "-new")) {
	    ximp_version = "4.0";
	}
    }

    if (!imname) imname = DEFAULT_IMNAME;

    if (!ximp_version) ximp_version = "3.5";

    if ((input_styles = (XIMStyles *)malloc(sizeof(XIMStyles))) == NULL) {
	fprintf(stderr, "Cannot allocate\n");
	exit(1);
    }
    input_styles->count_styles = sizeof(Styles)/sizeof(XIMStyle) - 1;
    input_styles->supported_styles = Styles;

    if ((on_keys = (XIMTriggerKeys *)
	 malloc(sizeof(XIMTriggerKeys))) == NULL) {
	fprintf(stderr, "Cannot allocate\n");
	exit(1);
    }
    on_keys->count_keys = sizeof(OnKeys)/sizeof(XIMTriggerKey) - 1;
    on_keys->keylist = OnKeys;

    if ((off_keys = (XIMTriggerKeys *)
	 malloc(sizeof(XIMTriggerKeys))) == NULL) {
	fprintf(stderr, "Cannot allocate\n");
	exit(1);
    }
    off_keys->count_keys = sizeof(OffKeys)/sizeof(XIMTriggerKey) - 1;
    off_keys->count_keys = 2;
    off_keys->keylist = OffKeys;

    ext_list = (XVaNestedList *)XVaCreateNestedList( 0,
				   XIMPExtStatusWin, True,
				   XIMPExtBackFront, 1,
				   XIMPExtConversion, True,
				   NULL);

    nest_list = (XVaNestedList *)XVaCreateNestedList( 0,
				    XIMPVersion, ximp_version,
				    XIMPType, ximp_type,
				    XIMPExtension,	ext_list,
				    XIMPServerName, imname,
				    NULL);
    ims = IMOpenIM(dpy,
		   IMModifiers, "XIMP",
		   IMServerWindow, im_window,
		   IMServerName, imname,
		   IMLocale, "ja_JP",
		   XIMPProtoDepend, nest_list,
		   IMInputStyles, input_styles,
		   IMOnKeysList, on_keys,
		   IMOffKeysList, off_keys,
		   NULL);
    IMSetIMValues(ims,
		  IMProtocolHandler, MyProtoHandler,
		  IMXEventHandler, MyXEventHandler,
		  IMFilterEventMask, filter_mask,
		  NULL);

    ext_list = (XVaNestedList *)XVaCreateNestedList( 0,
				   XIMPExtBackFront, &back_front,
				   NULL);

    nest_list = (XVaNestedList *)XVaCreateNestedList( 0,
				    XIMPExtension, &ext_list,
				    NULL);
    IMGetIMValues(ims,
		  IMInputStyles, &styles2,
		  IMOnKeysList, &trigger2,
		  XIMPProtoDepend, nest_list,
		  IMOffKeysList, &trigger2,
		  NULL);
    XSelectInput(dpy, im_window, StructureNotifyMask|ButtonPressMask);
    XMapWindow(dpy, im_window);
    XFlush(dpy);

    IMMainLoop();
}
