/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company
         Copyright 1993, 1994 by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard and
Sun Microsystems, Inc. not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.
Hewlett-Packard Company and Sun Microsystems, Inc. makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY AND SUN MICROSYSTEMS, INC. DISCLAIM ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
HEWLETT-PACKARD COMPANY AND SUN MICROSYSTEMS, INC. BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
    Hiromu Inukai	Sun Microsystems, Inc.
			(Hiromu.Inukai@Japan.Sun.COM)
******************************************************************/
#define NEED_EVENTS
#include <X11/Xlib.h>

#if __STDC__
#define Const const
#else
#define Const /**/
#endif
extern long Const _Xevent_to_mask[];
#include "IMdkit.h"

void
_IMRegisterFilterByType(ims, window, start_type, end_type,
			filter, client_data)
XIMS ims;
Window window;
int start_type;
int end_type;
Bool (*filter)(
#if NeedNestedPrototypes
	       XIMS, Window, XEvent*, XPointer
#endif
	       );
XPointer client_data;
{
    IMFilterEventRec		*rec;

    rec = (IMFilterList)malloc(sizeof(IMFilterEventRec));
    if (!rec)
      return;
    rec->window = window;
    rec->event_mask = 0;
    rec->start_type = start_type;
    rec->end_type = end_type;
    rec->filter = filter;
    rec->client_data = client_data;
    rec->next = ims->core.filters;
    ims->core.filters = rec;
}

void
_IMUnregisterFilter(ims, window, filter)
XIMS ims;
Window window;
Bool (*filter)(
#if NeedNestedPrototypes
		Display*, Window, XEvent*, XPointer
#endif
		);
{
    register IMFilterList   *prev, fl;
 
    for (prev = &ims->core.filters; fl = *prev; ) {
        if (fl->window == window &&
            fl->filter == (IMFilterEventProc)filter) {
            *prev = fl->next;
            free((char *)fl);
        } else
            prev = &fl->next;
    }
}

static Bool
_IMTrue()
{
    return True;
}

int
_IMWaitXEvent(ims, fd)
XIMS ims;
int fd;
{
    Display *dpy = ims->core.display;
    IMFilterList	p;
    XEvent		event, *ev;
    long		mask;
    Window		win;
    Bool		ret;

    if (!XCheckIfEvent(dpy, &event, (Bool (*)())_IMTrue, 0))
      return 0;

    ev = &event;
    win = ev->xany.window;

    if (ev->type >= LASTEvent)
      mask = 0;
    else
      mask = _Xevent_to_mask[ev->type];

    for (p = ims->core.filters; p != NULL; p = p->next) {
	if (win == p->window) {
	    if ((mask & p->event_mask) ||
		(ev->type >= p->start_type && ev->type <= p->end_type)) {
		ret = (*(p->filter))(ims, p->window, ev, p->client_data);
		if(ret == False) {
		    continue;
		}
		return(ret);
	    }
	}
    }
    /* All unfiltered events, may be processed by IMserver */
    if (ims->core.xevent)
      ims->core.xevent(ims, &event);
    return True;
}
