/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#ifndef _IMdkit_h
#define _IMdkit_h

#include <X11/Xmd.h>

/* IM Attributes Name */
#define IMModifiers		"modifiers"
#define IMServerWindow		"serverWindow"
#define IMServerName		"serverName"
#define IMServerTransport	"serverTransport"
#define IMLocale		"locale"
#define IMInputStyles		"inputStyles"
#define IMProtocolHandler	"protocolHandler"
#define IMXEventHandler		"xeventHandler"
#define IMOnKeysList		"onKeysList"
#define IMOffKeysList		"offKeysList"
#define IMEncodingList		"encodingList"
#define IMFilterEventMask	"filterEventMask"

typedef struct {
    char	*name;
    XPointer	value;
} XIMArg;

typedef struct {
    CARD32	keysym;
    CARD32	modifier;
    CARD32	modifier_mask;
} XIMTriggerKey;

typedef struct {
    unsigned short count_keys;
    XIMTriggerKey *keylist;
} XIMTriggerKeys;

typedef char *XIMEncoding;

typedef struct {
    unsigned short count_encodings;
    XIMEncoding *supported_encodings;
} XIMEncodings;

typedef struct {
    void*	(*setup)();
    Status	(*openIM)();
    Status	(*closeIM)();
    char*	(*setIMValues)();
    char*	(*getIMValues)();
    Status	(*forwardEvent)();
    Status	(*commitString)();
    int		(*callCallback)();
    Status	(*wait)();
} IMMethodsRec, *IMMethods;

typedef struct _XIMS *XIMS;

typedef Bool (*IMFilterEventProc)(
#if NeedFunctionPrototypes
    XIMS,
    Window,
    XEvent*,
    XPointer
#endif
);
typedef struct _IMFilter {
    struct _IMFilter *next;
    Window window;
    unsigned long event_mask;
    int start_type, end_type;
    IMFilterEventProc filter;
    XPointer client_data;
} IMFilterEventRec, *IMFilterList;

typedef int (*XEventHandler)(
#if NeedFunctionPrototypes
    XIMS,
    XEvent*
#endif
);

typedef struct {
    Display	*display;
    IMFilterList filters;
    XEventHandler  xevent;	/* IMXEventHandler */
} IMCoreRec, *IMCore;

typedef struct _XIMS {
    IMMethods	methods;
    IMCoreRec	core;
    void	*protocol;
} XIMProtocolRec;

/* 
 * X function declarations.
 */
extern XIMS IMOpenIM(
#if NeedFunctionPrototypes
    Display * /* display */,
    ...
#endif
);

extern Status IMCloseIM(
#if NeedFunctionPrototypes
    XIMS
#endif
);

extern char* IMSetIMValues(
#if NeedFunctionPrototypes
    XIMS,
    ...
#endif
);

extern char* IMGetIMValues(
#if NeedFunctionPrototypes
    XIMS,
    ...
#endif
);

#endif /* IMdkit_h */
