/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#ifndef _Xi18nTrTcp_h
#define _Xi18nTrTcp_h

typedef struct _TcpClient {
    CARD16	connection_id;
    int		accept_fd;
    CARD8	byte_order;
				/* 'B' for Big-Endian */
				/* 'l' for little-Endian */
				/* '?': initial value */
    struct _TcpClient	*next;
} TcpClient;

typedef enum {
    TRANSPORT_UNIX,
    TRANSPORT_TCP
} TcpType;

typedef struct {
    TcpType	transport_type;
    int		port;
    int		listen;
    Bool	is_registered; /* True if listen is registered */
    char	*host;
#ifdef FD_SETSIZE
    fd_set	fdset;
#else
    unsigned long fdset;
#endif
    TcpClient	*clients;
    TcpClient	*freeclients;
} TcpSpecRec;

#ifndef FD_SET		/* 4.2BSD base */
#define FD_SET(n, p)	(*(p) |= (1 << (n)))
#define FD_CLR(n, p)	(*(p) &= ~(1 << (n)))
#define FD_ISSET(n, p)	(*(p) & (1 << (n)))
#define FD_ZERO(p)	(*(p) = 0)
#endif

#define SERVICE_NAME "imdk"
#define DEFAULT_PORT 0x9495
#define UNIX_DOMAIN_PATH "/tmp/.ximsock"

extern Bool _xi18n_TcpBegin(
#if NeedFunctionPrototypes
	XIMS
#endif
);

extern Bool _xi18n_TcpEnd(
#if NeedFunctionPrototypes
	XIMS
#endif
);

extern Bool _xi18n_TcpSend(
#if NeedFunctionPrototypes
	XIMS,
	CARD16 ,
	unsigned char* ,
	long
#endif
);

extern Bool _xi18n_TcpWait(
#if NeedFunctionPrototypes
	XIMS,
	CARD16,
	CARD8,
	CARD8
#endif
);

#endif /* Xi18nTrTcp_h */
