/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/un.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include "FrameMgr.h"
#include "IMdkit.h"
#include "Xi18n.h"
#include "Xi18nTrTcp.h"

static int _TcpWrite(
#if NeedFunctionPrototypes
	int,  char *, int
#endif
);
 
#if NeedFunctionPrototypes
Bool _xi18n_TcpBegin(
	XIMS ims)
#else
Bool _xi18n_TcpBegin(ims)
	XIMS ims;
#endif
{
    Xi18n i18n_core = ims->protocol;
    extern int _xi18n_WaitTcpListen(
#if NeedFunctionPrototypes
		     XIMS, int
#endif
				     );
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;
    int fd;
    int port = 0;

    if (spec->transport_type == TRANSPORT_TCP) { /* inet */
	int reuse = 1;
	struct servent *sp;
	struct hostent *hp;
	struct sockaddr_in sin;
	extern int setsockopt();

	if (spec->port != 0) {
	    port = spec->port;
	} else {
	    if ((sp = getservbyname(SERVICE_NAME, "tcp")) == NULL) {
		port = DEFAULT_PORT;
	    } else {
		port = ntohs(sp->s_port);
	    }
	}
	if (!(hp = gethostbyname(spec->host))) {
	    return False;
	}
	memset((char *)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	memmove(&sin.sin_addr, hp ->h_addr, hp->h_length);
    
	if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	    return False;
	}
	setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &reuse, sizeof(int));
	if (bind(fd, (struct sockaddr *)&sin,
		 sizeof(struct sockaddr_in)) != 0) {
	    shutdown(fd, 2);
	    return False;
	}
	if (listen(fd, 5) < 0) {
	    shutdown(fd, 2);
	    return False;
	}
    } else {	/* unix domain */
	struct sockaddr_un  sosun;

	unlink(spec->host);
	sosun.sun_family = AF_UNIX;
	strcpy(sosun.sun_path, spec->host);
	if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
	    return False;
	}
	if (bind(fd, (struct sockaddr *)&sosun,
		 sizeof(struct sockaddr_un)) < 0) {
	    shutdown(fd, 2);
	    return False;
	}
	if (listen(fd, 5) < 0) {
	    shutdown(fd, 2);
	    return False;
	}
    }
    spec->listen = fd;
    spec->is_registered = True;
    spec->port = port;
    _IMAddInput(i18n_core->address.dpy,
		fd, _xi18n_WaitTcpListen, ims);
    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_TcpEnd(
	XIMS ims)
#else
Bool _xi18n_TcpEnd(ims)
	XIMS ims;
#endif
{
    Xi18n i18n_core = ims->protocol;
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;

    if (spec->is_registered) {
	shutdown(spec->listen, 2);
	(void)close(spec->listen);
	_IMRemoveInput(i18n_core->address.dpy, spec->listen);
	spec->is_registered = False;
    }
    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_TcpSend(
	XIMS ims,
	CARD16 connection_id,
	unsigned char *reply,
	long length)
#else
Bool _xi18n_TcpSend(ims, connection_id, reply, length)
	XIMS ims;
	CARD16 connection_id;
	unsigned char *reply;
	long length;
#endif
{
    Xi18n i18n_core = ims->protocol;
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;
    TcpClient *client = spec->clients;

    while (client != NULL) {
	if (client->connection_id == connection_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    if (length > 0)
      if (_TcpWrite(client->accept_fd, (char *)reply, length) != length)
	return False;

    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_TcpWait(
	XIMS ims,
	CARD16 connect_id,
	CARD8 major_opcode,
	CARD8 minor_opcode)
#else
Bool _xi18n_TcpWait(ims, connect_id, major_opcode, minor_opcode)
	XIMS ims;
	CARD16 connect_id;
	CARD8 major_opcode;
	CARD8 minor_opcode;
#endif
{
    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_TcpDisconnect(
	XIMS ims,
	CARD16 connect_id)
#else
Bool _xi18n_TcpDisconnect(ims, connect_id)
	XIMS ims;
	CARD16 connect_id;
#endif
{
    Xi18n i18n_core = ims->protocol;
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;
    TcpClient *client = spec->clients;
    Display *dpy = i18n_core->address.dpy;
    TcpClient *ccp, *ccp0;

    while (client != NULL) {
	if (client->connection_id == connect_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    shutdown(client->accept_fd, 2);
    (void)close(client->accept_fd);
    _IMRemoveInput(i18n_core->address.dpy, client->accept_fd);

    for (ccp = spec->clients, ccp0 = NULL;
	 ccp != NULL;
	 ccp0 = ccp, ccp = ccp->next) {
	if (ccp == client) {
	    if (ccp0 == NULL) {
		spec->clients = ccp->next;
	    } else {
		ccp0->next = ccp->next;
	    }
	    /* put it back to free list */
	    client->next = spec->freeclients;
	    spec->freeclients = client;
	    return;
	}
    }
    return True;
}

static int _TcpRead(fd, buf, nbyte)
int fd;
char *buf;
int nbyte;
{
    int remain = nbyte;
    int nread = 0;
    do {
	if ((nread = read(fd, buf, remain)) <= 0)
	  return nread ;
	buf += nread ;
	remain -= nread ;
    } while(remain > 0) ;
    return nbyte ;
}

static int _TcpWrite(fd, buf, nbyte)
int fd;
char *buf;
int nbyte;
{
    int remain = nbyte;
    int nwrite = 0;
    do {
	if ((nwrite = write(fd, buf, remain)) < 0)
	  return nwrite ;
	buf += nwrite ;
	remain -= nwrite ;
    } while(remain > 0) ;
    return nbyte ;
}

Bool _xi18n_CheckTcpAddress(i18n_core, transSW, address)
Xi18n i18n_core;
TransportSW *transSW;
char *address;
{
    TcpSpecRec *spec;
    char *p;
    char *hostname;

    if(!(spec = (TcpSpecRec *)malloc(sizeof(TcpSpecRec))))
      return False ;

    if (hostname = (char *)malloc(strlen(address) + 1))
      strcpy(hostname, address);

    if (!strcmp(transSW->transportname, "local")) {
	if (p = (char *)index(hostname, ':')) {
	    *p = 0; p++;
	    spec->host = p;	/* precisely a path name of socket address */
	    spec->transport_type = TRANSPORT_UNIX;
	} else {
	    XFree(hostname);
	    return False;
	}
    } else { /* inet */
	if (p = (char *)index(hostname, ':')) {
	    spec->host = hostname;
	    *p = 0; p++;
	    spec->port = atoi(p);
	    spec->transport_type = TRANSPORT_TCP;
	} else {
	    XFree(hostname);
	    return False;
	}
    }

    i18n_core->address.spec = (TcpSpecRec *)spec;
    i18n_core->methods.begin = _xi18n_TcpBegin;
    i18n_core->methods.end  = _xi18n_TcpEnd;
    i18n_core->methods.send = _xi18n_TcpSend;
    i18n_core->methods.wait = _xi18n_TcpWait;
    i18n_core->methods.disconnect = _xi18n_TcpDisconnect;
    return True;
}

static TcpClient *_FindClient(i18n_core, accept_fd)
Xi18n i18n_core;
Window accept_fd;
{
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;
    TcpClient *client = spec->clients;

    while (client != NULL) {
	if (client->accept_fd == accept_fd)
	  return client;
	client = client->next;
    }

    return NULL;
}

static TcpClient *_NewClient(i18n_core, accept_fd)
Xi18n i18n_core;
int accept_fd;
{
    TcpClient *client;
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;

    if (spec->freeclients != NULL) {
	client = spec->freeclients;
	spec->freeclients = client->next;
    } else {
	client = (TcpClient *)malloc(sizeof(TcpClient));
    }
    client->accept_fd = accept_fd;
    client->connection_id = _xi18n_NewClient();
    client->byte_order = '?';	/* initial value */
    client->next = spec->clients;
    spec->clients = client;

    return client;
}

int
_xi18n_WaitTcpListen(ims, fd)
XIMS ims;
int fd;
{
    Xi18n i18n_core = ims->protocol;
    extern int _xi18n_WaitTcpAccept(
#if NeedFunctionPrototypes
		     XIMS, int
#endif
				     );
    int afd;
    TcpClient *client;

    afd = xi18n_TcpAccept(ims, fd);
    client = _NewClient(i18n_core, afd);
    _IMAddInput(i18n_core->address.dpy,
		client->accept_fd, _xi18n_WaitTcpAccept, ims);
    return 0;
}

int
_xi18n_WaitTcpAccept(ims, fd)
XIMS ims;
int fd;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec packet_header_fr[];
    register int total_size;
    XimProtoHdr	*hdr;
    unsigned char *p = NULL, *pp;
    extern void _xi18n_MessageHandler();
    int read_length;
    Bool isConnect = False;
    CARD8 major_opcode, minor_opcode;
    CARD16 length;
    TcpClient *client = _FindClient(i18n_core, fd);
    CARD16 connect_id = client->connection_id;
    Bool delete = True;

    if ((hdr = malloc(sizeof(hdr))) == NULL)
      return 0;
    read_length = _TcpRead(fd, hdr, sizeof(hdr));
    if (read_length != sizeof(hdr)) {
	goto read_error;
    } else {
	if (client->byte_order == '?') {
	    if (hdr->major_opcode == XIM_CONNECT) {
		CARD8 byte_order;
		read_length = _TcpRead(fd, &byte_order, sizeof(CARD8));
		if (read_length != sizeof(CARD8)) {
		    goto read_error;
		}
		isConnect = True;
		client->byte_order = (CARD8)byte_order;
	    } else {
		return 0;		/* can do nothing */
	    }
	}
	fm = FrameMgrInit(packet_header_fr, (char *)hdr,
			  Need_Swap(i18n_core, connect_id));
	total_size = FrameMgrGetTotalSize(fm);
	/* get data */
	FrameMgrGetToken(fm, major_opcode);
	FrameMgrGetToken(fm, minor_opcode);
	FrameMgrGetToken(fm, length);

	if ((p = (unsigned char *)malloc(sizeof(XimProtoHdr) + length))
	    == NULL)
	  return 0;
	pp = p;
	memmove(pp, hdr, sizeof(XimProtoHdr)); pp += sizeof(XimProtoHdr);
	XFree(hdr);
	if (!isConnect) {
	    if (length > 0) {
		read_length =_TcpRead(fd, pp, length);
		if (read_length != length) {
		    goto read_error;
		}
	    }
	} else {
	    memmove(pp, &client->byte_order, sizeof(CARD8));
	    pp += sizeof(CARD8);
	    read_length = _TcpRead(fd, pp, length - sizeof(CARD8));
	    if (read_length != length - sizeof(CARD8)) {
		goto read_error;
	    }
	}

	_xi18n_MessageHandler(ims, client->connection_id, p, &delete);
	if (delete == True)
	  XFree(p);
    }
    return 0;
  read_error:
    _IMRemoveInput(i18n_core->address.dpy, fd);
    return 0;
}

xi18n_TcpAccept(ims, source)
XIMS ims;
int source;
{
    Xi18n i18n_core = ims->protocol;
    TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;
    int accept_fd;
    int	addrlen;

    if (source == spec->listen) {
	if (spec->transport_type == TRANSPORT_TCP) { /* inet */
	    struct sockaddr_in addr_in;

	    addrlen = sizeof(addr_in);
	    if ((accept_fd = accept(source, (struct sockaddr *)&addr_in,
				    &addrlen)) < 0) {
		return(-1);
	    }
	    return accept_fd;
	} else {	/* unix domain */
	    struct sockaddr_un addr_un;

	    addrlen = sizeof(addr_un);
	    if ((accept_fd = accept(source, (struct sockaddr *)&addr_un,
				    &addrlen)) < 0) {
		return(-1);
	    }
	    return accept_fd;
	}
    }
    return(-1);
}
