/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <X11/Xlib.h>
#include "IMdkit.h"
#include "Xi18n.h"

static Xi18nClient *Clients = (Xi18nClient *)NULL;
static Xi18nClient *FreeClients = (Xi18nClient *)NULL;

CARD16
_xi18n_NewClient()
{
    static CARD16 connect_id = 0;

    Xi18nClient *client;

    if (FreeClients != NULL) {
	client = FreeClients;
	FreeClients = client->next;
    } else {
	client = (Xi18nClient *)malloc(sizeof(Xi18nClient));
    }
    memset(client, 0, sizeof(Xi18nClient));
    client->connect_id = ++connect_id;
    client->pending = (XIMPending *)NULL;
    client->sync = False;
    memset(&client->pending, 0, sizeof(XIMPending *));
    client->next = Clients;
    Clients = client;
    return connect_id;
}

Xi18nClient *_xi18n_FindClient(connect_id)
CARD16 connect_id;
{
    Xi18nClient *client = Clients;

    while (client != NULL) {
	if (client->connect_id == connect_id)
	  return client;
	client = client->next;
    }
    return NULL;
}
