/* Copyright 1994 by Sun Microsystems, Inc. */
/* @(#)XimpData.h	1.7 94/02/16 */
/******************************************************************

              Copyright 1994 by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hiromu Inukai (inukai@Japan.Sun.COM) Sun Microsystems, Inc.

******************************************************************/

#ifndef _XIMPDATA_H_
#define _XIMPDATA_H_
#include <stdio.h>
#include <X11/Xlib.h>
#include "IMdkit.h"
#define XIMP_40
#include "XIMProto.h"

/* XIMP Valid Attribute Name Definition */
#define	XIMPProtoDepend		"ximpProtoDepend"
#define XIMPVersion		"ximpVersion"
#define XIMPType		"ximpType"
#define XIMPServerName		"ximpServerName"
#define XIMPServerVersion	"ximpServerVersion"
#define XIMPVendorName		"ximpVendorName"

#define	XIMPExtension		"ximpExtension"
#define	XIMPExtStatusWin	"ximpExtStatusWin"
#define	XIMPExtBackFront	"ximpExtBackFront"
#define	XIMPExtConversion	"ximpExtConversion"
/*
 * Data interchange structures
 */

/* XIMP4.0 */
typedef struct {
    int			type;	/* XIMP_KEYPRESS or XIMP_KEYRELEASE */
    ICID		icid;
    unsigned int	state;
    unsigned int	keycode;
    Time		time;
} XIMPKeyPressStruct, XIMPKeyReleaseStruct;

typedef struct {
    int			type;	/* XIMP_CREATE, XIMP_SETVALUE, XIMP_GETVALUE */
    Window		client_win;
    unsigned short	style;
    long		attr_mask;
    Window		focus_win;
    long		fwin_sel_mask;
    unsigned long	ximp_type_mask;
    long		icid;
    Ximp_PreeditPropRec4	*pre_values;
    Ximp_StatusPropRec4	*sts_values;
    char		*pre_font;
    char		*sts_font;
} XIMPICValuesStruct;

typedef struct {
    int			type;	/* XIMP_DESTORY */
    ICID		icid;
} XIMPDestroyStruct;

typedef struct {
    int			type;	/* XIMP_REG_KEY_PRESSED */
    ICID		icid;
} XIMPRegKeyPressedStruct;

typedef struct {
    int			type;	/* XIMP_SETFOCUS */
    ICID		icid;
} XIMPSetFocusStruct;

typedef struct {
    int			type;	/* XIMP_UNSETFOCUS */
    ICID		icid;
} XIMPUnSetFocusStruct;

typedef struct {
    int			type;	/* XIMP_CLIENTWINDOW */
    ICID		icid;
    Window		new_client_win;
    long		new_fwin_mask;
} XIMPClientWindowStruct;

typedef struct {
    int			type;	/* XIMP_FOCUSWINDOW */
    ICID		icid;
    Window		new_focus_win;
    long		new_fwin_mask;
} XIMPFocusWindowStruct;

typedef struct {
    int			type;	/* XIMP_MOVE */
    ICID		icid;
    long		x;
    long		y;
} XIMPMoveStruct;

typedef struct {
    int			type;	/* XIMP_EVENTMASKNOTIFY */
    ICID		icid;
    long		fwin_sel_mask;
} XIMPEventMaskNotifyStruct;

typedef struct {
    int			type;	/* XIMP_EXTENSION */
    ICID		icid;
    Atom		ext_atom;
    long		data1;
    long		data2;
} XIMPExtensionStruct;

typedef struct {
    int			type;	/* XIMP_KEYPRESS_RETURN */
    ICID		icid;
} XIMPKeyPressReturnStruct;

typedef struct {
    int			type;	/* XIMP_KEYRELEASE_RETURN */
    ICID		icid;
} XIMPKeyReleaseReturnStruct;

typedef struct {
    int			type;	/* XIMP_CREATE_RETURN */
    ICID		icid;
} XIMPCreateReturnStruct;

typedef struct {
    int			type;	/* XIMP_SPROC_STARTED */
    ICID		icid;
} XIMPSProcStartedStruct;

typedef struct {
    int			type;	/* XIMP_SPROC_STOPPED */
    ICID		icid;
} XIMPSProcStoppedStruct;

typedef struct {
    int			type;	/* XIMP_READ_PROP */
    ICID		icid;
    Atom		stored;
} XIMPReadPropStruct;

typedef struct {
    int			type;	/* XIMP_CLIENTWINDOW_RETURN */
    ICID		icid;
} XIMPClientWindowReturnStruct;

typedef struct {
    int			type;	/* XIMP_FOCUSWINDOW_RETURN */
    ICID		icid;
} XIMPFocusWindowReturnStruct;

typedef struct {
    int			type;	/* XIMP_GETVALUE_RETURN */
    ICID		icid;
} XIMPGetValueReturnStruct;

typedef struct {
    int			type;	/* XIMP_RESET or XIMP_RESET_RETURN */
    ICID		icid;
    char		*ctext; /* Return */
} XIMPResetStruct;

typedef struct {
    int			type;	/* XIMP_EVENTMASK_NOTIFY_RETURN */
    ICID		icid;
} XIMPEventMaskNotifyReturnStruct;

typedef struct {
    ICID		icid;
    char		*ctext;
} XIMPCommitStringStruct;

typedef struct {
    int			type;	/* XIMP_ERROR */
    ICID		icid;
    long		err_req;
    long		err_detail;
    long		extended;
} XIMPErrorStruct;

typedef struct {
    int			type;	/* XIMP_GEOMETRY */
    ICID		icid;
} XIMPGeometryCBStruct;

typedef struct {
    int			type;	/* XIMP_PREEDITSTART */
    ICID		icid;
} XIMPPreeditStartCBStruct;

typedef struct {
    int			type;	/* XIMP_PREEDITDONE */
    ICID		icid;
} XIMPPreeditDoneCBStruct;

typedef struct {
    int			type;	/* XIMP_PREEDITDRAW */
    ICID		icid;
    int			caret;
    int			chg_first;
    int			chg_length;
    XIMText		*text;
} XIMPPreeditDrawCBStruct;

typedef struct {
    int			type;	/* XIMP_PREEDITCARET */
    ICID		icid;
    int			position;
    XIMCaretDirection	direction;
    XIMCaretStyle	style;
} XIMPPreeditCaretCBStruct;

typedef struct {
    int			type;	/* XIMP_STATUSSTART */
    ICID		icid;
} XIMPStatusStartCBStruct;

typedef struct {
    int			type;	/* XIMP_STATUSDONE */
    ICID		icid;
} XIMPStatusDoneCBStruct;

typedef struct {
    int			type;	/* XIMP_STATUSDRAW */
    ICID		icid;
    XIMStatusDataType	data_type;
    union {
	XIMText	*text;
	Pixmap	bitmap;
    } data;
} XIMPStatusDrawCBStruct;

typedef union _IMProtocol {

    int					type;
    XIMPKeyPressStruct			keypress;
    XIMPKeyReleaseStruct		keyrelease;
    XIMPICValuesStruct			create;
    XIMPDestroyStruct			destroy;
    XIMPRegKeyPressedStruct		regkey;
    XIMPSetFocusStruct			setfocus;
    XIMPUnSetFocusStruct		unsetfocus;
    XIMPClientWindowStruct		clientwin;
    XIMPFocusWindowStruct		focuswin;
    XIMPMoveStruct			move;
    XIMPICValuesStruct			setvalue;
    XIMPICValuesStruct			getvalue;
    XIMPEventMaskNotifyStruct		evmasknotify;
    XIMPExtensionStruct			extension;
    XIMPKeyPressReturnStruct		keypressret;
    XIMPKeyReleaseReturnStruct		keyreleaseret;
    XIMPCreateReturnStruct		createret;
    XIMPSProcStartedStruct		sprocstart;
    XIMPSProcStoppedStruct		sprocstop;
    XIMPReadPropStruct			readprop;
    XIMPClientWindowReturnStruct	clientwinret;
    XIMPFocusWindowReturnStruct		focuswinret;
    XIMPGetValueReturnStruct		getvalueret;
    XIMPResetStruct			reset;
    XIMPEventMaskNotifyReturnStruct	evmasknotifyret;
    XIMPCommitStringStruct		commitstring;
    XIMPErrorStruct			error;
    XIMPGeometryCBStruct		geometry;
    XIMPPreeditStartCBStruct		preeditstart;
    XIMPPreeditDoneCBStruct		preeditdone;
    XIMPPreeditDrawCBStruct		preeditdraw;
    XIMPPreeditCaretCBStruct		preeditcaret;
    XIMPStatusStartCBStruct		statusstart;
    XIMPStatusDoneCBStruct		statusdone;
    XIMPStatusDrawCBStruct		statusdraw;

    long				pad[24];

} IMPProtocol;

/*
 * Used in determining protocol
 */
typedef enum {
	      ximp_none,
	      ximp_35,
	      ximp_40,
	      ximp_unknown
	     } protocol_version;

/*
 * Used in checking preedit/status attributes
 */
typedef enum {
	      none_mask,
	      preedit_mask,
	      status_mask
	     } mask_kind;

/*
 * Used in sending compound texts
 */

#define LONGENOUGH	250
#define RESET_NOTHING	0
#define RESET_BY_CMSG	1
#define RESET_BY_PROP	2

/*
 * Used in supporting extensions
 */
#define EXT_STATUS	(1L<<0)
#define EXT_BACKFRONT	(1L<<1)
#define EXT_CONV	(1L<<2)
#define XIMP_EXT_STAT_WIN	"_XIMP_EXT_XIMP_STATUSWINDOW"
#define XIMP_EXT_BACKFRONT	"_XIMP_EXT_XIMP_BACK_FRONT"
#define XIMP_EXT_CONV		"_XIMP_EXT_XIMP_CONVERSION"

typedef struct _XIMPTypeRec {
    int			num_of_types;
    unsigned long	*types;
} XIMPTypeRec;

/*
 * Active filters on focus window
 */
#define FLT_NONE	(0L)
#define FLT_KEYPRESS	(1L<<0)
#define FLT_KEYRELEASE	(1L<<1)

typedef struct _XIMPWinAssocRec {
    Bool		is_conv_on;	/* holds current conversion state */
    Bool		is_altered;	/* holds conversion state altered */
    long		clientmasks;	/* holds client's interest masks */
    unsigned int	og_code;	/* holds keycode to keep matching */
    unsigned int	og_state;	/* holds keystate to keep matching */
    long	icid;
    long	filters;
    Window	client;
    Window	focus;
} XIMPWinAssocRec;

typedef int (*IMProtoHandler)();

typedef struct _XIMPCoreRec {
    Display		*display;
    int			screen;
    Window		window;		/* ims window */
    int			ic_counts;	/* holds number of ICs */
    XIMPWinAssocRec	*ic_list;	/* holds icid-client_win-focus_win combi. */
    long		active_icid;	/* holds active IC id */
    char		*ims_name;	/* IMServer Name */
    char		*ims_version;	/* IMServer Version */
    char		*vendor;	/* IMServer Vendor Name */
    char		*support_locale; /* <locale>,<locale>,... */
					 /* <locale> := <lang>_<terr> */
    Atom		ximp_version;	/* XIMP Protocol version */
    Atom		mes_type;	/* Protocol type for Cmsg */
    XIMStyles		styles;
    XIMPTypeRec		*ximp_type;	/* Available Type List */
    unsigned long	cur_type;	/* Type for current session */
    Ximp_KeyList	start_keys;
    Ximp_KeyList	stop_keys;
    IMProtoHandler	imp_handler;
    XEventHandler	xev_handler;
    unsigned long	support_ext;
    long		ext_backfront;	/* holds BackEnd/FrontEnd flag */
} XIMPCoreRec, *XIMPCore;

extern void *ximp_setup(
#if NeedFunctionPrototypes
   Display* /* dpy */,
   XIMArg*  /* args */
#endif
);
 
extern Status ximp_openIM(
#if NeedFunctionPrototypes
   XIMS
#endif
);
 
extern Status ximp_closeIM(
#if NeedFunctionPrototypes
   XIMS
#endif
);
 
extern char * ximp_setIMValues(
#if NeedFunctionPrototypes
   XIMS,
   XIMArg*
#endif
);
 
extern char * ximp_getIMValues(
#if NeedFunctionPrototypes
   XIMS,
   XIMArg*
#endif
);
 
extern Status ximp_forwardEvent(
#if NeedFunctionPrototypes
   XIMS,
   IMPProtocol * /* For KeyPress or KeyRelease */
#endif
);
 
extern Status ximp_commitString(
#if NeedFunctionPrototypes
   XIMS,
   IMPProtocol * /* For CommitString */
#endif
);
 
extern Status ximp_wait(
#if NeedFunctionPrototypes
        XIMS,
        IMPProtocol *
#endif
);
#endif /* _XIMPDATA_H_ */
