/* Copyright 1994 by Sun Microsystems, Inc. */
/* @(#)XimpUtls.c	1.5 94/02/16 */
/******************************************************************
 
              Copyright 1994 by Sun Microsystems, Inc.
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.
 
Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hiromu Inukai (inukai@Japan.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/

#ifndef _XIMPUTLS_C_
#define _XIMPUTLS_C_
#include <X11/Xatom.h>
#define	NEED_EVENTS
#include <X11/Xlibint.h>
#include "XimpData.h"

long
_find_evmask(XIMPCore core, long icid)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    return(core->ic_list[i].clientmasks);
	}
    }
    return (long)0;
}

Bool
_find_state(XIMPCore core, long icid)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    return(core->ic_list[i].is_conv_on);
	}
    }
    return False;
}

Bool
_find_alter(XIMPCore core, long icid)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    return(core->ic_list[i].is_altered);
	}
    }
    return False;
}

Bool
_find_match(XIMPCore core, long icid, unsigned int kcode, unsigned int state)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if((core->ic_list[i].icid == icid) &&
	   (core->ic_list[i].og_code == kcode) &&
	   (core->ic_list[i].og_state == state)) {
		return True;
	}
    }
    return False;
}

Window
_find_focus(XIMPCore core, long icid)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    return(core->ic_list[i].focus);
	}
    }
    return (Window)0;
}

Window
_find_client(XIMPCore core, long icid)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    return(core->ic_list[i].client);
	}
    }
    return (Window)0;
}

long
_find_flt_mask(XIMPCore core, long icid)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    return(core->ic_list[i].filters);
	}
    }
    return (long)0;
}

long
_find_icid_cw(XIMPCore core, Window client)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].client == client) {
	    return(core->ic_list[i].icid);
	}
    }
    return (long)0;
}

long
_find_icid_fw(XIMPCore core, Window focus)
{
    register int i;

    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].focus == focus) {
	    return(core->ic_list[i].icid);
	}
    }
    return (long)0;
}

void
_set_evmask(XIMPCore core, long icid, long mask)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].clientmasks = mask;
	}
    }
}

void
_set_state(XIMPCore core, long icid, Bool state)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].is_conv_on = state;
	}
    }
}

void
_set_alter(XIMPCore core, long icid, Bool state)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].is_altered = state;
	}
    }
}

void
_set_match(XIMPCore core, long icid, unsigned int kcode, unsigned int state)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].og_code = kcode;
	    core->ic_list[i].og_state = state;
	}
    }
}

void
_set_focus(XIMPCore core, long icid, Window focus)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].focus = focus;
	}
    }
}

void
_set_client(XIMPCore core, long icid, Window client)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].client = client;
	}
    }
}

void
_set_flt_mask(XIMPCore core, long icid, long mask)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].filters |= mask;
	}
    }
}

void
_unset_flt_mask(XIMPCore core, long icid, long mask)
{
    register int i;
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].icid == icid) {
	    core->ic_list[i].filters &= ~mask;
	}
    }
}

void
_add_iclist(XIMPCore core, long icid, XIMPICValuesStruct *create)
{
    core->ic_counts++;
    if(core->ic_list == NULL)
	core->ic_list = (XIMPWinAssocRec*)malloc(sizeof(XIMPWinAssocRec));
    else
	core->ic_list = (XIMPWinAssocRec*)realloc((void*)core->ic_list,
					sizeof(XIMPWinAssocRec) * core->ic_counts);
    core->ic_list[core->ic_counts - 1].og_code = (unsigned int)0;
    core->ic_list[core->ic_counts - 1].og_state = (unsigned int)0;
    core->ic_list[core->ic_counts - 1].is_conv_on = False;
    core->ic_list[core->ic_counts - 1].is_altered = False;
    core->ic_list[core->ic_counts - 1].clientmasks = create->fwin_sel_mask;
    core->ic_list[core->ic_counts - 1].icid = create->icid;
    core->ic_list[core->ic_counts - 1].filters = FLT_NONE;
    core->ic_list[core->ic_counts - 1].client = create->client_win;
    core->ic_list[core->ic_counts - 1].focus = create->focus_win;
}

void
_remove_iclist(XIMPCore core, long icid)
{
    register int i;
    core->ic_counts--;
    if(core->ic_counts == 0) {
	free(core->ic_list);
	core->ic_list = NULL;
    } else {
	for(i = 0; i < core->ic_counts; i++) {
	    if(core->ic_list[i].icid == icid) {
	    /*
	     * Copy the information in the last room, then chop-off the tail.
	     */
		core->ic_list[i].og_code = core->ic_list[core->ic_counts - 1].og_code;
		core->ic_list[i].og_state = core->ic_list[core->ic_counts - 1].og_state;
		core->ic_list[i].is_conv_on = core->ic_list[core->ic_counts - 1].is_conv_on;
		core->ic_list[i].is_altered = core->ic_list[core->ic_counts - 1].is_altered;
		core->ic_list[i].clientmasks = core->ic_list[core->ic_counts - 1].clientmasks;
		core->ic_list[i].icid = core->ic_list[core->ic_counts - 1].icid;
		core->ic_list[i].filters = core->ic_list[core->ic_counts - 1].filters;
		core->ic_list[i].client = core->ic_list[core->ic_counts - 1].client;
		core->ic_list[i].focus = core->ic_list[core->ic_counts - 1].focus;
		core->ic_list = (XIMPWinAssocRec*)realloc((void*)core->ic_list,
					sizeof(XIMPWinAssocRec) * core->ic_counts);
	    }
	}
    }
}

void
_check_version(XIMS xims, XEvent *ev, int *proto_num)
{
    Display		*display = ((XIMPCore)xims->protocol)->display;
    Atom		va = XInternAtom(display, "_XIMP_VERSION", False);
    Atom		atom_ret = (Atom)0;
    int			format_ret = 0;
    unsigned long	nitems_ret = (unsigned long)0;
    unsigned long	bytes_ret = (unsigned long)0;
    char		*prop_ret = (char*)NULL;

    XGetWindowProperty(display,
			 ev->xclient.data.l[1],
			 va,
			 0,
			 10000L,
			 True,
			 XA_STRING,
			 &atom_ret,
			 &format_ret,
			 &nitems_ret,
			 &bytes_ret,
			 (unsigned char**)&prop_ret);
    if(atom_ret == None || atom_ret != va) {
	/*
	 * Call XIMP_ERROR because of ambiguity of protocol
	 */
    }
    if(!strcmp(prop_ret, "XIMP.4.0")) {
	*proto_num = ximp_40;
    } else if(!strcmp(prop_ret, "XIMP.3.5")) {
	*proto_num = ximp_35;
    } else if(!strcmp(prop_ret, "XIMP_1.0")) {
	*proto_num = ximp_40;
    } else if(!strcmp(prop_ret, "XIMP.3.4")) {
	*proto_num = ximp_35;
    } else {
	*proto_num = ximp_unknown;
	/*
	 * Call XIMP_ERROR because of unknown protocol version
	 */
    }
    XFree(prop_ret);
}

Atom
_check_atom(Display *display, Atom *at, char *at_str)
{
    if(!(*at))
	*at = XInternAtom(display, at_str, False);
    return(*at);
}

void
_send_proto(XIMPCore core, int protocol, int icid, int data1, int data2, int data3)
{
    Display	*display = core->display;
    XEvent	event;
    Window	win = _find_focus(core, icid);
 
    memset(&event, 0, sizeof(event));
    event.type = ClientMessage;
    event.xclient.format = 32;
    event.xclient.window = win;
    event.xclient.message_type = core->mes_type;
    event.xclient.data.l[0] = protocol;
    event.xclient.data.l[1] = icid;
    event.xclient.data.l[2] = data1;
    event.xclient.data.l[3] = data2;
    event.xclient.data.l[4] = data3;
    XSendEvent(display, win, False, NoEventMask, &event);
    XFlush(display);
}

void
_get_prop(
	  Display *display,
	  Window win,
	  Atom name_a,
	  Atom type_a,
	  char *dest)
{
#define MAX_LEN	10000L
    Atom		atom_ret = (Atom)0;
    int			format_ret = 0;
    unsigned long	nitems_ret = (unsigned long)0;
    unsigned long	bytes_ret = (unsigned long)0;
    unsigned char	*prop_ret = (unsigned char*)NULL;

    XGetWindowProperty(display,
			win,
			 name_a,
			 0,
			 MAX_LEN,
			 True,
			 type_a,
			 &atom_ret,
			 &format_ret,
			 &nitems_ret,
			 &bytes_ret,
			 &prop_ret);
    if(atom_ret == None || atom_ret != type_a) {
	/*
	 * Call XIMP_ERROR because of ambiguity of protocol
	 */
    }
    if(type_a == XA_STRING) {
	*((char**) dest) = strdup((char *)prop_ret);
    } else {
	memmove(dest, prop_ret, nitems_ret * 4); /* 32bits = 4 octets */
    }
    XFree(prop_ret);
#undef MAX_LEN
}

void
_set_prop(
	  Display *display,
	  Window win,
	  Atom name_a,
	  Atom type_a,
	  char *dest,
	  int nitems)
{
    XChangeProperty(display,
			win,
			 name_a,
			 type_a,
			 (type_a == XA_STRING ? 8 : 32),
			 PropModeAppend,
			 (unsigned char*)dest,
			 nitems);
}
	    
Atom
XimpAtomPool(Display *display, XPropertyEvent *evp)
{
#define CALLBACKS_PROPNAME_LEN	64
#define MAX_CALLBACKS_PROP	100
    static int  index = 0;
    static int  number = 0;
    static int  pool_size = 0;
    static char prop_name[CALLBACKS_PROPNAME_LEN] = {0};
    static Atom *pool = (Atom*)NULL;
    Atom   this_atom;
 
    if(pool_size == 0){
        pool = (Atom *)malloc(sizeof(Atom) * MAX_CALLBACKS_PROP);
        pool_size = MAX_CALLBACKS_PROP;
    }
 
    if(evp == (XPropertyEvent *)NULL) {
        if(index == 0) {
            memset(prop_name, 0, CALLBACKS_PROPNAME_LEN);
            sprintf(prop_name, "%s%X","_XIMP_NORMALPROP_", number++) ;
            this_atom = XInternAtom(display, prop_name, False);
        }
        else {
            this_atom = pool[--index];
        }
    }
    else {
        if(evp->state != PropertyDelete)
                return (Atom)NULL;
        if(index >= pool_size - 1) {
                pool = (Atom *)
                    realloc(pool, sizeof(Atom) * (pool_size + MAX_CALLBACKS_PROP));
                pool_size += MAX_CALLBACKS_PROP;
        }
        pool[index++] = evp->atom;
                return (Atom)NULL;
    }
    return this_atom;
#undef CALLBACKS_PROPNAME_LEN
#undef MAX_CALLBACKS_PROP
}

Atom
XimpReplacePropPool(XIMPCore core, Atom type, char *str, int len, int format)
{
    Display	*display = core->display;
    Window	window = core->window;
    Atom	atom;
    char	prop_name[32];
 
    atom = XimpAtomPool(display, (XPropertyEvent *)NULL);
    XChangeProperty(display, window, atom, type, format,
                    PropModeReplace, (unsigned char *) str, len);
    XFlush(display);
    return (atom);
}

static Bool
isRegisterd(Display *display, unsigned int kcode, unsigned int kstate, int count, Ximp_Key *ptr)
{
    register int i;
    KeySym ksym = XKeycodeToKeysym(display, kcode, 0);
    for(i = 0; i < count; i++, ptr++) {
	if((ptr->keysym == ksym) &&
	   ((kstate & ptr->modifier_mask) == ptr->modifier)) {
	    return True;
	}
    }
    return False;
}

/*
 * Functions to watch key events if they are conversion change keys.
 * Conversion stop process is a bit tricky. That is:
 *	When clients is interested in KeyRelease events,
 *	we alternate the conversion state by the KeyRelease event(not KeyPress).
 */

void
_check_alterkey4(XIMPCore core, XClientMessageEvent *event, int protocol)
{
    Display	    *display = core->display;
    long	    cur_type = core->cur_type;
    long	    icid = event->data.l[1];
    unsigned int    kcode = event->data.l[2];
    unsigned int    kstate = event->data.l[3];
    Bool	    cur_state = _find_state(core, icid);
    Bool	    release_on;
    Bool	    is_reg;

    release_on = ((_find_evmask(core, icid) & KeyReleaseMask) ?
			True :
			False);
    switch(cur_type) {
      case XIMP_FE_TYPE1:
      case XIMP_BE_TYPE1:
      case XIMP_SYNC_BE_TYPE1:
	is_reg = isRegisterd(display, kcode, kstate,
			     core->stop_keys.count_keys,
			     core->stop_keys.keys_list);
	if(is_reg) {
	    _set_state(core, icid, False);
	    _set_alter(core, icid, True);
	    _send_proto(core, XIMP_SPROC_STOPPED4,
			    icid, 0, 0, 0);
	} else {
	    _set_alter(core, icid, False);
	}
	break;
      case XIMP_FE_TYPE2:
      case XIMP_FE_TYPE3:
      case XIMP_BE_TYPE2:
      case XIMP_SYNC_BE_TYPE2:
	if(cur_state) {
		is_reg = isRegisterd(display, kcode, kstate,
				     core->stop_keys.count_keys,
				     core->stop_keys.keys_list);
		if(is_reg) {
		    _set_state(core, icid, False);
		    _set_alter(core, icid, True);
		    if(cur_type == XIMP_FE_TYPE3) {
			_send_proto(core, XIMP_SPROC_STOPPED4,
				    icid, 0, 0, 0);
		    }
		} else {
		    _set_alter(core, icid, False);
		}
	} else {
	    is_reg = isRegisterd(display, kcode, kstate,
				 core->start_keys.count_keys,
				 core->start_keys.keys_list);
	    if(is_reg) {
		_set_state(core, icid, True);
		_set_alter(core, icid, True);
	    } else {
		_set_alter(core, icid, False);
	    }
	}
    default:
	break;
    }
}

void
_check_alterkey3(XIMPCore core, XClientMessageEvent *event, int protocol)
{
    Display	    *display = core->display;
    long	    cur_type = core->cur_type;
    long	    icid = event->data.l[1];
    unsigned int    kcode = event->data.l[2];
    unsigned int    kstate = event->data.l[3];
    Bool	    cur_state = _find_state(core, icid);
    Bool	    release_on;
    Bool	    is_reg;

    release_on = ((_find_evmask(core, icid) & KeyReleaseMask) ?
			True :
			False);
    switch(cur_type) {
      case XIMP_FRONTEND:
      case XIMP_BACKEND:
	is_reg = isRegisterd(display, kcode, kstate,
			     core->stop_keys.count_keys,
			     core->stop_keys.keys_list);
	if(is_reg) {
	    _set_state(core, icid, False);
	    _set_alter(core, icid, True);
	    _send_proto(core, XIMP_PROCESS_END3,
			icid, 0, 0, 0);
	} else {
	    _set_alter(core, icid, False);
	}
	break;
    default:
	break;
    }
}
#endif /* _XIMPUTLS_C_ */
