/* @(#)Henkan.c	3.5 93/09/15 16:50:06 FUJITSU LIMITED. */
/******************************************************************

         Copyright 1991, 1992, 1993 by FUJITSU LIMITED

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of FUJITSU LIMITED
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
FUJITSU LIMITED makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

FUJITSU LIMITED DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL FUJITSU LIMITED BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Takashi Fujiwara     FUJITSU LIMITED 
                               fujiwara@a80.tech.yk.fujitsu.co.jp
          Kiyoaki oya          FUJITSU LIMITED
	  Toshimitu Terazono   FUJITSU LIMITED

******************************************************************/

/*  xfeoak : Input Server (kana-kanji covertion front end)	*/
/*         : Version 3.5					*/

#include <stdio.h>
#include "Henkan.h"

#ifndef       AIXV3
typedef unsigned short	ushort;
typedef unsigned char	uchar;
#endif

#define Static static

DictionaryFuncRec *current_dictionary_func;
extern DictionaryFuncRec dmy_dictionary_func;

#ifdef OAK_DICTIONARY					/* SXG OAK */
extern DictionaryFuncRec sxg_dictionary_func;
#endif /*OAK_DICTIONARY*/				/* SXG OAK */

#ifdef OAK2_DICTIONARY					/* OAK */
extern DictionaryFuncRec oak_dictionary_func;
#endif /*OAK2_DICTIONARY*/				/* OAK */


#ifdef SJ3_DICTIONARY					/* SJ3 */
extern DictionaryFuncRec sj3_dictionary_func;
#endif /*SJ3_DICTIONARY*/				/* SJ3 */


DictionaryFuncRec *dictionary_func_tbl[] = {

#ifdef OAK_DICTIONARY					/* SXG OAK */
    &sxg_dictionary_func,				/* SXG OAK */
#endif /*OAK_DICTIONARY*/				/* SXG OAK */

#ifdef OAK2_DICTIONARY					/* OAK */
    &oak_dictionary_func,				/* OAK */
#endif /*OAK2_DICTIONARY*/				/* OAK */

#ifdef SJ3_DICTIONARY					/* SJ3 */
    &sj3_dictionary_func,				/* SJ3 */
#endif /*SJ3_DICTIONARY*/				/* SJ3 */

    &dmy_dictionary_func
};

int     dictionary_no = 0;

int	no_of_dictionary_func = sizeof(dictionary_func_tbl)
			      / sizeof(dictionary_func_tbl[0]);

int
Dic_Argv( argc, argv)
    int 	argc;
    char	*argv[];
{
    int		j, rc;
    DictionaryFuncRec *current_dictionary_func;

    for( j=0; j < no_of_dictionary_func-1; j++) {
	current_dictionary_func = dictionary_func_tbl[j];
	if( *current_dictionary_func->selecut_name
	&& !strcmp(argv[0], current_dictionary_func->selecut_name)) {
	    dictionary_no = j;
	    return( 1 );
	}
    }

    for( j=0; j < no_of_dictionary_func; j++) {
	current_dictionary_func = dictionary_func_tbl[j];
	if( current_dictionary_func->argv ) {
	    rc = (*current_dictionary_func->argv)( argc, argv);
	    if( rc != 0 )
	        return( rc );
        }
    }
    return( 0 );
}

int
Dic_Help( fp)
FILE	*fp;
{
    int		j;
    DictionaryFuncRec *current_dictionary_func;

    if( no_of_dictionary_func > 2 ) {
        for( j=0; j < no_of_dictionary_func-1; j++) {
	    current_dictionary_func = dictionary_func_tbl[j];
	    if( *current_dictionary_func->selecut_name ) {
		fprintf(fp,"\t[%s ", current_dictionary_func->selecut_name );
		if( current_dictionary_func->help ) {
		   (*current_dictionary_func->help)( fp );
		}
    		fprintf(fp,"]\n");
	    }
	}
    } else {
	current_dictionary_func = dictionary_func_tbl[0];
	if( current_dictionary_func->help ) {
	    fprintf(fp,"\t");
	    (*current_dictionary_func->help)( fp );
    	    fprintf(fp,"\n");
	}
    }
    return( 0);
}

int
Dic_Open()
{
    current_dictionary_func = dictionary_func_tbl[ dictionary_no ];
    if( current_dictionary_func->open )
        return (*current_dictionary_func->open)();
    return(0);
}

int
Dic_Close()
{
    if( current_dictionary_func->close )
        return (*current_dictionary_func->close)();
    return(0);
}

int
Dic_Henkan( cnvrt, count, yomi, yomi_len, out_buff, out_size)
uchar	cnvrt;
int	count;
ushort	*yomi;
int	yomi_len;
ushort	*out_buff;
int	out_size;
{
    if( current_dictionary_func->henkan )
        return (*current_dictionary_func->henkan)( cnvrt, count, yomi,
					yomi_len, out_buff, out_size);
    return(0);
}

int
Dic_Zenkouho( type, yomi, yomi_len )
int 	type;
ushort *yomi;
int	yomi_len;
{
    if( current_dictionary_func->zenkouho )
        return (*current_dictionary_func->zenkouho)( type, yomi, yomi_len );
    return(0);
}

int
Dic_HenkanCancel()
{
    if( current_dictionary_func->cancel )
        return (*current_dictionary_func->cancel)();
    return(0);
}
