/* @(#)XimSwap.c	3.5 93/09/15 16:50:23 FUJITSU LIMITED. */
/******************************************************************

              Copyright 1992, 1993, 1994 by FUJITSU LIMITED

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of FUJITSU LIMITED
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
FUJITSU LIMITED makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

FUJITSU LIMITED DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL FUJITSU LIMITED BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Takashi Fujiwara     FUJITSU LIMITED 
                               fujiwara@a80.tech.yk.fujitsu.co.jp
          Riki Kawaguchi       FUJITSU LIMITED
	  Toshimitu Terazono   FUJITSU LIMITED

******************************************************************/

/*  Xfeoak : Input Server (kana-kanji covertion front end)	*/
/*         : Version 3.5 (for X11R6)				*/

#include <X11/Xlibint.h>
#include "XimProto.h"
#include "Xfeoak.h"

Static CARD16
_XimCard16(val)
    CARD16	 val;
{
    return val;
}

Static CARD16
_XimSwapCard16(val)
    CARD16	 val;
{
    return (val << 8) & 0xff00 |
           (val >> 8) & 0xff;
}

Static CARD32
_XimCard32(val)
    CARD32	val;
{
    return val;
}

Static CARD32
_XimSwapCard32(val)
    CARD32	val;
{
    return (val << 24) & 0xff000000 |
	   (val <<  8) & 0xff0000   |
	   (val >>  8) & 0xff00     |
	   (val >> 24) & 0xff;
}

void
XimSetEndian()
{
    CARD8		endian = current_connect->byte_order;
    static CARD16	tesr_card = 1;

    if ((endian == BIGENDIAN    && *((CARD8 *)&tesr_card) == 0)
     || (endian == LITTLEENDIAN && *((CARD8 *)&tesr_card) != 0)) {
	current_connect->Card16 = _XimCard16;
	current_connect->Card32  = _XimCard32;
    } else {
	current_connect->Card16 = _XimSwapCard16;
	current_connect->Card32  = _XimSwapCard32;
    }
    return;
}
