/* @(#)XimTrans.c	3.5 93/09/15 16:50:27 FUJITSU LIMITED. */
/******************************************************************

	   Copyright 1992, 1993, 1994 by FUJITSU LIMITED

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of FUJITSU LIMITED
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
FUJITSU LIMITED makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

FUJITSU LIMITED DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL FUJITSU LIMITED BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Takashi Fujiwara     FUJITSU LIMITED 
			       fujiwara@a80.tech.yk.fujitsu.co.jp
	  Riki Kawaguchi       FUJITSU LIMITED
	  Toshimitu Terazono   FUJITSU LIMITED

******************************************************************/

/*  xfeoak : Input Server (kana-kanji covertion front end)	*/
/*	 : Version 3.5 (for X11R6)			    */

#include "Xfeoak.h"

/*  Transport layer  */
static Xfe_TransRec	transRec[] = {
    {"X", InitialXProto, ExitXProto, GetXProtoName},
    {"tcp", InitialTcp, ExitTcp, GetTcpName},
    {"local", InitialInternal, ExitInternal, GetInternalName},
    {(char *)NULL, (Bool (*)())NULL,
			(void (*)())NULL, (Bool (*)())NULL}
};

Bool
InitialTransport()
{
    register int i;
    Bool	 ret = False;

    for (i = 0; transRec[i].transport_name; i++) {
	if (transRec[i].config_flag = (*transRec[i].config)(&transRec[i]))
	    ret = True;
    }
    return ret;
}

void
ExitTransport()
{
    register int i;

    for (i = 0; transRec[i].transport_name; i++)
	(*transRec[i].exit)(&transRec[i]);
    return;
}

Bool
GetTransportName(array, name)
    char	*array;
    char	*name;
{
    register int i;

    for (i = 0; transRec[i].transport_name; i++) {
	if (!strcmp(transRec[i].transport_name, name)) {
	    if (transRec[i].config_flag)
		return (*transRec[i].get_name)(&transRec[i], array);
	    else
		return False;
	}
    }
    return False;
}

Static Bool
_XimServerCheck(display, event, arg)
    Display	*display;
    XEvent	*event;
    XPointer	 arg;
{
    switch(event->type) {
    case Expose :
    case SelectionRequest:
    case KeyPress :
    case KeyRelease :
	return True;
    case DestroyNotify :
	if (event->xkey.window == root_client->window)
	    return True;
	break;
    }
    return False;
}

void
XimTransportCheck()
{
    register int  i;

    for (i = 0; transRec[i].transport_name; i++) {
	if (transRec[i].method.event_proc) {
	    (*transRec[i].method.event_proc)(&transRec[i]);
	}
    }
    return;
}
