.\" $Id: kterm.man,v 6.0 1994/06/04 15:44:00 kagotani Rel $
.\"
.\" Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993 and 1994
.\" XXI working group in Japan Unix Society (XXI).
.\"
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge, a
.\" full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.\" nonexclusive right and license to deal in this software and
.\" documentation files (the "Software"), including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons who receive
.\" copies from any such party to do so.  This license includes without
.\" limitation a license to do the foregoing actions under any patents of
.\" the party supplying this software to the X Consortium.
.\"
.TH KTERM 1 "4 June 1994" "X Version 11"
.SH NAME
kterm \- kanji terminal emulator for X
.SH SYNOPSIS
.B kterm
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The \fIkterm\fP program is a Kanji terminal emulator for the X Window System.
It provides DEC VT102 and Tektronix 4014 
compatible terminals for programs that can't
use the window system directly.
It comes from \fIxterm\fP in the core programs of the distribution of the
X Window System.
The most of the functions are the same as original \fIxterm\fP's, however,
it has capabilities of displaying Kanji strings and inputing them with
the \fIkinput\fP program if compiled with -DKTERM compile time option.
Also \fIkterm\fP supports handling of the status line
if compiled with -DSTATUSLINE option.
.PP
.SH OPTIONS
The \fIkterm\fP terminal emulator 
accepts all of the standard \fIxterm\fP command line options along with the 
additional options listed below (if the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value):
.TP 8
.BI \-version
Just displays the \fIkterm\fP version.
.TP 8
.BI \-fl " fontlist"
This option specifies fonts to be used.
\fIfontlist\fP is a argument expressed by XLFD with arbitrary wild-card.
\fIkterm\fP uses three fonts whose names have "-iso8859-1", "-jisx0201.1976-0"
and "-jisx0208.1983-0" as their tail.
.TP 8
.BI \-fn " iso8859/1-font"
This option specifies a normal ISO8859/1 font
to be used when displaying Latin-1 (including ASCII) text.
If it is not specified, search \fIfontlist\fP for it.
.TP 8
.BI \-fr " roman-kana-font"
This option specifies a normal JISX0201 font.
This font is used as JIS-Roman font if ``ESC ( J'' is appeared,
and used as Kana font if ``ESC ( I'' is appeared in JIS Kanji mode, SS2 (0x8e)
is appeared in EUC Kanji mode,
though Kana is not used so frequntly in normal Japanese text.
This font must have same height and width as the ISO8859/1 font.
If it is not specified, search \fIfontlist\fP for it.
.TP 8
.BI \-fk " kanji-font"
This option specifies a normal JISX0208 font
to be used when displaying Kanji text.  
This font must have same height and twice width as the ISO8859/1 font.
If it is not specified, search \fIfontlist\fP for it.
.TP
.BI \-flb " bold-fontlist"
.TP
.BI \-fb " bold-font"
.TP
.BI \-frb " roman-kana-bold-font"
.TP 8
.BI \-fkb " kanji-bold-font"
These options specify bold fonts.
.TP 8
.BI \-lsp " dots"
Because of large sizes of the Kanji fonts,
every user may not be allowed to have his own eye-friendly fonts.
This option specifies how much space to insert between every two lines.
.TP 8
.BI \-ka
This option indicates that \fIkterm\fP should connect to the X server
with KEEPALIVE socket option. It is usefull when the server is a X terminal
that is frequently powered off. This option is accepted only if \fIkterm\fP
has been compiled with -DKEEPALIVE compile option.
.TP 8
.BI \+ka
This option indicates that \fIkterm\fP should connect to the X server
without KEEPALIVE socket option.
.TP 8
.BI \-km " kanji-mode"
This option specifies the Kanji code from the pty output.
If kanji-mode is ``euc'', then it assumes the input/output is coded by EUC.
If kanji-mode is ``sjis'', then it assumes the input/output is coded by
Shift-JIS code (which is the same as MicroSoft Kanji code).
.TP 8
.B \-sn
By default, the status line is in reverse-video (relative to the rest of the
window).
This option causes the status line to be in normal video (the status line
is still enclosed in a box).
.TP 8
.B \-st
This option causes the status line to be displayed on startup.
.SH "X DEFAULTS"
The program understands all of the core \fIxterm\fP resource names and
classes as well as:
.TP 8
.B "fontList (\fPclass\fB FontList)"
Specifies the name of the fonts.
The default is ``-*-fixed-medium-r-normal--14-*''.
.TP 8
.B "boldFontList (\fPclass\fB FontList)"
Specifies the name of the bold fonts.
The default is not specified
.TP 8
.B "font (\fPclass\fB Font)"
Specifies the name of the Latin-1 font.  The default is not specified.
.TP 8
.B "boldFont (\fPclass\fB Font)"
Specifies the name of the bold Latin-1 font.  The default is not specified.
.TP 8
.B "romanKanaFont (\fPclass\fB RomanKanaFont)"
Specifies the name of the Roman-Kana font.  The default is not specified.
.TP 8
.B "romanKanaBoldFont (\fPclass\fB RomanKanaFont)"
Specifies the name of the bold font.  The default is not specified.
.TP 8
.B "kanjiFont (\fPclass\fB KanjiFont)"
Specifies the name of the Kanji font.  The default is not specified.
.TP 8
.B "kanjiBoldFont (\fPclass\fB KanjiFont)"
Specifies the name of the bold font.  The default is not specified.
.TP 8
.B "kanjiMode (\fPclass\fB KanjiMode)"
Specifies the Kanji code of pty output. The default is ``jis''.
.TP 8
.B "lineSpace (\fPclass\fB LineSpace)"
Specifies the space to insert between every two lines.
The default is ``0''.
.TP 8
.B "keepAlive (\fPclass\fB KeepAlive)"
Specifies whether or not \fIkterm\fP should connection to the X server
with KEEPALIVE socket option. The default is ``false.''
.TP 8
.B "statusLine (\fPclass\fB StatusLine)"
Causes the status line to be displayed on startup. The default is ``false.''
.TP 8
.B "statusNormal (\fPclass\fB StatusNormal)"
Specifies whether or not the status line should be in normal video.
The default is ``false.''
.TP 8
.B "forwardKeyEvent (\fPclass\fB ForwardKeyEvent)"
If false, key events are not forwarded to the conversion server.
This means that the server cannot receive key events if the keyboard
focus is set to \fIkterm\fP window but the pointer is on other windows.
However, on a slow network it may improve response time of the
conversion server. The default is ``true.''
.SH EMULATIONS
The VT102 emulation is fairly complete, but does not support the blinking
character attribute nor the double-wide and double-size character sets.
.IR Termcap (5)
entries that work with
.I kterm
include ``kterm'', ``xterm'', ``vt102'', ``vt100'' and ``ansi'', and
.I kterm
automatically searches the termcap file in this order for these entries and then
sets the ``TERM'' and the ``TERMCAP'' environment variables.
.SH "KANJI INPUT"
Kanji strings can be input with \fIkinput\fP command, which acts as
a Kanji conversion server.
By default, pressing control-Kanji key starts Kanji conversion.
You must run conversion server before this, or you will see 
`Conversion Server not found' warning message.
It is possible to rebind other keys to this action by changing
the translation table.
The default binding to begin conversion is:
.nf
.sp
	Ctrl<Key>Kanji:	begin-conversion(_JAPANESE_CONVERSION)
.sp
.fi
For further information (how to input/convert/correct text, etc.),
see the conversion server's document.
.SH "SEE ALSO"
xterm(1), resize(1), X(1), kinput(1), pty(4), tty(4)
.br
.I ``Xterm Control Sequences''
.SH BUGS
\fIkerm\fP assumes, like \fIxterm\fP, all characters in a font have same width.
Additionally, it also assumes that the width of Kanji characters is as twice as
that of ASCII characters.
.PP
This version of
.I kterm
uses ``ESC $ B'' to desigate the Kanji character set to paste Kanji text
to pty output in JIS mode.
There is no way to specify ``ESC $ ( B'' instead.
.SH AUTHORS
Far too many people, including:
.sp
Katsuya Sano (Toshiba Corp.),
Michael Irie (Sony Corp.),
Akira Kato (Keio Univ.),
Michiharu Ariza (Software Research Associates, Inc.),
Makoto Ishisone (Software Research Associates, Inc.),
Hiroto Kagotani (Tokyo Inst. of Tech.),
Susumu Mukawa (Nippon Telegraph and Telephone Corp.)
