.TH arecord
.SH NAME
arecord - An AF record client.
.SH SYNOPSIS
.B
arecord 
[\fB\-server\fP \fIaudioserver\fP] 
[\fB\-d\fP \fIdevice\fP] 
[\fB-l\fP \fIlength\fP] 
[\fB-t\fP \fItime\fP] 
[\fB-silentlevel\fP \fIlevel (dB)\fP] 
[\fB-silenttime\fP \fItime\fP] 
[\fB-printpower] 
[\fB-g\fP \fIgain\fP] 
[\fB-e\fP \fIencoding\fP] 
[\fB-B] 
[\fB-L] 
[\fIfile\fP]
.SH DDESCRIPTION
.PP
\fIarecord\fP reads samples from the audio server and writes the data to 
\fIfile\fP, or stdout if \fIfile\fP is not specified.  The file will be 
written in a sample format appropriate for the record device.
By default, the byte order of any 16 bit data will be that of
the host on which arecord is executing.
.SH OPTIONS
.TP
.B \-server \fIaudioserver\fP
.IP 
Specifies which audio server to connect to in order to record the sound 
file.
If \fIaudioserver\fP is not specified, \fIarecord\fP 
uses the default server.  See the AUDIOFILE environment variable.
.TP
.B \-d \fIdevice\fP
.IP 
Specifies which audio device to record the sound file from.
If \fIdevice\fP is not specified, \fIarecord\fP 
defaults to the first device that isn't connected to the telephone.
.TP
.B \-l \fIlength\fP
.IP
\fIlength\fP of sound data to record, specified in seconds.
.TP
.B \-silentlevel \fIlevel\fP
.IP
\fIlevel\fP (in dBm) below which the sound is deemed to be silent.
The default value is -60
.TP
.B \-silenttime \fItime\fP
.IP
\fItime\fP (in seconds) of silence which will terminate the recording.
The default value is 3.0.
.IP
If either -silentlevel or -silenttime is set, then arecord will terminate
recording after so many seconds of "silence".
.TP
.B \-e \fencoding\fP
.IP
\fIencoding\fP will specify the type of the data to be written to the file
or standard output.  Legal values are described in the audio.h
header file, and may be obtained via arecord -e xxx.  The -e flag simply
informs the AF server of the datatype. Some encodings may fail if they
are not supported by the AF server.  See also aconvert(1).
.TP
.B \-g \fIgain\fP
.IP
A \fIgain\fP in dB can be used to attenuate or amplify the sound
data prior to recording from the audio server.  Many AF servers do not
support client gain on record, so use with suspicion.
.TP
.B \-printpower
.IP
Print input power level in dBm on stderr every block (8 times a second).
.TP
.B \-B
.IP
Specifies that for 16 bit data, the bytes are in "Big Endian" byte order
(e.g. Sparc, RIOS, PA).
.TP
.B \-L
.IP
Specifies that for 16 bit data, the bytes are in "Little Endian" byte order
(e.g. Alpha, Intel x86, VAX).
.TP
.B \-t \fItime\fP
.IP
\fItime\fP can be used to adjust the audio device time at which the 
the \fIarecord\fP client begins to record the sound data.
A positive value of \fItime\fP will begin recording \fItime\fP seconds
in the future.
If \fItime\fP is negative, sound data will be returned from
\fItime\fP seconds in the past. 
If the \fItime\fP offset begins earlier than the start of the recording
buffer, silence will be returned.  Defaults to 0.125 seconds.
.TP
.B \fIfile\fP
.IP
\fIarecord\fP writes data to \fIfile\fP in the current working
directory
.SH ENVIRONMENT
.TP 15
.B AUDIOFILE
specifies the host and server to use.
.SH BUGS
If you encounter a \fBreproducible\fP bug, please submit a problem report to
(af-bugs@crl.dec.com).
.SH "SEE ALSO"
AF(1), aplay(1)
.SH COPYRIGHT
Copyright 1992-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Digital Cambridge Research Lab
