.\" $Header: /users/npm/src/widgit/doc/RCS/wl-tcpip.man,v 2.6 1994/07/23 23:21:52 npm Exp $
.\" Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
.\" WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
.\" WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Enterprise Integration Technologies,
.\" Hewlett-Packard Company, or Niels Mayer not be used in advertising or
.\" publicity pertaining to distribution of the software without specific,
.\" written prior permission. Enterprise Integration Technologies, Hewlett-Packard
.\" Company, and Niels Mayer makes no representations about the suitability of
.\" this software for any purpose.  It is provided "as is" without express or
.\" implied warranty.
.\" 
.\" ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
.\" INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
.\" FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
.\" RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
.\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"  
.TH WL\-TCPIP 1 "June 6, 1994" "X11r6 contrib"
.SH NAME
WL-TCPIP - Winterp-Lisp client for communicating with WINTERP INET-Domain Eval-Server.
.SH SYNOPSIS
.B wl\-tcpip
[\fB\-h <hostname>\fP]
[\fB\-p <port>\fP]
[\fB<s\-expr>\fP]
.SH DESCRIPTION

\-\-\->> FOR DETAILS ON WINTERP SEE /usr/local/winterp/doc/winterp.doc <<\-\-\-
.PP
The WINTERP client program 
.I wl\-tcpip
(stands for Winterp\-Lisp) sends the
XLISP expression given on its command line to the WINTERP inet\-domain
server. 
.I wl\-tcpip
hangs until WINTERP has evaluated the s\-expression given
on 
.I wl\-tcpip's
command\-line. After the s\-expression is successfully
evaluated by WINTERP, 
.I wl\-tcpip
prints to stdout the results of the
evaluation, and sets exit status 0.  If an evaluation error occurs, an
error messsage is output to stderr, and exit status gets set to 127.
.PP
By default, WINTERP compiles without the INET\-Domain eval server
capability. One may enable the TCP/IP socket capability by recompiling
WINTERP with the line "#define WINTERP_WANT_INET_SERVER" added to
../src\-server/config.h, or by setting "WANT_INET_SERVER=
\-DWINTERP_WANT_INET_SERVER" in the appropriate makefiles. Even when WINTERP
is compiled with this option, the TCP/IP socket will not be enabled by
default. This socket may be enabled/disabled via a command line options
<<\-no_inet_server>> <<\-enable_inet_server>> or by setting X resource
<<Winterp.enableInetServer>>. Note that the TCP/IP client program,
.I wl\-tcpip,
is not compiled by default because most WINTERP
installations don't need it.
.PP
The reason for disabling the TCP/IP socket is due to reasons of
security. If you run WINTERP on a known port number, without any security
precautions (see inetd.sec(4)), you are giving people open access to your
account \-\- for example, others users will be able to execute programs on
your account through the SYSTEM, POPEN, EXP_SPAWN, and EXP_POPEN
primitives.
.PP
By default, the program 
.I wl\-tcpip
attempts to connect to the
WINTERP server through your machine's loopback address, which it
assumes is 127.0.0.1. If that is not your loopback address (isn't
that IP address standard??), then you may have to specify
'localhost' or the hostname of your machine. 
.I wl\-tcpip
will be
able to connect to the WINTERP server more quickly if it can get an IP
address without having to do a gethostbyname(). That's why I hardcoded the
loopback address into wl\-tcpip.c... (If this lookup is too slow, and you
are running 
.I winterp
and 
.I wl\-tcpip
locally, you may prefer using the Unix
Domain Socket server and 
.I wl.
)
.PP
.I wl\-tcpip
will "hang" waiting for WINTERP to finish the evaluation.
When the evaluation completes, 
.I wl\-tcpip
prints the results of the
evaluation to stdout, and returns exit status 0.  If an error occurs in
evaluation, an exit status of 128 is returned and the following is printed
to stderr:
.PP
	"wl\-tcpip: an evaluation error occured in WINTERP server."
.PP
Finally, if some other error occurs, e.g. network error, unable to bind
socket, etc, then exit status of 1 is returned and an eror message will
appear on stderr.
.PP
If evaluation via 
.I wl\-tcpip
causes an error and *BREAKENABLE* is set
(including by selecting "Error Break\-Loop" or "Error Trace\-Back" in the
"WINTERP Control Panel), then 
.I wl\-tcpip
will hang until the break\-loop
exits, typically because the user has invoked functions
'clean\-up', 'top\-level', or 'continue', or typed Control\-C or
Control\-D into WINTERP's controlling terminal.
.PP
Example: invoking the following in a UN*X command shell:
.PP
			wl\-tcpip '(load "rc\-shell")'
.PP
while there is a WINTERP running with an inet domain socket enabled, will
cause WINTERP to load the file "rc\-shell" and pop up the widgetry
associated with loading that file.
.PP
NOTE\-0: 
.I wl\-tcpip
is not compiled in the WINTERP distribution by
default \-\- cd <winterp\-top\-dir>/src\-client/ and do
"cc \-O \-o wl\-tcpip wl\-tcpip.c" to compile it. Likewise, the

.I winterp
binary itself does not compile with the TCP/IP server
feature. To get the TCP/IP server, you must recompile WINTERP after
setting "#define WINTERP_WANT_INET_SERVER" in 
./../src\-server/config.h, or you should set 
"WANT_INET_SERVER= \-DWINTERP_WANT_INET_SERVER" in the appropriate
makefiles. after recompilation run 
.I winterp
with the resource
"Winterp.enableInetServer: true".
.PP
NOTE\-1: By default, 
.I wl\-tcpip
uses the IP address 127.0.0.1 as the
hostname. This is the standard "loopback" or localhost address on
all UN*X machines I've worked with. If your setup defines hostname
"localhost" as a different I.P. address, you may need to specify
'localhost' or `hostname` as <hostname>. You may see significant
speed increases in 
.I wl\-tcpip
by replacing "127.0.0.1" in
./../src\-server/config.h with the appropriate IP address and
recompiling 'wl\-tcpip.c' \-\- hostname lookup on some machines can be
slow. If you are really concerned about the speed of making local
connections, between 
.I winterp
and 
.I wl\-tcpip
, you should consider using
.I wl.
.SH OPTIONS

.BI [\-h <hostname>]

The optional <hostname> argument allows you to specify the host
upon which the WINTERP's eval\-server is running. By default,
.I wl\-tcpip
attempts to connect to a WINTERP server running at IP
address 127.0.0.1. See the note above for further details.  The hostname
may also be specified by setting environment variable
WINTERP_INET_HOSTNAME.

.BI [\-p <port>]	

The optional <port> argument specifies a different port number for
WINTERP's eval\-server. The default is 23751; you may want to change the
default (along with WINTERP's "Winterp.servicePort" resource) if 23751 is
already defined in /etc/services. You will also need to change <port> if
you are running multiple instances of WINTERP on the same machine. You may
"simultaneously" set the <port> argument for 
.I wl\-tcpip
as well as
<<Winterp.servicePort>> resource in 
.I winterp
by setting environment
variable WINTERP_INET_PORTNUM to the desired port number.

.BI [<s\-expr>]

The <s\-expr> argument is a single Lisp s\-expression to be sent to
WINTERP's Lisp listener. If no <s\-expr> argument is given, 
.I wl\-tcpip
sends an
EOF (==Control\-D) to XLISP, which causes WINTERP to terminate. Note that
the <s\-expr> must be quoted with ['] so that the shell does not attempt to
interpret the parentheses as shell commands.
.SH AVAILABILITY:
You may obtain the latest released version of the WINTERP source,
documentation, and examples via anonymous ftp from internet host ftp.x.org
in directory /contrib/devel_tools, file winterp\-2.xx.tar.gz, where 'xx'
represents the revision number. Directory /contrib/devel_tools/winterp
contains slides, papers, further documentation, contributed code, etc.
.PP
An automated reply indicating the locations and status of the latest
WINTERP source may be obtained by sending an e\-mail message to
winterp\-source@netcom.com.
.SH CONTACTING OTHER USERS
winterp@netcom.com is the mailing list for WINTERP\-related announcements
and discussions. To get added/removed from the list, send mail to
winterp\-request@netcom.com. Please do not send junk mail or
subscribe/unsubscribe messages to the mailing list winterp@netcom.com.
.PP
For discussions about XLISP, see the USENET newsgroup comp.lang.lisp.x.
.SH SEE ALSO
winterp(1), wl\-tcpip(1), http://www.eit.com/software/winterp/winterp.html .
.SH FILES
127.0.0.1 (default address -- localhost);

$WINTERP_INET_HOSTNAME (environment variable specifying hostname);

widget_interp (default service name if port number 0);

23751 (default port number);

$WINTERP_INET_PORTNUM (environment variable specifying port number).

.SH AUTHOR
Niels Mayer (mayer@netcom.com) (http://www.eit.com/people/mayer.html)
