/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Ximd/IMdkit.h>
#include <X11/Ximd/Xi18n.h>

#define DEFAULT_IMNAME "sampleIM"
#define DEFAULT_LOCALE "ja_JP"
#define DEFAULT_LOCALE "ja_JP"

static XIMStyle Styles[] = {
    XIMPreeditPosition|XIMStatusArea,
    XIMPreeditPosition|XIMStatusNothing,
    XIMPreeditArea|XIMStatusArea,
    XIMPreeditNothing|XIMStatusNothing,
    0
};

static XIMTriggerKey OnKeys[] = {
    {XK_space, ShiftMask, ShiftMask},
    {0L, 0L, 0L}
};

static XIMTriggerKey OffKeys[] = {
    {XK_space, ControlMask, ControlMask},
    {0L, 0L, 0L}
};

static XIMEncoding jaEncodings[] = {
    "COMPOUND_TEXT",
    "eucJP",
    "SJIS",
    NULL
};

static XIMEncoding zhEncodings[] = {
    "COMPOUND_TEXT",
    "eucTW",
    NULL
};

MyGetICValuesHandler(ims, call_data)
XIMS ims;
IMChangeICCallbackStruct *call_data;
{
    GetIC(call_data);
    return True;
}

MySetICValuesHandler(ims, call_data)
XIMS ims;
IMChangeICCallbackStruct *call_data;
{
    SetIC(call_data);
    return True;
}

MyCreateICHandler(ims, call_data)
XIMS ims;
IMChangeICCallbackStruct *call_data;
{
    CreateIC(call_data);
    return True;
}

MyForwardEventHandler(ims, call_data)
XIMS ims;
IMForwardEventCallbackStruct *call_data;
{
    /* only forwarding back */
    if (call_data->event.type == KeyPress)
      IMForwardEvent(ims, call_data);

    return True;
}

MyProtoHandler(ims, call_data)
XIMS ims;
IMProtocol *call_data;
{
    switch (call_data->major_code) {
      case XIM_CREATE_IC:
	MyCreateICHandler(ims, call_data);
	break;
      case XIM_DESTROY_IC:
	break;
      case XIM_SET_IC_VALUES:
	MySetICValuesHandler(ims, call_data);
	break;
      case XIM_GET_IC_VALUES:
	MyGetICValuesHandler(ims, call_data);
	break;
      case XIM_FORWARD_EVENT:
	MyForwardEventHandler(ims, call_data);
	break;
      case XIM_SET_IC_FOCUS:
      case XIM_UNSET_IC_FOCUS:
      case XIM_RESET_IC:
      case XIM_PREEDIT_START_REPLY:
      case XIM_PREEDIT_CARET_REPLY:
	break;
    }
}

MyXEventHandler(ims, event)
XIMS ims;
XEvent *event;
{
    switch (event->type) {
      case DestroyNotify:
	break;
      default:
	break;
    }
}

main(argc, argv)
int argc;
char **argv;
{
    char *display_name = NULL;
    Display *dpy;
    char *imname = NULL;
    XIMS ims;
    XIMStyles *input_styles, *styles2;
    XIMTriggerKeys *on_keys, *off_keys, *trigger2;
    XIMEncodings *encodings, *encoding2;
    Window im_window;
    register int i;
    Bool use_trigger = True;	/* Dynamic Event Flow is default */
    Bool use_tcp = False;	/* Using TCP/IP Transport or not */
    Bool use_local = False;	/* Using Unix domain Tranport or not */
    long filter_mask = KeyPressMask;
    char transport[80];		/* enough */

    for (i = 1; i < argc; i++) {
	if (!strcmp(argv[i], "-name")) {
	    imname = argv[++i];
	} else if (!strcmp(argv[i], "-display")) {
	    display_name = argv[++i];
	} else if (!strcmp(argv[i], "-dynamic")) {
	    use_trigger = True;
	} else if (!strcmp(argv[i], "-static")) {
	    use_trigger = False;
	} else if (!strcmp(argv[i], "-tcp")) {
	    use_tcp = True;
	} else if (!strcmp(argv[i], "-local")) {
	    use_local = True;
	} else if (!strcmp(argv[i], "-kl")) {
	    filter_mask = (KeyPressMask|KeyReleaseMask);
	}
    }
    if (!imname) imname = DEFAULT_IMNAME;

    if ((dpy = XOpenDisplay(display_name)) == NULL) {
	fprintf(stderr, "Can't Open Display: %s\n", display_name);
	exit(1);
    }
    im_window = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy),
				    0, 0, 1, 1, 1, 0, 0);
    if (im_window == (Window)NULL) {
	fprintf(stderr, "Can't Create Window\n");
	exit(1);
    }

    if ((input_styles = (XIMStyles *)malloc(sizeof(XIMStyles))) == NULL) {
	fprintf(stderr, "Can't allocate\n");
	exit(1);
    }
    input_styles->count_styles = sizeof(Styles)/sizeof(XIMStyle) - 1;
    input_styles->supported_styles = Styles;

    if ((on_keys = (XIMTriggerKeys *)
	 malloc(sizeof(XIMTriggerKeys))) == NULL) {
	fprintf(stderr, "Can't allocate\n");
	exit(1);
    }
    on_keys->count_keys = sizeof(OnKeys)/sizeof(XIMTriggerKey) - 1;
    on_keys->keylist = OnKeys;

    if ((off_keys = (XIMTriggerKeys *)
	 malloc(sizeof(XIMTriggerKeys))) == NULL) {
	fprintf(stderr, "Can't allocate\n");
	exit(1);
    }
    off_keys->count_keys = sizeof(OnKeys)/sizeof(XIMTriggerKey) - 1;
    off_keys->keylist = OnKeys;

    if ((encodings = (XIMEncodings *)malloc(sizeof(XIMEncodings))) == NULL) {
	fprintf(stderr, "Can't allocate\n");
	exit(1);
    }
    encodings->count_encodings = sizeof(jaEncodings)/sizeof(XIMEncoding) - 1;
    encodings->supported_encodings = jaEncodings;

    if (use_local) {
	char hostname[64];
	char *address = "/tmp/.ximsock";

	gethostname(hostname, 64);
	sprintf(transport, "local/%s:%s", hostname, address);
    } else if (use_tcp) {
	char hostname[64];
	int port_number = 9010;

	gethostname(hostname, 64);
	sprintf(transport, "tcp/%s:%d", hostname, port_number);
    } else {
	strcpy(transport, "X/");
    }

    ims = IMOpenIM(dpy,
		   IMModifiers, "Xi18n",
		   IMServerWindow, im_window,
		   IMServerName, imname,
		   IMLocale, DEFAULT_LOCALE,
		   IMServerTransport, transport,
		   IMInputStyles, input_styles,
		   NULL);
    if (ims == (XIMS)NULL) {
	fprintf(stderr, "Can't Open Input Method Service:\n");
	fprintf(stderr, "\tInput Method Name :%s\n", imname);
	fprintf(stderr, "\tTranport Address:%s\n", transport);
	exit(1);
    }
    if (use_trigger) {
	IMSetIMValues(ims,
		      IMOnKeysList, on_keys,
		      IMOffKeysList, off_keys,
		      NULL);
    }
    IMSetIMValues(ims,
		  IMEncodingList, encodings,
		  IMProtocolHandler, MyProtoHandler,
		  IMXEventHandler, MyXEventHandler,
		  IMFilterEventMask, filter_mask,
		  NULL);
    IMGetIMValues(ims,
		  IMInputStyles, &styles2,
		  IMOnKeysList, &trigger2,
		  IMOffKeysList, &trigger2,
		  IMEncodingList, &encoding2,
		  NULL);
    XSelectInput(dpy, im_window, StructureNotifyMask|ButtonPressMask);
    XMapWindow(dpy, im_window);
    XFlush(dpy);		/* necessary flush for tcp/ip connection */

    IMMainLoop();
}
