/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <stdio.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include "IMdkit.h"
#include "IMdEv.h"

static IMInputEvent *input_list  = (IMInputEvent *)NULL;
static int nfds = 0;
static Fd_set rmask_fd = {0};
static int max_fd = 0;

#if NeedFunctionPrototypes
void _IMAddInput(
	Display *dpy,
	int fd,
	CallbackProc proc,
	XPointer closure)
#else
void _IMAddInput(dpy, fd, proc, closure)
	Display *dpy;
	int fd;
	CallbackProc proc;
	XPointer closure;
#endif
{
    IMInputEvent sptr;

    if (fd < 0 || fd > (NOFILE - 1)) return;

    if (input_list == (IMInputEvent *)NULL) {
	input_list = (IMInputEvent *)malloc(sizeof(IMInputEvent) * NOFILE);
	if (input_list == NULL) return;
	memset(input_list, 0, sizeof(IMInputEvent) * NOFILE);
    }

    if ((sptr = (IMInputEvent)malloc(sizeof(IMInputEventRec))) == NULL)
      return;

    sptr->proc = proc;

    sptr->closure = closure;
    sptr->source = fd;
    input_list[fd] = sptr;

    FD_SET(fd, &rmask_fd);

    if (nfds < (fd + 1)) nfds = fd + 1;

    if (max_fd < fd)
      max_fd = fd;

    return;
}

#if NeedFunctionPrototypes
_IMRemoveInput(
	Display *dpy,
	int source)
#else
_IMRemoveInput(dpy, source)
	Display *dpy;
	int source;
#endif
{
    if (input_list[source]->source == source) {
	FD_CLR(source, &rmask_fd);
	XFree((char *)input_list[source]);
	close(source);
    }
}

#define TIMEOUT_SEC      5L
#define TIMEOUT_USEC     0L

void
IMNextEvent()
{
    int nfound;
    int i;
    struct timeval timeout;

    timeout.tv_sec  = TIMEOUT_SEC;
    timeout.tv_usec = TIMEOUT_USEC;

    for (;;) {
	Fd_set select_mask;
	int eventCount;

	select_mask = rmask_fd;
	if ((nfound = select(nfds, (int *)&select_mask,
			     NULL, NULL, &timeout)) == -1) {
	    if (errno == EINTR)
	      continue;
	    else
	      break;
	}
	eventCount = 1;
	while (eventCount) {
	    eventCount = 0;
	    for (i = 0; i < max_fd + 1; i++) {
		if (input_list[i]
		    && FD_ISSET(input_list[i]->source, &select_mask)) {
		    eventCount += input_list[i]->proc(input_list[i]->closure,
						      input_list[i]->source);
		}
	    }
	}
    }
}
IMMainLoop()
{
    for (;;) {
	IMNextEvent();
    }
}
