/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#ifndef _IMdEv_h
#define _IMdEv_h

#ifdef	AIXV3
#include <sys/select.h>
#endif

#ifdef FUJITSU_SXG
typedef	long		fd_mask;
#define NBBY		8
#define	FD_SETSIZE	1024
#define NFDBITS		(sizeof(fd_mask) * NBBY)        
#ifndef howmany
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif
typedef struct fd_set {
    fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;
#endif

typedef int (*CallbackProc)(
#if NeedFunctionPrototypes
	XPointer, int
#endif
);

typedef struct _IMInputEventRec {
    CallbackProc proc;
    XPointer	closure;
    int		source;
} IMInputEventRec, *IMInputEvent;

typedef long Fd_mask;
typedef	struct _Fd_set {
    Fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} Fd_set;

#define	NBBY	8		/* number of bits in a byte */
#undef NFDBITS
#define NFDBITS	(sizeof(Fd_mask) * NBBY)	/* bits per mask */

#ifndef FD_SET
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#endif

#ifndef FD_CLR
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#endif

#ifndef FD_ISSET
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#endif

extern void _IMAddInput(
#if NeedFunctionPrototypes
	Display *, int, CallbackProc, XPointer
#endif
);

extern int _IMRemoveInput(
#if NeedFunctionPrototypes
	Display *, int
#endif
);

extern void IMNextEvent(
#if NeedFunctionPrototypes
#endif
);

extern int IMMainLoop(
#if NeedFunctionPrototypes
#endif
);

#endif /* IMdEv_h */
