/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#ifndef _Xi18n_h
#define _Xi18n_h
#include <X11/Xlib.h>
#include <X11/Xfuncs.h>
#include <X11/Xos.h>
#ifndef XIM_USE_XPROTOCOL
#define XIM_USE_XPROTOCOL
#include "XimProto.h"
/*
 * Minor Protocol number
 */
#define XIM_EXTENSION		92
#define XIM_MINOR_OPCODE_CORE			(       0x00)
#define XIM_EXT_SET_EVENT_MASK			(       0x30)
#define	XIM_EXT_FORWARD_KEYEVENT		(       0x32)
#define	XIM_EXT_MOVE				(       0x33)
#define	XIM_EXT_COMMIT				(       0x34)
#undef  XIM_USE_XPROTOCOL
#endif	/* XIM_USE_XPROTOCOL */
#include <stdlib.h>
#include "IMdkit.h"

/*
 * Padding macro
 */
#define	IMPAD(length) ((4 - ((length) % 4)) % 4)

/*
 * Target Atom for Transport Connection
 */
#define LOCALES		"LOCALES"
#define TRANSPORT	"TRANSPORT"

#define I18N_OPEN	0
#define I18N_SET	1
#define I18N_GET	2

typedef struct {
    char *transportname;
    int   namelen;
    Bool (*checkAddr)();
} TransportSW;

typedef struct _XIMPending {
    unsigned char *p;
    struct _XIMPending *next;
} XIMPending;

typedef struct _XimProtoHdr {
    CARD8	major_opcode;
    CARD8	minor_opcode;
    CARD16	length;
} XimProtoHdr;

typedef struct {
    CARD16	attribute_id;
    CARD16	type;
    CARD16	length;
    char	*name;
} XIMAttr;

typedef struct {
    CARD16	attribute_id;
    CARD16	type;
    CARD16	length;
    char	*name;
} XICAttr;

typedef struct {
    int		attribute_id;
    CARD16	name_length; 
    char	*name;
    int		value_length;
    void	*value;
    int		type;
} XIMAttribute;

typedef struct {
    int		attribute_id;
    CARD16	name_length;
    char	*name;
    int		value_length;
    void	*value;
    int		type;
} XICAttribute;

typedef struct {
    int		length;
    char	*name;
} XIMStr;

typedef struct {
    CARD16	ext_major_opcode;
    CARD16	ext_minor_opcode;
    CARD16	length;
    char	*name;
} XIMExt;

typedef struct _Xi18nClient {
    int		connect_id;
    int		sync;
    XIMPending  *pending;
    struct _Xi18nClient *next;
    void *spec;
} Xi18nClient;

typedef struct _Xi18nCore *Xi18n;

/*
 * Callback Struct for XIM Protocol
 */
typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
} IMAnyCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD8	byte_order;
    CARD16	major_version;
    CARD16	minor_version;
} IMConnectCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
} IMDisConnectCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    XIMStr	lang;
} IMOpenCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
} IMCloseCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	number;
    XIMStr	*extension;
} IMQueryExtensionCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	number;
    char	**im_attr_list;
} IMGetIMValuesCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD16	preedit_attr_num;
    CARD16	status_attr_num;
    CARD16	ic_attr_num;
    XICAttribute *preedit_attr;
    XICAttribute *status_attr;
    XICAttribute *ic_attr;
} IMChangeICCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
} IMDestroyICCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD16	length;
    char	*commit_string;
} IMResetICCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
} IMChangeFocusCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    BITMASK16	sync_bit;
    CARD16	serial_number;
    XEvent	event;
} IMForwardEventCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD16	flag;
    CARD16	str_length;
    char	*commit_string;
    CARD16	keysym_num;
    KeySym	*keysym_list;
} IMCommitCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD32	flag;
    CARD32	key_index;
    CARD32	event_mask;
} IMTriggerNotifyCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	encoding_number;
    XIMStr	*encoding;	/* name information */
    CARD16	encoding_info_number;
    XIMStr	*encodinginfo;	/* detailed information */
    CARD16	category;	/* #0 for name, #1 for detail */
    INT16	enc_index;	/* index of the encoding determined */
} IMEncodingNegotiationCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD32	flag;
    CARD32	forward_event_mask;
    CARD32	sync_event_mask;
} IMSetEventMaskCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD32	flag;
    CARD32	intercept_event_mask;
    CARD32	select_event_mask;
    CARD32	forward_event_mask;
    CARD32	sync_event_mask;
} IMExtSetEventMaskCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD16	x;
    CARD16	y;
} IMExtMoveCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    CARD8	type;
    CARD8	keycode;
    CARD16	state;
    CARD32	ev_time;
} IMExtForwardKeyEventCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    BITMASK16	flag;
    CARD16	error_code;
    CARD16	str_length;
    CARD16	error_type;
    char	*error_detail;
} IMErrorCallbackStruct;

/* Callbacks */
typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
} IMGeometryCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    union {
	XIMPreeditDrawCallbackStruct draw;
	XIMPreeditCaretCallbackStruct caret;
    } todo;
} IMPreeditCallbackStruct;

typedef struct {
    int		major_code;
    int		minor_code;
    CARD16	connect_id;
    CARD16	input_method_ID;
    CARD16	icid;
    union {
	XIMStatusDrawCallbackStruct draw;
    } todo;
} IMStatusCallbackStruct;

typedef union _IMProtocol {
    int	major_code;
    IMAnyCallbackStruct any;
    IMConnectCallbackStruct imconnect;
    IMDisConnectCallbackStruct imdisconnect;
    IMOpenCallbackStruct imopen;
    IMCloseCallbackStruct imclose;
    IMQueryExtensionCallbackStruct queryext;
    IMGetIMValuesCallbackStruct getim;
    IMEncodingNegotiationCallbackStruct encodingnego;
    IMExtSetEventMaskCallbackStruct extsetevent;
    IMExtForwardKeyEventCallbackStruct extforward;
    IMExtMoveCallbackStruct extmove;
    IMSetEventMaskCallbackStruct setevent;
    IMChangeICCallbackStruct changeic;
    IMDestroyICCallbackStruct destroyic;
    IMResetICCallbackStruct resetic;
    IMChangeFocusCallbackStruct changefocus;
    IMCommitCallbackStruct commitstring;
    IMForwardEventCallbackStruct forwardevent;
    IMTriggerNotifyCallbackStruct triggernotify;
    IMErrorCallbackStruct imerror;
    IMGeometryCallbackStruct geometry_callback;
    IMPreeditCallbackStruct preedit_callback;
    IMStatusCallbackStruct status_callback;
    long pad[32];
} IMProtocol;

typedef int (*IMProtoHandler)(
#if NeedFunctionPrototypes
    XIMS,
    IMProtocol*
#endif
);

#define I18N_IMSERVER_WIN	0x0001 /* IMServerWindow */
#define I18N_IM_NAME		0x0002 /* IMServerName */
#define I18N_IM_LOCALE		0x0004 /* IMLocale */
#define I18N_IM_ADDRESS		0x0008 /* IMServerTransport */
#define I18N_INPUT_STYLES	0x0010 /* IMInputStyles */
#define I18N_ON_KEYS		0x0020 /* IMOnKeysList */
#define I18N_OFF_KEYS		0x0040 /* IMOffKeysList */
#define I18N_IM_HANDLER		0x0080 /* IMProtocolHander */
#define I18N_ENCODINGS		0x0100 /* IMEncodingList */
#define I18N_FILTERMASK		0x0200 /* IMFilterEventMask */

#define DEFAULT_FILTER_MASK	(KeyPressMask)
/* Xi18nAddressRec structure */
typedef struct _Xi18nAddressRec {
    Display	*dpy;
    CARD16	input_method_id;
    CARD8	im_byteOrder;	/* byte order 'B' or 'l' */
    /* IM Values */
    long	imvalue_mask;
    Window	im_window;	/* IMServerWindow */
    char	*im_name;	/* IMServerName */
    char	*im_locale;	/* IMLocale */
    char	*im_addr;	/* IMServerTransport */
    XIMStyles	*input_styles;	/* IMInputStyles */
    XIMTriggerKeys *on_keys;	/* IMOnKeysList */
    XIMTriggerKeys *off_keys;	/* IMOffKeysList */
    XIMEncodings *encoding_list; /* IMEncodingList */
    IMProtoHandler improto;	/* IMProtocolHander */
    long	filterevent_mask; /* IMFilterEventMask */
    /* XIM_SERVERS target Atoms */
    Atom	selection;
    Atom	Localename;
    Atom	Transportname;
    /* XIM/XIC Attr */
    int		im_attr_num;
    XIMAttr	*xim_attr;
    int		ic_attr_num;
    XICAttr	*xic_attr;
    CARD16	preeditAttr_id;
    CARD16	statusAttr_id;
    CARD16	separatorAttr_id;
    /* XIMExtension List */
    int		ext_num;
    XIMExt	*extension;
    /* transport specific data */
    void	*spec;
} Xi18nAddressRec;

typedef struct _XIMSMethodsRec {
    Bool (*begin)(
#if NeedFunctionPrototypes
	XIMS
#endif
		  );
    Bool (*end)(
#if NeedFunctionPrototypes
	XIMS
#endif
		);
    Bool (*send)(
#if NeedFunctionPrototypes
	XIMS, CARD16, unsigned char*, long
#endif
		 );
    Bool (*wait)(
#if NeedFunctionPrototypes
	XIMS, CARD16, CARD8, CARD8
#endif
		 );
    Bool (*disconnect)(
#if NeedFunctionPrototypes
	XIMS, CARD16
#endif
		 );
} Xi18nMethodsRec;

typedef struct _Xi18nCore {
    Xi18nAddressRec address;
    Xi18nMethodsRec methods;
} Xi18nCore;

extern void *xi18n_setup(
#if NeedFunctionPrototypes
   Display* /* dpy */,
   XIMArg*  /* args */
#endif
);

extern Status xi18n_openIM(
#if NeedFunctionPrototypes
   XIMS
#endif
);

extern Status xi18n_closeIM(
#if NeedFunctionPrototypes
   XIMS
#endif
);

extern char *xi18n_setIMValues(
#if NeedFunctionPrototypes
   XIMS,
   XIMArg*
#endif
);

extern char *xi18n_getIMValues(
#if NeedFunctionPrototypes
   XIMS,
   XIMArg*
#endif
);

extern Status xi18n_sendkeys(
#if NeedFunctionPrototypes
   XIMS,
   IMForwardEventCallbackStruct *
#endif
);

extern Status xi18n_commit(
#if NeedFunctionPrototypes
   XIMS,
   IMCommitCallbackStruct *
#endif
);

extern Status xi18n_callCallback(
#if NeedFunctionPrototypes
   XIMS,
   IMProtocol *
#endif
);

extern Status xi18n_wait(
#if NeedFunctionPrototypes
   XIMS,
   IMProtocol *
#endif
);

#endif /* _Xi18n_h */
