/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company
         Copyright 1993, 1994 by Digital Equipment Corporation

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY AND DIGITAL EQUIPMENT CORPORATION DISCLAIM ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
HEWLETT-PACKARD COMPANY AND DIGITAL EQUIPMENT CORPORATION BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#ifndef _Xi18nTrDnet_h
#define _Xi18nTrDnet_h

typedef struct _DnetClient {
    CARD16	connection_id;
    int		accept_fd;
    CARD8	byte_order;
				/* 'B' for Big-Endian */
				/* 'l' for little-Endian */
				/* '?': initial value */
    struct _DnetClient	*next;
} DnetClient;

typedef struct {
    char	 *nodename;
    char	 *objname;
    int		 listen;
    Bool	 is_registered; /* True if listen is registered */
#ifdef FD_SETSIZE
    fd_set	 fdset;
#else
    unsigned long fdset;
#endif
    DnetClient	*clients;
    DnetClient	*freeclients;
} DnetSpecRec;

#ifndef FD_SET		/* 4.2BSD base */
#define FD_SET(n, p)	(*(p) |= (1 << (n)))
#define FD_CLR(n, p)	(*(p) &= ~(1 << (n)))
#define FD_ISSET(n, p)	(*(p) & (1 << (n)))
#define FD_ZERO(p)	(*(p) = 0)
#endif

#define SERVICE_NAME "imdk"
#define DEFAULT_OBJNAME "XIMS$DEFAULT"

extern Bool _xi18n_DnetBegin(
#if NeedFunctionPrototypes
	XIMS
#endif
);

extern Bool _xi18n_DnetEnd(
#if NeedFunctionPrototypes
	XIMS
#endif
);

extern Bool _xi18n_DnetSend(
#if NeedFunctionPrototypes
	XIMS,
	CARD16 ,
	unsigned char* ,
	long
#endif
);

extern Bool _xi18n_DnetWait(
#if NeedFunctionPrototypes
	XIMS,
	CARD16,
	CARD8,
	CARD8
#endif
);

#endif /* Xi18nTrDnet_h */
