/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <X11/Xlib.h>
#include "IMdkit.h"
#include "Xi18n.h"
#include "FrameMgr.h"

int _xi18n_GeometryCallback(ims, call_data)
XIMS ims;
IMProtocol *call_data;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec geometry_fr[];
    register int total_size;
    unsigned char *reply = NULL;
    IMGeometryCallbackStruct *geometry_CB =
      (IMGeometryCallbackStruct*)&call_data->geometry_callback;
    CARD16 connect_id = call_data->any.connect_id;

    /* create FrameMgr */
    fm = FrameMgrInit(geometry_fr, NULL,
		      Need_Swap(i18n_core, connect_id));

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *) malloc(total_size);
    if (!reply) {
	_xi18n_SendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, geometry_CB->input_method_ID);
    FrameMgrPutToken(fm, geometry_CB->icid);

    _xi18n_SendMessage(ims, connect_id,
		       XIM_GEOMETRY, 0, reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);

    /* This is an asyncronous protocol, so return immediately */
    return 0;
}

int _xi18n_PreeditStartCallback(ims, call_data)
XIMS ims;
IMPreeditCallbackStruct *call_data;
{
}

int _xi18n_PreeditDrawCallback(ims, call_data)
XIMS ims;
IMPreeditCallbackStruct *call_data;
{
}

int _xi18n_PreeditCaretCallback(ims, call_data)
XIMS ims;
IMPreeditCallbackStruct *call_data;
{
}

int _xi18n_PreeditDoneCallback(ims, call_data)
XIMS ims;
IMPreeditCallbackStruct *call_data;
{
}

int _xi18n_StatusStartCallback(ims, call_data)
XIMS ims;
IMStatusCallbackStruct *call_data;
{
}

int _xi18n_StatusDrawCallback(ims, call_data)
XIMS ims;
IMStatusCallbackStruct *call_data;
{
}

int _xi18n_StatusDoneCallback(ims, call_data)
XIMS ims;
IMStatusCallbackStruct *call_data;
{
}
