/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <X11/Xlib.h>
#include "IMdkit.h"
#include "Xi18n.h"
#include "FrameMgr.h"

void _xi18n_SendMessage(ims, connect_id, major_opcode, minor_opcode,
			data, length)
XIMS ims;
CARD16 connect_id;
CARD8 major_opcode;
CARD8 minor_opcode;
unsigned char *data;
long length;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec packet_header_fr[];
    unsigned char *reply_hdr = NULL;
    int header_size;
    unsigned char *reply = NULL;
    unsigned char *replyp;
    int reply_length;

    /* create FrameMgr */
    fm = FrameMgrInit(packet_header_fr, NULL,
		      Need_Swap(i18n_core, connect_id));

    header_size = FrameMgrGetTotalSize(fm);
    reply_hdr = (unsigned char *) malloc(header_size);
    if (!reply_hdr) {
	_xi18n_SendMessage(ims, connect_id, XIM_ERROR, 0, 0, 0);
	return;
    }
    FrameMgrSetBuffer(fm, reply_hdr);

    /* put data */
    FrameMgrPutToken(fm, major_opcode);
    FrameMgrPutToken(fm, minor_opcode);
    FrameMgrPutToken(fm, length);

    reply_length = header_size + length;
    reply = (unsigned char *)malloc(reply_length);
    replyp = reply;
    memmove(reply, reply_hdr, header_size);
    replyp += header_size;
    memmove(replyp, data, length);

    i18n_core->methods.send(ims, connect_id, reply, reply_length);

    XFree(reply);
    /* free FrameMgr */
    FrameMgrFree(fm);

    return;
}

void
xi18n_SendTriggerKey(ims, imid, connect_id)
XIMS ims;
int imid;
CARD16 connect_id;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec register_triggerkeys_fr[];
    XIMTriggerKey *on_keys = i18n_core->address.on_keys->keylist;
    XIMTriggerKey *off_keys = i18n_core->address.off_keys->keylist;
    int on_key_num = i18n_core->address.on_keys->count_keys;
    int off_key_num = i18n_core->address.off_keys->count_keys;
    unsigned char *reply = NULL;
    register int i, total_size;

    /* create FrameMgr */
    fm = FrameMgrInit(register_triggerkeys_fr, NULL,
		      Need_Swap(i18n_core, connect_id));

    /* set iteration count for on-keys list */
    FrameMgrSetIterCount(fm, on_key_num);
    /* set iteration count for off-keys list */
    FrameMgrSetIterCount(fm, off_key_num);

    /* get total_size */
    total_size = FrameMgrGetTotalSize(fm);

    reply = (unsigned char *) malloc(total_size);
    if (!reply) {
	return;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    /* Right now XIM_OPEN_REPLY hasn't been sent to this new client, so
       the imid is still invalid, and should be set to zero...
       Reter to $(XC)/lib/X11/imDefLkup.c:_XimRegisterTriggerKeysCallback
     */
    imid = 0;
    FrameMgrPutToken(fm, imid);
    for (i = 0; i < on_key_num; i++) {
	FrameMgrPutToken(fm, on_keys[i].keysym);
	FrameMgrPutToken(fm, on_keys[i].modifier);
	FrameMgrPutToken(fm, on_keys[i].modifier_mask);
    }
    for (i = 0; i < off_key_num; i++) {
	FrameMgrPutToken(fm, off_keys[i].keysym);
	FrameMgrPutToken(fm, off_keys[i].modifier);
	FrameMgrPutToken(fm, off_keys[i].modifier_mask);
    }

    _xi18n_SendMessage(ims, connect_id, XIM_REGISTER_TRIGGERKEYS, 0,
		       reply, total_size);
    /* free FrameMgr */
    FrameMgrFree(fm);

    return;
}

void
_xi18n_SetEventMask(ims, connect_id, im_id, ic_id,
		    forward_mask, sync_mask)
XIMS ims;
CARD16 connect_id;
CARD16 im_id;
CARD16 ic_id;
CARD32 forward_mask;
CARD32 sync_mask;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec set_event_mask_fr[];
    unsigned char *reply = NULL;
    register int total_size;

    /* create FrameMgr */
    fm = FrameMgrInit(set_event_mask_fr, NULL,
		      Need_Swap(i18n_core, connect_id));

    total_size = FrameMgrGetTotalSize(fm);
    reply = (unsigned char *) malloc(total_size);
    if (!reply) {
	return;
    }
    memset(reply, 0, total_size);
    FrameMgrSetBuffer(fm, reply);

    FrameMgrPutToken(fm, im_id);
    FrameMgrPutToken(fm, ic_id);
    FrameMgrPutToken(fm, forward_mask);
    FrameMgrPutToken(fm, sync_mask);

    _xi18n_SendMessage(ims, connect_id,
		       XIM_SET_EVENT_MASK, 0, reply, total_size);

    /* free FrameMgr */
    FrameMgrFree(fm);

    return;
}
