/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <X11/Xlib.h>
#include "IMdkit.h"
#include "Xi18n.h"
#include "Xi18nTrX.h"
#include "Xi18nTrTcp.h"
#include "Xi18nTrDnet.h"

#define IM_USE_XCONNECTION(i18n) (!strncmp((i18n)->address.im_addr, "X", 1))
#define IM_USE_TCPCONNECTION(i18n) \
  (!strncmp((i18n)->address.im_addr, "tcp", 3) || \
   !strncmp((i18n)->address.im_addr, "local", 5))

Need_Swap(i18n_core, connect_id)
Xi18n i18n_core;
CARD16 connect_id;
{
    CARD8 im_byteOrder = i18n_core->address.im_byteOrder;

    if (IM_USE_XCONNECTION(i18n_core)) {
	XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
	XClient *client = spec->clients;

	while (client != NULL) {
	    if (client->connection_id == connect_id) {
		return (client->byte_order != im_byteOrder);
	    }
	    client = client->next;
	}
	return False;		/* not found in the list */
    }
    else if (IM_USE_TCPCONNECTION(i18n_core)) {
	TcpSpecRec *spec = (TcpSpecRec *)i18n_core->address.spec;
 	TcpClient *client = (TcpClient *)spec->clients;

	while (client != NULL) {
	    if (client->connection_id == connect_id) {
		return (client->byte_order != im_byteOrder);
	    }
	    client = client->next;
	}
	return False;		/* not found in the list */
    }
    return False;		/* unknown transport */
}
