/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company
         Copyright 1993, 1994 by Digital Equipment Corporation

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY AND DIGITAL EQUIPMENT CORPORATION DISCLAIM ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL HEWLETT-PACKARD COMPANY
AND DIGITAL EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/

#ifdef DNETCONN
#include <stdio.h>
#include <sys/types.h>
#include <netdnet/dnetdb.h>
#include <netdnet/dn.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include "FrameMgr.h"
#include "IMdkit.h"
#include "Xi18n.h"
#include "Xi18nTrDnet.h"

static int _DnetWrite(
#if NeedFunctionPrototypes
	int, char *, int
#endif
);
 
#if NeedFunctionPrototypes
Bool _xi18n_DnetBegin(
	XIMS ims)
#else
Bool _xi18n_DnetBegin(ims)
	XIMS ims;
#endif
{
    Xi18n i18n_core = ims->protocol;
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;
    int fd = 0;
    char* obj;

    if (i18n_core->address.transport_type == TRANSPORT_DNET) { /* DECnet */
	int reuse = 1;
	struct servent *sp;
	struct nodeent *np;
	struct sockaddr_dn sdn;
	extern int setsockopt();

	if (spec->objname && *spec->objname != '\0') {
	    obj = spec->objname;
	}
	else {
	    obj = DEFAULT_OBJNAME;
	}
	if (!(np = getnodebyname(spec->nodename))) {
	    return False;
	}
	memset((char *)&sdn, 0, sizeof(sdn));
	sdn.sdn_family = AF_DECnet;
	strcpy(sdn.sdn_objname, obj);
	sdn.sdn_objnamel = strlen(obj);
	memmove(sdn.sdn_add.a_addr, np->n_addr, np->n_length);
    
	if ((fd = socket(AF_DECnet, SOCK_STREAM, 0)) < 0) {
	    return False;
	}
	setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &reuse, sizeof(int));
	if (bind(fd, (struct sockaddr*)&sdn,
		 sizeof(struct sockaddr_dn)) != 0) {
	    shutdown(fd, 2);
	    return False;
	}
	if (listen(fd, 5) < 0) {
	    shutdown(fd, 2);
	    return False;
	}
    }
    spec->listen = fd;
    spec->is_registered = True;
    if (spec->objname = (char*)malloc(strlen(obj))) {
	strcpy(spec->objname, obj);
    }
    _IMAddInput(i18n_core->address.dpy,
		fd, _xi18n_WaitDnetListen, ims);
    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_DnetEnd(
	XIMS ims)
#else
Bool _xi18n_DnetEnd(ims)
	XIMS ims;
#endif
{
    Xi18n i18n_core = ims->protocol;
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;

    if (spec->is_registered) {
	shutdown(spec->listen, 2);
	(void)close(spec->listen);
	_IMRemoveInput(i18n_core->address.dpy, spec->listen);
	spec->is_registered = False;
    }

    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_DnetSend(
	XIMS ims,
	CARD16 connection_id,
	unsigned char *reply,
	long length)
#else
Bool _xi18n_DnetSend(ims, connection_id, reply, length)
	XIMS ims;
	CARD16 connection_id;
	unsigned char *reply;
	long length;
#endif
{
    Xi18n i18n_core = ims->protocol;
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;
    DnetClient *client = spec->clients;

    while (client != NULL) {
	if (client->connection_id == connection_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    if (length > 0)
      if (_DnetWrite(client->accept_fd, (char *)reply, length) != length)
	return False;

    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_DnetWait(
	XIMS ims,
	CARD16 connect_id,
	CARD8 major_opcode,
	CARD8 minor_opcode)
#else
Bool _xi18n_DnetWait(ims, connect_id, major_opcode, minor_opcode)
	XIMS ims;
	CARD16 connect_id;
	CARD8 major_opcode;
	CARD8 minor_opcode;
#endif
{
    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_DnetDisconnect(
	XIMS ims,
	CARD16 connect_id)
#else
Bool _xi18n_DnetDisconnect(ims, connect_id)
	XIMS ims;
	CARD16 connect_id;
#endif
{
    Xi18n i18n_core = ims->protocol;
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;
    DnetClient *client = spec->clients;
    Display *dpy = i18n_core->address.dpy;
    DnetClient *ccp, *ccp0;

    while (client != NULL) {
	if (client->connection_id == connect_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    shutdown(client->accept_fd, 2);
    (void)close(client->accept_fd);
    _IMRemoveInput(i18n_core->address.dpy, client->accept_fd);

    for (ccp = spec->clients, ccp0 = NULL;
	 ccp != NULL;
	 ccp0 = ccp, ccp = ccp->next) {
	if (ccp == client) {
	    if (ccp0 == NULL) {
		spec->clients = ccp->next;
	    } else {
		ccp0->next = ccp->next;
	    }
	    /* put it back to free list */
	    client->next = spec->freeclients;
	    spec->freeclients = client;
	    return;
	}
    }
    return True;
}

static int _DnetRead(fd, buf, nbyte)
int fd;
char *buf;
int nbyte;
{
    int remain = nbyte;
    int nread = 0;
    do {
	if ((nread = read(fd, buf, remain)) <= 0)
	  return nread ;
	buf += nread ;
	remain -= nread ;
    } while(remain > 0) ;
    return nbyte ;
}

static int _DnetWrite(fd, buf, nbyte)
int fd;
char *buf;
int nbyte;
{
    int remain = nbyte;
    int nwrite = 0;
    do {
	if ((nwrite = write(fd, buf, remain)) < 0)
	  return nwrite ;
	buf += nwrite ;
	remain -= nwrite ;
    } while(remain > 0) ;
    return nbyte ;
}

Bool _xi18n_CheckDnetAddress(i18n_core, transSW, address)
Xi18n i18n_core;
TransportSW *transSW;
char *address;
{
    DnetSpecRec *spec;
    char *p;

    i18n_core->address.transport_type = TRANSPORT_DNET;

    if(!(spec = (DnetSpecRec *)malloc(sizeof(DnetSpecRec))))
      return False ;
    if (spec->nodename = (char *)malloc(strlen(address) + 1))
      strcpy(spec->nodename, address);
    if (p = (char *)strchr(spec->nodename, ':')) {
	*p = 0; p++;
	if (p = (char *)strchr(p, '$')) {
	    *p = 0; p++;
	    spec->objname = p;
	} else {
	    spec->objname = "DEFAULT";
	}
    }
    i18n_core->address.spec = (DnetSpecRec *)spec;
    i18n_core->methods.begin = _xi18n_DnetBegin;
    i18n_core->methods.end  = _xi18n_DnetEnd;
    i18n_core->methods.send = _xi18n_DnetSend;
    i18n_core->methods.wait = _xi18n_DnetWait;
    i18n_core->methods.disconnect = _xi18n_DnetDisconnect;
    return True;
}

static DnetClient *_FindClient(i18n_core, accept_fd)
Xi18n i18n_core;
Window accept_fd;
{
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;
    DnetClient *client = spec->clients;

    while (client != NULL) {
	if (client->accept_fd == accept_fd)
	  return client;
	client = client->next;
    }

    return NULL;
}

static DnetClient *_NewClient(i18n_core, accept_fd)
Xi18n i18n_core;
int accept_fd;
{
    DnetClient *client;
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;

    if (spec->freeclients != NULL) {
	client = spec->freeclients;
	spec->freeclients = client->next;
    } else {
	client = (DnetClient *)malloc(sizeof(DnetClient));
    }
    client->accept_fd = accept_fd;
    client->connection_id = _xi18n_NewClient();
    client->byte_order = '?';	/* initial value */
    client->next = spec->clients;
    spec->clients = client;

    return client;
}


void
_xi18n_WaitDnetListen(ims, fd)
XIMS ims;
int fd;
{
    Xi18n i18n_core = ims->protocol;
    int afd;
    DnetClient *client;

    afd = xi18n_DnetAccept(i18n_core, fd);
    client = _NewClient(i18n_core, afd);
    _IMAddInput(i18n_core->address.dpy,
		client->accept_fd, _xi18n_WaitDnetAccept, ims);
    return;
}

void
_xi18n_WaitDnetAccept(ims, fd)
XIMS ims;
int fd;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec packet_header_fr[];
    register int total_size;
    XimProtoHdr	*hdr;
    unsigned char *p = NULL, *pp;
    extern void _xi18n_MessageHandler();
    int read_length;
    Bool isConnect = False;
    CARD8 major_opcode, minor_opcode;
    CARD16 length;
    DnetClient *client = _FindClient(i18n_core, fd);
    CARD16 connect_id = client->connection_id;

    if ((hdr = malloc(sizeof(hdr))) == NULL)
      return;
    read_length = _DnetRead(fd, hdr, sizeof(hdr));
    if (read_length != sizeof(hdr)) {
	goto read_error;
    } else {
	if (client->byte_order == '?') {
	    if (hdr->major_opcode == XIM_CONNECT) {
		CARD8 byte_order;
		read_length = _DnetRead(fd, &byte_order, sizeof(CARD8));
		if (read_length != sizeof(CARD8)) {
		    goto read_error;
		}
		isConnect = True;
		client->byte_order = (CARD8)byte_order;
	    } else {
		return;		/* can do nothing */
	    }
	}
	fm = FrameMgrInit(packet_header_fr, (char *)hdr,
			  Need_Swap(i18n_core, connect_id));
	total_size = FrameMgrGetTotalSize(fm);
	/* get data */
	FrameMgrGetToken(fm, major_opcode);
	FrameMgrGetToken(fm, minor_opcode);
	FrameMgrGetToken(fm, length);

	if ((p = (unsigned char *)malloc(sizeof(XimProtoHdr) + length))
	    == NULL)
	  return;
	pp = p;
	memmove(pp, hdr, sizeof(XimProtoHdr)); pp += sizeof(XimProtoHdr);
	XFree(hdr);
	if (!isConnect) {
	    if (length > 0) {
		read_length =_DnetRead(fd, pp, length);
		if (read_length != length) {
		    goto read_error;
		}
	    }
	} else {
	    memmove(pp, &client->byte_order, sizeof(CARD8));
	    pp += sizeof(CARD8);
	    read_length = _DnetRead(fd, pp, length - sizeof(CARD8));
	    if (read_length != length - sizeof(CARD8)) {
		goto read_error;
	    }
	}

	_xi18n_MessageHandler(ims, client->connection_id, p);
	if (p)
	  XFree(p);
    }
    return;
  read_error:
    _IMRemoveInput(i18n_core->address.dpy, fd);
    return;
}

xi18n_DnetAccept(ims, source)
XIMS ims;
int source;
{
    Xi18n i18n_core = ims->protocol;
    DnetSpecRec *spec = (DnetSpecRec *)i18n_core->address.spec;
    int accept_fd;
    int	addrlen;

    if (source == spec->listen) {
	if (i18n_core->address.transport_type == TRANSPORT_DNET) { /* DECnet */
	    struct sockaddr_dn addr_dn;

	    addrlen = sizeof(addr_dn);
	    if ((accept_fd = accept(source, (struct sockaddr *)&addr_dn,
				    &addrlen)) < 0) {
		return(-1);
	    }
	    return accept_fd;
	}
    }
    return(-1);
}

#else /* not DNETCONN */
#ifndef lint
static int dummy;	/* prevent ranlibs from complaining */
#endif  
#endif /* ifdef DNETCONN */
