/******************************************************************

         Copyright 1993, 1994 by Hewlett-Packard Company

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose without fee is hereby granted,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Hewlett-Packard not
be used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
Hewlett-Packard Company makes no representations about the suitability
of this software for any purpose.
It is provided "as is" without express or implied warranty.

HEWLETT-PACKARD COMPANY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Author:
    Hidetoshi Tajima	Hewlett-Packard Company.
			(tajima@kobe.hp.com)
******************************************************************/
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "FrameMgr.h"
#include "IMdkit.h"
#include "Xi18n.h"
#include "Xi18nTrX.h"

#if NeedFunctionPrototypes
Bool _xi18n_XBegin(
	XIMS ims)
#else
Bool _xi18n_XBegin(ims)
	XIMS ims;
#endif
{
    Xi18n i18n_core = ims->protocol;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    extern Bool _xi18n_WaitConnectMessage(
#if NeedFunctionPrototypes
    XIMS, Window, XEvent*, XPointer
#endif
					   );

    spec->xim_request = XInternAtom(i18n_core->address.dpy,
				    _XIM_PROTOCOL, False);
    spec->connect_request = XInternAtom(i18n_core->address.dpy,
					_XIM_XCONNECT, False);
    spec->clients = NULL;
    spec->freeclients = NULL;

    _IMRegisterFilterByType(ims, i18n_core->address.im_window,
			    ClientMessage, ClientMessage,
			    _xi18n_WaitConnectMessage, ims);
    return True;
}

#if NeedFunctionPrototypes
Bool _xi18n_XEnd(
XIMS ims)
#else
Bool _xi18n_XEnd(ims)
XIMS ims;
#endif
{
    Xi18n i18n_core = ims->protocol;
    extern Bool _xi18n_WaitConnectMessage(
#if NeedFunctionPrototypes
    XIMS, Window, XEvent*, XPointer
#endif
					   );

    _IMUnregisterFilter(ims, i18n_core->address.im_window,
			_xi18n_WaitConnectMessage);
    return True;
}

static char *
_MakeNewAtom(i18n_core, atomName)
Xi18n i18n_core;
char *atomName;
{
    static int sequence = 0;
    sprintf(atomName, "_server%d_%d",
	    i18n_core->address.input_method_id,
	    (sequence > 20 ? (sequence = 0) : sequence++));
    return atomName;
}

#if NeedFunctionPrototypes
Bool _xi18n_XSend(
	XIMS ims,
	CARD16 connection_id,
	unsigned char *reply,
	long length)
#else
Bool _xi18n_XSend(ims, connection_id, reply, length)
	XIMS ims;
	CARD16 connection_id;
	unsigned char *reply;
	long length;
#endif
{
    Xi18n i18n_core = ims->protocol;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    XClient *client = spec->clients;
    XEvent event;

    while (client != NULL) {
	if (client->connection_id == connection_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    event.type = ClientMessage;
    event.xclient.window = client->client_win;
    event.xclient.message_type = spec->xim_request;

    if (length > 20) {
	Atom atom;
	char atomName[16];
	Atom actual_type_ret;
	int actual_format_ret;
	int return_code;
	unsigned long nitems_ret;
	unsigned long bytes_after_ret;
	unsigned char *win_data;

	event.xclient.format = 32;
	atom = XInternAtom(i18n_core->address.dpy,
			   _MakeNewAtom(i18n_core, atomName), False);
	return_code = XGetWindowProperty(i18n_core->address.dpy,
				 client->client_win, atom, 0L, 10000L,
				 False, XA_STRING, &actual_type_ret,
				 &actual_format_ret, &nitems_ret,
				 &bytes_after_ret, &win_data);
	if (return_code != Success)
	  return False;
	XChangeProperty(i18n_core->address.dpy,
			client->client_win, atom, XA_STRING, 8,
			PropModeAppend, (unsigned char *)reply, length);
	event.xclient.data.l[0] = length;
	event.xclient.data.l[1] = atom;
    }
    else {
	unsigned char buffer[20];
	int i;

	event.xclient.format = 8;

	/* Clear unused field with NULL */
	memmove(buffer, reply, length);
	for (i = length; i < 20; i++) {
	    buffer[i] = (char)0;
	}
	length = 20;
	memmove(event.xclient.data.b, buffer, length);
    }
    XSendEvent(i18n_core->address.dpy,
	       client->client_win, False, NoEventMask, &event);
    XFlush(i18n_core->address.dpy);
    return True;
}

static Bool
_CheckCMEvent(display, event, xi18n_core)
Display	*display;
XEvent	*event;
XPointer xi18n_core;
{
    Xi18n i18n_core = (Xi18n)((void *)xi18n_core);
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;

    if ((event->type == ClientMessage)
	&& (event->xclient.message_type == spec->xim_request))
      return True;
    return False;

}

#if NeedFunctionPrototypes
Bool _xi18n_XWait(
	XIMS ims,
	CARD16 connect_id,
	CARD8 major_opcode,
	CARD8 minor_opcode)
#else
Bool _xi18n_XWait(ims, connect_id, major_opcode, minor_opcode)
	XIMS ims;
	CARD16 connect_id;
	CARD8 major_opcode;
	CARD8 minor_opcode;
#endif
{
    Xi18n i18n_core = ims->protocol;
    XEvent event;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    XClient *client = spec->clients;

    while (client != NULL) {
	if (client->connection_id == connect_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    for (;;) {
	XIfEvent(i18n_core->address.dpy, &event,
		 _CheckCMEvent, (XPointer)i18n_core);

	if ((event.xclient.window == client->accept_win) 
	  && (event.xclient.format == 8)) {
	    XimProtoHdr *hdr = (XimProtoHdr *)event.xclient.data.b;
	    if ((hdr->major_opcode == major_opcode)
		&& (hdr->minor_opcode == minor_opcode))
	      return True;
	}
	XPutBackEvent(i18n_core->address.dpy, &event);
    }
}

#if NeedFunctionPrototypes
Bool _xi18n_XDisconnect(
	XIMS ims,
	CARD16 connect_id)
#else
Bool _xi18n_XDisconnect(ims, connect_id)
	XIMS ims;
	CARD16 connect_id;
#endif
{
    Xi18n i18n_core = ims->protocol;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    XClient *client = spec->clients;
    Display *dpy = i18n_core->address.dpy;
    XClient *ccp, *ccp0;
    extern Bool _xi18n_WaitIMProtocol(
#if NeedFunctionPrototypes
    XIMS, Window, XEvent*, XPointer
#endif
				     );

    while (client != NULL) {
	if (client->connection_id == connect_id) {
	    break;
	}
	client = client->next;
    }
    if (client == NULL) return False;

    XDestroyWindow(dpy, client->accept_win);
    _IMUnregisterFilter(ims, client->accept_win,
			_xi18n_WaitIMProtocol);

    for (ccp = spec->clients, ccp0 = NULL;
	 ccp != NULL;
	 ccp0 = ccp, ccp = ccp->next) {
	if (ccp == client) {
	    if (ccp0 == NULL) {
		spec->clients = ccp->next;
	    } else {
		ccp0->next = ccp->next;
	    }
	    /* put it back to free list */
	    client->next = spec->freeclients;
	    spec->freeclients = client;
	    return;
	}
    }
    return True;
}

Bool _xi18n_CheckXAddress(i18n_core, transSW, address)
Xi18n i18n_core;
TransportSW *transSW;
char *address;
{
    XSpecRec *spec;

    if(!(spec = (XSpecRec *) malloc(sizeof(XSpecRec))))
      return False ;

    i18n_core->address.spec = (XSpecRec *)spec;
    i18n_core->methods.begin = _xi18n_XBegin;
    i18n_core->methods.end  = _xi18n_XEnd;
    i18n_core->methods.send = _xi18n_XSend;
    i18n_core->methods.wait = _xi18n_XWait;
    i18n_core->methods.disconnect = _xi18n_XDisconnect;
    return True;
}

static XClient *_FindClient(i18n_core, accept_window)
Xi18n i18n_core;
Window accept_window;
{
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    XClient *client = spec->clients;

    while (client != NULL) {
	if (client->accept_win == accept_window)
	  return client;
	client = client->next;
    }

    return NULL;
}

static XClient *_NewClient(i18n_core, new_client)
Xi18n i18n_core;
Window new_client;
{
    XClient *client;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    Display *dpy = i18n_core->address.dpy;

    if (spec->freeclients != NULL) {
	client = spec->freeclients;
	spec->freeclients = client->next;
    } else {
	client = (XClient *)malloc(sizeof(XClient));
    }
    client->client_win = new_client;
    client->accept_win = XCreateSimpleWindow(dpy,
		     DefaultRootWindow(dpy), 0, 0, 1, 1, 1, 0, 0);
    client->connection_id = _xi18n_NewClient();
    client->byte_order = '?';	/* initial value */
    client->next = spec->clients;
    spec->clients = client;

    return client;
}

static void _ReadConnectClientMessage(ims, ev)
XIMS ims;
XClientMessageEvent *ev;
{
    Xi18n i18n_core = ims->protocol;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;
    XEvent event;
    Display *dpy = i18n_core->address.dpy;
    Window new_client = ev->data.l[0];
    XClient *client = _NewClient(i18n_core, new_client);
    extern Bool _xi18n_WaitIMProtocol(
#if NeedFunctionPrototypes
    XIMS, Window, XEvent*, XPointer
#endif
				     );

    if (ev->window != i18n_core->address.im_window)
      return;			/* incorrect connection request */

    _IMRegisterFilterByType(ims, client->accept_win,
			    ClientMessage, ClientMessage,
			    _xi18n_WaitIMProtocol, ims);
    event.xclient.type = ClientMessage;
    event.xclient.display = dpy;
    event.xclient.window = new_client;
    event.xclient.message_type = spec->connect_request;
    event.xclient.format       = 32;
    event.xclient.data.l[0]    = client->accept_win;

    XSendEvent(dpy, new_client,
	       False, NoEventMask, &event);
    XFlush(dpy);
}

static void _ReadXIMClientMessage(ims, ev)
XIMS ims;
XClientMessageEvent *ev;
{
    Xi18n i18n_core = ims->protocol;
    FrameMgr fm;
    extern XimFrameRec packet_header_fr[];
    register int total_size;
    unsigned char *p = NULL;
    unsigned char *p1;
    extern void _xi18n_MessageHandler();
    XClient *client = _FindClient(i18n_core, ev->window);
    CARD16 connect_id = client->connection_id;
    Bool delete = True;

    if (ev->format == 8) {	/* ClientMessage only */
	XimProtoHdr *hdr = (XimProtoHdr *)ev->data.b;
	unsigned char *rec = (unsigned char *)(hdr + 1);
	CARD8 major_opcode, minor_opcode;
	CARD16 length;
	extern int Need_Swap();

	if (client->byte_order == '?') {
	    if (hdr->major_opcode == XIM_CONNECT)
	      client->byte_order = (CARD8)rec[0];
	    else
	      return;		/* can do nothing */
	}
	/* create FrameMgr */
	fm = FrameMgrInit(packet_header_fr, (char *)hdr,
			  Need_Swap(i18n_core, connect_id));

	total_size = FrameMgrGetTotalSize(fm);
	/* get data */
	FrameMgrGetToken(fm, major_opcode);
	FrameMgrGetToken(fm, minor_opcode);
	FrameMgrGetToken(fm, length);

	/* free FrameMgr */
	FrameMgrFree(fm);

	if ((p = (unsigned char *)malloc(total_size + length)) == NULL)
	  return;
	p1 = p;
	memmove(p1, &major_opcode, sizeof(CARD8)); p1 += sizeof(CARD8);
	memmove(p1, &minor_opcode, sizeof(CARD8)); p1 += sizeof(CARD8);
	memmove(p1, &length, sizeof(CARD16)); p1 += sizeof(CARD16);
	memmove(p1, rec, length);
    } else if (ev->format == 32) { /* ClientMessage and WindowProperty */
	unsigned long length = (unsigned long)ev->data.l[0];
	Atom atom = (Atom)ev->data.l[1];
	int	     return_code;
	Atom	     actual_type_ret;
	int	     actual_format_ret;
	unsigned long    bytes_after_ret;
	unsigned char    *prop;
	unsigned long    nitems;

	return_code = XGetWindowProperty(i18n_core->address.dpy,
					 client->accept_win, atom,
					 0L, length,
					 True, AnyPropertyType,
					 &actual_type_ret, &actual_format_ret,
					 &nitems, &bytes_after_ret, &prop);
	if (return_code != Success
	    || actual_format_ret == 0 || nitems == 0) {
	    if (return_code == Success)
	      XFree(prop);
	    return;
	}
	if ((p = (unsigned char *)malloc(length)) == NULL)
	  return;
	memmove(p, prop, length);
	XFree(prop);
    }
    _xi18n_MessageHandler(ims, connect_id, p, &delete);
    if (delete == True)
      XFree(p);
    return;
}

static void _ReturnSelectionNotify(i18n_core, ev)
Xi18n i18n_core;
XSelectionRequestEvent *ev;
{
    XEvent event;
    Display *dpy = i18n_core->address.dpy;
    char buf[256];

    event.type = SelectionNotify;
    event.xselection.requestor = ev->requestor;
    event.xselection.selection = ev->selection;
    event.xselection.target = ev->target;
    event.xselection.time = ev->time;
    event.xselection.property = ev->property;
    if (ev->target == i18n_core->address.Localename) {
	(void)sprintf(buf, "@locale=%s", i18n_core->address.im_locale);
    } else if (ev->target == i18n_core->address.Transportname) {
	(void)sprintf(buf, "@transport=%s", i18n_core->address.im_addr);
    }
    XChangeProperty(dpy, event.xselection.requestor,
		    ev->target, ev->target, 8,
		    PropModeReplace, (unsigned char *)&buf, strlen(buf));
    XSendEvent(dpy, event.xselection.requestor, False, NoEventMask, &event);
    XFlush(i18n_core->address.dpy);
}

Bool
_xi18n_WaitConnectMessage(ims, win, ev, client_data)
XIMS ims;
Window win;
XEvent *ev;
XPointer client_data;
{
    Xi18n i18n_core = ims->protocol;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;

    if (((XClientMessageEvent *)ev)->message_type ==
	spec->connect_request) {
	_ReadConnectClientMessage(ims,
				  (XClientMessageEvent *)ev);
	return True;
    }
    return False;
}

Bool
_xi18n_WaitIMProtocol(ims, win, ev, client_data)
XIMS ims;
Window win;
XEvent *ev;
XPointer client_data;
{
    Xi18n i18n_core = ims->protocol;
    XSpecRec *spec = (XSpecRec *)i18n_core->address.spec;

    if (((XClientMessageEvent *)ev)->message_type ==
	spec->xim_request) {
	_ReadXIMClientMessage(ims,
			      (XClientMessageEvent *)ev);
	return True;
    }
    return False;
}

Bool
_xi18n_WaitSelectionRequest(ims, win, ev, client_data)
XIMS ims;
Window win;
XEvent *ev;
XPointer client_data;
{
    Xi18n i18n_core = ims->protocol;

    if (((XSelectionRequestEvent *)ev)->selection ==
	i18n_core->address.selection) {
	_ReturnSelectionNotify(i18n_core,
			       (XSelectionRequestEvent *)ev);
	return True;
    }
}
