/* Copyright 1994 by Sun Microsystems, Inc. */
/* @(#)XimpHandler.c	1.2 94/02/16 */
/******************************************************************
 
              Copyright 1994 by Sun Microsystems, Inc.
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.
 
Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hiromu Inukai (inukai@Japan.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/

#ifndef	_XIMPHANDLER_C_
#define	_XIMPHANDLER_C_
#include "XimpData.h"

extern Bool _proc_keypress(XIMS, XEvent*);
extern Bool _proc_keyrelease(XIMS, XEvent*);
extern Bool _proc_create(XIMS, XEvent*);
extern Bool _proc_destroy(XIMS, XEvent*);
extern Bool _proc_start(XIMS, XEvent*);
extern Bool _proc_end(XIMS, XEvent*);
extern Bool _proc_setfocus(XIMS, XEvent*);
extern Bool _proc_unsetfocus(XIMS, XEvent*);
extern Bool _proc_clientwin(XIMS, XEvent*);
extern Bool _proc_focuswin(XIMS, XEvent*);
extern Bool _proc_move(XIMS, XEvent*);
extern Bool _proc_setval(XIMS, XEvent*);
extern Bool _proc_getval(XIMS, XEvent*);
extern Bool _proc_reset(XIMS, XEvent*);
extern Bool _proc_evmask(XIMS, XEvent*);
extern Bool _proc_extension(XIMS, XEvent*);

static Bool _dispat_prot(XIMS xims, XEvent *ev)
{
    IMPProtocol	call_data;
    memset(&call_data, 0, sizeof(call_data));

    switch(ev->xclient.data.l[0]) {
      case XIMP_KEYPRESS4:
      case XIMP_KEYPRESS3:
#ifdef DEBUG
	printf("XIMP_KEYPRESS4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_keypress(xims, ev));
      case XIMP_KEYRELEASE4:
#ifdef DEBUG
	printf("XIMP_KEYRELEASE. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_keyrelease(xims, ev));
      case XIMP_CREATE4:
      case XIMP_CREATE3:
#ifdef DEBUG
	printf("XIMP_CREATE4[3]. ClientWindow is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_create(xims, ev));
      case XIMP_DESTROY4:
      case XIMP_DESTROY3:
#ifdef DEBUG
	printf("XIMP_DESTROY4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_destroy(xims, ev));
      case XIMP_REG_KEY_PRESSED4:
      case XIMP_BEGIN3:
#ifdef DEBUG
	printf("XIMP_REG_KEY_PRESSED4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_start(xims, ev));
      case XIMP_END3:
#ifdef DEBUG
	printf("XIMP_END3. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_end(xims, ev));
      case XIMP_SETFOCUS4:
      case XIMP_SETFOCUS3:
#ifdef DEBUG
	printf("XIMP_SETFOCUS4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_setfocus(xims, ev));
      case XIMP_UNSETFOCUS4:
      case XIMP_UNSETFOCUS3:
#ifdef DEBUG
	printf("XIMP_UNSETFOCUS4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_unsetfocus(xims, ev));
      case XIMP_CLIENT_WINDOW4:
#ifdef DEBUG
	printf("XIMP_CLIENT_WINDOW4. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_clientwin(xims, ev));
      case XIMP_FOCUS_WINDOW4:
#ifdef DEBUG
	printf("XIMP_FOCUSWINDOW4. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_focuswin(xims, ev));
      case XIMP_MOVE4:
      case XIMP_MOVE3:
#ifdef DEBUG
	printf("XIMP_MOVE4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_move(xims, ev));
      case XIMP_SETVALUE4:
      case XIMP_SETVALUE3:
#ifdef DEBUG
	printf("XIMP_SETVALUE4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_setval(xims, ev));
      case XIMP_GETVALUE4:
      case XIMP_GETVALUE3:
#ifdef DEBUG
	printf("XIMP_GETVALUE4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_getval(xims, ev));
      case XIMP_RESET4:
      case XIMP_RESET3:
#ifdef DEBUG
	printf("XIMP_RESET4[3]. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_reset(xims, ev));
      case XIMP_EVENTMASK_NOTIFY4:
#ifdef DEBUG
	printf("XIMP_EVENTMASK_NOTIFY4. icid is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_evmask(xims, ev));
      case XIMP_EXTENSION4:
      case XIMP_EXTENSION3:
#ifdef DEBUG
	printf("XIMP_KEYPRESS4[3]. ClientWindow is %d[%x]\n", ev->xclient.data.l[1],ev->xclient.data.l[1]);
#endif
	return(_proc_extension(xims, ev));
    }
}

Bool
_ximp_HandleProto(XIMS xims, Window window, XEvent *ev, XPointer client_data)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    if(ev->xclient.message_type == core->mes_type) {
	return(_dispat_prot(xims, ev));
    }
    return False;
}
#endif	/* _XIMPHANDLER_C_ */
