/* Copyright 1994 by Sun Microsystems, Inc. */
/* @(#)XimpMethods.c	1.3 94/02/16 */
/******************************************************************

              Copyright 1994 by Sun Microsystems, Inc.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.

Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

  Author: Hiromu Inukai (inukai@Japan.Sun.COM) Sun Microsystems, Inc.

******************************************************************/

#ifndef _XIMPMETHODS_C_
#define _XIMPMETHODS_C_
#include <X11/Xatom.h>
#define	NEED_EVENTS
#include <X11/Xlibint.h>
#include "XimpData.h"

IMMethodsRec Ximp_im_methods = {
    ximp_setup,
    ximp_openIM,
    ximp_closeIM,
    ximp_setIMValues,
    ximp_getIMValues,
    ximp_forwardEvent,
    ximp_commitString,
    ximp_wait
};

static void setup_imvalues(XIMPCore, XIMArg*);
static void set_ximp_imvalues(XIMPCore, XIMArg*);
static void free_imvalues(XIMPCore);
static char *next_name(char**);
static char *update_ximp_extension(XIMPCore, XIMArg*);
static char *update_ximp_imvalues(XIMPCore, XIMArg*);
static char *extract_ximp_extension(XIMPCore, XIMArg**);
static char *extract_ximp_imvalues(XIMPCore, XIMArg*);
static Bool export_lang(XIMS);
static Bool regist_atoms(XIMS);
static int  set_owner_atom(Display*, char*, int, Atom*);

extern void _send_keyevent(XIMPCore, IMPProtocol*);
extern void _send_commit(XIMPCore, IMPProtocol*);
extern Bool _ximp_HandleProto(XIMS, Window, XEvent*, XPointer);


void *
ximp_setup(Display *display, XIMArg *args)
{
    XIMPCore	imp_core = (XIMPCore)NULL;
    if((imp_core = (XIMPCore)Xmalloc(sizeof(XIMPCoreRec))) == NULL)
	return (void *)NULL;
    memset(imp_core, 0, sizeof(XIMPCoreRec));
    imp_core->display = display;
    imp_core->screen = DefaultScreen(display);
    setup_imvalues(imp_core, args);
    if(imp_core->support_locale == (char*)NULL) {
	free_imvalues(imp_core);
	XFree(imp_core);
	return (void*)NULL;
    }
    return (void*)imp_core;
}

static void setup_imvalues(XIMPCore core, XIMArg *args)
{
    XIMArg	*ptr;
    Display	*display = core->display;

    for(ptr = args; ptr->name; ptr++) {
	if(!strcmp(ptr->name, IMServerWindow)) {
	    core->window = (Window)ptr->value;
	} else if(!strcmp(ptr->name, IMLocale)) {
	    core->support_locale = (char*)Xmalloc(strlen((char*)ptr->value) + 1);
	    if(core->support_locale == (char*)NULL) {
		free_imvalues(core);
	    }
	    strcpy(core->support_locale, (char*)ptr->value);
	} else if(!strcmp(ptr->name, IMInputStyles)) {
	    core->styles.count_styles = ((XIMStyles*)ptr->value)->count_styles;
	    core->styles.supported_styles = (XIMStyle*)Xmalloc(sizeof(XIMStyle) * core->styles.count_styles);
	    if(core->styles.supported_styles == (XIMStyle*)NULL) {
		free_imvalues(core);
	    }
	    memmove(core->styles.supported_styles,
		    ((XIMStyles*)ptr->value)->supported_styles,
		    sizeof(XIMStyle) * ((XIMStyles*)ptr->value)->count_styles);
	} else if(!strcmp(ptr->name, IMOnKeysList)) {
	    register int 	i;
	    register XIMTriggerKey *src;
	    register Ximp_Key *dst;
	    core->start_keys.count_keys = ((XIMTriggerKeys*)ptr->value)->count_keys;
	    core->start_keys.keys_list = (Ximp_Key*)Xmalloc(sizeof(Ximp_Key) *
						core->start_keys.count_keys);
	    if(core->start_keys.keys_list == (Ximp_Key*)NULL) {
		free_imvalues(core);
	    }
	    src = ((XIMTriggerKeys*)ptr->value)->keylist;
	    dst = core->start_keys.keys_list;
	    for(i = 0; i < (int)core->start_keys.count_keys; i++, src++, dst++) {
		dst->keysym = src->keysym;
		dst->modifier = src->modifier;
		dst->modifier_mask = src->modifier_mask;
	    }
	} else if(!strcmp(ptr->name, IMOffKeysList)) {
	    register int 	i;
	    register XIMTriggerKey *src;
	    register Ximp_Key *dst;
	    core->stop_keys.count_keys = ((XIMTriggerKeys*)ptr->value)->count_keys;
	    core->stop_keys.keys_list = (Ximp_Key*)Xmalloc(sizeof(Ximp_Key) *
						core->stop_keys.count_keys);
	    if(core->stop_keys.keys_list == (Ximp_Key*)NULL) {
		free_imvalues(core);
	    }
	    src = ((XIMTriggerKeys*)ptr->value)->keylist;
	    dst = core->stop_keys.keys_list;
	    for(i = 0; i < (int)core->start_keys.count_keys; i++, src++, dst++) {
		dst->keysym = src->keysym;
		dst->modifier = src->modifier;
		dst->modifier_mask = src->modifier_mask;
	    }
	} else if(!strcmp(ptr->name, IMProtocolHandler)) {
	    core->imp_handler = (IMProtoHandler)(ptr->value);
	} else if(!strcmp(ptr->name, IMXEventHandler)) {
	    core->xev_handler = (XEventHandler)(ptr->value);
	} else if(!strcmp(ptr->name, XIMPProtoDepend)) {
	    set_ximp_imvalues(core, ptr);
	}
    }
    if(core->window == (Window)NULL) {
	core->window = XCreateSimpleWindow(display,
					DefaultRootWindow(display),
					0,0,
					1,1,
					1,
					BlackPixel(display, core->screen),
					WhitePixel(display, core->screen)
					);
    }
    return;
}

static void set_ximp_imvalues(XIMPCore core, XIMArg *ptr)
{
    Display	*display = core->display;
    XIMArg	*imptr = (XIMArg*)ptr->value;

    for(; imptr->name; imptr++) {
	if(!strcmp(imptr->name, XIMPVersion)) {
	    core->ximp_version = XInternAtom(display, (char*)imptr->value, False);
	} else if(!strcmp(imptr->name, XIMPType)) {
	    core->ximp_type = (XIMPTypeRec*)Xmalloc(sizeof(XIMPTypeRec));
	    if(core->ximp_type == (XIMPTypeRec*)NULL) {
		free_imvalues(core);
	    }
	    core->ximp_type->types = (unsigned long*)Xmalloc(sizeof(unsigned long*) * ((XIMPTypeRec*)imptr->value)->num_of_types);
	    if(core->ximp_type->types == (unsigned long*)NULL) {
		free_imvalues(core);
	    }
	    core->ximp_type->num_of_types = ((XIMPTypeRec*)imptr->value)->num_of_types;
	    memmove(core->ximp_type->types,
			((XIMPTypeRec*)imptr->value)->types,
			((XIMPTypeRec*)imptr->value)->num_of_types * sizeof(unsigned long));
	} else if(!strcmp(imptr->name, XIMPServerName)) {
	    core->ims_name = (char*)Xmalloc(strlen((char*)imptr->value) + 1);
	    if(core->ims_name == (char*)NULL) {
		free_imvalues(core);
	    }
	    strcpy(core->ims_name, (char*)imptr->value);
	} else if(!strcmp(imptr->name, XIMPServerVersion)) {
	    core->ims_version = (char*)Xmalloc(strlen((char*)imptr->value) + 1);
	    if(core->ims_version == (char*)NULL) {
		free_imvalues(core);
	    }
	    strcpy(core->ims_version, (char*)imptr->value);
	} else if(!strcmp(imptr->name, XIMPVendorName)) {
	    core->vendor = (char*)Xmalloc(strlen((char*)imptr->value) + 1);
	    if(core->vendor == (char*)NULL) {
		free_imvalues(core);
	    }
	    strcpy(core->vendor, (char*)imptr->value);
	} else if(!strcmp(imptr->name, XIMPExtension)) {
	    update_ximp_extension(core, (XIMArg*)imptr->value);
	}
    }
}


static void free_imvalues(XIMPCore core)
{
    if(core->support_locale != (char*)NULL) {
	XFree(core->support_locale);
	core->support_locale = (char*)NULL;
    }
    if(core->styles.supported_styles != (XIMStyle*)NULL) {
	XFree(core->styles.supported_styles);
	core->styles.supported_styles = (XIMStyle*)NULL;
    }
    if(core->start_keys.keys_list != (Ximp_Key*)NULL) {
	XFree(core->start_keys.keys_list);
	core->start_keys.keys_list = (Ximp_Key*)NULL;
    }
    if(core->stop_keys.keys_list != (Ximp_Key*)NULL) {
	XFree(core->stop_keys.keys_list);
	core->stop_keys.keys_list = (Ximp_Key*)NULL;
    }
    if(core->ximp_type != (XIMPTypeRec *)NULL) {
	XFree(core->ximp_type->types);
	XFree(core->ximp_type);
	core->ximp_type = NULL;
    }
    if(core->ims_name != (char*)NULL) {
	XFree(core->ims_name);
	core->ims_name = (char*)NULL;
    }
    if(core->ims_version != (char*)NULL) {
	XFree(core->ims_version);
	core->ims_version = (char*)NULL;
    }
    if(core->vendor != (char*)NULL) {
	XFree(core->vendor);
	core->vendor = (char*)NULL;
    }
}

static int
set_owner_atom(Display *display, char *name, int conf, Atom *selection)
{
    if (*selection = XInternAtom(display, name, True)) {
	if (XGetSelectionOwner(display, *selection)) {
	    conf++;
	}
    } else {
	*selection = XInternAtom(display, name, False);
    }
    return conf;
}

static char *next_name(char **list)
{
    register char	*p;
    
    for(p = *list; **list && **list != ','; (*list)++);
    if(**list == ',') {
	**list = '\0';
	(*list)++;
    } else if(p == *list) {
	p = (char *)NULL;
    }
    return(p);
}

static Bool export_lang(XIMS ims)
{
#define _XIMP_BASE	"_XIMP_"
    XIMPCore	core = (XIMPCore)ims->protocol;
    Display 	*display = core->display;
    Window	imserver_window = core->window;
    Window	root = DefaultRootWindow(display);
    char	*locale_list = core->support_locale;
    char	*locale_name = next_name(&locale_list);
    char	im_name[32], im_lname[32];
    char	prop_data[32];
    Atom	selection_atom, selection_atom_long;
    int		conflict = 0;
    Bool	no_way = True;

    for(; locale_name; locale_name = next_name(&locale_list)) {
	sprintf(im_name, "%s%s", _XIMP_BASE, locale_name);
#undef _XIMP_BASE
	conflict = set_owner_atom(display, im_name, conflict, &selection_atom);
	if (conflict) {
	    printf("XIMP Dev. kit: Locale %s conflicts. Not served.\n",
					locale_name);
	    conflict = 0;
	    continue;
	} else {
	    if(core->ims_name && core->ims_version) {
		sprintf(prop_data, "%s.%s",
				core->ims_name,
				core->ims_version);
	    } else {
		prop_data[0] = '\0';
	    }
	    XSetSelectionOwner(display, selection_atom, imserver_window, 0L);
	    XChangeProperty(display, root, selection_atom, XA_STRING, 8,
			PropModeReplace, (unsigned char*)prop_data, strlen(prop_data));
	    no_way = False;
	    if(core->ims_name) {
		sprintf(im_lname, "%s@%s.%d", im_name,
						core->ims_name,
						core->screen);
		conflict = set_owner_atom(display, im_lname, conflict, &selection_atom_long);
		XSetSelectionOwner(display, selection_atom_long, imserver_window, 0L);
		XChangeProperty(display, root, selection_atom_long, XA_STRING, 8,
				PropModeReplace, (unsigned char*)prop_data, strlen(prop_data));
	    }
	}
    }
    return(no_way);
}

static Bool regist_atoms(XIMS ims)
{
    XIMPCore	core = (XIMPCore)ims->protocol;
    Display 	*display = core->display;
    Window	imserver_window = core->window;
    Atom	id, type;
    char	*ver_str = (char*)NULL;

    if(core->ximp_version == (Atom)NULL ||
       core->styles.count_styles == 0 ||
       core->ximp_type == (XIMPTypeRec*)NULL) {
	printf("XIMP Dev. kit error: Mandatory im values are not specified.\n");
	return True;
    }
    id = XInternAtom(display, _XIMP_VERSION, False);
    type = XA_STRING;
    ver_str = XGetAtomName(display, core->ximp_version);
    XChangeProperty(display, imserver_window, id, type, 8, PropModeReplace,
    	(unsigned char*)ver_str, strlen(ver_str));

    XFree(ver_str);
    id = type = XInternAtom(display, _XIMP_STYLE, False);
    XChangeProperty(display, imserver_window, id, type, 32, PropModeReplace,
			(unsigned char *) core->styles.supported_styles, core->styles.count_styles);

    id = type = XInternAtom(display, _XIMP_TYPE, False);
    XChangeProperty(display, imserver_window, id, type, 32, PropModeReplace,
                    (unsigned char *) core->ximp_type->types, core->ximp_type->num_of_types);

    if(core->start_keys.count_keys != 0) {
	id = type = XInternAtom(display, _XIMP_KEYS, False);
	XChangeProperty(display, imserver_window, id, type, 32, PropModeReplace,
			(unsigned char *) core->start_keys.keys_list,
			(sizeof(Ximp_Key)/sizeof(long)) * core->start_keys.count_keys);

	id = type = XInternAtom(display, _XIMP_SPROC_STARTED_KEYS, False);
	XChangeProperty(display, imserver_window, id, type, 32, PropModeReplace,
			(unsigned char *) core->start_keys.keys_list,
			(sizeof(Ximp_Key)/sizeof(long)) * core->start_keys.count_keys);
    }
    if(core->stop_keys.count_keys != 0) {
	id = type = XInternAtom(display, _XIMP_SPROC_STOPPED_KEYS, False);
	XChangeProperty(display, imserver_window, id, type, 32, PropModeReplace,
			(unsigned char *) core->stop_keys.keys_list,
			(sizeof(Ximp_Key)/sizeof(long)) * core->stop_keys.count_keys);
    }
    if(core->ims_name) {
	id = XInternAtom(display, _XIMP_SERVERNAME, False);
	type = XA_STRING;
	XChangeProperty(display, imserver_window, id, type, 8, PropModeReplace,
                    (unsigned char*)core->ims_name, strlen(core->ims_name));
    }
    if(core->ims_version) {
	id = XInternAtom(display, _XIMP_SERVERVERSION, False);
	type = XA_STRING;
	XChangeProperty(display, imserver_window, id, type, 8, PropModeReplace,
                    (unsigned char*)core->ims_version, strlen(core->ims_version));
    }
    if(core->vendor) {
	id = XInternAtom(display, _XIMP_VENDORNAME, False);
	type = XA_STRING;
	XChangeProperty(display, imserver_window, id, type, 8, PropModeReplace,
                    (unsigned char*)core->vendor, strlen(core->vendor));
    }
    if(core->support_ext) {
	Atom *atom_list;
	register int i = 0;
	register int counts = 0;
	id = type = XInternAtom(display, _XIMP_EXTENSIONS, False);
	if(core->support_ext & EXT_STATUS)
	    counts++;
	if(core->support_ext & EXT_BACKFRONT)
	    counts++;
	if(core->support_ext & EXT_CONV)
	    counts++;
	atom_list = (Atom*)malloc(sizeof(Atom) * counts);
	if(core->support_ext & EXT_STATUS) {
	    atom_list[i] = XInternAtom(display, XIMP_EXT_STAT_WIN, False);
	    i++;
	}
	if(core->support_ext & EXT_BACKFRONT) {
	    atom_list[i] = XInternAtom(display, XIMP_EXT_BACKFRONT, False);
	    i++;
	}
	if(core->support_ext & EXT_CONV) {
	    atom_list[i] = XInternAtom(display, XIMP_EXT_CONV, False);
	    i++;
	}
	XChangeProperty(display, imserver_window, id, type, 32, PropModeReplace,
                    (unsigned char*) atom_list, i);
	free(atom_list);
    }
    return False;
}

Status ximp_openIM(XIMS xims)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Window	win = core->window;

    if(export_lang(xims) || regist_atoms(xims)) {
	free_imvalues(xims->protocol);
	XFree(xims->protocol);
	return False;
    }
    core->mes_type = XInternAtom(core->display, _XIMP_PROTOCOL, False);
    _IMRegisterFilterByType(xims,
				win,
				ClientMessage,
				ClientMessage,
				_ximp_HandleProto,
				xims
				);
    return True;
}

static
char	*update_ximp_extension(XIMPCore core, XIMArg *ptr)
{
    register int i;
    for(i = 0; ptr[i].name; i++) {
	if(!strcmp(ptr[i].name, XIMPExtStatusWin)) {
	    core->support_ext |= EXT_STATUS;
	} else if(!strcmp(ptr[i].name, XIMPExtBackFront)) {
	    core->support_ext |= EXT_BACKFRONT;
	    core->ext_backfront = (long)ptr[i].value;
	} else if(!strcmp(ptr[i].name, XIMPExtConversion)) {
	    core->support_ext |= EXT_CONV;
	}
    }
    return (char*)NULL;
}

static
char	*update_ximp_imvalues(XIMPCore core, XIMArg *ptr)
{
    XIMArg	*imptr = (XIMArg*)ptr->value;

    for(; imptr->name; imptr++) {
	if(!strcmp(imptr->name, XIMPServerName)) {
	    XFree(core->ims_name);
	    core->ims_name = (char*)Xmalloc(strlen((char*)imptr->value) + 1);
	    if(core->ims_name == (char*)NULL) {
		return(imptr->name);
	    }
	    strcpy(core->ims_name, (char*)imptr->value);
	} else if(!strcmp(imptr->name, XIMPServerVersion)) {
	    XFree(core->ims_version);
	    core->ims_version = (char*)Xmalloc(strlen((char*)imptr->value) + 1);
	    if(core->ims_version == (char*)NULL) {
		return(imptr->name);
	    }
	    strcpy(core->ims_version, (char*)imptr->value);
	} else if(!strcmp(imptr->name, XIMPVendorName)) {
	    XFree(core->vendor);
	    core->vendor = (char*)Xmalloc(strlen((char*)imptr->value) + 1);
	    if(core->vendor == (char*)NULL) {
		return(imptr->name);
	    }
	    strcpy(core->vendor, (char*)imptr->value);
	} else if(!strcmp(imptr->name, XIMPExtension)) {
	    return(update_ximp_extension(core, (XIMArg*)imptr->value));
	} else {
	    return(imptr->name);
	}
    }
    return(NULL);
}

char	*ximp_setIMValues(XIMS xims, XIMArg *args)
{
    XIMArg	*ptr = args;
    XIMPCore	core = xims->protocol;
    char	*ret_name = (char *)NULL;

    for(; ptr->name; ptr++) {
	if(!strcmp(ptr->name, IMProtocolHandler)) {
	    core->imp_handler = (IMProtoHandler)ptr->value;
	} else if(!strcmp(ptr->name, XIMPProtoDepend)) {
	    ret_name = update_ximp_imvalues(core, ptr);
	    if(ret_name) {
		return(ret_name);
	    }
	} else {
	    ret_name = ptr->name;
	    return(ret_name);
	}
    }
    return(ret_name);
}

static char *
extract_ximp_extension(XIMPCore core, XIMArg **ptr)
{
    XIMArg	*ext_ptr;

    for(ext_ptr = (XIMArg*)(*ptr); ext_ptr->name; ext_ptr++) {
	if(!strcmp(ext_ptr->name, XIMPExtStatusWin)) {
	    *((Bool*)ext_ptr->value) = (core->support_ext & EXT_STATUS ?
				    True : False);
	} else if(!strcmp(ext_ptr->name, XIMPExtBackFront)) {
	    *((long*)ext_ptr->value) = (core->support_ext & EXT_BACKFRONT ?
				    core->ext_backfront : -1);
	} else if(!strcmp(ext_ptr->name, XIMPExtConversion)) {
	    *((Bool*)ext_ptr->value) = (core->support_ext & EXT_CONV ?
				    True : False);
	}
    }
    return(char*)NULL;
}

static char *
extract_ximp_imvalues(XIMPCore core, XIMArg *ptr)
{
    Display	*display = core->display;
    XIMArg	*imptr = (XIMArg*)ptr->value;
    char	*ret_val = (char *)NULL;

    for(; imptr->name; imptr++) {
	if(!strcmp(imptr->name, XIMPVersion)) {
	    char	*ptr = (char*)NULL;
	    ptr = XGetAtomName(display, core->ximp_version);
	    if(!ptr) {
		return(imptr->name);
	    } else {
		*((char**)(imptr->value)) = (char*)Xmalloc(strlen(ptr) + 1);
		if(*((char**)(imptr->value)) == (char*)NULL) {
		    XFree(ptr);
		    return(imptr->name);
		} else {
		    strcpy(*((char**)(imptr->value)), ptr);
		    XFree(ptr);
		}

	    }
	} else if(!strcmp(imptr->name, IMServerWindow)) {
	    *((Window*)(imptr->value)) = core->window;
	} else if(!strcmp(imptr->name, XIMPType)) {
	    XIMPTypeRec	**p_type = (XIMPTypeRec**)(imptr->value);
	    *p_type = (XIMPTypeRec*)Xmalloc(sizeof(XIMPTypeRec));
	    if(*p_type == NULL) {
		ret_val = (char*)imptr->name;
		return(ret_val);
	    }
	    (*p_type)->num_of_types = core->ximp_type->num_of_types;
	    (*p_type)->types = (unsigned long*)Xmalloc(sizeof(unsigned long) * core->ximp_type->num_of_types);
	    if((*p_type)->types == NULL) {
		XFree((void*)*imptr->value);
		ret_val = (char*)imptr->name;
		return(ret_val);
	    }
	    memmove((*p_type)->types,
			core->ximp_type->types,
			sizeof(unsigned long) * core->ximp_type->num_of_types);
	} else if(!strcmp(imptr->name, XIMPServerName)) {
	    *((char**)(imptr->value)) = (char*)Xmalloc(strlen(core->ims_name) + 1);
	    if(*((char**)(imptr->value))) {
		ret_val = (char*)imptr->name;
		return(ret_val);
	    }
	    strcpy((char*)*imptr->value, core->ims_name);
	} else if(!strcmp(imptr->name, XIMPServerVersion)) {
	    *((char**)(imptr->value)) = (char*)Xmalloc(strlen(core->ims_version) + 1);
	    if(*((char**)(imptr->value))) {
		ret_val = (char*)imptr->name;
		return(ret_val);
	    }
	    strcpy((char*)*imptr->value, core->ims_version);
	} else if(!strcmp(imptr->name, XIMPVendorName)) {
	    *((char**)(imptr->value)) = (char*)Xmalloc(strlen(core->vendor) + 1);
	    if(*((char**)(imptr->value))) {
		ret_val = (char*)imptr->name;
		return(ret_val);
	    }
	    strcpy((char*)*imptr->value, core->vendor);
	} else if(!strcmp(imptr->name, XIMPExtension)) {
	    return (extract_ximp_extension(core, (XIMArg**)imptr->value));
	}
    }
    return(ret_val);
}


char	*ximp_getIMValues(XIMS xims, XIMArg *args)
{
    XIMPCore	core = xims->protocol;
    Display	*display = core->display;
    XIMArg	*ptr;

    for(ptr = args; ptr->name; ptr++) {
	if(!strcmp(ptr->name, IMServerWindow)) {
	    *((Window*)(ptr->value)) = core->window;
	} else if(!strcmp(ptr->name, IMInputStyles)) {
	    XIMStyles	**p_styles = (XIMStyles**)ptr->value;
	    *p_styles = (XIMStyles*)Xmalloc(sizeof(XIMStyles));
	    if(*p_styles == NULL)
		return(ptr->name);
	    (*p_styles)->count_styles = core->styles.count_styles;
	    (*p_styles)->supported_styles =
	    	(XIMStyle*)Xmalloc(sizeof(XIMStyle) * core->styles.count_styles);
	    if((XIMStyle*)(*p_styles)->supported_styles == NULL)
		return(ptr->name);
	    memmove((XIMStyle*)(*p_styles)->supported_styles,
			core->styles.supported_styles,
			sizeof(XIMStyle) * (core->styles.count_styles));
	} else if(!strcmp(ptr->name, IMOnKeysList)) {
	    register int	i;
	    register Ximp_Key	*src;
	    register XIMTriggerKey	*dst;
	    XIMTriggerKeys	**p_triggerkeys = (XIMTriggerKeys**)ptr->value;
	    *p_triggerkeys = (XIMTriggerKeys*)Xmalloc(sizeof(XIMTriggerKeys));
	    if(*p_triggerkeys == NULL)
		return(ptr->name);
	    (*p_triggerkeys)->count_keys = core->start_keys.count_keys;
	    (*p_triggerkeys)->keylist =
		(XIMTriggerKey*)Xmalloc(sizeof(XIMTriggerKey) * core->start_keys.count_keys);
	    if((XIMTriggerKey*)(*p_triggerkeys)->keylist == NULL)
		return(ptr->name);
	    src = core->start_keys.keys_list;
	    dst = (*p_triggerkeys)->keylist;
	    for(i = 0; i < (int)core->start_keys.count_keys; i++, src++, dst++) {
		dst->keysym = src->keysym;
		dst->modifier = src->modifier;
		dst->modifier_mask = src->modifier_mask;
	    }
	} else if(!strcmp(ptr->name, IMOffKeysList)) {
	    register int	i;
	    register Ximp_Key	*src;
	    register XIMTriggerKey	*dst;
	    XIMTriggerKeys	**p_triggerkeys = (XIMTriggerKeys**)ptr->value;
	    *p_triggerkeys = (XIMTriggerKeys*)Xmalloc(sizeof(XIMTriggerKeys));
	    if(*p_triggerkeys == NULL)
		return(ptr->name);
	    (*p_triggerkeys)->count_keys = core->stop_keys.count_keys;
	    (*p_triggerkeys)->keylist =
		(XIMTriggerKey*)Xmalloc(sizeof(XIMTriggerKey) * core->stop_keys.count_keys);
	    if((XIMTriggerKey*)(*p_triggerkeys)->keylist == NULL)
		return(ptr->name);
	    src = core->start_keys.keys_list;
	    dst = (*p_triggerkeys)->keylist;
	    for(i = 0; i < (int)core->stop_keys.count_keys; i++, src++, dst++) {
		dst->keysym = src->keysym;
		dst->modifier = src->modifier;
		dst->modifier_mask = src->modifier_mask;
	    }
	} else if(!strcmp(ptr->name, IMProtocolHandler)) {
	    *(IMProtoHandler*)(ptr->value) = core->imp_handler;
	} else if(!strcmp(ptr->name, IMXEventHandler)) {
	    *(XEventHandler*)(ptr->value) = core->xev_handler;
	} else if(!strcmp(ptr->name, XIMPProtoDepend)) {
	    return(extract_ximp_imvalues(core, ptr));
	}
    }
    return NULL;
}

Status	ximp_forwardEvent(XIMS xims, IMPProtocol *improto)
{
    XIMPCore	core = (XIMPCore)xims->protocol;

    _send_keyevent(core, improto);
}
Status	ximp_commitString(XIMS xims, IMPProtocol *improto)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    _send_commit(core, improto);
}
Status	ximp_wait(XIMS xims, IMPProtocol *improto)
{
}

Status ximp_closeIM(XIMS xims)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    free_imvalues(core);
    XFree(core);
    return True;
}
#endif /* _XIMPMETHODS_C_ */
