/* Copyright 1994 by Sun Microsystems, Inc. */
/* @(#)XimpProc.c	1.8 94/02/16 */
/******************************************************************
 
              Copyright 1994 by Sun Microsystems, Inc.
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.
Sun Microsystems, Inc. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without
express or implied warranty.
 
Sun Microsystems Inc. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL Sun Microsystems, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hiromu Inukai (inukai@Japan.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/

#ifndef	_XIMPPROC_C_
#define	_XIMPPROC_C_
#include <X11/Xatom.h>
#include "XimpData.h"

static protocol_version proto_num = ximp_none;
static mask_kind kind = none_mask;

static Atom		IMA_VERSION = (Atom)0;
static Atom		IMA_FOCUS = (Atom)0;
static Atom		IMA_PREEDIT = (Atom)0;
static Atom		IMA_PREEDITFONT = (Atom)0;
static Atom		IMA_STATUS = (Atom)0;
static Atom		IMA_STATUSFONT = (Atom)0;
static Atom		IMA_CTEXT = (Atom)0;
static Atom		IMA_COMPOUND_TEXT = (Atom)0;
static Atom		IMA_EXT_SAMPLE_STATUSWINDOW = (Atom)0;
static Atom		IMA_EXT_SAMPLE_BACK_FRONT = (Atom)0;
static Atom		IMA_PREEDIT_DRAW_DATA = (Atom)0;
static Atom		IMA_FEEDBACKS = (Atom)0;
#ifdef notdef
static Atom		IMA_EXT_XIMP_LOOKUPCHOICES = (Atom)0;
static Atom		IMA_EXT_XIMP_CHOICE_START_REQ = (Atom)0;
static Atom		IMA_EXT_XIMP_CHOICE_START_REP = (Atom)0;
static Atom		IMA_EXT_XIMP_CHOICE_DRAW_REQ = (Atom)0;
static Atom		IMA_EXT_XIMP_CHOICE_PROC_REQ = (Atom)0;
static Atom		IMA_EXT_XIMP_CHOICE_PROC_REP = (Atom)0;
#endif
static Atom		IMA_EXT_XIMP_CONVERSION = (Atom)0;
static Atom		XA_COMPOUND_TEXT = (Atom)0;
static Atom		IMA_TYPE = (Atom)0;

static void	_sendby_prop(XIMPCore, long, char*, int);
static void	_sendby_cmsg(XIMPCore, long, char*, int);
static Bool	_keypress_filter(XIMS, Window, XEvent*, XPointer);
static Bool	_keyrelease_filter(XIMS, Window, XEvent*, XPointer);
static Bool	_destroy_filter(XIMS, Window, XEvent*, XPointer);
static void	_reg_keypress(XIMS, long);
static void	_reg_keyrelease(XIMS, long);
static void	_reg_destroy(XIMS, long);
static void	_unreg_keypress(XIMS, long);
static void	_unreg_keyrelease(XIMS, long);
static void	_unreg_destroy(XIMS, long);
extern Window	_find_focus(XIMPCore, long);
extern Window	_find_client(XIMPCore, long);
extern long	_find_flt_mask(XIMPCore, long);
extern long	_find_icid_cw(XIMPCore, Window);
extern long	_find_icid_fw(XIMPCore, Window);
extern long	_find_evmask(XIMPCore, long);
extern Bool	_find_state(XIMPCore, long);
extern Bool	_find_match(XIMPCore, long, unsigned int, unsigned int);
extern void	_set_focus(XIMPCore, long, Window);
extern void	_set_client(XIMPCore, long, Window);
extern void	_set_flt_mask(XIMPCore, long, long);
extern void	_set_evmask(XIMPCore, long, long);
extern void	_set_state(XIMPCore, long, Bool);
extern void	_set_match(XIMPCore, long, unsigned int, unsigned int);
extern void	_unset_flt_mask(XIMPCore, long, long);
extern void	_add_iclist(XIMPCore, long, XIMPICValuesStruct*);
extern void	_remove_iclist(XIMPCore, long);
extern void	_check_alterkey4(XIMPCore, XClientMessageEvent*, int);
extern void	_check_alterkey3(XIMPCore, XClientMessageEvent*, int);
extern void	_send_proto(XIMPCore, int, int, int, int, int);

static Bool
_check_mask(long mask, mask_kind kind)
{
    switch(proto_num) {
      case ximp_40:
	switch(kind) {
	  case preedit_mask:
	    if(mask &
		(XIMP_PRE_AREA_MASK4 |
		 XIMP_PRE_AREANEED_MASK4 |
		 XIMP_PRE_COLORMAP_MASK4 |
		 XIMP_PRE_STD_COLORMAP_MASK4 |
		 XIMP_PRE_FG_MASK4 |
		 XIMP_PRE_BG_MASK4 |
		 XIMP_PRE_BGPIXMAP_MASK4 |
		 XIMP_PRE_LINESP_MASK4 |
		 XIMP_PRE_CURSOR_MASK4 |
		 XIMP_PRE_SPOTL_MASK4)) {
		    return True;
	    } else {
		    return False;
	    }
	  case status_mask:
	    if(mask &
		(XIMP_STS_AREA_MASK4 |
		 XIMP_STS_AREANEED_MASK4 |
		 XIMP_STS_COLORMAP_MASK4 |
		 XIMP_STS_STD_COLORMAP_MASK4 |
		 XIMP_STS_FG_MASK4 |
		 XIMP_STS_BG_MASK4 |
		 XIMP_STS_BGPIXMAP_MASK4 |
		 XIMP_STS_LINESP_MASK4 |
		 XIMP_STS_CURSOR_MASK4 |
		 XIMP_STS_WINDOW_MASK4)) {
		    return True;
	    } else {
		    return False;
	    }
	}
      case ximp_35:
	switch(kind) {
	  case preedit_mask:
	    if(mask &
		(XIMP_PRE_AREA_MASK3 |
		 XIMP_PRE_AREANEED_MASK3 |
		 XIMP_PRE_COLORMAP_MASK3 |
		 XIMP_PRE_FG_MASK3 |
		 XIMP_PRE_BG_MASK3 |
		 XIMP_PRE_BGPIXMAP_MASK3 |
		 XIMP_PRE_LINESP_MASK3 |
		 XIMP_PRE_CURSOR_MASK3 |
		 XIMP_PRE_SPOTL_MASK3)) {
		    return True;
	    } else {
		    return False;
	    }
	  case status_mask:
	    if(mask &
		(XIMP_STS_AREA_MASK3 |
		 XIMP_STS_AREANEED_MASK3 |
		 XIMP_STS_COLORMAP_MASK3 |
		 XIMP_STS_FG_MASK3 |
		 XIMP_STS_BG_MASK3 |
		 XIMP_STS_BGPIXMAP_MASK3 |
		 XIMP_STS_LINESP_MASK3 |
		 XIMP_STS_CURSOR_MASK3 |
		 XIMP_STS_WINDOW_MASK3)) {
		    return True;
	    } else {
		    return False;
	    }
	}
    }
}

static Bool
_get_props(
	   XIMPCore	core,
	   Window	c_win,
	   long		mask,
	   Window	*focus_win,
	   Ximp_PreeditPropRec4 *pre_values,
	   Ximp_StatusPropRec4 *sts_values,
	   char		**pre_font,
	   char		**sts_font,
	   unsigned long *type_mask)
{
    _check_atom(core->display, &IMA_FOCUS, "_XIMP_FOCUS");
    _check_atom(core->display, &IMA_PREEDIT, "_XIMP_PREEDIT");
    _check_atom(core->display, &IMA_STATUS, "_XIMP_STATUS");
    _check_atom(core->display, &IMA_PREEDITFONT, "_XIMP_PREEDITFONT");
    _check_atom(core->display, &IMA_STATUSFONT, "_XIMP_STATUSFONT");
    _check_atom(core->display, &IMA_TYPE, "_XIMP_TYPE");

    switch(proto_num) {
      case ximp_40:
	if(mask & XIMP_FOCUS_WIN_MASK4) {
	    _get_prop(core->display,
			c_win,
			IMA_FOCUS,
			XA_WINDOW,
			(char*)focus_win);
	}
	if(_check_mask(mask, preedit_mask)) {
	    _get_prop(core->display,
		  c_win,
		  IMA_PREEDIT,
		  IMA_PREEDIT,
		  (char*)pre_values);
	}
	if(_check_mask(mask, status_mask)) {
	    _get_prop(core->display,
		  c_win,
		  IMA_STATUS,
		  IMA_STATUS,
		  (char*)sts_values);
	}
	if(mask & XIMP_PRE_FONT_MASK4) {
	    _get_prop(core->display,
		  c_win,
		  IMA_PREEDITFONT,
		  XA_STRING,
		  (char*)pre_font);
	}
	if(mask & XIMP_STS_FONT_MASK4) {
	    _get_prop(core->display,
		  c_win,
		  IMA_STATUSFONT,
		  XA_STRING,
		  (char*)sts_font);
	}
	if(mask & XIMP_SERVERTYPE_MASK4) {
	    _get_prop(core->display,
		  c_win,
		  IMA_TYPE,
		  IMA_TYPE,
		  (char*)type_mask);
	}
	break;
      case ximp_35:
	if(mask & XIMP_FOCUS_WIN_MASK3) {
	    _get_prop(core->display,
			c_win,
			IMA_FOCUS,
			XA_WINDOW,
			(char*)focus_win);
	}
	if(_check_mask(mask, preedit_mask)) {
	    Ximp_PreeditPropRec3	preedit_bc;
	    memset(&preedit_bc, 0, sizeof(Ximp_PreeditPropRec3));
	    _get_prop(core->display,
		  c_win,
		  IMA_PREEDIT,
		  IMA_PREEDIT,
		  (char*)&(preedit_bc));
	    pre_values->Area         = preedit_bc.Area;
	    pre_values->AreaNeeded   = preedit_bc.AreaNeeded;
	    pre_values->SpotLocation = preedit_bc.SpotLocation;
	    pre_values->Colormap     = preedit_bc.Colormap;
	    pre_values->Foreground   = preedit_bc.Foreground;
	    pre_values->Background   = preedit_bc.Background;
	    pre_values->Bg_Pixmap    = preedit_bc.Bg_Pixmap;
	    pre_values->LineSpacing  = preedit_bc.LineSpacing;
	    pre_values->Cursor       = preedit_bc.Cursor;
	}
	if(_check_mask(mask, status_mask)) {
	    Ximp_StatusPropRec3	status_bc;
	    memset(&status_bc, 0, sizeof(Ximp_StatusPropRec3));
	    _get_prop(core->display,
		  c_win,
		  IMA_STATUS,
		  IMA_STATUS,
		  (char*)&(status_bc));
            sts_values->Area        = status_bc.Area;
            sts_values->AreaNeeded  = status_bc.AreaNeeded;
            sts_values->Colormap    = status_bc.Colormap;
            sts_values->Foreground  = status_bc.Foreground;
            sts_values->Background  = status_bc.Background;
            sts_values->Bg_Pixmap   = status_bc.Bg_Pixmap;
            sts_values->LineSpacing = status_bc.LineSpacing;
            sts_values->Cursor      = status_bc.Cursor;
            sts_values->window      = status_bc.window;
	}
	if(mask & XIMP_PRE_FONT_MASK3) {
	    _get_prop(core->display,
		  c_win,
		  IMA_PREEDITFONT,
		  XA_STRING,
		  (char*)pre_font);
	}
	if(mask & XIMP_STS_FONT_MASK3) {
	    _get_prop(core->display,
		  c_win,
		  IMA_STATUSFONT,
		  XA_STRING,
		  (char*)sts_font);
	}
	break;
    }
}

static Bool
_set_props(
	   XIMPCore	core,
	   Window	client_win,
	   long		mask,
	   Window	focus_win,
	   Ximp_PreeditPropRec4 *pre_values,
	   Ximp_StatusPropRec4  *sts_values,
	   char		*pre_font,
	   char		*sts_font,
	   unsigned long	type_mask)
{
    _check_atom(core->display, &IMA_FOCUS, "_XIMP_FOCUS");
    _check_atom(core->display, &IMA_PREEDIT, "_XIMP_PREEDIT");
    _check_atom(core->display, &IMA_STATUS, "_XIMP_STATUS");
    _check_atom(core->display, &IMA_PREEDITFONT, "_XIMP_PREEDITFONT");
    _check_atom(core->display, &IMA_STATUSFONT, "_XIMP_STATUSFONT");
    _check_atom(core->display, &IMA_TYPE, "_XIMP_TYPE");

    switch(proto_num) {
      case ximp_40:
	if(mask & XIMP_FOCUS_WIN_MASK4) {
	    _set_prop(core->display,
			client_win,
			IMA_FOCUS,
			XA_WINDOW,
			(char*)focus_win,
			1);
	}
	if(_check_mask(mask, preedit_mask)) {
	    _set_prop(core->display,
		  client_win,
		  IMA_PREEDIT,
		  IMA_PREEDIT,
		  (char*)pre_values,
		  XIMP_PREEDIT_MAX_LONG4);
	}
	if(_check_mask(mask, status_mask)) {
	    _set_prop(core->display,
		  client_win,
		  IMA_STATUS,
		  IMA_STATUS,
		  (char*)sts_values,
		  XIMP_STATUS_MAX_LONG4);
	}
	if(mask & XIMP_PRE_FONT_MASK4) {
	    _set_prop(core->display,
		  client_win,
		  IMA_PREEDITFONT,
		  XA_STRING,
		  (char*)pre_font,
		  strlen(pre_font));
	}
	if(mask & XIMP_STS_FONT_MASK4) {
	    _set_prop(core->display,
		  client_win,
		  IMA_STATUSFONT,
		  XA_STRING,
		  (char*)sts_font,
		  strlen(sts_font));
	}
	if(mask & XIMP_SERVERTYPE_MASK4) {
	    _set_prop(core->display,
		  client_win,
		  IMA_TYPE,
		  IMA_TYPE,
		  (char*)type_mask,
		  1);
	}
	break;
      case ximp_35:
	if(mask & XIMP_FOCUS_WIN_MASK3) {
	    _set_prop(core->display,
			client_win,
			IMA_FOCUS,
			XA_WINDOW,
			(char*)focus_win,
			1);
	}
	if(_check_mask(mask, preedit_mask)) {
	    Ximp_PreeditPropRec3	preedit_bc;
	    memset(&preedit_bc, 0, sizeof(Ximp_PreeditPropRec3));

	    preedit_bc.Area		= pre_values->Area;
	    preedit_bc.AreaNeeded	= pre_values->AreaNeeded;
	    preedit_bc.SpotLocation	= pre_values->SpotLocation;
	    preedit_bc.Colormap		= pre_values->Colormap;
	    preedit_bc.Foreground	= pre_values->Foreground;
	    preedit_bc.Background	= pre_values->Background;
	    preedit_bc.Bg_Pixmap	= pre_values->Bg_Pixmap;
	    preedit_bc.LineSpacing	= pre_values->LineSpacing;
	    preedit_bc.Cursor		= pre_values->Cursor;

	    _set_prop(core->display,
			client_win,
		  IMA_PREEDIT,
		  IMA_PREEDIT,
		  (char*)&(preedit_bc),
		  XIMP_PREEDIT_MAX_LONG3);
	}
	if(_check_mask(mask, status_mask)) {
	    Ximp_StatusPropRec3		status_bc;
	    memset(&status_bc, 0, sizeof(Ximp_StatusPropRec3));

	    status_bc.Area		= sts_values->Area;
	    status_bc.AreaNeeded	= sts_values->AreaNeeded;
	    status_bc.Colormap		= sts_values->Colormap;
	    status_bc.Foreground	= sts_values->Foreground;
	    status_bc.Background	= sts_values->Background;
	    status_bc.Bg_Pixmap		= sts_values->Bg_Pixmap;
	    status_bc.LineSpacing	= sts_values->LineSpacing;
	    status_bc.Cursor		= sts_values->Cursor;
	    status_bc.window		= sts_values->window;

	    _set_prop(core->display,
		  client_win,
		  IMA_STATUS,
		  IMA_STATUS,
		  (char*)&(status_bc),
		  XIMP_STATUS_MAX_LONG3);
	}
	if(mask & XIMP_PRE_FONT_MASK3) {
	    _set_prop(core->display,
		  client_win,
		  IMA_PREEDITFONT,
		  XA_STRING,
		  (char*)pre_font,
		  strlen(pre_font));
	}
	if(mask & XIMP_STS_FONT_MASK3) {
	    _set_prop(core->display,
		  client_win,
		  IMA_STATUSFONT,
		  XA_STRING,
		  (char*)sts_font,
		  strlen(sts_font));
	}
	break;
    }
    return True;
}

Bool _proc_keypress(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPKeyPressStruct	*keypress =
			    (XIMPKeyPressStruct*)&(call_data.keypress);
    Bool		is_reg = False;

    if(proto_num == ximp_40) {
	_check_alterkey4(core, &event, XIMP_KEYPRESS4);
	if((core->cur_type == XIMP_FE_TYPE1) &&
	   !_find_state(core, event.data.l[1]) &&
	   _find_alter(core, event.data.l[1])) {
		_unreg_keypress(xims, event.data.l[1]);
	}
    } else if(proto_num == ximp_35) {
	_check_alterkey3(core, &event, XIMP_KEYPRESS3);
	if((core->cur_type == XIMP_FRONTEND) &&
	   !_find_state(core, event.data.l[1]) &&
	   _find_alter(core, event.data.l[1])) {
		_unreg_keypress(xims, event.data.l[1]);
	}
    }
    memset(&call_data, 0, sizeof(IMPProtocol));
    keypress->type	= event.data.l[0];
    keypress->icid	= event.data.l[1];
    keypress->keycode	= event.data.l[2];
    keypress->state	= event.data.l[3];
    keypress->time	= (proto_num == ximp_40 ? event.data.l[4] : 0);

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	if((proto_num == ximp_40) && (core->cur_type & XIMP_SYNC)) {
	    _send_proto(core,
			XIMP_KEYPRESS_RETURN4,
			keypress->icid,
			0, 0, 0);
	}
	return True;
    }
    return False;
}

Bool _proc_keyrelease(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPKeyReleaseStruct *keyrelease =
			 (XIMPKeyReleaseStruct*)&(call_data.keyrelease);

    if(!_find_match(core, event.data.l[1], event.data.l[2], event.data.l[3])) {
	return True;	/* Just ignore to keep matching */
    }
    _check_alterkey4(core, &event, XIMP_KEYRELEASE4);
    if((core->cur_type == XIMP_FE_TYPE1) &&
       !_find_state(core, event.data.l[1]) &&
       _find_alter(core, event.data.l[1])) {
	    _unreg_keyrelease(xims, event.data.l[1]);
    }
    memset(&call_data, 0, sizeof(IMPProtocol));
    keyrelease->type	= event.data.l[0];
    keyrelease->icid	= event.data.l[1];
    keyrelease->keycode	= event.data.l[2];
    keyrelease->state	= event.data.l[3];
    keyrelease->time	= event.data.l[4];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	if((proto_num == ximp_40) &&
	   (core->cur_type & XIMP_SYNC) &&
	   _find_match(core, event.data.l[1], event.data.l[2], event.data.l[ 3])) {
	    _send_proto(core,
			XIMP_KEYRELEASE_RETURN4,
			keyrelease->icid,
			0, 0, 0);
	}
	return True;
    }
    return False;
}

Bool _proc_create(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    Display		*display = core->display;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPICValuesStruct	*create =
			    (XIMPICValuesStruct*)&(call_data.create);
    Bool	flag;

    memset(&call_data, 0, sizeof(IMPProtocol));
    if(proto_num == ximp_none) {
	_check_version(xims, ev, &proto_num);
    }
    switch(event.data.l[0]) {
      case XIMP_CREATE4:
	if(proto_num == ximp_40) {
	    create->type = event.data.l[0];
	    create->client_win = event.data.l[1];
	    create->style = event.data.l[2];
	    create->attr_mask = event.data.l[3];
	    create->fwin_sel_mask = event.data.l[4];
	    create->pre_values = (Ximp_PreeditPropRec4*)
				   malloc(sizeof(Ximp_PreeditPropRec4));
	    create->sts_values = (Ximp_StatusPropRec4*)
				   malloc(sizeof(Ximp_StatusPropRec4));
	    flag = _get_props(core, create->client_win,
				create->attr_mask,
				&(create->focus_win),
				create->pre_values,
				create->sts_values,
				&(create->pre_font),
				&(create->sts_font),
				&(create->ximp_type_mask));
	    if(!flag) {
		/*
		 * Call XIMP_ERROR because of lack of properties
		 */
	    }
	    core->cur_type = create->ximp_type_mask;
	} else {
	    /*
	     * Call XIMP_ERROR because of wrong protocol version
	     */
	}
	break;
      case XIMP_CREATE3:
	if(proto_num == ximp_35) {
	    create->type = event.data.l[0];
	    create->client_win = event.data.l[1];
	    create->style = event.data.l[2];
	    create->attr_mask = event.data.l[3];
	    create->fwin_sel_mask = (long)0;
	    create->pre_values = (Ximp_PreeditPropRec4*)
				   malloc(sizeof(Ximp_PreeditPropRec4));
	    create->sts_values = (Ximp_StatusPropRec4*)
				   malloc(sizeof(Ximp_StatusPropRec4));
	    flag = _get_props(core, create->client_win,
				create->attr_mask,
				&(create->focus_win),
				create->pre_values,
				create->sts_values,
				&(create->pre_font),
				&(create->sts_font),
				NULL);
	    if(!flag) {
		/*
		 * Call XIMP_ERROR because of lack of properties
		 */
	    }
	} else {
	    /*
	     * Call XIMP_ERROR because of wrong protocol version
	     */
	}
	break;
      default:
	/*
	 * Call XIMP_ERROR because of unknown XIMP_CREATE request
	 */
	break;
    }
    /*
     * When focus window setting is deferred, use client window
     * as a fallback default.
     */
    if(!(create->focus_win)) {
	create->focus_win = create->client_win;
    }
    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	_add_iclist(core, create->icid, create);
	_reg_destroy(xims, create->icid);
	/* If FrontEnd Type2 or Type3, attach filters to focus win. */
	if((core->cur_type == XIMP_FE_TYPE2) ||
	   (core->cur_type == XIMP_FE_TYPE3)) {
	    core->active_icid = create->icid;
	    _reg_keypress(xims, create->icid);
	    if(_find_evmask(core, create->icid) & KeyReleaseMask) {
		_reg_keyrelease(xims, create->icid);
	    }
	}
	_send_proto(core,
		    (proto_num == ximp_40 ?
		      XIMP_CREATE_RETURN4 :
		      XIMP_CREATE_RETURN3),
		    call_data.create.icid,
		    0,
		    0,
		    0);
	return True;
    }
    return False;
}

Bool _proc_destroy(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPDestroyStruct	*destroy =
			    (XIMPDestroyStruct*)&(call_data.destroy);

    memset(&call_data, 0, sizeof(IMPProtocol));
    destroy->type = event.data.l[0];
    destroy->icid = event.data.l[1];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	_unreg_destroy(xims, destroy->icid);
	_unreg_keypress(xims, destroy->icid);
	_unreg_keyrelease(xims, destroy->icid);
	_remove_iclist(core, destroy->icid);
	return True;
    }
    return False;
}

Bool _proc_start(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    Display		*display = core->display;
    IMPProtocol		call_data;
    XClientMessageEvent event = ev->xclient;
    XIMPSProcStartedStruct
	*sprocstart = (XIMPSProcStartedStruct*)&(call_data.sprocstart);

    memset(&call_data, 0, sizeof(IMPProtocol));
    sprocstart->type = event.data.l[0];
    sprocstart->icid = event.data.l[1];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	switch(proto_num) {
	  case ximp_40:
	    if(core->cur_type == XIMP_FE_TYPE1) {
		core->active_icid = sprocstart->icid;
		_reg_keypress(xims, sprocstart->icid);
		if(_find_evmask(core, sprocstart->icid) & KeyReleaseMask) {
		    _reg_keyrelease(xims, sprocstart->icid);
		}
	    }
	    break;
	  case ximp_35:
	    if(core->cur_type == XIMP_FRONTEND) {
		core->active_icid = sprocstart->icid;
		_reg_keypress(xims, sprocstart->icid);
	    }
	    break;
	  default:
	    break;
	}
	_set_state(core, sprocstart->icid, True);
	_send_proto(core,
		    (proto_num == ximp_40 ?
		     XIMP_SPROC_STARTED4 :
		     XIMP_PROCESS_BEGIN3),
		    sprocstart->icid,
		    0,
		    0,
		    0);
	return True;
    }
    return False;
}

Bool _proc_end(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPSProcStoppedStruct
	*sprocstop = (XIMPSProcStoppedStruct*)&(call_data.sprocstop);

    memset(&call_data, 0, sizeof(IMPProtocol));
    sprocstop->type = event.data.l[0];
    sprocstop->icid = event.data.l[1];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	_unreg_keypress(xims, sprocstop->icid);
	_unreg_keyrelease(xims, sprocstop->icid);
	_set_state(core, sprocstop->icid, False);
	_send_proto(core,
		    XIMP_PROCESS_END3,
		    sprocstop->icid,
		    0,
		    0,
		    0);
	return True;
    }
    return False;
}

Bool _proc_setfocus(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPSetFocusStruct
	*setfocus = (XIMPSetFocusStruct*)&(call_data.setfocus);

    memset(&call_data, 0, sizeof(IMPProtocol));
    setfocus->type = event.data.l[0];
    setfocus->icid = event.data.l[1];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	core->active_icid = setfocus->icid;
	return True;
    }
    return False;
}

Bool _proc_unsetfocus(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPUnSetFocusStruct
	*unsetfocus = (XIMPUnSetFocusStruct*)&(call_data.unsetfocus);

    memset(&call_data, 0, sizeof(IMPProtocol));
    unsetfocus->type = event.data.l[0];
    unsetfocus->icid = event.data.l[1];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	return True;
    }
    return False;
}

Bool _proc_clientwin(XIMS xims, XEvent *ev)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    IMPProtocol	call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPClientWindowStruct
	*clientwin = (XIMPClientWindowStruct*)&(call_data.clientwin);

    if(proto_num == ximp_40) {
	memset(&call_data, 0, sizeof(IMPProtocol));
	clientwin->type = event.data.l[0];
	clientwin->icid = event.data.l[1];
	clientwin->new_client_win = event.data.l[2];
	clientwin->new_fwin_mask = event.data.l[3];

	if(core->imp_handler) {
	    (core->imp_handler)(xims, &call_data);
	    _set_evmask(core, clientwin->icid, event.data.l[3]);
	    _set_client(core,
			clientwin->icid,
			clientwin->new_client_win);
	    _send_proto(core,
			XIMP_CLIENT_WINDOW_RETURN4,
			call_data.clientwin.icid,
			0,
			0,
			0);
	    return True;
	}
    }
    return False;
}

Bool _proc_focuswin(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPFocusWindowStruct *focuswin = (XIMPFocusWindowStruct*)&(call_data.focuswin);
    Window	old_win;

    if(proto_num == ximp_40) {
	memset(&call_data, 0, sizeof(IMPProtocol));
	focuswin->type = event.data.l[0];
	focuswin->icid = event.data.l[1];
	focuswin->new_focus_win = event.data.l[2];
	focuswin->new_fwin_mask = event.data.l[3];

	if(core->imp_handler) {
	    (core->imp_handler)(xims, &call_data);
	    /*
	     * Change filters to new focus win
	     */
	    _set_evmask(core, focuswin->icid, event.data.l[3]);
	    _unreg_destroy(xims, focuswin->icid);
	    _unreg_keypress(xims, focuswin->icid);
	    _unreg_keyrelease(xims, focuswin->icid);
	    _set_focus(core, focuswin->icid, focuswin->new_focus_win);
	    _reg_destroy(xims, focuswin->icid);
	    if(core->cur_type == XIMP_FE_TYPE2 ||
	       core->cur_type == XIMP_FE_TYPE3 ||
	       (core->cur_type == XIMP_FE_TYPE1 &&
		  _find_state(core, focuswin->icid))) {
		_reg_keypress(xims, focuswin->icid);
		if(_find_evmask(core, focuswin->icid) & KeyReleaseMask) {
		    _reg_keyrelease(xims, focuswin->icid);
		}
	    }
	    _send_proto(core,
			XIMP_FOCUS_WINDOW_RETURN4,
			call_data.focuswin.icid,
			0,
			0,
			0);
	    return True;
	}
    }
    return False;
}

Bool _proc_move(XIMS xims, XEvent *ev)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    IMPProtocol	call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPMoveStruct *move = (XIMPMoveStruct*)&(call_data.move);

    memset(&call_data, 0, sizeof(IMPProtocol));
    move->type = event.data.l[0];
    move->icid = event.data.l[1];
    move->x = event.data.l[2];
    move->y = event.data.l[3];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	return True;
    }
    return False;
}

Bool _proc_setval(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    Display		*display = core->display;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPICValuesStruct	*setvalue = (XIMPICValuesStruct*)&(call_data.setvalue);
    Bool	flag;

    memset(&call_data, 0, sizeof(IMPProtocol));
    switch(event.data.l[0]) {
      case XIMP_SETVALUE4:
	if(proto_num == ximp_40) {
	    setvalue->type = event.data.l[0];
	    setvalue->icid = event.data.l[1];
	    setvalue->attr_mask = event.data.l[2];
	    setvalue->pre_values = (Ximp_PreeditPropRec4*)
				   malloc(sizeof(Ximp_PreeditPropRec4));
	    setvalue->sts_values = (Ximp_StatusPropRec4*)
				    malloc(sizeof(Ximp_StatusPropRec4));
	    setvalue->attr_mask &= ~(XIMP_FOCUS_WIN_MASK4|XIMP_SERVERTYPE_MASK4);
	    flag = _get_props(core,
				_find_client(core, setvalue->icid),
				setvalue->attr_mask,
				NULL,
				setvalue->pre_values,
				setvalue->sts_values,
				&(setvalue->pre_font),
				&(setvalue->sts_font),
				NULL);
	    if(!flag) {
		/*
		 * Call XIMP_ERROR because of lack of properties
		 */
	    }
	} else {
	    /*
	     * Call XIMP_ERROR because of wrong protocol version
	     */
	}
	break;
      case XIMP_SETVALUE3:
	if(proto_num == ximp_35) {
	    setvalue->type = event.data.l[0];
	    setvalue->icid = event.data.l[1];
	    setvalue->attr_mask = event.data.l[2];
	    setvalue->pre_values = (Ximp_PreeditPropRec4*)
				   malloc(sizeof(Ximp_PreeditPropRec4));
	    setvalue->sts_values = (Ximp_StatusPropRec4*)
				   malloc(sizeof(Ximp_StatusPropRec4));
	    flag = _get_props(core,
				_find_client(core, setvalue->icid),
				setvalue->attr_mask,
				&(setvalue->focus_win),
				setvalue->pre_values,
				setvalue->sts_values,
				&(setvalue->pre_font),
				&(setvalue->sts_font),
				NULL);
	    if(!flag) {
		/*
		 * Call XIMP_ERROR because of lack of properties
		 */
	    }
	} else {
	    /*
	     * Call XIMP_ERROR because of wrong protocol version
	     */
	}
	break;
      default:
	/*
	 * Call XIMP_ERROR because of unknown XIMP_CREATE request
	 */
	break;
    }
    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	if((proto_num == ximp_35) && setvalue->focus_win) {
	    _unreg_destroy(xims, setvalue->icid);
	    _unreg_keypress(xims, setvalue->icid);
	    _set_focus(core, setvalue->icid, setvalue->focus_win);
	    _reg_destroy(xims, setvalue->icid);
	    if((core->cur_type & XIMP_FRONTEND) && _find_state(core, setvalue->icid)) {
		_reg_keypress(xims, setvalue->icid);
	    }
	}
	return True;
    }
    return False;
}

Bool _proc_getval(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    Display		*display = core->display;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPICValuesStruct	*getvalue = (XIMPICValuesStruct*)&(call_data.getvalue);
    Bool	flag;

    memset(&call_data, 0, sizeof(IMPProtocol));
    switch(event.data.l[0]) {
      case XIMP_GETVALUE4:
	if(proto_num == ximp_40) {
	    getvalue->type = event.data.l[0];
	    getvalue->icid = event.data.l[1];
	    getvalue->attr_mask = event.data.l[2];
	    getvalue->ximp_type_mask = core->cur_type;
	    if(core->imp_handler) {
		(core->imp_handler)(xims, &call_data);
	    } else {
		return False;
	    }
	    _set_props(core,
			_find_client(core, getvalue->icid),
			getvalue->attr_mask,
			getvalue->focus_win,
			getvalue->pre_values,
			getvalue->sts_values,
			getvalue->pre_font,
			getvalue->sts_font,
			getvalue->ximp_type_mask);
	    free(getvalue->pre_values);
	    free(getvalue->sts_values);
	    free(getvalue->pre_font);
	    free(getvalue->sts_font);
	    _send_proto(core,
		    XIMP_GETVALUE_RETURN4,
		    call_data.getvalue.icid,
		    0,
		    0,
		    0);
	    if(!flag) {
		/*
		 * Call XIMP_ERROR because of lack of properties
		 */
	    }
	} else {
	    /*
	     * Call XIMP_ERROR because of wrong protocol version
	     */
	}
	break;
      case XIMP_GETVALUE3:
	if(proto_num == ximp_35) {
	    getvalue->type = event.data.l[0];
	    getvalue->icid = event.data.l[1];
	    getvalue->attr_mask = event.data.l[2];
	    if(core->imp_handler) {
		(core->imp_handler)(xims, &call_data);
	    } else {
		return False;
	    }
	    _set_props(core,
			_find_client(core, getvalue->icid),
			getvalue->attr_mask,
			getvalue->focus_win,
			getvalue->pre_values,
			getvalue->sts_values,
			getvalue->pre_font,
			getvalue->sts_font,
			getvalue->ximp_type_mask);
	    free(getvalue->pre_values);
	    free(getvalue->sts_values);
	    free(getvalue->pre_font);
	    free(getvalue->sts_font);
	    _send_proto(core,
		    XIMP_GETVALUE_RETURN3,
		    call_data.getvalue.icid,
		    0,
		    0,
		    0);
	    if(!flag) {
		/*
		 * Call XIMP_ERROR because of lack of properties
		 */
	    }
	} else {
	    /*
	     * Call XIMP_ERROR because of wrong protocol version
	     */
	}
	break;
      default:
	/*
	 * Call XIMP_ERROR because of unknown XIMP_CREATE request
	 */
	break;
    }
    return True;
}

Bool _proc_reset(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPResetStruct	*reset = (XIMPResetStruct*)&(call_data.reset);
    int	flag, length;
    Atom atom_ret = (Atom)0;

    memset(&call_data, 0, sizeof(IMPProtocol));
    reset->type = event.data.l[0];
    reset->icid = event.data.l[1];

    if(core->imp_handler) {
	(core->imp_handler)(xims, &call_data);
	_set_state(core, reset->icid, False);
	switch(proto_num) {
	  case ximp_40:
	    _send_proto(core, XIMP_SPROC_STOPPED4,
			call_data.reset.icid,
			0, 0, 0);
	    if(core->cur_type == XIMP_FE_TYPE1 ||
	       core->cur_type == XIMP_FE_TYPE3) {
		_unreg_keypress(xims, reset->icid);
		_unreg_keyrelease(xims, reset->icid);
	    }
	    break;
	  case ximp_35:
	    _send_proto(core, XIMP_PROCESS_END3,
			call_data.reset.icid,
			0, 0, 0);
	    if(core->cur_type == XIMP_FRONTEND) {
		_unreg_keypress(xims, reset->icid);
	    }
	    break;
	  default:
	    /*
	     * Call XIMP_ERROR because of unknown protocol
	     */
	    break;
	}
	if(!call_data.reset.ctext) {
	    flag = RESET_NOTHING;
	} else {
	    /*
	     * Reset string should be sent to client.
	     * Only XIMP4.0 supports sending reset string by cmsg.
	     */
	    length = strlen(call_data.reset.ctext);
	    if((proto_num == ximp_40) && (length <= LONGENOUGH)) {
		_sendby_cmsg(core,
			     call_data.reset.icid,
			     call_data.reset.ctext,
			     length);
		flag = RESET_BY_CMSG;
	    } else {
		atom_ret = XimpReplacePropPool(core,
					IMA_COMPOUND_TEXT,
					call_data.reset.ctext,
					length,
					8),
		flag = RESET_BY_PROP;
	    }
	}
	if(proto_num == ximp_40) {
	    _send_proto(core, XIMP_RESET_RETURN4,
			call_data.reset.icid,
			flag, atom_ret, 0);
	} else {
	    _send_proto(core, XIMP_RESET_RETURN3,
			call_data.reset.icid,
			atom_ret, 0, 0);
	}
	return True;
    }
    return False;
}

Bool _proc_evmask(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPEventMaskNotifyStruct *evmasknotify =
		(XIMPEventMaskNotifyStruct*)&(call_data.evmasknotify);

    if(proto_num == ximp_40) {
	memset(&call_data, 0, sizeof(IMPProtocol));
	evmasknotify->type = event.data.l[0];
	evmasknotify->icid = event.data.l[1];
	evmasknotify->fwin_sel_mask = event.data.l[2];
	if(core->imp_handler) {
	    (core->imp_handler)(xims, &call_data);
	    _set_evmask(core, evmasknotify->icid, event.data.l[2]);
	    _send_proto(core,
		    XIMP_EVENTMASK_NOTIFY_RETURN4,
		    call_data.evmasknotify.icid,
		    0,
		    0,
		    0);
	    return True;
	}
    }
    return False;
}

Bool _proc_extension(XIMS xims, XEvent *ev)
{
    XIMPCore		core = (XIMPCore)xims->protocol;
    IMPProtocol		call_data;
    XClientMessageEvent	event = ev->xclient;
    XIMPExtensionStruct	*extension =
		(XIMPExtensionStruct*)&(call_data.extension);

    _check_atom(core->display,
		&IMA_EXT_SAMPLE_STATUSWINDOW,
		"_XIMP_EXT_XIMP_STATUSWINDOW");
    _check_atom(core->display,
		&IMA_EXT_SAMPLE_BACK_FRONT,
		"_XIMP_EXT_XIMP_BACK_FRONT");
    _check_atom(core->display,
    		&IMA_EXT_XIMP_CONVERSION,
		"_XIMP_EXT_XIMP_CONVERSION");
    memset(&call_data, 0, sizeof(IMPProtocol));
    extension->type = event.data.l[0];
    extension->icid = event.data.l[1];
    extension->ext_atom = event.data.l[2];
    if(extension->ext_atom == IMA_EXT_SAMPLE_STATUSWINDOW) {
	extension->data1 = (long)0;
	extension->data2 = (long)0;
	if(core->imp_handler) {
	    (core->imp_handler)(xims, &call_data);
	    return True;
	}
    } else if(extension->ext_atom == IMA_EXT_SAMPLE_BACK_FRONT) {
	extension->data1 = event.data.l[3];
	extension->data2 = (long)0;
	if(core->imp_handler) {
	    (core->imp_handler)(xims, &call_data);
	    core->cur_type = event.data.l[3];
	    return True;
	}
    } else if(extension->ext_atom == IMA_EXT_XIMP_CONVERSION) {
	extension->data1 = event.data.l[3];
	extension->data2 = event.data.l[4];
	if(core->imp_handler) {
	    (core->imp_handler)(xims, &call_data);
	    if(!event.data.l[3]) {
		/*
		 * Clients query the conversion status.
		 * Need to reply.
		 */
		_send_proto(core,
		    (proto_num == ximp_40 ?
		     XIMP_EXTENSION4 : XIMP_EXTENSION3),
		    call_data.extension.icid,
		    IMA_EXT_XIMP_CONVERSION,
		    _find_state(core, extension->icid),
		    0);
	    } else {
		/*
		 * Clients set the conversion status.
		 * Need to obey. In FrontEnd Type1 of XIMP_40,
		 * we have to attach filters if conversion is on.
		 */
		switch(proto_num) {
		  case ximp_40:
		    if((core->cur_type == XIMP_FE_TYPE1) &&
		       extension->data2) {
			_set_state(core, extension->icid, True);
			_reg_keypress(xims, extension->icid);
			if(_find_evmask(core, extension->icid) & KeyReleaseMask) {
			    _reg_keyrelease(xims, extension->icid);
			}
		    }
		    break;
		  case ximp_35:
		    if((core->cur_type == XIMP_FRONTEND) &&
		       extension->data2) {
			_set_state(core, extension->icid, True);
			_reg_keypress(xims, extension->icid);
		    }
		    break;
		  default:
		    break;
		}
	    }
	    return True;
	}
    } else {
	/*
	 * Call XIMP_ERROR because of unknown XIMP_CREATE request
	 */
	return False;
    }
}

static Bool
_keypress_filter(XIMS xims,
		 Window win,
		 XEvent* ev,
		 XPointer client_data)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    XClientMessageEvent event;

    memset(&event, 0, sizeof(XClientMessageEvent));
    event.type		= ClientMessage;
    event.serial	= ev->xany.serial;
    event.send_event	= ev->xany.send_event;
    event.display	= ev->xany.display;
    event.message_type	= core->mes_type;
    event.window	= ev->xany.window;
    event.format	= 32;

    event.data.l[0]	= (proto_num == ximp_40 ?
			   XIMP_KEYPRESS4 :
			   XIMP_KEYPRESS3);
    event.data.l[1]	= (core->active_icid ?
			   core->active_icid :
			   _find_icid_fw(core, event.window));
    event.data.l[2]	= ev->xkey.keycode;
    event.data.l[3]	= ev->xkey.state;
    event.data.l[4]	= ev->xkey.time;
    return(_proc_keypress(xims, (XEvent*)&event));
}

static Bool
_keyrelease_filter(XIMS xims,
		   Window win,
		   XEvent* ev,
		   XPointer client_data)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    XClientMessageEvent event;

    if(proto_num == ximp_40) {
	memset(&event, 0, sizeof(XClientMessageEvent));
	event.type		= ClientMessage;
	event.serial		= ev->xany.serial;
	event.send_event	= ev->xany.send_event;
	event.display		= ev->xany.display;
	event.message_type	= core->mes_type;
	event.window		= ev->xany.window;
	event.format		= 32;

	event.data.l[0]	= XIMP_KEYRELEASE4;
	event.data.l[1]	= (core->active_icid ?
			   core->active_icid :
			   _find_icid_fw(core, event.window));
	event.data.l[2]	= ev->xkey.keycode;
	event.data.l[3]	= ev->xkey.state;
	event.data.l[4]	= ev->xkey.time;
    }

    return(_proc_keyrelease(xims, (XEvent*)&event));
}

static Bool
_destroy_filter(XIMS xims,
		Window win,
		XEvent *ev,
		XPointer client_data)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    register int i;
    long	icid = _find_icid_fw(core, ev->xany.window);
    long mask = _find_flt_mask(core, icid);
    /*
     *
    for(i = 0; i < core->ic_counts; i++) {
	if(core->ic_list[i].focus == ev->xany.window) {
	    if(core->ic_list[i].filters & FLT_KEYPRESS) {
		_IMUnregisterFilter(xims, ev->xany.window,
				    _keypress_filter);
	    }
	    if(core->ic_list[i].filters & FLT_KEYRELEASE) {
		_IMUnregisterFilter(xims, ev->xany.window,
				    _keyrelease_filter);
	    }
	    _IMUnregisterFilter(xims, ev->xany.window,
				    _destory_filter);
	    _remove_iclist(core, icid);
	}
    }
    return False;    /* This filter always returns False so that
		      * the clients' X event handler can hook this
		      * event and process accrodingly.
		      */
}

static void
_reg_destroy(XIMS xims, long icid)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Display	*display = core->display;
    Window	focus = _find_focus(core, icid);
    XWindowAttributes win_attr;
/*
 * I think preparing for client's destroy is mandatory. So this has
 * no event mask check.
 */
    XGetWindowAttributes(display, focus, &win_attr);
    XSelectInput(display, focus,
		(win_attr.your_event_mask | StructureNotifyMask));
    _IMRegisterFilterByType(xims, focus,
			    DestroyNotify, DestroyNotify,
			    _destroy_filter, NULL);
}

static void
_reg_keypress(XIMS xims, long icid)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Display	*display = core->display;
    Window	focus = _find_focus(core, icid);
    long	mask = _find_flt_mask(core, icid);
    XWindowAttributes win_attr;

    if(!(mask & FLT_KEYPRESS)) {
	XGetWindowAttributes(display, focus, &win_attr);
	XSelectInput(display, focus,
		(win_attr.your_event_mask | KeyPressMask));
	_IMRegisterFilterByType(xims, focus,
			    KeyPress, KeyPress,
			    _keypress_filter, NULL);
	_set_flt_mask(core, icid, FLT_KEYPRESS);
    }
}

static void
_reg_keyrelease(XIMS xims, long icid)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Display	*display = core->display;
    Window	focus = _find_focus(core, icid);
    long	mask = _find_flt_mask(core, icid);
    XWindowAttributes win_attr;

    if(!(mask & FLT_KEYRELEASE)) {
	XGetWindowAttributes(display, focus, &win_attr);
	XSelectInput(display, focus,
		(win_attr.your_event_mask | KeyReleaseMask));
	_IMRegisterFilterByType(xims, focus,
			    KeyRelease, KeyRelease,
			    _keyrelease_filter, NULL);
	_set_flt_mask(core, icid, FLT_KEYRELEASE);
    }
}

static void
_unreg_destroy(XIMS xims, long icid)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Display	*display = core->display;
    Window	focus = _find_focus(core, icid);
    XWindowAttributes win_attr;
/*
 * I think preparing for client's destroy is mandatory. So this has
 * no event mask check.
 */
    XGetWindowAttributes(display, focus, &win_attr);
    XSelectInput(display, focus,
		(win_attr.your_event_mask & ~StructureNotifyMask));
    _IMUnregisterFilter(xims, focus, _destroy_filter);
}

static void
_unreg_keypress(XIMS xims, long icid)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Display	*display = core->display;
    Window	focus = _find_focus(core, icid);
    long	mask = _find_flt_mask(core, icid);
    XWindowAttributes win_attr;

    if(mask & FLT_KEYPRESS) {
	XGetWindowAttributes(display, focus, &win_attr);
	XSelectInput(display, focus,
		(win_attr.your_event_mask & ~KeyPressMask));
	_IMUnregisterFilter(xims, focus, _keypress_filter);
	_unset_flt_mask(core, icid, FLT_KEYPRESS);
    }
}

static void
_unreg_keyrelease(XIMS xims, long icid)
{
    XIMPCore	core = (XIMPCore)xims->protocol;
    Display	*display = core->display;
    Window	focus = _find_focus(core, icid);
    long	mask = _find_flt_mask(core, icid);
    XWindowAttributes win_attr;

    if(mask & FLT_KEYRELEASE) {
	XGetWindowAttributes(display, focus, &win_attr);
	XSelectInput(display, focus,
		(win_attr.your_event_mask & ~KeyReleaseMask));
	_IMUnregisterFilter(xims, focus, _keyrelease_filter);
	_unset_flt_mask(core, icid, FLT_KEYRELEASE);
    }
}

/***********************************************
 *                                             *
 *   Followings are activated from IMServer.   *
 *                                             *
 ***********************************************/


static void
_sendby_cmsg(XIMPCore core, long icid, char *ctext, int length)
{
#define DATA_ROOM	15

    XClientMessageEvent	event;
    int			msglen = DATA_ROOM;
    char		*ctptr = ctext;
    Ximp_CommitPropRec	*msg = (Ximp_CommitPropRec*)&(event.data.l[0]);
    Window		dst_win = _find_focus(core, icid);

    while(length > 0) {
	memset(&event, 0, sizeof(event));
	event.type		= ClientMessage;
	event.display		= core->display;
	event.message_type	= core->mes_type;
	event.window		= dst_win;
	event.format		= 8;
	msg->icid = icid;
	msg->size = length;
	if(length < DATA_ROOM) {
	    msglen = length;
	}
	memmove(msg->ctext, ctptr, msglen);
	XSendEvent(core->display,
		   dst_win,
		   False,
		   NoEventMask,
		   (XEvent*)&event);
	length -= DATA_ROOM;
	ctptr += DATA_ROOM;
    }
    XFlush(core->display);
    return;

#undef DATA_ROOM
}

static void
_sendby_prop(XIMPCore core, long icid, char *ctext, int length)
{
    _check_atom(core->display, &IMA_COMPOUND_TEXT, "COMPOUND_TEXT");
    _send_proto(core,
		(proto_num == ximp_40 ? XIMP_READPROP4 : XIMP_READPROP3),
		icid,
		XimpReplacePropPool(core,
					IMA_COMPOUND_TEXT,
					ctext,
					length,
					8),
		0,
		0);
    return;
}

void
_send_commit(XIMPCore core, IMPProtocol *improto)
{
    int	length = strlen(improto->commitstring.ctext);

    if(length > 20) {
	_sendby_prop(core,
		     improto->commitstring.icid,
		     improto->commitstring.ctext,
		     length);
    } else {
	_sendby_cmsg(core,
		     improto->commitstring.icid,
		     improto->commitstring.ctext,
		     length);
    }
    return;
}

void
_send_keyevent(XIMPCore core, IMPProtocol *improto)
{
    XIMPKeyPressStruct keypress = improto->keypress;
    XIMPKeyReleaseStruct keyrelease = improto->keyrelease;
    
    switch(improto->type) {
      case XIMP_KEYPRESS4:
      case XIMP_KEYPRESS3:
	_send_proto(core,
		(proto_num == ximp_40 ? XIMP_KEYPRESS4 : XIMP_KEYPRESS3),
		keypress.icid,
		keypress.keycode,
		keypress.state,
		(proto_num == ximp_40 ? keypress.time : 0));
	if(proto_num == ximp_40) {
	    _set_match(core,
			keypress.icid,
			keypress.keycode,
			keypress.state);
	}
	break;
      case XIMP_KEYRELEASE4:
	if(_find_match(core, keyrelease.icid, keyrelease.keycode, keyrelease.state)) {
	    _send_proto(core,
			XIMP_KEYRELEASE4,
			keyrelease.icid,
			keyrelease.keycode,
			keyrelease.state,
			keyrelease.time);
	}
	break;
    }
}
#endif	/* _XIMPPROC_C_ */
