/*
 * mapdata.c
 * kirk johnson
 * july 1993
 *
 * RCS $Id: mapdata.c,v 1.4 1994/05/20 01:37:40 tuna Exp $
 *
 * map_data[] is a big array of short (16-bit) ints, as follows:
 *
 * - the map_data[] info is a sequence of closed curves
 *
 * - the first value in a curve is the number of points in the curve
 *
 * - the second value in a curve indicates land/water (1 or -1,
 *   respectively)
 *
 * - this is followed by (number of points in curve) triples of
 *   [x,y,z]; each triple indicates a point on the unit sphere (each
 *   of x, y, and z has been scaled by 30000), where the x axis points
 *   "to the right" (towards 0 N 90 E), the y axis points "up"
 *   (towards the north pole), and the z axis points "out of the
 *   screen" (towards 0 N 0 E).
 *
 * - the curves are [must be!] non-self-intersecting and traced in a
 *   counter-clockwise direction
 *
 * the curves are sampled at a (roughly) a 20 mile resolution.
 *
 * Copyright (C) 1989, 1990, 1993, 1994 Kirk Lauritz Johnson
 *
 * Parts of the source code (as marked) are:
 *   Copyright (C) 1989, 1990, 1991 by Jim Frost
 *   Copyright (C) 1992 by Jamie Zawinski <jwz@lucid.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this
 * permission notice appear in supporting documentation. The author
 * makes no representations about the suitability of this software
 * for any purpose. It is provided "as is" without express or
 * implied warranty.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "xearth.h"
#include "kljcpyrt.h"

short map_data[] = {

/* 0 */
3903, 1,
 13663,  15523,  21733,
 13525,  15597,  21767,
 13594,  15626,  21703,
 13556,  15645,  21713,
 13463,  15669,  21754,
 13340,  15671,  21828,
 13201,  15694,  21896,
 13108,  15640,  21990,
 13062,  15657,  22006,
 13095,  15690,  21962,
 12950,  15653,  22075,
 12891,  15571,  22167,
 12774,  15527,  22266,
 12691,  15448,  22367,
 12593,  15389,  22464,
 12464,  15390,  22534,
 12332,  15452,  22564,
 12196,  15482,  22618,
 12050,  15504,  22681,
 11930,  15541,  22719,
 11793,  15581,  22763,
 11661,  15631,  22797,
 11524,  15658,  22848,
 11384,  15681,  22902,
 11243,  15713,  22950,
 11110,  15717,  23012,
 10987,  15683,  23094,
 10863,  15727,  23122,
 10768,  15851,  23082,
 10634,  15901,  23110,
 10498,  15896,  23175,
 10355,  15920,  23223,
 10220,  15971,  23248,
 10069,  15984,  23305,
  9953,  16064,  23300,
  9883,  16178,  23251,
  9732,  16230,  23279,
  9591,  16274,  23306,
  9454,  16302,  23342,
  9303,  16302,  23403,
  9188,  16247,  23487,
  9051,  16228,  23553,
  8938,  16169,  23636,
  8832,  16102,  23721,
  8749,  16014,  23812,
  8693,  15908,  23904,
  8697,  15781,  23986,
  8754,  15654,  24048,
  8835,  15537,  24095,
  8839,  15411,  24174,
  8783,  15302,  24263,
  8702,  15208,  24351,
  8591,  15143,  24431,
  8454,  15124,  24491,
  8314,  15174,  24507,
  8185,  15251,  24503,
  8060,  15335,  24492,
  7920,  15394,  24501,
  7779,  15445,  24514,
  7638,  15491,  24530,
  7492,  15527,  24552,
  7347,  15551,  24580,
  7200,  15555,  24621,
  7054,  15585,  24644,
  6918,  15651,  24641,
  6817,  15756,  24602,
  6748,  15876,  24544,
  6702,  16001,  24475,
  6583,  16080,  24456,
  6433,  16103,  24481,
  6290,  16148,  24488,
  6155,  16213,  24479,
  6008,  16245,  24495,
  5863,  16274,  24511,
  5721,  16289,  24535,
  5583,  16253,  24590,
  5434,  16259,  24619,
  5292,  16305,  24620,
  5138,  16376,  24606,
  5013,  16414,  24606,
  4891,  16457,  24602,
  4760,  16583,  24543,
  4622,  16608,  24552,
  4474,  16652,  24550,
  4363,  16745,  24507,
  4331,  16867,  24428,
  4428,  16953,  24351,
  4539,  17027,  24279,
  4626,  17118,  24199,
  4681,  17228,  24110,
  4701,  17337,  24027,
  4649,  17465,  23945,
  4527,  17546,  23909,
  4422,  17646,  23855,
  4412,  17768,  23766,
  4515,  17847,  23688,
  4581,  17951,  23596,
  4563,  18052,  23522,
  4418,  17989,  23598,
  4293,  17978,  23630,
  4234,  18108,  23541,
  4102,  18152,  23530,
  3980,  18183,  23528,
  3840,  18146,  23579,
  3724,  18083,  23646,
  3601,  18031,  23705,
  3453,  18022,  23733,
  3288,  18010,  23766,
  3158,  18057,  23748,
  3021,  18063,  23761,
  2880,  18020,  23811,
  2739,  18063,  23796,
  2619,  18050,  23819,
  2499,  17988,  23879,
  2358,  17958,  23915,
  2224,  17910,  23964,
  2098,  17968,  23932,
  1951,  18007,  23915,
  1799,  18012,  23923,
  1647,  18011,  23935,
  1509,  17977,  23970,
  1357,  17959,  23993,
  1216,  17953,  24004,
  1076,  17890,  24058,
   930,  17888,  24065,
   782,  17870,  24084,
   630,  17860,  24096,
   484,  17843,  24112,
   350,  17792,  24152,
   213,  17741,  24191,
    91,  17674,  24241,
    -3,  17573,  24315,
  -156,  17570,  24316,
  -298,  17525,  24347,
  -439,  17489,  24371,
  -535,  17398,  24434,
  -648,  17322,  24485,
  -779,  17258,  24527,
  -927,  17246,  24530,
 -1075,  17257,  24516,
 -1215,  17285,  24490,
 -1306,  17348,  24441,
 -1473,  17297,  24467,
 -1622,  17311,  24448,
 -1770,  17296,  24448,
 -1917,  17281,  24448,
 -2058,  17324,  24406,
 -2170,  17403,  24340,
 -2249,  17500,  24263,
 -2310,  17580,  24199,
 -2487,  17535,  24215,
 -2562,  17427,  24284,
 -2622,  17311,  24361,
 -2680,  17194,  24437,
 -2747,  17079,  24510,
 -2821,  16968,  24579,
 -2903,  16859,  24644,
 -2997,  16759,  24702,
 -3127,  16688,  24733,
 -3263,  16627,  24757,
 -3403,  16573,  24774,
 -3545,  16524,  24787,
 -3681,  16463,  24808,
 -3789,  16377,  24848,
 -3898,  16281,  24895,
 -4012,  16192,  24935,
 -4079,  16084,  24993,
 -4111,  15958,  25069,
 -4203,  15852,  25121,
 -4298,  15746,  25171,
 -4363,  15626,  25235,
 -4385,  15496,  25311,
 -4401,  15365,  25388,
 -4383,  15259,  25455,
 -4331,  15144,  25533,
 -4378,  15014,  25601,
 -4465,  14903,  25651,
 -4562,  14796,  25696,
 -4654,  14688,  25741,
 -4761,  14586,  25780,
 -4885,  14505,  25802,
 -5022,  14438,  25813,
 -5139,  14348,  25840,
 -5249,  14247,  25874,
 -5386,  14184,  25880,
 -5528,  14131,  25879,
 -5676,  14098,  25866,
 -5825,  14076,  25844,
 -5956,  14021,  25845,
 -6058,  13913,  25879,
 -6128,  13785,  25931,
 -6201,  13663,  25978,
 -6263,  13534,  26031,
 -6373,  13437,  26054,
 -6509,  13368,  26056,
 -6639,  13300,  26058,
 -6736,  13200,  26085,
 -6799,  13072,  26132,
 -6871,  12945,  26177,
 -6939,  12819,  26220,
 -6963,  12682,  26281,
 -7011,  12548,  26332,
 -7116,  12447,  26352,
 -7231,  12350,  26366,
 -7344,  12248,  26383,
 -7468,  12163,  26387,
 -7513,  12078,  26414,
 -7599,  11912,  26464,
 -7680,  11780,  26500,
 -7743,  11660,  26534,
 -7807,  11529,  26573,
 -7898,  11403,  26601,
 -8018,  11322,  26599,
 -8100,  11197,  26627,
 -8139,  11062,  26672,
 -8180,  10920,  26718,
 -8216,  10781,  26763,
 -8205,  10718,  26792,
 -8117,  10767,  26799,
 -8062,  10639,  26867,
 -7968,  10573,  26921,
 -7896,  10444,  26992,
 -7871,  10315,  27049,
 -7906,  10184,  27089,
 -7978,  10044,  27119,
 -7990,   9969,  27144,
 -7933,   9794,  27224,
 -7904,   9657,  27281,
 -7881,   9518,  27337,
 -7876,   9375,  27388,
 -7885,   9231,  27434,
 -7910,   9087,  27474,
 -7961,   8947,  27506,
 -8028,   8813,  27530,
 -8099,   8683,  27550,
 -8153,   8545,  27577,
 -8192,   8403,  27609,
 -8207,   8257,  27649,
 -8246,   8117,  27679,
 -8332,   7990,  27690,
 -8419,   7867,  27699,
 -8520,   7754,  27700,
 -8645,   7674,  27684,
 -8680,   7619,  27688,
 -8549,   7540,  27750,
 -8470,   7425,  27805,
 -8415,   7293,  27857,
 -8367,   7256,  27881,
 -8287,   7293,  27895,
 -8311,   7163,  27922,
 -8306,   7031,  27957,
 -8220,   6934,  28006,
 -8077,   6974,  28038,
 -7926,   6989,  28077,
 -7787,   7000,  28114,
 -7764,   6988,  28123,
 -7929,   6974,  28080,
 -8079,   6959,  28041,
 -8203,   6888,  28023,
 -8340,   6954,  27966,
 -8435,   6914,  27947,
 -8431,   6769,  27984,
 -8441,   6619,  28017,
 -8373,   6581,  28046,
 -8264,   6552,  28085,
 -8095,   6571,  28130,
 -7955,   6543,  28176,
 -7847,   6596,  28194,
 -7815,   6612,  28199,
 -7946,   6526,  28183,
 -8090,   6546,  28137,
 -8235,   6532,  28098,
 -8374,   6532,  28057,
 -8437,   6434,  28061,
 -8305,   6350,  28120,
 -8200,   6349,  28150,
 -8170,   6195,  28193,
 -8029,   6230,  28226,
 -8006,   6211,  28237,
 -8010,   6137,  28252,
 -7865,   6181,  28283,
 -7727,   6203,  28316,
 -7642,   6170,  28347,
 -7840,   6101,  28307,
 -7772,   6058,  28335,
 -7698,   6040,  28359,
 -7809,   5931,  28352,
 -7752,   5798,  28395,
 -7685,   5774,  28418,
 -7648,   5745,  28434,
 -7597,   5676,  28462,
 -7504,   5681,  28485,
 -7462,   5592,  28514,
 -7412,   5599,  28526,
 -7432,   5461,  28547,
 -7345,   5333,  28594,
 -7199,   5269,  28643,
 -7099,   5166,  28686,
 -6985,   5103,  28726,
 -6945,   4958,  28761,
 -6840,   4852,  28804,
 -6785,   4741,  28836,
 -6734,   4614,  28868,
 -6731,   4489,  28888,
 -6682,   4442,  28907,
 -6794,   4372,  28892,
 -6695,   4275,  28929,
 -6629,   4147,  28963,
 -6560,   4049,  28993,
 -6430,   4002,  29028,
 -6366,   3899,  29056,
 -6242,   3782,  29099,
 -6105,   3728,  29135,
 -5982,   3647,  29170,
 -5879,   3544,  29204,
 -5769,   3459,  29236,
 -5637,   3391,  29270,
 -5557,   3291,  29297,
 -5393,   3218,  29335,
 -5278,   3137,  29365,
 -5173,   3036,  29394,
 -5064,   2931,  29424,
 -4955,   2833,  29452,
 -4848,   2721,  29480,
 -4730,   2634,  29507,
 -4600,   2564,  29534,
 -4469,   2495,  29560,
 -4337,   2422,  29586,
 -4197,   2372,  29610,
 -4061,   2310,  29634,
 -3917,   2277,  29656,
 -3780,   2337,  29669,
 -3642,   2398,  29681,
 -3507,   2456,  29693,
 -3366,   2507,  29705,
 -3223,   2560,  29716,
 -3083,   2617,  29726,
 -2929,   2653,  29739,
 -2785,   2668,  29751,
 -2705,   2702,  29755,
 -2484,   2691,  29776,
 -2334,   2712,  29786,
 -2181,   2724,  29796,
 -2150,   2750,  29796,
 -2336,   2729,  29784,
 -2406,   2745,  29777,
 -2190,   2769,  29792,
 -2045,   2771,  29802,
 -1975,   2744,  29809,
 -1734,   2707,  29827,
 -1646,   2748,  29828,
 -1572,   2668,  29840,
 -1357,   2602,  29856,
 -1209,   2560,  29866,
 -1070,   2494,  29877,
  -925,   2555,  29877,
  -798,   2630,  29874,
  -646,   2672,  29874,
  -504,   2719,  29872,
  -362,   2765,  29870,
  -231,   2836,  29865,
   -93,   2898,  29860,
    42,   2963,  29853,
   181,   3014,  29848,
   308,   3069,  29841,
   222,   3153,  29833,
   401,   3016,  29845,
   527,   3083,  29836,
   628,   3187,  29824,
   773,   3232,  29815,
   920,   3265,  29808,
  1070,   3288,  29800,
  1221,   3306,  29792,
  1372,   3321,  29784,
  1524,   3335,  29775,
  1676,   3337,  29767,
  1794,   3403,  29752,
  1890,   3391,  29748,
  2084,   3352,  29739,
  2234,   3332,  29731,
  2372,   3275,  29726,
  2491,   3182,  29727,
  2607,   3059,  29730,
  2711,   2999,  29726,
  2804,   2888,  29729,
  2876,   2836,  29727,
  2816,   2720,  29743,
  2838,   2605,  29752,
  2904,   2453,  29758,
  3015,   2335,  29757,
  3142,   2276,  29748,
  3265,   2286,  29734,
  3437,   2300,  29714,
  3518,   2357,  29700,
  3534,   2463,  29689,
  3631,   2376,  29685,
  3714,   2396,  29673,
  3727,   2430,  29668,
  3841,   2389,  29657,
  3948,   2393,  29643,
  4092,   2368,  29625,
  4264,   2382,  29600,
  4321,   2476,  29584,
  4331,   2536,  29577,
  4448,   2426,  29569,
  4573,   2389,  29553,
  4666,   2189,  29554,
  4794,   2094,  29540,
  4922,   2091,  29520,
  5025,   2051,  29505,
  5043,   1882,  29513,
  5120,   1751,  29508,
  5170,   1619,  29507,
  5139,   1472,  29520,
  5115,   1323,  29531,
  5095,   1177,  29541,
  5095,   1022,  29546,
  5037,    858,  29562,
  4957,    754,  29578,
  4919,    610,  29588,
  5050,    533,  29567,
  5016,    327,  29576,
  4961,    314,  29585,
  4883,    267,  29599,
  4989,    148,  29582,
  5134,    101,  29557,
  5129,     63,  29558,
  4981,     74,  29584,
  4874,     98,  29601,
  4857,   -121,  29604,
  4799,   -254,  29613,
  4727,   -374,  29623,
  4641,   -396,  29636,
  4573,   -382,  29647,
  4654,   -548,  29632,
  4732,   -677,  29617,
  4863,   -756,  29594,
  4888,   -842,  29587,
  4745,   -731,  29613,
  4721,   -715,  29618,
  4810,   -869,  29599,
  4886,   -973,  29583,
  4916,  -1040,  29576,
  5026,  -1241,  29550,
  5148,  -1296,  29527,
  5196,  -1333,  29517,
  5101,  -1335,  29533,
  5217,  -1448,  29507,
  5333,  -1541,  29482,
  5441,  -1644,  29457,
  5532,  -1764,  29433,
  5635,  -1870,  29407,
  5724,  -1988,  29382,
  5828,  -2093,  29354,
  5923,  -2203,  29327,
  6033,  -2307,  29297,
  6111,  -2438,  29270,
  6168,  -2560,  29247,
  6250,  -2656,  29221,
  6300,  -2832,  29194,
  6287,  -2974,  29183,
  6389,  -3106,  29147,
  6493,  -3134,  29121,
  6620,  -3061,  29100,
  6713,  -3087,  29076,
  6512,  -3155,  29114,
  6367,  -3210,  29140,
  6432,  -3386,  29106,
  6509,  -3511,  29074,
  6590,  -3632,  29041,
  6618,  -3781,  29016,
  6667,  -3923,  28985,
  6721,  -4062,  28954,
  6784,  -4198,  28920,
  6850,  -4329,  28885,
  6863,  -4470,  28860,
  6797,  -4586,  28858,
  6694,  -4688,  28865,
  6712,  -4839,  28836,
  6753,  -4982,  28802,
  6789,  -5117,  28770,
  6838,  -5249,  28735,
  6901,  -5389,  28694,
  6981,  -5513,  28651,
  7020,  -5643,  28616,
  7040,  -5791,  28582,
  7011,  -5936,  28559,
  7000,  -6085,  28530,
  6968,  -6232,  28506,
  6896,  -6377,  28492,
  6811,  -6489,  28487,
  6689,  -6555,  28501,
  6567,  -6659,  28505,
  6504,  -6789,  28489,
  6399,  -6894,  28487,
  6325,  -7018,  28474,
  6291,  -7175,  28442,
  6222,  -7308,  28423,
  6206,  -7451,  28390,
  6170,  -7598,  28358,
  6115,  -7732,  28334,
  6065,  -7867,  28308,
  6021,  -8019,  28274,
  5928,  -8137,  28260,
  5887,  -8251,  28236,
  5887,  -8395,  28193,
  5889,  -8539,  28150,
  5870,  -8683,  28109,
  5843,  -8831,  28069,
  5821,  -8971,  28029,
  5809,  -9115,  27985,
  5823,  -9258,  27936,
  5884,  -9384,  27881,
  5940,  -9511,  27825,
  6038,  -9615,  27769,
  6116,  -9732,  27711,
  6180,  -9854,  27653,
  6231,  -9984,  27595,
  6289, -10109,  27536,
  6346, -10235,  27477,
  6413, -10354,  27417,
  6449, -10490,  27356,
  6488, -10624,  27295,
  6539, -10750,  27234,
  6606, -10870,  27170,
  6675, -10987,  27106,
  6725, -11115,  27041,
  6802, -11226,  26976,
  6876, -11339,  26910,
  6926, -11465,  26844,
  6942, -11600,  26782,
  6891, -11715,  26744,
  6884, -11881,  26673,
  6876, -12013,  26616,
  6861, -12153,  26556,
  6848, -12289,  26497,
  6881, -12422,  26426,
  6925, -12544,  26357,
  6956, -12673,  26287,
  6939, -12810,  26225,
  6939, -12945,  26159,
  6937, -13078,  26093,
  6955, -13210,  26022,
  6976, -13332,  25954,
  6997, -13457,  25884,
  7009, -13585,  25813,
  7028, -13715,  25739,
  7069, -13836,  25663,
  7121, -13955,  25584,
  7179, -14071,  25504,
  7263, -14171,  25425,
  7351, -14265,  25347,
  7449, -14358,  25266,
  7510, -14462,  25188,
  7569, -14574,  25106,
  7606, -14695,  25024,
  7636, -14820,  24941,
  7652, -14947,  24860,
  7676, -15072,  24777,
  7707, -15193,  24694,
  7752, -15309,  24608,
  7793, -15426,  24522,
  7844, -15539,  24434,
  7901, -15647,  24347,
  7962, -15754,  24257,
  7983, -15877,  24170,
  7979, -16006,  24086,
  7948, -16134,  24011,
  7835, -16224,  23988,
  7737, -16273,  23986,
  7772, -16368,  23910,
  7792, -16443,  23852,
  7870, -16595,  23721,
  7876, -16718,  23632,
  7816, -16831,  23572,
  7863, -16868,  23530,
  7997, -16845,  23501,
  8065, -16929,  23417,
  8173, -16996,  23331,
  8253, -17080,  23241,
  8378, -17113,  23172,
  8498, -17078,  23154,
  8632, -16999,  23163,
  8783, -16961,  23134,
  8912, -16942,  23099,
  9050, -16944,  23043,
  9200, -16929,  22994,
  9331, -16850,  23000,
  9465, -16800,  22982,
  9610, -16782,  22935,
  9727, -16808,  22866,
  9866, -16803,  22811,
 10008, -16777,  22768,
 10139, -16799,  22694,
 10261, -16832,  22614,
 10400, -16849,  22538,
 10522, -16772,  22539,
 10661, -16782,  22465,
 10771, -16753,  22435,
 10883, -16659,  22451,
 11018, -16664,  22381,
 11153, -16660,  22317,
 11291, -16607,  22287,
 11426, -16548,  22263,
 11557, -16473,  22250,
 11688, -16398,  22238,
 11817, -16321,  22226,
 11941, -16231,  22225,
 12069, -16152,  22214,
 12191, -16061,  22213,
 12309, -15968,  22215,
 12422, -15869,  22223,
 12535, -15770,  22230,
 12661, -15687,  22217,
 12787, -15607,  22202,
 12902, -15506,  22206,
 13010, -15401,  22216,
 13111, -15289,  22234,
 13209, -15176,  22253,
 13304, -15058,  22277,
 13407, -14948,  22289,
 13494, -14826,  22318,
 13600, -14715,  22327,
 13712, -14617,  22323,
 13831, -14525,  22310,
 13953, -14455,  22279,
 14080, -14362,  22259,
 14165, -14247,  22279,
 14248, -14120,  22308,
 14303, -13988,  22355,
 14368, -13858,  22395,
 14444, -13730,  22424,
 14514, -13599,  22459,
 14562, -13466,  22508,
 14607, -13331,  22559,
 14598, -13239,  22619,
 14524, -13137,  22726,
 14628, -13023,  22725,
 14745, -12903,  22718,
 14876, -12822,  22678,
 14998, -12769,  22627,
 15128, -12714,  22572,
 15258, -12668,  22510,
 15389, -12619,  22449,
 15519, -12570,  22386,
 15647, -12510,  22331,
 15757, -12415,  22306,
 15860, -12301,  22297,
 15930, -12163,  22322,
 15900, -12098,  22379,
 15976, -11899,  22432,
 16035, -11765,  22460,
 16067, -11656,  22494,
 16093, -11501,  22555,
 16135, -11359,  22597,
 16097, -11345,  22631,
 16053, -11404,  22633,
 16084, -11218,  22704,
 16094, -11078,  22766,
 16076, -10946,  22842,
 16079, -10831,  22895,
 16094, -10679,  22955,
 16040, -10574,  23041,
 16003, -10465,  23117,
 16052, -10318,  23149,
 16072, -10178,  23197,
 16075, -10119,  23221,
 16192, -10154,  23124,
 16306, -10067,  23082,
 16414,  -9965,  23050,
 16510,  -9857,  23027,
 16630,  -9753,  22986,
 16753,  -9695,  22920,
 16848,  -9627,  22880,
 16956,  -9510,  22848,
 17073,  -9388,  22812,
 17145,  -9256,  22811,
 17260,  -9166,  22761,
 17369,  -9088,  22710,
 17489,  -9014,  22647,
 17608,  -8949,  22580,
 17707,  -8890,  22526,
 17854,  -8835,  22432,
 17960,  -8797,  22362,
 18095,  -8740,  22275,
 18197,  -8651,  22227,
 18312,  -8578,  22161,
 18414,  -8481,  22113,
 18500,  -8377,  22081,
 18585,  -8262,  22053,
 18683,  -8145,  22013,
 18782,  -8030,  21972,
 18842,  -7886,  21972,
 18884,  -7787,  21972,
 18926,  -7691,  21969,
 18956,  -7517,  22004,
 18946,  -7434,  22040,
 18936,  -7333,  22083,
 18954,  -7151,  22128,
 18967,  -7013,  22160,
 18989,  -6878,  22184,
 18995,  -6717,  22228,
 19042,  -6578,  22229,
 19033,  -6419,  22283,
 19058,  -6278,  22303,
 19062,  -6137,  22338,
 19072,  -5984,  22371,
 19082,  -5858,  22396,
 19145,  -5709,  22381,
 19170,  -5569,  22394,
 19141,  -5418,  22456,
 19057,  -5339,  22546,
 18972,  -5275,  22632,
 18899,  -5173,  22717,
 18897,  -5017,  22754,
 18876,  -4883,  22801,
 18857,  -4734,  22848,
 18838,  -4615,  22887,
 18803,  -4451,  22948,
 18817,  -4309,  22964,
 18871,  -4163,  22947,
 18836,  -4049,  22996,
 18847,  -3888,  23014,
 18906,  -3768,  22986,
 18950,  -3649,  22969,
 18872,  -3553,  23049,
 18811,  -3435,  23116,
 18734,  -3348,  23191,
 18698,  -3187,  23243,
 18721,  -3039,  23244,
 18773,  -2896,  23220,
 18823,  -2752,  23197,
 18864,  -2601,  23182,
 18913,  -2461,  23157,
 19005,  -2369,  23091,
 19067,  -2230,  23054,
 19104,  -2092,  23036,
 19176,  -1940,  22989,
 19202,  -1843,  22976,
 19273,  -1721,  22926,
 19325,  -1569,  22893,
 19343,  -1424,  22887,
 19444,  -1338,  22806,
 19551,  -1297,  22717,
 19622,  -1184,  22662,
 19656,  -1050,  22639,
 19783,  -1012,  22530,
 19872,   -905,  22456,
 19944,   -786,  22397,
 20009,   -646,  22344,
 20061,   -515,  22300,
 20132,   -416,  22238,
 20212,   -295,  22167,
 20282,   -189,  22104,
 20364,    -75,  22029,
 20440,     34,  21959,
 20515,    145,  21889,
 20590,    255,  21818,
 20665,    364,  21744,
 20746,    465,  21665,
 20831,    556,  21581,
 20909,    658,  21503,
 20989,    757,  21421,
 21074,    848,  21334,
 21161,    933,  21245,
 21252,   1007,  21151,
 21344,   1076,  21054,
 21434,   1153,  20959,
 21523,   1229,  20863,
 21601,   1325,  20776,
 21670,   1433,  20696,
 21743,   1536,  20612,
 21814,   1641,  20530,
 21880,   1753,  20450,
 21944,   1865,  20371,
 22010,   1974,  20290,
 22074,   2084,  20208,
 22135,   2199,  20130,
 22197,   2311,  20049,
 22246,   2436,  19980,
 22286,   2568,  19918,
 22337,   2691,  19845,
 22390,   2810,  19768,
 22437,   2936,  19697,
 22480,   3064,  19628,
 22518,   3196,  19564,
 22530,   3340,  19525,
 22550,   3482,  19477,
 22582,   3616,  19416,
 22624,   3740,  19343,
 22668,   3863,  19268,
 22699,   4000,  19203,
 22710,   4140,  19160,
 22768,   4253,  19066,
 22806,   4380,  18992,
 22836,   4509,  18926,
 22860,   4647,  18863,
 22902,   4766,  18783,
 22935,   4897,  18709,
 22925,   5049,  18680,
 22923,   5196,  18642,
 22913,   5348,  18611,
 22982,   5421,  18505,
 23006,   5447,  18467,
 22953,   5487,  18521,
 22940,   5632,  18494,
 22916,   5785,  18476,
 22888,   5927,  18466,
 22903,   6065,  18404,
 22868,   6165,  18414,
 22763,   6214,  18527,
 22680,   6180,  18639,
 22634,   6067,  18732,
 22559,   6001,  18843,
 22470,   5969,  18959,
 22379,   5941,  19076,
 22297,   5888,  19188,
 22204,   5856,  19305,
 22103,   5881,  19413,
 22005,   5868,  19529,
 21922,   5807,  19639,
 21824,   5788,  19754,
 21723,   5803,  19860,
 21627,   5789,  19968,
 21553,   5709,  20072,
 21474,   5635,  20177,
 21387,   5578,  20285,
 21286,   5600,  20386,
 21173,   5629,  20494,
 21082,   5628,  20588,
 20998,   5556,  20693,
 20913,   5491,  20796,
 20827,   5436,  20897,
 20715,   5431,  21009,
 20606,   5443,  21113,
 20504,   5529,  21190,
 20408,   5625,  21257,
 20322,   5738,  21309,
 20248,   5874,  21343,
 20159,   5969,  21400,
 20060,   6032,  21475,
 19943,   6008,  21591,
 19900,   6027,  21625,
 19987,   6125,  21518,
 20075,   6191,  21416,
 20152,   6273,  21320,
 20117,   6428,  21307,
 20042,   6545,  21342,
 19950,   6657,  21394,
 19850,   6719,  21467,
 19753,   6836,  21520,
 19667,   6919,  21572,
 19588,   7057,  21598,
 19491,   7154,  21655,
 19382,   7227,  21728,
 19288,   7338,  21774,
 19202,   7455,  21811,
 19108,   7565,  21855,
 18987,   7611,  21944,
 18895,   7700,  21993,
 18793,   7750,  22063,
 18681,   7783,  22146,
 18615,   7917,  22154,
 18529,   7946,  22216,
 18508,   7853,  22266,
 18412,   8014,  22289,
 18348,   8117,  22304,
 18263,   8255,  22323,
 18207,   8398,  22316,
 18163,   8542,  22297,
 18117,   8678,  22281,
 18055,   8821,  22276,
 17991,   8956,  22274,
 17915,   9089,  22281,
 17832,   9218,  22295,
 17753,   9327,  22312,
 17643,   9391,  22372,
 17543,   9482,  22413,
 17421,   9589,  22462,
 17311,   9646,  22523,
 17233,   9775,  22527,
 17174,   9915,  22511,
 17111,  10061,  22494,
 17079,  10193,  22459,
 17027,  10330,  22436,
 16994,  10479,  22392,
 16947,  10615,  22364,
 16891,  10758,  22337,
 16901,  10834,  22293,
 16773,  11029,  22294,
 16710,  11163,  22275,
 16653,  11294,  22251,
 16533,  11377,  22298,
 16425,  11473,  22329,
 16314,  11560,  22366,
 16180,  11633,  22425,
 16107,  11735,  22425,
 16014,  11860,  22425,
 15966,  11994,  22388,
 15946,  12147,  22320,
 15989,  12204,  22258,
 15861,  12307,  22293,
 15738,  12430,  22312,
 15654,  12551,  22303,
 15572,  12675,  22290,
 15481,  12798,  22283,
 15395,  12920,  22273,
 15304,  13042,  22264,
 15208,  13159,  22261,
 15117,  13281,  22251,
 15025,  13405,  22238,
 14958,  13531,  22208,
 14890,  13655,  22177,
 14802,  13770,  22165,
 14697,  13904,  22152,
 14655,  14009,  22113,
 14542,  14122,  22115,
 14432,  14226,  22121,
 14326,  14334,  22120,
 14231,  14448,  22108,
 14146,  14567,  22084,
 14085,  14694,  22039,
 13976,  14807,  22032,
 13971,  14942,  21944,
 14020,  14943,  21912,
 14106,  14792,  21959,
 14194,  14685,  21975,
 14308,  14581,  21970,
 14388,  14464,  21995,
 14453,  14339,  22034,
 14569,  14239,  22022,
 14679,  14138,  22015,
 14794,  14045,  21997,
 14928,  13994,  21939,
 14970,  14102,  21841,
 14932,  14237,  21780,
 14940,  14359,  21694,
 14933,  14489,  21612,
 14916,  14615,  21538,
 14926,  14734,  21451,
 14976,  14732,  21418,
 14990,  14594,  21502,
 15010,  14464,  21576,
 15035,  14332,  21646,
 15034,  14195,  21736,
 15077,  14126,  21752,
 15218,  14116,  21660,
 15333,  14021,  21640,
 15431,  13905,  21646,
 15528,  13789,  21650,
 15622,  13674,  21656,
 15726,  13566,  21649,
 15826,  13452,  21647,
 15920,  13337,  21649,
 16019,  13218,  21650,
 16104,  13115,  21649,
 16190,  13019,  21642,
 16294,  12899,  21636,
 16391,  12782,  21633,
 16449,  12640,  21672,
 16500,  12532,  21695,
 16604,  12411,  21686,
 16706,  12330,  21654,
 16827,  12277,  21590,
 16949,  12194,  21541,
 17060,  12098,  21508,
 17154,  11977,  21501,
 17241,  11848,  21502,
 17317,  11726,  21508,
 17385,  11627,  21508,
 17483,  11458,  21519,
 17499,  11328,  21574,
 17518,  11186,  21633,
 17586,  11063,  21641,
 17635,  10924,  21672,
 17695,  10790,  21690,
 17796,  10671,  21667,
 17879,  10563,  21650,
 17976,  10450,  21626,
 18086,  10394,  21561,
 18210,  10323,  21490,
 18321,  10232,  21439,
 18419,  10135,  21401,
 18505,  10020,  21381,
 18593,   9884,  21368,
 18673,   9754,  21359,
 18737,   9611,  21367,
 18827,   9494,  21340,
 18900,   9366,  21333,
 18990,   9240,  21307,
 19096,   9146,  21253,
 19199,   9053,  21200,
 19281,   8935,  21175,
 19339,   8814,  21173,
 19441,   8686,  21133,
 19513,   8562,  21117,
 19566,   8421,  21125,
 19607,   8273,  21145,
 19595,   8135,  21209,
 19635,   7995,  21226,
 19647,   7878,  21259,
 19744,   7702,  21233,
 19797,   7568,  21232,
 19825,   7458,  21245,
 19890,   7275,  21247,
 19964,   7148,  21222,
 19993,   7004,  21242,
 20017,   6859,  21267,
 20091,   6723,  21240,
 20166,   6609,  21205,
 20293,   6567,  21097,
 20398,   6560,  20997,
 20491,   6602,  20893,
 20585,   6636,  20790,
 20677,   6645,  20695,
 20741,   6746,  20599,
 20822,   6817,  20494,
 20884,   6915,  20397,
 20980,   6950,  20286,
 21084,   6960,  20175,
 21188,   6964,  20064,
 21281,   7000,  19953,
 21371,   7045,  19841,
 21460,   7091,  19728,
 21525,   7184,  19624,
 21601,   7255,  19513,
 21697,   7260,  19405,
 21791,   7266,  19296,
 21881,   7311,  19178,
 21927,   7421,  19082,
 21971,   7529,  18989,
 22047,   7595,  18874,
 22127,   7647,  18759,
 22216,   7679,  18641,
 22300,   7715,  18525,
 22373,   7782,  18410,
 22460,   7814,  18290,
 22545,   7848,  18169,
 22625,   7895,  18050,
 22695,   7956,  17934,
 22760,   8024,  17821,
 22823,   8107,  17703,
 22785,   8258,  17682,
 22788,   8396,  17613,
 22838,   8489,  17503,
 22910,   8542,  17382,
 22983,   8594,  17261,
 23059,   8637,  17137,
 23137,   8671,  17014,
 23205,   8734,  16889,
 23274,   8781,  16770,
 23360,   8787,  16647,
 23452,   8759,  16531,
 23525,   8802,  16404,
 23535,   8935,  16317,
 23505,   9073,  16285,
 23532,   9185,  16183,
 23607,   9220,  16054,
 23686,   9238,  15926,
 23759,   9268,  15800,
 23781,   9378,  15700,
 23762,   9522,  15643,
 23777,   9637,  15550,
 23831,   9701,  15426,
 23900,   9734,  15298,
 23980,   9744,  15165,
 23982,   9836,  15104,
 23927,   9976,  15099,
 23876,  10117,  15085,
 23859,  10254,  15020,
 23838,  10393,  14958,
 23846,  10509,  14863,
 23902,  10487,  14790,
 23968,  10478,  14688,
 23965,  10624,  14589,
 23962,  10734,  14512,
 23971,  10848,  14412,
 24002,  10938,  14292,
 24017,  11040,  14189,
 24010,  11164,  14103,
 24004,  11285,  14016,
 23985,  11416,  13942,
 23916,  11501,  13991,
 23824,  11573,  14089,
 23738,  11686,  14140,
 23650,  11794,  14197,
 23565,  11910,  14243,
 23481,  12002,  14303,
 23395,  12028,  14423,
 23301,  12066,  14543,
 23213,  12093,  14660,
 23119,  12135,  14774,
 23024,  12188,  14878,
 22928,  12282,  14949,
 22837,  12392,  14997,
 22748,  12504,  15039,
 22667,  12631,  15055,
 22604,  12765,  15037,
 22549,  12900,  15004,
 22486,  13029,  14987,
 22451,  13169,  14916,
 22399,  13262,  14913,
 22377,  13084,  15101,
 22354,  12995,  15212,
 22323,  12914,  15327,
 22309,  12803,  15441,
 22287,  12703,  15554,
 22249,  12612,  15682,
 22235,  12519,  15776,
 22230,  12427,  15856,
 22211,  12313,  15971,
 22152,  12252,  16098,
 22072,  12230,  16225,
 21976,  12251,  16339,
 21887,  12269,  16445,
 21787,  12275,  16572,
 21722,  12251,  16675,
 21658,  12191,  16802,
 21561,  12206,  16915,
 21465,  12321,  16954,
 21395,  12347,  17023,
 21330,  12404,  17064,
 21304,  12499,  17027,
 21307,  12660,  16904,
 21257,  12796,  16864,
 21187,  12933,  16848,
 21160,  13044,  16796,
 21058,  13166,  16829,
 20976,  13189,  16914,
 20969,  13074,  17011,
 20989,  12948,  17083,
 21007,  12819,  17158,
 21071,  12684,  17180,
 21080,  12607,  17225,
 20967,  12753,  17256,
 20874,  12893,  17264,
 20776,  12998,  17303,
 20686,  13130,  17312,
 20663,  13214,  17275,
 20632,  13336,  17218,
 20551,  13465,  17214,
 20467,  13555,  17244,
 20357,  13641,  17307,
 20265,  13708,  17362,
 20160,  13828,  17389,
 20036,  13907,  17469,
 19969,  14001,  17471,
 19867,  14130,  17483,
 19773,  14260,  17484,
 19683,  14382,  17485,
 19595,  14495,  17492,
 19505,  14614,  17493,
 19410,  14708,  17519,
 19348,  14762,  17542,
 19390,  14852,  17420,
 19316,  15010,  17366,
 19463,  14975,  17232,
 19530,  15012,  17124,
 19536,  15102,  17037,
 19517,  15209,  16964,
 19572,  15164,  16941,
 19684,  15071,  16894,
 19786,  15028,  16812,
 19868,  15078,  16671,
 19968,  14970,  16649,
 20076,  14859,  16619,
 20184,  14760,  16576,
 20269,  14630,  16587,
 20361,  14527,  16565,
 20458,  14416,  16543,
 20540,  14285,  16555,
 20633,  14164,  16543,
 20733,  14061,  16506,
 20834,  14010,  16421,
 20936,  13985,  16314,
 21044,  13922,  16227,
 21150,  13828,  16169,
 21239,  13740,  16128,
 21344,  13668,  16050,
 21454,  13614,  15950,
 21554,  13520,  15895,
 21648,  13487,  15794,
 21739,  13482,  15674,
 21839,  13425,  15583,
 21931,  13393,  15480,
 21979,  13461,  15354,
 22036,  13511,  15227,
 22075,  13580,  15108,
 22131,  13636,  14976,
 22180,  13697,  14847,
 22263,  13697,  14722,
 22361,  13653,  14614,
 22440,  13564,  14576,
 22523,  13423,  14580,
 22591,  13291,  14595,
 22662,  13164,  14599,
 22756,  13048,  14558,
 22857,  13011,  14431,
 22941,  12975,  14330,
 23027,  12952,  14213,
 23106,  12950,  14086,
 23195,  12908,  13977,
 23277,  12878,  13869,
 23349,  12886,  13739,
 23435,  12862,  13615,
 23519,  12848,  13483,
 23592,  12846,  13357,
 23683,  12794,  13245,
 23769,  12764,  13119,
 23854,  12739,  12989,
 23907,  12752,  12878,
 23980,  12729,  12763,
 24031,  12758,  12639,
 24068,  12776,  12550,
 24137,  12795,  12398,
 24207,  12791,  12265,
 24275,  12796,  12124,
 24307,  12855,  11998,
 24373,  12861,  11855,
 24459,  12808,  11736,
 24526,  12793,  11611,
 24577,  12827,  11465,
 24628,  12849,  11329,
 24689,  12850,  11194,
 24739,  12875,  11054,
 24792,  12895,  10913,
 24812,  12912,  10846,
 24944,  12747,  10738,
 25008,  12615,  10746,
 25086,  12579,  10604,
 25145,  12492,  10568,
 25214,  12366,  10551,
 25296,  12230,  10513,
 25366,  12138,  10451,
 25433,  12131,  10297,
 25494,  12071,  10215,
 25546,  12039,  10122,
 25563,  12114,   9989,
 25572,  12107,   9974,
 25576,  11995,  10099,
 25638,  11883,  10075,
 25712,  11776,  10011,
 25789,  11703,   9899,
 25861,  11642,   9782,
 25926,  11609,   9646,
 25956,  11651,   9515,
 25988,  11698,   9369,
 26027,  11694,   9266,
 26051,  11514,   9421,
 26021,  11460,   9569,
 25990,  11423,   9699,
 25941,  11405,   9848,
 25908,  11399,   9941,
 25997,  11241,   9888,
 26070,  11149,   9799,
 26147,  11047,   9710,
 26221,  10945,   9626,
 26295,  10835,   9549,
 26367,  10739,   9457,
 26438,  10662,   9347,
 26503,  10611,   9220,
 26541,  10634,   9081,
 26568,  10690,   8938,
 26585,  10750,   8813,
 26607,  10814,   8668,
 26599,  10908,   8573,
 26565,  11048,   8498,
 26491,  11185,   8553,
 26451,  11346,   8462,
 26469,  11375,   8367,
 26523,  11337,   8247,
 26559,  11198,   8319,
 26611,  11083,   8308,
 26652,  11073,   8190,
 26663,  10938,   8335,
 26729,  10798,   8305,
 26795,  10673,   8251,
 26846,  10531,   8271,
 26877,  10398,   8337,
 26915,  10259,   8387,
 26962,  10126,   8398,
 27016,  10003,   8372,
 27070,   9884,   8339,
 27118,   9759,   8331,
 27161,   9625,   8346,
 27214,   9476,   8342,
 27261,   9347,   8334,
 27321,   9189,   8315,
 27374,   9051,   8290,
 27424,   8914,   8273,
 27475,   8769,   8260,
 27529,   8610,   8248,
 27564,   8502,   8244,
 27623,   8342,   8209,
 27674,   8219,   8160,
 27734,   8088,   8089,
 27781,   7975,   8039,
 27835,   7818,   8005,
 27893,   7689,   7928,
 27946,   7567,   7858,
 27985,   7467,   7814,
 28029,   7330,   7786,
 28083,   7176,   7734,
 28124,   7052,   7701,
 28160,   6913,   7697,
 28208,   6744,   7671,
 28244,   6635,   7631,
 28296,   6468,   7581,
 28341,   6338,   7525,
 28389,   6219,   7444,
 28435,   6102,   7362,
 28479,   5974,   7296,
 28520,   5851,   7236,
 28561,   5704,   7192,
 28598,   5567,   7153,
 28639,   5427,   7098,
 28675,   5301,   7047,
 28703,   5202,   7005,
 28733,   5067,   6983,
 28767,   4872,   6982,
 28796,   4763,   6934,
 28831,   4652,   6867,
 28878,   4491,   6773,
 28917,   4375,   6683,
 28957,   4277,   6571,
 28996,   4227,   6432,
 29019,   4278,   6293,
 29034,   4360,   6164,
 29029,   4491,   6097,
 29016,   4618,   6060,
 29020,   4738,   5947,
 29041,   4785,   5805,
 29063,   4826,   5662,
 29093,   4817,   5513,
 29098,   4822,   5483,
 29058,   4875,   5644,
 29032,   5003,   5666,
 29026,   5128,   5582,
 29017,   5257,   5510,
 29015,   5365,   5419,
 29040,   5362,   5287,
 29045,   5424,   5196,
 29016,   5574,   5197,
 28988,   5722,   5190,
 28950,   5886,   5218,
 28927,   6001,   5219,
 28898,   6161,   5191,
 28877,   6316,   5123,
 28867,   6423,   5045,
 28848,   6556,   4980,
 28821,   6701,   4944,
 28792,   6847,   4911,
 28760,   6969,   4928,
 28732,   7058,   4968,
 28697,   7207,   4955,
 28652,   7358,   4994,
 28620,   7505,   4955,
 28582,   7633,   4979,
 28539,   7779,   5000,
 28505,   7924,   4970,
 28478,   8058,   4904,
 28464,   8168,   4805,
 28480,   8198,   4658,
 28494,   8192,   4583,
 28495,   8226,   4511,
 28469,   8380,   4395,
 28466,   8450,   4278,
 28490,   8438,   4134,
 28497,   8487,   3988,
 28489,   8570,   3861,
 28451,   8710,   3831,
 28419,   8830,   3796,
 28407,   8918,   3675,
 28404,   8982,   3538,
 28397,   9058,   3399,
 28379,   9147,   3311,
 28354,   9261,   3204,
 28341,   9348,   3070,
 28332,   9418,   2937,
 28306,   9526,   2831,
 28281,   9630,   2729,
 28251,   9743,   2634,
 28223,   9844,   2566,
 28195,   9957,   2429,
 28174,  10044,   2307,
 28165,  10073,   2288,
 28161,  10063,   2382,
 28127,  10187,   2260,
 28154,  10131,   2177,
 28153,  10176,   1970,
 28130,  10263,   1836,
 28117,  10316,   1731,
 28082,  10432,   1602,
 28045,  10542,   1535,
 28014,  10631,   1488,
 27953,  10784,   1536,
 27904,  10913,   1498,
 27875,  11005,   1382,
 27866,  11044,   1236,
 27854,  11088,   1091,
 27820,  11183,    978,
 27771,  11310,    930,
 27742,  11377,    962,
 27804,  11232,    885,
 27861,  11090,    874,
 27869,  11077,    806,
 27855,  11117,    708,
 27803,  11250,    638,
 27878,  11068,    581,
 27866,  11103,    469,
 27822,  11212,    460,
 27855,  11136,    321,
 27807,  11256,    244,
 27786,  11310,    218,
 27851,  11148,    169,
 27809,  11254,     73,
 27750,  11398,     59,
 27749,  11402,     38,
 27810,  11252,     -4,
 27843,  11170,    -76,
 27795,  11287,   -205,
 27747,  11402,   -289,
 27690,  11540,   -252,
 27637,  11668,   -245,
 27580,  11802,   -245,
 27536,  11906,   -191,
 27515,  11955,    -69,
 27476,  12043,     63,
 27450,  12102,    202,
 27428,  12150,    250,
 27431,  12147,    112,
 27478,  12040,      7,
 27512,  11962,   -119,
 27516,  11950,   -267,
 27588,  11783,   -291,
 27632,  11677,   -378,
 27647,  11634,   -522,
 27642,  11638,   -678,
 27688,  11522,   -788,
 27742,  11385,   -863,
 27790,  11264,   -903,
 27846,  11122,   -944,
 27898,  10989,   -968,
 27951,  10850,  -1002,
 27996,  10727,  -1076,
 28005,  10700,  -1114,
 27983,  10759,  -1106,
 28037,  10610,  -1177,
 28075,  10496,  -1271,
 28084,  10466,  -1332,
 28060,  10527,  -1345,
 28108,  10392,  -1398,
 28111,  10376,  -1452,
 28095,  10412,  -1496,
 28157,  10243,  -1503,
 28157,  10235,  -1561,
 28140,  10261,  -1690,
 28167,  10166,  -1807,
 28199,  10063,  -1884,
 28244,   9927,  -1931,
 28268,   9887,  -1785,
 28301,   9762,  -1939,
 28264,   9858,  -1994,
 28322,   9680,  -2044,
 28350,   9587,  -2096,
 28398,   9426,  -2169,
 28437,   9296,  -2220,
 28480,   9154,  -2252,
 28518,   9028,  -2282,
 28566,   8881,  -2256,
 28615,   8735,  -2216,
 28662,   8587,  -2179,
 28702,   8465,  -2135,
 28746,   8318,  -2120,
 28748,   8289,  -2196,
 28706,   8406,  -2301,
 28689,   8448,  -2354,
 28739,   8273,  -2373,
 28716,   8324,  -2465,
 28749,   8202,  -2497,
 28717,   8286,  -2581,
 28732,   8216,  -2639,
 28717,   8255,  -2680,
 28743,   8145,  -2734,
 28704,   8248,  -2841,
 28661,   8365,  -2926,
 28628,   8434,  -3050,
 28592,   8522,  -3143,
 28568,   8605,  -3139,
 28565,   8551,  -3307,
 28517,   8671,  -3405,
 28476,   8794,  -3435,
 28432,   8922,  -3465,
 28463,   8771,  -3594,
 28503,   8616,  -3651,
 28517,   8531,  -3743,
 28515,   8496,  -3835,
 28571,   8316,  -3815,
 28601,   8186,  -3869,
 28638,   8040,  -3901,
 28676,   7898,  -3913,
 28713,   7752,  -3934,
 28740,   7618,  -4001,
 28773,   7471,  -4033,
 28803,   7328,  -4088,
 28840,   7173,  -4102,
 28851,   7103,  -4142,
 28823,   7202,  -4169,
 28852,   7042,  -4239,
 28873,   6912,  -4307,
 28899,   6768,  -4365,
 28928,   6620,  -4402,
 28959,   6479,  -4406,
 28990,   6338,  -4403,
 29023,   6180,  -4413,
 29029,   6109,  -4468,
 29042,   6037,  -4483,
 29075,   5892,  -4464,
 29108,   5736,  -4450,
 29144,   5606,  -4381,
 29173,   5472,  -4355,
 29199,   5324,  -4369,
 29201,   5265,  -4422,
 29186,   5315,  -4466,
 29225,   5147,  -4403,
 29252,   5018,  -4372,
 29286,   4865,  -4318,
 29312,   4723,  -4300,
 29342,   4578,  -4255,
 29364,   4441,  -4244,
 29371,   4302,  -4337,
 29347,   4329,  -4472,
 29352,   4195,  -4565,
 29351,   4091,  -4667,
 29349,   3996,  -4762,
 29352,   3844,  -4869,
 29345,   3774,  -4965,
 29352,   3650,  -5017,
 29353,   3536,  -5090,
 29348,   3424,  -5191,
 29349,   3298,  -5268,
 29350,   3166,  -5343,
 29361,   3010,  -5371,
 29375,   2868,  -5377,
 29385,   2717,  -5399,
 29392,   2578,  -5429,
 29388,   2463,  -5503,
 29400,   2317,  -5503,
 29403,   2177,  -5541,
 29401,   2055,  -5599,
 29392,   1923,  -5694,
 29382,   1801,  -5784,
 29372,   1680,  -5870,
 29377,   1524,  -5888,
 29363,   1409,  -5984,
 29340,   1333,  -6115,
 29322,   1240,  -6221,
 29298,   1152,  -6349,
 29271,   1086,  -6485,
 29249,    988,  -6597,
 29222,    916,  -6726,
 29194,    844,  -6855,
 29172,    748,  -6961,
 29152,    713,  -7047,
 29112,    762,  -7204,
 29090,    783,  -7292,
 29064,    785,  -7394,
 29072,    939,  -7344,
 29082,   1075,  -7285,
 29093,   1210,  -7220,
 29106,   1348,  -7142,
 29130,   1437,  -7026,
 29138,   1573,  -6963,
 29130,   1726,  -6961,
 29124,   1868,  -6950,
 29119,   2021,  -6927,
 29104,   2165,  -6949,
 29088,   2311,  -6968,
 29079,   2463,  -6953,
 29080,   2600,  -6898,
 29085,   2733,  -6828,
 29094,   2856,  -6738,
 29114,   2941,  -6614,
 29129,   3041,  -6502,
 29135,   3162,  -6415,
 29151,   3247,  -6300,
 29170,   3318,  -6174,
 29181,   3421,  -6065,
 29184,   3548,  -5977,
 29203,   3606,  -5844,
 29234,   3590,  -5698,
 29252,   3658,  -5564,
 29264,   3738,  -5443,
 29272,   3824,  -5338,
 29270,   3957,  -5253,
 29255,   3998,  -5308,
 29258,   3874,  -5380,
 29258,   3825,  -5418,
 29242,   4021,  -5361,
 29228,   4167,  -5326,
 29212,   4314,  -5294,
 29210,   4417,  -5222,
 29208,   4541,  -5125,
 29188,   4691,  -5104,
 29176,   4833,  -5040,
 29205,   4814,  -4889,
 29217,   4859,  -4772,
 29199,   5008,  -4729,
 29177,   5154,  -4704,
 29149,   5304,  -4715,
 29122,   5427,  -4737,
 29086,   5568,  -4796,
 29051,   5696,  -4857,
 29017,   5846,  -4884,
 28980,   5989,  -4929,
 28940,   6123,  -4996,
 28902,   6256,  -5052,
 28866,   6390,  -5090,
 28836,   6539,  -5069,
 28800,   6683,  -5089,
 28766,   6820,  -5098,
 28738,   6942,  -5091,
 28701,   6996,  -5228,
 28668,   7019,  -5372,
 28652,   6960,  -5532,
 28691,   6798,  -5533,
 28728,   6652,  -5521,
 28737,   6569,  -5573,
 28706,   6562,  -5737,
 28676,   6570,  -5877,
 28649,   6549,  -6028,
 28642,   6493,  -6124,
 28637,   6405,  -6236,
 28627,   6308,  -6381,
 28622,   6221,  -6486,
 28635,   6086,  -6559,
 28631,   6033,  -6622,
 28660,   5840,  -6672,
 28681,   5686,  -6715,
 28645,   5720,  -6838,
 28615,   5771,  -6921,
 28634,   5622,  -6963,
 28661,   5497,  -6951,
 28623,   5520,  -7088,
 28589,   5484,  -7252,
 28571,   5406,  -7381,
 28562,   5311,  -7485,
 28535,   5253,  -7627,
 28542,   5153,  -7668,
 28588,   5025,  -7582,
 28615,   4878,  -7576,
 28641,   4726,  -7574,
 28658,   4563,  -7609,
 28670,   4481,  -7611,
 28618,   4538,  -7773,
 28576,   4649,  -7861,
 28534,   4759,  -7946,
 28488,   4817,  -8078,
 28437,   4879,  -8218,
 28412,   5000,  -8231,
 28416,   5123,  -8142,
 28415,   5162,  -8121,
 28397,   5034,  -8262,
 28358,   5020,  -8402,
 28349,   5167,  -8346,
 28352,   5248,  -8282,
 28322,   5171,  -8434,
 28326,   5268,  -8361,
 28286,   5279,  -8488,
 28280,   5371,  -8448,
 28238,   5485,  -8516,
 28198,   5495,  -8643,
 28166,   5432,  -8785,
 28107,   5507,  -8926,
 28053,   5569,  -9057,
 28003,   5659,  -9154,
 27950,   5719,  -9277,
 27892,   5810,  -9397,
 27838,   5881,  -9511,
 27792,   5981,  -9583,
 27751,   6074,  -9643,
 27714,   6222,  -9656,
 27683,   6380,  -9642,
 27653,   6489,  -9655,
 27603,   6606,  -9718,
 27573,   6759,  -9698,
 27558,   6897,  -9643,
 27533,   7021,  -9626,
 27499,   7173,  -9611,
 27471,   7331,  -9572,
 27451,   7467,  -9522,
 27429,   7601,  -9479,
 27414,   7737,  -9414,
 27388,   7877,  -9374,
 27388,   7982,  -9284,
 27391,   8101,  -9170,
 27383,   8221,  -9087,
 27376,   8327,  -9012,
 27390,   8421,  -8881,
 27404,   8511,  -8751,
 27411,   8591,  -8650,
 27421,   8709,  -8501,
 27411,   8818,  -8418,
 27418,   8913,  -8296,
 27416,   9018,  -8188,
 27413,   9124,  -8078,
 27398,   9169,  -8081,
 27360,   9306,  -8052,
 27364,   9389,  -7939,
 27365,   9480,  -7827,
 27348,   9610,  -7730,
 27328,   9720,  -7662,
 27271,   9858,  -7686,
 27217,   9995,  -7702,
 27162,  10125,  -7726,
 27096,  10245,  -7802,
 27038,  10315,  -7907,
 26966,  10424,  -8009,
 26909,  10555,  -8030,
 26852,  10663,  -8078,
 26816,  10734,  -8104,
 26771,  10746,  -8236,
 26710,  10809,  -8350,
 26651,  10904,  -8415,
 26579,  10982,  -8541,
 26533,  11006,  -8652,
 26471,  11049,  -8786,
 26430,  11097,  -8848,
 26396,  11157,  -8875,
 26382,  11095,  -8993,
 26372,  10998,  -9142,
 26336,  10976,  -9271,
 26272,  11041,  -9374,
 26274,  10937,  -9490,
 26351,  10796,  -9438,
 26396,  10656,  -9471,
 26420,  10536,  -9538,
 26437,  10421,  -9615,
 26379,  10409,  -9788,
 26322,  10533,  -9810,
 26304,  10644,  -9736,
 26278,  10765,  -9673,
 26205,  10888,  -9734,
 26189,  10901,  -9762,
 26143,  10918,  -9867,
 26065,  10976, -10006,
 26015,  10992, -10119,
 25953,  11020, -10246,
 25878,  11097, -10353,
 25815,  11148, -10456,
 25753,  11154, -10600,
 25724,  11203, -10618,
 25692,  11167, -10734,
 25622,  11220, -10845,
 25549,  11298, -10938,
 25493,  11377, -10985,
 25480,  11442, -10947,
 25450,  11375, -11086,
 25392,  11536, -11053,
 25373,  11655, -10971,
 25298,  11767, -11026,
 25296,  11734, -11065,
 25330,  11630, -11097,
 25335,  11499, -11220,
 25334,  11419, -11305,
 25279,  11445, -11401,
 25225,  11499, -11466,
 25185,  11544, -11509,
 25132,  11574, -11594,
 25100,  11571, -11667,
 25013,  11634, -11789,
 24963,  11625, -11905,
 24898,  11644, -12021,
 24827,  11661, -12151,
 24747,  11707, -12268,
 24649,  11823, -12355,
 24621,  11874, -12361,
 24607,  11905, -12360,
 24516,  12004, -12445,
 24442,  12036, -12559,
 24339,  12123, -12674,
 24260,  12196, -12756,
 24178,  12278, -12832,
 24128,  12369, -12840,
 24115,  12440, -12794,
 24037,  12489, -12893,
 23960,  12494, -13032,
 23878,  12605, -13076,
 23795,  12676, -13158,
 23731,  12771, -13181,
 23669,  12819, -13247,
 23625,  12921, -13225,
 23585,  12906, -13310,
 23557,  12900, -13366,
 23499,  13041, -13331,
 23460,  13142, -13301,
 23506,  13176, -13186,
 23379,  13263, -13323,
 23325,  13348, -13333,
 23269,  13491, -13287,
 23222,  13471, -13390,
 23237,  13427, -13406,
 23164,  13532, -13428,
 23074,  13644, -13470,
 23010,  13739, -13483,
 22895,  13858, -13557,
 22816,  13980, -13563,
 22775,  14082, -13527,
 22770,  14103, -13514,
 22687,  14125, -13630,
 22593,  14209, -13699,
 22492,  14259, -13812,
 22472,  14398, -13702,
 22473,  14433, -13662,
 22371,  14490, -13768,
 22342,  14591, -13709,
 22265,  14665, -13755,
 22207,  14677, -13836,
 22175,  14791, -13766,
 22242,  14780, -13668,
 22083,  14913, -13782,
 22063,  14955, -13769,
 22113,  15007, -13631,
 22121,  15103, -13512,
 22184,  15121, -13388,
 22300,  15052, -13272,
 22331,  15105, -13159,
 22360,  15133, -13077,
 22234,  15168, -13251,
 22141,  15249, -13314,
 22036,  15322, -13404,
 21937,  15381, -13497,
 21851,  15437, -13574,
 21817,  15570, -13475,
 21842,  15646, -13347,
 21852,  15736, -13224,
 21892,  15792, -13089,
 21896,  15866, -12994,
 21969,  15875, -12858,
 22045,  15880, -12721,
 22050,  15979, -12589,
 22014,  16017, -12604,
 22025,  15893, -12740,
 21953,  15901, -12853,
 21869,  15930, -12960,
 21845,  15852, -13095,
 21783,  15831, -13225,
 21732,  15789, -13358,
 21662,  15806, -13451,
 21650,  15927, -13327,
 21657,  16005, -13222,
 21644,  16106, -13119,
 21677,  16180, -12974,
 21615,  16301, -12925,
 21574,  16422, -12841,
 21541,  16536, -12750,
 21505,  16650, -12662,
 21461,  16767, -12581,
 21417,  16888, -12494,
 21436,  16959, -12364,
 21474,  17011, -12228,
 21489,  17090, -12089,
 21490,  17149, -12004,
 21396,  17257, -12017,
 21292,  17362, -12051,
 21177,  17463, -12107,
 21086,  17533, -12165,
 20981,  17630, -12205,
 20917,  17705, -12208,
 20851,  17695, -12335,
 20748,  17800, -12356,
 20666,  17881, -12376,
 20530,  17943, -12513,
 20454,  17975, -12591,
 20329,  18033, -12710,
 20282,  18009, -12819,
 20191,  18080, -12861,
 20097,  18204, -12834,
 20155,  18256, -12668,
 20229,  18244, -12568,
 20293,  18269, -12427,
 20332,  18325, -12280,
 20355,  18390, -12145,
 20452,  18359, -12027,
 20540,  18298, -11970,
 20669,  18200, -11897,
 20771,  18118, -11845,
 20851,  18112, -11714,
 20876,  18171, -11577,
 20802,  18289, -11522,
 20718,  18397, -11503,
 20680,  18506, -11397,
 20739,  18516, -11272,
 20804,  18530, -11128,
 20828,  18581, -10997,
 20806,  18673, -10882,
 20732,  18785, -10830,
 20627,  18894, -10843,
 20526,  18961, -10917,
 20489,  18918, -11060,
 20387,  18951, -11190,
 20322,  18970, -11276,
 20189,  19094, -11307,
 20083,  19191, -11329,
 19977,  19259, -11401,
 19872,  19312, -11496,
 19762,  19366, -11594,
 19656,  19453, -11628,
 19522,  19554, -11685,
 19420,  19631, -11726,
 19342,  19635, -11848,
 19271,  19630, -11970,
 19271,  19539, -12119,
 19331,  19442, -12179,
 19444,  19346, -12151,
 19552,  19264, -12109,
 19675,  19171, -12057,
 19763,  19080, -12057,
 19744,  19003, -12209,
 19880,  18892, -12162,
 19973,  18813, -12130,
 19829,  18871, -12277,
 19716,  18933, -12362,
 19601,  19023, -12406,
 19490,  19084, -12487,
 19377,  19140, -12578,
 19271,  19186, -12669,
 19174,  19217, -12770,
 19081,  19220, -12904,
 18976,  19264, -12993,
 18975,  19159, -13148,
 18913,  19122, -13290,
 18886,  19062, -13415,
 18980,  18941, -13453,
 19086,  18832, -13457,
 19085,  18771, -13542,
 19078,  18743, -13593,
 19198,  18703, -13477,
 19316,  18581, -13477,
 19368,  18515, -13494,
 19339,  18450, -13624,
 19304,  18391, -13752,
 19195,  18442, -13835,
 19136,  18394, -13982,
 19035,  18393, -14119,
 19059,  18326, -14174,
 19124,  18178, -14277,
 19161,  18091, -14339,
 19200,  18017, -14378,
 19287,  18028, -14248,
 19375,  17944, -14235,
 19401,  17802, -14377,
 19458,  17684, -14446,
 19474,  17591, -14537,
 19593,  17459, -14536,
 19705,  17343, -14524,
 19779,  17228, -14560,
 19804,  17119, -14654,
 19870,  17033, -14665,
 19863,  16948, -14773,
 19766,  17000, -14843,
 19655,  17045, -14937,
 19618,  17024, -15010,
 19548,  17102, -15013,
 19467,  17159, -15053,
 19355,  17196, -15156,
 19265,  17189, -15277,
 19159,  17257, -15334,
 19062,  17252, -15460,
 18936,  17347, -15508,
 18850,  17445, -15504,
 18749,  17577, -15476,
 18721,  17666, -15409,
 18658,  17796, -15335,
 18580,  17917, -15288,
 18516,  18040, -15222,
 18473,  18155, -15137,
 18455,  18262, -15031,
 18440,  18365, -14922,
 18438,  18462, -14805,
 18420,  18566, -14698,
 18391,  18674, -14596,
 18378,  18772, -14486,
 18405,  18848, -14352,
 18423,  18927, -14226,
 18420,  19012, -14116,
 18327,  19128, -14080,
 18229,  19216, -14088,
 18110,  19281, -14151,
 18002,  19312, -14248,
 17877,  19384, -14306,
 17754,  19454, -14364,
 17632,  19540, -14397,
 17512,  19603, -14459,
 17415,  19679, -14473,
 17327,  19800, -14414,
 17270,  19907, -14333,
 17154,  20008, -14333,
 17036,  20097, -14349,
 16913,  20174, -14386,
 16800,  20214, -14463,
 16683,  20314, -14457,
 16559,  20355, -14542,
 16452,  20440, -14545,
 16325,  20535, -14553,
 16264,  20544, -14609,
 16240,  20520, -14670,
 16176,  20528, -14728,
 16226,  20418, -14827,
 16138,  20391, -14959,
 16075,  20356, -15074,
 15930,  20394, -15176,
 15812,  20432, -15249,
 15680,  20499, -15294,
 15549,  20558, -15349,
 15420,  20625, -15390,
 15290,  20708, -15408,
 15169,  20788, -15420,
 15063,  20878, -15402,
 14942,  20968, -15396,
 14813,  21040, -15425,
 14690,  21129, -15420,
 14565,  21213, -15424,
 14439,  21298, -15425,
 14307,  21372, -15445,
 14178,  21454, -15450,
 14050,  21534, -15456,
 13925,  21619, -15450,
 13811,  21711, -15423,
 13697,  21802, -15397,
 13588,  21902, -15352,
 13469,  21990, -15331,
 13338,  22069, -15331,
 13222,  22162, -15297,
 13102,  22251, -15272,
 12968,  22327, -15275,
 12836,  22401, -15278,
 12718,  22485, -15253,
 12621,  22585, -15187,
 12550,  22664, -15128,
 12448,  22764, -15062,
 12343,  22870, -14987,
 12280,  22963, -14897,
 12205,  23037, -14843,
 12144,  23145, -14726,
 12065,  23238, -14643,
 11955,  23327, -14592,
 11850,  23427, -14518,
 11743,  23507, -14475,
 11611,  23582, -14460,
 11502,  23664, -14413,
 11466,  23725, -14340,
 11442,  23801, -14233,
 11363,  23892, -14144,
 11382,  23959, -14015,
 11364,  23980, -13994,
 11258,  23991, -14060,
 11217,  24064, -13968,
 11249,  24117, -13850,
 11297,  24184, -13695,
 11283,  24262, -13567,
 11306,  24328, -13427,
 11374,  24345, -13340,
 11490,  24338, -13252,
 11582,  24325, -13196,
 11676,  24228, -13292,
 11797,  24142, -13341,
 11833,  24150, -13295,
 11749,  24223, -13238,
 11947,  24142, -13207,
 12035,  24157, -13100,
 11896,  24256, -13045,
 11881,  24313, -12950,
 11833,  24357, -12911,
 11965,  24292, -12912,
 12066,  24221, -12953,
 12122,  24240, -12863,
 12013,  24335, -12787,
 11929,  24418, -12707,
 11929,  24462, -12621,
 12056,  24452, -12520,
 12142,  24466, -12410,
 12172,  24520, -12273,
 12033,  24600, -12250,
 11896,  24646, -12292,
 11761,  24707, -12299,
 11625,  24765, -12311,
 11489,  24816, -12337,
 11353,  24870, -12354,
 11211,  24934, -12354,
 11068,  25005, -12339,
 10949,  25076, -12301,
 10810,  25145, -12284,
 10680,  25197, -12290,
 10531,  25255, -12300,
 10390,  25312, -12301,
 10248,  25369, -12303,
 10123,  25424, -12294,
 10008,  25501, -12228,
  9870,  25561, -12215,
  9725,  25607, -12234,
  9590,  25670, -12209,
  9459,  25733, -12179,
  9314,  25779, -12194,
  9170,  25808, -12242,
  9044,  25817, -12317,
  8913,  25819, -12406,
  8810,  25817, -12484,
  8665,  25825, -12569,
  8592,  25800, -12670,
  8533,  25775, -12761,
  8408,  25826, -12741,
  8297,  25805, -12856,
  8187,  25795, -12946,
  8043,  25815, -12996,
  7950,  25788, -13107,
  7863,  25842, -13053,
  7718,  25909, -13006,
  7596,  25909, -13078,
  7500,  25878, -13195,
  7430,  25854, -13280,
  7267,  25855, -13369,
  7217,  25796, -13509,
  7205,  25764, -13576,
  7363,  25753, -13512,
  7443,  25704, -13561,
  7338,  25680, -13663,
  7184,  25712, -13684,
  7054,  25706, -13763,
  6899,  25759, -13743,
  6788,  25758, -13800,
  6653,  25756, -13870,
  6503,  25766, -13922,
  6450,  25829, -13829,
  6572,  25846, -13740,
  6605,  25873, -13673,
  6518,  25946, -13576,
  6407,  26011, -13504,
  6280,  26073, -13445,
  6138,  26122, -13415,
  6002,  26174, -13374,
  5891,  26241, -13293,
  5749,  26295, -13248,
  5653,  26363, -13155,
  5508,  26414, -13113,
  5370,  26435, -13128,
  5236,  26438, -13176,
  5093,  26456, -13195,
  4981,  26442, -13267,
  4912,  26423, -13331,
  4785,  26440, -13342,
  4891,  26352, -13478,
  4964,  26296, -13560,
  4947,  26230, -13693,
  4933,  26163, -13826,
  4777,  26206, -13800,
  4648,  26262, -13738,
  4521,  26315, -13677,
  4400,  26362, -13627,
  4235,  26403, -13600,
  4135,  26408, -13621,
  4096,  26491, -13471,
  4029,  26564, -13346,
  3959,  26620, -13256,
  3801,  26645, -13250,
  3663,  26646, -13287,
  3548,  26614, -13384,
  3529,  26592, -13433,
  3699,  26592, -13385,
  3828,  26540, -13453,
  3877,  26468, -13580,
  3946,  26401, -13690,
  3983,  26338, -13801,
  4064,  26275, -13896,
  4130,  26214, -13992,
  4261,  26178, -14020,
  4430,  26135, -14048,
  4580,  26088, -14087,
  4670,  26023, -14177,
  4798,  25970, -14231,
  4918,  25909, -14302,
  5056,  25861, -14341,
  5179,  25800, -14406,
  5311,  25742, -14462,
  5402,  25669, -14558,
  5536,  25598, -14633,
  5651,  25547, -14677,
  5790,  25494, -14714,
  5909,  25442, -14757,
  6068,  25422, -14727,
  6213,  25385, -14730,
  6298,  25355, -14747,
  6334,  25271, -14875,
  6451,  25192, -14958,
  6573,  25134, -15002,
  6679,  25085, -15038,
  6788,  24991, -15144,
  6870,  24909, -15242,
  6945,  24827, -15343,
  7010,  24742, -15450,
  7072,  24657, -15558,
  7113,  24570, -15675,
  7146,  24484, -15795,
  7176,  24395, -15918,
  7196,  24309, -16041,
  7221,  24221, -16161,
  7254,  24132, -16280,
  7286,  24042, -16398,
  7320,  23952, -16515,
  7342,  23862, -16634,
  7330,  23789, -16744,
  7359,  23686, -16877,
  7391,  23593, -16993,
  7441,  23498, -17102,
  7455,  23407, -17221,
  7425,  23323, -17346,
  7230,  23411, -17310,
  7109,  23481, -17266,
  6972,  23546, -17233,
  6853,  23625, -17173,
  6755,  23712, -17091,
  6699,  23794, -17000,
  6642,  23877, -16904,
  6583,  23950, -16824,
  6378,  24004, -16826,
  6227,  24031, -16844,
  6149,  24036, -16867,
  6127,  24137, -16729,
  6090,  24227, -16612,
  6002,  24311, -16521,
  5875,  24374, -16474,
  5740,  24430, -16439,
  5601,  24436, -16477,
  5461,  24437, -16524,
  5327,  24507, -16463,
  5332,  24588, -16341,
  5349,  24666, -16216,
  5308,  24752, -16099,
  5219,  24831, -16006,
  5121,  24906, -15921,
  5002,  24970, -15859,
  4902,  24989, -15860,
  4919,  24894, -16003,
  4787,  24944, -15965,
  4767,  25031, -15834,
  4814,  25087, -15732,
  4832,  25155, -15616,
  4803,  25241, -15486,
  4697,  25307, -15412,
  4631,  25380, -15310,
  4761,  25412, -15216,
  4864,  25382, -15235,
  4911,  25459, -15090,
  4841,  25538, -14979,
  4742,  25609, -14889,
  4614,  25672, -14821,
  4500,  25734, -14748,
  4413,  25804, -14653,
  4358,  25882, -14530,
  4261,  25950, -14437,
  4140,  25974, -14430,
  3993,  25983, -14454,
  3888,  25952, -14539,
  3808,  26017, -14443,
  3640,  26063, -14404,
  3540,  26082, -14395,
  3593,  25981, -14563,
  3556,  25952, -14624,
  3429,  26017, -14539,
  3308,  26075, -14462,
  3174,  26104, -14440,
  3018,  26129, -14428,
  2874,  26127, -14461,
  2737,  26124, -14493,
  2634,  26057, -14631,
  2599,  25995, -14748,
  2505,  25986, -14780,
  2426,  26075, -14636,
  2323,  26117, -14578,
  2176,  26169, -14507,
  2045,  26208, -14455,
  1951,  26258, -14378,
  1841,  26303, -14309,
  1753,  26344, -14246,
  1608,  26402, -14155,
  1473,  26430, -14116,
  1324,  26463, -14071,
  1170,  26505, -14004,
  1060,  26534, -13957,
   918,  26567, -13905,
   796,  26610, -13830,
   708,  26646, -13765,
   660,  26672, -13717,
   581,  26628, -13807,
   430,  26610, -13847,
   291,  26581, -13905,
   200,  26591, -13888,
   115,  26650, -13776,
   152,  26720, -13639,
   184,  26781, -13518,
   263,  26823, -13434,
   320,  26866, -13345,
   336,  26962, -13150,
   372,  27024, -13021,
   442,  27033, -13002,
   579,  27073, -12912,
   630,  27123, -12804,
   799,  27106, -12831,
   835,  27117, -12805,
   896,  27153, -12725,
  1051,  27132, -12757,
  1134,  27126, -12762,
   903,  27160, -12709,
   767,  27155, -12728,
   670,  27172, -12699,
   742,  27201, -12631,
   587,  27168, -12711,
   496,  27126, -12804,
   333,  27111, -12840,
   209,  27134, -12794,
    86,  27168, -12723,
   -26,  27215, -12623,
  -100,  27268, -12509,
  -124,  27327, -12378,
   -47,  27384, -12252,
   -96,  27438, -12131,
  -195,  27467, -12062,
  -303,  27461, -12074,
  -249,  27397, -12220,
  -316,  27334, -12359,
  -395,  27295, -12443,
  -545,  27301, -12423,
  -684,  27317, -12382,
  -832,  27292, -12428,
  -908,  27240, -12537,
  -951,  27178, -12668,
 -1080,  27146, -12726,
 -1239,  27116, -12774,
 -1344,  27070, -12861,
 -1468,  27064, -12861,
 -1498,  27072, -12839,
 -1571,  27048, -12882,
 -1628,  27092, -12781,
 -1589,  27158, -12645,
 -1691,  27220, -12499,
 -1661,  27252, -12432,
 -1650,  27301, -12327,
 -1621,  27328, -12270,
 -1772,  27301, -12309,
 -1889,  27325, -12239,
 -1873,  27352, -12179,
 -2011,  27347, -12169,
 -2076,  27402, -12033,
 -2109,  27437, -11949,
 -1987,  27472, -11888,
 -1866,  27521, -11794,
 -1751,  27565, -11708,
 -1638,  27606, -11629,
 -1480,  27612, -11635,
 -1356,  27615, -11643,
 -1173,  27635, -11616,
 -1150,  27620, -11654,
 -1230,  27560, -11787,
 -1248,  27514, -11892,
 -1238,  27482, -11967,
 -1152,  27501, -11932,
 -1070,  27554, -11817,
 -1049,  27615, -11676,
 -1033,  27679, -11525,
  -957,  27712, -11450,
  -855,  27771, -11316,
  -726,  27804, -11243,
  -588,  27839, -11163,
  -477,  27867, -11100,
  -372,  27896, -11031,
  -251,  27937, -10930,
  -136,  27977, -10828,
   -54,  27995, -10784,
   816,  28018, -10693,
   926,  28058, -10579,
  1003,  28081, -10509,
  1171,  28109, -10418,
  1304,  28129, -10348,
  1418,  28159, -10250,
  1565,  28168, -10204,
  1475,  28195, -10142,
  1616,  28208, -10085,
  1689,  28193, -10115,
  1742,  28142, -10247,
  1723,  28108, -10343,
  1682,  28057, -10488,
  1697,  28008, -10615,
  1792,  27974, -10688,
  1961,  27979, -10646,
  2013,  28028, -10506,
  2137,  28056, -10407,
  2154,  28109, -10260,
  2223,  28137, -10167,
  2394,  28104, -10220,
  2538,  28108, -10172,
  2678,  28116, -10114,
  2809,  28128, -10047,
  2922,  28139,  -9983,
  3072,  28133,  -9956,
  3210,  28119,  -9951,
  3348,  28077, -10022,
  3397,  28026, -10149,
  3457,  27972, -10276,
  3533,  27943, -10329,
  3462,  28022, -10139,
  3448,  28074,  -9999,
  3449,  28124,  -9855,
  3559,  28149,  -9746,
  3531,  28201,  -9605,
  3450,  28244,  -9506,
  3442,  28293,  -9362,
  3490,  28332,  -9226,
  3583,  28358,  -9110,
  3696,  28375,  -9010,
  3831,  28380,  -8938,
  3981,  28377,  -8882,
  4094,  28370,  -8853,
  4256,  28357,  -8820,
  4402,  28342,  -8795,
  4542,  28339,  -8733,
  4594,  28367,  -8613,
  4587,  28416,  -8457,
  4701,  28423,  -8370,
  4745,  28433,  -8310,
  4759,  28471,  -8170,
  4800,  28496,  -8059,
  4650,  28527,  -8038,
  4680,  28562,  -7894,
  4774,  28579,  -7774,
  4900,  28583,  -7680,
  5039,  28555,  -7696,
  5174,  28514,  -7758,
  5325,  28485,  -7762,
  5350,  28504,  -7674,
  5209,  28539,  -7643,
  5151,  28552,  -7634,
  5165,  28526,  -7720,
  5038,  28575,  -7622,
  5193,  28575,  -7518,
  5264,  28580,  -7448,
  5056,  28587,  -7565,
  5010,  28597,  -7558,
  5101,  28617,  -7417,
  5199,  28630,  -7302,
  5300,  28639,  -7192,
  5414,  28643,  -7090,
  5510,  28653,  -6973,
  5605,  28654,  -6894,
  5714,  28614,  -6970,
  5847,  28607,  -6889,
  5964,  28566,  -6957,
  5929,  28552,  -7046,
  6049,  28510,  -7112,
  6145,  28452,  -7260,
  6234,  28452,  -7186,
  6299,  28462,  -7087,
  6429,  28418,  -7148,
  6500,  28405,  -7133,
  6525,  28446,  -6945,
  6567,  28468,  -6816,
  6689,  28457,  -6744,
  6829,  28427,  -6728,
  6911,  28444,  -6573,
  6900,  28480,  -6426,
  6911,  28499,  -6330,
  7094,  28438,  -6400,
  7206,  28395,  -6466,
  7361,  28344,  -6513,
  7445,  28340,  -6436,
  7461,  28367,  -6298,
  7447,  28398,  -6173,
  7372,  28451,  -6018,
  7292,  28487,  -5944,
  7260,  28510,  -5870,
  7245,  28545,  -5716,
  7220,  28580,  -5575,
  7292,  28580,  -5476,
  7401,  28526,  -5609,
  7506,  28481,  -5703,
  7556,  28460,  -5737,
  7428,  28524,  -5584,
  7355,  28572,  -5437,
  7385,  28589,  -5302,
  7370,  28621,  -5153,
  7388,  28642,  -5005,
  7441,  28652,  -4869,
  7469,  28671,  -4711,
  7506,  28682,  -4582,
  7571,  28686,  -4446,
  7618,  28684,  -4379,
  7613,  28720,  -4147,
  7487,  28764,  -4071,
  7525,  28778,  -3895,
  7561,  28789,  -3748,
  7620,  28791,  -3607,
  7724,  28777,  -3496,
  7847,  28750,  -3448,
  7985,  28708,  -3480,
  8172,  28646,  -3555,
  8130,  28664,  -3501,
  7989,  28708,  -3472,
  7871,  28750,  -3391,
  7740,  28791,  -3339,
  7693,  28815,  -3240,
  7793,  28803,  -3113,
  7726,  28834,  -2988,
  7795,  28831,  -2834,
  7906,  28797,  -2863,
  7903,  28788,  -2962,
  8050,  28760,  -2841,
  8150,  28740,  -2760,
  8240,  28722,  -2675,
  8317,  28714,  -2515,
  8408,  28694,  -2440,
  8538,  28660,  -2383,
  8526,  28667,  -2353,
  8379,  28707,  -2392,
  8253,  28738,  -2447,
  8113,  28773,  -2506,
  8021,  28789,  -2615,
  7888,  28821,  -2667,
  7750,  28852,  -2740,
  7622,  28884,  -2765,
  7483,  28913,  -2834,
  7352,  28937,  -2927,
  7217,  28966,  -2983,
  7077,  28995,  -3034,
  6922,  29033,  -3025,
  6854,  29062,  -2905,
  6802,  29076,  -2879,
  6800,  29066,  -2984,
  6673,  29103,  -2912,
  6600,  29131,  -2793,
  6520,  29163,  -2651,
  6438,  29193,  -2511,
  6467,  29198,  -2375,
  6518,  29199,  -2226,
  6609,  29185,  -2131,
  6655,  29184,  -2007,
  6468,  29227,  -1984,
  6470,  29237,  -1826,
  6438,  29251,  -1714,
  6261,  29286,  -1770,
  6201,  29309,  -1584,
  6284,  29298,  -1453,
  6419,  29273,  -1376,
  6567,  29243,  -1315,
  6702,  29213,  -1302,
  6844,  29177,  -1359,
  6888,  29165,  -1403,
  6909,  29168,  -1219,
  6972,  29157,  -1127,
  7119,  29117,  -1234,
  7263,  29082,  -1219,
  7465,  29028,  -1284,
  7392,  29049,  -1230,
  7269,  29081,  -1204,
  7120,  29118,  -1198,
  7088,  29131,  -1068,
  7194,  29110,   -941,
  7245,  29101,   -811,
  7218,  29109,   -747,
  7159,  29126,   -656,
  7192,  29121,   -521,
  7269,  29103,   -426,
  7377,  29077,   -296,
  7432,  29064,   -161,
  7480,  29053,    -14,
  7546,  29035,    114,
  7649,  29008,    218,
  7734,  28984,    352,
  7881,  28943,    416,
  7900,  28937,    484,
  7915,  28932,    539,
  8044,  28898,    434,
  8070,  28890,    465,
  8095,  28882,    535,
  8231,  28846,    423,
  8360,  28809,    378,
  8463,  28777,    481,
  8543,  28752,    601,
  8675,  28714,    520,
  8696,  28707,    523,
  8553,  28748,    614,
  8435,  28785,    530,
  8331,  28816,    493,
  8368,  28801,    686,
  8369,  28797,    834,
  8381,  28789,    986,
  8364,  28788,   1139,
  8367,  28780,   1293,
  8422,  28759,   1407,
  8558,  28717,   1440,
  8696,  28677,   1410,
  8839,  28632,   1444,
  8969,  28594,   1393,
  9053,  28574,   1259,
  9194,  28531,   1213,
  9293,  28503,   1098,
  9432,  28459,   1068,
  9565,  28412,   1130,
  9691,  28369,   1134,
  9846,  28317,   1102,
  9987,  28267,   1111,
 10054,  28238,   1240,
  9837,  28316,   1192,
  9746,  28346,   1241,
  9893,  28290,   1338,
  9968,  28263,   1362,
  9760,  28337,   1316,
  9617,  28387,   1302,
  9509,  28427,   1216,
  9387,  28471,   1129,
  9318,  28490,   1224,
  9298,  28489,   1377,
  9154,  28531,   1472,
  9063,  28557,   1541,
  8958,  28584,   1651,
  8902,  28593,   1793,
  8933,  28574,   1934,
  9017,  28546,   1958,
  9123,  28512,   1968,
  9025,  28533,   2099,
  9055,  28514,   2233,
  9203,  28466,   2236,
  9320,  28435,   2147,
  9398,  28418,   2030,
  9520,  28382,   1956,
  9589,  28360,   1942,
  9451,  28391,   2157,
  9391,  28401,   2276,
  9313,  28417,   2398,
  9198,  28455,   2394,
  9047,  28505,   2376,
  8923,  28549,   2305,
  8799,  28592,   2251,
  8655,  28637,   2237,
  8591,  28651,   2304,
  8770,  28594,   2334,
  8895,  28550,   2401,
  8947,  28522,   2538,
  9010,  28491,   2664,
  9136,  28442,   2759,
  9280,  28398,   2732,
  9425,  28351,   2720,
  9569,  28305,   2694,
  9691,  28257,   2762,
  9798,  28211,   2857,
  9929,  28158,   2921,
 10065,  28109,   2932,
 10201,  28057,   2960,
 10290,  28029,   2912,
 10326,  28031,   2760,
 10310,  28051,   2612,
 10396,  28032,   2482,
 10500,  28002,   2380,
 10611,  27965,   2312,
 10751,  27912,   2311,
 10871,  27864,   2324,
 10975,  27814,   2431,
 11104,  27765,   2416,
 11177,  27746,   2283,
 11218,  27733,   2246,
 11179,  27734,   2425,
 11050,  27778,   2507,
 10914,  27835,   2467,
 10785,  27888,   2440,
 10659,  27935,   2450,
 10517,  27985,   2503,
 10454,  27998,   2615,
 10462,  27980,   2764,
 10507,  27949,   2907,
 10643,  27892,   2966,
 10785,  27839,   2946,
 10923,  27782,   2969,
 11025,  27732,   3062,
 11107,  27686,   3183,
 11233,  27627,   3249,
 11311,  27582,   3364,
 11354,  27547,   3504,
 11411,  27508,   3623,
 11485,  27462,   3731,
 11396,  27481,   3861,
 11350,  27479,   4008,
 11262,  27498,   4127,
 11149,  27529,   4226,
 11056,  27575,   4167,
 11128,  27567,   4030,
 11230,  27539,   3938,
 11241,  27557,   3777,
 11145,  27606,   3703,
 11061,  27657,   3569,
 10967,  27708,   3465,
 10888,  27754,   3341,
 10781,  27805,   3263,
 10649,  27861,   3217,
 10545,  27912,   3117,
 10402,  27959,   3175,
 10270,  28003,   3223,
 10132,  28057,   3184,
 10005,  28108,   3139,
  9867,  28162,   3085,
  9725,  28215,   3059,
  9604,  28262,   3001,
  9478,  28311,   2942,
  9339,  28361,   2906,
  9204,  28402,   2931,
  9058,  28447,   2955,
  8951,  28491,   2855,
  8836,  28535,   2769,
  8712,  28580,   2695,
  8564,  28629,   2655,
  8439,  28660,   2721,
  8356,  28674,   2829,
  8308,  28673,   2976,
  8266,  28672,   3099,
  8382,  28624,   3229,
  8509,  28577,   3305,
  8633,  28531,   3384,
  8745,  28486,   3477,
  8819,  28447,   3601,
  8860,  28416,   3747,
  8955,  28373,   3846,
  9075,  28332,   3863,
  9200,  28293,   3856,
  9323,  28243,   3926,
  9433,  28198,   3984,
  9544,  28145,   4092,
  9622,  28122,   4071,
  9744,  28098,   3943,
  9887,  28046,   3962,
 10033,  28000,   3914,
 10106,  27981,   3868,
 10234,  27920,   3969,
 10300,  27877,   4096,
 10140,  27925,   4171,
  9992,  27970,   4226,
  9872,  27999,   4314,
  9752,  28028,   4395,
  9630,  28053,   4502,
  9490,  28095,   4541,
  9368,  28121,   4629,
  9262,  28139,   4736,
  9175,  28146,   4860,
  9074,  28159,   4975,
  9054,  28143,   5097,
  9109,  28105,   5207,
  9257,  28054,   5225,
  9381,  28011,   5233,
  9463,  27955,   5382,
  9473,  27929,   5496,
  9535,  27888,   5600,
  9416,  27921,   5637,
  9303,  27976,   5547,
  9210,  28003,   5569,
  9214,  27971,   5718,
  9210,  27939,   5881,
  9150,  27931,   6012,
  9065,  27934,   6124,
  9030,  27913,   6271,
  9071,  27866,   6420,
  8994,  27864,   6533,
  8907,  27884,   6571,
  8817,  27940,   6451,
  8729,  27988,   6361,
  8721,  28005,   6297,
  8668,  27985,   6459,
  8658,  27954,   6606,
  8713,  27920,   6675,
  8699,  27905,   6756,
  8625,  27898,   6878,
  8581,  27876,   7022,
  8579,  27833,   7193,
  8565,  27804,   7321,
  8546,  27770,   7470,
  8505,  27745,   7608,
  8531,  27707,   7717,
  8616,  27649,   7828,
  8669,  27598,   7948,
  8599,  27579,   8091,
  8531,  27581,   8155,
  8372,  27625,   8172,
  8237,  27667,   8166,
  8126,  27714,   8118,
  8112,  27760,   7973,
  8189,  27778,   7832,
  8192,  27804,   7736,
  8064,  27853,   7692,
  7914,  27902,   7671,
  7773,  27926,   7728,
  7673,  27922,   7842,
  7583,  27919,   7938,
  7805,  27836,   8014,
  7867,  27792,   8105,
  7941,  27737,   8223,
  8031,  27668,   8365,
  8173,  27627,   8365,
  8290,  27566,   8447,
  8356,  27512,   8559,
  8420,  27453,   8686,
  8459,  27415,   8766,
  8345,  27439,   8801,
  8185,  27494,   8780,
  8069,  27501,   8865,
  8048,  27451,   9037,
  8018,  27413,   9178,
  7974,  27380,   9314,
  7956,  27336,   9457,
  7971,  27286,   9589,
  8096,  27228,   9650,
  8230,  27173,   9689,
  8317,  27108,   9797,
  8209,  27101,   9908,
  8038,  27131,   9965,
  7916,  27139,  10041,
  7755,  27191,  10025,
  7598,  27223,  10059,
  7584,  27169,  10215,
  7684,  27115,  10282,
  7834,  27059,  10317,
  7970,  27042,  10258,
  8091,  26966,  10362,
  8029,  26931,  10501,
  7886,  26949,  10563,
  7748,  26987,  10567,
  7608,  27034,  10549,
  7469,  27054,  10597,
  7335,  27118,  10528,
  7252,  27179,  10427,
  7144,  27236,  10352,
  7067,  27288,  10267,
  7032,  27354,  10115,
  6935,  27407,  10037,
  6782,  27452,  10020,
  6643,  27487,  10016,
  6521,  27530,   9978,
  6376,  27578,   9939,
  6245,  27628,   9884,
  6210,  27645,   9859,
  6347,  27623,   9833,
  6519,  27571,   9866,
  6639,  27555,   9830,
  6765,  27532,   9810,
  6928,  27501,   9782,
  7072,  27479,   9741,
  7209,  27467,   9675,
  7347,  27448,   9623,
  7488,  27425,   9582,
  7610,  27422,   9494,
  7699,  27439,   9371,
  7761,  27468,   9236,
  7788,  27507,   9093,
  7780,  27557,   8950,
  7744,  27611,   8813,
  7647,  27665,   8727,
  7529,  27723,   8647,
  7400,  27768,   8611,
  7276,  27803,   8606,
  7143,  27836,   8610,
  6979,  27870,   8636,
  6872,  27890,   8656,
  6684,  27944,   8629,
  6538,  27978,   8629,
  6388,  28012,   8632,
  6243,  28042,   8642,
  6116,  28050,   8705,
  5971,  28064,   8760,
  5886,  28053,   8852,
  5854,  28039,   8919,
  5748,  28084,   8846,
  5611,  28104,   8870,
  5569,  28130,   8813,
  5642,  28141,   8732,
  5474,  28163,   8769,
  5421,  28136,   8887,
  5263,  28151,   8935,
  5195,  28145,   8993,
  5107,  28161,   8994,
  5004,  28195,   8944,
  4936,  28213,   8925,
  5125,  28209,   8832,
  5188,  28243,   8686,
  5100,  28278,   8623,
  4969,  28303,   8615,
  4810,  28329,   8623,
  4749,  28302,   8744,
  4775,  28261,   8862,
  4790,  28233,   8943,
  4690,  28292,   8807,
  4651,  28335,   8690,
  4603,  28370,   8600,
  4511,  28357,   8692,
  4535,  28307,   8840,
  4488,  28285,   8933,
  4385,  28336,   8822,
  4355,  28282,   9009,
  4351,  28237,   9150,
  4308,  28227,   9202,
  4264,  28284,   9046,
  4261,  28339,   8874,
  4148,  28348,   8897,
  4102,  28319,   9012,
  4082,  28277,   9152,
  4031,  28234,   9307,
  4023,  28197,   9421,
  3881,  28224,   9400,
  3743,  28234,   9425,
  3746,  28213,   9488,
  3845,  28186,   9526,
  3846,  28162,   9597,
  3713,  28170,   9625,
  3662,  28136,   9744,
  3682,  28097,   9849,
  3633,  28083,   9906,
  3614,  28146,   9734,
  3551,  28164,   9704,
  3554,  28112,   9852,
  3527,  28106,   9881,
  3446,  28144,   9801,
  3445,  28097,   9933,
  3486,  28069,   9999,
  3386,  28081,   9999,
  3329,  28067,  10059,
  3251,  28017,  10220,
  3270,  27967,  10352,
  3160,  27936,  10470,
  3197,  27904,  10542,
  3318,  27891,  10539,
  3263,  27874,  10600,
  3144,  27869,  10651,
  3166,  27837,  10726,
  3158,  27807,  10807,
  3030,  27841,  10756,
  3017,  27807,  10848,
  2949,  27769,  10963,
  3053,  27744,  10998,
  3031,  27706,  11099,
  2934,  27698,  11145,
  2944,  27667,  11220,
  3040,  27652,  11231,
  2890,  27626,  11333,
  2801,  27585,  11455,
  2772,  27536,  11579,
  2767,  27477,  11721,
  2869,  27452,  11755,
  2727,  27417,  11868,
  2716,  27375,  11969,
  2699,  27314,  12110,
  2731,  27249,  12250,
  2666,  27200,  12371,
  2550,  27175,  12451,
  2538,  27153,  12500,
  2612,  27157,  12476,
  2580,  27092,  12625,
  2493,  27070,  12689,
  2386,  27051,  12750,
  2312,  26998,  12875,
  2282,  26944,  12992,
  2262,  26897,  13094,
  2365,  26857,  13157,
  2486,  26895,  13057,
  2497,  26940,  12962,
  2580,  26955,  12914,
  2575,  26903,  13023,
  2501,  26854,  13138,
  2376,  26817,  13237,
  2298,  26838,  13209,
  2193,  26862,  13177,
  2128,  26826,  13261,
  2011,  26772,  13387,
  1999,  26729,  13475,
  2002,  26709,  13514,
  1909,  26726,  13493,
  1949,  26690,  13560,
  1762,  26722,  13522,
  1694,  26687,  13599,
  1836,  26668,  13618,
  1880,  26662,  13625,
  1773,  26631,  13698,
  1603,  26636,  13709,
  1565,  26607,  13770,
  1703,  26572,  13821,
  1722,  26542,  13877,
  1583,  26572,  13836,
  1557,  26550,  13881,
  1478,  26532,  13924,
  1468,  26512,  13963,
  1349,  26517,  13965,
  1276,  26502,  14000,
  1327,  26468,  14060,
  1462,  26459,  14064,
  1550,  26446,  14079,
  1346,  26452,  14087,
  1288,  26398,  14194,
  1329,  26336,  14305,
  1317,  26276,  14416,
  1482,  26279,  14394,
  1623,  26288,  14364,
  1704,  26297,  14338,
  1825,  26302,  14313,
  1871,  26312,  14290,
  1806,  26241,  14427,
  1693,  26256,  14414,
  1528,  26262,  14422,
  1391,  26252,  14453,
  1320,  26213,  14530,
  1364,  26158,  14626,
  1420,  26106,  14713,
  1360,  26055,  14808,
  1436,  26047,  14816,
  1468,  26040,  14825,
  1526,  26010,  14871,
  1617,  26084,  14731,
  1750,  26098,  14691,
  1649,  26040,  14806,
  1533,  25966,  14947,
  1555,  25930,  15008,
  1591,  25921,  15020,
  1463,  25882,  15099,
  1418,  25820,  15210,
  1514,  25816,  15207,
  1603,  25840,  15157,
  1672,  25856,  15121,
  1645,  25788,  15240,
  1637,  25715,  15365,
  1689,  25701,  15382,
  1526,  25696,  15408,
  1515,  25616,  15541,
  1628,  25560,  15622,
  1792,  25519,  15670,
  1885,  25475,  15732,
  2005,  25448,  15760,
  2144,  25460,  15722,
  2258,  25492,  15654,
  2371,  25548,  15546,
  2462,  25623,  15408,
  2533,  25673,  15313,
  2618,  25721,  15217,
  2747,  25744,  15155,
  2763,  25823,  15018,
  2742,  25883,  14918,
  2787,  25922,  14842,
  2830,  25820,  15010,
  2930,  25760,  15095,
  3016,  25718,  15149,
  3038,  25627,  15298,
  3115,  25545,  15419,
  3217,  25506,  15463,
  3247,  25404,  15623,
  3299,  25336,  15723,
  3378,  25260,  15828,
  3459,  25185,  15929,
  3559,  25113,  16021,
  3666,  25031,  16124,
  3646,  24951,  16253,
  3689,  24874,  16361,
  3786,  24796,  16456,
  3817,  24705,  16586,
  3969,  24682,  16584,
  4108,  24697,  16529,
  4193,  24734,  16451,
  4147,  24818,  16335,
  4229,  24884,  16214,
  4322,  24918,  16138,
  4462,  24920,  16096,
  4582,  24927,  16052,
  4609,  25021,  15897,
  4642,  25092,  15775,
  4632,  25177,  15642,
  4615,  25259,  15513,
  4593,  25336,  15395,
  4557,  25411,  15282,
  4557,  25482,  15163,
  4515,  25560,  15043,
  4431,  25611,  14981,
  4413,  25619,  14973,
  4571,  25630,  14906,
  4663,  25674,  14802,
  4722,  25717,  14708,
  4831,  25767,  14584,
  4827,  25810,  14509,
  4661,  25786,  14607,
  4526,  25804,  14618,
  4382,  25834,  14608,
  4295,  25851,  14604,
  4462,  25863,  14532,
  4581,  25863,  14495,
  4583,  25894,  14440,
  4732,  25820,  14524,
  4813,  25849,  14446,
  4887,  25912,  14306,
  4857,  25975,  14203,
  4720,  26039,  14131,
  4602,  26095,  14066,
  4472,  26131,  14043,
  4356,  26173,  14001,
  4292,  26248,  13879,
  4251,  26322,  13751,
  4222,  26397,  13616,
  4232,  26446,  13517,
  4217,  26526,  13363,
  4177,  26595,  13239,
  4253,  26641,  13121,
  4246,  26698,  13008,
  4315,  26739,  12900,
  4386,  26786,  12778,
  4471,  26840,  12634,
  4564,  26876,  12523,
  4639,  26907,  12429,
  4687,  26968,  12278,
  4714,  27028,  12136,
  4721,  27082,  12013,
  4623,  27137,  11926,
  4634,  27199,  11780,
  4601,  27262,  11645,
  4650,  27307,  11519,
  4649,  27326,  11475,
  4692,  27337,  11430,
  4737,  27368,  11338,
  4873,  27360,  11300,
  5015,  27362,  11232,
  5136,  27355,  11194,
  5304,  27299,  11253,
  5373,  27236,  11372,
  5427,  27171,  11501,
  5325,  27142,  11617,
  5306,  27083,  11763,
  5274,  27029,  11901,
  5239,  26975,  12039,
  5189,  26925,  12170,
  5132,  26884,  12284,
  5098,  26829,  12419,
  5046,  26780,  12544,
  4985,  26750,  12633,
  4964,  26685,  12778,
  4988,  26619,  12906,
  5066,  26560,  12996,
  5124,  26484,  13127,
  5222,  26414,  13231,
  5261,  26356,  13329,
  5296,  26270,  13484,
  5325,  26203,  13603,
  5420,  26133,  13701,
  5546,  26101,  13711,
  5707,  26058,  13727,
  5825,  26030,  13729,
  5913,  25966,  13814,
  5924,  25940,  13857,
  6004,  25978,  13751,
  6160,  25987,  13664,
  6249,  26015,  13571,
  6350,  26036,  13483,
  6475,  26067,  13363,
  6562,  26093,  13269,
  6653,  26107,  13198,
  6796,  26113,  13112,
  6911,  26120,  13038,
  7047,  26132,  12941,
  7179,  26056,  13020,
  7319,  26027,  13001,
  7453,  26007,  12965,
  7515,  25962,  13020,
  7325,  25971,  13110,
  7250,  25933,  13226,
  7150,  25908,  13329,
  7137,  25841,  13465,
  7006,  25833,  13548,
  6861,  25849,  13593,
  6715,  25870,  13625,
  6578,  25876,  13680,
  6471,  25852,  13777,
  6354,  25843,  13848,
  6249,  25810,  13958,
  6151,  25769,  14075,
  6172,  25703,  14186,
  6245,  25635,  14278,
  6342,  25547,  14392,
  6500,  25522,  14366,
  6566,  25441,  14479,
  6601,  25362,  14601,
  6669,  25281,  14710,
  6685,  25207,  14831,
  6596,  25159,  14951,
  6453,  25188,  14964,
  6344,  25261,  14887,
  6210,  25322,  14840,
  6103,  25358,  14823,
  5979,  25321,  14937,
  5931,  25257,  15063,
  5947,  25177,  15191,
  5913,  25106,  15320,
  5944,  25013,  15461,
  5974,  24940,  15566,
  6035,  24857,  15676,
  6101,  24774,  15781,
  6175,  24687,  15887,
  6209,  24609,  15994,
  6182,  24549,  16098,
  6075,  24587,  16080,
  6122,  24674,  15928,
  6106,  24726,  15853,
  6072,  24607,  16051,
  5981,  24562,  16154,
  5895,  24526,  16239,
  5884,  24440,  16372,
  5797,  24388,  16481,
  5657,  24381,  16540,
  5535,  24438,  16497,
  5506,  24495,  16422,
  5288,  24516,  16461,
  5158,  24495,  16535,
  5046,  24455,  16628,
  4935,  24417,  16717,
  4872,  24361,  16817,
  4724,  24329,  16905,
  4595,  24304,  16977,
  4469,  24272,  17055,
  4337,  24257,  17110,
  4250,  24266,  17120,
  4440,  24208,  17154,
  4404,  24177,  17207,
  4264,  24218,  17185,
  4161,  24299,  17095,
  4028,  24337,  17074,
  3889,  24388,  17032,
  3795,  24384,  17059,
  3659,  24320,  17181,
  3531,  24282,  17261,
  3440,  24260,  17309,
  3332,  24297,  17279,
  3319,  24378,  17167,
  3120,  24391,  17185,
  3016,  24446,  17127,
  2926,  24514,  17044,
  2876,  24554,  16996,
  2851,  24643,  16871,
  2852,  24734,  16736,
  2894,  24798,  16634,
  2978,  24858,  16529,
  3038,  24926,  16416,
  3134,  24977,  16319,
  3039,  25022,  16269,
  2937,  25055,  16236,
  2891,  25163,  16077,
  2959,  25235,  15952,
  2926,  25319,  15824,
  2897,  25347,  15785,
  2765,  25303,  15878,
  2699,  25232,  16002,
  2579,  25199,  16074,
  2440,  25178,  16128,
  2369,  25100,  16260,
  2441,  25075,  16287,
  2532,  25160,  16142,
  2630,  25169,  16112,
  2720,  25159,  16113,
  2650,  25066,  16268,
  2632,  25049,  16297,
  2540,  25078,  16268,
  2431,  25036,  16348,
  2355,  24998,  16418,
  2368,  24944,  16497,
  2400,  24854,  16628,
  2405,  24756,  16773,
  2489,  24717,  16819,
  2561,  24618,  16953,
  2601,  24535,  17067,
  2676,  24459,  17164,
  2668,  24395,  17256,
  2687,  24347,  17321,
  2750,  24268,  17421,
  2887,  24210,  17480,
  2946,  24166,  17531,
  2736,  24224,  17484,
  2632,  24198,  17536,
  2607,  24115,  17654,
  2505,  24138,  17637,
  2376,  24177,  17602,
  2230,  24150,  17657,
  2234,  24070,  17766,
  2187,  24059,  17787,
  2060,  24098,  17750,
  1913,  24086,  17782,
  1773,  24058,  17835,
  1680,  23995,  17929,
  1553,  23941,  18012,
  1479,  23892,  18083,
  1461,  23801,  18204,
  1415,  23716,  18318,
  1325,  23638,  18426,
  1257,  23573,  18513,
  1273,  23528,  18570,
  1320,  23492,  18611,
  1203,  23471,  18646,
  1331,  23433,  18685,
  1101,  23437,  18694,
   966,  23396,  18753,
   838,  23347,  18820,
   695,  23320,  18859,
   556,  23279,  18915,
   524,  23186,  19030,
   530,  23088,  19149,
   495,  23028,  19221,
   372,  22964,  19301,
   228,  22935,  19338,
    93,  22888,  19394,
    81,  22798,  19500,
   -71,  22746,  19560,
  -220,  22761,  19542,
  -375,  22776,  19522,
  -461,  22860,  19422,
  -623,  22853,  19426,
  -571,  22739,  19561,
  -539,  22648,  19667,
  -530,  22534,  19797,
  -691,  22509,  19821,
  -824,  22513,  19811,
  -963,  22503,  19816,
 -1074,  22577,  19726,
 -1225,  22559,  19738,
 -1361,  22533,  19758,
 -1522,  22517,  19766,
 -1594,  22444,  19843,
 -1537,  22381,  19918,
 -1590,  22294,  20011,
 -1453,  22244,  20078,
 -1316,  22225,  20107,
 -1154,  22193,  20153,
 -1054,  22148,  20208,
  -935,  22129,  20235,
  -844,  22054,  20320,
  -711,  22017,  20365,
  -741,  21900,  20490,
  -674,  21806,  20593,
  -589,  21741,  20664,
  -443,  21680,  20731,
  -399,  21576,  20840,
  -408,  21482,  20937,
  -305,  21393,  21030,
  -253,  21294,  21131,
  -230,  21237,  21188,
  -345,  21379,  21043,
  -416,  21376,  21045,
  -438,  21267,  21155,
  -457,  21160,  21261,
  -443,  21082,  21339,
  -483,  20946,  21472,
  -511,  20839,  21575,
  -543,  20733,  21676,
  -617,  20634,  21768,
  -755,  20592,  21803,
  -901,  20592,  21798,
 -1044,  20625,  21761,
 -1186,  20609,  21769,
 -1337,  20643,  21727,
 -1476,  20640,  21721,
 -1648,  20618,  21730,
 -1793,  20627,  21709,
 -1938,  20651,  21674,
 -2076,  20674,  21640,
 -2224,  20697,  21603,
 -2383,  20684,  21599,
 -2530,  20680,  21585,
 -2678,  20675,  21573,
 -2819,  20725,  21506,
 -2947,  20740,  21475,
 -3086,  20698,  21496,
 -3148,  20619,  21563,
 -3359,  20574,  21573,
 -3482,  20518,  21608,
 -3514,  20430,  21686,
 -3437,  20341,  21781,
 -3384,  20265,  21860,
 -3386,  20172,  21946,
 -3431,  20046,  22054,
 -3433,  19944,  22146,
 -3431,  19829,  22249,
 -3409,  19721,  22348,
 -3436,  19606,  22446,
 -3444,  19552,  22491,
 -3527,  19366,  22639,
 -3573,  19268,  22715,
 -3639,  19160,  22796,
 -3722,  19058,  22868,
 -3786,  18974,  22927,
 -3830,  18855,  23018,
 -3811,  18762,  23097,
 -3685,  18815,  23075,
 -3624,  18854,  23052,
 -3746,  18723,  23139,
 -3699,  18660,  23197,
 -3590,  18650,  23223,
 -3628,  18498,  23338,
 -3629,  18377,  23433,
 -3648,  18263,  23519,
 -3697,  18146,  23602,
 -3679,  18079,  23657,
 -3510,  18094,  23671,
 -3357,  18069,  23711,
 -3224,  18075,  23725,
 -3082,  18129,  23703,
 -2925,  18142,  23713,
 -2841,  18123,  23738,
 -2720,  18037,  23818,
 -2650,  17970,  23876,
 -2620,  17835,  23980,
 -2541,  17721,  24073,
 -2414,  17657,  24133,
 -2286,  17690,  24121,
 -2194,  17791,  24056,
 -2054,  17841,  24031,
 -1916,  17880,  24014,
 -1793,  17936,  23981,
 -1642,  17947,  23984,
 -1491,  17939,  24000,
 -1343,  17950,  24000,
 -1191,  17937,  24018,
 -1057,  17973,  23997,
  -898,  17969,  24006,
  -792,  18064,  23939,
  -723,  18176,  23856,
  -609,  18254,  23800,
  -468,  18289,  23776,
  -335,  18326,  23750,
  -296,  18441,  23661,
  -238,  18560,  23569,
  -148,  18648,  23500,
   -17,  18713,  23448,
    44,  18799,  23379,
   -78,  18901,  23297,
  -121,  19012,  23206,
  -108,  19123,  23115,
   -35,  19225,  23031,
    52,  19318,  22952,
   145,  19409,  22875,
   226,  19509,  22789,
   303,  19569,  22737,
   391,  19690,  22631,
   525,  19732,  22591,
   672,  19765,  22559,
   816,  19797,  22525,
   926,  19873,  22455,
  1058,  19929,  22399,
  1182,  19988,  22340,
  1255,  20078,  22255,
  1255,  20189,  22155,
  1199,  20302,  22054,
  1176,  20414,  21952,
  1210,  20505,  21865,
  1330,  20578,  21789,
  1450,  20647,  21717,
  1553,  20669,  21688,
  1721,  20621,  21721,
  1835,  20629,  21704,
  1950,  20623,  21700,
  2078,  20550,  21757,
  2231,  20504,  21786,
  2372,  20498,  21776,
  2516,  20552,  21709,
  2598,  20632,  21623,
  2710,  20701,  21543,
  2831,  20751,  21480,
  2976,  20782,  21431,
  3075,  20851,  21350,
  3155,  20935,  21255,
  3276,  20992,  21180,
  3425,  20967,  21182,
  3559,  20916,  21210,
  3695,  20866,  21236,
  3825,  20806,  21271,
  3877,  20701,  21364,
  3947,  20602,  21447,
  4002,  20496,  21538,
  4071,  20421,  21597,
  4193,  20346,  21644,
  4295,  20247,  21717,
  4436,  20203,  21730,
  4552,  20113,  21789,
  4679,  20044,  21826,
  4784,  19956,  21883,
  4910,  19873,  21930,
  5045,  19815,  21952,
  5168,  19787,  21949,
  5315,  19772,  21927,
  5441,  19702,  21960,
  5546,  19614,  22012,
  5678,  19544,  22040,
  5833,  19520,  22021,
  5907,  19403,  22104,
  6020,  19323,  22145,
  6155,  19297,  22130,
  6262,  19218,  22169,
  6331,  19108,  22244,
  6413,  19002,  22311,
  6473,  18888,  22391,
  6499,  18784,  22471,
  6421,  18707,  22557,
  6398,  18593,  22658,
  6372,  18494,  22746,
  6487,  18438,  22759,
  6570,  18503,  22682,
  6638,  18596,  22586,
  6691,  18687,  22495,
  6690,  18799,  22402,
  6818,  18847,  22323,
  6867,  18912,  22253,
  6816,  19034,  22164,
  6688,  19112,  22136,
  6563,  19183,  22112,
  6571,  19300,  22008,
  6610,  19403,  21905,
  6696,  19479,  21811,
  6800,  19446,  21809,
  6964,  19401,  21797,
  7078,  19330,  21823,
  7167,  19237,  21877,
  7264,  19249,  21834,
  7254,  19367,  21732,
  7141,  19461,  21686,
  7018,  19539,  21655,
  6874,  19596,  21650,
  6741,  19661,  21633,
  6602,  19720,  21623,
  6459,  19762,  21627,
  6317,  19811,  21624,
  6176,  19890,  21593,
  6190,  20015,  21473,
  6018,  20042,  21497,
  5873,  20043,  21536,
  5731,  20084,  21536,
  5607,  20153,  21504,
  5480,  20230,  21464,
  5365,  20314,  21414,
  5285,  20415,  21337,
  5223,  20522,  21250,
  5147,  20626,  21168,
  5045,  20700,  21120,
  4908,  20765,  21089,
  4775,  20828,  21057,
  4649,  20897,  21017,
  4568,  20994,  20938,
  4530,  21103,  20837,
  4564,  21194,  20736,
  4475,  21311,  20635,
  4535,  21397,  20533,
  4663,  21427,  20473,
  4772,  21478,  20394,
  4916,  21475,  20363,
  4953,  21407,  20425,
  4965,  21303,  20531,
  5035,  21212,  20608,
  5140,  21176,  20620,
  5194,  21263,  20516,
  5276,  21322,  20434,
  5413,  21248,  20474,
  5469,  21149,  20563,
  5541,  21052,  20642,
  5664,  20975,  20688,
  5665,  20924,  20739,
  5783,  20802,  20829,
  5917,  20730,  20863,
  6024,  20657,  20904,
  6175,  20653,  20865,
  6328,  20604,  20866,
  6458,  20532,  20898,
  6594,  20458,  20928,
  6625,  20426,  20950,
  6503,  20447,  20968,
  6716,  20382,  20963,
  6855,  20327,  20972,
  6999,  20254,  20995,
  7102,  20219,  20994,
  7250,  20128,  21031,
  7362,  20042,  21074,
  7500,  19965,  21098,
  7490,  19869,  21193,
  7525,  19757,  21284,
  7547,  19647,  21378,
  7565,  19514,  21494,
  7598,  19423,  21565,
  7738,  19326,  21601,
  7852,  19245,  21633,
  7935,  19141,  21695,
  8023,  19053,  21740,
  8152,  18959,  21774,
  8287,  18893,  21780,
  8356,  18853,  21788,
  8333,  18774,  21866,
  8448,  18664,  21916,
  8537,  18626,  21913,
  8663,  18608,  21879,
  8822,  18625,  21801,
  8964,  18622,  21745,
  9094,  18593,  21717,
  9213,  18508,  21739,
  8985,  18532,  21814,
  8847,  18582,  21828,
  8728,  18574,  21883,
  8608,  18525,  21971,
  8566,  18415,  22079,
  8677,  18313,  22121,
  8799,  18210,  22158,
  8818,  18083,  22254,
  8938,  17994,  22278,
  9051,  18027,  22206,
  9153,  17918,  22253,
  9216,  17869,  22265,
  9305,  17945,  22167,
  9424,  17853,  22191,
  9461,  17866,  22165,
  9404,  17983,  22095,
  9324,  18104,  22030,
  9233,  18214,  21978,
  9258,  18272,  21919,
  9392,  18209,  21914,
  9439,  18281,  21834,
  9318,  18370,  21811,
  9297,  18443,  21758,
  9441,  18464,  21678,
  9569,  18394,  21682,
  9656,  18385,  21651,
  9605,  18531,  21548,
  9486,  18608,  21535,
  9350,  18673,  21538,
  9229,  18736,  21536,
  9078,  18791,  21552,
  9017,  18833,  21541,
  9080,  18916,  21441,
  9071,  19001,  21370,
  9156,  18963,  21368,
  9023,  19116,  21288,
  8922,  19219,  21237,
  8816,  19319,  21191,
  8789,  19444,  21087,
  8857,  19493,  21014,
  8991,  19400,  21043,
  9103,  19308,  21079,
  9178,  19291,  21063,
  9142,  19381,  20995,
  9276,  19302,  21009,
  9317,  19313,  20981,
  9250,  19409,  20922,
  9363,  19402,  20878,
  9194,  19518,  20845,
  9205,  19584,  20779,
  9330,  19607,  20701,
  9426,  19646,  20621,
  9551,  19651,  20558,
  9656,  19664,  20496,
  9805,  19629,  20458,
  9954,  19600,  20415,
 10070,  19524,  20430,
 10210,  19535,  20351,
 10238,  19494,  20375,
 10135,  19426,  20491,
 10170,  19354,  20543,
 10266,  19466,  20389,
 10364,  19523,  20284,
 10439,  19593,  20178,
 10495,  19675,  20069,
 10623,  19688,  19988,
 10750,  19700,  19909,
 10862,  19682,  19865,
 10957,  19744,  19752,
 10812,  19815,  19760,
 10671,  19867,  19785,
 10549,  19945,  19772,
 10477,  20050,  19704,
 10372,  20156,  19651,
 10254,  20242,  19624,
 10249,  20317,  19549,
 10292,  20394,  19447,
 10255,  20514,  19339,
 10294,  20603,  19224,
 10396,  20644,  19124,
 10363,  20766,  19010,
 10331,  20877,  18906,
 10301,  20977,  18811,
 10304,  21072,  18703,
 10326,  21156,  18596,
 10486,  21161,  18500,
 10473,  21269,  18383,
 10430,  21373,  18287,
 10392,  21468,  18198,
 10464,  21493,  18127,
 10546,  21593,  17959,
 10573,  21683,  17834,
 10584,  21771,  17720,
 10695,  21804,  17613,
 10771,  21835,  17528,
 10859,  21860,  17441,
 10800,  21950,  17365,
 10779,  21976,  17345,
 10877,  21864,  17426,
 10985,  21793,  17447,
 11054,  21777,  17423,
 10874,  21773,  17541,
 10851,  21759,  17572,
 10965,  21694,  17582,
 11123,  21627,  17566,
 11255,  21622,  17488,
 11380,  21632,  17394,
 11514,  21599,  17347,
 11561,  21533,  17398,
 11462,  21488,  17518,
 11382,  21433,  17637,
 11370,  21354,  17740,
 11552,  21297,  17692,
 11686,  21253,  17656,
 11764,  21151,  17726,
 11801,  21047,  17826,
 11949,  20988,  17797,
 12038,  21032,  17684,
 12078,  21111,  17563,
 12179,  21144,  17453,
 12258,  21185,  17348,
 12323,  21241,  17233,
 12467,  21218,  17158,
 12559,  21250,  17050,
 12517,  21358,  16945,
 12358,  21365,  17052,
 12268,  21332,  17160,
 12136,  21387,  17185,
 12018,  21477,  17156,
 11915,  21575,  17105,
 11887,  21665,  17010,
 11957,  21685,  16935,
 12037,  21774,  16763,
 12129,  21815,  16644,
 12213,  21834,  16557,
 12320,  21847,  16459,
 12405,  21908,  16315,
 12467,  21960,  16197,
 12592,  21967,  16090,
 12678,  21997,  15982,
 12750,  22011,  15904,
 12904,  22002,  15793,
 12900,  21940,  15882,
 12820,  21896,  16006,
 12779,  21839,  16117,
 12665,  21812,  16243,
 12652,  21773,  16306,
 12767,  21710,  16299,
 12912,  21641,  16277,
 12920,  21608,  16315,
 12871,  21566,  16409,
 12839,  21547,  16458,
 12835,  21412,  16637,
 12865,  21336,  16711,
 12746,  21325,  16817,
 12636,  21333,  16889,
 12662,  21258,  16963,
 12824,  21204,  16910,
 12944,  21118,  16925,
 13078,  21087,  16862,
 13205,  21023,  16843,
 13338,  20971,  16802,
 13470,  20926,  16753,
 13601,  20855,  16735,
 13732,  20779,  16724,
 13860,  20697,  16719,
 13990,  20622,  16703,
 14127,  20550,  16676,
 14252,  20500,  16632,
 14383,  20457,  16572,
 14508,  20382,  16556,
 14631,  20309,  16538,
 14725,  20200,  16587,
 14824,  20092,  16630,
 14896,  19979,  16702,
 14890,  19885,  16819,
 14853,  19811,  16939,
 14780,  19759,  17063,
 14710,  19705,  17185,
 14621,  19662,  17310,
 14499,  19676,  17397,
 14367,  19709,  17468,
 14255,  19701,  17569,
 14157,  19668,  17685,
 14051,  19654,  17784,
 13915,  19683,  17859,
 13800,  19714,  17914,
 13668,  19736,  17990,
 13542,  19799,  18017,
 13423,  19803,  18101,
 13309,  19828,  18158,
 13176,  19942,  18131,
 13068,  19938,  18212,
 12937,  19969,  18272,
 12826,  20070,  18239,
 12738,  20075,  18296,
 12626,  20055,  18395,
 12498,  20062,  18475,
 12368,  20069,  18555,
 12241,  20071,  18636,
 12140,  20032,  18745,
 12034,  19997,  18849,
 11952,  19945,  18956,
 11872,  19883,  19071,
 11787,  19827,  19183,
 11741,  19748,  19291,
 11629,  19713,  19394,
 11493,  19735,  19453,
 11363,  19748,  19516,
 11232,  19743,  19598,
 11096,  19761,  19657,
 10989,  19740,  19738,
 11054,  19641,  19800,
 11174,  19594,  19779,
 11260,  19572,  19752,
 11083,  19544,  19880,
 11046,  19467,  19975,
 10920,  19437,  20074,
 10788,  19440,  20142,
 10663,  19454,  20195,
 10523,  19428,  20294,
 10403,  19454,  20330,
 10282,  19429,  20416,
 10208,  19352,  20526,
 10156,  19262,  20636,
 10174,  19147,  20733,
 10237,  19073,  20770,
 10371,  19100,  20679,
 10458,  19065,  20667,
 10452,  18970,  20758,
 10572,  18843,  20813,
 10573,  18731,  20913,
 10607,  18645,  20973,
 10449,  18683,  21018,
 10491,  18567,  21100,
 10669,  18512,  21059,
 10813,  18448,  21042,
 10837,  18329,  21133,
 10927,  18219,  21182,
 11022,  18132,  21207,
 11018,  18054,  21276,
 11158,  18056,  21201,
 11286,  18067,  21124,
 11313,  18033,  21138,
 11247,  17973,  21225,
 11157,  17939,  21300,
 11341,  17930,  21210,
 11476,  17968,  21106,
 11627,  17916,  21067,
 11718,  17861,  21064,
 11827,  17756,  21091,
 11966,  17709,  21053,
 12077,  17719,  20981,
 12201,  17746,  20886,
 12257,  17801,  20806,
 12237,  17920,  20715,
 12279,  17994,  20626,
 12415,  17984,  20553,
 12548,  17947,  20505,
 12687,  17890,  20469,
 12820,  17831,  20438,
 12937,  17733,  20449,
 13067,  17664,  20427,
 13192,  17665,  20345,
 13302,  17690,  20252,
 13418,  17705,  20162,
 13509,  17757,  20055,
 13557,  17853,  19936,
 13618,  17934,  19822,
 13721,  17960,  19728,
 13854,  17905,  19685,
 13983,  17881,  19615,
 14025,  17938,  19533,
 14143,  17988,  19401,
 14201,  17874,  19464,
 14153,  17779,  19585,
 14234,  17656,  19638,
 14247,  17542,  19730,
 14287,  17429,  19802,
 14378,  17307,  19843,
 14414,  17187,  19921,
 14489,  17065,  19971,
 14485,  16966,  20058,
 14461,  16867,  20159,
 14473,  16745,  20252,
 14469,  16631,  20349,
 14460,  16517,  20447,
 14461,  16404,  20538,
 14463,  16279,  20635,
 14464,  16165,  20724,
 14484,  16040,  20807,
 14493,  15917,  20895,
 14487,  15800,  20988,
 14460,  15691,  21088,
 14408,  15597,  21193,
 14322,  15533,  21298,
 14208,  15507,  21393,
 14078,  15499,  21485,
 13981,  15495,  21551,
 13892,  15488,  21613,
 13737,  15510,  21696,
 13787,  15343,  21784,
 13821,  15232,  21839,

/* 1 */
2737, 1,
-14284,  23878, -11217,
-14366,  23773, -11334,
-14381,  23798, -11262,
-14441,  23767, -11252,
-14520,  23748, -11190,
-14511,  23858, -10965,
-14557,  23797, -11037,
-14711,  23712, -11015,
-14671,  23719, -11053,
-14617,  23683, -11201,
-14616,  23636, -11300,
-14738,  23517, -11390,
-14835,  23548, -11200,
-14810,  23527, -11277,
-14813,  23454, -11423,
-14904,  23423, -11368,
-14893,  23387, -11457,
-15052,  23290, -11445,
-15122,  23286, -11363,
-15216,  23288, -11232,
-15334,  23232, -11187,
-15377,  23283, -11020,
-15417,  23237, -11063,
-15383,  23183, -11222,
-15458,  23146, -11195,
-15517,  23165, -11073,
-15610,  23149, -10975,
-15550,  23248, -10849,
-15571,  23237, -10844,
-15664,  23121, -10957,
-15739,  23126, -10837,
-15757,  23102, -10865,
-15832,  23001, -10969,
-15940,  22926, -10968,
-16029,  22923, -10845,
-15974,  23008, -10744,
-16006,  22989, -10738,
-16129,  22884, -10780,
-16136,  22857, -10826,
-16179,  22810, -10861,
-16260,  22827, -10702,
-16376,  22767, -10653,
-16416,  22710, -10713,
-16521,  22644, -10691,
-16648,  22565, -10662,
-16753,  22470, -10697,
-16877,  22364, -10725,
-16975,  22290, -10724,
-17063,  22178, -10816,
-17155,  22072, -10887,
-17137,  21993, -11073,
-17108,  22051, -11002,
-17068,  22129, -10909,
-16988,  22222, -10844,
-16970,  22215, -10886,
-17015,  22101, -11047,
-16975,  22142, -11027,
-16945,  22222, -10912,
-16849,  22317, -10865,
-16754,  22343, -10959,
-16663,  22350, -11081,
-16562,  22369, -11195,
-16425,  22412, -11311,
-16477,  22329, -11398,
-16595,  22237, -11407,
-16712,  22144, -11417,
-16820,  22048, -11446,
-16963,  21931, -11458,
-17098,  21801, -11506,
-17148,  21722, -11581,
-17305,  21666, -11451,
-17258,  21650, -11551,
-17287,  21584, -11631,
-17380,  21479, -11689,
-17463,  21381, -11743,
-17547,  21269, -11820,
-17622,  21164, -11898,
-17713,  21049, -11966,
-17783,  20950, -12036,
-17864,  20841, -12104,
-17943,  20734, -12171,
-18015,  20615, -12268,
-18056,  20521, -12363,
-18121,  20409, -12453,
-18222,  20303, -12479,
-18309,  20191, -12534,
-18419,  20087, -12540,
-18517,  19979, -12569,
-18621,  19869, -12588,
-18696,  19752, -12663,
-18780,  19626, -12733,
-18805,  19550, -12813,
-18880,  19424, -12895,
-18995,  19329, -12868,
-19110,  19239, -12833,
-19213,  19128, -12845,
-19293,  19009, -12901,
-19390,  18892, -12926,
-19493,  18794, -12916,
-19608,  18703, -12873,
-19769,  18574, -12814,
-19827,  18497, -12835,
-19941,  18426, -12761,
-19948,  18482, -12669,
-20015,  18509, -12521,
-20105,  18502, -12387,
-20104,  18492, -12405,
-20020,  18492, -12539,
-19998,  18440, -12651,
-20129,  18305, -12639,
-20057,  18332, -12713,
-20113,  18231, -12771,
-20210,  18116, -12782,
-20320,  18044, -12708,
-20420,  17970, -12653,
-20462,  17866, -12733,
-20562,  17744, -12742,
-20675,  17651, -12688,
-20781,  17549, -12657,
-20884,  17462, -12607,
-20999,  17364, -12552,
-21099,  17266, -12520,
-21185,  17145, -12539,
-21276,  17020, -12557,
-21368,  16980, -12453,
-21452,  16964, -12329,
-21537,  16946, -12206,
-21651,  16865, -12116,
-21742,  16806, -12035,
-21822,  16792, -11910,
-21922,  16702, -11852,
-21997,  16662, -11769,
-22106,  16587, -11671,
-22206,  16508, -11591,
-22307,  16408, -11541,
-22395,  16286, -11542,
-22472,  16183, -11538,
-22576,  16048, -11523,
-22675,  15935, -11486,
-22779,  15817, -11443,
-22853,  15700, -11456,
-22951,  15594, -11405,
-23043,  15470, -11389,
-23136,  15368, -11337,
-23237,  15218, -11334,
-23311,  15138, -11289,
-23396,  15000, -11296,
-23484,  14883, -11269,
-23576,  14802, -11183,
-23666,  14735, -11082,
-23757,  14659, -10987,
-23851,  14557, -10920,
-23939,  14466, -10848,
-24027,  14372, -10778,
-24098,  14242, -10792,
-24159,  14105, -10836,
-24221,  13981, -10857,
-24199,  13977, -10911,
-24145,  13987, -11019,
-24062,  14004, -11177,
-24097,  13936, -11185,
-24187,  13851, -11098,
-24275,  13743, -11037,
-24358,  13679, -10936,
-24442,  13610, -10833,
-24537,  13526, -10723,
-24599,  13539, -10564,
-24680,  13441, -10500,
-24768,  13352, -10405,
-24847,  13290, -10296,
-24926,  13196, -10226,
-25041,  13014, -10177,
-25081,  12944, -10169,
-25137,  12812, -10199,
-25193,  12665, -10244,
-25251,  12580, -10206,
-25343,  12471, -10109,
-25432,  12374, -10004,
-25501,  12306,  -9913,
-25578,  12228,  -9811,
-25656,  12134,  -9724,
-25733,  12045,  -9629,
-25807,  11959,  -9538,
-25880,  11836,  -9494,
-25955,  11697,  -9463,
-25996,  11704,  -9340,
-25999,  11795,  -9216,
-25961,  11924,  -9156,
-25886,  12033,  -9226,
-25811,  12153,  -9280,
-25745,  12245,  -9341,
-25662,  12311,  -9481,
-25614,  12324,  -9595,
-25540,  12430,  -9654,
-25484,  12566,  -9626,
-25416,  12690,  -9644,
-25338,  12805,  -9697,
-25260,  12928,  -9737,
-25177,  13041,  -9802,
-25107,  13169,  -9810,
-25033,  13302,  -9820,
-24959,  13422,  -9842,
-24884,  13493,  -9936,
-24829,  13549,  -9998,
-24751,  13669, -10028,
-24667,  13769, -10097,
-24579,  13888, -10148,
-24494,  13974, -10235,
-24418,  14100, -10245,
-24335,  14233, -10258,
-24256,  14316, -10330,
-24160,  14444, -10376,
-24078,  14524, -10455,
-23986,  14645, -10498,
-23895,  14748, -10559,
-23804,  14836, -10641,
-23714,  14919, -10728,
-23620,  15021, -10792,
-23539,  15143, -10797,
-23465,  15273, -10776,
-23382,  15404, -10769,
-23296,  15517, -10794,
-23224,  15648, -10759,
-23121,  15818, -10733,
-23163,  15806, -10661,
-23253,  15741, -10560,
-23344,  15699, -10421,
-23389,  15703, -10312,
-23482,  15610, -10244,
-23570,  15561, -10114,
-23641,  15482, -10071,
-23707,  15356, -10108,
-23795,  15239, -10079,
-23882,  15125, -10045,
-23968,  14992, -10038,
-24055,  14878, -10001,
-24144,  14763,  -9956,
-24222,  14666,  -9911,
-24312,  14535,  -9882,
-24401,  14434,  -9810,
-24492,  14321,  -9750,
-24577,  14238,  -9657,
-24665,  14127,  -9596,
-24754,  14049,  -9479,
-24814,  14026,  -9356,
-24876,  13922,  -9347,
-24961,  13781,  -9330,
-25041,  13694,  -9242,
-25123,  13628,  -9116,
-25208,  13503,  -9069,
-25266,  13479,  -8942,
-25364,  13354,  -8852,
-25407,  13270,  -8855,
-25438,  13136,  -8964,
-25516,  12999,  -8941,
-25568,  12999,  -8791,
-25586,  12957,  -8803,
-25620,  12915,  -8764,
-25683,  12850,  -8674,
-25800,  12733,  -8500,
-25858,  12644,  -8454,
-25903,  12574,  -8421,
-26008,  12438,  -8299,
-26045,  12383,  -8266,
-26117,  12300,  -8164,
-26188,  12214,  -8061,
-26261,  12114,  -7976,
-26333,  12001,  -7909,
-26406,  11894,  -7827,
-26474,  11787,  -7759,
-26552,  11677,  -7658,
-26615,  11587,  -7575,
-26682,  11475,  -7511,
-26746,  11338,  -7490,
-26805,  11202,  -7484,
-26874,  11076,  -7424,
-26941,  10971,  -7337,
-26998,  10818,  -7355,
-27019,  10689,  -7463,
-27072,  10586,  -7417,
-27077,  10495,  -7531,
-27102,  10397,  -7573,
-27164,  10264,  -7533,
-27229,  10144,  -7462,
-27292,  10037,  -7375,
-27358,   9924,  -7286,
-27410,   9858,  -7177,
-27465,   9804,  -7039,
-27520,   9735,  -6920,
-27576,   9659,  -6804,
-27634,   9556,  -6714,
-27693,   9442,  -6628,
-27744,   9383,  -6497,
-27792,   9335,  -6363,
-27837,   9292,  -6226,
-27880,   9255,  -6087,
-27912,   9252,  -5945,
-27959,   9187,  -5821,
-28013,   9084,  -5722,
-28062,   9005,  -5607,
-28112,   8922,  -5489,
-28156,   8859,  -5360,
-28197,   8812,  -5223,
-28238,   8759,  -5087,
-28282,   8700,  -4944,
-28324,   8628,  -4828,
-28357,   8601,  -4682,
-28389,   8571,  -4537,
-28424,   8531,  -4395,
-28469,   8438,  -4279,
-28512,   8380,  -4107,
-28545,   8320,  -3994,
-28580,   8253,  -3878,
-28605,   8236,  -3728,
-28632,   8209,  -3582,
-28667,   8143,  -3448,
-28696,   8103,  -3299,
-28710,   8112,  -3151,
-28710,   8164,  -3012,
-28709,   8218,  -2870,
-28709,   8269,  -2725,
-28698,   8349,  -2597,
-28693,   8405,  -2463,
-28700,   8412,  -2359,
-28726,   8357,  -2236,
-28756,   8298,  -2064,
-28731,   8360,  -2154,
-28738,   8356,  -2069,
-28770,   8274,  -1952,
-28805,   8179,  -1832,
-28838,   8088,  -1716,
-28871,   7994,  -1604,
-28914,   7866,  -1446,
-28936,   7794,  -1392,
-28969,   7688,  -1291,
-29001,   7584,  -1187,
-29031,   7488,  -1076,
-29058,   7396,   -959,
-29082,   7315,   -835,
-29102,   7250,   -701,
-29114,   7217,   -555,
-29115,   7220,   -403,
-29121,   7206,   -254,
-29134,   7153,   -114,
-29150,   7090,     22,
-29167,   7019,    146,
-29171,   6999,    303,
-29179,   6955,    446,
-29195,   6869,    683,
-29193,   6872,    755,
-29197,   6840,    860,
-29192,   6838,   1035,
-29165,   6937,   1140,
-29162,   6925,   1279,
-29197,   6760,   1353,
-29205,   6746,   1245,
-29226,   6651,   1259,
-29242,   6561,   1356,
-29258,   6469,   1462,
-29271,   6377,   1590,
-29289,   6269,   1687,
-29310,   6147,   1772,
-29325,   6044,   1881,
-29336,   5952,   1998,
-29348,   5854,   2112,
-29373,   5705,   2164,
-29394,   5577,   2214,
-29417,   5466,   2178,
-29444,   5336,   2143,
-29463,   5196,   2217,
-29464,   5133,   2345,
-29469,   5036,   2488,
-29447,   5107,   2603,
-29430,   5265,   2479,
-29423,   5267,   2558,
-29426,   5186,   2685,
-29442,   5054,   2757,
-29449,   4964,   2847,
-29443,   4915,   2995,
-29441,   4843,   3129,
-29443,   4751,   3247,
-29460,   4611,   3298,
-29484,   4475,   3270,
-29480,   4390,   3418,
-29463,   4498,   3417,
-29453,   4494,   3509,
-29465,   4376,   3563,
-29472,   4247,   3655,
-29464,   4270,   3694,
-29440,   4332,   3808,
-29422,   4337,   3944,
-29411,   4292,   4068,
-29393,   4249,   4241,
-29396,   4145,   4325,
-29400,   4028,   4403,
-29370,   4056,   4577,
-29371,   3936,   4672,
-29381,   3793,   4728,
-29358,   3780,   4883,
-29327,   3854,   5009,
-29295,   3928,   5137,
-29289,   4069,   5059,
-29291,   4180,   4955,
-29273,   4307,   4955,
-29240,   4361,   5097,
-29201,   4461,   5232,
-29172,   4585,   5290,
-29140,   4665,   5395,
-29093,   4725,   5593,
-29089,   4666,   5662,
-29076,   4576,   5803,
-29071,   4435,   5934,
-29048,   4416,   6061,
-29032,   4300,   6219,
-29056,   4323,   6088,
-29095,   4194,   5990,
-29108,   4046,   6032,
-29108,   3925,   6109,
-29102,   3810,   6208,
-29091,   3703,   6323,
-29095,   3582,   6377,
-29085,   3471,   6484,
-29099,   3311,   6503,
-29114,   3182,   6500,
-29112,   3052,   6572,
-29143,   2916,   6496,
-29148,   2800,   6524,
-29160,   2645,   6536,
-29167,   2483,   6568,
-29181,   2342,   6557,
-29196,   2156,   6555,
-29185,   2058,   6633,
-29187,   1953,   6658,
-29213,   1818,   6579,
-29237,   1706,   6501,
-29267,   1556,   6406,
-29283,   1445,   6359,
-29306,   1352,   6273,
-29336,   1317,   6135,
-29369,   1278,   5984,
-29391,   1164,   5899,
-29395,    994,   5914,
-29431,    893,   5748,
-29425,    733,   5801,
-29442,    622,   5727,
-29469,    569,   5589,
-29502,    504,   5418,
-29523,    478,   5306,
-29547,    385,   5181,
-29546,    215,   5196,
-29550,     70,   5179,
-29564,    -54,   5095,
-29582,   -164,   4987,
-29578,   -315,   5002,
-29593,   -453,   4904,
-29614,   -533,   4767,
-29606,   -688,   4799,
-29604,   -838,   4783,
-29594,   -992,   4818,
-29600,  -1132,   4747,
-29593,  -1223,   4768,
-29569,  -1299,   4897,
-29541,  -1393,   5038,
-29519,  -1296,   5191,
-29506,  -1276,   5268,
-29511,  -1112,   5279,
-29508,  -1125,   5290,
-29498,  -1281,   5312,
-29492,  -1416,   5314,
-29493,  -1560,   5264,
-29499,  -1691,   5189,
-29519,  -1760,   5055,
-29533,  -1849,   4936,
-29548,  -1940,   4814,
-29556,  -2052,   4716,
-29564,  -2165,   4615,
-29568,  -2287,   4530,
-29558,  -2439,   4514,
-29532,  -2591,   4596,
-29520,  -2730,   4592,
-29494,  -2849,   4691,
-29474,  -2993,   4728,
-29483,  -3079,   4613,
-29464,  -3208,   4645,
-29435,  -3291,   4771,
-29405,  -3361,   4903,
-29375,  -3431,   5034,
-29344,  -3514,   5156,
-29314,  -3633,   5243,
-29284,  -3753,   5329,
-29255,  -3891,   5385,
-29225,  -4026,   5447,
-29193,  -4149,   5527,
-29158,  -4251,   5631,
-29126,  -4381,   5701,
-29092,  -4510,   5774,
-29061,  -4655,   5815,
-29028,  -4788,   5870,
-28993,  -4914,   5937,
-28958,  -5057,   5989,
-28924,  -5195,   6032,
-28890,  -5331,   6081,
-28851,  -5458,   6150,
-28811,  -5585,   6224,
-28772,  -5716,   6286,
-28737,  -5860,   6312,
-28691,  -5962,   6425,
-28648,  -6082,   6503,
-28609,  -6236,   6529,
-28567,  -6350,   6602,
-28520,  -6466,   6692,
-28476,  -6594,   6756,
-28431,  -6721,   6820,
-28385,  -6845,   6886,
-28338,  -6970,   6956,
-28306,  -7132,   6922,
-28291,  -7228,   6884,
-28243,  -7364,   6934,
-28193,  -7484,   7011,
-28142,  -7605,   7083,
-28090,  -7690,   7199,
-28037,  -7794,   7292,
-27982,  -7905,   7383,
-27932,  -7999,   7473,
-27878,  -8067,   7597,
-27824,  -8138,   7719,
-27770,  -8209,   7837,
-27716,  -8284,   7951,
-27657,  -8366,   8067,
-27604,  -8413,   8200,
-27549,  -8479,   8318,
-27489,  -8545,   8447,
-27432,  -8600,   8573,
-27374,  -8660,   8699,
-27312,  -8756,   8796,
-27250,  -8835,   8909,
-27188,  -8897,   9035,
-27127,  -8990,   9126,
-27071,  -9123,   9161,
-27003,  -9210,   9275,
-26938,  -9299,   9376,
-26870,  -9386,   9480,
-26802,  -9489,   9571,
-26755,  -9636,   9557,
-26702,  -9779,   9560,
-26649,  -9920,   9562,
-26591, -10059,   9577,
-26536, -10198,   9583,
-26487, -10341,   9566,
-26445, -10479,   9531,
-26395, -10626,   9508,
-26337, -10764,   9513,
-26276, -10903,   9523,
-26232, -11037,   9491,
-26188, -11177,   9446,
-26145, -11314,   9405,
-26096, -11455,   9368,
-26049, -11592,   9332,
-26013, -11729,   9260,
-26009, -11807,   9173,
-25947, -11945,   9169,
-25885, -12056,   9198,
-25842, -12187,   9147,
-25786, -12328,   9116,
-25733, -12465,   9080,
-25671, -12600,   9070,
-25601, -12732,   9083,
-25546, -12866,   9047,
-25522, -12976,   8957,
-25462, -13113,   8929,
-25396, -13251,   8915,
-25342, -13378,   8878,
-25291, -13512,   8821,
-25239, -13646,   8761,
-25195, -13763,   8705,
-25129, -13900,   8677,
-25095, -14015,   8593,
-25038, -14144,   8545,
-24979, -14276,   8499,
-24935, -14396,   8426,
-24895, -14519,   8334,
-24819, -14648,   8335,
-24735, -14773,   8363,
-24664, -14903,   8343,
-24607, -15026,   8289,
-24581, -15126,   8185,
-24531, -15244,   8114,
-24456, -15375,   8094,
-24378, -15504,   8084,
-24296, -15633,   8081,
-24212, -15763,   8081,
-24136, -15886,   8067,
-24055, -16016,   8054,
-23977, -16135,   8047,
-23914, -16256,   7992,
-23863, -16374,   7903,
-23787, -16499,   7872,
-23706, -16624,   7853,
-23663, -16732,   7753,
-23606, -16849,   7675,
-23532, -16970,   7631,
-23460, -17094,   7578,
-23396, -17212,   7509,
-23350, -17315,   7415,
-23299, -17424,   7318,
-23227, -17541,   7268,
-23172, -17651,   7176,
-23094, -17773,   7126,
-23029, -17895,   7030,
-22987, -17977,   6960,
-22900, -18107,   6908,
-22911, -18148,   6763,
-22840, -18258,   6707,
-22752, -18374,   6690,
-22652, -18486,   6720,
-22567, -18605,   6678,
-22457, -18742,   6666,
-22374, -18834,   6684,
-22269, -18952,   6703,
-22182, -19062,   6676,
-22109, -19173,   6602,
-22067, -19251,   6516,
-21997, -19361,   6426,
-21908, -19477,   6376,
-21830, -19588,   6305,
-21749, -19696,   6250,
-21642, -19812,   6255,
-21544, -19903,   6304,
-21497, -19950,   6314,
-21428, -19988,   6426,
-21461, -19918,   6536,
-21441, -19903,   6645,
-21401, -19896,   6791,
-21362, -19948,   6762,
-21341, -20022,   6610,
-21253, -20091,   6681,
-21151, -20196,   6690,
-21183, -20184,   6624,
-21130, -20250,   6591,
-21102, -20294,   6548,
-21008, -20406,   6501,
-20933, -20495,   6460,
-20863, -20601,   6352,
-20737, -20724,   6365,
-20687, -20792,   6307,
-20598, -20902,   6231,
-20470, -20993,   6349,
-20422, -21029,   6384,
-20348, -21125,   6300,
-20326, -21187,   6161,
-20288, -21253,   6059,
-20168, -21347,   6129,
-20187, -21353,   6046,
-20095, -21458,   5979,
-20034, -21535,   5908,
-19931, -21647,   5846,
-19935, -21626,   5908,
-19910, -21653,   5897,
-19836, -21756,   5763,
-19926, -21679,   5744,
-19977, -21666,   5614,
-19998, -21629,   5678,
-20078, -21549,   5703,
-20122, -21539,   5581,
-20078, -21610,   5468,
-20037, -21675,   5357,
-20007, -21732,   5239,
-19899, -21856,   5132,
-19925, -21826,   5160,
-19936, -21780,   5309,
-19903, -21806,   5327,
-19794, -21877,   5438,
-19762, -21875,   5561,
-19616, -21996,   5601,
-19585, -22056,   5474,
-19462, -22159,   5495,
-19481, -22166,   5401,
-19433, -22211,   5387,
-19381, -22225,   5518,
-19397, -22177,   5650,
-19362, -22202,   5674,
-19262, -22274,   5731,
-19260, -22280,   5713,
-19195, -22338,   5706,
-19238, -22327,   5605,
-19281, -22325,   5462,
-19325, -22307,   5381,
-19299, -22335,   5359,
-19173, -22419,   5457,
-19087, -22505,   5404,
-19028, -22572,   5333,
-18926, -22670,   5278,
-18793, -22783,   5270,
-18864, -22695,   5395,
-18791, -22757,   5383,
-18658, -22860,   5411,
-18685, -22848,   5372,
-18672, -22880,   5275,
-18578, -22951,   5301,
-18502, -23020,   5268,
-18530, -23024,   5150,
-18471, -23076,   5132,
-18365, -23140,   5221,
-18258, -23228,   5203,
-18284, -23175,   5351,
-18223, -23229,   5322,
-18173, -23298,   5190,
-18063, -23376,   5224,
-17941, -23467,   5235,
-17849, -23540,   5223,
-17719, -23631,   5254,
-17771, -23578,   5319,
-17705, -23625,   5326,
-17757, -23572,   5392,
-17734, -23565,   5494,
-17846, -23491,   5449,
-17808, -23504,   5518,
-17674, -23594,   5562,
-17585, -23672,   5517,
-17473, -23768,   5458,
-17504, -23742,   5468,
-17617, -23654,   5490,
-17605, -23676,   5430,
-17603, -23694,   5361,
-17662, -23683,   5213,
-17620, -23722,   5179,
-17485, -23828,   5149,
-17464, -23816,   5275,
-17437, -23833,   5285,
-17352, -23916,   5189,
-17259, -23979,   5209,
-17301, -23928,   5303,
-17395, -23843,   5375,
-17388, -23820,   5500,
-17312, -23828,   5704,
-17310, -23854,   5602,
-17305, -23896,   5433,
-17296, -23928,   5319,
-17181, -24020,   5281,
-17058, -24094,   5336,
-17136, -24017,   5433,
-17159, -23983,   5509,
-17166, -23947,   5645,
-17186, -23897,   5794,
-17104, -23950,   5816,
-17060, -24013,   5688,
-16974, -24102,   5567,
-17000, -24080,   5579,
-17049, -24062,   5509,
-17043, -24089,   5409,
-16911, -24168,   5470,
-16823, -24207,   5569,
-16754, -24222,   5708,
-16825, -24149,   5807,
-16941, -24059,   5844,
-17045, -23967,   5918,
-17144, -23877,   6001,
-17139, -23845,   6138,
-17138, -23807,   6286,
-17158, -23760,   6409,
-17172, -23715,   6534,
-17077, -23737,   6705,
-17189, -23653,   6714,
-17314, -23568,   6691,
-17424, -23518,   6580,
-17425, -23503,   6631,
-17473, -23448,   6702,
-17621, -23340,   6690,
-17676, -23295,   6703,
-17767, -23203,   6778,
-17845, -23116,   6871,
-17872, -23047,   7030,
-17974, -22982,   6984,
-18009, -22943,   7022,
-18003, -22936,   7060,
-17884, -23010,   7119,
-17877, -22971,   7264,
-17955, -22882,   7352,
-18076, -22766,   7414,
-18148, -22691,   7469,
-18205, -22608,   7579,
-18247, -22533,   7702,
-18261, -22474,   7839,
-18273, -22414,   7980,
-18299, -22343,   8121,
-18385, -22255,   8167,
-18420, -22206,   8221,
-18481, -22118,   8322,
-18587, -22016,   8354,
-18681, -21970,   8267,
-18752, -21959,   8135,
-18852, -21908,   8040,
-18964, -21834,   7976,
-19078, -21758,   7914,
-19191, -21659,   7910,
-19277, -21560,   7973,
-19336, -21469,   8075,
-19392, -21377,   8183,
-19425, -21300,   8305,
-19412, -21259,   8440,
-19399, -21209,   8594,
-19335, -21211,   8732,
-19406, -21125,   8782,
-19450, -21030,   8913,
-19521, -20931,   8990,
-19610, -20826,   9040,
-19713, -20717,   9066,
-19763, -20621,   9175,
-19797, -20537,   9291,
-19778, -20479,   9456,
-19832, -20436,   9436,
-19954, -20358,   9348,
-19967, -20278,   9493,
-19876, -20325,   9583,
-19774, -20405,   9624,
-19741, -20368,   9769,
-19817, -20259,   9843,
-19923, -20149,   9854,
-19990, -20156,   9702,
-19939, -20234,   9645,
-20020, -20207,   9533,
-20122, -20145,   9448,
-20228, -20056,   9412,
-20313, -19944,   9467,
-20410, -19836,   9486,
-20514, -19724,   9496,
-20586, -19605,   9584,
-20554, -19599,   9667,
-20455, -19646,   9779,
-20359, -19691,   9889,
-20261, -19741,   9989,
-20191, -19744,  10125,
-20134, -19731,  10262,
-20109, -19683,  10401,
-20119, -19586,  10565,
-20190, -19502,  10585,
-20296, -19383,  10602,
-20365, -19267,  10679,
-20387, -19192,  10772,
-20494, -19041,  10837,
-20574, -18970,  10809,
-20674, -18836,  10852,
-20601, -18855,  10960,
-20512, -18878,  11085,
-20441, -18876,  11220,
-20374, -18868,  11353,
-20313, -18850,  11492,
-20254, -18829,  11629,
-20194, -18808,  11768,
-20140, -18778,  11906,
-20084, -18751,  12043,
-20038, -18711,  12182,
-19989, -18673,  12320,
-19952, -18622,  12456,
-19925, -18561,  12590,
-19947, -18466,  12693,
-19985, -18359,  12788,
-19990, -18268,  12910,
-20013, -18165,  13019,
-20035, -18062,  13129,
-20083, -17950,  13208,
-20182, -17811,  13246,
-20268, -17772,  13167,
-20384, -17688,  13102,
-20478, -17572,  13109,
-20513, -17460,  13204,
-20568, -17352,  13262,
-20677, -17255,  13218,
-20786, -17182,  13143,
-20891, -17122,  13053,
-20998, -17060,  12964,
-21099, -16959,  12931,
-21140, -16864,  12989,
-21215, -16742,  13024,
-21304, -16620,  13035,
-21359, -16494,  13106,
-21387, -16386,  13196,
-21397, -16297,  13288,
-21484, -16159,  13316,
-21464, -16173,  13331,
-21378, -16298,  13317,
-21366, -16395,  13218,
-21334, -16504,  13133,
-21276, -16626,  13073,
-21192, -16748,  13054,
-21085, -16846,  13100,
-20977, -16941,  13152,
-20894, -16975,  13239,
-20817, -16970,  13366,
-20719, -17021,  13454,
-20613, -17087,  13533,
-20508, -17136,  13630,
-20419, -17160,  13733,
-20357, -17118,  13877,
-20259, -17138,  13994,
-20155, -17174,  14101,
-20087, -17151,  14224,
-20044, -17065,  14389,
-20002, -17034,  14483,
-19984, -16945,  14613,
-19994, -16839,  14720,
-20014, -16729,  14817,
-20010, -16634,  14930,
-19990, -16548,  15052,
-19971, -16460,  15173,
-19977, -16355,  15279,
-20003, -16237,  15370,
-20038, -16115,  15453,
-20052, -15980,  15574,
-20103, -15891,  15600,
-20148, -15744,  15690,
-20165, -15639,  15773,
-20133, -15561,  15891,
-20117, -15466,  16004,
-20131, -15337,  16110,
-20157, -15214,  16193,
-20218, -15092,  16231,
-20176, -15108,  16268,
-20042, -15155,  16390,
-19989, -15248,  16369,
-19962, -15367,  16290,
-19977, -15470,  16174,
-19979, -15562,  16083,
-19973, -15671,  15983,
-19996, -15744,  15884,
-20051, -15873,  15684,
-20012, -15848,  15759,
-19966, -15779,  15886,
-19935, -15695,  16008,
-19913, -15603,  16125,
-19899, -15504,  16238,
-19897, -15396,  16343,
-19898, -15285,  16445,
-19905, -15170,  16542,
-19929, -15047,  16626,
-19948, -14924,  16714,
-19956, -14807,  16809,
-19951, -14696,  16911,
-19938, -14590,  17018,
-19911, -14495,  17131,
-19868, -14413,  17249,
-19847, -14299,  17368,
-19843, -14200,  17453,
-19877, -14065,  17524,
-19932, -13934,  17566,
-19980, -13802,  17616,
-20013, -13683,  17671,
-20093, -13530,  17697,
-20150, -13398,  17733,
-20227, -13251,  17756,
-20253, -13099,  17839,
-20235, -12995,  17935,
-20318, -12911,  17902,
-20296, -12859,  17965,
-20230, -12836,  18055,
-20175, -12749,  18178,
-20183, -12672,  18222,
-20130, -12572,  18350,
-20063, -12509,  18466,
-20002, -12425,  18589,
-19970, -12328,  18688,
-19904, -12255,  18806,
-19821, -12179,  18942,
-19763, -12123,  19039,
-19669, -12095,  19153,
-19568, -12085,  19262,
-19517, -11986,  19376,
-19456, -11920,  19477,
-19355, -11887,  19598,
-19373, -11826,  19617,
-19361, -11729,  19687,
-19276, -11720,  19776,
-19134, -11723,  19911,
-19042, -11746,  19986,
-18933, -11720,  20104,
-18929, -11617,  20168,
-18876, -11657,  20194,
-18770, -11707,  20264,
-18664, -11694,  20369,
-18529, -11698,  20490,
-18493, -11609,  20573,
-18512, -11477,  20630,
-18455, -11381,  20734,
-18364, -11327,  20844,
-18275, -11271,  20952,
-18267, -11162,  21017,
-18318, -11020,  21047,
-18324, -10884,  21113,
-18309, -10755,  21192,
-18264, -10654,  21282,
-18210, -10553,  21379,
-18200, -10410,  21457,
-18174, -10288,  21537,
-18155, -10166,  21612,
-18094, -10067,  21708,
-18083,  -9933,  21779,
-18124,  -9790,  21810,
-18162,  -9646,  21842,
-18180,  -9505,  21889,
-18173,  -9368,  21954,
-18128,  -9250,  22041,
-18059,  -9151,  22140,
-18083,  -9012,  22176,
-18114,  -8866,  22210,
-18118,  -8726,  22262,
-18125,  -8582,  22312,
-18123,  -8441,  22368,
-18116,  -8302,  22425,
-18128,  -8159,  22468,
-18178,  -8014,  22480,
-18218,  -7869,  22499,
-18253,  -7715,  22523,
-18288,  -7578,  22542,
-18291,  -7431,  22588,
-18312,  -7278,  22621,
-18354,  -7149,  22628,
-18377,  -7020,  22650,
-18349,  -6881,  22715,
-18341,  -6673,  22783,
-18295,  -6590,  22844,
-18198,  -6701,  22889,
-18111,  -6681,  22965,
-18048,  -6569,  23046,
-18000,  -6447,  23118,
-17948,  -6326,  23192,
-17907,  -6196,  23258,
-17868,  -6022,  23334,
-17850,  -5895,  23380,
-17795,  -5784,  23450,
-17733,  -5691,  23520,
-17666,  -5580,  23596,
-17572,  -5500,  23685,
-17484,  -5418,  23768,
-17425,  -5300,  23838,
-17355,  -5191,  23913,
-17311,  -5048,  23976,
-17218,  -4963,  24060,
-17150,  -4850,  24132,
-17091,  -4727,  24198,
-17053,  -4592,  24251,
-17022,  -4453,  24298,
-16998,  -4311,  24341,
-16979,  -4169,  24379,
-16994,  -4003,  24396,
-16986,  -3892,  24420,
-17011,  -3706,  24431,
-17042,  -3588,  24428,
-17077,  -3439,  24424,
-17132,  -3274,  24408,
-17161,  -3151,  24404,
-17201,  -3006,  24395,
-17247,  -2862,  24379,
-17319,  -2732,  24343,
-17432,  -2668,  24269,
-17556,  -2649,  24182,
-17677,  -2666,  24092,
-17800,  -2665,  24001,
-17912,  -2620,  23923,
-18029,  -2573,  23839,
-18123,  -2476,  23779,
-18234,  -2412,  23700,
-18328,  -2314,  23638,
-18426,  -2219,  23570,
-18512,  -2106,  23513,
-18602,  -1986,  23452,
-18701,  -1917,  23379,
-18800,  -1829,  23307,
-18900,  -1746,  23233,
-19003,  -1670,  23153,
-19116,  -1597,  23066,
-19214,  -1524,  22989,
-19322,  -1482,  22901,
-19440,  -1470,  22802,
-19555,  -1493,  22702,
-19670,  -1510,  22602,
-19775,  -1537,  22507,
-19892,  -1510,  22406,
-20010,  -1451,  22305,
-20115,  -1470,  22208,
-20225,  -1428,  22112,
-20322,  -1359,  22026,
-20424,  -1297,  21936,
-20534,  -1251,  21836,
-20633,  -1298,  21739,
-20734,  -1333,  21641,
-20878,  -1442,  21495,
-20848,  -1316,  21532,
-20918,  -1311,  21464,
-20958,  -1408,  21420,
-20987,  -1556,  21381,
-21068,  -1678,  21292,
-21072,  -1642,  21290,
-21062,  -1501,  21311,
-21039,  -1352,  21343,
-20992,  -1213,  21397,
-21076,  -1214,  21315,
-21072,  -1156,  21323,
-21034,  -1020,  21366,
-21110,   -906,  21297,
-21190,   -805,  21221,
-21307,   -838,  21102,
-21370,   -735,  21042,
-21462,   -665,  20950,
-21542,   -630,  20870,
-21633,   -568,  20777,
-21713,   -546,  20694,
-21820,   -484,  20582,
-21911,   -420,  20487,
-22007,   -363,  20385,
-22099,   -360,  20285,
-22208,   -364,  20166,
-22311,   -392,  20052,
-22369,   -543,  19983,
-22409,   -653,  19935,
-22440,   -793,  19895,
-22511,   -796,  19815,
-22589,   -891,  19721,
-22663,   -980,  19633,
-22724,  -1087,  19556,
-22759,  -1227,  19507,
-22808,  -1369,  19440,
-22816,  -1324,  19434,
-22789,  -1178,  19475,
-22800,   -996,  19472,
-22908,  -1030,  19343,
-22993,   -972,  19246,
-23093,  -1039,  19122,
-23175,   -963,  19027,
-23210,   -842,  18989,
-23249,   -703,  18947,
-23267,   -565,  18929,
-23302,   -505,  18888,
-23377,   -605,  18792,
-23449,   -680,  18700,
-23538,   -753,  18584,
-23619,   -830,  18478,
-23709,   -845,  18363,
-23817,   -826,  18222,
-23802,   -785,  18244,
-23716,   -724,  18358,
-23626,   -697,  18474,
-23572,   -573,  18548,
-23543,   -438,  18588,
-23497,   -302,  18649,
-23443,   -194,  18719,
-23399,    -56,  18775,
-23320,     31,  18873,
-23239,    112,  18972,
-23173,    225,  19051,
-23119,    352,  19115,
-23053,    463,  19192,
-22979,    561,  19279,
-22941,    686,  19320,
-22951,    834,  19302,
-23022,    925,  19213,
-23117,    962,  19097,
-23196,   1097,  18993,
-23204,   1227,  18975,
-23233,   1358,  18931,
-23259,   1506,  18888,
-23286,   1652,  18843,
-23294,   1802,  18818,
-23306,   1972,  18787,
-23319,   2099,  18757,
-23395,   2241,  18645,
-23412,   2125,  18638,
-23441,   2146,  18598,
-23474,   2246,  18546,
-23536,   2350,  18454,
-23578,   2460,  18386,
-23652,   2538,  18280,
-23711,   2644,  18187,
-23775,   2743,  18089,
-23837,   2844,  17991,
-23922,   2884,  17873,
-24005,   2925,  17753,
-24083,   2995,  17636,
-24175,   2882,  17529,
-24162,   2957,  17535,
-24189,   3060,  17480,
-24274,   3092,  17356,
-24358,   3119,  17233,
-24450,   3128,  17100,
-24445,   3076,  17117,
-24457,   3062,  17102,
-24529,   3099,  16992,
-24613,   3122,  16866,
-24706,   3047,  16743,
-24768,   3049,  16650,
-24846,   3091,  16527,
-24925,   3113,  16402,
-25011,   3122,  16270,
-25084,   2950,  16189,
-25079,   3021,  16183,
-25068,   3168,  16172,
-25120,   3284,  16068,
-25169,   3346,  15979,
-25217,   3451,  15881,
-25271,   3547,  15772,
-25347,   3586,  15643,
-25435,   3422,  15535,
-25431,   3513,  15522,
-25391,   3656,  15554,
-25367,   3806,  15557,
-25397,   3945,  15473,
-25435,   4042,  15386,
-25479,   4146,  15285,
-25528,   4237,  15178,
-25603,   4314,  15030,
-25652,   4359,  14933,
-25698,   4455,  14825,
-25768,   4496,  14690,
-25840,   4464,  14572,
-25918,   4471,  14432,
-25980,   4415,  14337,
-26073,   4452,  14156,
-26025,   4486,  14233,
-25970,   4576,  14304,
-25919,   4737,  14345,
-25859,   4837,  14419,
-25864,   4952,  14372,
-25922,   4999,  14250,
-25983,   5110,  14098,
-26051,   5073,  13986,
-26126,   5140,  13821,
-26169,   5134,  13742,
-26193,   5264,  13645,
-26277,   5247,  13490,
-26238,   5290,  13550,
-26270,   5416,  13438,
-26224,   5494,  13496,
-26155,   5489,  13631,
-26042,   5553,  13820,
-26087,   5570,  13727,
-26156,   5587,  13589,
-26225,   5582,  13458,
-26297,   5574,  13319,
-26366,   5552,  13192,
-26439,   5549,  13046,
-26535,   5524,  12859,
-26480,   5478,  12992,
-26525,   5444,  12915,
-26603,   5396,  12773,
-26662,   5331,  12677,
-26720,   5275,  12579,
-26795,   5246,  12431,
-26850,   5280,  12297,
-26915,   5334,  12129,
-26947,   5374,  12041,
-26966,   5491,  11945,
-27013,   5532,  11819,
-27075,   5530,  11678,
-27136,   5521,  11540,
-27198,   5494,  11405,
-27259,   5478,  11266,
-27322,   5456,  11124,
-27374,   5474,  10985,
-27383,   5600,  10899,
-27369,   5707,  10880,
-27376,   5838,  10792,
-27410,   5920,  10660,
-27455,   5960,  10522,
-27502,   5985,  10383,
-27557,   5986,  10237,
-27562,   6109,  10149,
-27546,   6254,  10106,
-27571,   6316,   9996,
-27625,   6212,   9913,
-27639,   6078,   9956,
-27587,   6029,  10129,
-27634,   5977,  10031,
-27681,   5912,   9941,
-27738,   5860,   9810,
-27795,   5830,   9668,
-27851,   5766,   9545,
-27915,   5698,   9397,
-27956,   5583,   9342,
-27973,   5435,   9378,
-27971,   5307,   9459,
-27965,   5179,   9548,
-27972,   5043,   9599,
-28002,   4886,   9592,
-28051,   4770,   9506,
-28105,   4721,   9373,
-28124,   4806,   9272,
-28125,   4916,   9208,
-28132,   4994,   9145,
-28120,   5147,   9098,
-28074,   5279,   9166,
-28024,   5398,   9247,
-27981,   5522,   9305,
-27965,   5689,   9253,
-27959,   5783,   9211,
-27961,   5906,   9126,
-27930,   6036,   9138,
-27873,   6082,   9281,
-27819,   6150,   9395,
-27764,   6273,   9476,
-27759,   6407,   9401,
-27806,   6455,   9228,
-27861,   6381,   9115,
-27906,   6336,   9004,
-27956,   6197,   8947,
-28010,   6124,   8828,
-28063,   6067,   8697,
-28116,   5981,   8584,
-28169,   5893,   8473,
-28216,   5864,   8334,
-28257,   5873,   8188,
-28295,   5886,   8045,
-28337,   5756,   7993,
-28393,   5623,   7887,
-28377,   5690,   7896,
-28374,   5722,   7886,
-28405,   5768,   7738,
-28447,   5713,   7624,
-28497,   5609,   7512,
-28549,   5496,   7399,
-28590,   5353,   7347,
-28609,   5239,   7355,
-28644,   5080,   7328,
-28676,   4929,   7306,
-28713,   4898,   7182,
-28753,   4802,   7084,
-28793,   4675,   7006,
-28836,   4582,   6893,
-28885,   4479,   6754,
-28897,   4338,   6793,
-28919,   4179,   6801,
-28928,   4217,   6736,
-28930,   4327,   6659,
-28939,   4438,   6546,
-28948,   4537,   6435,
-28958,   4629,   6325,
-28963,   4742,   6219,
-28976,   4823,   6092,
-28996,   4878,   5951,
-29019,   4913,   5810,
-29046,   4939,   5653,
-29064,   4974,   5526,
-29091,   4992,   5366,
-29129,   4903,   5243,
-29158,   4842,   5137,
-29194,   4774,   4994,
-29225,   4728,   4854,
-29258,   4649,   4730,
-29288,   4593,   4594,
-29313,   4582,   4444,
-29324,   4711,   4235,
-29342,   4664,   4160,
-29352,   4727,   4018,
-29343,   4827,   3961,
-29334,   4951,   3872,
-29337,   5035,   3743,
-29333,   5133,   3636,
-29327,   5236,   3538,
-29318,   5354,   3433,
-29305,   5478,   3350,
-29287,   5611,   3287,
-29274,   5724,   3207,
-29251,   5870,   3148,
-29219,   6000,   3206,
-29190,   6134,   3208,
-29162,   6269,   3204,
-29132,   6394,   3230,
-29092,   6571,   3241,
-29106,   6497,   3263,
-29103,   6489,   3306,
-29066,   6653,   3303,
-29034,   6798,   3286,
-29001,   6945,   3276,
-28963,   7088,   3299,
-28924,   7230,   3336,
-28884,   7352,   3414,
-28847,   7488,   3432,
-28816,   7636,   3367,
-28795,   7703,   3395,
-28768,   7802,   3400,
-28758,   7901,   3245,
-28770,   7916,   3099,
-28758,   7992,   3021,
-28734,   8088,   2993,
-28725,   8183,   2814,
-28734,   8182,   2721,
-28729,   8248,   2575,
-28746,   8231,   2433,
-28762,   8219,   2282,
-28762,   8257,   2143,
-28773,   8247,   2017,
-28805,   8174,   1861,
-28816,   8165,   1715,
-28828,   8154,   1565,
-28831,   8173,   1414,
-28833,   8193,   1249,
-28833,   8212,   1102,
-28858,   8141,    977,
-28856,   8161,    846,
-28853,   8185,    713,
-28838,   8247,    574,
-28796,   8387,    674,
-28753,   8520,    803,
-28731,   8592,    843,
-28688,   8730,    877,
-28646,   8870,    857,
-28598,   9021,    879,
-28555,   9157,    887,
-28509,   9293,    934,
-28465,   9430,    910,
-28451,   9480,    834,
-28396,   9635,    919,
-28418,   9565,    974,
-28460,   9430,   1047,
-28451,   9453,   1096,
-28402,   9593,   1133,
-28352,   9734,   1179,
-28296,   9894,   1198,
-28246,  10034,   1207,
-28196,  10174,   1224,
-28166,  10251,   1251,
-28115,  10388,   1280,
-28068,  10504,   1363,
-28025,  10604,   1468,
-27975,  10725,   1545,
-27924,  10853,   1564,
-27878,  10979,   1506,
-27872,  11015,   1346,
-27890,  10981,   1242,
-27886,  11008,   1099,
-27880,  11039,    920,
-27889,  11026,    798,
-27907,  10989,    654,
-27928,  10944,    513,
-27940,  10920,    365,
-27948,  10902,    215,
-27960,  10874,     68,
-27982,  10816,    -69,
-28025,  10703,   -182,
-28068,  10589,   -223,
-28121,  10447,   -236,
-28175,  10302,   -238,
-28218,  10183,   -289,
-28261,  10059,   -350,
-28309,   9922,   -389,
-28341,   9824,   -502,
-28374,   9719,   -666,
-28410,   9617,   -642,
-28442,   9514,   -737,
-28438,   9512,   -910,
-28413,   9579,   -979,
-28396,   9610,  -1134,
-28409,   9552,  -1307,
-28416,   9515,  -1414,
-28422,   9474,  -1558,
-28412,   9462,  -1801,
-28421,   9421,  -1867,
-28421,   9394,  -1998,
-28423,   9355,  -2144,
-28404,   9383,  -2278,
-28357,   9501,  -2372,
-28323,   9569,  -2500,
-28293,   9622,  -2632,
-28274,   9631,  -2794,
-28249,   9673,  -2898,
-28192,   9812,  -2984,
-28145,   9918,  -3077,
-28094,  10046,  -3131,
-28039,  10186,  -3172,
-27987,  10303,  -3254,
-27936,  10411,  -3345,
-27885,  10517,  -3440,
-27831,  10636,  -3513,
-27774,  10764,  -3568,
-27716,  10895,  -3620,
-27662,  11012,  -3680,
-27578,  11200,  -3740,
-27602,  11156,  -3697,
-27686,  10977,  -3604,
-27654,  11061,  -3592,
-27599,  11166,  -3689,
-27540,  11292,  -3750,
-27479,  11430,  -3772,
-27423,  11562,  -3779,
-27375,  11692,  -3726,
-27309,  11846,  -3723,
-27235,  12022,  -3703,
-27194,  12116,  -3700,
-27132,  12263,  -3673,
-27073,  12401,  -3646,
-27016,  12536,  -3606,
-26959,  12670,  -3562,
-26907,  12797,  -3499,
-26859,  12919,  -3421,
-26802,  13050,  -3369,
-26740,  13172,  -3386,
-26669,  13300,  -3447,
-26608,  13415,  -3477,
-26532,  13557,  -3505,
-26475,  13676,  -3472,
-26415,  13768,  -3561,
-26419,  13777,  -3498,
-26393,  13850,  -3403,
-26323,  13981,  -3411,
-26309,  14018,  -3369,
-26271,  14110,  -3278,
-26249,  14170,  -3190,
-26211,  14270,  -3059,
-26161,  14377,  -2980,
-26183,  14367,  -2833,
-26190,  14380,  -2706,
-26174,  14425,  -2621,
-26155,  14482,  -2483,
-26109,  14586,  -2364,
-26057,  14696,  -2250,
-25990,  14810,  -2271,
-25959,  14874,  -2209,
-26004,  14809,  -2122,
-26033,  14757,  -2123,
-26040,  14746,  -2114,
-26017,  14805,  -1975,
-26002,  14851,  -1819,
-25955,  14941,  -1769,
-25974,  14912,  -1720,
-25993,  14898,  -1553,
-26008,  14887,  -1405,
-26044,  14836,  -1268,
-26070,  14802,  -1124,
-26052,  14844,   -973,
-26023,  14902,   -864,
-26058,  14846,   -737,
-26093,  14792,   -614,
-26140,  14710,   -555,
-26177,  14646,   -517,
-26198,  14612,   -379,
-26171,  14664,   -247,
-26190,  14631,   -109,
-26131,  14738,    -43,
-26135,  14730,     79,
-26171,  14665,    200,
-26221,  14573,    317,
-26192,  14621,    420,
-26144,  14710,    308,
-26107,  14777,    174,
-26057,  14865,    200,
-26000,  14963,    277,
-25981,  14998,    219,
-25966,  15025,    119,
-25959,  15037,     15,
-25954,  15046,   -153,
-25892,  15153,   -106,
-25909,  15124,     34,
-25933,  15082,    176,
-25897,  15141,    309,
-25872,  15180,    469,
-25877,  15166,    598,
-25874,  15165,    749,
-25819,  15251,    884,
-25878,  15147,    958,
-25900,  15107,    996,
-25864,  15158,   1143,
-25833,  15202,   1259,
-25824,  15210,   1336,
-25828,  15189,   1482,
-25813,  15197,   1658,
-25841,  15137,   1767,
-25860,  15080,   1968,
-25900,  15002,   2027,
-25956,  14894,   2113,
-25947,  14883,   2286,
-25916,  14918,   2407,
-25865,  14985,   2538,
-25822,  15040,   2655,
-25834,  14992,   2804,
-25873,  14902,   2916,
-25922,  14799,   3010,
-25968,  14696,   3115,
-25997,  14617,   3239,
-26039,  14521,   3335,
-26097,  14408,   3368,
-26180,  14260,   3356,
-26251,  14137,   3325,
-26322,  14004,   3323,
-26308,  14016,   3381,
-26296,  14017,   3472,
-26382,  13868,   3413,
-26429,  13770,   3450,
-26488,  13638,   3522,
-26502,  13577,   3647,
-26551,  13454,   3751,
-26590,  13368,   3779,
-26651,  13228,   3839,
-26693,  13121,   3916,
-26708,  13047,   4060,
-26752,  12931,   4139,
-26802,  12802,   4214,
-26812,  12749,   4308,
-26774,  12775,   4466,
-26730,  12842,   4539,
-26661,  12975,   4565,
-26597,  13086,   4623,
-26525,  13228,   4630,
-26453,  13369,   4638,
-26387,  13501,   4634,
-26329,  13626,   4592,
-26286,  13735,   4517,
-26220,  13880,   4457,
-26164,  14005,   4393,
-26111,  14126,   4322,
-26055,  14250,   4254,
-25989,  14385,   4203,
-25982,  14385,   4243,
-26028,  14283,   4307,
-26094,  14155,   4331,
-26120,  14099,   4354,
-26022,  14289,   4322,
-25964,  14411,   4265,
-25913,  14529,   4176,
-25861,  14643,   4098,
-25802,  14765,   4030,
-25740,  14890,   3968,
-25675,  15014,   3921,
-25606,  15143,   3878,
-25538,  15268,   3834,
-25446,  15426,   3809,
-25386,  15518,   3838,
-25309,  15637,   3868,
-25233,  15749,   3910,
-25160,  15848,   3977,
-25077,  15958,   4063,
-25005,  16072,   4052,
-25001,  16067,   4097,
-24977,  16088,   4165,
-24927,  16137,   4270,
-24849,  16220,   4407,
-24791,  16279,   4515,
-24721,  16358,   4614,
-24640,  16459,   4687,
-24559,  16561,   4750,
-24478,  16656,   4835,
-24408,  16724,   4959,
-24371,  16735,   5099,
-24308,  16795,   5198,
-24227,  16895,   5254,
-24136,  16992,   5361,
-24075,  17060,   5417,
-24027,  17085,   5551,
-23932,  17154,   5744,
-23928,  17213,   5583,
-23905,  17222,   5652,
-23833,  17311,   5687,
-23807,  17396,   5532,
-23797,  17405,   5547,
-23767,  17396,   5701,
-23749,  17371,   5851,
-23665,  17450,   5955,
-23578,  17559,   5980,
-23611,  17544,   5892,
-23597,  17575,   5856,
-23592,  17616,   5753,
-23591,  17656,   5632,
-23586,  17679,   5581,
-23523,  17707,   5755,
-23483,  17718,   5884,
-23441,  17772,   5887,
-23381,  17866,   5841,
-23373,  17864,   5880,
-23448,  17747,   5938,
-23529,  17609,   6026,
-23509,  17638,   6018,
-23443,  17751,   5942,
-23368,  17869,   5887,
-23294,  17990,   5812,
-23313,  18014,   5657,
-23284,  18090,   5532,
-23266,  18169,   5345,
-23253,  18165,   5415,
-23262,  18094,   5611,
-23197,  18206,   5519,
-23184,  18197,   5600,
-23125,  18261,   5636,
-23093,  18337,   5522,
-23018,  18483,   5342,
-23042,  18431,   5419,
-23078,  18343,   5562,
-23011,  18412,   5610,
-22968,  18502,   5487,
-22954,  18565,   5333,
-22933,  18629,   5200,
-22815,  18768,   5220,
-22889,  18676,   5225,
-22920,  18602,   5352,
-22935,  18531,   5527,
-22854,  18648,   5470,
-22798,  18717,   5471,
-22692,  18852,   5446,
-22624,  18937,   5435,
-22551,  19013,   5474,
-22457,  19086,   5605,
-22495,  19037,   5618,
-22599,  18931,   5561,
-22690,  18823,   5554,
-22737,  18749,   5614,
-22797,  18681,   5594,
-22839,  18600,   5693,
-22867,  18544,   5763,
-22929,  18449,   5820,
-23015,  18344,   5812,
-23146,  18184,   5796,
-23082,  18246,   5859,
-23004,  18325,   5918,
-22904,  18437,   5955,
-22804,  18545,   6006,
-22707,  18650,   6049,
-22635,  18749,   6013,
-22561,  18869,   5913,
-22484,  18982,   5846,
-22408,  19095,   5768,
-22318,  19188,   5806,
-22263,  19234,   5867,
-22411,  19083,   5793,
-22458,  18990,   5916,
-22488,  18905,   6073,
-22389,  18990,   6171,
-22304,  19070,   6232,
-22151,  19225,   6302,
-22111,  19265,   6322,
-22014,  19377,   6319,
-21956,  19463,   6253,
-21883,  19554,   6226,
-21724,  19720,   6259,
-21805,  19624,   6278,
-21786,  19630,   6328,
-21696,  19699,   6420,
-21613,  19749,   6545,
-21543,  19787,   6662,
-21483,  19799,   6816,
-21431,  19810,   6949,
-21371,  19822,   7096,
-21240,  19941,   7156,
-21223,  19920,   7263,
-21161,  19933,   7409,
-21118,  19926,   7547,
-21027,  19996,   7619,
-20987,  20038,   7618,
-21079,  19985,   7502,
-21024,  20085,   7389,
-20967,  20195,   7250,
-20852,  20301,   7285,
-20787,  20383,   7239,
-20672,  20498,   7247,
-20551,  20602,   7296,
-20447,  20690,   7337,
-20337,  20768,   7421,
-20289,  20802,   7459,
-20261,  20810,   7514,
-20186,  20840,   7630,
-20094,  20905,   7694,
-19973,  21013,   7715,
-19976,  20983,   7789,
-19914,  21009,   7877,
-19860,  21012,   8005,
-19780,  21051,   8099,
-19695,  21088,   8209,
-19586,  21162,   8280,
-19506,  21256,   8228,
-19478,  21265,   8272,
-19438,  21249,   8403,
-19312,  21313,   8532,
-19282,  21305,   8620,
-19189,  21343,   8733,
-19084,  21399,   8827,
-18977,  21451,   8930,
-18856,  21558,   8928,
-18864,  21523,   8997,
-18868,  21494,   9057,
-19046,  21372,   8971,
-19014,  21357,   9074,
-18948,  21358,   9210,
-18876,  21349,   9377,
-18914,  21327,   9351,
-19044,  21258,   9244,
-19051,  21295,   9143,
-19118,  21281,   9036,
-19221,  21228,   8939,
-19380,  21134,   8819,
-19445,  21089,   8784,
-19549,  21029,   8695,
-19652,  20934,   8692,
-19748,  20831,   8723,
-19789,  20752,   8816,
-19809,  20675,   8952,
-19727,  20707,   9058,
-19632,  20756,   9153,
-19524,  20830,   9216,
-19401,  20920,   9271,
-19319,  20983,   9301,
-19220,  21055,   9341,
-19197,  21030,   9445,
-19114,  21070,   9525,
-19012,  21109,   9642,
-18919,  21134,   9767,
-18827,  21176,   9856,
-18715,  21222,   9969,
-18622,  21261,  10058,
-18499,  21305,  10192,
-18477,  21362,  10112,
-18441,  21447,   9997,
-18461,  21490,   9867,
-18491,  21501,   9787,
-18596,  21455,   9687,
-18624,  21477,   9587,
-18688,  21503,   9402,
-18722,  21530,   9270,
-18700,  21601,   9149,
-18695,  21652,   9038,
-18712,  21699,   8891,
-18632,  21809,   8787,
-18564,  21897,   8711,
-18524,  21977,   8594,
-18390,  22085,   8606,
-18267,  22189,   8601,
-18265,  22229,   8502,
-18373,  22187,   8375,
-18368,  22228,   8279,
-18367,  22278,   8144,
-18414,  22302,   7973,
-18382,  22321,   7992,
-18303,  22342,   8115,
-18261,  22330,   8240,
-18228,  22304,   8384,
-18118,  22354,   8486,
-18006,  22419,   8554,
-17886,  22486,   8628,
-17804,  22581,   8549,
-17743,  22663,   8460,
-17754,  22708,   8316,
-17797,  22726,   8172,
-17864,  22722,   8038,
-17938,  22709,   7907,
-18027,  22679,   7791,
-18126,  22637,   7683,
-18220,  22599,   7570,
-18318,  22555,   7464,
-18416,  22510,   7358,
-18522,  22452,   7268,
-18625,  22397,   7175,
-18740,  22324,   7101,
-18852,  22251,   7034,
-18968,  22168,   6985,
-19081,  22090,   6925,
-19195,  22008,   6870,
-19304,  21936,   6794,
-19419,  21880,   6647,
-19366,  21925,   6653,
-19262,  21990,   6741,
-19141,  22081,   6788,
-19033,  22150,   6863,
-18916,  22233,   6920,
-18803,  22331,   6911,
-18787,  22388,   6771,
-18813,  22431,   6552,
-18789,  22429,   6626,
-18773,  22398,   6774,
-18761,  22362,   6926,
-18653,  22424,   7017,
-18535,  22510,   7055,
-18421,  22586,   7110,
-18290,  22663,   7204,
-18206,  22704,   7283,
-18114,  22743,   7393,
-18028,  22770,   7517,
-17908,  22862,   7527,
-17795,  22943,   7545,
-17656,  23022,   7632,
-17579,  23055,   7710,
-17509,  23068,   7830,
-17428,  23081,   7973,
-17370,  23076,   8111,
-17301,  23080,   8247,
-17238,  23078,   8384,
-17178,  23072,   8521,
-17114,  23071,   8651,
-17039,  23078,   8778,
-16983,  23069,   8909,
-16931,  23037,   9090,
-16887,  23034,   9180,
-16788,  23054,   9310,
-16714,  23059,   9429,
-16638,  23066,   9547,
-16530,  23112,   9622,
-16396,  23184,   9678,
-16267,  23249,   9739,
-16152,  23324,   9751,
-16020,  23395,   9799,
-15921,  23419,   9904,
-15797,  23459,  10006,
-15716,  23463,  10124,
-15625,  23484,  10216,
-15493,  23548,  10269,
-15373,  23597,  10338,
-15229,  23679,  10362,
-15155,  23764,  10276,
-15169,  23817,  10133,
-15102,  23837,  10185,
-15015,  23913,  10137,
-14935,  23981,  10093,
-14838,  24056,  10057,
-14803,  24132,   9925,
-14824,  24180,   9776,
-14980,  24142,   9632,
-14885,  24212,   9604,
-14821,  24289,   9507,
-14833,  24329,   9385,
-14913,  24334,   9243,
-14925,  24303,   9307,
-14955,  24292,   9286,
-15065,  24265,   9181,
-15192,  24206,   9126,
-15299,  24159,   9071,
-15427,  24114,   8975,
-15552,  24055,   8917,
-15533,  24079,   8884,
-15479,  24176,   8713,
-15426,  24163,   8844,
-15308,  24213,   8910,
-15207,  24235,   9022,
-15036,  24297,   9140,
-15134,  24286,   9006,
-15064,  24308,   9065,
-14958,  24335,   9167,
-14851,  24374,   9240,
-14697,  24423,   9354,
-14676,  24483,   9230,
-14728,  24505,   9089,
-14771,  24532,   8946,
-14738,  24604,   8800,
-14890,  24546,   8704,
-14811,  24594,   8704,
-14797,  24634,   8616,
-14891,  24623,   8482,
-14791,  24706,   8416,
-14720,  24782,   8316,
-14731,  24821,   8181,
-14707,  24883,   8033,
-14678,  24948,   7883,
-14606,  25022,   7782,
-14553,  25097,   7637,
-14566,  25078,   7678,
-14507,  25080,   7781,
-14347,  25162,   7812,
-14310,  25225,   7675,
-14284,  25288,   7514,
-14199,  25329,   7537,
-14105,  25411,   7439,
-14084,  25451,   7341,
-14133,  25463,   7206,
-14080,  25488,   7222,
-13988,  25542,   7207,
-14040,  25552,   7069,
-14023,  25572,   7032,
-13867,  25646,   7071,
-13808,  25707,   6964,
-13836,  25723,   6847,
-13776,  25761,   6824,
-13713,  25818,   6736,
-13644,  25875,   6659,
-13542,  25958,   6541,
-13534,  25982,   6462,
-13514,  26002,   6425,
-13440,  26051,   6379,
-13551,  26009,   6315,
-13681,  25940,   6320,
-13827,  25852,   6363,
-13926,  25804,   6341,
-14022,  25746,   6366,
-14071,  25718,   6373,
-14166,  25677,   6324,
-14316,  25579,   6383,
-14282,  25606,   6354,
-14265,  25647,   6225,
-14412,  25576,   6177,
-14522,  25534,   6091,
-14674,  25461,   6033,
-14624,  25508,   5958,
-14545,  25568,   5891,
-14602,  25547,   5842,
-14734,  25471,   5845,
-14894,  25410,   5699,
-14833,  25436,   5746,
-14724,  25479,   5834,
-14581,  25564,   5821,
-14487,  25634,   5748,
-14450,  25684,   5615,
-14513,  25677,   5483,
-14630,  25637,   5355,
-14543,  25688,   5352,
-14462,  25720,   5418,
-14351,  25790,   5376,
-14251,  25864,   5288,
-14133,  25938,   5243,
-14118,  25971,   5117,
-14154,  25985,   4945,
-14145,  25985,   4972,
-14100,  25983,   5109,
-14016,  26012,   5188,
-13888,  26094,   5123,
-13759,  26163,   5119,
-13634,  26229,   5112,
-13697,  26213,   5027,
-13677,  26249,   4889,
-13706,  26261,   4745,
-13708,  26287,   4589,
-13619,  26350,   4494,
-13553,  26398,   4408,
-13493,  26449,   4287,
-13453,  26484,   4193,
-13386,  26536,   4082,
-13329,  26586,   3943,
-13376,  26580,   3823,
-13494,  26536,   3706,
-13493,  26556,   3569,
-13537,  26551,   3433,
-13499,  26591,   3270,
-13485,  26616,   3121,
-13513,  26618,   2983,
-13628,  26570,   2883,
-13762,  26500,   2893,
-13884,  26428,   2962,
-13974,  26369,   3061,
-14115,  26294,   3065,
-14241,  26230,   3029,
-14316,  26182,   3092,
-14426,  26112,   3165,
-14562,  26031,   3217,
-14643,  25976,   3289,
-14790,  25895,   3271,
-14907,  25834,   3224,
-15013,  25776,   3192,
-15140,  25711,   3121,
-15256,  25645,   3098,
-15328,  25594,   3166,
-15389,  25540,   3300,
-15443,  25489,   3438,
-15515,  25429,   3555,
-15611,  25358,   3646,
-15717,  25281,   3721,
-15831,  25201,   3783,
-15952,  25118,   3823,
-16075,  25035,   3853,
-16200,  24952,   3870,
-16326,  24873,   3846,
-16458,  24796,   3777,
-16564,  24734,   3723,
-16675,  24673,   3633,
-16774,  24620,   3534,
-16865,  24573,   3425,
-16946,  24534,   3303,
-17046,  24486,   3139,
-17127,  24427,   3163,
-17234,  24338,   3260,
-17309,  24275,   3334,
-17422,  24188,   3377,
-17527,  24109,   3406,
-17657,  24006,   3454,
-17760,  23921,   3515,
-17869,  23832,   3570,
-17971,  23742,   3654,
-18082,  23661,   3629,
-18195,  23585,   3563,
-18366,  23445,   3614,
-18332,  23487,   3511,
-18336,  23498,   3410,
-18450,  23417,   3355,
-18599,  23284,   3452,
-18558,  23327,   3389,
-18498,  23391,   3267,
-18498,  23412,   3120,
-18603,  23344,   2996,
-18581,  23362,   2997,
-18470,  23438,   3089,
-18359,  23530,   3044,
-18280,  23605,   2942,
-18226,  23661,   2822,
-18186,  23710,   2659,
-18126,  23755,   2672,
-18019,  23847,   2581,
-17934,  23922,   2478,
-17831,  24003,   2425,
-17717,  24086,   2442,
-17600,  24174,   2419,
-17482,  24262,   2394,
-17385,  24339,   2319,
-17257,  24430,   2318,
-17129,  24518,   2335,
-17012,  24604,   2282,
-17002,  24626,   2125,
-17000,  24642,   1945,
-16999,  24649,   1866,
-17000,  24659,   1714,
-17023,  24653,   1565,
-17090,  24616,   1409,
-17030,  24657,   1419,
-16938,  24726,   1326,
-16874,  24775,   1201,
-16838,  24806,   1057,
-16795,  24841,    914,
-16761,  24870,    755,
-16686,  24923,    669,
-16582,  24994,    577,
-16508,  25045,    453,
-16423,  25103,    334,
-16383,  25131,    197,
-16347,  25155,     50,
-16282,  25197,    -84,
-16232,  25228,   -219,
-16243,  25220,   -366,
-16287,  25189,   -506,
-16327,  25158,   -706,
-16217,  25230,   -696,
-16093,  25308,   -708,
-15970,  25385,   -757,
-15843,  25463,   -784,
-15722,  25537,   -827,
-15576,  25625,   -872,
-15525,  25651,  -1003,
-15557,  25626,  -1135,
-15696,  25539,  -1174,
-15687,  25544,  -1185,
-15559,  25624,  -1157,
-15492,  25662,  -1217,
-15380,  25725,  -1295,
-15256,  25800,  -1264,
-15129,  25875,  -1267,
-14991,  25955,  -1257,
-14870,  26027,  -1224,
-14730,  26107,  -1198,
-14619,  26173,  -1128,
-14496,  26244,  -1048,
-14375,  26312,  -1001,
-14261,  26377,   -950,
-14150,  26439,   -851,
-14065,  26486,   -800,
-13964,  26542,   -729,
-13953,  26549,   -664,
-13858,  26600,   -637,
-13810,  26627,   -531,
-13747,  26660,   -541,
-13687,  26691,   -507,
-13700,  26687,   -346,
-13635,  26721,   -205,
-13529,  26776,   -164,
-13424,  26828,   -216,
-13352,  26863,   -346,
-13315,  26878,   -514,
-13232,  26917,   -604,
-13186,  26936,   -765,
-13107,  26972,   -840,
-13104,  26975,   -791,
-13183,  26940,   -661,
-13242,  26914,   -500,
-13277,  26899,   -369,
-13336,  26872,   -241,
-13318,  26881,   -105,
-13200,  26940,    -13,
-13099,  26989,     19,
-13130,  26974,    132,
-13146,  26965,    258,
-13096,  26988,    390,
-12993,  27036,    468,
-12866,  27096,    533,
-12756,  27146,    597,
-12615,  27211,    657,
-12538,  27249,    561,
-12540,  27250,    417,
-12525,  27259,    263,
-12447,  27296,    149,
-12341,  27344,     55,
-12273,  27374,    -76,
-12254,  27382,   -243,
-12231,  27393,   -219,
-12256,  27382,    -30,
-12249,  27385,     82,
-12349,  27340,    253,
-12410,  27311,    321,
-12499,  27269,    437,
-12487,  27271,    594,
-12384,  27316,    688,
-12263,  27369,    765,
-12135,  27423,    842,
-11976,  27496,    727,
-11916,  27518,    875,
-11977,  27488,    986,
-12019,  27464,   1131,
-12022,  27457,   1254,
-11983,  27472,   1300,
-11852,  27533,   1215,
-11714,  27597,   1077,
-11749,  27578,   1187,
-11808,  27550,   1255,
-11924,  27496,   1340,
-11878,  27510,   1449,
-11785,  27544,   1563,
-11670,  27589,   1628,
-11569,  27626,   1722,
-11417,  27688,   1746,
-11298,  27740,   1691,
-11202,  27785,   1584,
-11067,  27842,   1527,
-10958,  27890,   1446,
-10902,  27909,   1500,
-10836,  27928,   1622,
-10702,  27982,   1575,
-10582,  28027,   1589,
-10503,  28064,   1451,
-10426,  28100,   1302,
-10385,  28113,   1347,
-10335,  28132,   1324,
-10341,  28137,   1174,
-10296,  28159,   1028,
-10318,  28157,    858,
-10419,  28120,    824,
-10546,  28073,    843,
-10673,  28021,    946,
-10800,  27973,    927,
-10889,  27942,    827,
-11037,  27884,    816,
-11181,  27827,    786,
-11303,  27780,    722,
-11478,  27709,    692,
-11595,  27663,    566,
-11508,  27701,    477,
-11396,  27749,    383,
-11265,  27803,    327,
-11112,  27864,    353,
-11021,  27899,    416,
-10880,  27955,    385,
-10764,  28001,    306,
-10653,  28044,    176,
-10734,  28014,     69,
-10888,  27954,     46,
-11050,  27891,    -26,
-10974,  27921,   -101,
-10831,  27976,    -97,
-10635,  28051,   -188,
-10549,  28084,   -110,
-10478,  28110,   -208,
-10467,  28113,   -310,
-10413,  28131,   -457,
-10325,  28164,   -431,
-10168,  28222,   -363,
-10052,  28263,   -368,
 -9932,  28305,   -423,
 -9807,  28347,   -499,
 -9649,  28402,   -491,
 -9521,  28444,   -546,
 -9389,  28485,   -658,
 -9319,  28507,   -733,
 -9296,  28512,   -811,
 -9421,  28467,   -928,
 -9535,  28428,   -955,
 -9611,  28398,  -1082,
 -9734,  28355,  -1114,
 -9894,  28302,  -1059,
-10004,  28260,  -1129,
-10140,  28211,  -1151,
-10282,  28162,  -1080,
-10371,  28133,   -972,
-10426,  28117,   -848,
-10497,  28095,   -698,
-10580,  28065,   -660,
-10581,  28064,   -694,
-10548,  28075,   -727,
-10655,  28033,   -785,
-10786,  27981,   -854,
-10773,  27989,   -735,
-10905,  27940,   -687,
-11001,  27900,   -771,
-11109,  27854,   -862,
-11166,  27827,  -1005,
-11249,  27790,  -1093,
-11374,  27739,  -1091,
-11515,  27682,  -1067,
-11659,  27621,  -1081,
-11700,  27599,  -1173,
-11795,  27558,  -1199,
-11681,  27604,  -1251,
-11643,  27626,  -1116,
-11530,  27671,  -1176,
-11402,  27720,  -1256,
-11284,  27770,  -1224,
-11103,  27845,  -1175,
-11123,  27833,  -1271,
-11054,  27859,  -1298,
-10922,  27903,  -1450,
-10953,  27885,  -1572,
-11001,  27862,  -1645,
-11150,  27804,  -1609,
-11169,  27804,  -1479,
-11298,  27754,  -1438,
-11265,  27760,  -1569,
-11119,  27814,  -1652,
-11186,  27785,  -1690,
-11216,  27765,  -1817,
-11157,  27780,  -1954,
-11134,  27777,  -2118,
-11147,  27761,  -2259,
-11104,  27766,  -2399,
-11010,  27792,  -2525,
-10895,  27829,  -2619,
-10857,  27828,  -2785,
-10732,  27869,  -2857,
-10617,  27906,  -2927,
-10475,  27960,  -2921,
-10373,  27988,  -3013,
-10388,  27966,  -3162,
-10400,  27944,  -3312,
-10412,  27922,  -3458,
-10550,  27861,  -3529,
-10593,  27861,  -3401,
-10587,  27880,  -3257,
-10567,  27909,  -3070,
-10642,  27875,  -3117,
-10684,  27847,  -3221,
-10693,  27821,  -3411,
-10801,  27769,  -3493,
-10955,  27709,  -3489,
-11107,  27650,  -3482,
-11215,  27600,  -3532,
-11389,  27521,  -3586,
-11321,  27544,  -3626,
-11137,  27612,  -3684,
-11087,  27643,  -3599,
-10905,  27708,  -3656,
-10867,  27713,  -3730,
-10728,  27760,  -3779,
-10609,  27795,  -3856,
-10570,  27795,  -3967,
-10574,  27771,  -4121,
-10542,  27761,  -4266,
-10506,  27751,  -4415,
-10438,  27756,  -4547,
-10354,  27765,  -4678,
-10227,  27790,  -4810,
-10113,  27847,  -4722,
-10127,  27864,  -4587,
-10080,  27896,  -4496,
 -9938,  27943,  -4519,
 -9806,  27980,  -4581,
 -9698,  27994,  -4720,
 -9677,  27983,  -4830,
 -9590,  27994,  -4935,
 -9474,  28014,  -5048,
 -9342,  28046,  -5115,
 -9229,  28065,  -5215,
 -9117,  28083,  -5314,
 -8977,  28119,  -5358,
 -8846,  28148,  -5425,
 -8748,  28156,  -5540,
 -8710,  28144,  -5662,
 -8792,  28091,  -5793,
 -8730,  28084,  -5925,
 -8588,  28141,  -5857,
 -8453,  28195,  -5798,
 -8413,  28196,  -5849,
 -8495,  28146,  -5967,
 -8584,  28093,  -6092,
 -8505,  28094,  -6195,
 -8358,  28137,  -6201,
 -8223,  28186,  -6161,
 -8082,  28234,  -6125,
 -7912,  28279,  -6141,
 -7981,  28243,  -6218,
 -8036,  28196,  -6356,
 -8045,  28159,  -6506,
 -7973,  28153,  -6623,
 -7953,  28124,  -6766,
 -8019,  28064,  -6936,
 -7933,  28088,  -6939,
 -7880,  28070,  -7070,
 -7878,  28038,  -7199,
 -7941,  27989,  -7317,
 -7917,  27970,  -7418,
 -7847,  28016,  -7317,
 -7835,  28055,  -7180,
 -7819,  28097,  -7029,
 -7868,  28117,  -6893,
 -7893,  28141,  -6767,
 -7860,  28204,  -6540,
 -7761,  28211,  -6628,
 -7748,  28179,  -6775,
 -7704,  28147,  -6955,
 -7674,  28132,  -7050,
 -7679,  28093,  -7201,
 -7639,  28066,  -7343,
 -7643,  28025,  -7496,
 -7753,  27970,  -7588,
 -7708,  27975,  -7615,
 -7623,  27969,  -7721,
 -7515,  27980,  -7787,
 -7390,  27990,  -7869,
 -7252,  28011,  -7924,
 -7078,  28049,  -7948,
 -6958,  28076,  -7959,
 -6802,  28111,  -7970,
 -6685,  28120,  -8037,
 -6550,  28128,  -8120,
 -6415,  28150,  -8150,
 -6270,  28180,  -8159,
 -6118,  28206,  -8185,
 -6013,  28201,  -8281,
 -5913,  28189,  -8392,
 -5777,  28206,  -8429,
 -5631,  28223,  -8472,
 -5507,  28224,  -8550,
 -5356,  28244,  -8577,
 -5216,  28263,  -8603,
 -5069,  28279,  -8636,
 -4945,  28273,  -8727,
 -4830,  28267,  -8813,
 -4670,  28287,  -8833,
 -4548,  28333,  -8751,
 -4412,  28349,  -8769,
 -4288,  28336,  -8869,
 -4127,  28371,  -8834,
 -4040,  28342,  -8965,
 -3985,  28375,  -8888,
 -3846,  28417,  -8812,
 -3773,  28392,  -8924,
 -3731,  28354,  -9062,
 -3627,  28334,  -9166,
 -3494,  28331,  -9227,
 -3445,  28297,  -9350,
 -3486,  28257,  -9454,
 -3420,  28273,  -9431,
 -3314,  28258,  -9513,
 -3174,  28232,  -9638,
 -3108,  28217,  -9702,
 -3071,  28175,  -9836,
 -3044,  28129,  -9974,
 -3055,  28076, -10119,
 -3014,  28032, -10254,
 -2925,  27998, -10370,
 -2790,  27986, -10441,
 -2642,  27983, -10487,
 -2595,  27954, -10575,
 -2575,  27894, -10736,
 -2625,  27871, -10785,
 -2761,  27836, -10842,
 -2901,  27803, -10889,
 -3021,  27768, -10946,
 -3159,  27721, -11025,
 -3240,  27665, -11142,
 -3349,  27629, -11198,
 -3509,  27626, -11157,
 -3667,  27608, -11151,
 -3735,  27541, -11294,
 -3852,  27535, -11270,
 -4010,  27522, -11245,
 -3943,  27493, -11340,
 -3803,  27510, -11347,
 -3598,  27573, -11259,
 -3658,  27539, -11322,
 -3837,  27469, -11433,
 -3795,  27421, -11562,
 -3650,  27418, -11617,
 -3509,  27424, -11646,
 -3353,  27447, -11638,
 -3324,  27520, -11472,
 -3182,  27525, -11500,
 -3075,  27497, -11595,
 -2988,  27457, -11714,
 -2918,  27436, -11779,
 -2791,  27412, -11866,
 -2695,  27375, -11973,
 -2590,  27343, -12069,
 -2610,  27309, -12142,
 -2802,  27273, -12179,
 -2949,  27258, -12179,
 -2887,  27231, -12252,
 -2937,  27185, -12342,
 -3001,  27138, -12431,
 -3114,  27093, -12501,
 -3265,  27076, -12498,
 -3389,  27076, -12466,
 -3516,  27094, -12391,
 -3710,  27086, -12352,
 -3810,  27069, -12360,
 -3878,  27082, -12309,
 -3969,  27129, -12176,
 -4086,  27157, -12074,
 -4194,  27134, -12089,
 -4155,  27072, -12241,
 -4241,  27018, -12330,
 -4320,  26954, -12442,
 -4354,  26891, -12566,
 -4282,  26845, -12690,
 -4123,  26842, -12747,
 -4046,  26811, -12837,
 -3979,  26761, -12961,
 -3838,  26749, -13030,
 -3714,  26787, -12987,
 -3634,  26748, -13089,
 -3608,  26674, -13247,
 -3651,  26611, -13360,
 -3542,  26599, -13415,
 -3487,  26539, -13548,
 -3479,  26464, -13695,
 -3433,  26411, -13807,
 -3481,  26358, -13896,
 -3604,  26284, -14006,
 -3661,  26311, -13940,
 -3722,  26371, -13810,
 -3726,  26363, -13824,
 -3689,  26299, -13956,
 -3766,  26245, -14037,
 -3903,  26209, -14067,
 -4065,  26218, -14002,
 -4126,  26176, -14063,
 -4012,  26157, -14132,
 -3852,  26203, -14091,
 -3766,  26142, -14226,
 -3833,  26088, -14308,
 -3962,  26039, -14363,
 -4091,  25972, -14447,
 -4210,  25930, -14489,
 -4348,  25940, -14429,
 -4464,  25973, -14334,
 -4468,  26038, -14215,
 -4502,  26129, -14036,
 -4496,  26086, -14118,
 -4544,  26028, -14209,
 -4634,  25951, -14321,
 -4731,  25880, -14417,
 -4742,  25808, -14542,
 -4795,  25749, -14629,
 -4838,  25714, -14676,
 -4855,  25629, -14819,
 -4957,  25617, -14805,
 -5029,  25666, -14696,
 -5160,  25710, -14573,
 -5307,  25679, -14575,
 -5419,  25675, -14541,
 -5616,  25583, -14628,
 -5612,  25670, -14477,
 -5707,  25719, -14351,
 -5688,  25702, -14389,
 -5765,  25629, -14488,
 -5885,  25634, -14432,
 -5989,  25669, -14327,
 -6052,  25722, -14203,
 -6062,  25716, -14210,
 -6067,  25644, -14339,
 -6016,  25580, -14474,
 -6073,  25500, -14590,
 -6060,  25425, -14725,
 -6129,  25329, -14862,
 -6135,  25305, -14900,
 -6029,  25270, -15003,
 -5962,  25213, -15125,
 -5929,  25119, -15294,
 -5847,  25085, -15381,
 -5758,  25048, -15474,
 -5662,  24999, -15589,
 -5599,  24937, -15710,
 -5640,  24841, -15847,
 -5554,  24818, -15913,
 -5424,  24862, -15889,
 -5299,  24846, -15956,
 -5200,  24802, -16058,
 -5117,  24727, -16199,
 -5075,  24669, -16300,
 -4984,  24629, -16388,
 -4948,  24558, -16505,
 -4992,  24577, -16463,
 -5129,  24604, -16381,
 -5256,  24602, -16344,
 -5313,  24654, -16247,
 -5350,  24738, -16106,
 -5443,  24716, -16109,
 -5584,  24721, -16053,
 -5674,  24748, -15979,
 -5771,  24800, -15863,
 -5872,  24780, -15857,
 -5904,  24799, -15816,
 -5977,  24839, -15726,
 -6104,  24888, -15600,
 -6147,  24933, -15510,
 -6121,  24996, -15418,
 -6207,  25036, -15320,
 -6303,  25084, -15201,
 -6398,  25125, -15094,
 -6477,  25169, -14985,
 -6487,  25238, -14865,
 -6537,  25300, -14737,
 -6606,  25342, -14634,
 -6680,  25390, -14516,
 -6751,  25446, -14384,
 -6842,  25477, -14287,
 -6861,  25531, -14181,
 -6892,  25598, -14045,
 -6961,  25659, -13897,
 -6886,  25714, -13833,
 -6721,  25748, -13851,
 -6708,  25825, -13714,
 -6756,  25890, -13567,
 -6823,  25921, -13474,
 -6881,  25967, -13355,
 -6791,  26040, -13259,
 -6832,  26050, -13218,
 -6879,  26107, -13080,
 -6915,  26171, -12932,
 -6932,  26230, -12803,
 -7007,  26272, -12677,
 -7089,  26310, -12551,
 -7249,  26341, -12395,
 -7237,  26300, -12488,
 -7414,  26227, -12538,
 -7325,  26224, -12595,
 -7187,  26234, -12653,
 -7099,  26200, -12774,
 -7053,  26151, -12898,
 -7114,  26073, -13023,
 -7113,  26006, -13156,
 -7121,  25934, -13294,
 -7268,  25900, -13280,
 -7287,  25854, -13360,
 -7210,  25809, -13487,
 -7310,  25770, -13508,
 -7418,  25787, -13417,
 -7499,  25859, -13231,
 -7562,  25877, -13161,
 -7605,  25928, -13035,
 -7666,  25979, -12897,
 -7815,  25972, -12821,
 -7843,  26028, -12690,
 -7822,  26095, -12565,
 -7753,  26111, -12574,
 -7719,  26124, -12568,
 -7672,  26170, -12501,
 -7648,  26226, -12398,
 -7685,  26275, -12270,
 -7712,  26248, -12310,
 -7804,  26228, -12295,
 -7906,  26232, -12222,
 -7995,  26265, -12092,
 -8007,  26238, -12144,
 -8118,  26181, -12193,
 -8260,  26140, -12185,
 -8393,  26087, -12207,
 -8480,  26133, -12048,
 -8528,  26087, -12113,
 -8663,  26034, -12131,
 -8794,  25993, -12126,
 -8924,  25994, -12028,
 -9033,  26005, -11921,
 -9163,  25996, -11843,
 -9340,  25982, -11734,
 -9443,  25937, -11752,
 -9583,  25908, -11701,
 -9689,  25914, -11601,
 -9728,  25966, -11450,
 -9846,  25950, -11388,
 -9837,  25924, -11453,
 -9826,  25878, -11566,
 -9929,  25824, -11600,
-10043,  25792, -11573,
-10197,  25751, -11529,
-10339,  25702, -11511,
-10502,  25629, -11527,
-10611,  25581, -11532,
-10787,  25530, -11483,
-10853,  25540, -11398,
-10866,  25578, -11299,
-10736,  25634, -11297,
-10607,  25677, -11321,
-10578,  25705, -11286,
-10717,  25684, -11202,
-10797,  25669, -11159,
-10951,  25568, -11241,
-11086,  25524, -11207,
-11101,  25549, -11136,
-10986,  25628, -11068,
-10826,  25735, -10977,
-10751,  25798, -10902,
-10786,  25782, -10906,
-10903,  25706, -10969,
-11018,  25640, -11009,
-11159,  25559, -11054,
-11302,  25544, -10944,
-11418,  25473, -10990,
-11554,  25414, -10984,
-11681,  25335, -11033,
-11763,  25268, -11097,
-11828,  25218, -11142,
-11971,  25162, -11116,
-12119,  25092, -11115,
-12225,  25031, -11134,
-12422,  24945, -11111,
-12460,  24882, -11209,
-12559,  24774, -11336,
-12570,  24811, -11243,
-12607,  24874, -11062,
-12711,  24823, -11057,
-12824,  24745, -11100,
-12955,  24646, -11169,
-12994,  24598, -11230,
-13084,  24529, -11276,
-13136,  24551, -11166,
-13100,  24629, -11037,
-13021,  24706, -10957,
-12927,  24788, -10883,
-12904,  24809, -10862,
-13035,  24703, -10947,
-13123,  24614, -11043,
-13145,  24618, -11008,
-13069,  24710, -10891,
-13107,  24702, -10865,
-13190,  24594, -11006,
-13208,  24549, -11086,
-13264,  24474, -11185,
-13349,  24406, -11232,
-13289,  24418, -11276,
-13364,  24358, -11318,
-13492,  24337, -11212,
-13506,  24302, -11268,
-13513,  24256, -11359,
-13639,  24185, -11360,
-13793,  24108, -11339,
-13791,  24153, -11244,
-13773,  24230, -11100,
-13829,  24215, -11064,
-13920,  24125, -11144,
-14083,  24079, -11041,
-14034,  24088, -11083,
-13916,  24116, -11170,
-13924,  24085, -11226,
-14060,  24007, -11223,
-14214,  23920, -11216,

/* 2 */
855, 1,
 10146, -28113,   2593,
 10082, -28127,   2692,
 10002, -28145,   2798,
  9908, -28166,   2916,
  9791, -28198,   3005,
  9649, -28247,   2996,
  9524, -28289,   3001,
  9396, -28324,   3073,
  9245, -28371,   3096,
  9099, -28421,   3078,
  8966, -28467,   3043,
  8815, -28512,   3057,
  8686, -28544,   3131,
  8552, -28578,   3185,
  8452, -28596,   3293,
  8467, -28573,   3446,
  8553, -28535,   3547,
  8719, -28482,   3569,
  8833, -28444,   3595,
  8973, -28405,   3559,
  9108, -28368,   3508,
  9251, -28321,   3514,
  9396, -28266,   3572,
  9272, -28298,   3639,
  9300, -28275,   3749,
  9385, -28234,   3844,
  9533, -28184,   3845,
  9579, -28184,   3729,
  9705, -28146,   3689,
  9803, -28101,   3774,
  9901, -28074,   3720,
  9988, -28043,   3720,
 10105, -27995,   3765,
 10240, -27945,   3775,
 10363, -27900,   3771,
 10468, -27847,   3869,
 10608, -27784,   3938,
 10569, -27783,   4048,
 10505, -27787,   4185,
 10472, -27777,   4333,
 10430, -27770,   4477,
 10391, -27761,   4625,
 10353, -27749,   4773,
 10316, -27738,   4919,
 10288, -27722,   5067,
 10201, -27732,   5187,
 10131, -27735,   5304,
 10089, -27720,   5460,
 10057, -27705,   5593,
 10013, -27692,   5734,
  9933, -27694,   5864,
  9928, -27670,   5981,
  9921, -27641,   6129,
  9889, -27620,   6272,
  9854, -27599,   6419,
  9941, -27559,   6455,
 10037, -27519,   6477,
 10018, -27489,   6633,
 10029, -27451,   6773,
 10060, -27404,   6914,
 10017, -27383,   7058,
  9934, -27380,   7187,
  9848, -27379,   7309,
  9735, -27392,   7411,
  9624, -27403,   7515,
  9482, -27441,   7555,
  9345, -27477,   7596,
  9207, -27512,   7636,
  9091, -27571,   7562,
  9035, -27625,   7432,
  8973, -27652,   7406,
  8924, -27629,   7549,
  8872, -27610,   7680,
  8728, -27637,   7745,
  8702, -27685,   7604,
  8613, -27719,   7582,
  8475, -27747,   7632,
  8383, -27748,   7733,
  8457, -27697,   7832,
  8408, -27675,   7963,
  8281, -27725,   7921,
  8140, -27758,   7953,
  8016, -27771,   8033,
  7867, -27808,   8050,
  7737, -27823,   8124,
  7605, -27837,   8201,
  7458, -27879,   8192,
  7314, -27905,   8236,
  7171, -27934,   8263,
  7024, -27967,   8278,
  6886, -28005,   8264,
  6776, -28066,   8149,
  6671, -28115,   8065,
  6478, -28164,   8052,
  6516, -28123,   8162,
  6415, -28154,   8137,
  6343, -28131,   8270,
  6470, -28084,   8332,
  6419, -28074,   8406,
  6258, -28123,   8363,
  6225, -28095,   8480,
  6268, -28055,   8580,
  6212, -28025,   8718,
  6193, -27983,   8864,
  6229, -27930,   9006,
  6143, -27914,   9114,
  5998, -27951,   9098,
  5901, -28003,   9001,
  5773, -28054,   8925,
  5627, -28092,   8899,
  5478, -28121,   8898,
  5330, -28151,   8896,
  5189, -28158,   8956,
  5048, -28168,   9004,
  4899, -28192,   9012,
  4749, -28212,   9031,
  4608, -28219,   9080,
  4458, -28237,   9098,
  4311, -28251,   9126,
  4162, -28267,   9145,
  4013, -28282,   9167,
  3871, -28285,   9217,
  3759, -28266,   9322,
  3626, -28260,   9393,
  3510, -28242,   9489,
  3398, -28222,   9590,
  3273, -28207,   9676,
  3152, -28191,   9763,
  2993, -28210,   9760,
  2843, -28229,   9750,
  2692, -28241,   9756,
  2557, -28232,   9820,
  2425, -28228,   9864,
  2269, -28242,   9861,
  2151, -28277,   9788,
  2037, -28314,   9703,
  1884, -28310,   9745,
  1796, -28276,   9860,
  1715, -28239,   9981,
  1603, -28207,  10089,
  1568, -28233,  10021,
  1492, -28266,   9939,
  1377, -28228,  10065,
  1260, -28259,   9992,
  1150, -28293,   9909,
   998, -28299,   9908,
   846, -28306,   9902,
   699, -28319,   9877,
   554, -28335,   9840,
   410, -28351,   9800,
   278, -28377,   9730,
   139, -28398,   9671,
    30, -28431,   9574,
   -69, -28467,   9466,
  -159, -28431,   9574,
  -286, -28436,   9557,
  -382, -28416,   9612,
  -499, -28411,   9621,
  -646, -28419,   9589,
  -796, -28420,   9575,
  -945, -28434,   9519,
 -1028, -28406,   9595,
  -970, -28364,   9724,
  -990, -28322,   9842,
 -1116, -28335,   9793,
 -1202, -28372,   9673,
 -1256, -28416,   9537,
 -1241, -28469,   9381,
 -1376, -28490,   9296,
 -1458, -28441,   9433,
 -1528, -28395,   9559,
 -1647, -28359,   9647,
 -1728, -28378,   9577,
 -1750, -28424,   9434,
 -1819, -28467,   9290,
 -1959, -28429,   9379,
 -2002, -28462,   9269,
 -1888, -28499,   9178,
 -1817, -28543,   9056,
 -1847, -28585,   8916,
 -1918, -28620,   8787,
 -2015, -28649,   8671,
 -2153, -28658,   8606,
 -2130, -28683,   8529,
 -2137, -28715,   8419,
 -2273, -28722,   8361,
 -2377, -28746,   8248,
 -2391, -28797,   8065,
 -2370, -28825,   7969,
 -2312, -28846,   7911,
 -2180, -28837,   7979,
 -2053, -28822,   8065,
 -2026, -28850,   7973,
 -2123, -28873,   7863,
 -2190, -28903,   7733,
 -2269, -28930,   7608,
 -2316, -28962,   7474,
 -2321, -28999,   7326,
 -2352, -29032,   7185,
 -2304, -29072,   7035,
 -2440, -29082,   6951,
 -2544, -29092,   6868,
 -2655, -29102,   6783,
 -2780, -29106,   6717,
 -2900, -29114,   6630,
 -3017, -29124,   6533,
 -3107, -29144,   6401,
 -3176, -29160,   6294,
 -3269, -29175,   6173,
 -3336, -29196,   6041,
 -3374, -29221,   5897,
 -3429, -29242,   5756,
 -3460, -29267,   5608,
 -3537, -29283,   5477,
 -3564, -29307,   5330,
 -3561, -29334,   5181,
 -3557, -29360,   5032,
 -3535, -29388,   4884,
 -3480, -29417,   4747,
 -3377, -29446,   4641,
 -3227, -29464,   4635,
 -3082, -29484,   4604,
 -2948, -29491,   4650,
 -2868, -29478,   4779,
 -2790, -29464,   4907,
 -2658, -29454,   5042,
 -2642, -29468,   4966,
 -2674, -29489,   4819,
 -2670, -29515,   4664,
 -2508, -29536,   4622,
 -2415, -29560,   4514,
 -2447, -29578,   4376,
 -2543, -29588,   4252,
 -2608, -29601,   4118,
 -2698, -29610,   3996,
 -2767, -29621,   3862,
 -2846, -29630,   3734,
 -2890, -29644,   3588,
 -2947, -29655,   3449,
 -2969, -29670,   3302,
 -2910, -29691,   3159,
 -2971, -29698,   3030,
 -3095, -29694,   2944,
 -3185, -29697,   2824,
 -3242, -29703,   2685,
 -3278, -29712,   2539,
 -3299, -29722,   2390,
 -3269, -29737,   2242,
 -3198, -29754,   2109,
 -3123, -29773,   1946,
 -3228, -29763,   1943,
 -3362, -29744,   1997,
 -3507, -29730,   1954,
 -3651, -29716,   1902,
 -3793, -29702,   1852,
 -3933, -29687,   1798,
 -4074, -29671,   1743,
 -4210, -29656,   1675,
 -4334, -29643,   1589,
 -4434, -29634,   1475,
 -4549, -29621,   1378,
 -4675, -29605,   1292,
 -4819, -29584,   1259,
 -4964, -29562,   1210,
 -5090, -29548,    999,
 -5080, -29546,   1102,
 -5142, -29530,   1234,
 -5270, -29505,   1300,
 -5411, -29481,   1270,
 -5468, -29476,   1138,
 -5507, -29474,    987,
 -5400, -29496,    904,
 -5436, -29491,    857,
 -5578, -29466,    801,
 -5687, -29448,    707,
 -5834, -29419,    676,
 -5990, -29389,    642,
 -6021, -29380,    734,
 -5885, -29406,    813,
 -5773, -29425,    912,
 -5719, -29431,   1053,
 -5738, -29422,   1203,
 -5846, -29397,   1288,
 -5979, -29372,   1231,
 -6067, -29359,   1107,
 -6174, -29341,    978,
 -6288, -29317,    992,
 -6264, -29318,   1112,
 -6180, -29330,   1241,
 -6120, -29337,   1379,
 -6043, -29346,   1508,
 -5960, -29357,   1632,
 -6010, -29338,   1776,
 -6129, -29307,   1874,
 -6243, -29288,   1795,
 -6290, -29287,   1647,
 -6413, -29265,   1570,
 -6549, -29237,   1516,
 -6692, -29207,   1474,
 -6834, -29176,   1437,
 -6973, -29144,   1426,
 -7089, -29110,   1534,
 -7029, -29118,   1661,
 -6890, -29149,   1693,
 -6761, -29175,   1757,
 -6691, -29183,   1891,
 -6630, -29188,   2030,
 -6569, -29191,   2169,
 -6515, -29192,   2316,
 -6606, -29162,   2431,
 -6642, -29143,   2567,
 -6645, -29129,   2715,
 -6640, -29115,   2867,
 -6661, -29096,   3015,
 -6691, -29073,   3160,
 -6721, -29050,   3309,
 -6827, -29019,   3359,
 -6923, -28986,   3445,
 -7035, -28945,   3561,
 -6940, -28962,   3609,
 -6946, -28949,   3702,
 -7063, -28910,   3787,
 -7153, -28874,   3892,
 -7247, -28842,   3954,
 -7287, -28825,   4005,
 -7348, -28794,   4115,
 -7478, -28764,   4086,
 -7609, -28727,   4104,
 -7543, -28731,   4201,
 -7518, -28722,   4304,
 -7627, -28683,   4374,
 -7783, -28644,   4353,
 -7903, -28618,   4308,
 -7957, -28587,   4411,
 -8081, -28546,   4456,
 -8196, -28535,   4308,
 -8234, -28515,   4369,
 -8205, -28500,   4520,
 -8314, -28469,   4517,
 -8376, -28444,   4560,
 -8440, -28408,   4663,
 -8586, -28357,   4705,
 -8697, -28334,   4640,
 -8769, -28301,   4707,
 -8903, -28262,   4692,
 -8999, -28218,   4772,
 -9155, -28168,   4769,
 -9284, -28114,   4837,
 -9418, -28073,   4816,
 -9552, -28034,   4778,
 -9702, -27974,   4832,
 -9819, -27932,   4835,
 -9846, -27896,   4987,
 -9899, -27885,   4943,
 -9905, -27911,   4784,
 -9792, -27955,   4754,
 -9812, -27959,   4696,
 -9894, -27950,   4575,
-10019, -27902,   4596,
-10103, -27852,   4713,
-10185, -27830,   4666,
-10332, -27767,   4716,
-10452, -27715,   4760,
-10491, -27677,   4892,
-10591, -27621,   4989,
-10614, -27580,   5166,
-10732, -27519,   5248,
-10803, -27467,   5371,
-10601, -27527,   5467,
-10715, -27467,   5547,
-10622, -27474,   5686,
-10602, -27455,   5817,
-10623, -27416,   5959,
-10696, -27402,   5892,
-10714, -27427,   5740,
-10856, -27383,   5683,
-10944, -27318,   5826,
-11041, -27273,   5857,
-11092, -27227,   5970,
-11110, -27185,   6127,
-11152, -27137,   6260,
-11190, -27090,   6398,
-11172, -27061,   6548,
-11086, -27070,   6656,
-11126, -27035,   6731,
-11223, -26969,   6833,
-11270, -26917,   6962,
-11272, -26877,   7113,
-11216, -26859,   7265,
-11311, -26800,   7337,
-11396, -26792,   7233,
-11403, -26827,   7089,
-11431, -26857,   6933,
-11406, -26905,   6786,
-11421, -26930,   6658,
-11445, -26952,   6526,
-11450, -26986,   6375,
-11377, -27045,   6255,
-11354, -27085,   6122,
-11351, -27124,   5953,
-11330, -27157,   5842,
-11292, -27201,   5711,
-11346, -27210,   5559,
-11220, -27277,   5483,
-11150, -27320,   5414,
-11097, -27365,   5294,
-11050, -27403,   5196,
-11049, -27427,   5066,
-11001, -27470,   4938,
-10926, -27521,   4819,
-10841, -27571,   4722,
-10791, -27610,   4607,
-10775, -27638,   4476,
-10630, -27707,   4398,
-10538, -27721,   4528,
-10457, -27759,   4482,
-10365, -27808,   4392,
-10230, -27863,   4362,
-10125, -27913,   4286,
-10005, -27969,   4204,
 -9882, -28009,   4221,
 -9781, -28060,   4119,
 -9812, -28070,   3974,
 -9817, -28085,   3856,
 -9673, -28138,   3833,
 -9546, -28189,   3773,
 -9405, -28235,   3788,
 -9263, -28283,   3781,
 -9122, -28331,   3761,
 -8983, -28379,   3734,
 -8854, -28428,   3666,
 -8712, -28475,   3646,
 -8568, -28518,   3648,
 -8434, -28565,   3593,
 -8316, -28608,   3528,
 -8221, -28649,   3410,
 -8173, -28679,   3277,
 -8133, -28706,   3129,
 -8124, -28725,   2979,
 -8149, -28733,   2831,
 -8147, -28748,   2685,
 -8152, -28760,   2529,
 -8121, -28781,   2384,
 -8123, -28793,   2232,
 -8138, -28800,   2089,
 -8129, -28813,   1932,
 -8215, -28789,   1930,
 -8292, -28771,   1861,
 -8276, -28786,   1694,
 -8373, -28761,   1645,
 -8504, -28726,   1577,
 -8603, -28702,   1470,
 -8548, -28722,   1413,
 -8455, -28752,   1346,
 -8326, -28792,   1297,
 -8242, -28821,   1202,
 -8277, -28816,   1077,
 -8357, -28797,    949,
 -8395, -28790,    809,
 -8463, -28774,    670,
 -8647, -28720,    628,
 -8617, -28731,    519,
 -8640, -28726,    388,
 -8680, -28716,    254,
 -8866, -28660,    171,
 -8754, -28694,     93,
 -8684, -28716,    -25,
 -8629, -28732,   -159,
 -8669, -28719,   -316,
 -8665, -28718,   -463,
 -8616, -28730,   -602,
 -8622, -28725,   -752,
 -8582, -28732,   -900,
 -8578, -28728,  -1047,
 -8627, -28708,  -1200,
 -8676, -28688,  -1320,
 -8634, -28693,  -1468,
 -8595, -28697,  -1612,
 -8567, -28696,  -1777,
 -8597, -28679,  -1893,
 -8667, -28651,  -2003,
 -8557, -28680,  -2057,
 -8427, -28724,  -1985,
 -8401, -28740,  -1847,
 -8426, -28742,  -1700,
 -8439, -28747,  -1547,
 -8369, -28775,  -1405,
 -8291, -28795,  -1449,
 -8255, -28798,  -1596,
 -8279, -28782,  -1745,
 -8226, -28789,  -1874,
 -8116, -28826,  -1797,
 -8059, -28849,  -1673,
 -7916, -28893,  -1599,
 -7889, -28907,  -1464,
 -7763, -28943,  -1432,
 -7688, -28966,  -1364,
 -7590, -28995,  -1288,
 -7508, -29012,  -1396,
 -7480, -29012,  -1541,
 -7548, -28987,  -1668,
 -7524, -28983,  -1829,
 -7475, -28987,  -1973,
 -7389, -29000,  -2101,
 -7282, -29019,  -2206,
 -7255, -29014,  -2350,
 -7267, -28999,  -2504,
 -7183, -29005,  -2670,
 -7310, -28967,  -2733,
 -7458, -28931,  -2718,
 -7601, -28887,  -2790,
 -7620, -28867,  -2934,
 -7511, -28893,  -2965,
 -7375, -28933,  -2911,
 -7266, -28956,  -2961,
 -7280, -28939,  -3084,
 -7369, -28908,  -3167,
 -7492, -28869,  -3234,
 -7579, -28834,  -3341,
 -7502, -28843,  -3438,
 -7347, -28889,  -3384,
 -7243, -28905,  -3472,
 -7149, -28914,  -3586,
 -7141, -28896,  -3743,
 -7049, -28909,  -3816,
 -6939, -28926,  -3893,
 -6838, -28934,  -4007,
 -6743, -28940,  -4127,
 -6676, -28935,  -4262,
 -6581, -28940,  -4376,
 -6516, -28934,  -4516,
 -6435, -28931,  -4644,
 -6350, -28930,  -4770,
 -6241, -28937,  -4871,
 -6111, -28951,  -4947,
 -6008, -28954,  -5055,
 -5929, -28948,  -5186,
 -5842, -28943,  -5309,
 -5713, -28953,  -5396,
 -5695, -28927,  -5552,
 -5599, -28924,  -5660,
 -5448, -28943,  -5713,
 -5304, -28974,  -5690,
 -5165, -28988,  -5747,
 -5032, -28994,  -5831,
 -4886, -29026,  -5800,
 -4746, -29044,  -5824,
 -4628, -29044,  -5919,
 -4501, -29056,  -5958,
 -4345, -29072,  -5996,
 -4211, -29094,  -5982,
 -4068, -29104,  -6036,
 -3987, -29149,  -5871,
 -3883, -29146,  -5952,
 -3805, -29127,  -6095,
 -3640, -29149,  -6090,
 -3670, -29167,  -5983,
 -3800, -29164,  -5917,
 -3857, -29183,  -5784,
 -3851, -29211,  -5647,
 -3772, -29237,  -5566,
 -3675, -29269,  -5459,
 -3587, -29269,  -5520,
 -3427, -29287,  -5525,
 -3286, -29306,  -5511,
 -3188, -29307,  -5562,
 -3146, -29283,  -5711,
 -3042, -29279,  -5787,
 -2965, -29274,  -5853,
 -2913, -29252,  -5988,
 -2800, -29243,  -6083,
 -2675, -29259,  -6064,
 -2557, -29255,  -6134,
 -2468, -29282,  -6037,
 -2391, -29313,  -5920,
 -2350, -29343,  -5784,
 -2422, -29368,  -5628,
 -2566, -29362,  -5593,
 -2687, -29364,  -5524,
 -2618, -29394,  -5400,
 -2457, -29408,  -5397,
 -2420, -29429,  -5297,
 -2465, -29451,  -5155,
 -2557, -29463,  -5038,
 -2639, -29476,  -4917,
 -2699, -29494,  -4778,
 -2778, -29507,  -4647,
 -2847, -29521,  -4515,
 -2882, -29540,  -4368,
 -2855, -29564,  -4220,
 -2795, -29589,  -4086,
 -2660, -29610,  -4022,
 -2522, -29629,  -3967,
 -2389, -29652,  -3880,
 -2263, -29659,  -3904,
 -2192, -29646,  -4036,
 -2096, -29638,  -4148,
 -1979, -29632,  -4244,
 -1828, -29644,  -4232,
 -1844, -29659,  -4116,
 -1908, -29675,  -3971,
 -1822, -29696,  -3848,
 -1799, -29717,  -3700,
 -1821, -29734,  -3546,
 -1814, -29752,  -3398,
 -1708, -29770,  -3290,
 -1616, -29788,  -3172,
 -1550, -29806,  -3036,
 -1475, -29822,  -2907,
 -1419, -29838,  -2770,
 -1410, -29852,  -2619,
 -1442, -29863,  -2471,
 -1514, -29870,  -2338,
 -1600, -29876,  -2212,
 -1684, -29880,  -2086,
 -1698, -29888,  -1953,
 -1575, -29896,  -1935,
 -1486, -29892,  -2065,
 -1361, -29891,  -2162,
 -1204, -29902,  -2100,
 -1090, -29901,  -2181,
  -933, -29903,  -2217,
  -813, -29900,  -2313,
  -728, -29892,  -2434,
  -636, -29884,  -2552,
  -561, -29876,  -2670,
  -453, -29867,  -2788,
  -325, -29861,  -2868,
  -172, -29860,  -2892,
   -49, -29855,  -2945,
    66, -29845,  -3046,
   198, -29837,  -3120,
   333, -29828,  -3187,
   446, -29820,  -3254,
   531, -29807,  -3353,
   684, -29801,  -3381,
   722, -29793,  -3444,
   767, -29777,  -3566,
   856, -29764,  -3656,
   965, -29748,  -3762,
  1077, -29733,  -3846,
  1158, -29717,  -3946,
  1262, -29697,  -4062,
  1413, -29676,  -4164,
  1433, -29654,  -4313,
  1544, -29635,  -4400,
  1597, -29613,  -4533,
  1650, -29591,  -4656,
  1782, -29583,  -4655,
  1853, -29567,  -4728,
  1789, -29544,  -4891,
  1831, -29521,  -5013,
  1830, -29494,  -5171,
  1896, -29467,  -5303,
  1844, -29448,  -5423,
  1736, -29436,  -5521,
  1648, -29418,  -5644,
  1542, -29406,  -5736,
  1361, -29406,  -5780,
  1414, -29394,  -5832,
  1547, -29364,  -5949,
  1647, -29351,  -5983,
  1729, -29314,  -6140,
  1811, -29294,  -6213,
  1874, -29261,  -6345,
  1989, -29233,  -6440,
  2024, -29212,  -6525,
  2055, -29180,  -6655,
  2116, -29143,  -6797,
  2143, -29110,  -6929,
  2159, -29078,  -7059,
  2221, -29042,  -7187,
  2297, -29003,  -7317,
  2221, -28980,  -7431,
  2188, -28944,  -7580,
  2080, -28933,  -7653,
  2054, -28905,  -7764,
  2128, -28864,  -7896,
  2018, -28851,  -7972,
  2027, -28826,  -8060,
  1942, -28794,  -8195,
  1852, -28763,  -8322,
  1749, -28769,  -8324,
  1650, -28761,  -8370,
  1625, -28721,  -8512,
  1569, -28687,  -8638,
  1537, -28640,  -8797,
  1546, -28595,  -8941,
  1586, -28556,  -9057,
  1512, -28526,  -9164,
  1498, -28486,  -9291,
  1604, -28447,  -9393,
  1757, -28437,  -9394,
  1883, -28404,  -9469,
  2026, -28371,  -9537,
  2110, -28329,  -9643,
  2273, -28314,  -9652,
  2409, -28306,  -9640,
  2555, -28291,  -9649,
  2709, -28279,  -9641,
  2832, -28292,  -9568,
  2972, -28257,  -9629,
  3119, -28245,  -9618,
  3261, -28232,  -9610,
  3403, -28206,  -9636,
  3509, -28166,  -9713,
  3641, -28128,  -9775,
  3784, -28099,  -9803,
  3919, -28065,  -9847,
  4113, -28029,  -9874,
  4210, -28041,  -9796,
  4334, -28045,  -9732,
  4484, -28029,  -9709,
  4643, -27992,  -9740,
  4689, -27944,  -9855,
  4845, -27899,  -9908,
  4830, -27935,  -9814,
  4804, -27988,  -9676,
  4951, -27977,  -9633,
  5069, -27977,  -9569,
  5207, -27985,  -9471,
  5327, -27914,  -9614,
  5465, -27903,  -9569,
  5610, -27882,  -9546,
  5756, -27876,  -9478,
  5869, -27826,  -9553,
  5984, -27794,  -9575,
  6071, -27826,  -9427,
  6142, -27801,  -9453,
  6290, -27755,  -9490,
  6461, -27734,  -9438,
  6521, -27679,  -9558,
  6605, -27634,  -9629,
  6717, -27645,  -9521,
  6851, -27625,  -9481,
  6998, -27596,  -9461,
  7105, -27611,  -9335,
  7252, -27579,  -9319,
  7383, -27571,  -9237,
  7513, -27560,  -9164,
  7644, -27544,  -9104,
  7785, -27523,  -9048,
  7910, -27515,  -8963,
  8049, -27494,  -8905,
  8182, -27476,  -8840,
  8293, -27474,  -8741,
  8437, -27448,  -8684,
  8590, -27419,  -8628,
  8677, -27366,  -8707,
  8749, -27304,  -8828,
  8869, -27243,  -8898,
  8992, -27196,  -8919,
  9071, -27198,  -8831,
  8985, -27263,  -8717,
  8879, -27326,  -8629,
  8754, -27385,  -8570,
  8712, -27435,  -8452,
  8843, -27423,  -8353,
  8919, -27437,  -8224,
  9000, -27448,  -8100,
  9087, -27455,  -7979,
  9192, -27452,  -7868,
  9224, -27482,  -7723,
  9193, -27532,  -7582,
  9119, -27588,  -7468,
  9079, -27635,  -7341,
  9191, -27624,  -7240,
  9312, -27606,  -7155,
  9449, -27570,  -7114,
  9580, -27508,  -7180,
  9721, -27473,  -7122,
  9746, -27505,  -6964,
  9703, -27554,  -6828,
  9798, -27536,  -6765,
  9893, -27524,  -6677,
  9910, -27553,  -6527,
  9984, -27546,  -6446,
 10103, -27528,  -6335,
 10130, -27553,  -6183,
 10147, -27578,  -6039,
 10211, -27585,  -5898,
 10255, -27599,  -5758,
 10328, -27600,  -5618,
 10380, -27608,  -5482,
 10490, -27587,  -5375,
 10630, -27538,  -5356,
 10766, -27493,  -5312,
 10844, -27486,  -5187,
 10869, -27506,  -5028,
 10998, -27459,  -5006,
 11137, -27410,  -4966,
 11276, -27362,  -4916,
 11335, -27358,  -4801,
 11342, -27381,  -4653,
 11374, -27392,  -4505,
 11368, -27419,  -4357,
 11267, -27474,  -4267,
 11191, -27522,  -4163,
 11174, -27550,  -4019,
 11190, -27568,  -3844,
 11294, -27539,  -3750,
 11418, -27499,  -3665,
 11476, -27494,  -3521,
 11549, -27479,  -3392,
 11627, -27462,  -3265,
 11715, -27439,  -3141,
 11797, -27417,  -3019,
 11856, -27406,  -2884,
 11923, -27391,  -2751,
 11953, -27392,  -2604,
 11947, -27409,  -2456,
 11929, -27429,  -2309,
 11839, -27478,  -2195,
 11774, -27516,  -2066,
 11669, -27570,  -1936,
 11735, -27547,  -1850,
 11817, -27519,  -1748,
 11788, -27541,  -1586,
 11831, -27530,  -1450,
 11823, -27542,  -1295,
 11832, -27545,  -1138,
 11886, -27527,   -997,
 11866, -27541,   -847,
 11896, -27532,   -699,
 11894, -27536,   -544,
 11932, -27522,   -400,
 11932, -27524,   -246,
 11894, -27541,   -101,
 11864, -27554,     45,
 11851, -27559,    210,
 11969, -27508,    259,
 12128, -27437,    329,
 12070, -27462,    383,
 11923, -27526,    399,
 11806, -27575,    475,
 11720, -27610,    595,
 11677, -27624,    737,
 11614, -27647,    866,
 11604, -27646,   1019,
 11592, -27645,   1168,
 11571, -27647,   1318,
 11484, -27677,   1446,
 11477, -27673,   1580,
 11339, -27726,   1644,
 11260, -27756,   1679,
 11162, -27788,   1794,
 11103, -27803,   1932,
 11022, -27826,   2059,
 10920, -27858,   2163,
 10795, -27901,   2239,
 10661, -27949,   2275,
 10524, -28003,   2256,
 10409, -28040,   2325,
 10312, -28066,   2441,
 10217, -28092,   2536,

/* 3 */
533, 1,
 14413, -10720, -24028,
 14519, -10656, -23993,
 14560, -10511, -24032,
 14605, -10390, -24057,
 14723, -10328, -24012,
 14831, -10269, -23970,
 14961, -10204, -23917,
 15082, -10141, -23868,
 15207,  -9985, -23855,
 15312,  -9969, -23794,
 15428,  -9901, -23748,
 15562,  -9858, -23678,
 15685,  -9782, -23628,
 15763,  -9661, -23626,
 15800,  -9525, -23657,
 15902,  -9415, -23632,
 15930,  -9279, -23667,
 15933,  -9140, -23719,
 15974,  -9003, -23744,
 16045,  -8868, -23747,
 16116,  -8736, -23748,
 16222,  -8627, -23715,
 16316,  -8508, -23694,
 16339,  -8371, -23727,
 16388,  -8227, -23744,
 16438,  -8085, -23757,
 16476,  -7934, -23782,
 16501,  -7802, -23809,
 16545,  -7702, -23810,
 16662,  -7619, -23755,
 16776,  -7535, -23702,
 16853,  -7407, -23688,
 16953,  -7396, -23620,
 17030,  -7455, -23546,
 17132,  -7488, -23461,
 17213,  -7360, -23442,
 17272,  -7223, -23442,
 17317,  -7082, -23451,
 17338,  -6941, -23478,
 17378,  -6794, -23491,
 17427,  -6663, -23493,
 17482,  -6522, -23491,
 17581,  -6402, -23450,
 17593,  -6250, -23483,
 17690,  -6173, -23430,
 17749,  -6029, -23423,
 17775,  -5884, -23440,
 17834,  -5733, -23432,
 17917,  -5633, -23393,
 17994,  -5643, -23332,
 18063,  -5741, -23254,
 18060,  -5899, -23217,
 18076,  -6044, -23167,
 18082,  -6194, -23123,
 18110,  -6262, -23083,
 18157,  -6379, -23014,
 18095,  -6562, -23011,
 18120,  -6659, -22964,
 18147,  -6778, -22908,
 18113,  -6922, -22891,
 18143,  -7060, -22825,
 18135,  -7208, -22786,
 18072,  -7345, -22791,
 18069,  -7493, -22746,
 18032,  -7638, -22727,
 17981,  -7784, -22718,
 17991,  -7921, -22662,
 18007,  -8062, -22600,
 18001,  -8208, -22552,
 17983,  -8349, -22514,
 17993,  -8495, -22452,
 18015,  -8627, -22384,
 18058,  -8746, -22303,
 18066,  -8882, -22243,
 18094,  -9006, -22170,
 18179,  -9082, -22070,
 18282,  -9121, -21968,
 18396,  -9100, -21881,
 18514,  -9037, -21808,
 18628,  -8964, -21740,
 18731,  -8881, -21686,
 18805,  -8752, -21674,
 18924,  -8693, -21595,
 19040,  -8659, -21506,
 19156,  -8618, -21419,
 19263,  -8528, -21359,
 19359,  -8418, -21316,
 19471,  -8352, -21240,
 19580,  -8281, -21167,
 19694,  -8225, -21084,
 19796,  -8192, -21000,
 19902,  -8099, -20936,
 20000,  -7999, -20881,
 20101,  -7910, -20818,
 20208,  -7825, -20746,
 20313,  -7749, -20672,
 20358,  -7619, -20676,
 20319,  -7493, -20760,
 20268,  -7378, -20852,
 20245,  -7252, -20917,
 20255,  -7111, -20956,
 20304,  -6979, -20954,
 20276,  -6876, -21014,
 20185,  -6840, -21114,
 20111,  -6834, -21186,
 20108,  -6689, -21235,
 20071,  -6534, -21318,
 20018,  -6435, -21398,
 20092,  -6353, -21353,
 20179,  -6240, -21304,
 20251,  -6251, -21233,
 20263,  -6359, -21189,
 20298,  -6466, -21123,
 20365,  -6354, -21092,
 20427,  -6344, -21035,
 20475,  -6323, -20995,
 20444,  -6203, -21061,
 20463,  -6169, -21052,
 20538,  -6261, -20952,
 20630,  -6342, -20837,
 20712,  -6350, -20753,
 20821,  -6253, -20673,
 20911,  -6263, -20579,
 21027,  -6238, -20469,
 21133,  -6160, -20382,
 21218,  -6120, -20306,
 21319,  -6122, -20199,
 21417,  -6075, -20110,
 21525,  -5939, -20035,
 21618,  -5957, -19930,
 21719,  -5850, -19851,
 21791,  -5855, -19771,
 21836,  -5851, -19722,
 21902,  -5864, -19645,
 21810,  -5969, -19715,
 21694,  -5972, -19841,
 21614,  -6084, -19895,
 21573,  -6259, -19885,
 21628,  -6352, -19796,
 21703,  -6347, -19716,
 21801,  -6375, -19598,
 21900,  -6384, -19484,
 22016,  -6327, -19371,
 22091,  -6347, -19279,
 22137,  -6485, -19181,
 22197,  -6479, -19113,
 22236,  -6560, -19040,
 22296,  -6632, -18945,
 22339,  -6741, -18855,
 22290,  -6897, -18857,
 22346,  -6996, -18754,
 22396,  -7067, -18668,
 22392,  -7200, -18622,
 22436,  -7294, -18532,
 22459,  -7435, -18447,
 22359,  -7551, -18521,
 22272,  -7651, -18585,
 22289,  -7686, -18550,
 22299,  -7813, -18485,
 22347,  -7777, -18442,
 22439,  -7787, -18327,
 22490,  -7736, -18285,
 22593,  -7680, -18182,
 22702,  -7664, -18052,
 22730,  -7764, -17974,
 22748,  -7927, -17880,
 22789,  -7878, -17849,
 22804,  -7725, -17898,
 22822,  -7608, -17924,
 22921,  -7505, -17841,
 22999,  -7391, -17788,
 23089,  -7288, -17714,
 23178,  -7223, -17624,
 23254,  -7170, -17545,
 23316,  -7184, -17457,
 23335,  -7302, -17382,
 23391,  -7283, -17316,
 23440,  -7322, -17232,
 23505,  -7263, -17169,
 23522,  -7297, -17130,
 23499,  -7470, -17087,
 23559,  -7525, -16980,
 23614,  -7426, -16948,
 23628,  -7464, -16912,
 23660,  -7540, -16833,
 23709,  -7610, -16733,
 23662,  -7735, -16742,
 23642,  -7814, -16733,
 23722,  -7796, -16628,
 23701,  -7926, -16596,
 23757,  -7928, -16515,
 23793,  -7970, -16442,
 23839,  -8067, -16329,
 23771,  -8202, -16361,
 23745,  -8294, -16352,
 23757,  -8394, -16284,
 23648,  -8458, -16409,
 23665,  -8470, -16378,
 23753,  -8465, -16252,
 23838,  -8420, -16151,
 23936,  -8410, -16010,
 23969,  -8499, -15914,
 23959,  -8571, -15890,
 23851,  -8695, -15985,
 23842,  -8815, -15933,
 23849,  -8981, -15830,
 23908,  -8929, -15770,
 23981,  -8800, -15731,
 24056,  -8661, -15693,
 24120,  -8530, -15667,
 24160,  -8522, -15611,
 24170,  -8645, -15526,
 24205,  -8740, -15418,
 24243,  -8842, -15300,
 24237,  -8974, -15233,
 24191,  -9115, -15222,
 24134,  -9252, -15231,
 24102,  -9361, -15213,
 24137,  -9453, -15101,
 24174,  -9544, -14984,
 24181,  -9661, -14898,
 24173,  -9802, -14819,
 24180,  -9922, -14727,
 24205, -10022, -14618,
 24248, -10096, -14495,
 24301, -10153, -14365,
 24358, -10204, -14233,
 24425, -10229, -14099,
 24486, -10265, -13966,
 24555, -10267, -13844,
 24631, -10257, -13715,
 24655, -10354, -13599,
 24696, -10417, -13476,
 24764, -10435, -13335,
 24813, -10479, -13209,
 24839, -10567, -13092,
 24891, -10605, -12960,
 24969, -10587, -12825,
 25048, -10570, -12684,
 25087, -10606, -12577,
 25124, -10671, -12446,
 25154, -10733, -12332,
 25176, -10822, -12208,
 25194, -10913, -12091,
 25208, -11008, -11973,
 25248, -11068, -11834,
 25288, -11118, -11700,
 25303, -11215, -11576,
 25285, -11325, -11508,
 25275, -11460, -11395,
 25334, -11381, -11344,
 25403, -11197, -11371,
 25426, -11233, -11286,
 25399, -11364, -11215,
 25375, -11493, -11136,
 25321, -11618, -11131,
 25256, -11755, -11133,
 25206, -11893, -11101,
 25181, -12015, -11026,
 25162, -12136, -10937,
 25122, -12270, -10878,
 25066, -12409, -10850,
 24986, -12529, -10895,
 24916, -12657, -10909,
 24836, -12776, -10952,
 24754, -12899, -10992,
 24671, -13017, -11041,
 24596, -13136, -11068,
 24543, -13303, -10984,
 24643, -13198, -10887,
 24703, -13117, -10848,
 24801, -12976, -10795,
 24778, -13059, -10748,
 24699, -13183, -10779,
 24612, -13286, -10851,
 24555, -13420, -10814,
 24618, -13370, -10733,
 24721, -13240, -10658,
 24694, -13317, -10624,
 24609, -13424, -10688,
 24522, -13530, -10752,
 24437, -13644, -10801,
 24352, -13763, -10841,
 24270, -13890, -10863,
 24207, -14023, -10834,
 24126, -14151, -10848,
 24037, -14258, -10907,
 23949, -14373, -10948,
 23870, -14497, -10956,
 23777, -14609, -11010,
 23693, -14736, -11022,
 23626, -14867, -10990,
 23555, -15000, -10962,
 23478, -15127, -10952,
 23397, -15255, -10949,
 23307, -15377, -10970,
 23215, -15492, -11002,
 23124, -15611, -11027,
 23030, -15726, -11058,
 22945, -15851, -11059,
 22868, -15988, -11019,
 22776, -16160, -10960,
 22753, -16227, -10909,
 22668, -16354, -10895,
 22605, -16466, -10859,
 22572, -16588, -10739,
 22622, -16602, -10611,
 22630, -16636, -10542,
 22555, -16763, -10502,
 22455, -16893, -10508,
 22371, -16929, -10628,
 22274, -16999, -10719,
 22169, -17097, -10780,
 22071, -17155, -10889,
 22002, -17195, -10965,
 21914, -17221, -11101,
 21845, -17221, -11236,
 21760, -17243, -11366,
 21698, -17234, -11497,
 21662, -17182, -11642,
 21666, -17090, -11769,
 21656, -17009, -11903,
 21602, -16986, -12035,
 21560, -16949, -12162,
 21590, -16836, -12266,
 21571, -16763, -12398,
 21502, -16753, -12530,
 21435, -16741, -12660,
 21371, -16718, -12798,
 21302, -16706, -12928,
 21220, -16711, -13056,
 21123, -16729, -13189,
 21040, -16767, -13273,
 20978, -16741, -13403,
 20905, -16725, -13537,
 20813, -16755, -13641,
 20746, -16716, -13790,
 20744, -16615, -13915,
 20766, -16507, -14010,
 20797, -16389, -14103,
 20767, -16318, -14229,
 20698, -16287, -14364,
 20661, -16219, -14494,
 20615, -16160, -14625,
 20571, -16099, -14753,
 20531, -16031, -14883,
 20452, -16014, -15009,
 20351, -16034, -15125,
 20261, -16032, -15247,
 20179, -16017, -15371,
 20113, -15976, -15499,
 20041, -15940, -15629,
 19975, -15896, -15758,
 19916, -15842, -15887,
 19862, -15781, -16013,
 19785, -15749, -16141,
 19697, -15733, -16263,
 19606, -15721, -16385,
 19512, -15713, -16505,
 19411, -15719, -16617,
 19317, -15711, -16734,
 19239, -15677, -16854,
 19120, -15728, -16942,
 19003, -15794, -17013,
 18886, -15874, -17069,
 18782, -15900, -17160,
 18695, -15882, -17271,
 18573, -15950, -17339,
 18452, -15977, -17443,
 18366, -15975, -17535,
 18240, -16092, -17561,
 18128, -16136, -17635,
 18090, -16256, -17564,
 17992, -16386, -17544,
 17863, -16428, -17636,
 17756, -16527, -17652,
 17671, -16642, -17629,
 17547, -16740, -17660,
 17460, -16853, -17639,
 17380, -17009, -17569,
 17318, -17080, -17560,
 17145, -17152, -17660,
 17175, -17049, -17730,
 17150, -16964, -17835,
 17142, -16847, -17953,
 17111, -16757, -18067,
 17046, -16676, -18203,
 16976, -16635, -18305,
 16965, -16527, -18413,
 16976, -16410, -18508,
 16937, -16319, -18623,
 16973, -16193, -18701,
 16942, -16198, -18724,
 16858, -16321, -18694,
 16825, -16426, -18631,
 16768, -16556, -18566,
 16772, -16658, -18472,
 16783, -16762, -18367,
 16762, -16876, -18282,
 16711, -16998, -18216,
 16651, -17144, -18133,
 16735, -17174, -18027,
 16740, -17288, -17914,
 16634, -17285, -18015,
 16529, -17261, -18134,
 16527, -17152, -18239,
 16560, -17031, -18322,
 16573, -16890, -18441,
 16477, -16956, -18466,
 16355, -17077, -18463,
 16294, -17188, -18414,
 16251, -17313, -18335,
 16254, -17450, -18202,
 16135, -17468, -18289,
 16050, -17423, -18408,
 15967, -17370, -18530,
 15932, -17455, -18479,
 15925, -17505, -18438,
 15809, -17594, -18454,
 15738, -17648, -18462,
 15965, -17489, -18418,
 15931, -17515, -18424,
 15809, -17600, -18448,
 15696, -17699, -18449,
 15596, -17811, -18426,
 15509, -17927, -18387,
 15487, -18044, -18292,
 15412, -18161, -18239,
 15285, -18264, -18242,
 15171, -18353, -18249,
 15057, -18450, -18245,
 14929, -18496, -18304,
 14802, -18528, -18374,
 14664, -18619, -18393,
 14584, -18600, -18476,
 14448, -18618, -18564,
 14325, -18633, -18644,
 14191, -18696, -18683,
 14057, -18751, -18730,
 13922, -18800, -18781,
 13833, -18763, -18883,
 13783, -18682, -19001,
 13714, -18613, -19118,
 13678, -18537, -19217,
 13628, -18440, -19346,
 13519, -18500, -19364,
 13546, -18610, -19240,
 13478, -18660, -19239,
 13404, -18589, -19359,
 13321, -18650, -19358,
 13203, -18740, -19352,
 13085, -18812, -19362,
 12919, -18891, -19397,
 12952, -18810, -19453,
 12907, -18758, -19533,
 12801, -18727, -19632,
 12747, -18638, -19752,
 12694, -18554, -19865,
 12629, -18478, -19977,
 12538, -18425, -20084,
 12424, -18396, -20180,
 12297, -18391, -20262,
 12165, -18385, -20347,
 12047, -18373, -20428,
 11972, -18295, -20542,
 11930, -18210, -20642,
 11979, -18104, -20706,
 12024, -17992, -20778,
 12032, -17871, -20877,
 12048, -17753, -20969,
 12082, -17639, -21045,
 12080, -17521, -21145,
 12058, -17407, -21251,
 12026, -17300, -21356,
 11998, -17217, -21438,
 12016, -17094, -21527,
 12031, -16992, -21599,
 12008, -16866, -21711,
 11981, -16768, -21801,
 11997, -16620, -21905,
 11961, -16509, -22009,
 11932, -16417, -22094,
 11899, -16309, -22191,
 11801, -16225, -22304,
 11744, -16146, -22392,
 11689, -16052, -22488,
 11715, -15925, -22565,
 11669, -15812, -22668,
 11648, -15691, -22762,
 11651, -15567, -22846,
 11656, -15436, -22931,
 11708, -15309, -22990,
 11711, -15182, -23073,
 11703, -15057, -23158,
 11701, -14931, -23241,
 11710, -14802, -23319,
 11728, -14671, -23392,
 11711, -14546, -23479,
 11694, -14422, -23564,
 11740, -14291, -23621,
 11789, -14164, -23673,
 11862, -14037, -23712,
 11935, -13914, -23748,
 12033, -13794, -23768,
 12070, -13673, -23819,
 12096, -13529, -23888,
 12138, -13400, -23940,
 12175, -13270, -23993,
 12210, -13117, -24060,
 12304, -13005, -24072,
 12343, -12867, -24126,
 12473, -12772, -24110,
 12556, -12657, -24128,
 12650, -12552, -24134,
 12771, -12465, -24115,
 12863, -12330, -24135,
 12989, -12230, -24119,
 13096, -12199, -24077,
 13218, -12104, -24058,
 13350, -11994, -24040,
 13428, -11890, -24048,
 13480, -11751, -24087,
 13493, -11617, -24145,
 13584, -11477, -24161,
 13715, -11460, -24095,
 13846, -11354, -24070,
 13870, -11468, -24002,
 13957, -11454, -23959,
 14051, -11356, -23950,
 14124, -11220, -23971,
 14172, -11067, -24014,
 14250, -10962, -24016,
 14320, -10829, -24035,

/* 4 */
521, 1,
 -7056,  27453,   9826,
 -7008,  27479,   9786,
 -6906,  27476,   9868,
 -6777,  27515,   9847,
 -6668,  27554,   9813,
 -6519,  27617,   9737,
 -6391,  27674,   9659,
 -6282,  27725,   9585,
 -6167,  27762,   9551,
 -6012,  27799,   9543,
 -5938,  27852,   9434,
 -5908,  27905,   9294,
 -5874,  27910,   9302,
 -5858,  27863,   9452,
 -5827,  27834,   9554,
 -5680,  27843,   9616,
 -5581,  27860,   9627,
 -5494,  27876,   9631,
 -5399,  27877,   9682,
 -5237,  27901,   9701,
 -5109,  27917,   9723,
 -4959,  27937,   9745,
 -4809,  27958,   9759,
 -4662,  27998,   9715,
 -4550,  28035,   9661,
 -4412,  28071,   9621,
 -4271,  28106,   9581,
 -4135,  28146,   9522,
 -4011,  28174,   9496,
 -3910,  28205,   9445,
 -4096,  28213,   9339,
 -4197,  28233,   9234,
 -4300,  28252,   9129,
 -4443,  28238,   9102,
 -4591,  28228,   9062,
 -4734,  28194,   9094,
 -4808,  28209,   9009,
 -4593,  28241,   9018,
 -4516,  28266,   8980,
 -4685,  28263,   8902,
 -4792,  28271,   8819,
 -4841,  28276,   8778,
 -4681,  28310,   8754,
 -4592,  28359,   8640,
 -4520,  28372,   8637,
 -4416,  28357,   8741,
 -4272,  28377,   8746,
 -4155,  28413,   8686,
 -4189,  28448,   8553,
 -4327,  28454,   8466,
 -4427,  28463,   8382,
 -4453,  28465,   8360,
 -4347,  28492,   8326,
 -4393,  28523,   8195,
 -4384,  28538,   8145,
 -4317,  28505,   8298,
 -4266,  28467,   8453,
 -4151,  28459,   8536,
 -4078,  28428,   8674,
 -4010,  28406,   8776,
 -4017,  28356,   8932,
 -4040,  28308,   9075,
 -3977,  28273,   9210,
 -3850,  28285,   9227,
 -3795,  28309,   9176,
 -3712,  28281,   9295,
 -3654,  28327,   9177,
 -3626,  28375,   9040,
 -3586,  28429,   8885,
 -3614,  28457,   8782,
 -3595,  28481,   8711,
 -3657,  28491,   8653,
 -3609,  28529,   8549,
 -3690,  28560,   8411,
 -3750,  28587,   8290,
 -3867,  28586,   8240,
 -3916,  28585,   8219,
 -3760,  28626,   8150,
 -3826,  28656,   8013,
 -3973,  28645,   7981,
 -3998,  28662,   7905,
 -3815,  28670,   7966,
 -3731,  28699,   7902,
 -3847,  28715,   7789,
 -3966,  28711,   7744,
 -3889,  28748,   7642,
 -3742,  28736,   7763,
 -3591,  28772,   7700,
 -3579,  28804,   7586,
 -3479,  28791,   7678,
 -3373,  28800,   7694,
 -3268,  28780,   7812,
 -3271,  28777,   7822,
 -3401,  28776,   7769,
 -3322,  28734,   7958,
 -3190,  28744,   7974,
 -3069,  28758,   7971,
 -2963,  28778,   7939,
 -2928,  28818,   7808,
 -3066,  28829,   7713,
 -3116,  28808,   7770,
 -3106,  28854,   7601,
 -3037,  28891,   7491,
 -2961,  28909,   7448,
 -2823,  28897,   7550,
 -2736,  28876,   7660,
 -2635,  28909,   7573,
 -2688,  28928,   7478,
 -2802,  28940,   7391,
 -2790,  28981,   7233,
 -2875,  28988,   7174,
 -2723,  29010,   7142,
 -2808,  29039,   6989,
 -2793,  29050,   6948,
 -2709,  29027,   7077,
 -2587,  29011,   7189,
 -2492,  29048,   7072,
 -2471,  29082,   6936,
 -2558,  29102,   6820,
 -2633,  29107,   6770,
 -2454,  29131,   6734,
 -2568,  29141,   6648,
 -2632,  29173,   6481,
 -2591,  29200,   6374,
 -2452,  29216,   6356,
 -2327,  29225,   6361,
 -2195,  29210,   6477,
 -2101,  29233,   6407,
 -2120,  29265,   6250,
 -2226,  29273,   6176,
 -2275,  29291,   6069,
 -2194,  29310,   6009,
 -2116,  29313,   6022,
 -2241,  29334,   5872,
 -2350,  29317,   5915,
 -2255,  29361,   5732,
 -2172,  29393,   5599,
 -2111,  29420,   5477,
 -1978,  29444,   5397,
 -1870,  29472,   5282,
 -1832,  29502,   5128,
 -1722,  29522,   5047,
 -1595,  29539,   4992,
 -1616,  29555,   4890,
 -1767,  29544,   4901,
 -1829,  29537,   4924,
 -1698,  29566,   4792,
 -1546,  29565,   4850,
 -1423,  29580,   4797,
 -1444,  29596,   4691,
 -1587,  29595,   4648,
 -1670,  29598,   4598,
 -1442,  29610,   4599,
 -1287,  29616,   4609,
 -1185,  29636,   4508,
 -1061,  29654,   4418,
  -954,  29675,   4300,
  -998,  29693,   4162,
 -1118,  29702,   4070,
 -1269,  29694,   4080,
 -1388,  29674,   4188,
 -1530,  29674,   4134,
 -1674,  29655,   4213,
 -1795,  29635,   4305,
 -1914,  29615,   4391,
 -1981,  29606,   4425,
 -1838,  29637,   4271,
 -1738,  29658,   4173,
 -1642,  29680,   4049,
 -1584,  29702,   3910,
 -1648,  29711,   3816,
 -1765,  29692,   3909,
 -1906,  29677,   3958,
 -2002,  29672,   3947,
 -1811,  29701,   3816,
 -1901,  29709,   3708,
 -2059,  29704,   3665,
 -2192,  29698,   3639,
 -2280,  29695,   3603,
 -2073,  29719,   3534,
 -1910,  29721,   3610,
 -1779,  29719,   3689,
 -1631,  29727,   3695,
 -1491,  29738,   3664,
 -1420,  29755,   3552,
 -1505,  29765,   3428,
 -1578,  29770,   3356,
 -1578,  29783,   3233,
 -1713,  29782,   3178,
 -1842,  29781,   3113,
 -1980,  29774,   3099,
 -2083,  29771,   3056,
 -1922,  29782,   3052,
 -1782,  29786,   3097,
 -1647,  29786,   3175,
 -1537,  29797,   3123,
 -1632,  29806,   2992,
 -1726,  29812,   2873,
 -1869,  29811,   2796,
 -2004,  29807,   2741,
 -2098,  29803,   2720,
 -2191,  29793,   2748,
 -2232,  29780,   2854,
 -2353,  29769,   2876,
 -2384,  29786,   2672,
 -2452,  29788,   2585,
 -2592,  29777,   2573,
 -2661,  29769,   2596,
 -2567,  29766,   2714,
 -2482,  29762,   2839,
 -2487,  29749,   2973,
 -2529,  29743,   2990,
 -2559,  29754,   2856,
 -2638,  29762,   2697,
 -2719,  29754,   2700,
 -2752,  29737,   2856,
 -2799,  29725,   2933,
 -2961,  29702,   3005,
 -3025,  29697,   2985,
 -2997,  29715,   2830,
 -2997,  29729,   2683,
 -2993,  29743,   2532,
 -3089,  29735,   2509,
 -3175,  29715,   2637,
 -3267,  29698,   2711,
 -3327,  29687,   2755,
 -3343,  29703,   2559,
 -3478,  29687,   2565,
 -3286,  29722,   2406,
 -3319,  29727,   2300,
 -3420,  29721,   2224,
 -3573,  29708,   2158,
 -3673,  29686,   2287,
 -3735,  29668,   2426,
 -3748,  29666,   2427,
 -3701,  29683,   2278,
 -3649,  29700,   2137,
 -3769,  29690,   2070,
 -3897,  29667,   2158,
 -4053,  29644,   2187,
 -4149,  29638,   2090,
 -4224,  29627,   2099,
 -4385,  29610,   2008,
 -4520,  29593,   1962,
 -4678,  29569,   1953,
 -4744,  29550,   2071,
 -4662,  29554,   2195,
 -4642,  29555,   2230,
 -4801,  29529,   2238,
 -4932,  29502,   2307,
 -5081,  29476,   2312,
 -5196,  29461,   2244,
 -5275,  29456,   2132,
 -5411,  29436,   2061,
 -5543,  29418,   1964,
 -5635,  29407,   1860,
 -5769,  29385,   1803,
 -5895,  29358,   1838,
 -5980,  29331,   1984,
 -5977,  29323,   2101,
 -6008,  29311,   2179,
 -6086,  29289,   2257,
 -6014,  29295,   2371,
 -5930,  29302,   2496,
 -5903,  29300,   2584,
 -6028,  29272,   2614,
 -6081,  29274,   2456,
 -6164,  29259,   2433,
 -6127,  29251,   2620,
 -6133,  29248,   2638,
 -6178,  29252,   2479,
 -6215,  29256,   2331,
 -6284,  29252,   2197,
 -6406,  29225,   2200,
 -6420,  29214,   2303,
 -6397,  29216,   2350,
 -6453,  29192,   2483,
 -6469,  29182,   2557,
 -6629,  29151,   2505,
 -6697,  29123,   2651,
 -6695,  29108,   2812,
 -6657,  29113,   2848,
 -6575,  29133,   2838,
 -6536,  29131,   2941,
 -6522,  29125,   3033,
 -6422,  29139,   3108,
 -6331,  29145,   3239,
 -6303,  29135,   3378,
 -6299,  29118,   3533,
 -6314,  29096,   3683,
 -6328,  29075,   3822,
 -6392,  29045,   3942,
 -6478,  29019,   3995,
 -6558,  28982,   4127,
 -6604,  28948,   4289,
 -6679,  28910,   4427,
 -6767,  28881,   4481,
 -6841,  28859,   4511,
 -6887,  28824,   4663,
 -6983,  28788,   4743,
 -7069,  28741,   4896,
 -7175,  28701,   4976,
 -7247,  28656,   5130,
 -7361,  28617,   5188,
 -7448,  28597,   5171,
 -7479,  28575,   5245,
 -7579,  28536,   5318,
 -7763,  28486,   5317,
 -7848,  28440,   5437,
 -7801,  28428,   5564,
 -7672,  28460,   5582,
 -7576,  28490,   5562,
 -7441,  28542,   5475,
 -7383,  28567,   5423,
 -7467,  28508,   5615,
 -7496,  28475,   5745,
 -7466,  28468,   5817,
 -7590,  28435,   5818,
 -7518,  28436,   5906,
 -7612,  28407,   5923,
 -7591,  28404,   5963,
 -7633,  28385,   6001,
 -7629,  28367,   6089,
 -7688,  28323,   6223,
 -7761,  28283,   6312,
 -7829,  28255,   6351,
 -7869,  28277,   6205,
 -7867,  28310,   6053,
 -7920,  28325,   5912,
 -7998,  28330,   5781,
 -8103,  28297,   5798,
 -8126,  28260,   5945,
 -8078,  28243,   6087,
 -8087,  28208,   6240,
 -8033,  28192,   6377,
 -7961,  28193,   6466,
 -7933,  28177,   6568,
 -8051,  28133,   6614,
 -8142,  28093,   6672,
 -8228,  28045,   6767,
 -8298,  28013,   6814,
 -8426,  27973,   6821,
 -8523,  27932,   6866,
 -8641,  27922,   6758,
 -8749,  27906,   6688,
 -8849,  27870,   6704,
 -8755,  27862,   6859,
 -8637,  27888,   6904,
 -8607,  27885,   6952,
 -8695,  27835,   7042,
 -8700,  27806,   7150,
 -8783,  27826,   6969,
 -8844,  27839,   6839,
 -8894,  27843,   6757,
 -8947,  27838,   6706,
 -8988,  27804,   6793,
 -9136,  27766,   6751,
 -9192,  27732,   6815,
 -9031,  27773,   6865,
 -8902,  27796,   6937,
 -8866,  27784,   7031,
 -8766,  27785,   7154,
 -8759,  27776,   7195,
 -8845,  27752,   7184,
 -8808,  27736,   7291,
 -8890,  27733,   7202,
 -8946,  27748,   7073,
 -9005,  27764,   6932,
 -9101,  27749,   6868,
 -9271,  27705,   6818,
 -9324,  27670,   6887,
 -9207,  27682,   6997,
 -9101,  27691,   7098,
 -9030,  27683,   7219,
 -9015,  27653,   7350,
 -9009,  27650,   7371,
 -9072,  27664,   7241,
 -9112,  27685,   7106,
 -9222,  27674,   7007,
 -9340,  27658,   6912,
 -9418,  27629,   6926,
 -9419,  27603,   7027,
 -9356,  27588,   7166,
 -9482,  27551,   7144,
 -9533,  27517,   7206,
 -9655,  27497,   7119,
 -9720,  27448,   7222,
 -9575,  27479,   7296,
 -9433,  27520,   7328,
 -9290,  27564,   7345,
 -9147,  27601,   7382,
 -9026,  27620,   7460,
 -9032,  27612,   7482,
 -9138,  27587,   7448,
 -9292,  27556,   7371,
 -9438,  27512,   7349,
 -9581,  27473,   7310,
 -9720,  27433,   7277,
 -9782,  27398,   7325,
 -9697,  27397,   7441,
 -9644,  27397,   7509,
 -9828,  27362,   7397,
 -9845,  27334,   7480,
 -9860,  27302,   7576,
 -9730,  27330,   7640,
 -9594,  27359,   7711,
 -9570,  27348,   7779,
 -9735,  27323,   7660,
 -9870,  27281,   7636,
 -9939,  27242,   7688,
-10039,  27169,   7813,
-10011,  27164,   7867,
 -9960,  27172,   7903,
-10141,  27105,   7903,
-10215,  27042,   8025,
-10020,  27116,   8020,
 -9916,  27142,   8060,
 -9797,  27206,   7991,
 -9828,  27135,   8192,
 -9886,  27072,   8328,
 -9909,  27057,   8351,
 -9908,  27112,   8170,
 -9974,  27085,   8180,
-10009,  27057,   8232,
-10161,  27015,   8181,
-10237,  26997,   8147,
-10104,  27012,   8264,
-10057,  27009,   8330,
-10237,  26977,   8214,
-10307,  26944,   8234,
-10304,  26928,   8289,
-10411,  26881,   8307,
-10364,  26874,   8389,
-10352,  26868,   8424,
-10435,  26827,   8452,
-10413,  26815,   8517,
-10486,  26779,   8541,
-10461,  26749,   8663,
-10499,  26707,   8747,
-10439,  26723,   8769,
-10537,  26674,   8802,
-10667,  26591,   8896,
-10648,  26557,   9018,
-10661,  26522,   9108,
-10682,  26494,   9164,
-10628,  26501,   9204,
-10720,  26450,   9247,
-10662,  26460,   9284,
-10760,  26393,   9361,
-10703,  26376,   9475,
-10724,  26365,   9482,
-10801,  26325,   9504,
-10788,  26291,   9613,
-10751,  26281,   9680,
-10823,  26233,   9731,
-10858,  26196,   9790,
-10766,  26209,   9857,
-10640,  26214,   9982,
-10498,  26249,  10040,
-10382,  26271,  10101,
-10341,  26254,  10188,
-10487,  26198,  10182,
-10427,  26195,  10251,
-10524,  26140,  10293,
-10465,  26140,  10354,
-10468,  26122,  10397,
-10405,  26120,  10462,
-10525,  26044,  10533,
-10422,  26078,  10551,
-10548,  26002,  10614,
-10363,  26046,  10686,
-10284,  26015,  10837,
-10196,  26038,  10866,
-10192,  26088,  10750,
-10197,  26133,  10634,
-10071,  26124,  10775,
-10014,  26161,  10738,
 -9993,  26204,  10655,
 -9881,  26247,  10652,
 -9920,  26268,  10564,
 -9846,  26280,  10602,
 -9834,  26289,  10590,
 -9801,  26306,  10580,
 -9793,  26321,  10551,
 -9698,  26358,  10545,
 -9679,  26385,  10496,
 -9606,  26416,  10484,
 -9602,  26431,  10449,
 -9498,  26478,  10426,
 -9414,  26548,  10324,
 -9374,  26604,  10215,
 -9316,  26670,  10095,
 -9191,  26696,  10143,
 -9090,  26720,  10169,
 -9048,  26760,  10101,
 -8963,  26793,  10091,
 -8906,  26833,  10033,
 -8863,  26835,  10065,
 -8806,  26845,  10089,
 -8730,  26874,  10078,
 -8742,  26906,   9982,
 -8615,  26923,  10046,
 -8571,  26982,   9925,
 -8590,  27029,   9779,
 -8420,  27061,   9839,
 -8358,  27139,   9676,
 -8301,  27196,   9564,
 -8188,  27203,   9641,
 -8074,  27236,   9644,
 -7976,  27303,   9537,
 -7849,  27326,   9575,
 -7731,  27327,   9667,
 -7624,  27355,   9673,
 -7542,  27405,   9598,
 -7414,  27466,   9520,
 -7338,  27482,   9535,
 -7349,  27454,   9607,
 -7476,  27397,   9671,
 -7387,  27385,   9771,
 -7240,  27404,   9828,
 -7134,  27420,   9860,

/* 5 */
321, 1,
-10216,  27876,   4312,
-10249,  27875,   4236,
-10177,  27895,   4281,
-10179,  27910,   4175,
-10193,  27929,   4011,
-10154,  27941,   4027,
-10127,  27968,   3904,
-10062,  27976,   4015,
 -9977,  28007,   4006,
 -9969,  28029,   3870,
 -9898,  28049,   3909,
 -9890,  28064,   3824,
 -9862,  28067,   3872,
 -9858,  28048,   4020,
 -9822,  28038,   4168,
 -9731,  28072,   4158,
 -9726,  28094,   4013,
 -9749,  28106,   3871,
 -9823,  28108,   3672,
 -9784,  28113,   3732,
 -9683,  28132,   3848,
 -9586,  28147,   3984,
 -9475,  28188,   3961,
 -9392,  28234,   3827,
 -9472,  28215,   3763,
 -9594,  28181,   3714,
 -9743,  28144,   3601,
 -9703,  28158,   3603,
 -9528,  28208,   3674,
 -9541,  28217,   3572,
 -9679,  28178,   3508,
 -9648,  28190,   3498,
 -9526,  28226,   3541,
 -9397,  28255,   3656,
 -9295,  28286,   3672,
 -9249,  28321,   3515,
 -9336,  28310,   3377,
 -9392,  28304,   3264,
 -9614,  28231,   3253,
 -9531,  28261,   3237,
 -9532,  28269,   3165,
 -9490,  28284,   3152,
 -9379,  28312,   3238,
 -9221,  28363,   3239,
 -9272,  28356,   3154,
 -9413,  28326,   3004,
 -9294,  28366,   2995,
 -9185,  28391,   3092,
 -9055,  28439,   3044,
 -9015,  28466,   2895,
 -9096,  28448,   2821,
 -9276,  28395,   2769,
 -9168,  28437,   2697,
 -9235,  28421,   2641,
 -9214,  28430,   2620,
 -9057,  28478,   2637,
 -9083,  28476,   2570,
 -9258,  28425,   2513,
 -9175,  28456,   2468,
 -9103,  28482,   2434,
 -8976,  28514,   2527,
 -8898,  28547,   2428,
 -9062,  28505,   2312,
 -8969,  28534,   2319,
 -9015,  28527,   2224,
 -8986,  28536,   2225,
 -8888,  28558,   2335,
 -8764,  28597,   2325,
 -8728,  28619,   2184,
 -8690,  28641,   2048,
 -8705,  28646,   1902,
 -8821,  28617,   1806,
 -8952,  28565,   1968,
 -8954,  28574,   1830,
 -9122,  28515,   1922,
 -9092,  28532,   1811,
 -9010,  28561,   1750,
 -8952,  28586,   1644,
 -9005,  28572,   1592,
 -9102,  28546,   1514,
 -8994,  28584,   1444,
 -8910,  28610,   1441,
 -8772,  28651,   1482,
 -8634,  28695,   1428,
 -8525,  28732,   1338,
 -8388,  28775,   1282,
 -8327,  28798,   1170,
 -8367,  28791,   1026,
 -8496,  28757,    923,
 -8568,  28739,    803,
 -8684,  28703,    862,
 -8695,  28703,    736,
 -8790,  28671,    830,
 -8778,  28678,    727,
 -8889,  28645,    672,
 -9017,  28603,    753,
 -9135,  28562,    874,
 -9126,  28568,    775,
 -9223,  28539,    687,
 -9343,  28498,    739,
 -9419,  28470,    860,
 -9551,  28425,    885,
 -9707,  28373,    882,
 -9676,  28384,    839,
 -9724,  28373,    634,
 -9669,  28391,    686,
 -9587,  28415,    814,
 -9473,  28455,    747,
 -9360,  28495,    645,
 -9230,  28539,    581,
 -9085,  28585,    580,
 -8953,  28628,    539,
 -8818,  28670,    524,
 -8682,  28710,    572,
 -8544,  28751,    628,
 -8425,  28784,    720,
 -8336,  28810,    682,
 -8330,  28815,    530,
 -8377,  28804,    387,
 -8469,  28778,    270,
 -8606,  28739,    182,
 -8722,  28704,    122,
 -8872,  28658,     91,
 -9005,  28617,     40,
 -9147,  28572,     28,
 -9265,  28533,      8,
 -9412,  28485,     13,
 -9559,  28436,     16,
 -9628,  28413,    143,
 -9645,  28406,    302,
 -9742,  28371,    433,
 -9772,  28362,    290,
 -9756,  28369,    130,
 -9884,  28325,    132,
-10007,  28281,    216,
-10094,  28249,    339,
-10089,  28249,    467,
-10041,  28264,    575,
-10067,  28254,    616,
-10188,  28209,    677,
-10204,  28200,    799,
-10200,  28197,    949,
-10218,  28185,   1110,
-10202,  28184,   1257,
-10235,  28164,   1420,
-10093,  28220,   1326,
-10125,  28204,   1415,
-10219,  28161,   1587,
-10132,  28196,   1530,
-10099,  28204,   1593,
-10115,  28189,   1749,
-10146,  28169,   1883,
-10069,  28189,   2003,
 -9845,  28275,   1896,
 -9895,  28250,   2002,
 -9940,  28226,   2123,
-10083,  28169,   2204,
-10087,  28163,   2256,
-10099,  28153,   2332,
-10162,  28123,   2419,
-10250,  28082,   2516,
-10339,  28038,   2639,
-10436,  28012,   2538,
-10562,  27964,   2544,
-10458,  27990,   2677,
-10397,  28001,   2798,
-10475,  27966,   2865,
-10523,  27933,   3001,
-10530,  27924,   3060,
-10628,  27877,   3150,
-10668,  27850,   3254,
-10792,  27792,   3340,
-10902,  27737,   3430,
-11021,  27680,   3512,
-11142,  27633,   3502,
-11281,  27581,   3467,
-11307,  27555,   3591,
-11279,  27544,   3757,
-11114,  27604,   3810,
-11137,  27577,   3933,
-11156,  27550,   4066,
-11205,  27510,   4203,
-11326,  27459,   4210,
-11384,  27459,   4052,
-11511,  27421,   3950,
-11439,  27458,   3902,
-11329,  27515,   3819,
-11307,  27544,   3668,
-11336,  27552,   3519,
-11409,  27536,   3408,
-11537,  27490,   3343,
-11671,  27443,   3270,
-11777,  27386,   3359,
-11896,  27318,   3492,
-11975,  27296,   3399,
-12063,  27272,   3276,
-12149,  27252,   3118,
-12223,  27212,   3178,
-12327,  27161,   3214,
-12312,  27172,   3180,
-12207,  27227,   3110,
-12167,  27260,   2971,
-12159,  27284,   2786,
-12256,  27246,   2732,
-12378,  27199,   2648,
-12514,  27139,   2623,
-12635,  27077,   2679,
-12692,  27039,   2798,
-12700,  27020,   2938,
-12647,  27032,   3050,
-12545,  27067,   3167,
-12494,  27080,   3252,
-12472,  27070,   3413,
-12336,  27139,   3359,
-12327,  27139,   3398,
-12400,  27088,   3532,
-12343,  27097,   3663,
-12423,  27052,   3721,
-12506,  26999,   3830,
-12582,  26945,   3956,
-12622,  26908,   4081,
-12632,  26881,   4222,
-12750,  26831,   4189,
-12833,  26782,   4249,
-12859,  26743,   4409,
-12902,  26704,   4520,
-12897,  26675,   4702,
-12900,  26651,   4827,
-12970,  26596,   4944,
-12991,  26559,   5083,
-12970,  26538,   5243,
-12951,  26518,   5389,
-12948,  26489,   5539,
-12939,  26460,   5697,
-12831,  26513,   5695,
-12757,  26569,   5597,
-12680,  26631,   5479,
-12647,  26673,   5348,
-12599,  26725,   5201,
-12570,  26761,   5083,
-12504,  26817,   4950,
-12423,  26880,   4811,
-12365,  26894,   4879,
-12410,  26845,   5032,
-12341,  26877,   5030,
-12336,  26873,   5064,
-12401,  26815,   5212,
-12453,  26766,   5340,
-12418,  26778,   5362,
-12412,  26778,   5375,
-12448,  26735,   5506,
-12445,  26708,   5638,
-12496,  26658,   5764,
-12448,  26675,   5789,
-12354,  26721,   5778,
-12243,  26785,   5714,
-12095,  26874,   5611,
-12146,  26822,   5746,
-12040,  26874,   5729,
-11947,  26939,   5620,
-11901,  26979,   5522,
-11797,  27045,   5420,
-11737,  27089,   5332,
-11678,  27137,   5214,
-11671,  27170,   5057,
-11610,  27217,   4946,
-11514,  27279,   4827,
-11469,  27319,   4705,
-11424,  27352,   4622,
-11300,  27425,   4490,
-11301,  27413,   4562,
-11315,  27388,   4676,
-11230,  27420,   4694,
-11126,  27488,   4540,
-11113,  27481,   4616,
-11049,  27509,   4601,
-10989,  27523,   4664,
-11049,  27476,   4797,
-11028,  27457,   4950,
-11098,  27423,   4984,
-11097,  27406,   5078,
-10928,  27456,   5171,
-11004,  27424,   5182,
-11144,  27379,   5120,
-11221,  27331,   5207,
-11267,  27303,   5257,
-11319,  27259,   5369,
-11343,  27225,   5492,
-11367,  27191,   5609,
-11319,  27200,   5658,
-11198,  27263,   5599,
-11057,  27337,   5518,
-11016,  27333,   5615,
-10942,  27355,   5655,
-10834,  27410,   5594,
-10778,  27416,   5676,
-10707,  27468,   5556,
-10615,  27480,   5672,
-10541,  27515,   5642,
-10459,  27543,   5657,
-10375,  27597,   5548,
-10430,  27594,   5458,
-10522,  27569,   5408,
-10495,  27586,   5373,
-10561,  27579,   5280,
-10534,  27594,   5255,
-10366,  27659,   5245,
-10443,  27643,   5178,
-10532,  27636,   5032,
-10470,  27665,   5006,
-10373,  27698,   5025,
-10268,  27754,   4929,
-10290,  27765,   4821,
-10229,  27797,   4767,
-10320,  27770,   4726,
-10290,  27788,   4686,
-10341,  27778,   4629,
-10262,  27816,   4581,
-10326,  27798,   4544,
-10303,  27818,   4472,
-10273,  27852,   4327,

/* 6 */
232, 1,
 18592,  -4797, -23051,
 18486,  -4782, -23139,
 18366,  -4806, -23230,
 18247,  -4798, -23324,
 18129,  -4791, -23417,
 18009,  -4843, -23499,
 17901,  -4823, -23586,
 17804,  -4747, -23674,
 17695,  -4684, -23769,
 17705,  -4542, -23788,
 17800,  -4435, -23738,
 17918,  -4377, -23660,
 18035,  -4352, -23576,
 18164,  -4297, -23486,
 18128,  -4297, -23514,
 18021,  -4327, -23591,
 17901,  -4336, -23680,
 17783,  -4323, -23771,
 17649,  -4288, -23878,
 17685,  -4168, -23872,
 17672,  -4156, -23883,
 17526,  -4157, -23991,
 17587,  -3953, -23981,
 17538,  -3986, -24011,
 17419,  -4051, -24086,
 17320,  -4013, -24164,
 17245,  -3969, -24225,
 17123,  -4009, -24305,
 17012,  -4079, -24371,
 16892,  -4123, -24447,
 16761,  -4146, -24533,
 16669,  -4183, -24590,
 16553,  -4263, -24654,
 16475,  -4390, -24684,
 16389,  -4516, -24718,
 16326,  -4636, -24738,
 16193,  -4736, -24806,
 16146,  -4848, -24815,
 16048,  -4945, -24860,
 15938,  -5028, -24914,
 15857,  -5158, -24939,
 15740,  -5244, -24995,
 15617,  -5273, -25066,
 15493,  -5295, -25138,
 15348,  -5299, -25226,
 15231,  -5340, -25289,
 15100,  -5351, -25364,
 14977,  -5385, -25430,
 14792,  -5442, -25526,
 14745,  -5517, -25537,
 14617,  -5558, -25602,
 14494,  -5526, -25679,
 14534,  -5419, -25679,
 14434,  -5361, -25747,
 14479,  -5336, -25727,
 14606,  -5305, -25661,
 14733,  -5255, -25600,
 14851,  -5188, -25545,
 14820,  -5072, -25586,
 14892,  -5013, -25556,
 15023,  -4995, -25482,
 15140,  -4908, -25430,
 15146,  -4732, -25460,
 15284,  -4723, -25379,
 15413,  -4732, -25299,
 15490,  -4616, -25274,
 15568,  -4498, -25247,
 15632,  -4379, -25228,
 15688,  -4231, -25219,
 15802,  -4156, -25160,
 15909,  -4071, -25107,
 16002,  -3969, -25063,
 16112,  -3880, -25007,
 16175,  -3724, -24990,
 16237,  -3588, -24969,
 16151,  -3517, -25035,
 16022,  -3524, -25117,
 15887,  -3494, -25207,
 15867,  -3363, -25237,
 15943,  -3244, -25205,
 16038,  -3136, -25158,
 16162,  -3111, -25082,
 16285,  -3069, -25008,
 16401,  -3005, -24939,
 16518,  -2931, -24871,
 16640,  -2892, -24794,
 16772,  -2856, -24709,
 16801,  -2716, -24705,
 16809,  -2563, -24716,
 16890,  -2447, -24673,
 16979,  -2337, -24622,
 17095,  -2286, -24547,
 17195,  -2190, -24485,
 17295,  -2108, -24422,
 17390,  -2016, -24362,
 17516,  -2003, -24273,
 17630,  -1949, -24195,
 17734,  -1866, -24125,
 17841,  -1789, -24052,
 17963,  -1761, -23963,
 18082,  -1731, -23875,
 18199,  -1687, -23789,
 18314,  -1635, -23705,
 18425,  -1577, -23623,
 18536,  -1518, -23539,
 18646,  -1452, -23457,
 18755,  -1390, -23374,
 18870,  -1364, -23282,
 18976,  -1335, -23198,
 19092,  -1273, -23106,
 19200,  -1241, -23018,
 19315,  -1239, -22922,
 19425,  -1190, -22831,
 19531,  -1123, -22744,
 19636,  -1058, -22656,
 19743,  -1001, -22566,
 19844,   -926, -22480,
 19953,   -880, -22386,
 20057,   -820, -22295,
 20159,   -787, -22204,
 20261,   -849, -22108,
 20360,   -920, -22014,
 20380,  -1034, -21990,
 20434,  -1116, -21936,
 20536,  -1168, -21838,
 20647,  -1168, -21733,
 20706,  -1277, -21671,
 20771,  -1392, -21602,
 20834,  -1502, -21533,
 20897,  -1616, -21464,
 20973,  -1718, -21382,
 21066,  -1766, -21286,
 21177,  -1732, -21179,
 21239,  -1631, -21124,
 21280,  -1525, -21091,
 21331,  -1347, -21051,
 21380,  -1421, -20997,
 21427,  -1368, -20952,
 21487,  -1243, -20899,
 21515,  -1097, -20878,
 21528,   -946, -20872,
 21502,   -814, -20904,
 21495,   -667, -20917,
 21544,   -508, -20871,
 21570,   -407, -20847,
 21670,   -388, -20743,
 21776,   -381, -20631,
 21869,   -301, -20534,
 21963,   -240, -20435,
 22062,   -194, -20328,
 22165,   -194, -20216,
 22257,   -253, -20114,
 22336,   -348, -20025,
 22438,   -395, -19909,
 22533,   -439, -19801,
 22560,   -583, -19766,
 22626,   -690, -19687,
 22600,   -770, -19715,
 22511,   -760, -19816,
 22398,   -800, -19942,
 22319,   -843, -20029,
 22294,   -969, -20050,
 22246,  -1086, -20099,
 22150,  -1172, -20199,
 22046,  -1179, -20312,
 21943,  -1186, -20423,
 21839,  -1164, -20536,
 21730,  -1165, -20650,
 21635,  -1124, -20753,
 21596,  -1197, -20789,
 21643,  -1332, -20732,
 21749,  -1350, -20620,
 21798,  -1315, -20569,
 21890,  -1293, -20473,
 21960,  -1401, -20392,
 22043,  -1446, -20299,
 22137,  -1417, -20198,
 22248,  -1462, -20072,
 22197,  -1542, -20123,
 22098,  -1599, -20227,
 22020,  -1711, -20303,
 21952,  -1809, -20368,
 21969,  -1931, -20338,
 21944,  -2081, -20350,
 21859,  -2136, -20436,
 21769,  -2084, -20537,
 21735,  -1957, -20585,
 21699,  -1810, -20637,
 21626,  -1616, -20729,
 21647,  -1690, -20702,
 21632,  -1881, -20700,
 21553,  -1973, -20774,
 21449,  -2038, -20876,
 21347,  -2075, -20976,
 21226,  -2059, -21100,
 21260,  -2112, -21061,
 21199,  -2236, -21109,
 21099,  -2312, -21201,
 20994,  -2327, -21304,
 20884,  -2348, -21409,
 20778,  -2380, -21509,
 20676,  -2441, -21599,
 20572,  -2494, -21693,
 20464,  -2557, -21787,
 20362,  -2582, -21880,
 20261,  -2627, -21968,
 20150,  -2706, -22060,
 20050,  -2787, -22141,
 19963,  -2881, -22208,
 19874,  -3016, -22269,
 19836,  -3154, -22284,
 19789,  -3295, -22306,
 19675,  -3451, -22383,
 19635,  -3534, -22405,
 19514,  -3607, -22498,
 19531,  -3608, -22484,
 19661,  -3617, -22369,
 19515,  -3753, -22474,
 19605,  -3761, -22394,
 19596,  -3816, -22393,
 19506,  -3935, -22451,
 19503,  -4078, -22428,
 19520,  -4254, -22380,
 19416,  -4204, -22480,
 19370,  -4243, -22512,
 19261,  -4256, -22603,
 19094,  -4188, -22757,
 19069,  -4299, -22757,
 18965,  -4403, -22824,
 18871,  -4504, -22883,
 18787,  -4620, -22929,
 18691,  -4722, -22986,

/* 7 */
154, 1,
 26493,   2257, -13893,
 26417,   2226, -14042,
 26343,   2263, -14176,
 26277,   2342, -14284,
 26334,   2467, -14158,
 26332,   2589, -14140,
 26262,   2599, -14267,
 26191,   2606, -14397,
 26117,   2655, -14522,
 26062,   2759, -14599,
 26105,   2834, -14508,
 26159,   2869, -14403,
 26216,   2942, -14286,
 26269,   3031, -14169,
 26342,   2993, -14040,
 26338,   3075, -14030,
 26373,   3124, -13954,
 26438,   3084, -13838,
 26443,   3116, -13823,
 26412,   3256, -13849,
 26403,   3389, -13834,
 26456,   3451, -13718,
 26482,   3584, -13633,
 26520,   3612, -13552,
 26579,   3522, -13459,
 26604,   3610, -13386,
 26651,   3461, -13332,
 26707,   3344, -13250,
 26755,   3251, -13176,
 26797,   3121, -13122,
 26847,   2986, -13051,
 26912,   2904, -12935,
 26962,   2859, -12841,
 26969,   2745, -12850,
 26973,   2632, -12865,
 27039,   2568, -12740,
 27084,   2587, -12639,
 27150,   2549, -12504,
 27207,   2456, -12400,
 27269,   2404, -12273,
 27323,   2354, -12161,
 27356,   2201, -12117,
 27402,   2081, -12034,
 27454,   1980, -11932,
 27496,   1860, -11853,
 27541,   1742, -11766,
 27587,   1640, -11674,
 27645,   1596, -11541,
 27703,   1560, -11407,
 27760,   1523, -11272,
 27817,   1501, -11133,
 27871,   1447, -11006,
 27897,   1314, -10957,
 27922,   1239, -10901,
 27940,   1118, -10866,
 27969,    962, -10809,
 27975,    838, -10804,
 27966,    736, -10833,
 28047,    797, -10618,
 28093,    875, -10489,
 28133,    900, -10378,
 28190,    903, -10222,
 28229,    997, -10105,
 28255,   1047, -10028,
 28297,    952,  -9919,
 28330,    831,  -9836,
 28339,    680,  -9820,
 28368,    562,  -9745,
 28381,    407,  -9713,
 28377,    249,  -9731,
 28358,    137,  -9787,
 28330,     11,  -9869,
 28344,   -135,  -9829,
 28332,   -280,  -9859,
 28300,   -363,  -9947,
 28290,   -460,  -9973,
 28240,   -495, -10111,
 28202,   -604, -10212,
 28173,   -734, -10282,
 28180,   -891, -10250,
 28172,  -1001, -10264,
 28150,  -1140, -10310,
 28128,  -1307, -10350,
 28120,  -1433, -10354,
 28094,  -1544, -10408,
 28037,  -1560, -10560,
 27994,  -1563, -10673,
 27938,  -1574, -10815,
 27887,  -1546, -10951,
 27844,  -1524, -11064,
 27827,  -1502, -11108,
 27807,  -1663, -11135,
 27781,  -1822, -11177,
 27720,  -1745, -11339,
 27659,  -1784, -11481,
 27609,  -1725, -11609,
 27577,  -1625, -11698,
 27551,  -1591, -11764,
 27499,  -1684, -11874,
 27443,  -1713, -11997,
 27408,  -1812, -12063,
 27355,  -1748, -12193,
 27311,  -1733, -12292,
 27255,  -1806, -12406,
 27221,  -1939, -12460,
 27208,  -2093, -12465,
 27175,  -2167, -12524,
 27119,  -2097, -12655,
 27064,  -2038, -12783,
 27006,  -1983, -12913,
 26950,  -1916, -13039,
 26912,  -1821, -13131,
 26885,  -1691, -13204,
 26889,  -1580, -13210,
 26869,  -1512, -13257,
 26847,  -1341, -13322,
 26808,  -1226, -13410,
 26836,  -1143, -13361,
 26856,  -1081, -13326,
 26866,   -918, -13319,
 26819,   -776, -13421,
 26783,   -653, -13500,
 26771,   -612, -13525,
 26711,   -593, -13644,
 26663,   -467, -13744,
 26604,   -404, -13859,
 26600,   -259, -13871,
 26619,   -113, -13836,
 26611,     46, -13851,
 26594,    190, -13882,
 26562,    326, -13942,
 26511,    422, -14036,
 26491,    498, -14071,
 26486,    537, -14079,
 26421,    448, -14204,
 26353,    433, -14330,
 26280,    443, -14463,
 26254,    548, -14506,
 26307,    656, -14405,
 26368,    749, -14289,
 26423,    836, -14181,
 26476,    931, -14077,
 26508,   1063, -14007,
 26458,   1200, -14090,
 26490,   1333, -14019,
 26528,   1473, -13932,
 26551,   1571, -13877,
 26600,   1698, -13768,
 26606,   1814, -13742,
 26626,   1897, -13691,
 26540,   1925, -13853,
 26493,   1978, -13935,
 26531,   2077, -13849,
 26551,   2165, -13797,

/* 8 */
165, 1,
 -3761,  29749,    925,
 -3656,  29765,    837,
 -3636,  29770,    722,
 -3716,  29761,    685,
 -3745,  29758,    654,
 -3792,  29754,    574,
 -3902,  29740,    533,
 -4038,  29721,    614,
 -4138,  29704,    746,
 -4137,  29705,    716,
 -4065,  29718,    547,
 -4032,  29724,    476,
 -3937,  29738,    360,
 -4008,  29730,    290,
 -4171,  29707,    338,
 -4171,  29708,    232,
 -4162,  29710,    103,
 -4309,  29689,    -50,
 -4419,  29673,    -19,
 -4426,  29672,    116,
 -4479,  29664,     55,
 -4601,  29645,     20,
 -4664,  29635,    115,
 -4581,  29646,    328,
 -4665,  29634,    284,
 -4726,  29625,    103,
 -4854,  29604,    176,
 -4783,  29615,    272,
 -4663,  29633,    359,
 -4592,  29642,    539,
 -4623,  29637,    505,
 -4693,  29628,    372,
 -4835,  29606,    296,
 -4911,  29593,    368,
 -4829,  29604,    529,
 -4815,  29605,    624,
 -4823,  29600,    745,
 -4712,  29615,    849,
 -4560,  29639,    875,
 -4406,  29659,    969,
 -4453,  29652,    960,
 -4609,  29630,    919,
 -4634,  29622,   1043,
 -4675,  29616,   1026,
 -4766,  29605,    901,
 -4806,  29597,    951,
 -4835,  29593,    935,
 -4902,  29586,    806,
 -4980,  29577,    656,
 -5090,  29558,    660,
 -5203,  29536,    762,
 -5299,  29515,    878,
 -5345,  29508,    843,
 -5287,  29521,    750,
 -5169,  29544,    656,
 -5065,  29564,    544,
 -5041,  29571,    393,
 -5109,  29560,    306,
 -5239,  29537,    362,
 -5359,  29515,    418,
 -5473,  29492,    509,
 -5631,  29461,    584,
 -5713,  29445,    600,
 -5698,  29443,    797,
 -5811,  29422,    753,
 -5786,  29430,    635,
 -5767,  29437,    484,
 -5838,  29424,    344,
 -5966,  29399,    291,
 -6131,  29365,    287,
 -6123,  29365,    423,
 -6004,  29388,    534,
 -6072,  29374,    567,
 -6158,  29356,    569,
 -6277,  29331,    541,
 -6396,  29304,    585,
 -6426,  29295,    705,
 -6221,  29337,    790,
 -6292,  29322,    798,
 -6450,  29289,    738,
 -6530,  29273,    666,
 -6515,  29279,    525,
 -6405,  29305,    456,
 -6299,  29329,    353,
 -6342,  29321,    215,
 -6483,  29290,    249,
 -6597,  29264,    336,
 -6669,  29248,    313,
 -6715,  29238,    171,
 -6841,  29210,     72,
 -6991,  29174,     76,
 -6959,  29181,    166,
 -7016,  29167,    259,
 -7001,  29169,    407,
 -7065,  29151,    529,
 -7015,  29161,    644,
 -6926,  29179,    767,
 -6896,  29182,    911,
 -6923,  29172,   1031,
 -7043,  29140,   1132,
 -7013,  29142,   1251,
 -6887,  29167,   1360,
 -6796,  29185,   1444,
 -6652,  29218,   1429,
 -6663,  29221,   1322,
 -6572,  29244,   1254,
 -6560,  29252,   1130,
 -6560,  29258,    968,
 -6445,  29284,    943,
 -6448,  29282,    994,
 -6497,  29266,   1133,
 -6451,  29270,   1279,
 -6318,  29296,   1347,
 -6157,  29332,   1304,
 -6088,  29340,   1454,
 -5988,  29359,   1470,
 -5913,  29372,   1521,
 -5816,  29395,   1450,
 -5756,  29403,   1518,
 -5624,  29430,   1506,
 -5589,  29443,   1365,
 -5651,  29438,   1214,
 -5609,  29448,   1173,
 -5525,  29461,   1240,
 -5475,  29466,   1322,
 -5480,  29458,   1478,
 -5419,  29472,   1422,
 -5435,  29478,   1230,
 -5357,  29491,   1263,
 -5321,  29491,   1401,
 -5246,  29498,   1529,
 -5113,  29525,   1468,
 -5092,  29525,   1538,
 -5048,  29524,   1688,
 -4896,  29553,   1634,
 -4729,  29577,   1686,
 -4637,  29587,   1760,
 -4492,  29608,   1783,
 -4353,  29626,   1826,
 -4203,  29645,   1865,
 -4052,  29663,   1912,
 -4041,  29670,   1834,
 -4158,  29660,   1739,
 -4306,  29645,   1613,
 -4258,  29652,   1626,
 -4117,  29666,   1722,
 -4080,  29678,   1612,
 -4060,  29678,   1655,
 -3959,  29684,   1782,
 -3854,  29693,   1870,
 -3700,  29708,   1930,
 -3555,  29725,   1943,
 -3478,  29742,   1814,
 -3412,  29756,   1708,
 -3391,  29765,   1587,
 -3521,  29757,   1461,
 -3445,  29765,   1466,
 -3404,  29774,   1380,
 -3427,  29779,   1221,
 -3460,  29778,   1136,
 -3569,  29767,   1084,
 -3544,  29773,   1009,
 -3536,  29778,    870,
 -3626,  29768,    859,
 -3750,  29750,    942,

/* 9 */
141, -1,
-21883,  20471,   1436,
-21818,  20543,   1406,
-21731,  20639,   1341,
-21631,  20744,   1330,
-21524,  20855,   1327,
-21422,  20957,   1381,
-21313,  21066,   1398,
-21221,  21156,   1458,
-21120,  21246,   1585,
-21185,  21178,   1642,
-21149,  21209,   1699,
-21040,  21315,   1719,
-20961,  21385,   1817,
-20850,  21489,   1868,
-20858,  21468,   2018,
-20896,  21418,   2153,
-20932,  21369,   2289,
-20975,  21312,   2419,
-21067,  21217,   2450,
-21178,  21102,   2487,
-21289,  20991,   2484,
-21379,  20907,   2418,
-21471,  20823,   2321,
-21568,  20723,   2319,
-21552,  20726,   2442,
-21459,  20812,   2518,
-21405,  20851,   2661,
-21467,  20773,   2768,
-21566,  20665,   2809,
-21665,  20555,   2847,
-21722,  20483,   2937,
-21645,  20546,   3063,
-21552,  20632,   3137,
-21447,  20743,   3121,
-21340,  20855,   3108,
-21234,  20957,   3147,
-21135,  21046,   3220,
-21029,  21153,   3211,
-20929,  21269,   3104,
-20905,  21279,   3188,
-20987,  21183,   3291,
-21051,  21107,   3366,
-21059,  21077,   3501,
-21074,  21035,   3661,
-20958,  21136,   3744,
-20898,  21200,   3723,
-20804,  21306,   3637,
-20743,  21384,   3528,
-20680,  21460,   3435,
-20607,  21546,   3334,
-20604,  21572,   3183,
-20604,  21594,   3032,
-20595,  21623,   2878,
-20593,  21645,   2723,
-20608,  21648,   2584,
-20616,  21657,   2438,
-20609,  21681,   2287,
-20581,  21721,   2149,
-20538,  21775,   2010,
-20447,  21864,   1980,
-20374,  21938,   1903,
-20255,  22049,   1896,
-20167,  22138,   1792,
-20049,  22246,   1781,
-20025,  22277,   1657,
-20038,  22276,   1507,
-19978,  22337,   1391,
-19878,  22430,   1322,
-19768,  22531,   1256,
-19740,  22562,   1129,
-19742,  22567,    979,
-19716,  22597,    826,
-19682,  22631,    661,
-19807,  22524,    566,
-19879,  22464,    433,
-19882,  22464,    316,
-19979,  22378,    255,
-20060,  22306,    166,
-20124,  22249,     35,
-20167,  22210,   -105,
-20210,  22170,   -245,
-20277,  22107,   -365,
-20358,  22030,   -470,
-20432,  21959,   -582,
-20514,  21878,   -712,
-20559,  21839,   -638,
-20523,  21876,   -483,
-20488,  21912,   -344,
-20563,  21842,   -311,
-20597,  21811,   -242,
-20601,  21808,    -92,
-20547,  21859,     40,
-20516,  21888,    182,
-20465,  21933,    317,
-20397,  21994,    461,
-20488,  21908,    547,
-20490,  21903,    625,
-20486,  21902,    770,
-20548,  21841,    880,
-20615,  21772,    994,
-20628,  21752,   1154,
-20590,  21781,   1281,
-20534,  21826,   1413,
-20518,  21830,   1565,
-20480,  21852,   1740,
-20560,  21771,   1816,
-20569,  21750,   1969,
-20606,  21704,   2080,
-20697,  21609,   2160,
-20739,  21577,   2082,
-20763,  21566,   1941,
-20763,  21577,   1817,
-20739,  21612,   1669,
-20793,  21571,   1529,
-20820,  21556,   1378,
-20905,  21479,   1270,
-20896,  21491,   1233,
-20882,  21509,   1144,
-20899,  21496,   1068,
-20996,  21405,    997,
-21093,  21313,    927,
-21190,  21219,    857,
-21316,  21096,    765,
-21279,  21128,    918,
-21389,  21015,    936,
-21494,  20908,    916,
-21596,  20805,    863,
-21699,  20698,    853,
-21799,  20594,    812,
-21902,  20486,    812,
-22001,  20377,    846,
-22104,  20265,    846,
-22206,  20153,    859,
-22296,  20051,    920,
-22381,  19952,    996,
-22384,  19942,   1136,
-22326,  19999,   1264,
-22239,  20090,   1346,
-22145,  20189,   1411,
-22045,  20296,   1446,
-21943,  20406,   1449,

/* 10 */
132, 1,
 25827,  -2922, -14981,
 25764,  -2899, -15093,
 25783,  -2759, -15088,
 25804,  -2618, -15077,
 25788,  -2480, -15127,
 25801,  -2327, -15128,
 25816,  -2177, -15126,
 25822,  -2028, -15137,
 25819,  -1884, -15159,
 25835,  -1726, -15152,
 25877,  -1585, -15096,
 25833,  -1473, -15182,
 25773,  -1390, -15291,
 25698,  -1398, -15417,
 25670,  -1500, -15453,
 25666,  -1668, -15443,
 25695,  -1812, -15378,
 25644,  -1936, -15448,
 25581,  -2032, -15539,
 25504,  -2118, -15655,
 25494,  -2243, -15654,
 25498,  -2403, -15623,
 25442,  -2509, -15698,
 25350,  -2511, -15845,
 25321,  -2367, -15913,
 25246,  -2322, -16040,
 25165,  -2307, -16167,
 25132,  -2193, -16235,
 25193,  -2114, -16150,
 25235,  -2009, -16098,
 25312,  -1902, -15990,
 25306,  -1753, -16017,
 25296,  -1634, -16045,
 25346,  -1506, -15979,
 25409,  -1390, -15890,
 25452,  -1255, -15831,
 25510,  -1150, -15745,
 25592,  -1004, -15621,
 25531,   -995, -15722,
 25470,   -893, -15827,
 25395,   -840, -15950,
 25326,   -768, -16062,
 25273,   -656, -16151,
 25225,   -539, -16230,
 25161,   -464, -16332,
 25080,   -511, -16453,
 25038,   -387, -16521,
 25107,   -300, -16418,
 25196,   -354, -16281,
 25251,   -406, -16194,
 25331,   -398, -16068,
 25403,   -451, -15953,
 25477,   -496, -15833,
 25554,   -453, -15709,
 25620,   -555, -15598,
 25663,   -677, -15522,
 25724,   -730, -15419,
 25799,   -692, -15294,
 25837,   -551, -15237,
 25900,   -469, -15133,
 25952,   -354, -15045,
 25972,   -208, -15014,
 25973,    -58, -15014,
 25946,     83, -15059,
 25902,    207, -15134,
 25834,    274, -15249,
 25760,    240, -15374,
 25684,    230, -15501,
 25603,    252, -15634,
 25530,    263, -15753,
 25455,    234, -15874,
 25376,    252, -15999,
 25289,    258, -16137,
 25217,    255, -16249,
 25133,    238, -16380,
 25061,    162, -16490,
 24976,    154, -16618,
 24892,    172, -16744,
 24809,    199, -16866,
 24730,    261, -16981,
 24684,    380, -17046,
 24622,    491, -17133,
 24565,    605, -17210,
 24517,    745, -17273,
 24534,    871, -17243,
 24605,    825, -17143,
 24679,    712, -17042,
 24725,    622, -16979,
 24793,    530, -16882,
 24873,    459, -16767,
 24955,    448, -16645,
 25036,    472, -16521,
 25113,    494, -16403,
 25196,    458, -16278,
 25274,    503, -16155,
 25353,    532, -16030,
 25433,    552, -15901,
 25510,    562, -15777,
 25582,    620, -15658,
 25645,    661, -15553,
 25726,    694, -15418,
 25764,    586, -15358,
 25813,    463, -15280,
 25886,    468, -15156,
 25939,    408, -15067,
 25981,    287, -14997,
 26023,    152, -14926,
 26043,    -13, -14892,
 26038,   -142, -14899,
 26033,   -360, -14904,
 26083,   -420, -14815,
 26120,   -557, -14746,
 26151,   -688, -14685,
 26149,   -839, -14681,
 26143,   -996, -14682,
 26178,  -1129, -14609,
 26188,  -1276, -14579,
 26240,  -1381, -14476,
 26251,  -1496, -14444,
 26247,  -1641, -14437,
 26212,  -1820, -14478,
 26145,  -1823, -14598,
 26074,  -1846, -14722,
 26051,  -1996, -14743,
 26016,  -2125, -14786,
 26006,  -2290, -14780,
 26014,  -2439, -14742,
 26015,  -2587, -14716,
 26032,  -2726, -14659,
 26007,  -2884, -14673,
 25946,  -2959, -14766,
 25874,  -2929, -14898,

/* 11 */
133, 1,
 29737,   2888,  -2716,
 29746,   2775,  -2728,
 29754,   2637,  -2780,
 29760,   2497,  -2852,
 29758,   2391,  -2952,
 29756,   2280,  -3065,
 29751,   2181,  -3179,
 29746,   2080,  -3289,
 29742,   1974,  -3398,
 29726,   1940,  -3549,
 29720,   1832,  -3656,
 29716,   1709,  -3748,
 29712,   1585,  -3830,
 29702,   1488,  -3948,
 29703,   1341,  -3989,
 29702,   1207,  -4043,
 29684,   1164,  -4181,
 29669,   1079,  -4314,
 29652,   1006,  -4443,
 29639,    880,  -4559,
 29638,    744,  -4583,
 29633,    602,  -4638,
 29628,    458,  -4684,
 29623,    315,  -4734,
 29617,    161,  -4776,
 29597,     96,  -4902,
 29574,     23,  -5035,
 29563,   -107,  -5099,
 29547,   -224,  -5188,
 29529,   -339,  -5284,
 29511,   -461,  -5375,
 29501,   -607,  -5417,
 29482,   -733,  -5501,
 29467,   -869,  -5562,
 29448,   -999,  -5640,
 29440,  -1148,  -5652,
 29421,  -1285,  -5721,
 29396,  -1390,  -5824,
 29372,  -1501,  -5918,
 29350,  -1632,  -5991,
 29324,  -1739,  -6091,
 29293,  -1827,  -6211,
 29262,  -1920,  -6330,
 29241,  -2059,  -6382,
 29211,  -2166,  -6484,
 29178,  -2256,  -6600,
 29145,  -2354,  -6710,
 29110,  -2438,  -6832,
 29076,  -2532,  -6940,
 29038,  -2602,  -7074,
 29002,  -2702,  -7181,
 28971,  -2820,  -7261,
 28933,  -2928,  -7369,
 28883,  -3059,  -7512,
 28894,  -2930,  -7520,
 28873,  -2914,  -7605,
 28822,  -3001,  -7763,
 28810,  -2916,  -7841,
 28782,  -2927,  -7939,
 28738,  -3033,  -8060,
 28724,  -2947,  -8138,
 28735,  -2797,  -8154,
 28744,  -2647,  -8173,
 28755,  -2497,  -8181,
 28766,  -2347,  -8186,
 28785,  -2201,  -8159,
 28783,  -2045,  -8207,
 28802,  -1908,  -8173,
 28796,  -1760,  -8228,
 28786,  -1636,  -8286,
 28817,  -1532,  -8199,
 28845,  -1410,  -8122,
 28874,  -1277,  -8042,
 28917,  -1238,  -7891,
 28958,  -1225,  -7741,
 28992,  -1354,  -7590,
 28993,  -1255,  -7605,
 28979,  -1111,  -7679,
 29013,  -1026,  -7563,
 29029,   -920,  -7513,
 29041,   -769,  -7486,
 29050,   -621,  -7462,
 29074,   -549,  -7377,
 29114,   -534,  -7217,
 29145,   -498,  -7093,
 29176,   -399,  -6971,
 29175,   -264,  -6981,
 29181,   -161,  -6959,
 29176,    -91,  -6980,
 29149,    -11,  -7096,
 29141,    123,  -7125,
 29165,    216,  -7024,
 29198,    256,  -6886,
 29228,    177,  -6758,
 29276,    112,  -6550,
 29260,    146,  -6620,
 29228,    232,  -6758,
 29239,    357,  -6706,
 29271,    386,  -6561,
 29299,    445,  -6432,
 29316,    562,  -6343,
 29324,    704,  -6294,
 29345,    806,  -6182,
 29370,    870,  -6054,
 29395,    927,  -5924,
 29402,   1068,  -5863,
 29421,   1172,  -5749,
 29443,   1068,  -5655,
 29460,   1101,  -5558,
 29479,   1185,  -5437,
 29493,   1353,  -5323,
 29510,   1397,  -5216,
 29510,   1537,  -5174,
 29522,   1647,  -5072,
 29539,   1728,  -4946,
 29552,   1823,  -4830,
 29568,   1902,  -4703,
 29585,   1971,  -4564,
 29594,   2077,  -4461,
 29611,   2152,  -4311,
 29605,   2247,  -4298,
 29608,   2371,  -4212,
 29608,   2490,  -4140,
 29611,   2603,  -4049,
 29618,   2709,  -3932,
 29637,   2710,  -3782,
 29651,   2749,  -3641,
 29670,   2741,  -3493,
 29688,   2730,  -3344,
 29701,   2763,  -3198,
 29706,   2850,  -3075,
 29711,   2927,  -2947,
 29725,   2934,  -2799,

/* 12 */
129, -1,
 17606,  18970,  15171,
 17593,  18901,  15271,
 17617,  18783,  15390,
 17696,  18659,  15450,
 17771,  18540,  15507,
 17859,  18423,  15545,
 17964,  18320,  15546,
 18084,  18262,  15475,
 18199,  18247,  15358,
 18306,  18208,  15276,
 18420,  18108,  15257,
 18539,  18033,  15202,
 18658,  17969,  15133,
 18769,  17928,  15043,
 18878,  17900,  14941,
 18981,  17883,  14830,
 19053,  17914,  14699,
 19128,  17940,  14570,
 19197,  17973,  14438,
 19268,  18001,  14307,
 19351,  18014,  14180,
 19377,  18016,  14140,
 19274,  18197,  14049,
 19185,  18315,  14017,
 19100,  18436,  13975,
 19035,  18555,  13906,
 18956,  18674,  13854,
 18901,  18789,  13774,
 18811,  18890,  13759,
 18714,  18968,  13785,
 18597,  19001,  13897,
 18526,  19084,  13878,
 18553,  19105,  13813,
 18596,  19123,  13730,
 18484,  19246,  13709,
 18380,  19241,  13855,
 18269,  19324,  13886,
 18182,  19438,  13842,
 18133,  19551,  13746,
 18112,  19644,  13641,
 18240,  19600,  13534,
 18313,  19581,  13462,
 18401,  19548,  13390,
 18453,  19588,  13258,
 18488,  19644,  13126,
 18427,  19737,  13072,
 18298,  19814,  13137,
 18179,  19896,  13178,
 18076,  20008,  13151,
 17965,  20109,  13149,
 17867,  20113,  13276,
 17807,  20080,  13405,
 17844,  19968,  13523,
 17920,  19864,  13575,
 17963,  19784,  13635,
 17788,  19943,  13634,
 17694,  20051,  13597,
 17626,  20155,  13531,
 17590,  20257,  13425,
 17519,  20348,  13381,
 17383,  20400,  13478,
 17275,  20431,  13571,
 17148,  20517,  13601,
 17049,  20562,  13658,
 16944,  20678,  13613,
 16828,  20771,  13616,
 16717,  20870,  13601,
 16603,  20941,  13632,
 16485,  20988,  13701,
 16448,  21071,  13620,
 16553,  21068,  13496,
 16670,  21034,  13404,
 16693,  21064,  13329,
 16520,  21178,  13364,
 16509,  21260,  13245,
 16504,  21344,  13118,
 16577,  21360,  12998,
 16676,  21360,  12872,
 16779,  21343,  12765,
 16829,  21361,  12670,
 16693,  21471,  12662,
 16665,  21563,  12542,
 16604,  21664,  12449,
 16504,  21768,  12400,
 16427,  21866,  12331,
 16310,  21921,  12388,
 16226,  21907,  12522,
 16157,  21897,  12628,
 16045,  21940,  12696,
 15928,  21972,  12787,
 15865,  21935,  12929,
 15825,  21890,  13053,
 15792,  21836,  13183,
 15741,  21779,  13338,
 15672,  21758,  13454,
 15688,  21676,  13566,
 15655,  21614,  13702,
 15661,  21541,  13810,
 15593,  21486,  13971,
 15502,  21460,  14113,
 15474,  21429,  14191,
 15539,  21304,  14307,
 15565,  21205,  14425,
 15560,  21142,  14522,
 15563,  21046,  14658,
 15676,  20972,  14644,
 15802,  20899,  14613,
 15930,  20790,  14629,
 15999,  20719,  14654,
 16100,  20576,  14744,
 16174,  20467,  14816,
 16291,  20371,  14820,
 16403,  20278,  14823,
 16525,  20187,  14812,
 16641,  20090,  14815,
 16759,  20011,  14788,
 16883,  19924,  14765,
 17002,  19832,  14753,
 17106,  19725,  14775,
 17223,  19631,  14764,
 17338,  19540,  14750,
 17460,  19508,  14650,
 17579,  19445,  14591,
 17585,  19407,  14633,
 17483,  19406,  14756,
 17446,  19330,  14899,
 17497,  19217,  14986,
 17545,  19101,  15078,
 17615,  19014,  15105,

/* 13 */
124, 1,
 19067, -11237,  20253,
 19034, -11359,  20216,
 19005, -11510,  20157,
 18995, -11645,  20089,
 19026, -11758,  19993,
 19023, -11890,  19918,
 19002, -12007,  19868,
 18944, -12149,  19837,
 18905, -12288,  19789,
 18897, -12413,  19719,
 18922, -12525,  19623,
 18919, -12657,  19541,
 18980, -12758,  19416,
 19037, -12808,  19328,
 19127, -12847,  19212,
 19189, -12929,  19095,
 19287, -12941,  18988,
 19400, -12889,  18908,
 19514, -12818,  18839,
 19629, -12767,  18754,
 19741, -12753,  18646,
 19853, -12705,  18560,
 19952, -12621,  18510,
 20036, -12484,  18512,
 20114, -12352,  18517,
 20193, -12224,  18515,
 20274, -12096,  18511,
 20340, -11959,  18527,
 20413, -11826,  18533,
 20481, -11691,  18544,
 20540, -11553,  18564,
 20607, -11417,  18574,
 20678, -11284,  18577,
 20755, -11156,  18568,
 20826, -11021,  18569,
 20895, -10886,  18571,
 20960, -10748,  18579,
 21023, -10610,  18586,
 21089, -10473,  18590,
 21163, -10341,  18579,
 21225, -10218,  18577,
 21292, -10070,  18581,
 21361,  -9936,  18573,
 21427,  -9799,  18571,
 21498,  -9666,  18558,
 21568,  -9532,  18546,
 21632,  -9394,  18542,
 21682,  -9256,  18553,
 21737,  -9114,  18559,
 21752,  -8974,  18609,
 21807,  -8833,  18613,
 21888,  -8719,  18571,
 21941,  -8633,  18549,
 21997,  -8479,  18554,
 22007,  -8344,  18603,
 22012,  -8206,  18658,
 22026,  -8060,  18705,
 22105,  -8010,  18634,
 22118,  -8145,  18559,
 22169,  -8227,  18462,
 22252,  -8104,  18416,
 22312,  -7963,  18405,
 22325,  -7827,  18449,
 22307,  -7696,  18525,
 22310,  -7554,  18579,
 22332,  -7407,  18613,
 22350,  -7261,  18648,
 22364,  -7114,  18688,
 22362,  -6969,  18745,
 22360,  -6833,  18797,
 22352,  -6697,  18855,
 22305,  -6606,  18944,
 22290,  -6461,  19011,
 22227,  -6310,  19135,
 22152,  -6377,  19199,
 22057,  -6481,  19274,
 22055,  -6630,  19226,
 22014,  -6770,  19224,
 21960,  -6916,  19233,
 21860,  -6981,  19324,
 21766,  -7099,  19387,
 21695,  -7043,  19487,
 21631,  -7093,  19540,
 21617,  -7310,  19475,
 21563,  -7374,  19510,
 21530,  -7563,  19475,
 21451,  -7634,  19534,
 21370,  -7770,  19570,
 21362,  -7675,  19615,
 21303,  -7723,  19660,
 21188,  -7947,  19695,
 21141,  -7895,  19767,
 21032,  -7972,  19852,
 20939,  -8057,  19916,
 20897,  -8185,  19907,
 20871,  -8219,  19921,
 20794,  -8165,  20024,
 20698,  -8166,  20122,
 20603,  -8249,  20186,
 20496,  -8278,  20282,
 20381,  -8332,  20376,
 20280,  -8370,  20461,
 20172,  -8410,  20552,
 20134,  -8566,  20524,
 20063,  -8700,  20538,
 19979,  -8826,  20566,
 19899,  -8947,  20591,
 19854,  -9086,  20573,
 19844,  -9221,  20523,
 19818,  -9364,  20483,
 19806,  -9503,  20431,
 19822,  -9632,  20354,
 19798,  -9766,  20314,
 19804,  -9905,  20241,
 19806, -10035,  20175,
 19765, -10176,  20144,
 19720, -10302,  20124,
 19634, -10427,  20144,
 19551, -10539,  20167,
 19457, -10666,  20190,
 19388, -10803,  20184,
 19287, -10892,  20233,
 19208, -10984,  20258,
 19140, -11130,  20243,

/* 14 */
122, 1,
 14146,  19873, -17463,
 14250,  19783, -17481,
 14167,  19761, -17573,
 14202,  19665, -17651,
 14326,  19646, -17572,
 14360,  19749, -17429,
 14450,  19690, -17421,
 14560,  19589, -17443,
 14674,  19510, -17437,
 14712,  19393, -17535,
 14834,  19261, -17578,
 14820,  19161, -17698,
 14893,  19044, -17764,
 14990,  18937, -17796,
 15082,  18822, -17840,
 15193,  18722, -17851,
 15293,  18610, -17882,
 15388,  18501, -17914,
 15517,  18435, -17871,
 15634,  18350, -17856,
 15742,  18245, -17869,
 15864,  18161, -17847,
 15990,  18105, -17792,
 16118,  18055, -17727,
 16242,  17995, -17675,
 16351,  17974, -17595,
 16325,  18098, -17491,
 16177,  18218, -17504,
 16233,  18237, -17433,
 16356,  18174, -17384,
 16415,  18062, -17445,
 16493,  17940, -17497,
 16605,  17840, -17494,
 16728,  17751, -17467,
 16844,  17650, -17457,
 16905,  17521, -17528,
 17026,  17441, -17491,
 17138,  17426, -17396,
 17177,  17482, -17301,
 17292,  17483, -17185,
 17403,  17472, -17083,
 17523,  17432, -17002,
 17635,  17419, -16899,
 17754,  17422, -16772,
 17833,  17439, -16669,
 17960,  17388, -16586,
 18073,  17297, -16558,
 18191,  17213, -16516,
 18309,  17130, -16473,
 18431,  17059, -16411,
 18546,  16978, -16365,
 18651,  16948, -16276,
 18751,  16872, -16240,
 18776,  16770, -16317,
 18671,  16767, -16440,
 18566,  16780, -16546,
 18502,  16716, -16681,
 18435,  16768, -16703,
 18342,  16891, -16681,
 18263,  16889, -16770,
 18123,  16912, -16898,
 18042,  16925, -16971,
 17936,  16976, -17032,
 17806,  17001, -17144,
 17687,  17062, -17207,
 17574,  17103, -17282,
 17484,  17078, -17397,
 17393,  17062, -17504,
 17341,  17025, -17592,
 17474,  16905, -17576,
 17548,  16780, -17621,
 17550,  16672, -17722,
 17533,  16583, -17821,
 17445,  16553, -17936,
 17339,  16642, -17956,
 17215,  16765, -17960,
 17114,  16857, -17971,
 16986,  16899, -18053,
 16921,  16955, -18061,
 16966,  17046, -17933,
 16893,  17164, -17889,
 16818,  17157, -17966,
 16771,  17077, -18087,
 16723,  17050, -18156,
 16610,  17057, -18253,
 16487,  17048, -18373,
 16379,  17127, -18396,
 16220,  17222, -18447,
 16225,  17085, -18570,
 16103,  17171, -18597,
 16031,  17289, -18551,
 15883,  17310, -18657,
 15737,  17437, -18662,
 15778,  17340, -18718,
 15850,  17206, -18781,
 15777,  17217, -18833,
 15646,  17286, -18878,
 15557,  17410, -18838,
 15434,  17492, -18864,
 15380,  17556, -18848,
 15386,  17665, -18741,
 15337,  17783, -18670,
 15250,  17902, -18626,
 15146,  18010, -18607,
 15050,  18115, -18584,
 14981,  18235, -18522,
 14935,  18353, -18442,
 14901,  18470, -18353,
 14795,  18590, -18317,
 14682,  18615, -18383,
 14624,  18650, -18393,
 14567,  18756, -18330,
 14459,  18862, -18307,
 14343,  18962, -18296,
 14253,  19078, -18245,
 14203,  19189, -18167,
 14173,  19305, -18068,
 14155,  19410, -17970,
 14181,  19503, -17848,
 14161,  19610, -17746,
 14100,  19725, -17667,
 14064,  19824, -17585,

/* 15 */
125, 1,
 -1369,  25599,  15582,
 -1389,  25542,  15674,
 -1457,  25488,  15756,
 -1455,  25427,  15855,
 -1492,  25411,  15877,
 -1592,  25380,  15915,
 -1602,  25295,  16049,
 -1576,  25237,  16144,
 -1622,  25160,  16259,
 -1691,  25080,  16375,
 -1657,  25029,  16456,
 -1520,  25077,  16396,
 -1509,  25059,  16425,
 -1566,  25001,  16507,
 -1634,  24899,  16655,
 -1642,  24827,  16761,
 -1685,  24706,  16934,
 -1622,  24747,  16881,
 -1582,  24828,  16765,
 -1506,  24913,  16645,
 -1456,  24866,  16720,
 -1436,  24804,  16813,
 -1391,  24726,  16933,
 -1462,  24641,  17049,
 -1528,  24560,  17160,
 -1472,  24501,  17250,
 -1307,  24513,  17246,
 -1170,  24523,  17241,
  -991,  24562,  17196,
 -1000,  24535,  17235,
 -1083,  24449,  17352,
 -1045,  24368,  17468,
  -940,  24319,  17542,
  -906,  24255,  17632,
  -928,  24173,  17743,
  -931,  24072,  17880,
 -1030,  24055,  17897,
 -1185,  24051,  17892,
 -1325,  24010,  17938,
 -1452,  23925,  18041,
 -1375,  23912,  18065,
 -1287,  23845,  18159,
 -1316,  23762,  18266,
 -1424,  23697,  18342,
 -1565,  23655,  18384,
 -1676,  23586,  18463,
 -1601,  23533,  18538,
 -1399,  23540,  18544,
 -1317,  23502,  18599,
 -1202,  23475,  18641,
 -1066,  23450,  18681,
  -862,  23523,  18599,
  -915,  23466,  18668,
 -1008,  23394,  18754,
 -1158,  23382,  18760,
 -1315,  23382,  18750,
 -1428,  23326,  18811,
 -1516,  23250,  18898,
 -1621,  23176,  18980,
 -1717,  23105,  19058,
 -1864,  23035,  19129,
 -1808,  23003,  19173,
 -1696,  23020,  19162,
 -1588,  23075,  19105,
 -1425,  23096,  19093,
 -1282,  23068,  19137,
 -1177,  23118,  19083,
 -1106,  23196,  18993,
  -941,  23215,  18979,
  -805,  23178,  19029,
  -655,  23203,  19006,
  -493,  23246,  18957,
  -366,  23254,  18951,
  -257,  23241,  18968,
   -88,  23252,  18956,
    66,  23240,  18971,
   209,  23274,  18928,
   335,  23314,  18877,
   447,  23404,  18764,
   237,  23456,  18702,
   288,  23541,  18594,
   401,  23611,  18502,
   498,  23672,  18423,
   545,  23760,  18307,
   545,  23850,  18190,
   450,  23919,  18102,
   307,  23945,  18070,
   158,  23924,  18100,
    49,  23931,  18092,
   102,  24025,  17966,
    34,  24108,  17856,
  -137,  24171,  17770,
   -20,  24167,  17775,
   -43,  24240,  17676,
   -72,  24322,  17563,
  -163,  24402,  17450,
  -297,  24450,  17381,
  -378,  24497,  17314,
  -428,  24582,  17191,
  -464,  24665,  17071,
  -504,  24749,  16948,
  -595,  24814,  16850,
  -709,  24863,  16773,
  -840,  24873,  16752,
 -1010,  24872,  16744,
  -970,  24886,  16725,
  -812,  24936,  16659,
  -870,  24984,  16585,
  -867,  24999,  16561,
  -739,  25038,  16509,
  -660,  25106,  16408,
  -597,  25184,  16292,
  -537,  25260,  16175,
  -527,  25329,  16067,
  -664,  25349,  16030,
  -814,  25352,  16018,
  -965,  25354,  16007,
 -1163,  25329,  16034,
 -1115,  25385,  15948,
 -1052,  25452,  15846,
  -936,  25507,  15765,
  -863,  25593,  15629,
  -993,  25606,  15600,
 -1165,  25588,  15617,
 -1290,  25592,  15600,

/* 16 */
107, 1,
 -8155,  28629,  -3723,
 -8112,  28651,  -3649,
 -7998,  28694,  -3562,
 -7853,  28736,  -3548,
 -7814,  28730,  -3679,
 -7820,  28709,  -3827,
 -7832,  28685,  -3978,
 -7863,  28657,  -4117,
 -7908,  28624,  -4256,
 -8031,  28579,  -4332,
 -8103,  28539,  -4459,
 -8235,  28484,  -4566,
 -8328,  28472,  -4468,
 -8402,  28452,  -4462,
 -8483,  28437,  -4402,
 -8532,  28446,  -4247,
 -8581,  28453,  -4094,
 -8598,  28441,  -4147,
 -8604,  28423,  -4252,
 -8592,  28404,  -4404,
 -8575,  28385,  -4556,
 -8651,  28347,  -4649,
 -8806,  28306,  -4605,
 -8890,  28299,  -4487,
 -8961,  28296,  -4361,
 -9024,  28298,  -4218,
 -9054,  28310,  -4069,
 -9129,  28304,  -3944,
 -9232,  28285,  -3838,
 -9368,  28254,  -3737,
 -9384,  28239,  -3810,
 -9353,  28232,  -3935,
 -9271,  28240,  -4071,
 -9197,  28245,  -4200,
 -9153,  28237,  -4346,
 -9118,  28225,  -4493,
 -9094,  28209,  -4642,
 -9169,  28169,  -4739,
 -9322,  28121,  -4720,
 -9446,  28084,  -4694,
 -9570,  28059,  -4596,
 -9640,  28056,  -4466,
 -9727,  28050,  -4310,
 -9835,  28014,  -4301,
 -9966,  27961,  -4344,
-10111,  27913,  -4318,
-10166,  27914,  -4180,
-10212,  27921,  -4014,
-10238,  27929,  -3893,
-10275,  27936,  -3744,
-10288,  27951,  -3592,
-10247,  27985,  -3444,
-10256,  27999,  -3301,
-10221,  28028,  -3159,
-10113,  28080,  -3045,
-10198,  28055,  -2984,
-10283,  28034,  -2888,
-10382,  28007,  -2796,
-10465,  27988,  -2680,
-10537,  27974,  -2540,
-10557,  27979,  -2394,
-10482,  28021,  -2226,
-10332,  28076,  -2235,
-10357,  28054,  -2391,
-10300,  28075,  -2391,
-10185,  28115,  -2414,
-10180,  28124,  -2319,
-10120,  28156,  -2191,
-10183,  28144,  -2051,
-10131,  28170,  -1953,
 -9997,  28216,  -1988,
 -9900,  28243,  -2085,
 -9745,  28286,  -2224,
 -9698,  28295,  -2312,
 -9573,  28332,  -2384,
 -9428,  28376,  -2433,
 -9289,  28426,  -2383,
 -9149,  28473,  -2359,
 -9007,  28517,  -2381,
 -8863,  28562,  -2380,
 -8716,  28607,  -2375,
 -8574,  28651,  -2364,
 -8432,  28691,  -2395,
 -8301,  28723,  -2472,
 -8232,  28730,  -2608,
 -8288,  28704,  -2718,
 -8444,  28655,  -2754,
 -8587,  28611,  -2772,
 -8725,  28567,  -2793,
 -8882,  28519,  -2788,
 -8973,  28483,  -2860,
 -8920,  28493,  -2928,
 -8779,  28538,  -2915,
 -8630,  28584,  -2906,
 -8490,  28627,  -2903,
 -8355,  28661,  -2955,
 -8236,  28687,  -3041,
 -8340,  28654,  -3065,
 -8458,  28616,  -3097,
 -8455,  28601,  -3238,
 -8470,  28584,  -3346,
 -8449,  28588,  -3364,
 -8341,  28633,  -3256,
 -8207,  28666,  -3297,
 -8096,  28685,  -3411,
 -8165,  28648,  -3556,
 -8180,  28629,  -3670,

/* 17 */
87, 1,
-27734,  11163,   2489,
-27715,  11176,   2640,
-27707,  11168,   2754,
-27666,  11234,   2897,
-27620,  11321,   2998,
-27597,  11336,   3148,
-27559,  11394,   3267,
-27508,  11486,   3377,
-27460,  11561,   3502,
-27437,  11569,   3653,
-27419,  11564,   3804,
-27413,  11519,   3978,
-27465,  11437,   3855,
-27489,  11361,   3909,
-27482,  11331,   4043,
-27465,  11307,   4218,
-27454,  11303,   4302,
-27448,  11263,   4444,
-27415,  11280,   4602,
-27436,  11177,   4727,
-27440,  11107,   4867,
-27425,  11074,   5021,
-27417,  11030,   5159,
-27388,  11034,   5307,
-27358,  11036,   5453,
-27389,  10911,   5549,
-27432,  10778,   5597,
-27445,  10683,   5712,
-27446,  10612,   5839,
-27418,  10600,   5990,
-27385,  10589,   6157,
-27410,  10471,   6249,
-27472,  10362,   6158,
-27546,  10233,   6042,
-27529,  10198,   6174,
-27495,  10207,   6312,
-27454,  10228,   6456,
-27414,  10238,   6606,
-27375,  10249,   6749,
-27342,  10239,   6896,
-27317,  10208,   7043,
-27261,  10236,   7217,
-27233,  10237,   7319,
-27179,  10284,   7452,
-27106,  10343,   7635,
-27100,  10438,   7525,
-27095,  10536,   7406,
-27113,  10592,   7259,
-27147,  10605,   7112,
-27173,  10642,   6956,
-27138,  10747,   6929,
-27154,  10798,   6787,
-27166,  10846,   6664,
-27193,  10872,   6506,
-27203,  10917,   6390,
-27201,  11005,   6247,
-27205,  11041,   6163,
-27184,  11162,   6037,
-27197,  11118,   6062,
-27204,  11111,   6040,
-27211,  11181,   5878,
-27205,  11253,   5765,
-27203,  11325,   5636,
-27204,  11387,   5502,
-27215,  11419,   5381,
-27245,  11426,   5213,
-27248,  11479,   5077,
-27225,  11582,   4969,
-27212,  11661,   4848,
-27227,  11688,   4698,
-27231,  11745,   4534,
-27243,  11761,   4418,
-27262,  11777,   4250,
-27286,  11772,   4114,
-27294,  11796,   3987,
-27311,  11806,   3835,
-27335,  11799,   3685,
-27375,  11748,   3548,
-27405,  11725,   3392,
-27429,  11705,   3261,
-27468,  11651,   3120,
-27505,  11603,   2977,
-27542,  11546,   2848,
-27596,  11442,   2742,
-27656,  11299,   2734,
-27681,  11249,   2685,
-27714,  11204,   2525,

/* 18 */
90, 1,
-15425,  23492,  10498,
-15483,  23493,  10411,
-15604,  23447,  10333,
-15727,  23380,  10297,
-15842,  23304,  10294,
-15992,  23206,  10284,
-16103,  23132,  10275,
-16224,  23041,  10290,
-16347,  22951,  10298,
-16487,  22827,  10350,
-16595,  22774,  10292,
-16652,  22683,  10401,
-16726,  22664,  10322,
-16928,  22537,  10273,
-17023,  22500,  10197,
-16964,  22465,  10371,
-17064,  22397,  10354,
-17187,  22328,  10298,
-17311,  22248,  10265,
-17370,  22154,  10368,
-17277,  22159,  10512,
-17185,  22184,  10609,
-17115,  22175,  10740,
-17047,  22160,  10879,
-16982,  22145,  11008,
-16905,  22151,  11117,
-16777,  22190,  11232,
-16668,  22237,  11301,
-16686,  22204,  11338,
-16777,  22137,  11335,
-16755,  22117,  11407,
-16657,  22153,  11480,
-16575,  22175,  11556,
-16546,  22160,  11627,
-16675,  22085,  11585,
-16801,  22002,  11561,
-16921,  21954,  11475,
-16946,  21897,  11548,
-16841,  21922,  11654,
-16724,  21997,  11680,
-16557,  22091,  11740,
-16502,  22105,  11793,
-16364,  22215,  11778,
-16315,  22219,  11837,
-16382,  22109,  11951,
-16474,  22028,  11975,
-16600,  21924,  11991,
-16590,  21891,  12064,
-16453,  21975,  12099,
-16451,  21952,  12143,
-16527,  21855,  12216,
-16463,  21831,  12344,
-16325,  21931,  12349,
-16230,  22022,  12314,
-16091,  22157,  12252,
-16203,  22115,  12182,
-16196,  22157,  12114,
-16028,  22300,  12076,
-16122,  22271,  12004,
-16273,  22164,  11999,
-16264,  22224,  11899,
-16174,  22320,  11842,
-16065,  22378,  11881,
-15899,  22471,  11927,
-15958,  22477,  11837,
-16067,  22449,  11743,
-16017,  22494,  11726,
-15986,  22559,  11644,
-15876,  22641,  11633,
-15754,  22728,  11629,
-15782,  22790,  11469,
-15872,  22781,  11362,
-15960,  22765,  11271,
-16065,  22741,  11168,
-16076,  22784,  11065,
-16136,  22804,  10935,
-16112,  22853,  10868,
-15969,  22942,  10893,
-15990,  22992,  10756,
-16088,  22955,  10687,
-16232,  22871,  10651,
-16218,  22900,  10609,
-16109,  22990,  10581,
-15967,  23088,  10584,
-15853,  23162,  10594,
-15729,  23250,  10584,
-15602,  23325,  10607,
-15566,  23392,  10512,
-15506,  23427,  10523,
-15394,  23477,  10576,

/* 19 */
80, 1,
  1236, -19143, -23066,
  1240, -19065, -23130,
  1178, -18965, -23215,
  1044, -18914, -23264,
   892, -18939, -23249,
   841, -18930, -23258,
   835, -18796, -23367,
   737, -18720, -23431,
   685, -18614, -23517,
   675, -18495, -23611,
   628, -18364, -23715,
   760, -18290, -23768,
   901, -18329, -23733,
   997, -18415, -23662,
  1150, -18467, -23614,
  1280, -18439, -23630,
  1420, -18389, -23661,
  1604, -18317, -23705,
  1660, -18239, -23761,
  1709, -18118, -23850,
  1758, -17994, -23940,
  1864, -17898, -24004,
  1890, -17974, -23945,
  1862, -18119, -23838,
  1973, -18067, -23869,
  2158, -17999, -23903,
  2192, -17910, -23967,
  2198, -17801, -24048,
  2258, -17688, -24126,
  2344, -17560, -24211,
  2331, -17465, -24281,
  2432, -17346, -24356,
  2533, -17287, -24387,
  2657, -17220, -24422,
  2813, -17176, -24435,
  2933, -17125, -24456,
  3039, -16997, -24533,
  3056, -17057, -24489,
  2959, -17158, -24431,
  2922, -17279, -24350,
  2796, -17369, -24300,
  2774, -17474, -24227,
  2676, -17581, -24161,
  2515, -17738, -24063,
  2561, -17637, -24133,
  2542, -17657, -24120,
  2392, -17723, -24087,
  2371, -17837, -24004,
  2389, -17903, -23953,
  2310, -18026, -23869,
  2183, -18052, -23861,
  2200, -18114, -23813,
  2182, -18209, -23742,
  2119, -18360, -23631,
  2125, -18475, -23541,
  2158, -18549, -23480,
  2191, -18681, -23371,
  2209, -18798, -23276,
  2315, -18869, -23208,
  2449, -18917, -23155,
  2517, -19007, -23074,
  2422, -19096, -23010,
  2282, -19142, -22986,
  2157, -19215, -22938,
  2010, -19262, -22911,
  1899, -19365, -22834,
  1903, -19445, -22765,
  1933, -19562, -22663,
  2002, -19666, -22567,
  2080, -19761, -22476,
  2015, -19813, -22436,
  1875, -19888, -22382,
  1750, -19879, -22400,
  1633, -19810, -22470,
  1546, -19722, -22553,
  1482, -19623, -22644,
  1411, -19521, -22737,
  1328, -19422, -22826,
  1254, -19329, -22909,
  1201, -19185, -23032,

/* 20 */
78, 1,
 24076,   9507, -15164,
 24148,   9432, -15096,
 24231,   9437, -14960,
 24279,   9500, -14843,
 24329,   9569, -14716,
 24408,   9567, -14585,
 24493,   9498, -14487,
 24560,   9349, -14470,
 24620,   9207, -14460,
 24672,   9068, -14458,
 24699,   8924, -14502,
 24739,   8777, -14525,
 24803,   8633, -14501,
 24838,   8498, -14521,
 24863,   8349, -14564,
 24922,   8305, -14488,
 24967,   8413, -14348,
 25028,   8279, -14320,
 25028,   8159, -14388,
 25056,   8016, -14421,
 25068,   7879, -14476,
 25088,   7728, -14521,
 25065,   7650, -14603,
 25039,   7507, -14721,
 24971,   7646, -14765,
 24904,   7611, -14895,
 24928,   7489, -14916,
 25018,   7378, -14821,
 25053,   7247, -14826,
 25030,   7189, -14893,
 24984,   7110, -15009,
 24909,   7071, -15151,
 24840,   7164, -15220,
 24753,   7215, -15337,
 24694,   7143, -15466,
 24653,   7047, -15574,
 24606,   6901, -15713,
 24572,   7013, -15717,
 24568,   7181, -15648,
 24510,   7159, -15749,
 24483,   7052, -15839,
 24429,   6959, -15962,
 24420,   6828, -16033,
 24389,   6745, -16115,
 24296,   6691, -16277,
 24295,   6559, -16332,
 24240,   6564, -16412,
 24200,   6739, -16400,
 24268,   6799, -16274,
 24268,   6900, -16231,
 24296,   7043, -16128,
 24211,   7121, -16221,
 24224,   7194, -16169,
 24299,   7248, -16032,
 24364,   7200, -15954,
 24399,   7293, -15858,
 24444,   7404, -15738,
 24515,   7416, -15622,
 24598,   7325, -15534,
 24652,   7232, -15491,
 24720,   7294, -15354,
 24728,   7416, -15281,
 24712,   7574, -15230,
 24693,   7687, -15205,
 24696,   7821, -15131,
 24685,   7951, -15081,
 24608,   8096, -15129,
 24570,   8231, -15118,
 24442,   8342, -15264,
 24407,   8347, -15318,
 24347,   8469, -15346,
 24275,   8610, -15381,
 24211,   8744, -15406,
 24185,   8879, -15370,
 24208,   8977, -15278,
 24197,   9122, -15209,
 24151,   9268, -15193,
 24084,   9400, -15218,

/* 21 */
83, 1,
  2308, -19901, -22330,
  2300, -19787, -22432,
  2337, -19723, -22484,
  2425, -19727, -22472,
  2440, -19678, -22512,
  2583, -19746, -22437,
  2712, -19766, -22404,
  2770, -19636, -22512,
  2887, -19557, -22565,
  2900, -19505, -22609,
  3059, -19593, -22512,
  3107, -19688, -22422,
  3101, -19806, -22318,
  3159, -19910, -22217,
  3274, -19983, -22135,
  3330, -20069, -22048,
  3358, -20178, -21945,
  3314, -20227, -21906,
  3266, -20212, -21927,
  3403, -20291, -21833,
  3426, -20397, -21731,
  3490, -20418, -21700,
  3618, -20482, -21619,
  3700, -20544, -21547,
  3825, -20639, -21434,
  3936, -20703, -21351,
  4050, -20746, -21289,
  4104, -20811, -21214,
  4284, -20844, -21146,
  4388, -20914, -21055,
  4463, -20986, -20968,
  4515, -21081, -20862,
  4604, -21159, -20763,
  4696, -21228, -20672,
  4701, -21312, -20584,
  4729, -21354, -20534,
  4777, -21395, -20480,
  4781, -21483, -20387,
  4824, -21561, -20294,
  4755, -21611, -20258,
  4604, -21673, -20226,
  4453, -21660, -20273,
  4311, -21715, -20245,
  4183, -21755, -20230,
  4102, -21791, -20208,
  3936, -21811, -20218,
  3797, -21806, -20250,
  3675, -21758, -20325,
  3585, -21677, -20427,
  3510, -21596, -20525,
  3389, -21521, -20624,
  3370, -21428, -20724,
  3334, -21327, -20833,
  3308, -21211, -20956,
  3403, -21160, -20992,
  3261, -21109, -21066,
  3255, -21003, -21172,
  3319, -20927, -21238,
  3311, -20917, -21249,
  3194, -20891, -21292,
  3064, -20851, -21350,
  2978, -20778, -21433,
  3108, -20688, -21502,
  3221, -20608, -21562,
  3292, -20556, -21601,
  3109, -20680, -21510,
  2979, -20749, -21462,
  2857, -20764, -21464,
  2768, -20778, -21462,
  2637, -20756, -21500,
  2738, -20679, -21561,
  2885, -20642, -21578,
  2960, -20614, -21594,
  2812, -20585, -21641,
  2859, -20558, -21661,
  2731, -20529, -21705,
  2611, -20465, -21780,
  2536, -20379, -21869,
  2477, -20274, -21974,
  2395, -20192, -22058,
  2345, -20108, -22139,
  2252, -19994, -22253,
  2301, -19944, -22292,

/* 22 */
75, 1,
 27917,  -4121, -10180,
 27862,  -4187, -10305,
 27806,  -4247, -10431,
 27749,  -4284, -10565,
 27693,  -4307, -10703,
 27636,  -4325, -10842,
 27579,  -4341, -10980,
 27527,  -4331, -11114,
 27465,  -4352, -11256,
 27404,  -4390, -11390,
 27349,  -4377, -11527,
 27301,  -4326, -11660,
 27239,  -4364, -11790,
 27175,  -4425, -11913,
 27113,  -4477, -12034,
 27050,  -4501, -12168,
 27000,  -4496, -12280,
 27041,  -4288, -12264,
 27049,  -4137, -12298,
 27095,  -4038, -12229,
 27159,  -3999, -12099,
 27217,  -4027, -11960,
 27275,  -4040, -11821,
 27330,  -4034, -11696,
 27392,  -3974, -11570,
 27427,  -3868, -11524,
 27464,  -3746, -11475,
 27506,  -3616, -11416,
 27568,  -3602, -11272,
 27625,  -3566, -11143,
 27683,  -3520, -11011,
 27736,  -3489, -10887,
 27792,  -3472, -10750,
 27841,  -3363, -10658,
 27883,  -3418, -10530,
 27888,  -3560, -10469,
 27921,  -3629, -10355,
 27973,  -3608, -10222,
 28027,  -3598, -10076,
 28080,  -3577,  -9937,
 28129,  -3583,  -9793,
 28178,  -3561,  -9659,
 28230,  -3525,  -9520,
 28267,  -3390,  -9459,
 28317,  -3294,  -9344,
 28363,  -3283,  -9207,
 28408,  -3251,  -9077,
 28457,  -3187,  -8948,
 28501,  -3117,  -8831,
 28533,  -3148,  -8714,
 28573,  -3163,  -8578,
 28617,  -3139,  -8438,
 28662,  -3110,  -8294,
 28689,  -3158,  -8184,
 28688,  -3299,  -8133,
 28697,  -3409,  -8053,
 28716,  -3518,  -7938,
 28725,  -3563,  -7885,
 28673,  -3579,  -8066,
 28632,  -3576,  -8212,
 28584,  -3639,  -8349,
 28548,  -3707,  -8442,
 28531,  -3847,  -8438,
 28482,  -3878,  -8588,
 28436,  -3890,  -8734,
 28387,  -3914,  -8879,
 28339,  -3966,  -9009,
 28290,  -4026,  -9137,
 28239,  -4061,  -9277,
 28193,  -4052,  -9419,
 28152,  -4004,  -9561,
 28104,  -4022,  -9694,
 28052,  -4031,  -9842,
 28000,  -4062,  -9974,
 27958,  -4088, -10082,

/* 23 */
73, 1,
 11139,  23963, -14202,
 11228,  23868, -14291,
 11324,  23782, -14358,
 11412,  23695, -14432,
 11474,  23602, -14535,
 11501,  23527, -14637,
 11499,  23436, -14783,
 11540,  23343, -14898,
 11643,  23251, -14962,
 11725,  23154, -15046,
 11774,  23059, -15154,
 11846,  22962, -15245,
 11917,  22865, -15335,
 12003,  22768, -15413,
 12088,  22670, -15490,
 12190,  22573, -15552,
 12236,  22479, -15652,
 12257,  22386, -15768,
 12322,  22284, -15862,
 12428,  22187, -15915,
 12510,  22084, -15994,
 12556,  21984, -16096,
 12650,  21883, -16159,
 12749,  21781, -16219,
 12799,  21678, -16317,
 12787,  21598, -16432,
 12634,  21734, -16372,
 12497,  21821, -16360,
 12396,  21794, -16474,
 12337,  21751, -16574,
 12342,  21669, -16677,
 12236,  21830, -16545,
 12294,  21866, -16453,
 12278,  21975, -16321,
 12263,  22068, -16206,
 12281,  22140, -16093,
 12244,  22241, -15981,
 12164,  22340, -15905,
 12061,  22438, -15845,
 11959,  22533, -15787,
 11861,  22629, -15724,
 11753,  22715, -15681,
 11630,  22755, -15714,
 11510,  22727, -15843,
 11464,  22661, -15971,
 11442,  22582, -16097,
 11431,  22565, -16129,
 11441,  22668, -15977,
 11418,  22762, -15860,
 11377,  22858, -15750,
 11345,  22952, -15637,
 11324,  23042, -15518,
 11296,  23133, -15403,
 11247,  23228, -15296,
 11203,  23321, -15186,
 11164,  23411, -15076,
 11136,  23503, -14953,
 11094,  23597, -14837,
 11047,  23683, -14734,
 10970,  23771, -14650,
 10909,  23814, -14625,
 10787,  23958, -14480,
 10737,  24054, -14356,
 10712,  24134, -14241,
 10678,  24210, -14136,
 10591,  24307, -14035,
 10623,  24366, -13909,
 10703,  24328, -13913,
 10721,  24235, -14062,
 10787,  24164, -14133,
 10930,  24095, -14141,
 11052,  24077, -14077,
 11107,  24019, -14132,

/* 24 */
68, 1,
 24092,   5088, -17137,
 24106,   4990, -17147,
 24101,   4845, -17195,
 24134,   4705, -17188,
 24227,   4665, -17067,
 24323,   4656, -16933,
 24372,   4485, -16908,
 24429,   4448, -16836,
 24501,   4435, -16734,
 24557,   4298, -16687,
 24680,   4208, -16529,
 24659,   4278, -16541,
 24654,   4432, -16509,
 24708,   4508, -16406,
 24771,   4497, -16315,
 24859,   4427, -16199,
 24913,   4293, -16152,
 24996,   4237, -16040,
 25078,   4200, -15921,
 25152,   4113, -15826,
 25188,   3971, -15805,
 25229,   3828, -15775,
 25271,   3687, -15742,
 25214,   3638, -15843,
 25160,   3783, -15896,
 25106,   3922, -15947,
 25048,   4038, -16010,
 24992,   3958, -16117,
 24917,   3960, -16231,
 24843,   3910, -16357,
 24783,   4056, -16412,
 24705,   4039, -16533,
 24640,   3967, -16648,
 24610,   3837, -16722,
 24668,   3705, -16666,
 24696,   3561, -16656,
 24695,   3413, -16688,
 24674,   3281, -16746,
 24614,   3195, -16851,
 24544,   3124, -16966,
 24466,   3072, -17087,
 24395,   3144, -17175,
 24370,   3104, -17218,
 24373,   2969, -17237,
 24318,   2958, -17317,
 24256,   3084, -17383,
 24226,   3227, -17398,
 24244,   3372, -17345,
 24285,   3483, -17265,
 24242,   3638, -17295,
 24153,   3782, -17387,
 24105,   3675, -17477,
 24080,   3540, -17539,
 24074,   3353, -17584,
 24046,   3400, -17613,
 24020,   3572, -17615,
 23959,   3663, -17679,
 23898,   3795, -17734,
 23881,   3941, -17725,
 23906,   4069, -17662,
 23896,   4232, -17637,
 23900,   4361, -17601,
 23930,   4479, -17530,
 23889,   4622, -17549,
 23904,   4793, -17483,
 23955,   4892, -17385,
 23998,   4977, -17300,
 24054,   5068, -17196,

/* 25 */
68, 1,
 -3077,  27485,  11624,
 -3212,  27455,  11659,
 -3277,  27494,  11548,
 -3382,  27504,  11494,
 -3481,  27440,  11615,
 -3635,  27419,  11617,
 -3755,  27420,  11579,
 -3821,  27363,  11689,
 -3841,  27363,  11685,
 -3874,  27416,  11549,
 -3954,  27435,  11476,
 -4093,  27375,  11569,
 -4195,  27407,  11458,
 -4276,  27352,  11558,
 -4367,  27316,  11610,
 -4494,  27264,  11682,
 -4529,  27272,  11650,
 -4536,  27330,  11510,
 -4469,  27386,  11402,
 -4494,  27431,  11285,
 -4557,  27480,  11141,
 -4671,  27496,  11053,
 -4650,  27472,  11120,
 -4695,  27410,  11253,
 -4795,  27428,  11168,
 -4887,  27398,  11202,
 -4912,  27358,  11287,
 -4960,  27341,  11307,
 -5071,  27316,  11320,
 -5089,  27291,  11372,
 -4958,  27294,  11422,
 -4807,  27314,  11439,
 -4691,  27296,  11528,
 -4783,  27244,  11613,
 -4724,  27217,  11700,
 -4794,  27198,  11717,
 -4935,  27190,  11677,
 -5119,  27162,  11663,
 -5072,  27145,  11723,
 -4913,  27142,  11798,
 -4880,  27105,  11895,
 -4790,  27096,  11953,
 -4797,  27064,  12023,
 -4862,  27007,  12123,
 -5035,  26956,  12167,
 -4956,  26929,  12259,
 -4791,  26938,  12303,
 -4665,  26910,  12413,
 -4621,  26870,  12517,
 -4505,  26851,  12598,
 -4375,  26828,  12693,
 -4205,  26843,  12720,
 -4095,  26879,  12679,
 -3994,  26908,  12648,
 -3842,  26927,  12656,
 -3696,  26961,  12628,
 -3558,  27004,  12574,
 -3414,  27034,  12550,
 -3254,  27071,  12514,
 -3177,  27122,  12423,
 -3062,  27168,  12350,
 -3024,  27196,  12298,
 -2987,  27233,  12225,
 -2968,  27273,  12140,
 -3040,  27319,  12019,
 -3110,  27358,  11910,
 -3130,  27418,  11766,
 -3093,  27467,  11662,

/* 26 */
58, 1,
-26874,  10130,   8671,
-26904,  10149,   8554,
-26927,  10215,   8403,
-26969,  10221,   8259,
-27020,  10197,   8121,
-27063,  10109,   8085,
-27032,  10061,   8248,
-27021,   9976,   8388,
-27066,   9846,   8395,
-27091,   9728,   8453,
-27087,   9628,   8578,
-27119,   9545,   8571,
-27181,   9496,   8428,
-27224,   9502,   8279,
-27261,   9521,   8134,
-27295,   9541,   7998,
-27330,   9566,   7846,
-27362,   9593,   7699,
-27417,   9490,   7632,
-27415,   9412,   7737,
-27397,   9324,   7903,
-27343,   9381,   8023,
-27299,   9390,   8161,
-27265,   9362,   8303,
-27225,   9351,   8448,
-27175,   9374,   8580,
-27124,   9382,   8734,
-27096,   9334,   8872,
-27099,   9220,   8979,
-27105,   9125,   9058,
-27071,   9141,   9143,
-27008,   9257,   9212,
-26944,   9392,   9265,
-26876,   9459,   9393,
-26858,   9399,   9502,
-26805,   9396,   9654,
-26736,   9483,   9760,
-26682,   9486,   9904,
-26629,   9485,  10046,
-26581,   9471,  10187,
-26554,   9406,  10315,
-26506,   9435,  10411,
-26436,   9556,  10479,
-26434,   9669,  10381,
-26451,   9755,  10257,
-26497,   9774,  10118,
-26549,   9826,   9929,
-26491,   9886,  10026,
-26495,   9928,   9971,
-26552,   9921,   9825,
-26552,  10020,   9728,
-26559,  10089,   9633,
-26600,  10117,   9491,
-26635,  10156,   9351,
-26663,  10213,   9209,
-26718,  10186,   9077,
-26765,  10205,   8917,
-26832,  10122,   8810,

/* 27 */
56, 1,
 12962,  21402, -16551,
 13045,  21364, -16535,
 13138,  21270, -16582,
 13162,  21167, -16695,
 13218,  21060, -16786,
 13310,  20955, -16844,
 13385,  20847, -16920,
 13504,  20757, -16935,
 13578,  20653, -17002,
 13654,  20551, -17066,
 13768,  20532, -16997,
 13891,  20566, -16855,
 13965,  20465, -16917,
 14088,  20376, -16922,
 14226,  20308, -16888,
 14319,  20188, -16953,
 14303,  20098, -17073,
 14348,  19996, -17155,
 14426,  19875, -17230,
 14320,  19895, -17296,
 14190,  19980, -17304,
 14079,  19975, -17400,
 14044,  20033, -17362,
 14095,  20106, -17236,
 14169,  20156, -17116,
 14117,  20254, -17043,
 14003,  20286, -17100,
 13944,  20219, -17227,
 13788,  20285, -17274,
 13664,  20303, -17351,
 13592,  20247, -17474,
 13528,  20184, -17596,
 13450,  20131, -17715,
 13342,  20088, -17845,
 13229,  20207, -17795,
 13112,  20304, -17771,
 12985,  20385, -17772,
 12850,  20445, -17801,
 12720,  20439, -17901,
 12584,  20470, -17962,
 12362,  20560, -18013,
 12415,  20587, -17946,
 12403,  20698, -17826,
 12362,  20799, -17737,
 12240,  20915, -17685,
 12290,  20911, -17655,
 12423,  20832, -17655,
 12548,  20816, -17585,
 12621,  20870, -17469,
 12728,  20899, -17356,
 12791,  20961, -17234,
 12844,  21030, -17110,
 12883,  21107, -16985,
 12900,  21195, -16863,
 12919,  21281, -16741,
 12947,  21361, -16616,

/* 28 */
49, 1,
 -6596,  29135,  -2761,
 -6532,  29140,  -2866,
 -6389,  29166,  -2915,
 -6434,  29143,  -3052,
 -6441,  29132,  -3132,
 -6493,  29108,  -3252,
 -6610,  29094,  -3143,
 -6614,  29087,  -3191,
 -6602,  29071,  -3358,
 -6714,  29059,  -3241,
 -6734,  29042,  -3348,
 -6719,  29029,  -3490,
 -6834,  29000,  -3506,
 -6936,  28990,  -3386,
 -7006,  28986,  -3276,
 -6942,  29021,  -3098,
 -7039,  28997,  -3100,
 -7085,  29001,  -2957,
 -7136,  29004,  -2805,
 -7194,  28988,  -2820,
 -7183,  28977,  -2959,
 -7189,  28960,  -3104,
 -7230,  28934,  -3253,
 -7376,  28901,  -3216,
 -7444,  28898,  -3084,
 -7442,  28914,  -2933,
 -7391,  28942,  -2783,
 -7370,  28959,  -2655,
 -7358,  28976,  -2498,
 -7401,  28976,  -2368,
 -7446,  28976,  -2224,
 -7382,  29001,  -2108,
 -7252,  29039,  -2031,
 -7124,  29075,  -1967,
 -6983,  29108,  -1992,
 -7031,  29087,  -2128,
 -6975,  29094,  -2215,
 -6830,  29126,  -2247,
 -6674,  29163,  -2227,
 -6519,  29200,  -2206,
 -6514,  29193,  -2310,
 -6610,  29162,  -2421,
 -6741,  29133,  -2416,
 -6877,  29098,  -2456,
 -7041,  29061,  -2424,
 -7056,  29048,  -2533,
 -6984,  29052,  -2679,
 -6827,  29085,  -2726,
 -6699,  29114,  -2738,

/* 29 */
50, 1,
 -2179,  24668,  16933,
 -2273,  24621,  16989,
 -2387,  24623,  16970,
 -2508,  24560,  17044,
 -2579,  24503,  17116,
 -2524,  24452,  17197,
 -2598,  24373,  17297,
 -2672,  24349,  17320,
 -2812,  24350,  17297,
 -3027,  24335,  17281,
 -3012,  24255,  17396,
 -2987,  24205,  17470,
 -3118,  24123,  17560,
 -3049,  24073,  17641,
 -2873,  24025,  17735,
 -2950,  23948,  17827,
 -3066,  23851,  17937,
 -2988,  23838,  17967,
 -2838,  23862,  17960,
 -2845,  23843,  17984,
 -3000,  23822,  17987,
 -3117,  23762,  18045,
 -3231,  23694,  18115,
 -3298,  23598,  18228,
 -3162,  23583,  18272,
 -3218,  23542,  18314,
 -3117,  23539,  18336,
 -3141,  23501,  18380,
 -3101,  23479,  18415,
 -2961,  23488,  18427,
 -2805,  23518,  18413,
 -2675,  23579,  18354,
 -2541,  23609,  18335,
 -2417,  23663,  18282,
 -2248,  23696,  18260,
 -2100,  23712,  18257,
 -2013,  23779,  18180,
 -1953,  23870,  18067,
 -1899,  23957,  17957,
 -1911,  24057,  17822,
 -1907,  24136,  17715,
 -1941,  24223,  17592,
 -1891,  24282,  17515,
 -1761,  24336,  17454,
 -1695,  24405,  17364,
 -1733,  24488,  17244,
 -1773,  24558,  17140,
 -1839,  24628,  17032,
 -2071,  24619,  17018,
 -2127,  24667,  16942,

/* 30 */
50, 1,
 -8496, -28645,   2696,
 -8490, -28638,   2793,
 -8441, -28638,   2937,
 -8417, -28630,   3083,
 -8449, -28605,   3218,
 -8520, -28569,   3353,
 -8635, -28524,   3439,
 -8758, -28477,   3517,
 -8896, -28429,   3558,
 -9031, -28380,   3604,
 -9169, -28331,   3640,
 -9312, -28282,   3666,
 -9457, -28235,   3650,
 -9599, -28187,   3654,
 -9740, -28136,   3672,
 -9884, -28085,   3677,
-10018, -28042,   3643,
-10172, -27984,   3665,
-10237, -27975,   3555,
-10227, -27997,   3406,
-10160, -28037,   3274,
-10020, -28088,   3269,
 -9887, -28135,   3271,
 -9756, -28187,   3212,
 -9609, -28239,   3195,
 -9547, -28277,   3049,
 -9433, -28312,   3075,
 -9339, -28330,   3190,
 -9195, -28379,   3179,
 -9209, -28392,   3012,
 -9271, -28386,   2878,
 -9175, -28419,   2856,
 -9176, -28428,   2765,
 -9133, -28449,   2691,
 -9136, -28457,   2596,
 -9120, -28472,   2479,
 -9093, -28490,   2375,
 -8964, -28531,   2374,
 -8860, -28554,   2484,
 -8919, -28525,   2601,
 -8914, -28518,   2693,
 -8963, -28490,   2823,
 -8910, -28500,   2892,
 -8788, -28530,   2968,
 -8726, -28556,   2899,
 -8644, -28572,   2989,
 -8590, -28589,   2982,
 -8623, -28594,   2837,
 -8688, -28588,   2687,
 -8578, -28625,   2652,

/* 31 */
48, 1,
-16082, -24523,   6323,
-16020, -24529,   6458,
-15949, -24539,   6591,
-15879, -24549,   6725,
-15781, -24578,   6846,
-15746, -24559,   6995,
-15696, -24552,   7130,
-15714, -24505,   7250,
-15786, -24468,   7218,
-15856, -24461,   7089,
-15964, -24420,   6989,
-16084, -24361,   6918,
-16198, -24309,   6833,
-16317, -24250,   6758,
-16436, -24184,   6710,
-16562, -24108,   6673,
-16720, -24010,   6631,
-16810, -23934,   6679,
-16935, -23857,   6638,
-16995, -23841,   6542,
-17074, -23814,   6431,
-17068, -23846,   6331,
-17058, -23899,   6154,
-16992, -23968,   6068,
-16886, -24059,   6002,
-16809, -24090,   6094,
-16753, -24084,   6267,
-16691, -24155,   6162,
-16665, -24207,   6025,
-16541, -24294,   6015,
-16437, -24341,   6110,
-16331, -24386,   6217,
-16268, -24440,   6170,
-16301, -24423,   6149,
-16379, -24396,   6047,
-16449, -24375,   5943,
-16569, -24331,   5786,
-16442, -24403,   5846,
-16467, -24408,   5750,
-16531, -24405,   5577,
-16546, -24426,   5439,
-16485, -24462,   5462,
-16452, -24459,   5578,
-16362, -24490,   5704,
-16284, -24512,   5831,
-16246, -24504,   5968,
-16148, -24541,   6080,
-16100, -24536,   6225,

/* 32 */
48, -1,
-13245,  26217,  -6103,
-13278,  26234,  -5958,
-13269,  26268,  -5824,
-13181,  26333,  -5732,
-13204,  26349,  -5600,
-13216,  26373,  -5459,
-13160,  26428,  -5325,
-13089,  26490,  -5191,
-13022,  26543,  -5092,
-13002,  26580,  -4946,
-13029,  26590,  -4816,
-12998,  26613,  -4772,
-12968,  26615,  -4843,
-12923,  26660,  -4715,
-12880,  26658,  -4844,
-12873,  26631,  -5009,
-12881,  26616,  -5070,
-12834,  26677,  -4861,
-12862,  26687,  -4730,
-12943,  26671,  -4596,
-12977,  26668,  -4516,
-12830,  26714,  -4664,
-12780,  26712,  -4809,
-12787,  26681,  -4959,
-12854,  26627,  -5078,
-12930,  26568,  -5192,
-12974,  26519,  -5332,
-12954,  26498,  -5483,
-12897,  26498,  -5614,
-12775,  26544,  -5679,
-12662,  26580,  -5760,
-12545,  26612,  -5868,
-12420,  26650,  -5958,
-12410,  26642,  -6017,
-12554,  26589,  -5952,
-12687,  26528,  -5942,
-12841,  26459,  -5918,
-12843,  26428,  -6051,
-12854,  26395,  -6172,
-12936,  26328,  -6283,
-12951,  26300,  -6371,
-12881,  26303,  -6497,
-12842,  26291,  -6624,
-12822,  26291,  -6663,
-12957,  26248,  -6568,
-13055,  26225,  -6468,
-13158,  26200,  -6358,
-13215,  26202,  -6233,

/* 33 */
47, 1,
 -6930,  29187,   -252,
 -6981,  29174,   -385,
 -6897,  29194,   -393,
 -6780,  29220,   -475,
 -6715,  29233,   -607,
 -6717,  29228,   -764,
 -6833,  29201,   -787,
 -6967,  29171,   -709,
 -7079,  29146,   -620,
 -7090,  29147,   -447,
 -7160,  29131,   -349,
 -7296,  29098,   -297,
 -7442,  29061,   -275,
 -7581,  29025,   -321,
 -7715,  28990,   -293,
 -7876,  28946,   -259,
 -7903,  28940,   -142,
 -7982,  28919,     -8,
 -7892,  28943,    160,
 -8007,  28911,    253,
 -8005,  28909,    411,
 -7983,  28914,    519,
 -7949,  28920,    649,
 -7959,  28915,    741,
 -7850,  28941,    907,
 -7923,  28917,   1015,
 -7934,  28909,   1153,
 -7867,  28921,   1307,
 -7703,  28962,   1362,
 -7612,  28988,   1329,
 -7466,  29023,   1375,
 -7381,  29050,   1276,
 -7315,  29072,   1134,
 -7283,  29086,    991,
 -7322,  29081,    835,
 -7386,  29068,    704,
 -7477,  29048,    572,
 -7538,  29033,    481,
 -7485,  29049,    337,
 -7489,  29050,    183,
 -7453,  29059,     76,
 -7321,  29093,     39,
 -7289,  29101,    -79,
 -7207,  29121,   -120,
 -7152,  29135,      3,
 -7019,  29167,   -105,
 -6918,  29191,   -165,

/* 34 */
48, 1,
  1042,  29488,   5419,
  1140,  29468,   5506,
  1192,  29440,   5642,
  1240,  29410,   5787,
  1330,  29392,   5861,
  1449,  29370,   5941,
  1505,  29391,   5825,
  1515,  29417,   5689,
  1561,  29418,   5669,
  1638,  29401,   5734,
  1696,  29405,   5697,
  1714,  29381,   5814,
  1587,  29360,   5958,
  1503,  29344,   6054,
  1569,  29319,   6161,
  1714,  29328,   6079,
  1801,  29324,   6069,
  1701,  29302,   6206,
  1758,  29290,   6247,
  1601,  29287,   6301,
  1676,  29253,   6436,
  1822,  29235,   6480,
  1876,  29219,   6538,
  1996,  29192,   6620,
  1999,  29236,   6423,
  1984,  29270,   6272,
  2016,  29296,   6140,
  1993,  29330,   5982,
  1999,  29357,   5847,
  1977,  29389,   5688,
  2039,  29411,   5555,
  2108,  29427,   5441,
  1938,  29456,   5349,
  1814,  29474,   5288,
  1690,  29500,   5185,
  1612,  29529,   5044,
  1478,  29539,   5024,
  1455,  29516,   5165,
  1513,  29489,   5300,
  1581,  29462,   5432,
  1572,  29455,   5470,
  1476,  29486,   5328,
  1402,  29513,   5199,
  1326,  29514,   5210,
  1274,  29500,   5304,
  1200,  29527,   5167,
  1094,  29520,   5230,
  1031,  29506,   5324,

/* 35 */
44, -1,
 14587,  -2200,  26122,
 14605,  -2253,  26108,
 14566,  -2389,  26117,
 14538,  -2545,  26118,
 14545,  -2696,  26099,
 14597,  -2834,  26056,
 14631,  -2970,  26021,
 14566,  -3107,  26042,
 14594,  -3236,  26011,
 14646,  -3379,  25963,
 14686,  -3514,  25923,
 14761,  -3633,  25863,
 14859,  -3716,  25795,
 14945,  -3817,  25731,
 14964,  -3963,  25698,
 15001,  -4103,  25654,
 15084,  -4216,  25587,
 15080,  -4412,  25556,
 15180,  -4472,  25487,
 15298,  -4562,  25400,
 15352,  -4471,  25383,
 15308,  -4343,  25433,
 15261,  -4217,  25482,
 15208,  -4079,  25536,
 15151,  -3945,  25591,
 15136,  -3795,  25622,
 15126,  -3660,  25648,
 15063,  -3515,  25705,
 14978,  -3401,  25770,
 14860,  -3363,  25843,
 14792,  -3232,  25899,
 14861,  -3110,  25874,
 14879,  -2978,  25880,
 14831,  -2839,  25923,
 14849,  -2689,  25928,
 14782,  -2559,  25980,
 14785,  -2412,  25992,
 14776,  -2269,  26010,
 14722,  -2131,  26053,
 14675,  -1991,  26090,
 14644,  -1799,  26121,
 14581,  -1884,  26150,
 14560,  -2031,  26151,
 14545,  -2184,  26147,

/* 36 */
44, -1,
 15944,  24781,  -5628,
 16037,  24729,  -5595,
 16161,  24642,  -5620,
 16287,  24563,  -5601,
 16414,  24482,  -5586,
 16541,  24404,  -5555,
 16667,  24323,  -5533,
 16793,  24242,  -5507,
 16908,  24180,  -5427,
 17029,  24106,  -5376,
 17140,  24046,  -5293,
 17262,  23972,  -5229,
 17380,  23894,  -5197,
 17487,  23834,  -5116,
 17588,  23780,  -5017,
 17707,  23703,  -4964,
 17816,  23637,  -4887,
 17900,  23598,  -4766,
 17967,  23572,  -4639,
 18040,  23550,  -4468,
 18092,  23498,  -4531,
 18088,  23472,  -4679,
 18035,  23486,  -4814,
 17961,  23515,  -4943,
 17880,  23551,  -5069,
 17767,  23620,  -5141,
 17646,  23708,  -5152,
 17559,  23753,  -5239,
 17482,  23789,  -5333,
 17380,  23842,  -5431,
 17296,  23875,  -5553,
 17187,  23933,  -5640,
 17071,  24006,  -5681,
 16964,  24058,  -5782,
 16880,  24126,  -5742,
 16788,  24189,  -5748,
 16762,  24187,  -5834,
 16632,  24269,  -5863,
 16515,  24352,  -5852,
 16396,  24441,  -5815,
 16272,  24523,  -5816,
 16149,  24608,  -5800,
 16024,  24694,  -5780,
 15902,  24789,  -5715,

/* 37 */
44, 1,
  6601,  28935,   4379,
  6617,  28914,   4497,
  6691,  28878,   4612,
  6745,  28857,   4665,
  6750,  28831,   4815,
  6827,  28795,   4925,
  6904,  28787,   4861,
  6967,  28752,   4981,
  7104,  28744,   4828,
  7203,  28735,   4734,
  7136,  28769,   4629,
  7058,  28801,   4550,
  7059,  28818,   4438,
  6964,  28853,   4361,
  6936,  28879,   4230,
  6843,  28914,   4143,
  6830,  28937,   4003,
  6777,  28968,   3861,
  6727,  28992,   3766,
  6688,  29020,   3618,
  6667,  29045,   3457,
  6660,  29065,   3300,
  6666,  29080,   3151,
  6656,  29098,   3001,
  6644,  29116,   2853,
  6613,  29137,   2702,
  6560,  29159,   2587,
  6445,  29194,   2489,
  6302,  29224,   2499,
  6240,  29226,   2630,
  6280,  29203,   2780,
  6357,  29176,   2892,
  6371,  29156,   3054,
  6357,  29142,   3214,
  6306,  29140,   3330,
  6271,  29132,   3466,
  6291,  29114,   3576,
  6285,  29093,   3752,
  6314,  29066,   3909,
  6373,  29034,   4051,
  6388,  29013,   4178,
  6433,  28985,   4302,
  6559,  28946,   4371,
  6639,  28936,   4317,

/* 38 */
42, -1,
-10564,  27211,  -6925,
-10666,  27196,  -6827,
-10758,  27193,  -6696,
-10692,  27249,  -6570,
-10648,  27297,  -6442,
-10705,  27306,  -6306,
-10809,  27243,  -6401,
-10863,  27177,  -6587,
-10903,  27179,  -6512,
-10894,  27220,  -6357,
-10859,  27271,  -6197,
-10726,  27333,  -6153,
-10727,  27362,  -6021,
-10858,  27350,  -5837,
-10767,  27409,  -5728,
-10704,  27454,  -5628,
-10580,  27517,  -5555,
-10556,  27505,  -5662,
-10559,  27476,  -5795,
-10474,  27476,  -5946,
-10363,  27496,  -6047,
-10301,  27539,  -5956,
-10296,  27579,  -5781,
-10195,  27612,  -5798,
-10134,  27608,  -5923,
-10105,  27586,  -6073,
-10101,  27556,  -6214,
-10072,  27529,  -6379,
-10028,  27513,  -6517,
 -9997,  27491,  -6656,
 -9971,  27439,  -6905,
-10041,  27436,  -6814,
-10144,  27432,  -6677,
-10161,  27452,  -6570,
-10229,  27461,  -6425,
-10356,  27432,  -6342,
-10419,  27395,  -6399,
-10307,  27403,  -6545,
-10366,  27377,  -6563,
-10447,  27326,  -6647,
-10485,  27283,  -6760,
-10524,  27237,  -6884,

/* 39 */
42, -1,
 15744,  -1075,  25514,
 15750,  -1211,  25505,
 15813,  -1397,  25456,
 15908,  -1314,  25401,
 16002,  -1224,  25346,
 16121,  -1294,  25267,
 16218,  -1324,  25204,
 16230,  -1493,  25187,
 16285,  -1476,  25152,
 16278,  -1318,  25165,
 16373,  -1274,  25106,
 16495,  -1312,  25024,
 16627,  -1173,  24943,
 16473,  -1111,  25048,
 16509,  -1019,  25029,
 16592,   -908,  24978,
 16674,   -786,  24927,
 16732,   -679,  24891,
 16802,   -538,  24847,
 16816,   -409,  24841,
 16842,   -266,  24825,
 16958,   -234,  24746,
 17091,   -163,  24655,
 17066,    -71,  24673,
 16930,   -143,  24766,
 16838,    -82,  24829,
 16773,     18,  24873,
 16699,    117,  24922,
 16593,    126,  24993,
 16501,    189,  25054,
 16395,    135,  25123,
 16295,     69,  25189,
 16178,     80,  25264,
 16055,     17,  25342,
 15939,    -32,  25415,
 15886,   -130,  25448,
 15827,   -272,  25484,
 15782,   -417,  25510,
 15817,   -552,  25485,
 15812,   -719,  25485,
 15775,   -852,  25504,
 15736,  -1001,  25522,

/* 40 */
41, -1,
 10098,  22921,  16512,
 10171,  22873,  16534,
 10309,  22814,  16531,
 10448,  22757,  16522,
 10594,  22697,  16511,
 10736,  22652,  16481,
 10862,  22640,  16415,
 10996,  22586,  16399,
 11137,  22535,  16374,
 11275,  22481,  16354,
 11422,  22444,  16304,
 11516,  22346,  16372,
 11574,  22247,  16465,
 11602,  22153,  16573,
 11476,  22145,  16670,
 11359,  22137,  16761,
 11351,  22060,  16868,
 11336,  21965,  17001,
 11318,  21886,  17115,
 11170,  21839,  17271,
 11220,  21849,  17226,
 11341,  21875,  17114,
 11372,  21935,  17016,
 11397,  22047,  16853,
 11418,  22096,  16775,
 11526,  22118,  16671,
 11668,  22092,  16607,
 11680,  22153,  16517,
 11582,  22253,  16452,
 11523,  22348,  16364,
 11456,  22467,  16248,
 11411,  22470,  16275,
 11273,  22494,  16338,
 11126,  22561,  16346,
 11015,  22608,  16357,
 10857,  22652,  16401,
 10720,  22701,  16424,
 10556,  22789,  16409,
 10447,  22795,  16469,
 10302,  22834,  16507,
 10161,  22882,  16528,

/* 41 */
41, 1,
 13989,  -2192, -26448,
 14075,  -2230, -26399,
 14234,  -2219, -26315,
 14215,  -2366, -26312,
 14190,  -2534, -26310,
 14293,  -2581, -26250,
 14403,  -2650, -26183,
 14468,  -2774, -26134,
 14552,  -2864, -26078,
 14670,  -2875, -26010,
 14793,  -2891, -25938,
 14892,  -2832, -25888,
 14886,  -2685, -25908,
 14929,  -2681, -25883,
 14962,  -2831, -25848,
 15065,  -2890, -25781,
 15190,  -2916, -25705,
 15316,  -2899, -25633,
 15444,  -2879, -25557,
 15573,  -2876, -25480,
 15669,  -2915, -25416,
 15602,  -3033, -25444,
 15473,  -3081, -25517,
 15358,  -3168, -25575,
 15264,  -3187, -25629,
 15138,  -3220, -25699,
 15030,  -3290, -25754,
 14897,  -3287, -25831,
 14771,  -3284, -25904,
 14646,  -3237, -25981,
 14537,  -3172, -26050,
 14411,  -3126, -26126,
 14307,  -3036, -26193,
 14233,  -2922, -26247,
 14097,  -2908, -26321,
 13981,  -2828, -26392,
 14028,  -2672, -26383,
 13945,  -2602, -26434,
 13861,  -2493, -26489,
 13864,  -2337, -26502,
 13936,  -2234, -26473,

/* 42 */
42, -1,
   119,   4674,  29633,
    88,   4579,  29648,
    62,   4423,  29672,
    80,   4291,  29691,
    18,   4132,  29714,
  -118,   4236,  29699,
  -182,   4289,  29691,
  -305,   4319,  29686,
  -393,   4445,  29666,
  -431,   4516,  29655,
  -570,   4663,  29630,
  -576,   4579,  29643,
  -774,   4545,  29644,
  -715,   4545,  29645,
  -575,   4501,  29655,
  -449,   4433,  29667,
  -373,   4291,  29689,
  -296,   4220,  29700,
  -177,   4186,  29706,
   -87,   4067,  29723,
  -255,   3970,  29735,
   -93,   3962,  29737,
   -34,   3904,  29745,
    51,   3784,  29760,
    43,   3648,  29777,
   -21,   3534,  29791,
  -154,   3520,  29792,
  -297,   3549,  29788,
  -292,   3511,  29792,
  -151,   3445,  29801,
    -7,   3360,  29811,
    46,   3278,  29820,
    58,   3290,  29819,
   123,   3466,  29799,
   128,   3589,  29784,
   146,   3730,  29767,
   143,   3902,  29745,
   128,   4067,  29723,
    88,   4173,  29708,
   110,   4327,  29686,
    72,   4457,  29667,
   109,   4599,  29645,

/* 43 */
38, -1,
 16496,  -5129,  24527,
 16526,  -5272,  24476,
 16589,  -5399,  24406,
 16575,  -5541,  24384,
 16573,  -5693,  24350,
 16557,  -5840,  24326,
 16563,  -5987,  24286,
 16526,  -6122,  24278,
 16447,  -6249,  24299,
 16415,  -6396,  24282,
 16455,  -6517,  24223,
 16478,  -6666,  24167,
 16482,  -6803,  24126,
 16465,  -6950,  24096,
 16530,  -7066,  24017,
 16526,  -7198,  23981,
 16523,  -7337,  23940,
 16603,  -7345,  23883,
 16669,  -7309,  23848,
 16759,  -7369,  23766,
 16731,  -7146,  23854,
 16666,  -7054,  23926,
 16670,  -6905,  23967,
 16674,  -6757,  24007,
 16698,  -6611,  24030,
 16684,  -6468,  24079,
 16715,  -6322,  24097,
 16797,  -6201,  24071,
 16837,  -6057,  24080,
 16811,  -5924,  24131,
 16747,  -5821,  24200,
 16740,  -5682,  24238,
 16755,  -5535,  24262,
 16748,  -5389,  24300,
 16741,  -5240,  24337,
 16689,  -5113,  24399,
 16616,  -5005,  24472,
 16532,  -4986,  24532,

/* 44 */
38, -1,
 18721,  21147,  10116,
 18680,  21234,  10009,
 18582,  21296,  10061,
 18439,  21402,  10097,
 18329,  21477,  10138,
 18232,  21582,  10089,
 18193,  21673,   9966,
 18147,  21757,   9864,
 18065,  21853,   9803,
 18030,  21796,   9992,
 17921,  21835,  10103,
 17880,  21825,  10197,
 17869,  21761,  10352,
 17957,  21663,  10404,
 17882,  21667,  10524,
 17980,  21550,  10597,
 17935,  21559,  10656,
 17853,  21561,  10788,
 17884,  21478,  10903,
 17947,  21378,  10994,
 18002,  21279,  11097,
 18062,  21177,  11194,
 18158,  21069,  11242,
 18250,  20961,  11295,
 18358,  20861,  11305,
 18470,  20736,  11352,
 18531,  20767,  11195,
 18581,  20759,  11126,
 18662,  20746,  11015,
 18769,  20679,  10959,
 18847,  20636,  10907,
 18882,  20678,  10764,
 18942,  20690,  10636,
 18949,  20742,  10522,
 18846,  20833,  10526,
 18804,  20936,  10396,
 18733,  21040,  10315,
 18719,  21091,  10236,

/* 45 */
36, 1,
 -7108,  28862,  -4057,
 -6996,  28883,  -4101,
 -6855,  28909,  -4159,
 -6785,  28907,  -4286,
 -6726,  28899,  -4426,
 -6685,  28884,  -4588,
 -6817,  28841,  -4660,
 -6963,  28802,  -4688,
 -7056,  28759,  -4808,
 -7135,  28718,  -4935,
 -7236,  28677,  -5025,
 -7335,  28631,  -5143,
 -7407,  28589,  -5273,
 -7496,  28542,  -5399,
 -7600,  28523,  -5357,
 -7739,  28494,  -5311,
 -7879,  28462,  -5278,
 -8020,  28417,  -5305,
 -8149,  28387,  -5272,
 -8148,  28416,  -5110,
 -8158,  28436,  -4984,
 -8180,  28456,  -4833,
 -8073,  28502,  -4738,
 -7948,  28555,  -4628,
 -7935,  28579,  -4505,
 -7851,  28621,  -4383,
 -7804,  28654,  -4246,
 -7781,  28682,  -4099,
 -7760,  28708,  -3952,
 -7741,  28733,  -3805,
 -7694,  28764,  -3665,
 -7546,  28802,  -3673,
 -7401,  28835,  -3707,
 -7258,  28866,  -3752,
 -7168,  28873,  -3870,
 -7170,  28853,  -4009,

/* 46 */
37, 1,
-12612,  27178,   1511,
-12540,  27216,   1425,
-12489,  27246,   1288,
-12460,  27266,   1148,
-12374,  27309,   1050,
-12249,  27367,    996,
-12247,  27372,    899,
-12376,  27315,    851,
-12512,  27253,    844,
-12654,  27188,    844,
-12781,  27129,    828,
-12917,  27064,    818,
-13058,  26996,    845,
-13159,  26950,    735,
-13294,  26885,    668,
-13301,  26878,    790,
-13258,  26895,    951,
-13331,  26856,   1021,
-13469,  26786,   1036,
-13499,  26767,   1149,
-13407,  26808,   1265,
-13282,  26867,   1333,
-13180,  26911,   1444,
-13045,  26975,   1477,
-13024,  26978,   1591,
-13102,  26932,   1729,
-13183,  26888,   1807,
-13206,  26866,   1956,
-13216,  26850,   2102,
-13099,  26898,   2216,
-13018,  26941,   2173,
-12962,  26977,   2059,
-12996,  26971,   1910,
-12948,  26997,   1879,
-12807,  27066,   1847,
-12707,  27120,   1747,
-12665,  27148,   1613,

/* 47 */
37, 1,
 29276,   3899,   5265,
 29298,   3743,   5253,
 29318,   3595,   5246,
 29343,   3446,   5206,
 29366,   3305,   5168,
 29393,   3175,   5097,
 29422,   3113,   4964,
 29445,   3121,   4821,
 29462,   3180,   4679,
 29478,   3228,   4541,
 29490,   3306,   4407,
 29495,   3408,   4295,
 29487,   3545,   4234,
 29473,   3692,   4205,
 29449,   3860,   4226,
 29424,   3981,   4285,
 29403,   4086,   4331,
 29368,   4240,   4420,
 29339,   4391,   4466,
 29315,   4478,   4539,
 29279,   4633,   4616,
 29252,   4727,   4687,
 29221,   4852,   4750,
 29185,   4961,   4861,
 29150,   5061,   4969,
 29141,   5074,   5006,
 29154,   5033,   4973,
 29133,   5045,   5084,
 29173,   4951,   4944,
 29152,   4930,   5083,
 29175,   4780,   5095,
 29184,   4645,   5170,
 29204,   4491,   5194,
 29217,   4347,   5239,
 29225,   4241,   5284,
 29253,   4054,   5276,
 29265,   3973,   5269,

/* 48 */
36, 1,
 23365,    142, -18817,
 23419,    236, -18748,
 23490,    320, -18658,
 23545,    426, -18587,
 23456,    523, -18696,
 23405,    630, -18757,
 23410,    786, -18744,
 23495,    792, -18638,
 23578,    684, -18536,
 23616,    577, -18492,
 23679,    455, -18415,
 23738,    508, -18337,
 23667,    627, -18425,
 23628,    753, -18470,
 23640,    902, -18449,
 23642,   1081, -18436,
 23702,   1046, -18361,
 23760,    918, -18293,
 23786,    778, -18266,
 23820,    611, -18228,
 23787,    484, -18274,
 23782,    353, -18283,
 23764,    210, -18310,
 23738,     83, -18343,
 23743,    -68, -18337,
 23701,   -188, -18392,
 23646,   -313, -18460,
 23548,   -436, -18582,
 23566,   -367, -18561,
 23617,   -239, -18498,
 23652,   -100, -18454,
 23672,     46, -18429,
 23659,    207, -18445,
 23568,    218, -18560,
 23478,    185, -18675,
 23388,    137, -18788,

/* 49 */
37, 1,
 12054, -19593, -19257,
 12112, -19628, -19184,
 12209, -19670, -19079,
 12337, -19705, -18961,
 12413, -19733, -18883,
 12532, -19744, -18791,
 12671, -19706, -18738,
 12809, -19646, -18707,
 12948, -19599, -18661,
 13098, -19570, -18586,
 13118, -19633, -18506,
 13063, -19738, -18433,
 12973, -19846, -18380,
 12871, -19951, -18338,
 12756, -20043, -18318,
 12612, -20189, -18258,
 12610, -20263, -18177,
 12520, -20359, -18132,
 12405, -20457, -18101,
 12269, -20549, -18089,
 12162, -20610, -18091,
 12041, -20657, -18119,
 11916, -20688, -18166,
 11872, -20631, -18260,
 11874, -20542, -18358,
 11862, -20438, -18483,
 11804, -20434, -18524,
 11674, -20490, -18544,
 11662, -20430, -18617,
 11718, -20324, -18699,
 11742, -20222, -18793,
 11720, -20119, -18917,
 11724, -20054, -18983,
 11779, -19942, -19067,
 11836, -19818, -19161,
 11887, -19712, -19240,
 11976, -19615, -19283,

/* 50 */
35, -1,
 19917,  21699,   5700,
 19946,  21645,   5798,
 20020,  21556,   5878,
 20091,  21467,   5959,
 20208,  21369,   5916,
 20357,  21252,   5827,
 20292,  21329,   5772,
 20200,  21431,   5717,
 20134,  21505,   5669,
 20071,  21584,   5594,
 20056,  21630,   5466,
 19983,  21729,   5344,
 19976,  21765,   5218,
 19976,  21785,   5136,
 20031,  21770,   4983,
 20055,  21778,   4851,
 20114,  21757,   4697,
 20152,  21751,   4557,
 20209,  21730,   4405,
 20265,  21704,   4271,
 20289,  21708,   4140,
 20301,  21727,   3976,
 20203,  21835,   3885,
 20179,  21835,   4002,
 20192,  21793,   4162,
 20145,  21808,   4312,
 20113,  21811,   4447,
 20082,  21801,   4633,
 20042,  21811,   4753,
 19980,  21843,   4867,
 19921,  21867,   5000,
 19903,  21848,   5153,
 19843,  21867,   5301,
 19829,  21844,   5446,
 19880,  21767,   5567,

/* 51 */
41, 1,
 -4651,  29635,   -334,
 -4703,  29626,   -408,
 -4850,  29603,   -374,
 -4892,  29595,   -451,
 -4991,  29577,   -532,
 -5114,  29557,   -447,
 -5147,  29550,   -563,
 -5258,  29530,   -583,
 -5348,  29516,   -458,
 -5398,  29506,   -477,
 -5512,  29485,   -510,
 -5520,  29486,   -356,
 -5546,  29482,   -203,
 -5602,  29472,   -109,
 -5621,  29469,   -106,
 -5638,  29464,   -260,
 -5695,  29452,   -386,
 -5831,  29426,   -359,
 -5953,  29402,   -262,
 -6088,  29375,   -238,
 -6157,  29361,   -103,
 -6058,  29382,      3,
 -6102,  29373,     84,
 -6073,  29379,    143,
 -5941,  29405,    175,
 -5749,  29443,    195,
 -5825,  29428,    220,
 -5757,  29441,    299,
 -5667,  29457,    379,
 -5491,  29490,    438,
 -5425,  29504,    315,
 -5310,  29525,    264,
 -5189,  29547,    229,
 -5057,  29570,    206,
 -5091,  29565,    132,
 -5019,  29577,     73,
 -4927,  29593,     -8,
 -4797,  29614,    -93,
 -4654,  29637,   -143,
 -4527,  29656,   -220,
 -4574,  29648,   -298,

/* 52 */
36, -1,
-17857,  23953,  -2714,
-17926,  23893,  -2788,
-18040,  23816,  -2717,
-18149,  23741,  -2645,
-18260,  23662,  -2589,
-18308,  23633,  -2507,
-18297,  23651,  -2416,
-18389,  23587,  -2341,
-18493,  23509,  -2311,
-18527,  23492,  -2203,
-18637,  23403,  -2226,
-18751,  23306,  -2281,
-18872,  23207,  -2306,
-18959,  23143,  -2231,
-18875,  23222,  -2120,
-18727,  23344,  -2088,
-18630,  23421,  -2085,
-18522,  23502,  -2144,
-18409,  23586,  -2188,
-18290,  23674,  -2236,
-18181,  23757,  -2250,
-18054,  23850,  -2283,
-17932,  23938,  -2323,
-17817,  24023,  -2342,
-17699,  24105,  -2388,
-17579,  24189,  -2427,
-17462,  24271,  -2446,
-17351,  24353,  -2425,
-17331,  24363,  -2466,
-17452,  24270,  -2534,
-17541,  24207,  -2517,
-17500,  24213,  -2738,
-17619,  24117,  -2815,
-17730,  24029,  -2869,
-17814,  23978,  -2776,
-17835,  23976,  -2665,

/* 53 */
35, 1,
 18868,  16148, -16830,
 18750,  16259, -16855,
 18707,  16352, -16812,
 18718,  16438, -16716,
 18731,  16503, -16636,
 18683,  16608, -16587,
 18797,  16599, -16466,
 18815,  16688, -16355,
 18832,  16739, -16284,
 18942,  16702, -16193,
 19048,  16614, -16160,
 19167,  16558, -16076,
 19271,  16491, -16021,
 19330,  16397, -16046,
 19344,  16307, -16121,
 19375,  16198, -16193,
 19257,  16245, -16287,
 19168,  16381, -16255,
 19169,  16237, -16399,
 19211,  16138, -16447,
 19317,  16009, -16450,
 19426,  15905, -16421,
 19476,  15773, -16489,
 19546,  15638, -16535,
 19542,  15557, -16616,
 19471,  15573, -16684,
 19414,  15712, -16621,
 19368,  15720, -16666,
 19410,  15585, -16743,
 19438,  15496, -16794,
 19287,  15620, -16853,
 19178,  15693, -16910,
 19101,  15819, -16879,
 19024,  15945, -16848,
 18945,  16054, -16833,

/* 54 */
34, -1,
-21907,  20246,   3192,
-21969,  20189,   3129,
-22031,  20141,   2994,
-22106,  20075,   2884,
-22115,  20089,   2714,
-22026,  20188,   2709,
-21989,  20204,   2879,
-21917,  20284,   2864,
-21909,  20306,   2769,
-22008,  20207,   2702,
-22110,  20105,   2640,
-22214,  19997,   2582,
-22283,  19896,   2761,
-22306,  19861,   2826,
-22302,  19847,   2954,
-22257,  19875,   3101,
-22223,  19890,   3247,
-22144,  19959,   3361,
-22078,  20010,   3487,
-22019,  20051,   3621,
-21941,  20108,   3775,
-21888,  20147,   3874,
-21815,  20203,   3995,
-21732,  20270,   4103,
-21646,  20343,   4199,
-21550,  20438,   4229,
-21554,  20445,   4177,
-21615,  20409,   4035,
-21653,  20397,   3891,
-21745,  20327,   3739,
-21783,  20294,   3691,
-21786,  20318,   3543,
-21797,  20331,   3395,
-21851,  20296,   3262,

/* 55 */
35, -1,
 16309,  24931,  -3533,
 16333,  24928,  -3444,
 16435,  24871,  -3364,
 16503,  24821,  -3403,
 16622,  24729,  -3492,
 16625,  24714,  -3581,
 16738,  24630,  -3632,
 16722,  24638,  -3651,
 16604,  24721,  -3630,
 16539,  24780,  -3524,
 16432,  24857,  -3485,
 16350,  24897,  -3584,
 16314,  24902,  -3706,
 16409,  24826,  -3797,
 16515,  24745,  -3866,
 16623,  24662,  -3928,
 16744,  24580,  -3931,
 16861,  24501,  -3927,
 16981,  24410,  -3976,
 17095,  24334,  -3951,
 17238,  24224,  -4004,
 17283,  24185,  -4044,
 17434,  24060,  -4145,
 17329,  24128,  -4191,
 17267,  24185,  -4114,
 17175,  24267,  -4019,
 17061,  24346,  -4025,
 16965,  24416,  -4007,
 16862,  24497,  -3942,
 16741,  24580,  -3945,
 16619,  24664,  -3937,
 16506,  24748,  -3880,
 16404,  24826,  -3816,
 16274,  24923,  -3737,
 16261,  24953,  -3596,

/* 56 */
34, 1,
-15019,  23246, -11578,
-14910,  23264, -11682,
-14918,  23205, -11790,
-15047,  23143, -11747,
-15108,  23141, -11673,
-15227,  23027, -11742,
-15345,  22995, -11652,
-15459,  22950, -11590,
-15579,  22896, -11536,
-15655,  22849, -11526,
-15718,  22782, -11574,
-15828,  22756, -11473,
-15934,  22687, -11463,
-16056,  22632, -11402,
-16121,  22648, -11278,
-16125,  22668, -11232,
-16194,  22556, -11357,
-16349,  22491, -11263,
-16453,  22454, -11186,
-16570,  22417, -11087,
-16622,  22438, -10965,
-16528,  22521, -10939,
-16394,  22618, -10940,
-16279,  22698, -10946,
-16167,  22748, -11007,
-16038,  22793, -11103,
-15918,  22872, -11112,
-15792,  22955, -11121,
-15669,  23040, -11120,
-15552,  23101, -11156,
-15442,  23127, -11256,
-15334,  23147, -11362,
-15224,  23172, -11457,
-15107,  23211, -11533,

/* 57 */
31, 1,
 24179,  -4896, -17070,
 24114,  -4821, -17184,
 24036,  -4779, -17304,
 23959,  -4730, -17424,
 23883,  -4680, -17542,
 23811,  -4620, -17655,
 23736,  -4562, -17771,
 23663,  -4494, -17884,
 23643,  -4379, -17939,
 23748,  -4370, -17802,
 23832,  -4412, -17680,
 23919,  -4418, -17561,
 24004,  -4436, -17439,
 24091,  -4445, -17317,
 24173,  -4473, -17195,
 24249,  -4528, -17073,
 24287,  -4649, -16986,
 24350,  -4729, -16874,
 24417,  -4790, -16759,
 24492,  -4834, -16636,
 24556,  -4907, -16520,
 24604,  -5012, -16418,
 24610,  -5154, -16365,
 24590,  -5276, -16355,
 24581,  -5392, -16330,
 24493,  -5373, -16468,
 24428,  -5307, -16587,
 24349,  -5270, -16714,
 24299,  -5169, -16818,
 24253,  -5061, -16916,
 24228,  -4963, -16981,

/* 58 */
32, -1,
 13075,  24485,  11382,
 13035,  24537,  11315,
 13049,  24595,  11171,
 13066,  24647,  11037,
 13124,  24679,  10896,
 13188,  24702,  10765,
 13272,  24705,  10655,
 13301,  24761,  10487,
 13231,  24789,  10508,
 13259,  24735,  10600,
 13183,  24714,  10743,
 13098,  24707,  10863,
 13023,  24692,  10986,
 12911,  24694,  11114,
 12959,  24634,  11190,
 12980,  24560,  11329,
 13031,  24478,  11446,
 13037,  24416,  11572,
 13145,  24322,  11648,
 13281,  24260,  11623,
 13376,  24180,  11679,
 13508,  24092,  11710,
 13502,  24057,  11787,
 13521,  24047,  11786,
 13608,  24092,  11592,
 13518,  24116,  11649,
 13436,  24190,  11589,
 13381,  24297,  11429,
 13334,  24277,  11525,
 13241,  24296,  11592,
 13111,  24370,  11585,
 13117,  24438,  11433,

/* 59 */
29, 1,
 -3768, -29624,   2870,
 -3723, -29620,   2964,
 -3672, -29612,   3106,
 -3613, -29604,   3244,
 -3556, -29596,   3384,
 -3524, -29582,   3531,
 -3572, -29561,   3660,
 -3603, -29542,   3778,
 -3694, -29513,   3913,
 -3847, -29485,   3976,
 -3926, -29459,   4093,
 -4101, -29434,   4104,
 -4116, -29411,   4251,
 -4222, -29379,   4364,
 -4371, -29355,   4380,
 -4515, -29339,   4337,
 -4614, -29340,   4228,
 -4630, -29359,   4078,
 -4605, -29383,   3929,
 -4542, -29410,   3795,
 -4452, -29439,   3674,
 -4348, -29468,   3568,
 -4233, -29496,   3472,
 -4156, -29522,   3344,
 -4101, -29546,   3201,
 -4083, -29563,   3055,
 -4058, -29581,   2912,
 -3964, -29605,   2794,
 -3829, -29623,   2796,

/* 60 */
30, 1,
 -8205,  28819,  -1455,
 -8254,  28801,  -1550,
 -8361,  28766,  -1624,
 -8487,  28732,  -1561,
 -8618,  28693,  -1569,
 -8730,  28656,  -1628,
 -8702,  28657,  -1749,
 -8567,  28692,  -1831,
 -8651,  28660,  -1947,
 -8790,  28620,  -1908,
 -8919,  28585,  -1836,
 -9006,  28564,  -1726,
 -9131,  28529,  -1655,
 -9261,  28491,  -1586,
 -9403,  28446,  -1547,
 -9493,  28421,  -1456,
 -9328,  28481,  -1356,
 -9367,  28474,  -1234,
 -9280,  28508,  -1094,
 -9169,  28545,  -1060,
 -9034,  28588,  -1038,
 -8883,  28636,  -1050,
 -8784,  28664,  -1111,
 -8691,  28687,  -1243,
 -8584,  28721,  -1198,
 -8470,  28758,  -1099,
 -8352,  28795,  -1033,
 -8260,  28818,  -1126,
 -8295,  28801,  -1294,
 -8224,  28817,  -1398,

/* 61 */
29, 1,
  7341,  28492,   5857,
  7438,  28460,   5889,
  7539,  28452,   5798,
  7668,  28438,   5701,
  7830,  28390,   5718,
  7928,  28340,   5833,
  8064,  28319,   5747,
  8185,  28307,   5632,
  8271,  28304,   5523,
  8343,  28302,   5421,
  8335,  28323,   5325,
  8176,  28362,   5360,
  8030,  28402,   5372,
  7886,  28446,   5348,
  7746,  28492,   5311,
  7622,  28534,   5261,
  7482,  28590,   5163,
  7406,  28625,   5075,
  7323,  28666,   4961,
  7251,  28704,   4848,
  7101,  28738,   4869,
  7002,  28745,   4972,
  6964,  28728,   5118,
  7029,  28689,   5249,
  7039,  28664,   5367,
  7152,  28627,   5420,
  7247,  28579,   5543,
  7271,  28549,   5663,
  7281,  28519,   5802,

/* 62 */
29, -1,
 13904,  22523,  14121,
 13885,  22616,  13991,
 13862,  22704,  13870,
 13812,  22799,  13763,
 13791,  22886,  13640,
 13735,  22984,  13530,
 13756,  23049,  13398,
 13850,  23060,  13281,
 13849,  23083,  13243,
 13730,  23116,  13310,
 13624,  23219,  13239,
 13603,  23299,  13119,
 13491,  23390,  13073,
 13455,  23476,  12955,
 13469,  23542,  12820,
 13498,  23576,  12727,
 13436,  23522,  12892,
 13438,  23447,  13026,
 13505,  23359,  13114,
 13603,  23275,  13162,
 13610,  23198,  13290,
 13712,  23103,  13350,
 13715,  23022,  13486,
 13755,  22931,  13600,
 13780,  22835,  13736,
 13823,  22750,  13833,
 13860,  22660,  13943,
 13876,  22575,  14065,
 13903,  22498,  14162,

/* 63 */
28, 1,
 25599,   5928, -14475,
 25632,   5834, -14455,
 25679,   5674, -14436,
 25704,   5584, -14427,
 25758,   5448, -14382,
 25820,   5368, -14300,
 25888,   5257, -14218,
 25952,   5142, -14145,
 26019,   5031, -14061,
 26083,   4917, -13981,
 26150,   4825, -13889,
 26220,   4740, -13785,
 26286,   4636, -13696,
 26369,   4446, -13598,
 26311,   4464, -13704,
 26244,   4541, -13807,
 26175,   4633, -13908,
 26113,   4751, -13984,
 26039,   4827, -14096,
 25976,   4942, -14172,
 25926,   5072, -14217,
 25877,   5187, -14265,
 25795,   5241, -14392,
 25732,   5361, -14462,
 25647,   5441, -14582,
 25627,   5578, -14564,
 25625,   5718, -14514,
 25597,   5864, -14506,

/* 64 */
32, -1,
  6784,  26265,  12812,
  6851,  26260,  12786,
  6888,  26317,  12648,
  6860,  26383,  12526,
  6940,  26395,  12457,
  7001,  26439,  12328,
  6956,  26510,  12200,
  6856,  26598,  12064,
  6829,  26548,  12189,
  6731,  26545,  12249,
  6598,  26552,  12306,
  6460,  26633,  12204,
  6610,  26606,  12183,
  6542,  26645,  12134,
  6449,  26718,  12023,
  6331,  26734,  12051,
  6213,  26773,  12025,
  6119,  26840,  11924,
  6122,  26830,  11945,
  6202,  26760,  12059,
  6334,  26697,  12131,
  6385,  26622,  12268,
  6415,  26598,  12305,
  6526,  26558,  12333,
  6653,  26507,  12375,
  6781,  26468,  12388,
  6768,  26436,  12463,
  6742,  26387,  12580,
  6675,  26397,  12594,
  6588,  26399,  12638,
  6582,  26350,  12742,
  6739,  26294,  12775,

/* 65 */
26, 1,
 23238,  12726, -14073,
 23314,  12662, -14004,
 23402,  12541, -13967,
 23490,  12436, -13912,
 23574,  12315, -13878,
 23659,  12194, -13841,
 23744,  12071, -13803,
 23807,  11928, -13818,
 23873,  11779, -13833,
 23893,  11664, -13895,
 23917,  11520, -13973,
 23895,  11434, -14082,
 23897,  11260, -14218,
 23825,  11373, -14249,
 23754,  11507, -14259,
 23668,  11618, -14312,
 23584,  11736, -14355,
 23512,  11862, -14370,
 23441,  12000, -14370,
 23372,  12136, -14368,
 23303,  12270, -14367,
 23219,  12399, -14393,
 23162,  12522, -14377,
 23083,  12679, -14368,
 23103,  12772, -14251,
 23169,  12767, -14150,

/* 66 */
30, -1,
-15626,  24491,   7484,
-15709,  24424,   7530,
-15823,  24336,   7576,
-15891,  24331,   7450,
-15794,  24436,   7310,
-15838,  24404,   7322,
-15947,  24300,   7432,
-16018,  24275,   7358,
-16001,  24333,   7201,
-15945,  24419,   7033,
-15890,  24473,   6971,
-15791,  24563,   6878,
-15837,  24533,   6879,
-15948,  24452,   6909,
-16055,  24357,   6999,
-16004,  24389,   7001,
-15986,  24382,   7068,
-16030,  24311,   7211,
-16059,  24254,   7337,
-16186,  24137,   7444,
-16125,  24179,   7440,
-16041,  24227,   7465,
-15912,  24285,   7554,
-15889,  24256,   7692,
-15835,  24244,   7842,
-15738,  24281,   7922,
-15737,  24303,   7856,
-15770,  24317,   7744,
-15731,  24382,   7619,
-15653,  24462,   7524,

/* 67 */
28, 1,
  5003,  28957,  -6038,
  4861,  28970,  -6093,
  4773,  28965,  -6186,
  4651,  28977,  -6222,
  4657,  29016,  -6034,
  4577,  29057,  -5893,
  4509,  29060,  -5930,
  4620,  29016,  -6058,
  4606,  28990,  -6193,
  4490,  28991,  -6274,
  4370,  29026,  -6197,
  4277,  29059,  -6107,
  4340,  29085,  -5933,
  4439,  29091,  -5832,
  4462,  29118,  -5680,
  4524,  29115,  -5642,
  4651,  29078,  -5729,
  4709,  29072,  -5713,
  4710,  29100,  -5571,
  4737,  29127,  -5400,
  4852,  29114,  -5370,
  4986,  29081,  -5425,
  5095,  29049,  -5495,
  5193,  29015,  -5584,
  5236,  28975,  -5749,
  5239,  28945,  -5892,
  5130,  28947,  -5981,
  5035,  28967,  -5962,

/* 68 */
26, 1,
  7323, -10567, -27106,
  7444, -10473, -27109,
  7586, -10400, -27098,
  7708, -10350, -27083,
  7739, -10373, -27065,
  7660, -10491, -27042,
  7560, -10617, -27021,
  7444, -10719, -27013,
  7345, -10807, -27005,
  7227, -10921, -26991,
  7111, -11008, -26986,
  6982, -11075, -26993,
  6849, -11139, -27000,
  6701, -11221, -27003,
  6597, -11310, -26992,
  6471, -11369, -26997,
  6309, -11412, -27018,
  6258, -11328, -27065,
  6379, -11231, -27077,
  6494, -11148, -27084,
  6609, -11062, -27092,
  6754, -10979, -27090,
  6859, -10920, -27087,
  6987, -10830, -27091,
  7092, -10715, -27109,
  7198, -10629, -27115,

/* 69 */
26, -1,
-20783,  20998,   5211,
-20850,  20958,   5102,
-20917,  20922,   4977,
-20993,  20892,   4774,
-21013,  20855,   4853,
-21074,  20809,   4782,
-21077,  20840,   4633,
-21112,  20834,   4497,
-21161,  20814,   4355,
-21209,  20795,   4213,
-21269,  20759,   4085,
-21351,  20696,   3972,
-21456,  20603,   3897,
-21500,  20539,   3987,
-21455,  20559,   4125,
-21397,  20591,   4260,
-21353,  20607,   4404,
-21328,  20601,   4553,
-21327,  20568,   4702,
-21290,  20570,   4859,
-21246,  20586,   4984,
-21159,  20648,   5096,
-21079,  20711,   5172,
-20965,  20832,   5150,
-20891,  20912,   5123,
-20791,  20984,   5232,

/* 70 */
27, 1,
-22450,   -137,  19899,
-22520,   -123,  19820,
-22619,   -100,  19707,
-22717,    -81,  19594,
-22803,   -121,  19494,
-22907,   -110,  19371,
-23003,    -78,  19258,
-23100,    -69,  19142,
-23184,   -129,  19038,
-23206,   -308,  19010,
-23238,   -416,  18969,
-23188,   -553,  19027,
-23207,   -602,  19002,
-23237,   -742,  18960,
-23181,   -877,  19023,
-23115,   -953,  19100,
-23068,   -876,  19160,
-23045,   -876,  19187,
-22966,   -908,  19281,
-22874,   -897,  19390,
-22792,   -820,  19490,
-22695,   -798,  19604,
-22606,   -729,  19709,
-22573,   -628,  19750,
-22503,   -511,  19833,
-22471,   -367,  19872,
-22436,   -211,  19914,

/* 71 */
25, 1,
 23559,  -1507, -18512,
 23586,  -1582, -18472,
 23629,  -1756, -18401,
 23572,  -1676, -18481,
 23509,  -1710, -18559,
 23421,  -1798, -18661,
 23325,  -1715, -18789,
 23240,  -1762, -18889,
 23143,  -1796, -19004,
 23077,  -1751, -19088,
 22968,  -1771, -19218,
 22884,  -1855, -19310,
 22792,  -1913, -19413,
 22686,  -1996, -19528,
 22649,  -1899, -19581,
 22699,  -1776, -19535,
 22759,  -1645, -19476,
 22846,  -1567, -19381,
 22948,  -1558, -19260,
 23035,  -1504, -19161,
 23134,  -1469, -19044,
 23231,  -1522, -18921,
 23315,  -1490, -18819,
 23412,  -1493, -18699,
 23506,  -1497, -18580,

/* 72 */
25, 1,
 25640,  -4315, -14965,
 25671,  -4360, -14899,
 25725,  -4425, -14786,
 25710,  -4580, -14766,
 25634,  -4590, -14894,
 25560,  -4592, -15021,
 25478,  -4612, -15153,
 25400,  -4654, -15270,
 25321,  -4628, -15409,
 25247,  -4615, -15533,
 25175,  -4614, -15650,
 25105,  -4564, -15777,
 25024,  -4551, -15909,
 24947,  -4487, -16047,
 24931,  -4305, -16122,
 24946,  -4338, -16089,
 25011,  -4416, -15966,
 25061,  -4496, -15866,
 25144,  -4435, -15751,
 25216,  -4431, -15637,
 25285,  -4460, -15517,
 25364,  -4425, -15397,
 25444,  -4368, -15281,
 25529,  -4328, -15150,
 25601,  -4313, -15033,

/* 73 */
25, 1,
  6329,  18585,  22684,
  6222,  18564,  22731,
  6103,  18534,  22787,
  5970,  18511,  22841,
  5834,  18479,  22902,
  5692,  18474,  22941,
  5549,  18489,  22965,
  5398,  18536,  22962,
  5245,  18510,  23019,
  5135,  18477,  23070,
  5130,  18363,  23162,
  5257,  18293,  23189,
  5404,  18256,  23185,
  5539,  18188,  23206,
  5675,  18127,  23221,
  5816,  18095,  23210,
  5948,  18036,  23223,
  6062,  17953,  23258,
  6213,  17926,  23239,
  6269,  17982,  23181,
  6295,  18100,  23081,
  6227,  18202,  23020,
  6222,  18319,  22928,
  6260,  18425,  22833,
  6318,  18529,  22732,

/* 74 */
26, -1,
  7748,  26705,  11261,
  7877,  26637,  11333,
  7952,  26630,  11298,
  8089,  26575,  11329,
  8076,  26525,  11454,
  7915,  26580,  11440,
  7964,  26532,  11517,
  7921,  26528,  11556,
  7786,  26594,  11496,
  7788,  26582,  11521,
  7914,  26519,  11580,
  8013,  26449,  11671,
  8135,  26389,  11725,
  8276,  26351,  11709,
  8423,  26276,  11775,
  8315,  26276,  11852,
  8345,  26249,  11890,
  8517,  26219,  11833,
  8567,  26260,  11705,
  8549,  26316,  11593,
  8429,  26381,  11531,
  8303,  26449,  11469,
  8197,  26514,  11395,
  8128,  26589,  11268,
  8004,  26639,  11239,
  7852,  26680,  11248,

/* 75 */
24, 1,
 14610,  -1401, -26164,
 14567,  -1458, -26185,
 14446,  -1519, -26249,
 14332,  -1603, -26306,
 14221,  -1688, -26361,
 14113,  -1783, -26413,
 13986,  -1835, -26477,
 13886,  -1932, -26522,
 13800,  -2050, -26559,
 13736,  -2187, -26581,
 13722,  -2338, -26575,
 13649,  -2484, -26599,
 13560,  -2432, -26650,
 13533,  -2289, -26676,
 13574,  -2156, -26666,
 13669,  -2056, -26626,
 13786,  -1978, -26571,
 13880,  -1878, -26530,
 13988,  -1774, -26480,
 14093,  -1684, -26430,
 14209,  -1612, -26372,
 14326,  -1532, -26314,
 14447,  -1473, -26251,
 14559,  -1387, -26194,

/* 76 */
25, 1,
 26396,  -4371, -13570,
 26423,  -4399, -13507,
 26470,  -4487, -13387,
 26459,  -4647, -13354,
 26403,  -4733, -13434,
 26339,  -4718, -13564,
 26274,  -4696, -13699,
 26212,  -4654, -13830,
 26149,  -4621, -13960,
 26101,  -4541, -14075,
 26074,  -4571, -14115,
 25987,  -4591, -14270,
 25924,  -4526, -14403,
 25955,  -4384, -14392,
 26022,  -4388, -14270,
 26057,  -4341, -14219,
 26131,  -4339, -14083,
 26200,  -4247, -13983,
 26270,  -4268, -13844,
 26222,  -4393, -13896,
 26149,  -4456, -14014,
 26152,  -4520, -13987,
 26221,  -4533, -13852,
 26291,  -4431, -13754,
 26354,  -4399, -13643,

/* 77 */
23, 1,
 26582,  10216,  -9436,
 26612,  10199,  -9371,
 26661,  10137,  -9296,
 26736,  10035,  -9191,
 26806,   9948,  -9083,
 26856,   9832,  -9061,
 26902,   9685,  -9083,
 26937,   9541,  -9132,
 26918,   9462,  -9267,
 26888,   9419,  -9398,
 26842,   9387,  -9560,
 26765,   9470,  -9692,
 26721,   9513,  -9771,
 26644,   9610,  -9887,
 26592,   9700,  -9940,
 26532,   9847,  -9955,
 26440,  10014, -10032,
 26382,  10088, -10110,
 26342,  10231, -10070,
 26378,  10279,  -9926,
 26426,  10269,  -9808,
 26489,  10246,  -9660,
 26537,  10247,  -9528,

/* 78 */
23, 1,
 -8254,  28832,   -761,
 -8351,  28805,   -729,
 -8382,  28795,   -779,
 -8479,  28765,   -837,
 -8637,  28717,   -847,
 -8782,  28673,   -869,
 -8914,  28633,   -844,
 -9053,  28590,   -821,
 -9199,  28544,   -807,
 -9215,  28542,   -663,
 -9069,  28591,   -578,
 -8902,  28642,   -610,
 -8868,  28655,   -498,
 -8887,  28651,   -344,
 -8769,  28689,   -252,
 -8641,  28728,   -205,
 -8506,  28769,   -131,
 -8366,  28810,    -54,
 -8284,  28833,   -115,
 -8267,  28837,   -270,
 -8224,  28848,   -374,
 -8183,  28858,   -522,
 -8199,  28850,   -663,

/* 79 */
24, -1,
 14884,  12125,  23053,
 14876,  12008,  23120,
 14906,  11952,  23129,
 14932,  11851,  23165,
 14890,  11721,  23257,
 14861,  11601,  23336,
 14760,  11590,  23405,
 14652,  11571,  23482,
 14576,  11491,  23569,
 14515,  11367,  23666,
 14467,  11258,  23748,
 14434,  11131,  23828,
 14432,  11072,  23856,
 14489,  11238,  23744,
 14551,  11356,  23650,
 14625,  11429,  23568,
 14677,  11533,  23485,
 14794,  11533,  23412,
 14886,  11615,  23313,
 14940,  11710,  23231,
 15012,  11739,  23169,
 14988,  11885,  23110,
 14955,  12016,  23064,
 14899,  12149,  23031,

/* 80 */
24, 1,
 -6839,  29182,  -1275,
 -6959,  29154,  -1272,
 -7122,  29116,  -1246,
 -7082,  29122,  -1321,
 -6932,  29154,  -1422,
 -7012,  29132,  -1464,
 -7172,  29094,  -1440,
 -7190,  29087,  -1490,
 -7233,  29071,  -1592,
 -7317,  29050,  -1600,
 -7318,  29058,  -1437,
 -7317,  29068,  -1235,
 -7373,  29051,  -1293,
 -7473,  29022,  -1376,
 -7616,  28985,  -1374,
 -7651,  28981,  -1239,
 -7637,  28992,  -1082,
 -7503,  29028,  -1033,
 -7429,  29050,   -964,
 -7294,  29083,   -983,
 -7136,  29124,   -948,
 -6984,  29160,   -951,
 -6893,  29178,  -1061,
 -6852,  29183,  -1177,

/* 81 */
22, 1,
  3600,  19765,  22280,
  3523,  19706,  22344,
  3417,  19636,  22422,
  3258,  19628,  22453,
  3254,  19526,  22542,
  3347,  19427,  22614,
  3368,  19313,  22708,
  3403,  19203,  22796,
  3391,  19086,  22896,
  3404,  18954,  23003,
  3442,  18883,  23056,
  3565,  18841,  23072,
  3660,  18944,  22972,
  3787,  18948,  22948,
  3869,  18984,  22905,
  3876,  19100,  22807,
  3875,  19219,  22707,
  3856,  19329,  22616,
  3863,  19435,  22525,
  3857,  19539,  22436,
  3783,  19652,  22349,
  3697,  19742,  22284,

/* 82 */
22, 1,
 17666,  16854, -17432,
 17724,  16885, -17342,
 17791,  16930, -17230,
 17918,  16890, -17137,
 17995,  16812, -17133,
 18113,  16756, -17062,
 18201,  16791, -16935,
 18319,  16691, -16907,
 18429,  16598, -16879,
 18561,  16520, -16810,
 18536,  16520, -16837,
 18511,  16453, -16930,
 18552,  16336, -17000,
 18502,  16244, -17141,
 18405,  16314, -17178,
 18298,  16420, -17192,
 18201,  16512, -17207,
 18079,  16559, -17290,
 17993,  16494, -17441,
 17876,  16587, -17474,
 17758,  16667, -17517,
 17707,  16741, -17498,

/* 83 */
23, -1,
  5861,  26752,  12246,
  5943,  26719,  12278,
  5987,  26652,  12403,
  6063,  26588,  12503,
  6067,  26522,  12640,
  6065,  26462,  12766,
  6091,  26401,  12880,
  6147,  26329,  12999,
  6232,  26264,  13090,
  6345,  26283,  12999,
  6265,  26308,  12986,
  6188,  26367,  12904,
  6140,  26439,  12779,
  6124,  26503,  12653,
  6151,  26583,  12471,
  6234,  26608,  12376,
  6235,  26664,  12254,
  6162,  26713,  12183,
  6146,  26668,  12291,
  6117,  26615,  12418,
  6065,  26610,  12455,
  6050,  26665,  12344,
  5987,  26722,  12251,

/* 84 */
21, -1,
-14603,  25601,  -5597,
-14613,  25626,  -5455,
-14541,  25693,  -5331,
-14532,  25728,  -5186,
-14555,  25744,  -5041,
-14593,  25750,  -4894,
-14610,  25770,  -4737,
-14602,  25798,  -4613,
-14665,  25788,  -4461,
-14719,  25785,  -4302,
-14699,  25791,  -4332,
-14640,  25802,  -4463,
-14570,  25818,  -4597,
-14498,  25834,  -4734,
-14467,  25826,  -4873,
-14402,  25848,  -4948,
-14321,  25869,  -5068,
-14370,  25817,  -5193,
-14419,  25761,  -5334,
-14462,  25710,  -5462,
-14513,  25651,  -5604,

/* 85 */
22, 1,
 -5757,  29270,  -3178,
 -5793,  29252,  -3278,
 -5861,  29224,  -3408,
 -5920,  29196,  -3544,
 -5974,  29168,  -3683,
 -5986,  29146,  -3834,
 -6090,  29117,  -3891,
 -6197,  29114,  -3738,
 -6274,  29102,  -3699,
 -6337,  29097,  -3634,
 -6237,  29133,  -3517,
 -6168,  29164,  -3380,
 -6078,  29196,  -3261,
 -6132,  29186,  -3247,
 -6275,  29151,  -3290,
 -6253,  29169,  -3172,
 -6197,  29196,  -3033,
 -6072,  29228,  -2975,
 -5962,  29260,  -2883,
 -5843,  29286,  -2859,
 -5834,  29278,  -2966,
 -5799,  29273,  -3080,

/* 86 */
21, -1,
 20081,  22197,   2006,
 20029,  22248,   1962,
 19945,  22316,   2048,
 19841,  22396,   2177,
 19772,  22454,   2205,
 19652,  22556,   2242,
 19579,  22628,   2147,
 19531,  22686,   1965,
 19447,  22754,   2020,
 19337,  22841,   2090,
 19319,  22849,   2175,
 19383,  22797,   2142,
 19461,  22742,   2024,
 19539,  22672,   2050,
 19573,  22629,   2195,
 19664,  22543,   2265,
 19779,  22442,   2265,
 19840,  22378,   2370,
 19907,  22321,   2340,
 19964,  22284,   2204,
 20039,  22228,   2085,

/* 87 */
20, 1,
-17819,  21913,  10114,
-17847,  21924,  10041,
-17989,  21830,   9991,
-18092,  21748,   9985,
-18216,  21658,   9954,
-18329,  21566,   9948,
-18407,  21461,  10030,
-18384,  21428,  10142,
-18308,  21434,  10266,
-18205,  21467,  10380,
-18089,  21534,  10443,
-17994,  21621,  10427,
-18050,  21651,  10268,
-18162,  21570,  10241,
-18264,  21486,  10238,
-18299,  21499,  10148,
-18221,  21573,  10131,
-18079,  21658,  10203,
-17989,  21737,  10193,
-17880,  21832,  10180,

/* 88 */
20, -1,
  7617,   6776,  28215,
  7517,   6813,  28232,
  7385,   6874,  28253,
  7244,   6851,  28295,
  7155,   6929,  28298,
  7059,   6941,  28319,
  6957,   6994,  28332,
  6964,   7141,  28293,
  6845,   7234,  28299,
  6704,   7171,  28348,
  6744,   7018,  28377,
  6821,   6891,  28390,
  6937,   6804,  28383,
  6991,   6735,  28386,
  7007,   6611,  28411,
  7128,   6497,  28407,
  7223,   6562,  28369,
  7338,   6651,  28318,
  7457,   6692,  28278,
  7607,   6721,  28230,

/* 89 */
19, 1,
 10847,  17337,  21949,
 10792,  17303,  22003,
 10656,  17302,  22071,
 10531,  17343,  22098,
 10386,  17362,  22152,
 10252,  17384,  22197,
 10111,  17366,  22276,
  9981,  17428,  22285,
  9817,  17454,  22338,
  9770,  17393,  22406,
  9840,  17312,  22439,
  9987,  17297,  22385,
 10128,  17279,  22335,
 10272,  17218,  22317,
 10398,  17181,  22287,
 10527,  17198,  22213,
 10660,  17210,  22140,
 10795,  17215,  22071,
 10859,  17284,  21986,

/* 90 */
20, 1,
  2092,  29573,   4591,
  2046,  29564,   4670,
  1956,  29577,   4622,
  1958,  29556,   4757,
  1869,  29563,   4746,
  1736,  29579,   4697,
  1693,  29577,   4729,
  1664,  29563,   4825,
  1638,  29547,   4927,
  1716,  29523,   5045,
  1933,  29523,   4963,
  1889,  29508,   5068,
  1947,  29490,   5150,
  2107,  29485,   5117,
  2256,  29470,   5142,
  2347,  29484,   5020,
  2377,  29504,   4884,
  2396,  29527,   4733,
  2339,  29553,   4599,
  2182,  29565,   4597,

/* 91 */
20, -1,
-20217,  21829,  -3845,
-20288,  21770,  -3804,
-20398,  21664,  -3822,
-20498,  21569,  -3820,
-20608,  21466,  -3813,
-20703,  21371,  -3827,
-20739,  21336,  -3830,
-20831,  21249,  -3814,
-20902,  21162,  -3908,
-20902,  21134,  -4061,
-20920,  21118,  -4051,
-21018,  21043,  -3926,
-20974,  21090,  -3913,
-20890,  21189,  -3825,
-20812,  21275,  -3771,
-20698,  21385,  -3777,
-20601,  21481,  -3762,
-20503,  21571,  -3787,
-20392,  21673,  -3801,
-20276,  21784,  -3787,

/* 92 */
18, 1,
 24559,   5678, -16267,
 24604,   5701, -16191,
 24686,   5684, -16071,
 24739,   5567, -16031,
 24787,   5431, -16003,
 24816,   5270, -16013,
 24895,   5197, -15913,
 24957,   5092, -15850,
 24944,   4963, -15911,
 24888,   4876, -16026,
 24854,   4751, -16116,
 24781,   4757, -16226,
 24746,   4891, -16239,
 24761,   5018, -16178,
 24727,   5176, -16180,
 24673,   5314, -16217,
 24622,   5452, -16249,
 24567,   5591, -16286,

/* 93 */
20, -1,
  7773,  28919,  -1814,
  7684,  28935,  -1932,
  7601,  28948,  -2066,
  7560,  28958,  -2064,
  7552,  28971,  -1911,
  7714,  28934,  -1824,
  7766,  28928,  -1689,
  7784,  28931,  -1541,
  7690,  28962,  -1435,
  7636,  28979,  -1388,
  7836,  28923,  -1441,
  7944,  28897,  -1366,
  7975,  28889,  -1355,
  7986,  28878,  -1505,
  8116,  28838,  -1584,
  8143,  28827,  -1638,
  7982,  28876,  -1572,
  7912,  28896,  -1567,
  7913,  28888,  -1688,
  7822,  28910,  -1738,

/* 94 */
19, 1,
 28847,   -786,  -8199,
 28861,   -867,  -8144,
 28878,   -857,  -8081,
 28911,   -873,  -7961,
 28932,  -1026,  -7868,
 28905,  -1107,  -7953,
 28864,  -1112,  -8100,
 28838,  -1229,  -8178,
 28820,  -1361,  -8220,
 28796,  -1481,  -8282,
 28753,  -1536,  -8420,
 28713,  -1609,  -8543,
 28700,  -1555,  -8595,
 28699,  -1384,  -8627,
 28725,  -1317,  -8552,
 28767,  -1260,  -8419,
 28790,  -1117,  -8359,
 28803,   -967,  -8333,
 28827,   -831,  -8264,

/* 95 */
19, -1,
-13526,  25075,  -9397,
-13630,  25018,  -9397,
-13799,  24914,  -9428,
-13880,  24870,  -9423,
-13999,  24814,  -9396,
-14135,  24752,  -9355,
-14290,  24661,  -9360,
-14269,  24682,  -9336,
-14144,  24753,  -9341,
-14009,  24825,  -9352,
-13975,  24875,  -9269,
-14054,  24879,  -9139,
-14132,  24892,  -8980,
-14093,  24909,  -8997,
-14039,  24887,  -9139,
-13973,  24880,  -9258,
-13845,  24919,  -9347,
-13726,  24972,  -9380,
-13596,  25044,  -9379,

/* 96 */
20, 1,
 -8960, -28564,  -1947,
 -8964, -28571,  -1831,
 -8966, -28579,  -1682,
 -8949, -28594,  -1512,
 -8909, -28613,  -1384,
 -8928, -28614,  -1226,
 -8925, -28621,  -1082,
 -8985, -28607,   -961,
 -9091, -28573,   -972,
 -9108, -28564,  -1078,
 -9186, -28539,  -1064,
 -9263, -28512,  -1129,
 -9162, -28542,  -1197,
 -9150, -28541,  -1299,
 -9233, -28510,  -1400,
 -9157, -28531,  -1460,
 -9113, -28541,  -1536,
 -9123, -28531,  -1659,
 -9107, -28527,  -1807,
 -9030, -28542,  -1960,

/* 97 */
17, -1,
 17593,   2406,  24180,
 17547,   2284,  24226,
 17545,   2132,  24241,
 17531,   1985,  24264,
 17563,   1840,  24252,
 17624,   1706,  24217,
 17684,   1578,  24182,
 17775,   1468,  24123,
 17857,   1306,  24071,
 17908,   1411,  24028,
 17857,   1519,  24059,
 17763,   1620,  24121,
 17705,   1753,  24155,
 17693,   1908,  24152,
 17681,   2056,  24148,
 17678,   2207,  24137,
 17661,   2361,  24135,

/* 98 */
17, -1,
  7274,  26419,  12212,
  7244,  26366,  12344,
  7218,  26303,  12493,
  7308,  26248,  12554,
  7429,  26186,  12613,
  7541,  26117,  12690,
  7652,  26051,  12758,
  7788,  25974,  12834,
  7833,  26021,  12710,
  7942,  26030,  12624,
  8011,  26056,  12527,
  7988,  26120,  12408,
  7920,  26193,  12297,
  7802,  26258,  12232,
  7654,  26308,  12220,
  7515,  26352,  12210,
  7380,  26400,  12189,

/* 99 */
18, 1,
 -5378,  29484,  -1323,
 -5371,  29481,  -1417,
 -5446,  29463,  -1514,
 -5580,  29441,  -1448,
 -5703,  29420,  -1393,
 -5781,  29402,  -1447,
 -5826,  29388,  -1546,
 -5914,  29375,  -1455,
 -5937,  29377,  -1324,
 -6027,  29364,  -1195,
 -6168,  29336,  -1157,
 -6229,  29328,  -1038,
 -6099,  29357,   -984,
 -5952,  29386,  -1019,
 -5812,  29414,  -1014,
 -5691,  29435,  -1100,
 -5592,  29449,  -1222,
 -5449,  29474,  -1271,

/* 100 */
18, -1,
 13477,  22776,  14129,
 13586,  22700,  14146,
 13627,  22621,  14233,
 13621,  22544,  14361,
 13596,  22466,  14506,
 13617,  22375,  14627,
 13649,  22293,  14722,
 13568,  22263,  14840,
 13562,  22193,  14951,
 13654,  22163,  14912,
 13739,  22211,  14762,
 13740,  22262,  14684,
 13689,  22354,  14591,
 13684,  22450,  14449,
 13663,  22528,  14345,
 13638,  22613,  14237,
 13606,  22696,  14135,
 13486,  22771,  14128,

/* 101 */
17, 1,
 13832,  17499,  20061,
 13783,  17475,  20115,
 13696,  17421,  20223,
 13597,  17375,  20328,
 13484,  17351,  20424,
 13339,  17356,  20514,
 13276,  17283,  20617,
 13155,  17242,  20728,
 13175,  17148,  20793,
 13293,  17069,  20784,
 13431,  17047,  20712,
 13541,  17089,  20606,
 13622,  17147,  20504,
 13724,  17195,  20396,
 13694,  17287,  20338,
 13729,  17383,  20233,
 13802,  17456,  20119,

/* 102 */
17, 1,
 24192,   6529, -16496,
 24197,   6448, -16521,
 24185,   6316, -16589,
 24127,   6227, -16706,
 24083,   6134, -16805,
 24092,   6027, -16829,
 24103,   5937, -16846,
 24055,   5829, -16952,
 23938,   5791, -17129,
 23921,   5911, -17113,
 23925,   6067, -17053,
 23903,   6207, -17033,
 23885,   6347, -17007,
 23913,   6459, -16925,
 23982,   6524, -16802,
 24064,   6503, -16693,
 24151,   6513, -16563,

/* 103 */
16, -1,
 13005,  -9227,  25411,
 13094,  -9120,  25404,
 13211,  -9029,  25376,
 13307,  -8900,  25371,
 13431,  -8816,  25335,
 13521,  -8737,  25315,
 13656,  -8678,  25262,
 13848,  -8607,  25182,
 13754,  -8533,  25259,
 13618,  -8577,  25318,
 13502,  -8671,  25348,
 13372,  -8735,  25395,
 13279,  -8832,  25410,
 13171,  -8963,  25420,
 13098,  -9075,  25418,
 13005,  -9194,  25423,

/* 104 */
17, -1,
 12753,  25778,   8535,
 12805,  25714,   8649,
 12904,  25656,   8676,
 12899,  25607,   8826,
 12908,  25602,   8827,
 12996,  25588,   8737,
 13139,  25509,   8756,
 13335,  25411,   8745,
 13259,  25477,   8667,
 13174,  25510,   8701,
 13015,  25594,   8692,
 12932,  25676,   8574,
 12805,  25749,   8546,
 12774,  25808,   8412,
 12666,  25882,   8348,
 12613,  25915,   8325,
 12744,  25815,   8437,

/* 105 */
17, -1,
-16206,  24956,  -3814,
-16170,  24992,  -3734,
-16124,  25043,  -3587,
-16050,  25103,  -3499,
-15953,  25178,  -3396,
-15830,  25260,  -3364,
-15660,  25382,  -3245,
-15548,  25446,  -3277,
-15556,  25430,  -3363,
-15641,  25360,  -3493,
-15757,  25274,  -3598,
-15867,  25208,  -3578,
-16038,  25095,  -3610,
-16097,  25043,  -3705,
-16025,  25087,  -3722,
-16060,  25060,  -3756,
-16139,  25001,  -3808,

/* 106 */
16, 1,
-27904,   9377,   5782,
-27890,   9343,   5903,
-27898,   9244,   6020,
-27884,   9197,   6154,
-27859,   9161,   6323,
-27803,   9226,   6472,
-27776,   9222,   6590,
-27742,   9211,   6749,
-27710,   9300,   6758,
-27716,   9372,   6634,
-27729,   9430,   6497,
-27745,   9475,   6357,
-27770,   9501,   6210,
-27797,   9517,   6064,
-27832,   9503,   5921,
-27875,   9461,   5785,

/* 107 */
16, 1,
 24919,   6169, -15523,
 24904,   6086, -15580,
 24919,   5942, -15612,
 24949,   5794, -15619,
 24995,   5646, -15600,
 25022,   5494, -15611,
 24992,   5479, -15665,
 24913,   5547, -15766,
 24828,   5590, -15884,
 24756,   5692, -15961,
 24678,   5787, -16047,
 24619,   5957, -16075,
 24674,   5984, -15981,
 24743,   6013, -15863,
 24803,   6077, -15744,
 24861,   6146, -15625,

/* 108 */
15, 1,
 25878,  -4981, -14336,
 25813,  -5073, -14420,
 25739,  -5090, -14546,
 25665,  -5138, -14659,
 25590,  -5222, -14761,
 25519,  -5322, -14848,
 25439,  -5347, -14976,
 25377,  -5286, -15103,
 25403,  -5168, -15099,
 25474,  -5055, -15018,
 25550,  -4994, -14908,
 25629,  -4889, -14808,
 25696,  -4882, -14693,
 25771,  -4883, -14562,
 25843,  -4896, -14429,

/* 109 */
16, 1,
  5450,  29486,   -929,
  5296,  29515,   -920,
  5163,  29540,   -867,
  5178,  29540,   -765,
  5233,  29532,   -706,
  5102,  29556,   -623,
  5153,  29550,   -477,
  5270,  29531,   -401,
  5422,  29504,   -315,
  5468,  29495,   -369,
  5639,  29461,   -477,
  5685,  29450,   -610,
  5752,  29434,   -753,
  5754,  29429,   -893,
  5639,  29449,   -972,
  5527,  29472,   -906,

/* 110 */
16, -1,
 17357,  24467,   -289,
 17450,  24400,   -372,
 17564,  24317,   -439,
 17682,  24231,   -446,
 17669,  24239,   -495,
 17606,  24285,   -491,
 17475,  24381,   -456,
 17376,  24453,   -337,
 17263,  24534,   -300,
 17184,  24587,   -396,
 17154,  24606,   -535,
 17052,  24672,   -713,
 17070,  24662,   -638,
 17131,  24623,   -515,
 17171,  24597,   -373,
 17256,  24539,   -283,

/* 111 */
16, 1,
-10217,  28170,  -1431,
-10282,  28144,  -1490,
-10403,  28097,  -1528,
-10515,  28050,  -1611,
-10579,  28018,  -1753,
-10682,  27983,  -1687,
-10756,  27962,  -1564,
-10869,  27926,  -1417,
-10921,  27912,  -1294,
-10899,  27926,  -1158,
-10827,  27958,  -1047,
-10754,  27986,  -1062,
-10627,  28032,  -1137,
-10498,  28078,  -1185,
-10378,  28118,  -1301,
-10287,  28148,  -1364,

/* 112 */
15, 1,
 29126,   7027,  -1524,
 29151,   6932,  -1463,
 29186,   6788,  -1442,
 29223,   6635,  -1413,
 29255,   6499,  -1391,
 29287,   6352,  -1395,
 29323,   6196,  -1328,
 29354,   6043,  -1354,
 29344,   6077,  -1404,
 29311,   6232,  -1418,
 29276,   6382,  -1473,
 29249,   6499,  -1509,
 29208,   6682,  -1499,
 29181,   6791,  -1529,
 29146,   6936,  -1548,

/* 113 */
15, 1,
  6145,  29344,  -1095,
  6034,  29362,  -1206,
  5981,  29367,  -1344,
  5899,  29377,  -1483,
  5794,  29393,  -1569,
  5647,  29425,  -1514,
  5569,  29444,  -1420,
  5524,  29458,  -1313,
  5593,  29447,  -1253,
  5432,  29481,  -1179,
  5583,  29455,  -1105,
  5724,  29429,  -1090,
  5863,  29403,  -1054,
  6008,  29374,  -1038,
  6135,  29349,  -1015,

/* 114 */
15, 1,
 24375,   5854, -16479,
 24415,   5790, -16444,
 24458,   5650, -16428,
 24517,   5517, -16385,
 24575,   5384, -16342,
 24640,   5251, -16288,
 24683,   5125, -16264,
 24720,   4968, -16255,
 24687,   4964, -16307,
 24633,   5101, -16346,
 24582,   5241, -16378,
 24504,   5353, -16458,
 24446,   5464, -16509,
 24420,   5614, -16497,
 24397,   5761, -16480,

/* 115 */
15, -1,
-17689,  24006,  -3293,
-17686,  23992,  -3405,
-17759,  23932,  -3446,
-17793,  23921,  -3345,
-17863,  23883,  -3240,
-17952,  23826,  -3174,
-18058,  23738,  -3230,
-18221,  23613,  -3226,
-18325,  23541,  -3170,
-18281,  23580,  -3133,
-18161,  23671,  -3137,
-18055,  23757,  -3101,
-17943,  23847,  -3058,
-17828,  23931,  -3072,
-17735,  23984,  -3198,

/* 116 */
14, 1,
 12744,  -2905, -27003,
 12739,  -3050, -26989,
 12662,  -3173, -27011,
 12559,  -3272, -27048,
 12496,  -3390, -27062,
 12429,  -3512, -27077,
 12301,  -3581, -27127,
 12168,  -3530, -27193,
 12185,  -3383, -27205,
 12292,  -3266, -27170,
 12396,  -3187, -27133,
 12495,  -3067, -27101,
 12581,  -2933, -27076,
 12700,  -2875, -27027,

/* 117 */
15, 1,
-12039,  24973, -11465,
-12103,  24933, -11483,
-12239,  24858, -11501,
-12336,  24773, -11582,
-12451,  24687, -11640,
-12557,  24640, -11628,
-12685,  24576, -11623,
-12811,  24507, -11631,
-12818,  24545, -11544,
-12719,  24620, -11493,
-12563,  24713, -11465,
-12502,  24768, -11412,
-12372,  24845, -11387,
-12232,  24902, -11413,
-12108,  24962, -11415,

/* 118 */
14, 1,
  7404,  28675,  -4785,
  7375,  28658,  -4931,
  7358,  28637,  -5079,
  7365,  28608,  -5228,
  7320,  28597,  -5351,
  7170,  28650,  -5270,
  7039,  28692,  -5219,
  6925,  28738,  -5116,
  6908,  28762,  -5000,
  6915,  28786,  -4852,
  6971,  28796,  -4714,
  7096,  28771,  -4679,
  7242,  28716,  -4790,
  7371,  28686,  -4773,

/* 119 */
15, 1,
-18411,  21935,   8938,
-18526,  21854,   8898,
-18563,  21784,   8992,
-18579,  21717,   9122,
-18585,  21659,   9246,
-18514,  21661,   9382,
-18531,  21602,   9485,
-18454,  21620,   9594,
-18323,  21711,   9639,
-18343,  21746,   9522,
-18412,  21735,   9411,
-18468,  21751,   9263,
-18520,  21762,   9133,
-18502,  21809,   9058,
-18432,  21899,   8983,

/* 120 */
16, -1,
-19925, -10993,  19549,
-20010, -10933,  19495,
-20091, -10802,  19485,
-20186, -10670,  19460,
-20137, -10626,  19534,
-20013, -10735,  19602,
-19909, -10784,  19681,
-19947, -10749,  19661,
-20053, -10612,  19629,
-20120, -10574,  19581,
-20231, -10590,  19456,
-20220, -10666,  19427,
-20156, -10784,  19428,
-20127, -10910,  19387,
-20076, -10934,  19426,
-19976, -10981,  19504,

/* 121 */
15, -1,
-18321,  23571,  -2957,
-18342,  23546,  -3022,
-18397,  23502,  -3034,
-18524,  23414,  -2941,
-18617,  23343,  -2915,
-18722,  23262,  -2895,
-18840,  23172,  -2853,
-18964,  23073,  -2833,
-18988,  23069,  -2701,
-18899,  23146,  -2660,
-18792,  23225,  -2731,
-18702,  23285,  -2842,
-18603,  23365,  -2831,
-18448,  23482,  -2875,
-18382,  23527,  -2931,

/* 122 */
13, 1,
-17336,  22935,   8569,
-17413,  22944,   8388,
-17449,  22893,   8453,
-17444,  22843,   8597,
-17477,  22771,   8720,
-17466,  22722,   8869,
-17430,  22692,   9015,
-17385,  22669,   9157,
-17286,  22699,   9272,
-17255,  22777,   9136,
-17259,  22830,   8996,
-17268,  22879,   8852,
-17294,  22915,   8706,

/* 123 */
15, 1,
 18292, -22847,   6589,
 18309, -22796,   6718,
 18374, -22769,   6630,
 18412, -22763,   6543,
 18493, -22679,   6607,
 18384, -22723,   6759,
 18388, -22686,   6874,
 18372, -22665,   6983,
 18447, -22577,   7071,
 18347, -22646,   7110,
 18255, -22735,   7063,
 18130, -22847,   7023,
 18176, -22841,   6923,
 18232, -22841,   6775,
 18239, -22863,   6683,

/* 124 */
14, 1,
 25183,   6987, -14730,
 25164,   6919, -14796,
 25130,   6812, -14902,
 25129,   6672, -14967,
 25121,   6548, -15035,
 25103,   6411, -15124,
 25048,   6381, -15228,
 24987,   6483, -15285,
 24947,   6625, -15290,
 24918,   6784, -15266,
 24936,   6898, -15186,
 24992,   6972, -15060,
 25055,   6997, -14943,
 25131,   7007, -14810,

/* 125 */
14, 1,
 -8316,  28793,   1345,
 -8428,  28760,   1359,
 -8534,  28724,   1443,
 -8653,  28685,   1513,
 -8736,  28654,   1628,
 -8666,  28667,   1763,
 -8625,  28670,   1905,
 -8613,  28663,   2061,
 -8514,  28691,   2080,
 -8406,  28730,   1980,
 -8311,  28765,   1871,
 -8269,  28786,   1723,
 -8299,  28786,   1573,
 -8283,  28799,   1423,

/* 126 */
14, 1,
-20941, -20602,   6087,
-20998, -20524,   6152,
-21067, -20436,   6208,
-21163, -20341,   6195,
-21239, -20259,   6203,
-21293, -20164,   6326,
-21409, -20040,   6327,
-21473, -20012,   6200,
-21426, -20086,   6121,
-21344, -20194,   6052,
-21247, -20305,   6023,
-21149, -20419,   5981,
-21065, -20528,   5906,
-20979, -20593,   5984,

/* 127 */
13, 1,
 -4213, -29615,   2279,
 -4267, -29597,   2406,
 -4380, -29573,   2503,
 -4508, -29547,   2582,
 -4646, -29519,   2654,
 -4702, -29517,   2572,
 -4590, -29544,   2469,
 -4512, -29565,   2351,
 -4557, -29570,   2206,
 -4684, -29561,   2046,
 -4549, -29584,   2023,
 -4469, -29587,   2148,
 -4320, -29606,   2196,

/* 128 */
17, 1,
 -7190,  25393, -14265,
 -7112,  25378, -14331,
 -7120,  25307, -14452,
 -7024,  25329, -14461,
 -6921,  25307, -14549,
 -6937,  25238, -14661,
 -7060,  25152, -14750,
 -7089,  25166, -14711,
 -7140,  25183, -14657,
 -7201,  25135, -14710,
 -7254,  25157, -14645,
 -7308,  25222, -14506,
 -7376,  25272, -14384,
 -7458,  25292, -14306,
 -7433,  25354, -14210,
 -7329,  25398, -14185,
 -7241,  25418, -14195,

/* 129 */
14, -1,
-19493,  22341,  -4569,
-19472,  22331,  -4707,
-19490,  22314,  -4716,
-19508,  22329,  -4566,
-19549,  22322,  -4426,
-19653,  22240,  -4378,
-19763,  22155,  -4310,
-19839,  22114,  -4170,
-19850,  22141,  -3969,
-19826,  22151,  -4033,
-19807,  22141,  -4177,
-19683,  22231,  -4283,
-19626,  22264,  -4376,
-19523,  22343,  -4430,

/* 130 */
14, 1,
   631,  -8774, -28681,
   536,  -8722, -28699,
   423,  -8648, -28724,
   297,  -8665, -28720,
    79,  -8600, -28741,
   199,  -8618, -28735,
   202,  -8556, -28753,
    51,  -8393, -28802,
   169,  -8385, -28804,
   295,  -8444, -28786,
   437,  -8487, -28771,
   573,  -8549, -28750,
   715,  -8613, -28728,
   692,  -8702, -28702,

/* 131 */
14, 1,
 19698,  -3856, -22297,
 19764,  -3875, -22234,
 19858,  -3942, -22138,
 19917,  -4057, -22065,
 19958,  -4190, -22003,
 19991,  -4334, -21945,
 19935,  -4378, -21987,
 19823,  -4377, -22088,
 19711,  -4379, -22188,
 19623,  -4290, -22283,
 19544,  -4197, -22370,
 19509,  -4061, -22425,
 19527,  -3935, -22432,
 19636,  -3850, -22352,

/* 132 */
13, 1,
-11506,  10377, -25689,
-11530,  10271, -25721,
-11485,  10138, -25794,
-11542,   9992, -25825,
-11574,   9847, -25866,
-11686,   9764, -25848,
-11782,   9854, -25770,
-11896,   9912, -25695,
-12010,   9993, -25611,
-11943,  10110, -25596,
-11854,  10227, -25591,
-11723,  10303, -25621,
-11590,  10358, -25659,

/* 133 */
13, 1,
  3573,  20459,  21649,
  3555,  20377,  21729,
  3434,  20322,  21799,
  3328,  20243,  21890,
  3339,  20136,  21986,
  3381,  20023,  22083,
  3445,  19928,  22159,
  3590,  19867,  22191,
  3648,  19965,  22093,
  3666,  20079,  21986,
  3681,  20189,  21883,
  3641,  20303,  21784,
  3617,  20410,  21688,

/* 134 */
14, 1,
-13127,  24311, -11689,
-13095,  24275, -11800,
-13115,  24210, -11911,
-13126,  24171, -11978,
-13007,  24279, -11890,
-12888,  24314, -11947,
-12876,  24273, -12043,
-12989,  24180, -12109,
-13137,  24097, -12115,
-13215,  24038, -12146,
-13314,  24023, -12067,
-13299,  24094, -11943,
-13218,  24182, -11854,
-13169,  24265, -11738,

/* 135 */
14, -1,
-27102,  -7955,  10108,
-27143,  -7915,  10032,
-27136,  -8036,   9953,
-27134,  -8131,   9881,
-27084,  -8207,   9954,
-27024,  -8266,  10070,
-26970,  -8365,  10133,
-26921,  -8351,  10273,
-26863,  -8463,  10332,
-26822,  -8433,  10462,
-26878,  -8318,  10410,
-26933,  -8214,  10351,
-27001,  -8109,  10257,
-27063,  -8011,  10169,

/* 136 */
13, 1,
 24282,   5951, -16583,
 24283,   5821, -16626,
 24271,   5697, -16687,
 24209,   5633, -16799,
 24230,   5488, -16816,
 24218,   5295, -16896,
 24143,   5357, -16983,
 24105,   5471, -17000,
 24127,   5608, -16925,
 24105,   5760, -16905,
 24106,   5897, -16856,
 24180,   5898, -16750,
 24242,   5949, -16641,

/* 137 */
12, 1,
-26265,   9394,  11041,
-26290,   9264,  11093,
-26229,   9254,  11244,
-26168,   9254,  11384,
-26112,   9243,  11520,
-26040,   9279,  11654,
-25958,   9408,  11734,
-25991,   9492,  11591,
-26038,   9500,  11479,
-26097,   9512,  11334,
-26157,   9514,  11193,
-26220,   9502,  11057,

/* 138 */
13, 1,
   959,  -9398, -28474,
   863,  -9358, -28490,
   726,  -9328, -28504,
   680,  -9232, -28536,
   726,  -9095, -28579,
   846,  -8991, -28608,
   952,  -8948, -28619,
  1117,  -8982, -28602,
  1239,  -9037, -28580,
  1310,  -9153, -28539,
  1344,  -9285, -28495,
  1216,  -9355, -28478,
  1066,  -9394, -28471,

/* 139 */
13, -1,
 14782,  -8096,  24818,
 14851,  -8116,  24770,
 14970,  -8149,  24688,
 15103,  -8126,  24614,
 15232,  -8127,  24535,
 15362,  -8108,  24459,
 15534,  -8064,  24365,
 15482,  -8040,  24406,
 15353,  -8062,  24480,
 15229,  -8072,  24555,
 15094,  -8077,  24636,
 14967,  -8102,  24705,
 14840,  -8091,  24785,

/* 140 */
13, 1,
-18588, -22992,   5084,
-18618, -22951,   5159,
-18714, -22867,   5186,
-18831, -22759,   5237,
-18952, -22653,   5260,
-19068, -22561,   5237,
-19052, -22600,   5125,
-18926, -22712,   5098,
-18893, -22769,   4965,
-18747, -22888,   4972,
-18807, -22812,   5088,
-18754, -22857,   5086,
-18640, -22954,   5063,

/* 141 */
13, 1,
 10930,  21399, -17962,
 11042,  21342, -17960,
 11173,  21333, -17891,
 11262,  21290, -17886,
 11393,  21219, -17887,
 11541,  21133, -17895,
 11662,  21043, -17922,
 11628,  21029, -17960,
 11497,  21103, -17957,
 11363,  21184, -17948,
 11223,  21237, -17973,
 11085,  21298, -17986,
 10930,  21351, -18018,

/* 142 */
13, -1,
  2123,   5909,  29336,
  2214,   5831,  29345,
  2344,   5758,  29349,
  2409,   5627,  29369,
  2324,   5515,  29397,
  2284,   5382,  29425,
  2334,   5220,  29450,
  2368,   5256,  29441,
  2396,   5395,  29413,
  2406,   5530,  29388,
  2414,   5682,  29358,
  2311,   5798,  29344,
  2179,   5864,  29340,

/* 143 */
14, -1,
-17261,  24337,  -3127,
-17367,  24256,  -3168,
-17464,  24183,  -3193,
-17534,  24116,  -3312,
-17637,  24047,  -3264,
-17726,  23996,  -3153,
-17753,  23996,  -3006,
-17723,  24027,  -2932,
-17680,  24048,  -3017,
-17628,  24077,  -3089,
-17503,  24165,  -3114,
-17421,  24240,  -2985,
-17406,  24241,  -3062,
-17312,  24308,  -3064,

/* 144 */
15, -1,
-17925,  23424,   5478,
-17981,  23402,   5389,
-18090,  23338,   5299,
-18186,  23275,   5249,
-18344,  23147,   5264,
-18466,  23042,   5297,
-18395,  23090,   5333,
-18307,  23164,   5319,
-18188,  23250,   5350,
-18055,  23337,   5424,
-18122,  23285,   5424,
-18079,  23307,   5472,
-17970,  23372,   5553,
-17965,  23382,   5524,
-17949,  23399,   5504,

/* 145 */
12, 1,
-11151,  25532, -11125,
-11247,  25472, -11165,
-11360,  25387, -11245,
-11514,  25291, -11305,
-11603,  25207, -11400,
-11642,  25248, -11268,
-11599,  25304, -11189,
-11412,  25424, -11108,
-11533,  25365, -11118,
-11496,  25398, -11081,
-11361,  25471, -11052,
-11229,  25505, -11108,

/* 146 */
13, 1,
 -8245,  28241,   5871,
 -8361,  28193,   5939,
 -8472,  28148,   5990,
 -8527,  28115,   6069,
 -8460,  28104,   6211,
 -8525,  28086,   6207,
 -8559,  28058,   6282,
 -8448,  28071,   6378,
 -8314,  28095,   6445,
 -8194,  28138,   6410,
 -8186,  28176,   6254,
 -8154,  28216,   6111,
 -8181,  28240,   5966,

/* 147 */
12, -1,
-29258,   6281,   2126,
-29281,   6183,   2094,
-29308,   6047,   2123,
-29331,   5906,   2195,
-29338,   5824,   2318,
-29335,   5778,   2463,
-29327,   5753,   2617,
-29302,   5858,   2659,
-29285,   5977,   2576,
-29271,   6090,   2474,
-29263,   6178,   2351,
-29254,   6263,   2231,

/* 148 */
12, -1,
 15271,    556,  25816,
 15343,    663,  25771,
 15427,    783,  25718,
 15536,    857,  25649,
 15609,    980,  25601,
 15623,   1179,  25584,
 15563,   1143,  25622,
 15469,   1042,  25683,
 15368,    952,  25747,
 15275,    847,  25806,
 15196,    727,  25856,
 15215,    607,  25848,

/* 149 */
13, 1,
  4573,  29647,   -405,
  4680,  29631,   -283,
  4807,  29611,   -242,
  4971,  29585,   -202,
  5045,  29572,   -186,
  5108,  29561,   -240,
  5156,  29551,   -392,
  5082,  29562,   -522,
  4997,  29574,   -630,
  4832,  29602,   -631,
  4723,  29620,   -605,
  4606,  29640,   -512,
  4528,  29653,   -458,

/* 150 */
12, -1,
  9509,  25746,  12114,
  9428,  25721,  12228,
  9535,  25676,  12240,
  9592,  25613,  12327,
  9442,  25639,  12388,
  9484,  25610,  12416,
  9635,  25545,  12435,
  9800,  25481,  12436,
  9886,  25484,  12363,
  9884,  25551,  12226,
  9756,  25609,  12207,
  9617,  25671,  12187,

/* 151 */
12, 1,
 10885,  -3987, -27670,
 10786,  -4100, -27692,
 10673,  -4191, -27722,
 10543,  -4265, -27761,
 10416,  -4332, -27798,
 10258,  -4423, -27842,
 10250,  -4360, -27855,
 10358,  -4251, -27832,
 10480,  -4170, -27799,
 10611,  -4111, -27758,
 10728,  -4020, -27726,
 10847,  -3956, -27689,

/* 152 */
12, 1,
-10784,  27846,   2885,
-10753,  27865,   2814,
-10759,  27878,   2664,
-10843,  27855,   2552,
-10983,  27804,   2512,
-11122,  27749,   2511,
-11249,  27693,   2565,
-11292,  27663,   2687,
-11237,  27672,   2830,
-11131,  27704,   2930,
-10991,  27759,   2933,
-10858,  27816,   2891,

/* 153 */
12, -1,
-20095, -16594,  14860,
-20110, -16535,  14906,
-20157, -16401,  14991,
-20152, -16310,  15097,
-20120, -16271,  15180,
-20063, -16246,  15282,
-20156, -16058,  15358,
-20193, -16119,  15245,
-20218, -16214,  15111,
-20210, -16309,  15019,
-20219, -16404,  14904,
-20139, -16535,  14866,

/* 154 */
12, -1,
-19229,  22976,  -1545,
-19296,  22918,  -1556,
-19384,  22836,  -1664,
-19481,  22751,  -1696,
-19561,  22675,  -1788,
-19633,  22616,  -1758,
-19658,  22605,  -1609,
-19579,  22684,  -1447,
-19487,  22755,  -1566,
-19484,  22767,  -1426,
-19393,  22843,  -1461,
-19296,  22921,  -1516,

/* 155 */
11, 1,
 -1931, -29525,  -4956,
 -1965, -29500,  -5088,
 -1938, -29476,  -5235,
 -1892, -29453,  -5379,
 -1850, -29429,  -5526,
 -1722, -29428,  -5571,
 -1604, -29455,  -5461,
 -1567, -29483,  -5322,
 -1611, -29506,  -5179,
 -1693, -29523,  -5051,
 -1812, -29531,  -4962,

/* 156 */
11, 1,
 -7314, -28817,  -4011,
 -7276, -28807,  -4146,
 -7213, -28803,  -4283,
 -7177, -28790,  -4430,
 -7097, -28787,  -4575,
 -7011, -28823,  -4482,
 -6887, -28867,  -4392,
 -6856, -28890,  -4285,
 -6964, -28879,  -4182,
 -7073, -28867,  -4081,
 -7192, -28850,  -3996,

/* 157 */
14, 1,
-10998,  25512, -11321,
-10957,  25484, -11424,
-11011,  25423, -11508,
-11118,  25352, -11562,
-11247,  25290, -11573,
-11222,  25338, -11491,
-11242,  25347, -11452,
-11392,  25299, -11408,
-11375,  25343, -11329,
-11188,  25400, -11389,
-11262,  25388, -11340,
-11255,  25425, -11265,
-11134,  25459, -11308,
-11089,  25463, -11344,

/* 158 */
11, 1,
-29990,    -14,   -784,
-29991,   -153,   -700,
-29992,   -308,   -616,
-29988,   -413,   -745,
-29987,   -521,   -723,
-29990,   -525,   -569,
-29994,   -438,   -445,
-29994,   -304,   -489,
-29994,   -176,   -557,
-29993,    -51,   -632,
-29991,     56,   -714,

/* 159 */
11, 1,
 24220,  -1670, -17623,
 24199,  -1812, -17639,
 24131,  -1911, -17722,
 24047,  -1978, -17828,
 23961,  -1985, -17943,
 23880,  -1926, -18057,
 23840,  -1814, -18121,
 23895,  -1712, -18058,
 23974,  -1620, -17962,
 24065,  -1606, -17840,
 24155,  -1637, -17716,

/* 160 */
11, 1,
   140,  28342,  -9835,
    -8,  28358,  -9789,
  -155,  28356,  -9794,
  -307,  28370,  -9749,
  -403,  28404,  -9646,
  -302,  28445,  -9528,
  -163,  28462,  -9480,
   -13,  28456,  -9501,
   109,  28427,  -9586,
   209,  28389,  -9697,
   217,  28348,  -9817,

/* 161 */
11, 1,
  9134,  18840,  21486,
  9268,  18774,  21486,
  9394,  18683,  21511,
  9529,  18629,  21498,
  9642,  18562,  21506,
  9779,  18480,  21514,
  9736,  18542,  21480,
  9639,  18642,  21438,
  9548,  18737,  21396,
  9398,  18777,  21427,
  9274,  18851,  21416,

/* 162 */
11, 1,
-21516,  19701,   6996,
-21570,  19694,   6847,
-21622,  19676,   6733,
-21678,  19664,   6588,
-21728,  19651,   6458,
-21846,  19562,   6330,
-21840,  19534,   6436,
-21763,  19571,   6585,
-21694,  19597,   6730,
-21629,  19630,   6845,
-21547,  19677,   6968,

/* 163 */
12, 1,
 -2471,  26742, -13370,
 -2577,  26779, -13275,
 -2515,  26811, -13223,
 -2382,  26834, -13201,
 -2269,  26876, -13135,
 -2111,  26875, -13164,
 -1966,  26888, -13159,
 -1903,  26861, -13223,
 -1996,  26815, -13303,
 -2172,  26820, -13264,
 -2285,  26791, -13306,
 -2398,  26749, -13369,

/* 164 */
12, 1,
-10150, -24537,  13962,
-10160, -24501,  14017,
-10262, -24419,  14085,
-10409, -24355,  14089,
-10536, -24306,  14078,
-10669, -24284,  14015,
-10811, -24271,  13929,
-10764, -24299,  13918,
-10641, -24334,  13952,
-10497, -24383,  13974,
-10360, -24435,  13986,
-10224, -24509,  13955,

/* 165 */
12, 1,
-15831, -23712,   9333,
-15820, -23673,   9453,
-15808, -23628,   9584,
-15775, -23585,   9743,
-15746, -23547,   9879,
-15818, -23485,   9912,
-15872, -23485,   9825,
-15937, -23456,   9789,
-16040, -23421,   9703,
-15980, -23513,   9581,
-15962, -23569,   9472,
-15928, -23639,   9353,

/* 166 */
11, -1,
-26860,  12885,  -3537,
-26882,  12817,  -3615,
-26946,  12675,  -3639,
-27001,  12555,  -3648,
-27055,  12427,  -3690,
-27153,  12210,  -3695,
-27125,  12276,  -3679,
-27066,  12414,  -3650,
-27009,  12549,  -3611,
-26952,  12683,  -3567,
-26896,  12816,  -3514,

/* 167 */
10, -1,
 21555,  20350,   4610,
 21542,  20337,   4727,
 21519,  20327,   4874,
 21508,  20302,   5023,
 21523,  20237,   5216,
 21612,  20171,   5107,
 21671,  20139,   4979,
 21703,  20142,   4825,
 21677,  20203,   4682,
 21606,  20314,   4532,

/* 168 */
12, 1,
 25080,  -2304, -16299,
 25116,  -2395, -16231,
 25117,  -2547, -16207,
 25122,  -2692, -16175,
 25150,  -2830, -16107,
 25122,  -2953, -16129,
 25075,  -2890, -16214,
 25021,  -2813, -16310,
 25035,  -2717, -16306,
 25069,  -2633, -16267,
 25036,  -2496, -16340,
 25041,  -2367, -16350,

/* 169 */
11, 1,
 -5147, -29506,   1706,
 -5111, -29507,   1790,
 -5206, -29483,   1916,
 -5310, -29457,   2024,
 -5395, -29433,   2149,
 -5498, -29404,   2278,
 -5553, -29399,   2198,
 -5512, -29418,   2053,
 -5456, -29438,   1913,
 -5367, -29462,   1792,
 -5236, -29489,   1719,

/* 170 */
11, 1,
  3601,  24897,  16346,
  3507,  24832,  16465,
  3401,  24830,  16490,
  3258,  24788,  16581,
  3289,  24705,  16698,
  3361,  24642,  16777,
  3522,  24593,  16815,
  3610,  24628,  16746,
  3622,  24701,  16636,
  3659,  24768,  16527,
  3651,  24851,  16403,

/* 171 */
12, 1,
-16031, -24558,   6319,
-16060, -24566,   6211,
-16088, -24589,   6045,
-16069, -24631,   5922,
-15939, -24699,   5991,
-15997, -24653,   6028,
-15992, -24637,   6107,
-15891, -24691,   6150,
-15759, -24740,   6290,
-15874, -24670,   6277,
-15992, -24612,   6205,
-15978, -24600,   6288,

/* 172 */
11, 1,
  4179,  29039,  -6267,
  4252,  29002,  -6388,
  4198,  28976,  -6539,
  4141,  28953,  -6675,
  4027,  28946,  -6778,
  3873,  28961,  -6802,
  3786,  28995,  -6706,
  3882,  29012,  -6575,
  3974,  29020,  -6483,
  4075,  29030,  -6375,
  4134,  29040,  -6293,

/* 173 */
11, 1,
  7225,  28615,  -5385,
  7075,  28645,  -5425,
  6936,  28669,  -5476,
  6784,  28705,  -5479,
  6761,  28737,  -5335,
  6757,  28763,  -5201,
  6857,  28753,  -5125,
  6981,  28709,  -5205,
  7118,  28667,  -5250,
  7241,  28621,  -5330,
  7290,  28597,  -5390,

/* 174 */
10, 1,
 27028,  -4267, -12299,
 26981,  -4368, -12368,
 26913,  -4418, -12496,
 26837,  -4561, -12608,
 26798,  -4487, -12717,
 26756,  -4387, -12840,
 26809,  -4263, -12771,
 26878,  -4222, -12639,
 26933,  -4270, -12505,
 27000,  -4241, -12369,

/* 175 */
11, -1,
 17469,  24240,   2693,
 17441,  24265,   2655,
 17358,  24337,   2525,
 17308,  24387,   2395,
 17256,  24436,   2262,
 17199,  24491,   2092,
 17162,  24514,   2137,
 17221,  24459,   2280,
 17294,  24396,   2403,
 17345,  24346,   2530,
 17415,  24283,   2652,

/* 176 */
11, 1,
  9832,  -4353, -28007,
  9820,  -4448, -27996,
  9788,  -4592, -27984,
  9729,  -4734, -27981,
  9625,  -4841, -27999,
  9491,  -4963, -28023,
  9489,  -4891, -28036,
  9533,  -4766, -28043,
  9614,  -4643, -28036,
  9674,  -4517, -28036,
  9749,  -4386, -28031,

/* 177 */
11, -1,
  3662,  25807,  14853,
  3527,  25809,  14881,
  3506,  25732,  15019,
  3389,  25705,  15092,
  3365,  25652,  15187,
  3378,  25577,  15310,
  3431,  25557,  15332,
  3546,  25596,  15240,
  3675,  25628,  15156,
  3740,  25685,  15043,
  3732,  25750,  14933,

/* 178 */
10, 1,
 -6841, -28848,  -4579,
 -6930, -28808,  -4696,
 -6919, -28789,  -4828,
 -6963, -28753,  -4978,
 -6963, -28727,  -5123,
 -6843, -28743,  -5198,
 -6761, -28781,  -5096,
 -6761, -28806,  -4951,
 -6735, -28837,  -4805,
 -6753, -28857,  -4657,

/* 179 */
10, 1,
 10303,  -4850, -27755,
 10300,  -4960, -27737,
 10213,  -5078, -27747,
 10074,  -5117, -27791,
  9929,  -5133, -27840,
  9761,  -5138, -27899,
  9812,  -5010, -27904,
  9940,  -4925, -27874,
 10084,  -4914, -27824,
 10211,  -4865, -27786,

/* 180 */
11, 1,
 27435,  -3603, -11592,
 27458,  -3673, -11514,
 27422,  -3750, -11575,
 27366,  -3761, -11704,
 27296,  -3766, -11864,
 27251,  -3718, -11982,
 27204,  -3670, -12103,
 27218,  -3597, -12093,
 27279,  -3599, -11954,
 27339,  -3599, -11817,
 27399,  -3598, -11677,

/* 181 */
11, -1,
-19573, -21914,   6055,
-19614, -21842,   6181,
-19636, -21784,   6314,
-19608, -21767,   6460,
-19535, -21790,   6600,
-19581, -21743,   6621,
-19672, -21703,   6479,
-19659, -21755,   6343,
-19678, -21784,   6184,
-19671, -21807,   6128,
-19595, -21897,   6048,

/* 182 */
10, 1,
-16090, -23678,   8971,
-16023, -23693,   9051,
-16018, -23638,   9203,
-16015, -23585,   9341,
-16083, -23473,   9505,
-16183, -23453,   9384,
-16264, -23458,   9230,
-16164, -23539,   9200,
-16109, -23601,   9137,
-16122, -23641,   9009,

/* 183 */
10, 1,
 -7427,  29059,   -664,
 -7506,  29036,   -766,
 -7600,  29009,   -828,
 -7735,  28973,   -849,
 -7837,  28948,   -751,
 -7918,  28929,   -629,
 -7887,  28941,   -490,
 -7733,  28982,   -472,
 -7591,  29020,   -489,
 -7461,  29052,   -567,

/* 184 */
10, 1,
 22146,  -6178, -19271,
 22086,  -6105, -19363,
 22028,  -5989, -19465,
 22083,  -5859, -19442,
 22158,  -5893, -19347,
 22265,  -5913, -19217,
 22364,  -5874, -19114,
 22383,  -5952, -19068,
 22315,  -6079, -19107,
 22219,  -6161, -19193,

/* 185 */
11, -1,
 13300,  25127,   9578,
 13329,  25168,   9428,
 13322,  25224,   9287,
 13345,  25259,   9161,
 13214,  25348,   9104,
 13174,  25364,   9117,
 13300,  25272,   9187,
 13286,  25235,   9310,
 13295,  25186,   9430,
 13266,  25146,   9576,
 13305,  25103,   9634,

/* 186 */
10, -1,
 11562,  21630,  17276,
 11678,  21590,  17248,
 11818,  21543,  17211,
 11925,  21501,  17190,
 12139,  21361,  17214,
 12075,  21425,  17181,
 11954,  21517,  17150,
 11818,  21608,  17130,
 11686,  21646,  17172,
 11582,  21653,  17234,

/* 187 */
10, 1,
-25792,   5633,  14249,
-25835,   5621,  14175,
-25913,   5566,  14055,
-25932,   5385,  14090,
-26021,   5277,  13966,
-25999,   5245,  14019,
-25926,   5246,  14153,
-25847,   5277,  14286,
-25810,   5414,  14301,
-25776,   5592,  14294,

/* 188 */
10, 1,
-11381,  25287, -11447,
-11325,  25285, -11506,
-11409,  25217, -11574,
-11523,  25137, -11634,
-11649,  25066, -11662,
-11814,  24959, -11724,
-11783,  25017, -11633,
-11697,  25094, -11553,
-11585,  25175, -11489,
-11467,  25250, -11443,

/* 189 */
11, -1,
-17257,  23572,   6821,
-17336,  23540,   6732,
-17352,  23563,   6611,
-17405,  23525,   6607,
-17508,  23431,   6668,
-17570,  23353,   6777,
-17659,  23259,   6870,
-17643,  23267,   6882,
-17519,  23350,   6917,
-17406,  23426,   6948,
-17298,  23518,   6904,

/* 190 */
9, 1,
 21029,   -858, -21378,
 20947,   -896, -21458,
 20843,   -941, -21557,
 20735,   -982, -21658,
 20569,   -957, -21817,
 20644,   -904, -21749,
 20750,   -876, -21649,
 20859,   -860, -21545,
 20967,   -847, -21440,

/* 191 */
9, -1,
 16710,  18554,  16629,
 16750,  18473,  16680,
 16827,  18373,  16711,
 16917,  18256,  16749,
 17031,  18133,  16767,
 17094,  18194,  16637,
 17020,  18312,  16583,
 16906,  18388,  16615,
 16831,  18510,  16556,

/* 192 */
10, 1,
-26154,  13570,   5641,
-26142,  13534,   5783,
-26164,  13442,   5895,
-26202,  13345,   5948,
-26293,  13170,   5937,
-26260,  13216,   5977,
-26190,  13336,   6020,
-26153,  13455,   5915,
-26132,  13547,   5797,
-26146,  13580,   5655,

/* 193 */
10, 1,
-10691, -27735,   4062,
-10602, -27760,   4120,
-10655, -27717,   4273,
-10747, -27667,   4361,
-10850, -27618,   4415,
-10969, -27559,   4492,
-11013, -27547,   4456,
-10944, -27595,   4329,
-10846, -27649,   4229,
-10755, -27701,   4124,

/* 194 */
9, 1,
  5294,  28803,  -6509,
  5435,  28765,  -6562,
  5493,  28751,  -6575,
  5368,  28744,  -6707,
  5286,  28730,  -6831,
  5158,  28731,  -6923,
  5072,  28774,  -6806,
  5084,  28807,  -6655,
  5161,  28822,  -6529,

/* 195 */
10, 1,
-13366,  24028, -12001,
-13301,  24004, -12121,
-13359,  23955, -12153,
-13477,  23886, -12158,
-13599,  23815, -12161,
-13803,  23720, -12118,
-13746,  23764, -12096,
-13613,  23832, -12112,
-13505,  23913, -12075,
-13444,  23979, -12010,

/* 196 */
9, 1,
-13524,  26719,   1794,
-13573,  26703,   1653,
-13632,  26679,   1550,
-13761,  26616,   1493,
-13888,  26547,   1539,
-13877,  26544,   1687,
-13780,  26587,   1796,
-13670,  26638,   1881,
-13542,  26701,   1912,

/* 197 */
10, -1,
-19280,  22118,  -6250,
-19277,  22155,  -6126,
-19302,  22175,  -5974,
-19331,  22185,  -5842,
-19367,  22194,  -5688,
-19295,  22260,  -5675,
-19296,  22219,  -5830,
-19291,  22189,  -5961,
-19260,  22178,  -6100,
-19264,  22139,  -6226,

/* 198 */
9, 1,
 -5809,  29420,   -843,
 -5941,  29393,   -855,
 -6105,  29361,   -799,
 -6240,  29333,   -784,
 -6263,  29331,   -696,
 -6180,  29351,   -553,
 -6026,  29384,   -539,
 -5913,  29405,   -634,
 -5801,  29425,   -740,

/* 199 */
10, -1,
 -2866,   4214,  29564,
 -2943,   4106,  29572,
 -2969,   3985,  29586,
 -2995,   3827,  29604,
 -2854,   3694,  29635,
 -2800,   3856,  29619,
 -2871,   3844,  29614,
 -2919,   3882,  29604,
 -2891,   4037,  29586,
 -2871,   4152,  29572,

/* 200 */
9, 1,
 16380, -17659, -17885,
 16303, -17573, -18039,
 16406, -17509, -18008,
 16503, -17464, -17963,
 16599, -17490, -17849,
 16694, -17522, -17728,
 16683, -17611, -17650,
 16572, -17652, -17714,
 16465, -17641, -17823,

/* 201 */
8, 1,
  2405,  29362,   5664,
  2244,  29361,   5738,
  2299,  29333,   5855,
  2339,  29293,   6035,
  2506,  29280,   6033,
  2614,  29285,   5965,
  2641,  29317,   5794,
  2526,  29334,   5756,

/* 202 */
10, -1,
 15812,  18669,  17362,
 15874,  18668,  17306,
 15995,  18644,  17221,
 16096,  18626,  17145,
 16044,  18729,  17083,
 16070,  18834,  16941,
 15985,  18852,  17003,
 15956,  18800,  17087,
 15849,  18789,  17199,
 15811,  18720,  17308,

/* 203 */
9, -1,
-22192,  18429,  -8241,
-22216,  18378,  -8289,
-22258,  18273,  -8409,
-22303,  18178,  -8492,
-22300,  18084,  -8698,
-22331,  18079,  -8630,
-22338,  18144,  -8472,
-22275,  18259,  -8390,
-22230,  18365,  -8279,

/* 204 */
9, 1,
 11904,  -3476, -27317,
 11852,  -3559, -27329,
 11746,  -3662, -27361,
 11644,  -3775, -27389,
 11457,  -3842, -27459,
 11505,  -3770, -27449,
 11590,  -3649, -27429,
 11704,  -3561, -27392,
 11826,  -3480, -27350,

/* 205 */
9, 1,
 29712,    544,  -4112,
 29725,    642,  -4004,
 29737,    767,  -3887,
 29755,    747,  -3754,
 29757,    689,  -3749,
 29748,    559,  -3839,
 29738,    462,  -3930,
 29725,    324,  -4041,
 29713,    416,  -4120,

/* 206 */
9, 1,
  9469,  -5342, -27961,
  9393,  -5406, -27974,
  9304,  -5517, -27982,
  9181,  -5593, -28008,
  8988,  -5629, -28063,
  9008,  -5520, -28078,
  9119,  -5445, -28057,
  9259,  -5405, -28019,
  9392,  -5332, -27989,

/* 207 */
9, 1,
 -4851,  24586, -16492,
 -4739,  24571, -16548,
 -4627,  24536, -16631,
 -4550,  24463, -16759,
 -4599,  24400, -16837,
 -4716,  24434, -16755,
 -4836,  24462, -16680,
 -4991,  24482, -16605,
 -4945,  24527, -16552,

/* 208 */
9, 1,
 24496,   6480, -16061,
 24538,   6288, -16073,
 24472,   6317, -16162,
 24416,   6245, -16275,
 24356,   6147, -16401,
 24324,   6213, -16424,
 24354,   6333, -16334,
 24400,   6423, -16230,
 24459,   6494, -16111,

/* 209 */
9, 1,
 -5809,  29356,  -2119,
 -5784,  29353,  -2221,
 -5774,  29344,  -2368,
 -5830,  29322,  -2499,
 -5984,  29288,  -2529,
 -6093,  29273,  -2438,
 -6091,  29287,  -2278,
 -5960,  29318,  -2219,
 -5880,  29341,  -2133,

/* 210 */
9, -1,
 28373,   6866,  -6918,
 28389,   6764,  -6949,
 28388,   6667,  -7050,
 28379,   6587,  -7157,
 28358,   6480,  -7337,
 28348,   6546,  -7318,
 28355,   6642,  -7201,
 28346,   6773,  -7115,
 28353,   6862,  -7003,

/* 211 */
9, 1,
  6654,  -7693, -28223,
  6739,  -7650, -28214,
  6702,  -7836, -28172,
  6672,  -7985, -28138,
  6566,  -8073, -28138,
  6420,  -8014, -28188,
  6444,  -7870, -28223,
  6544,  -7788, -28223,
  6632,  -7769, -28208,

/* 212 */
9, 1,
 23496,   6501,  17484,
 23553,   6445,  17428,
 23644,   6399,  17321,
 23731,   6414,  17196,
 23818,   6490,  17046,
 23766,   6562,  17091,
 23681,   6575,  17204,
 23597,   6571,  17321,
 23515,   6560,  17435,

/* 213 */
9, -1,
 -6643,  25925, -13555,
 -6574,  25925, -13589,
 -6446,  25914, -13673,
 -6341,  25887, -13772,
 -6232,  25861, -13870,
 -6303,  25806, -13939,
 -6429,  25827, -13843,
 -6526,  25855, -13746,
 -6602,  25902, -13620,

/* 214 */
9, 1,
 -7497,  28006,  -7711,
 -7597,  27995,  -7653,
 -7735,  27971,  -7604,
 -7708,  27985,  -7580,
 -7631,  28032,  -7482,
 -7586,  28090,  -7307,
 -7482,  28114,  -7323,
 -7446,  28079,  -7491,
 -7434,  28048,  -7619,

/* 215 */
9, -1,
-20663,  19947,  -8671,
-20672,  19907,  -8738,
-20771,  19796,  -8757,
-20881,  19698,  -8716,
-20998,  19601,  -8653,
-20990,  19655,  -8548,
-20937,  19719,  -8533,
-20835,  19792,  -8613,
-20721,  19885,  -8673,

/* 216 */
9, 1,
  4747,  25258,  15476,
  4732,  25211,  15557,
  4707,  25135,  15686,
  4675,  25062,  15812,
  4698,  24971,  15949,
  4737,  24983,  15919,
  4740,  25062,  15793,
  4752,  25142,  15662,
  4762,  25219,  15534,

/* 217 */
8, 1,
  8037,  27999,   7173,
  8163,  27962,   7177,
  8233,  27975,   7045,
  8225,  28017,   6884,
  8158,  28054,   6814,
  8012,  28089,   6842,
  7915,  28093,   6939,
  7945,  28049,   7079,

/* 218 */
8, 1,
 -8206,  28777,  -2132,
 -8117,  28797,  -2201,
 -8074,  28797,  -2348,
 -8149,  28767,  -2462,
 -8295,  28730,  -2405,
 -8471,  28684,  -2344,
 -8422,  28706,  -2239,
 -8300,  28748,  -2158,

/* 219 */
8, 1,
 26623,  -4311, -13138,
 26650,  -4405, -13053,
 26656,  -4566, -12985,
 26620,  -4634, -13035,
 26536,  -4635, -13204,
 26517,  -4531, -13278,
 26514,  -4384, -13333,
 26575,  -4298, -13239,

/* 220 */
9, -1,
-19193,  23050,    547,
-19196,  23050,    431,
-19322,  22946,    352,
-19413,  22870,    343,
-19464,  22825,    436,
-19496,  22795,    559,
-19434,  22845,    631,
-19303,  22956,    634,
-19211,  23035,    595,

/* 221 */
9, -1,
-21968,  17844,  -9950,
-22020,  17699, -10094,
-22085,  17667, -10007,
-22138,  17678,  -9868,
-22237,  17606,  -9774,
-22231,  17617,  -9769,
-22126,  17697,  -9861,
-22081,  17689,  -9976,
-21995,  17812,  -9949,

/* 222 */
8, 1,
 -9395, -28397,   2317,
 -9398, -28383,   2462,
 -9404, -28368,   2613,
 -9454, -28338,   2757,
 -9557, -28307,   2712,
 -9543, -28324,   2580,
 -9525, -28345,   2417,
 -9481, -28371,   2277,

/* 223 */
8, 1,
-23532,   -559,  18600,
-23583,   -699,  18529,
-23505,   -689,  18629,
-23433,   -577,  18723,
-23389,   -466,  18781,
-23407,   -313,  18762,
-23481,   -331,  18668,
-23528,   -460,  18607,

/* 224 */
8, 1,
 29597,   -880,  -4821,
 29608,   -761,  -4772,
 29622,   -629,  -4709,
 29637,   -507,  -4624,
 29655,   -564,  -4504,
 29649,   -703,  -4524,
 29633,   -832,  -4605,
 29612,   -925,  -4721,

/* 225 */
8, 1,
 -4242,  28374,   8769,
 -4353,  28355,   8779,
 -4501,  28336,   8763,
 -4675,  28288,   8829,
 -4588,  28277,   8909,
 -4438,  28287,   8953,
 -4282,  28307,   8966,
 -4223,  28352,   8851,

/* 226 */
8, -1,
 23521,  18132,  -4238,
 23543,  18134,  -4111,
 23628,  18036,  -4054,
 23690,  17940,  -4116,
 23692,  17903,  -4262,
 23674,  17888,  -4420,
 23598,  17983,  -4444,
 23545,  18081,  -4325,

/* 227 */
9, -1,
-12721,  26335,  -6680,
-12620,  26369,  -6739,
-12632,  26332,  -6860,
-12611,  26302,  -7010,
-12514,  26313,  -7142,
-12536,  26304,  -7138,
-12623,  26295,  -7018,
-12655,  26319,  -6869,
-12685,  26338,  -6736,

/* 228 */
8, 1,
 28556,  -1354,  -9094,
 28560,  -1477,  -9062,
 28550,  -1630,  -9069,
 28508,  -1644,  -9198,
 28467,  -1649,  -9324,
 28454,  -1504,  -9388,
 28484,  -1384,  -9315,
 28528,  -1340,  -9186,

/* 229 */
9, -1,
-13304,  26737,  -2855,
-13380,  26703,  -2820,
-13457,  26675,  -2713,
-13434,  26697,  -2611,
-13289,  26772,  -2586,
-13198,  26825,  -2494,
-13149,  26843,  -2557,
-13161,  26825,  -2683,
-13256,  26764,  -2826,

/* 230 */
9, 1,
 -4166,  24261, -17148,
 -4087,  24250, -17183,
 -4011,  24198, -17274,
 -3978,  24134, -17370,
 -3850,  24074, -17482,
 -3902,  24057, -17493,
 -4037,  24098, -17407,
 -4142,  24156, -17302,
 -4173,  24225, -17197,

/* 231 */
10, -1,
 22208,  16310, -11865,
 22163,  16312, -11947,
 22054,  16390, -12042,
 21967,  16539, -11996,
 22058,  16490, -11895,
 22110,  16382, -11948,
 22139,  16390, -11884,
 22178,  16393, -11807,
 22206,  16389, -11760,
 22184,  16338, -11872,

/* 232 */
8, -1,
 18389,  23461,  -3379,
 18467,  23403,  -3362,
 18593,  23301,  -3370,
 18741,  23181,  -3376,
 18715,  23192,  -3448,
 18595,  23283,  -3482,
 18475,  23375,  -3505,
 18352,  23480,  -3446,

/* 233 */
9, -1,
-12115,  27105,   4305,
-12042,  27144,   4265,
-11944,  27205,   4151,
-11886,  27256,   3977,
-11963,  27223,   3977,
-12097,  27163,   3979,
-12192,  27111,   4045,
-12123,  27125,   4154,
-12115,  27113,   4255,

/* 234 */
9, 1,
 22705,     -5, -19608,
 22754,    -24, -19551,
 22862,    -80, -19425,
 22818,   -168, -19476,
 22730,   -143, -19579,
 22671,   -158, -19647,
 22567,   -178, -19766,
 22561,    -79, -19773,
 22650,    -22, -19672,

/* 235 */
9, -1,
-21304,  20829,  -3509,
-21365,  20762,  -3537,
-21454,  20670,  -3530,
-21547,  20588,  -3446,
-21644,  20505,  -3331,
-21627,  20522,  -3337,
-21542,  20594,  -3439,
-21449,  20677,  -3520,
-21361,  20768,  -3524,

/* 236 */
8, 1,
 21301,  -2864, -20930,
 21350,  -2973, -20864,
 21345,  -3114, -20850,
 21328,  -3240, -20847,
 21220,  -3300, -20948,
 21204,  -3158, -20986,
 21204,  -3028, -21006,
 21247,  -2886, -20982,

/* 237 */
8, 1,
 -3541,  26084, -14390,
 -3450,  26068, -14442,
 -3307,  26026, -14550,
 -3391,  25972, -14628,
 -3574,  25935, -14650,
 -3684,  25952, -14592,
 -3711,  25996, -14506,
 -3627,  26064, -14406,

/* 238 */
9, 1,
-17503, -23888,   4794,
-17405, -23951,   4839,
-17332, -23984,   4938,
-17242, -24024,   5056,
-17159, -24065,   5140,
-17206, -24032,   5138,
-17288, -23990,   5063,
-17377, -23949,   4945,
-17464, -23907,   4848,

/* 239 */
8, 1,
-20659,  21543,   3021,
-20679,  21534,   2947,
-20689,  21548,   2768,
-20719,  21543,   2574,
-20753,  21501,   2648,
-20775,  21462,   2794,
-20781,  21434,   2955,
-20712,  21490,   3037,

/* 240 */
8, 1,
 24748,   -885, -16934,
 24748,   -998, -16928,
 24674,  -1039, -17033,
 24588,  -1005, -17158,
 24491,   -967, -17299,
 24522,   -911, -17258,
 24610,   -882, -17135,
 24697,   -860, -17010,

/* 241 */
8, 1,
 22276,  -3747, -19742,
 22324,  -3853, -19667,
 22373,  -3985, -19585,
 22387,  -4091, -19546,
 22326,  -4162, -19602,
 22270,  -4057, -19687,
 22222,  -3932, -19767,
 22229,  -3776, -19789,

/* 242 */
10, 1,
-16881, -24201,   5419,
-16954, -24164,   5354,
-17029, -24132,   5259,
-17093, -24103,   5185,
-17033, -24162,   5108,
-16916, -24247,   5093,
-16907, -24232,   5194,
-16837, -24280,   5195,
-16802, -24288,   5271,
-16841, -24239,   5369,

/* 243 */
8, 1,
-26588,  12735,   5561,
-26640,  12625,   5560,
-26704,  12502,   5531,
-26736,  12390,   5629,
-26710,  12391,   5746,
-26650,  12501,   5789,
-26609,  12624,   5708,
-26570,  12743,   5625,

/* 244 */
8, -1,
 15516,  21285, -14359,
 15539,  21320, -14283,
 15632,  21329, -14168,
 15729,  21251, -14178,
 15794,  21145, -14262,
 15795,  21066, -14378,
 15669,  21129, -14425,
 15552,  21229, -14404,

/* 245 */
8, 1,
  7216,  28601,  -5469,
  7186,  28582,  -5607,
  7188,  28551,  -5759,
  7086,  28564,  -5820,
  7023,  28603,  -5705,
  7063,  28622,  -5559,
  7137,  28626,  -5441,
  7238,  28609,  -5399,

/* 246 */
8, 1,
  3833,  29553,   3454,
  3835,  29564,   3360,
  3801,  29582,   3232,
  3812,  29598,   3065,
  3683,  29614,   3070,
  3711,  29595,   3220,
  3702,  29580,   3365,
  3753,  29563,   3453,

/* 247 */
8, 1,
  8843,  28172,   5303,
  8930,  28154,   5253,
  9026,  28139,   5168,
  8944,  28180,   5088,
  8801,  28218,   5127,
  8645,  28261,   5158,
  8644,  28240,   5274,
  8757,  28195,   5325,

/* 248 */
7, 1,
 21050,   -381, -21372,
 20956,   -450, -21463,
 20896,   -570, -21518,
 20758,   -603, -21650,
 20800,   -490, -21613,
 20887,   -392, -21531,
 20987,   -362, -21434,

/* 249 */
7, -1,
  3999,  25672,  14999,
  3947,  25630,  15084,
  3910,  25561,  15211,
  3907,  25438,  15415,
  3975,  25486,  15318,
  4009,  25560,  15185,
  4016,  25626,  15072,

/* 250 */
8, 1,
-26361,  12892,   6235,
-26360,  12825,   6380,
-26385,  12717,   6488,
-26451,  12584,   6481,
-26444,  12579,   6516,
-26380,  12719,   6507,
-26355,  12825,   6398,
-26349,  12904,   6261,

/* 251 */
7, 1,
  5148,  25410,  15094,
  5070,  25383,  15166,
  5022,  25312,  15300,
  5104,  25186,  15480,
  5183,  25227,  15387,
  5205,  25294,  15269,
  5192,  25377,  15134,

/* 252 */
7, 1,
 24083,  -4111, -17411,
 23997,  -4125, -17525,
 23904,  -4131, -17651,
 23825,  -4049, -17776,
 23851,  -3979, -17756,
 23933,  -3994, -17642,
 24019,  -4018, -17520,

/* 253 */
8, 1,
 12234, -12996, -24113,
 12221, -12862, -24191,
 12195, -12735, -24272,
 12236, -12601, -24321,
 12274, -12603, -24300,
 12281, -12743, -24224,
 12292, -12856, -24158,
 12284, -12989, -24092,

/* 254 */
7, 1,
  1263,  19267,  22961,
  1175,  19245,  22984,
  1017,  19131,  23086,
  1130,  19054,  23144,
  1275,  19024,  23161,
  1374,  19135,  23064,
  1289,  19219,  22999,

/* 255 */
7, 1,
 24383,   5280, -16661,
 24459,   5240, -16562,
 24541,   5139, -16472,
 24541,   5027, -16506,
 24458,   5005, -16636,
 24364,   5074, -16753,
 24336,   5200, -16755,

/* 256 */
7, 1,
 -3500,  28664,   8132,
 -3601,  28667,   8076,
 -3688,  28634,   8155,
 -3656,  28603,   8277,
 -3510,  28568,   8460,
 -3436,  28603,   8369,
 -3461,  28641,   8229,

/* 257 */
8, -1,
 10996,  25265,  11864,
 11110,  25195,  11908,
 11226,  25113,  11972,
 11278,  25087,  11977,
 11162,  25184,  11883,
 11088,  25270,  11767,
 11050,  25316,  11705,
 10978,  25286,  11836,

/* 258 */
7, 1,
 -8489, -28676,   2368,
 -8534, -28674,   2233,
 -8434, -28711,   2126,
 -8299, -28751,   2122,
 -8174, -28778,   2234,
 -8256, -28750,   2301,
 -8386, -28707,   2361,

/* 259 */
7, 1,
 -8544, -28708,   1696,
 -8608, -28679,   1845,
 -8708, -28644,   1927,
 -8807, -28616,   1888,
 -8873, -28606,   1722,
 -8768, -28639,   1705,
 -8637, -28683,   1644,

/* 260 */
7, 1,
-13684,  26583,   2464,
-13786,  26538,   2388,
-13923,  26466,   2387,
-14021,  26405,   2485,
-13964,  26428,   2567,
-13835,  26492,   2601,
-13708,  26561,   2576,

/* 261 */
7, 1,
-26462,  13710,  -3429,
-26501,  13633,  -3440,
-26571,  13498,  -3431,
-26681,  13293,  -3381,
-26639,  13374,  -3389,
-26569,  13504,  -3422,
-26499,  13638,  -3433,

/* 262 */
8, 1,
 25177,  -2424, -16132,
 25228,  -2479, -16044,
 25243,  -2599, -16001,
 25250,  -2748, -15966,
 25200,  -2804, -16034,
 25160,  -2757, -16106,
 25147,  -2621, -16148,
 25146,  -2487, -16171,

/* 263 */
7, 1,
 -3593,  28752,   7771,
 -3723,  28726,   7809,
 -3671,  28701,   7923,
 -3472,  28705,   7997,
 -3572,  28730,   7864,
 -3478,  28728,   7914,
 -3486,  28745,   7848,

/* 264 */
7, -1,
 18992,  23204,   -949,
 19042,  23166,   -870,
 19118,  23106,   -769,
 19234,  23008,   -825,
 19245,  22994,   -957,
 19136,  23079,  -1078,
 19034,  23167,   -996,

/* 265 */
8, -1,
 16204,    715,  25237,
 16285,    721,  25185,
 16426,    677,  25094,
 16435,    748,  25087,
 16492,    864,  25046,
 16421,    862,  25092,
 16295,    817,  25176,
 16173,    788,  25255,

/* 266 */
7, 1,
 11947,  21012, -17769,
 12037,  20940, -17795,
 12231,  20786, -17843,
 12131,  20833, -17855,
 12002,  20918, -17844,
 11861,  20972, -17874,
 11867,  21007, -17829,

/* 267 */
8, 1,
-16323,  24985,   3054,
-16387,  24948,   3014,
-16524,  24860,   2989,
-16479,  24874,   3116,
-16373,  24938,   3163,
-16467,  24877,   3161,
-16422,  24905,   3175,
-16303,  24983,   3175,

/* 268 */
8, -1,
  7459,  26926,  10924,
  7513,  26882,  10997,
  7635,  26828,  11044,
  7776,  26741,  11156,
  7765,  26763,  11112,
  7721,  26826,  10988,
  7681,  26855,  10945,
  7541,  26911,  10906,

/* 269 */
7, 1,
  4421,  25599, -15005,
  4258,  25656, -14954,
  4109,  25699, -14923,
  4130,  25757, -14816,
  4307,  25712, -14844,
  4392,  25634, -14953,
  4462,  25599, -14993,

/* 270 */
7, 1,
 -3740,  24124, -17437,
 -3639,  24118, -17467,
 -3579,  24047, -17577,
 -3476,  23945, -17736,
 -3550,  23952, -17712,
 -3642,  24019, -17602,
 -3745,  24077, -17501,

/* 271 */
7, -1,
  1630,  23899,  18060,
  1623,  23826,  18157,
  1649,  23747,  18259,
  1801,  23751,  18239,
  1837,  23825,  18138,
  1752,  23907,  18038,
  1698,  23966,  17965,

/* 272 */
8, -1,
 17320,  22752,  -9075,
 17418,  22694,  -9033,
 17544,  22617,  -8981,
 17636,  22531,  -9019,
 17620,  22517,  -9084,
 17502,  22591,  -9128,
 17388,  22655,  -9189,
 17355,  22695,  -9152,

/* 273 */
7, 1,
  6068,  25608,  14403,
  5959,  25597,  14466,
  5878,  25552,  14579,
  5966,  25456,  14710,
  6004,  25469,  14673,
  6080,  25509,  14571,
  6168,  25566,  14434,

/* 274 */
7, -1,
 17827,   6043,  23359,
 17858,   6112,  23318,
 17888,   6242,  23260,
 17817,   6372,  23280,
 17695,   6347,  23380,
 17678,   6197,  23433,
 17782,   6111,  23376,

/* 275 */
7, 1,
  1364, -29308,  -6258,
  1229, -29302,  -6317,
  1253, -29279,  -6416,
  1413, -29273,  -6411,
  1529, -29264,  -6423,
  1493, -29305,  -6246,
  1443, -29323,  -6169,

/* 276 */
7, -1,
-18191, -23193,   5583,
-18265, -23125,   5622,
-18278, -23063,   5834,
-18333, -23041,   5743,
-18425, -23007,   5582,
-18359, -23065,   5564,
-18244, -23153,   5578,

/* 277 */
7, 1,
 -5480,  29422,  -2079,
 -5514,  29407,  -2194,
 -5553,  29387,  -2359,
 -5618,  29379,  -2305,
 -5670,  29379,  -2176,
 -5696,  29385,  -2019,
 -5552,  29413,  -2008,

/* 278 */
7, 1,
-26312,  13467,   5132,
-26326,  13403,   5224,
-26288,  13423,   5364,
-26225,  13467,   5557,
-26230,  13485,   5489,
-26262,  13490,   5322,
-26311,  13440,   5204,

/* 279 */
7, 1,
 22241,  13603,  14842,
 22193,  13609,  14909,
 22130,  13563,  15044,
 22075,  13455,  15220,
 22122,  13450,  15156,
 22189,  13486,  15026,
 22228,  13557,  14903,

/* 280 */
7, -1,
-10783,  26096, -10136,
-10856,  26061, -10147,
-10996,  26008, -10134,
-11189,  25915, -10161,
-11137,  25950, -10127,
-11004,  26011, -10118,
-10861,  26064, -10135,

/* 281 */
7, 1,
 29783,   1256,  -3378,
 29787,   1324,  -3316,
 29796,   1412,  -3194,
 29807,   1499,  -3045,
 29813,   1403,  -3033,
 29802,   1338,  -3169,
 29791,   1251,  -3304,

/* 282 */
6, 1,
-17758,  24025,   2727,
-17787,  24019,   2591,
-17874,  23960,   2539,
-17910,  23915,   2700,
-17915,  23890,   2888,
-17800,  23981,   2839,

/* 283 */
7, -1,
-23952,  18049,    730,
-24007,  17974,    772,
-24094,  17855,    810,
-24203,  17707,    838,
-24168,  17753,    865,
-24082,  17871,    828,
-23997,  17987,    783,

/* 284 */
7, -1,
 -1959,   8253,  28776,
 -2044,   8220,  28779,
 -2153,   8138,  28795,
 -2157,   8014,  28829,
 -2103,   7933,  28856,
 -2141,   8143,  28794,
 -2032,   8214,  28782,

/* 285 */
7, 1,
 24446,   -969, -17363,
 24388,  -1010, -17442,
 24298,  -1004, -17567,
 24193,   -976, -17713,
 24218,   -945, -17680,
 24308,   -942, -17556,
 24398,   -945, -17431,

/* 286 */
8, 1,
  2887,  27868,  10725,
  2967,  27892,  10640,
  3060,  27912,  10563,
  3067,  27965,  10418,
  3008,  27944,  10493,
  2954,  27969,  10440,
  2915,  27943,  10521,
  2890,  27898,  10646,

/* 287 */
7, 1,
 21419,  -3233, -20756,
 21395,  -3352, -20761,
 21407,  -3475, -20729,
 21356,  -3587, -20762,
 21281,  -3502, -20853,
 21283,  -3385, -20870,
 21367,  -3277, -20802,

/* 288 */
8, 1,
 20078,  -7369, -21038,
 20021,  -7376, -21089,
 19904,  -7400, -21192,
 19900,  -7339, -21216,
 19922,  -7209, -21240,
 19969,  -7135, -21221,
 20044,  -7154, -21143,
 20063,  -7293, -21078,

/* 289 */
7, 1,
 10608,  21446, -18098,
 10453,  21517, -18104,
 10323,  21591, -18090,
 10282,  21640, -18056,
 10461,  21565, -18042,
 10590,  21494, -18051,
 10655,  21440, -18077,

/* 290 */
7, 1,
 16151,  -1050, -25260,
 16224,  -1051, -25213,
 16346,  -1027, -25135,
 16495,  -1088, -25034,
 16434,  -1132, -25073,
 16296,  -1144, -25162,
 16177,  -1082, -25242,

/* 291 */
7, 1,
  6256,  -8530, -28073,
  6167,  -8540, -28090,
  6097,  -8470, -28126,
  6225,  -8357, -28132,
  6335,  -8248, -28139,
  6377,  -8317, -28110,
  6288,  -8426, -28098,

/* 292 */
7, 1,
 21026,  13541, -16569,
 21111,  13472, -16518,
 21186,  13403, -16477,
 21295,  13249, -16462,
 21240,  13292, -16497,
 21146,  13390, -16539,
 21039,  13485, -16599,

/* 293 */
8, -1,
-18859, -22602,   5789,
-18753, -22656,   5917,
-18802, -22607,   5950,
-18942, -22492,   5941,
-18895, -22540,   5908,
-18990, -22473,   5858,
-18942, -22524,   5819,
-18897, -22577,   5762,

/* 294 */
7, -1,
 13656,  23661,  12396,
 13688,  23703,  12280,
 13634,  23780,  12191,
 13597,  23872,  12052,
 13579,  23868,  12080,
 13618,  23786,  12198,
 13648,  23704,  12322,

/* 295 */
6, 1,
  8006,  23007, -17510,
  7855,  23063, -17504,
  7734,  23149, -17444,
  7751,  23202, -17366,
  7909,  23112, -17416,
  8038,  23054, -17433,

/* 296 */
6, 1,
  3087,  24735,  16693,
  2904,  24716,  16754,
  2976,  24631,  16866,
  3080,  24593,  16902,
  3198,  24626,  16832,
  3165,  24707,  16719,

/* 297 */
8, 1,
-12618,  24857, -11088,
-12616,  24812, -11190,
-12669,  24738, -11292,
-12755,  24707, -11265,
-12794,  24688, -11260,
-12854,  24666, -11241,
-12811,  24743, -11121,
-12697,  24822, -11075,

/* 298 */
7, 1,
-11749,  25130, -11421,
-11784,  25081, -11492,
-11894,  25005, -11545,
-11984,  24923, -11628,
-11997,  24952, -11552,
-11931,  25029, -11454,
-11852,  25089, -11405,

/* 299 */
6, 1,
 25018,   -660, -16543,
 25084,   -664, -16442,
 25163,   -623, -16323,
 25190,   -770, -16275,
 25104,   -777, -16407,
 25026,   -758, -16527,

/* 300 */
6, 1,
-15854, -24577,   6681,
-15934, -24552,   6579,
-16000, -24553,   6417,
-15916, -24614,   6391,
-15830, -24642,   6496,
-15768, -24646,   6630,

/* 301 */
7, -1,
-17115,  24557,  -2011,
-17119,  24547,  -2095,
-17152,  24511,  -2241,
-17184,  24475,  -2389,
-17213,  24457,  -2361,
-17182,  24492,  -2224,
-17139,  24533,  -2095,

/* 302 */
6, 1,
 11398,  -4172, -27435,
 11468,  -4286, -27388,
 11351,  -4344, -27428,
 11215,  -4449, -27467,
 11234,  -4322, -27479,
 11320,  -4219, -27460,

/* 303 */
6, 1,
 -7436,  14318,  25292,
 -7574,  14260,  25284,
 -7657,  14199,  25294,
 -7564,  14103,  25375,
 -7447,  14209,  25350,
 -7349,  14319,  25317,

/* 304 */
6, 1,
 23814,   -745, -18231,
 23819,   -838, -18220,
 23745,   -898, -18313,
 23622,   -862, -18473,
 23677,   -749, -18407,
 23765,   -720, -18295,

/* 305 */
6, 1,
 -1698,  25570,  15597,
 -1786,  25547,  15625,
 -1901,  25497,  15694,
 -1932,  25409,  15832,
 -1812,  25443,  15791,
 -1719,  25508,  15696,

/* 306 */
6, 1,
-11912,  25153, -11200,
-11790,  25170, -11291,
-11855,  25112, -11351,
-11998,  25019, -11406,
-12028,  25061, -11282,
-12006,  25116, -11184,

/* 307 */
7, -1,
-20089,  -9689,  20064,
-20155,  -9600,  20040,
-20231,  -9447,  20036,
-20249,  -9528,  19980,
-20180,  -9655,  19989,
-20180,  -9738,  19948,
-20141,  -9747,  19984,

/* 308 */
6, -1,
 22251,  15516, -12811,
 22247,  15429, -12924,
 22161,  15455, -13039,
 22141,  15509, -13009,
 22106,  15644, -12907,
 22178,  15629, -12802,

/* 309 */
6, 1,
 -6458,  14255,  25595,
 -6554,  14149,  25629,
 -6559,  14123,  25642,
 -6403,  14187,  25646,
 -6314,  14292,  25610,
 -6346,  14389,  25548,

/* 310 */
6, 1,
 24489,  -4261, -16797,
 24479,  -4353, -16788,
 24390,  -4387, -16909,
 24298,  -4332, -17053,
 24353,  -4261, -16994,
 24441,  -4260, -16867,

/* 311 */
6, 1,
 -3316,  28682,   8146,
 -3415,  28695,   8058,
 -3595,  28686,   8012,
 -3560,  28673,   8075,
 -3446,  28656,   8184,
 -3342,  28652,   8241,

/* 312 */
6, 1,
 23528,   1053, -18582,
 23461,   1092, -18665,
 23408,   1221, -18724,
 23439,   1344, -18676,
 23521,   1263, -18578,
 23545,   1131, -18556,

/* 313 */
6, 1,
 -6353,  29317,   -386,
 -6339,  29319,   -493,
 -6342,  29315,   -643,
 -6460,  29289,   -661,
 -6493,  29285,   -499,
 -6452,  29295,   -385,

/* 314 */
6, 1,
 23124, -10704,  15834,
 23036, -10724,  15948,
 22999, -10847,  15919,
 23044, -10922,  15802,
 23131, -10866,  15712,
 23142, -10770,  15762,

/* 315 */
6, 1,
-10965, -27064,   6879,
-10940, -27048,   6980,
-11007, -26992,   7089,
-11149, -26948,   7036,
-11169, -26971,   6914,
-11039, -27037,   6868,

/* 316 */
6, -1,
  4917,  27988,   9617,
  5013,  27967,   9629,
  5100,  27981,   9543,
  5064,  28053,   9347,
  5010,  28046,   9399,
  4950,  28007,   9545,

/* 317 */
6, 1,
-11542, -27125,   5570,
-11473, -27141,   5635,
-11467, -27105,   5817,
-11576, -27051,   5852,
-11632, -27046,   5766,
-11584, -27093,   5638,

/* 318 */
6, 1,
 22858,   -880, -19409,
 22912,   -904, -19345,
 23022,   -972, -19210,
 22961,  -1059, -19279,
 22862,  -1052, -19397,
 22839,   -961, -19428,

/* 319 */
6, 1,
-27648,  11150,   3354,
-27687,  11048,   3371,
-27711,  10974,   3414,
-27675,  11016,   3573,
-27626,  11142,   3557,
-27621,  11197,   3417,

/* 320 */
6, 1,
  4612,   1962,  29578,
  4518,   1931,  29595,
  4427,   1799,  29617,
  4460,   1694,  29618,
  4570,   1751,  29598,
  4642,   1891,  29578,

/* 321 */
6, 1,
 -1839,  23767, -18214,
 -1796,  23716, -18284,
 -1612,  23658, -18376,
 -1690,  23650, -18381,
 -1814,  23669, -18344,
 -1890,  23729, -18258,

/* 322 */
6, 1,
-26596,  11995,   6985,
-26635,  11856,   7071,
-26664,  11771,   7104,
-26662,  11721,   7194,
-26631,  11857,   7086,
-26593,  11984,   7013,

/* 323 */
6, 1,
 23795,   -164, -18269,
 23841,   -219, -18208,
 23812,   -377, -18245,
 23716,   -430, -18367,
 23734,   -356, -18345,
 23759,   -226, -18315,

/* 324 */
6, -1,
-22867, -15404,  11824,
-22826, -15380,  11935,
-22834, -15304,  12017,
-22916, -15247,  11933,
-22969, -15289,  11776,
-22920, -15374,  11760,

/* 325 */
6, 1,
 11693,  24510, -12748,
 11629,  24490, -12845,
 11504,  24578, -12789,
 11546,  24618, -12675,
 11682,  24554, -12674,
 11749,  24509, -12699,

/* 326 */
6, 1,
-11168, -26833,   7435,
-11150, -26813,   7534,
-11068, -26812,   7657,
-11110, -26778,   7713,
-11217, -26762,   7614,
-11231, -26799,   7460,

/* 327 */
6, 1,
-13936,  24051, -11284,
-14010,  23975, -11354,
-14070,  23913, -11412,
-14166,  23881, -11358,
-14150,  23934, -11268,
-14032,  24014, -11244,

/* 328 */
6, 1,
 29225,    434,  -6762,
 29243,    495,  -6680,
 29273,    556,  -6542,
 29289,    494,  -6472,
 29273,    413,  -6551,
 29236,    396,  -6718,

/* 329 */
5, 1,
 -3608, -29413,   4678,
 -3700, -29407,   4641,
 -3899, -29404,   4497,
 -3803, -29410,   4540,
 -3678, -29413,   4618,

/* 330 */
5, 1,
 27658,  11617,   -322,
 27692,  11536,   -286,
 27776,  11329,   -338,
 27740,  11414,   -417,
 27687,  11546,   -384,

/* 331 */
5, 1,
 -2705, -28959,   7352,
 -2729, -28937,   7430,
 -2844, -28880,   7605,
 -2910, -28904,   7491,
 -2771, -28942,   7394,

/* 332 */
5, -1,
-15874,  23873,  -8837,
-15942,  23833,  -8822,
-16163,  23707,  -8761,
-16069,  23763,  -8780,
-15941,  23838,  -8811,

/* 333 */
5, 1,
-22981,    137,  19284,
-23077,    108,  19168,
-23073,     27,  19173,
-22966,     -8,  19302,
-22904,    106,  19376,

/* 334 */
6, 1,
 -7340,  25545, -13913,
 -7253,  25554, -13941,
 -7179,  25516, -14050,
 -7181,  25466, -14139,
 -7294,  25470, -14073,
 -7377,  25507, -13963,

/* 335 */
5, 1,
  1932,  28169, -10137,
  2074,  28188, -10055,
  2162,  28154, -10132,
  2057,  28120, -10250,
  1942,  28131, -10242,

/* 336 */
5, 1,
 -2239,  29202,   6500,
 -2266,  29182,   6578,
 -2312,  29124,   6816,
 -2271,  29149,   6722,
 -2229,  29185,   6578,

/* 337 */
5, -1,
-24505,   2604,  17110,
-24555,   2505,  17052,
-24575,   2383,  17040,
-24485,   2402,  17168,
-24450,   2531,  17199,

/* 338 */
6, 1,
-20336, -21189,   6121,
-20347, -21152,   6211,
-20408, -21067,   6302,
-20487, -21004,   6255,
-20468, -21052,   6154,
-20397, -21137,   6101,

/* 339 */
4, 1,
  4254,   3683, -29468,
  4574,   3708, -29416,
  4411,   3692, -29443,
  4306,   3652, -29464,

/* 340 */
5, 1,
  4284,  29586,   2515,
  4343,  29586,   2410,
  4257,  29610,   2263,
  4159,  29616,   2362,
  4179,  29604,   2474,

/* 341 */
5, 1,
-26886,  10733,   7871,
-26857,  10721,   7985,
-26772,  10821,   8134,
-26796,  10837,   8035,
-26847,  10809,   7900,

/* 342 */
5, 1,
-13498,  24234, -11425,
-13603,  24169, -11437,
-13772,  24084, -11415,
-13704,  24146, -11364,
-13569,  24214, -11383,

/* 343 */
6, -1,
 22043,  16210, -12301,
 21987,  16242, -12359,
 21917,  16376, -12307,
 21981,  16378, -12190,
 21948,  16374, -12256,
 21996,  16289, -12282,

/* 344 */
5, 1,
 22450,  -6144, -18928,
 22339,  -6114, -19068,
 22394,  -5962, -19052,
 22453,  -5946, -18987,
 22468,  -6083, -18926,

/* 345 */
5, 1,
 20013,  16577, -14989,
 20065,  16571, -14926,
 20205,  16488, -14829,
 20157,  16444, -14943,
 20033,  16517, -15028,

/* 346 */
5, 1,
  8227,  28696,   2972,
  8212,  28719,   2784,
  8113,  28748,   2779,
  8047,  28756,   2886,
  8158,  28716,   2972,

/* 347 */
5, 1,
 -6380,  29120,  -3367,
 -6408,  29102,  -3469,
 -6521,  29059,  -3610,
 -6539,  29070,  -3486,
 -6438,  29107,  -3369,

/* 348 */
5, 1,
 23793, -10289,  15101,
 23699, -10405,  15169,
 23686, -10502,  15121,
 23780, -10446,  15013,
 23819, -10349,  15019,

/* 349 */
5, 1,
 18853,  -3180,  23118,
 18901,  -3297,  23063,
 18968,  -3281,  23010,
 18932,  -3124,  23061,
 18895,  -3044,  23102,

/* 350 */
5, 1,
 -2898,  29718,   2905,
 -2792,  29737,   2818,
 -2798,  29752,   2644,
 -2893,  29738,   2699,
 -2913,  29722,   2848,

/* 351 */
5, 1,
  4133,  24673, -16558,
  4155,  24634, -16610,
  4106,  24558, -16734,
  4025,  24530, -16795,
  4068,  24641, -16622,

/* 352 */
5, 1,
-17359,  23518,   6748,
-17465,  23458,   6687,
-17532,  23383,   6774,
-17444,  23419,   6873,
-17362,  23483,   6864,

/* 353 */
5, 1,
 24745,  -5658, -15990,
 24675,  -5633, -16106,
 24627,  -5515, -16219,
 24669,  -5498, -16162,
 24723,  -5579, -16051,

/* 354 */
5, 1,
 -6134,  29314,  -1752,
 -6252,  29288,  -1762,
 -6418,  29255,  -1723,
 -6342,  29275,  -1665,
 -6198,  29304,  -1692,

/* 355 */
5, -1,
-18455, -22892,   5946,
-18536, -22842,   5888,
-18625, -22804,   5752,
-18572, -22857,   5713,
-18496, -22884,   5851,

/* 356 */
5, 1,
  7506,  28869,  -3200,
  7392,  28904,  -3154,
  7455,  28902,  -3013,
  7565,  28873,  -3018,
  7586,  28854,  -3142,

/* 357 */
5, 1,
-19149, -22531,   5067,
-19218, -22464,   5106,
-19374, -22341,   5054,
-19308, -22407,   5013,
-19200, -22493,   5043,

/* 358 */
4, 1,
-11154,  10714, -25706,
-11240,  10578, -25725,
-11378,  10594, -25658,
-11339,  10688, -25636,

/* 359 */
5, 1,
-11977, -26541,   7220,
-11942, -26527,   7327,
-11921, -26490,   7494,
-12001, -26474,   7422,
-12012, -26509,   7281,

/* 360 */
5, -1,
 12975,  18669,  19573,
 12986,  18730,  19508,
 12861,  18855,  19471,
 12799,  18802,  19562,
 12908,  18705,  19583,

/* 361 */
5, 1,
-10778,  27815,   3183,
-10775,  27829,   3071,
-10812,  27825,   2976,
-10915,  27778,   3045,
-10863,  27780,   3206,

/* 362 */
5, 1,
  5802,  24352,  16532,
  5856,  24373,  16483,
  5972,  24457,  16315,
  5899,  24444,  16362,
  5808,  24383,  16484,

/* 363 */
5, 1,
 10271,  19027,  20796,
 10166,  18984,  20887,
 10252,  18927,  20896,
 10390,  18890,  20862,
 10365,  18962,  20809,

/* 364 */
5, 1,
 -3812,  -7158, -28883,
 -3923,  -7135, -28874,
 -3910,  -7011, -28906,
 -3733,  -7013, -28929,
 -3745,  -7106, -28905,

/* 365 */
5, -1,
-26344,  13706,   4261,
-26392,  13637,   4185,
-26439,  13541,   4200,
-26435,  13510,   4322,
-26361,  13649,   4335,

/* 366 */
4, 1,
  4332, -21849, -20096,
  4358, -21992, -19934,
  4207, -21972, -19989,
  4236, -21901, -20060,

/* 367 */
5, 1,
 11385,  17811,  21287,
 11313,  17770,  21360,
 11297,  17649,  21468,
 11391,  17660,  21410,
 11419,  17767,  21306,

/* 368 */
5, 1,
-25127,  12810, -10224,
-25152,  12740, -10250,
-25207,  12608, -10277,
-25238,  12542, -10283,
-25154,  12745, -10240,

/* 369 */
5, 1,
 12061, -19379, -19468,
 12066, -19320, -19523,
 12195, -19209, -19552,
 12252, -19233, -19494,
 12153, -19341, -19448,

/* 370 */
5, 1,
 14601,  -4888, -25747,
 14568,  -4993, -25746,
 14427,  -5040, -25816,
 14403,  -4973, -25842,
 14511,  -4900, -25796,

/* 371 */
5, 1,
  3182,  28027,  10215,
  3267,  28052,  10121,
  3204,  28102,  10002,
  3120,  28082,  10082,
  3120,  28037,  10207,

/* 372 */
5, 1,
 24760, -13205, -10611,
 24808, -13122, -10602,
 24903, -12966, -10571,
 24892, -13015, -10537,
 24812, -13138, -10571,

/* 373 */
5, 1,
 22676,   -468, -19636,
 22732,   -514, -19570,
 22714,   -646, -19588,
 22638,   -667, -19674,
 22633,   -508, -19685,

/* 374 */
5, 1,
 -8077,  26065, -12464,
 -8053,  26040, -12533,
 -8030,  25957, -12718,
 -8085,  25964, -12670,
 -8098,  26027, -12530,

/* 375 */
5, 1,
-16783, -24152,   5918,
-16710, -24223,   5833,
-16592, -24312,   5802,
-16622, -24273,   5877,
-16720, -24192,   5930,

/* 376 */
5, 1,
  3471,  29597,   3461,
  3568,  29591,   3416,
  3608,  29605,   3248,
  3528,  29615,   3245,
  3487,  29604,   3383,

/* 377 */
5, 1,
-23913,  14805, -10440,
-23958,  14729, -10443,
-24076,  14600, -10353,
-24045,  14666, -10331,
-23953,  14772, -10394,

/* 378 */
5, 1,
-13537,  24149, -11558,
-13615,  24102, -11564,
-13770,  24029, -11533,
-13751,  24067, -11476,
-13618,  24129, -11503,

/* 379 */
5, 1,
 25723,  -3019, -15140,
 25725,  -3100, -15120,
 25701,  -3299, -15119,
 25688,  -3244, -15152,
 25703,  -3094, -15159,

/* 380 */
5, 1,
 18791,  -8648, -21728,
 18744,  -8620, -21779,
 18643,  -8526, -21903,
 18717,  -8493, -21853,
 18790,  -8572, -21759,

/* 381 */
5, 1,
 -8993, -28620,   -183,
 -8904, -28647,   -233,
 -8756, -28693,   -211,
 -8757, -28693,   -159,
 -8896, -28650,   -131,

/* 382 */
5, 1,
 -8768, -28641,  -1673,
 -8745, -28654,  -1578,
 -8777, -28652,  -1427,
 -8847, -28628,  -1473,
 -8831, -28625,  -1626,

/* 383 */
5, -1,
 16062,    838,  25324,
 16111,    858,  25292,
 16278,    941,  25182,
 16195,    931,  25236,
 16079,    876,  25312,

/* 384 */
5, 1,
-26157,  14015,   4405,
-26187,  13948,   4434,
-26264,  13777,   4517,
-26242,  13824,   4499,
-26185,  13951,   4441,

/* 385 */
5, 1,
 21813,  15801, -13211,
 21811,  15743, -13282,
 21759,  15677, -13446,
 21748,  15724, -13407,
 21774,  15796, -13281,

/* 386 */
5, -1,
-19641,  22184,   4702,
-19717,  22128,   4647,
-19827,  22011,   4732,
-19775,  22051,   4761,
-19697,  22134,   4702,

/* 387 */
5, 1,
 15005,  -1299, -25945,
 14946,  -1352, -25977,
 14822,  -1393, -26046,
 14814,  -1291, -26055,
 14947,  -1268, -25980,

/* 388 */
5, 1,
-10453,  11094, -25839,
-10386,  11051, -25885,
-10387,  10949, -25927,
-10538,  10922, -25878,
-10506,  11030, -25845,

/* 389 */
5, 1,
-26735,  12315,   5795,
-26781,  12233,   5756,
-26818,  12106,   5853,
-26783,  12153,   5915,
-26743,  12273,   5848,

/* 390 */
5, -1,
-16802,  23231,  -8833,
-16821,  23187,  -8911,
-16960,  23063,  -8969,
-16927,  23096,  -8947,
-16826,  23192,  -8889,

/* 391 */
5, 1,
 14422,  -5109, -25805,
 14343,  -5223, -25826,
 14218,  -5259, -25888,
 14275,  -5196, -25869,
 14387,  -5111, -25824,

/* 392 */
5, 1,
 10064,  -5982, -27621,
  9996,  -6042, -27633,
  9837,  -6118, -27673,
  9853,  -6071, -27678,
  9984,  -6001, -27646,

/* 393 */
5, 1,
 24783,  -4317, -16345,
 24789,  -4391, -16317,
 24747,  -4466, -16360,
 24679,  -4341, -16496,
 24735,  -4327, -16415,

/* 394 */
5, 1,
-13180,  26791,   2922,
-13128,  26823,   2864,
-13126,  26839,   2717,
-13216,  26793,   2737,
-13242,  26766,   2870,

/* 395 */
4, 1,
 -1749,  25344,  15957,
 -1843,  25298,  16019,
 -1724,  25220,  16156,
 -1727,  25278,  16063,

/* 396 */
5, 1,
-26328,  14008,  -3259,
-26355,  13942,  -3321,
-26421,  13795,  -3407,
-26407,  13829,  -3380,
-26355,  13947,  -3303,

/* 397 */
4, 1,
 24089,   7261, -16340,
 24137,   7079, -16350,
 24066,   7087, -16451,
 24046,   7223, -16419,

/* 398 */
4, 1,
 -7194,  13999,  25540,
 -7065,  14003,  25573,
 -7046,  14131,  25508,
 -7177,  14118,  25479,

/* 399 */
5, -1,
-24613,  17122,   1025,
-24616,  17111,   1133,
-24647,  17056,   1271,
-24636,  17071,   1274,
-24605,  17125,   1139,

/* 400 */
5, 1,
 20152,  -5943,  21414,
 20130,  -6048,  21406,
 20152,  -6167,  21351,
 20197,  -6130,  21319,
 20191,  -5970,  21371,

/* 401 */
5, 1,
 -1915,  23677, -18322,
 -2006,  23657, -18339,
 -2179,  23660, -18316,
 -2137,  23675, -18301,
 -1995,  23680, -18310,

/* 402 */
5, 1,
-23760,  17289,   6048,
-23713,  17329,   6115,
-23624,  17450,   6118,
-23604,  17477,   6114,
-23716,  17330,   6101,

/* 403 */
5, 1,
-14558,  23775, -11081,
-14543,  23744, -11167,
-14555,  23670, -11309,
-14595,  23665, -11268,
-14591,  23734, -11126,

/* 404 */
5, 1,
-12479,  24643, -11704,
-12534,  24593, -11752,
-12686,  24504, -11774,
-12669,  24530, -11738,
-12549,  24604, -11711,

/* 405 */
4, 1,
  5264,  29534,   -120,
  5346,  29519,   -241,
  5223,  29540,   -301,
  5181,  29549,   -141,

/* 406 */
5, 1,
 13262,  -5908, -26253,
 13197,  -5980, -26269,
 13060,  -6036, -26325,
 13067,  -5982, -26334,
 13198,  -5922, -26282,

/* 407 */
4, 1,
-20288,  22087,    756,
-20269,  22106,    675,
-20387,  22002,    550,
-20358,  22025,    660,

/* 408 */
5, 1,
 19086,  -2847,  22970,
 19124,  -2792,  22945,
 19150,  -2643,  22941,
 19104,  -2610,  22983,
 19082,  -2759,  22984,

/* 409 */
4, 1,
 -2873,  28899,   7523,
 -3006,  28886,   7523,
 -2992,  28856,   7640,
 -2848,  28868,   7650,

/* 410 */
5, 1,
 15596,  18597, -17633,
 15663,  18554, -17619,
 15752,  18439, -17660,
 15707,  18421, -17718,
 15641,  18517, -17677,

/* 411 */
5, -1,
-28925,   7951,    348,
-28916,   7978,    426,
-28881,   8099,    542,
-28882,   8098,    507,
-28906,   8019,    355,

/* 412 */
5, -1,
  9541,  23385,  16190,
  9539,  23335,  16263,
  9618,  23226,  16371,
  9637,  23245,  16333,
  9584,  23342,  16226,

/* 413 */
5, 1,
 29210,    473,  -6823,
 29225,    550,  -6751,
 29256,    585,  -6613,
 29254,    529,  -6626,
 29224,    461,  -6764,

/* 414 */
5, 1,
-25829,  15180,   1561,
-25833,  15182,   1475,
-25856,  15158,   1300,
-25855,  15158,   1331,
-25835,  15177,   1479,

/* 415 */
5, 1,
-20000,  22355,    530,
-20025,  22333,    455,
-20094,  22274,    312,
-20109,  22260,    359,
-20045,  22315,    482,

/* 416 */
4, 1,
  -444, -28368,   9750,
  -392, -28333,   9853,
  -553, -28311,   9907,
  -531, -28358,   9775,

/* 417 */
4, 1,
  2286,  29384,   5600,
  2178,  29406,   5527,
  2114,  29387,   5651,
  2212,  29368,   5710,

/* 418 */
4, 1,
 -9750,  11346, -26004,
 -9636,  11283, -26074,
 -9729,  11192, -26078,
 -9817,  11257, -26018,

/* 419 */
4, 1,
 29357,   1075,  -6086,
 29383,   1063,  -5961,
 29386,    930,  -5968,
 29361,    950,  -6086,

/* 420 */
5, 1,
 -4180,  -7285, -28800,
 -4276,  -7279, -28788,
 -4264,  -7212, -28806,
 -4091,  -7177, -28840,
 -4112,  -7256, -28817,

/* 421 */
4, 1,
 21812,  -2819, -20403,
 21855,  -3035, -20326,
 21825,  -2974, -20367,
 21786,  -2842, -20427,

/* 422 */
4, 1,
 -6475,  29293,   -129,
 -6612,  29262,    -75,
 -6578,  29270,     27,
 -6448,  29299,    -30,

/* 423 */
4, 1,
 -9851, -28219,   2574,
 -9871, -28201,   2699,
 -9994, -28163,   2638,
 -9940, -28192,   2525,

/* 424 */
4, 1,
  6163, -10670, -27353,
  6247, -10640, -27345,
  6239, -10762, -27299,
  6109, -10797, -27315,

/* 425 */
5, 1,
 24033,  10600,  14493,
 24032,  10539,  14540,
 24028,  10423,  14630,
 24057,  10407,  14593,
 24056,  10526,  14509,

/* 426 */
4, 1,
-10404,  28061,   2080,
-10572,  28003,   2015,
-10557,  28003,   2098,
-10408,  28055,   2142,

/* 427 */
4, -1,
 -6287,  25435, -14613,
 -6462,  25370, -14650,
 -6495,  25390, -14600,
 -6386,  25444, -14554,

/* 428 */
4, 1,
  3313,  24533,  16946,
  3385,  24479,  17010,
  3522,  24487,  16969,
  3439,  24536,  16917,

/* 429 */
5, 1,
-17749,  22168,   9672,
-17804,  22146,   9621,
-17938,  22062,   9566,
-17903,  22076,   9599,
-17793,  22145,   9644,

/* 430 */
4, 1,
-24211,  14614, -10014,
-24256,  14513, -10051,
-24317,  14469,  -9967,
-24240,  14620,  -9934,

/* 431 */
5, 1,
  6168,  20534,  20984,
  6246,  20515,  20979,
  6401,  20506,  20942,
  6387,  20517,  20935,
  6239,  20536,  20960,

/* 432 */
4, 1,
 25249,   3517, -15816,
 25303,   3462, -15741,
 25271,   3358, -15814,
 25210,   3456, -15891,

/* 433 */
5, 1,
 24510,   6812, -15901,
 24507,   6742, -15936,
 24460,   6643, -16049,
 24453,   6659, -16053,
 24485,   6769, -15959,

/* 434 */
4, 1,
  8900,  28579,   2013,
  8872,  28597,   1868,
  8774,  28626,   1885,
  8822,  28603,   2014,

/* 435 */
4, 1,
-19110, -22514,   5287,
-19244, -22402,   5271,
-19210, -22449,   5198,
-19133, -22517,   5191,

/* 436 */
4, 1,
-26431,  12476,   6763,
-26484,  12303,   6875,
-26463,  12328,   6907,
-26435,  12448,   6801,

/* 437 */
4, 1,
 -6923,  29146,  -1603,
 -6934,  29136,  -1738,
 -7020,  29115,  -1739,
 -7008,  29127,  -1586,

/* 438 */
4, 1,
 -7322,  29032,  -1885,
 -7415,  29003,  -1956,
 -7499,  28987,  -1872,
 -7383,  29021,  -1818,

/* 439 */
4, 1,
  3874,  29626,   2697,
  4032,  29612,   2626,
  3970,  29623,   2587,
  3830,  29635,   2662,

/* 440 */
5, -1,
-20399, -10562,  19296,
-20446, -10508,  19275,
-20549, -10426,  19211,
-20545, -10458,  19198,
-20473, -10519,  19241,

/* 441 */
4, 1,
-12040, -26645,   6714,
-11949, -26652,   6846,
-12006, -26618,   6881,
-12085, -26621,   6730,

/* 442 */
4, 1,
 -8141,  28851,  -1154,
 -8185,  28832,  -1303,
 -8252,  28814,  -1284,
 -8206,  28833,  -1135,

/* 443 */
4, 1,
-26611,  11542,   7659,
-26699,  11385,   7586,
-26673,  11408,   7644,
-26603,  11533,   7698,

/* 444 */
4, 1,
-25420,   7629,  13987,
-25396,   7510,  14095,
-25357,   7594,  14119,
-25378,   7674,  14038,

/* 445 */
4, 1,
  -361,  26098,  14791,
  -371,  26034,  14902,
  -317,  26006,  14952,
  -291,  26088,  14810,

/* 446 */
4, 1,
-10298,  18382,  21356,
-10168,  18355,  21441,
-10119,  18401,  21425,
-10266,  18414,  21344,

/* 447 */
4, 1,
 -6714,  29188,  -1727,
 -6808,  29164,  -1756,
 -6881,  29154,  -1648,
 -6767,  29180,  -1655,

/* 448 */
4, 1,
-14486,  -9145, -24628,
-14593,  -9168, -24556,
-14593,  -9096, -24583,
-14489,  -9056, -24659,

/* 449 */
3, 1,
-12116,  27417,   1220,
-12261,  27347,   1354,
-12188,  27380,   1337,

/* 450 */
4, 1,
 12149, -27337,  -2254,
 12141, -27334,  -2336,
 12232, -27288,  -2395,
 12218, -27307,  -2242,

/* 451 */
3, 1,
  4304,  29609,   2188,
  4256,  29629,   2003,
  4218,  29626,   2127,

/* 452 */
4, 1,
-12276,  24972, -11211,
-12280,  24929, -11301,
-12410,  24872, -11286,
-12336,  24932, -11236,

/* 453 */
4, 1,
  3993,  24360,  17048,
  4099,  24362,  17021,
  4044,  24442,  16919,
  3988,  24414,  16972,

/* 454 */
4, 1,
  4361,  29555,   2736,
  4323,  29569,   2645,
  4207,  29585,   2647,
  4282,  29565,   2748,

/* 455 */
4, 1,
-18479, -23127,   4866,
-18531, -23060,   4984,
-18592, -23025,   4918,
-18533, -23087,   4847,

/* 456 */
4, -1,
  2259,  21690,  20602,
  2422,  21730,  20541,
  2371,  21760,  20515,
  2252,  21712,  20579,

/* 457 */
4, 1,
 20331,  14288, -16807,
 20444,  14226, -16723,
 20446,  14175, -16764,
 20330,  14262, -16831,

/* 458 */
4, 1,
-16786, -24244,   5517,
-16799, -24258,   5419,
-16684, -24335,   5429,
-16720, -24294,   5499,

/* 459 */
4, 1,
 -1657,  25010,  16486,
 -1764,  25041,  16427,
 -1791,  24982,  16513,
 -1685,  24973,  16538,

/* 460 */
4, 1,
 -1331, -20857, -21523,
 -1363, -20770, -21604,
 -1351, -20739, -21635,
 -1257, -20781, -21600,

/* 461 */
3, 1,
-26552,   5728,  12735,
-26466,   5718,  12917,
-26507,   5748,  12819,

/* 462 */
3, 1,
-11118,  27856,    637,
-11288,  27788,    642,
-11206,  27820,    705,

/* 463 */
4, 1,
  2831, -28218,   9783,
  2873, -28191,   9850,
  2774, -28176,   9920,
  2755, -28216,   9812,

/* 464 */
3, 1,
 23950,   2362, -17911,
 23970,   2183, -17907,
 23926,   2265, -17956,

/* 465 */
3, 1,
 29304,    688,  -6390,
 29307,    537,  -6387,
 29289,    555,  -6469,

/* 466 */
3, 1,
 -9197, -28136,   4878,
 -9356, -28068,   4963,
 -9281, -28105,   4899,

/* 467 */
4, 1,
-10259,  28140,   1705,
-10315,  28115,   1768,
-10253,  28132,   1869,
-10219,  28149,   1793,

/* 468 */
3, 1,
 29280,    766,  -6487,
 29314,    808,  -6329,
 29291,    712,  -6445,

/* 469 */
4, 1,
  6865,  26520,  12229,
  6827,  26505,  12283,
  6870,  26449,  12379,
  6920,  26480,  12286,

/* 470 */
3, 1,
 13499, -19327, -18554,
 13544, -19192, -18661,
 13557, -19272, -18568,

/* 471 */
3, -1,
 16732,   5918,  24187,
 16609,   6049,  24240,
 16659,   5965,  24226,

/* 472 */
3, 1,
 13670,  -4696, -26288,
 13524,  -4767, -26351,
 13584,  -4682, -26336,

/* 473 */
3, 1,
  2313,  23926, -17950,
  2152,  23910, -17991,
  2232,  23957, -17919,

/* 474 */
3, 1,
  3781,  28274,   9290,
  3874,  28308,   9144,
  3783,  28302,   9202,

/* 475 */
3, 1,
 25584,   3122, -15352,
 25499,   3096, -15499,
 25516,   3155, -15460,

/* 476 */
3, 1,
 29702,   3744,  -1936,
 29719,   3591,  -1971,
 29704,   3680,  -2026,

/* 477 */
3, 1,
 24789,   6574, -15566,
 24854,   6405, -15532,
 24802,   6507, -15572,

/* 478 */
3, -1,
-29247,   6430,   1802,
-29258,   6345,   1924,
-29241,   6417,   1947,

/* 479 */
3, 1,
 -6095,  14636,  25468,
 -6230,  14541,  25490,
 -6133,  14548,  25510,

/* 480 */
3, 1,
-10821,  10826, -25801,
-10988,  10803, -25740,
-10923,  10844, -25751,

/* 481 */
3, 1,
 29023,    590,  -7570,
 29057,    585,  -7441,
 29038,    490,  -7520,

/* 482 */
3, 1,
 23976,   5439, -17192,
 24015,   5262, -17193,
 23982,   5349, -17211,

/* 483 */
4, 1,
  5247,  29038,  -5412,
  5148,  29074,  -5312,
  5174,  29074,  -5284,
  5271,  29042,  -5365,

/* 484 */
4, 1,
-18202, -23335,   4919,
-18187, -23330,   4992,
-18249, -23268,   5060,
-18247, -23290,   4960,

/* 485 */
3, 1,
  5756,  -9056, -28015,
  5813,  -9140, -27976,
  5683,  -9150, -27999,

/* 486 */
3, 1,
-11472, -27071,   5962,
-11561, -27004,   6094,
-11547, -27029,   6008,

/* 487 */
3, 1,
-12893,  26395,   6088,
-12940,  26398,   5975,
-12990,  26348,   6087,

/* 488 */
3, 1,
  5886,  -8242, -28239,
  5912,  -8076, -28281,
  5936,  -8143, -28257,

/* 489 */
4, 1,
  8245,  18657,  21999,
  8220,  18598,  22058,
  8293,  18532,  22086,
  8295,  18602,  22026,

/* 490 */
3, 1,
  5232,  21275,  20494,
  5290,  21152,  20606,
  5277,  21221,  20538,

/* 491 */
4, 1,
-16253, -24546,   5776,
-16262, -24567,   5656,
-16186, -24610,   5689,
-16198, -24587,   5751,

/* 492 */
3, -1,
  9502,  25942,  11694,
  9667,  25877,  11702,
  9592,  25912,  11687,

/* 493 */
3, 1,
-12159,  27406,   1045,
-12300,  27340,   1104,
-12212,  27379,   1116,

/* 494 */
3, 1,
  5425,  21100,  20624,
  5560,  21006,  20684,
  5490,  21064,  20644,

/* 495 */
3, -1,
  3389,  22127,  19973,
  3245,  22196,  19920,
  3273,  22154,  19962,

/* 496 */
3, 1,
-29998,   -271,   -211,
-29997,   -374,   -238,
-29998,   -330,   -114,

/* 497 */
3, 1,
 -6646,   3953,  28986,
 -6492,   3918,  29026,
 -6558,   3982,  29003,

/* 498 */
3, 1,
 17776,  -4397, -23763,
 17651,  -4491, -23839,
 17710,  -4430, -23806,

/* 499 */
3, 1,
 15919,  -2901, -25262,
 15833,  -3014, -25303,
 15835,  -2911, -25313,

/* 500 */
3, 1,
 10276,  18702,  21087,
 10310,  18587,  21171,
 10359,  18635,  21106,

/* 501 */
3, 1,
-27182,   9729,   8156,
-27158,   9666,   8308,
-27158,   9737,   8225,

/* 502 */
3, 1,
 -5062,  29557,   -877,
 -5213,  29531,   -862,
 -5111,  29550,   -815,

/* 503 */
3, 1,
  5323,  -9639, -27906,
  5417,  -9646, -27886,
  5302,  -9737, -27876,

/* 504 */
3, 1,
  9566,  21962, -18060,
  9646,  21902, -18090,
  9500,  21989, -18062,

/* 505 */
3, 1,
  7782,  19198,  21700,
  7880,  19084,  21765,
  7857,  19158,  21708,

/* 506 */
3, 1,
-25374,   8277,  13699,
-25337,   8409,  13687,
-25385,   8366,  13624,

/* 507 */
3, 1,
-21077,  21320,   1096,
-21183,  21219,   1014,
-21130,  21269,   1084,

/* 508 */
3, 1,
 24281,  -1036, -17589,
 24260,  -1202, -17607,
 24259,  -1106, -17615,

/* 509 */
3, 1,
-22788,     37,  19512,
-22873,    -15,  19412,
-22790,    -35,  19509,

/* 510 */
3, 1,
  5240,  28832,  -6422,
  5171,  28868,  -6319,
  5290,  28837,  -6358,

/* 511 */
3, 1,
 -7468, -28825,  -3652,
 -7341, -28848,  -3725,
 -7367, -28853,  -3642,

/* 512 */
3, 1,
 24788,   6981, -15389,
 24760,   6890, -15474,
 24733,   7001, -15468,

/* 513 */
3, 1,
-23208,     -6,  19010,
-23288,    -88,  18912,
-23214,    -74,  19003,

/* 514 */
3, 1,
 -2403,  29024,   7200,
 -2397,  28986,   7353,
 -2360,  29012,   7263,

/* 515 */
3, 1,
 -8354,  27070,   9869,
 -8323,  27133,   9722,
 -8362,  27102,   9775,

/* 516 */
3, 1,
 25819,   2792, -15019,
 25887,   2702, -14919,
 25831,   2718, -15012,

/* 517 */
3, 1,
-13037,  26839,   3117,
-13001,  26872,   2978,
-13072,  26830,   3050,

/* 518 */
3, 1,
 19424,  15377, -16920,
 19517,  15245, -16932,
 19453,  15309, -16947,

/* 519 */
3, 1,
 25368,  -2667, -15790,
 25352,  -2805, -15793,
 25327,  -2723, -15847,

/* 520 */
3, 1,
-27385,   6432,  10424,
-27368,   6315,  10540,
-27374,   6382,  10485,

/* 521 */
3, 1,
-16689, -24298,   5573,
-16589, -24353,   5632,
-16633, -24311,   5683,

/* 522 */
3, 1,
  7818,  28361,   5876,
  7674,  28412,   5820,
  7742,  28383,   5870,

/* 523 */
3, 1,
 -1083,  23630, -18452,
 -1033,  23552, -18554,
 -1125,  23582, -18510,

/* 524 */
3, 1,
 25414,   6393, -14604,
 25373,   6287, -14720,
 25384,   6357, -14672,

/* 525 */
3, 1,
-11631,    906, -27639,
-11511,    997, -27686,
-11560,    917, -27668,

/* 526 */
3, 1,
  3474,    212,  29797,
  3415,     89,  29805,
  3513,    139,  29793,

/* 527 */
3, 1,
  2829,  27930,  10580,
  2846,  27978,  10446,
  2777,  27958,  10519,

/* 528 */
3, 1,
-18229, -23261,   5161,
-18349, -23176,   5118,
-18270, -23241,   5106,

/* 529 */
3, 1,
  1852,  23822,  18140,
  1727,  23778,  18210,
  1828,  23780,  18198,

/* 530 */
3, 1,
 17469,  17022, -17466,
 17585,  16916, -17454,
 17523,  16949, -17484,

/* 531 */
3, 1,
-13668,  26130,   5512,
-13785,  26072,   5496,
-13724,  26088,   5575,

/* 532 */
3, 1,
-16825,  22385, -10761,
-16894,  22325, -10779,
-16778,  22432, -10738,

/* 533 */
3, 1,
-17801, -23670,   4779,
-17908, -23575,   4850,
-17869, -23615,   4798,

/* 534 */
3, -1,
-16972,  24643,  -2166,
-17022,  24596,  -2304,
-17028,  24599,  -2226,

/* 535 */
3, 1,
-29510,  -1408,   5213,
-29525,  -1510,   5096,
-29513,  -1487,   5175,

/* 536 */
3, 1,
 -8023,  14394,  25068,
 -8091,  14428,  25028,
 -8076,  14312,  25099,

/* 537 */
3, 1,
 18663,   8080,  22054,
 18588,   8173,  22084,
 18557,   8137,  22123,

/* 538 */
3, 1,
 20234,  -5953, -21335,
 20185,  -5823, -21416,
 20216,  -5880, -21371,

/* 539 */
3, 1,
  9465,  -4873, -28048,
  9403,  -5018, -28043,
  9413,  -4932, -28055,

/* 540 */
3, 1,
 11849,  -3988, -27271,
 11770,  -4094, -27289,
 11767,  -3994, -27305,

/* 541 */
3, 1,
 19173,   8661,  21387,
 19234,   8622,  21348,
 19118,   8709,  21417,

/* 542 */
3, 1,
-25383,   8079,  13799,
-25391,   7950,  13860,
-25359,   8044,  13865,

/* 543 */
3, 1,
  -947,  23612, -18482,
  -828,  23562, -18551,
  -907,  23559, -18551,

/* 544 */
3, 1,
-20303, -21276,   5923,
-20379, -21235,   5813,
-20315, -21291,   5831,

/* 545 */
3, 1,
 -3266,  29707,   2611,
 -3229,  29723,   2473,
 -3294,  29712,   2520,

/* 546 */
3, 1,
 29437,   5643,  -1268,
 29461,   5529,  -1224,
 29455,   5538,  -1306,

/* 547 */
3, 1,
  5941,  -8348, -28196,
  5974,  -8425, -28166,
  5856,  -8419, -28193,

/* 548 */
3, 1,
  8674,  28665,   1747,
  8737,  28650,   1683,
  8635,  28683,   1642,

/* 549 */
3, 1,
 12119, -27290,  -2892,
 12251, -27236,  -2846,
 12183, -27269,  -2830,

/* 550 */
3, 1,
 16774,   7079, -23844,
 16856,   6955, -23822,
 16783,   7009, -23858,

/* 551 */
3, 1,
 20757,  13260,  17126,
 20820,  13132,  17148,
 20807,  13220,  17097,

/* 552 */
3, 1,
-23106,    319,  19132,
-23120,    166,  19116,
-23097,    241,  19143,

/* 553 */
3, 1,
 28708,   8390,  -2334,
 28749,   8273,  -2247,
 28731,   8314,  -2321,

/* 554 */
3, -1,
-17143,  22854,  -9157,
-17199,  22805,  -9172,
-17088,  22907,  -9125,

/* 555 */
3, 1,
 24593,  -4420, -16602,
 24535,  -4339, -16710,
 24577,  -4340, -16647,

/* 556 */
3, 1,
 -5670,  29343,  -2618,
 -5794,  29319,  -2618,
 -5724,  29338,  -2549,

/* 557 */
3, 1,
 29384,   4265,  -4286,
 29403,   4123,  -4297,
 29387,   4196,  -4338,

/* 558 */
3, -1,
-26493,  13413,  -4266,
-26420,  13542,  -4314,
-26461,  13463,  -4305,

/* 559 */
3, 1,
-12215,   8751,  25965,
-12165,   8841,  25959,
-12275,   8798,  25921,

/* 560 */
3, 1,
   942,  -9821, -28331,
   815,  -9781, -28349,
   833,  -9745, -28361,

/* 561 */
3, 1,
  5791, -10962, -27318,
  5863, -11003, -27287,
  5762, -11059, -27286,

/* 562 */
3, 1,
-16110, -24557,   6118,
-16165, -24556,   5978,
-16113, -24571,   6055,

/* 563 */
3, 1,
 24603,   7780, -15303,
 24622,   7650, -15338,
 24581,   7731, -15363,

/* 564 */
3, 1,
-11587,   7787,  26554,
-11664,   7865,  26497,
-11661,   7765,  26528,

/* 565 */
3, -1,
-16566,  24953,  -1701,
-16600,  24921,  -1840,
-16615,  24916,  -1768,

/* 566 */
3, 1,
-10538,  27951,   2769,
-10651,  27901,   2840,
-10569,  27933,   2838,

/* 567 */
3, 1,
-26227,  14265,  -2946,
-26256,  14184,  -3072,
-26248,  14216,  -2996,

/* 568 */
3, 1,
-29996,   -410,    275,
-29995,   -474,    271,
-29995,   -378,    373,

/* 569 */
3, 1,
 -1328,  24397,  17407,
 -1416,  24329,  17495,
 -1337,  24351,  17471,

/* 570 */
3, 1,
 28640,   5411,  -7103,
 28656,   5287,  -7133,
 28631,   5368,  -7174,

/* 571 */
3, 1,
  2879,  27986,  10415,
  2923,  28031,  10282,
  2875,  28017,  10334,

/* 572 */
3, 1,
-10402, -26170,  10341,
-10542, -26130,  10301,
-10478, -26154,  10305,

/* 573 */
3, 1,
-10281,  28087,   2329,
-10387,  28045,   2363,
-10309,  28069,   2413,

/* 574 */
3, 1,
  2742,  27846,  10820,
  2827,  27881,  10709,
  2757,  27874,  10743,

/* 575 */
3, 1,
 -3438, -29243,  -5748,
 -3395, -29223,  -5873,
 -3366, -29241,  -5797,

/* 576 */
3, 1,
-26723,  12841,   4584,
-26789,  12731,   4504,
-26760,  12774,   4551,

/* 577 */
3, 1,
 -1401,  24087,  17828,
 -1402,  24027,  17909,
 -1313,  24053,  17881,

/* 578 */
3, 1,
  5935,  -7944, -28314,
  5950,  -7799, -28351,
  5961,  -7846, -28336,

/* 579 */
3, 1,
 22691,   -404, -19620,
 22781,   -444, -19515,
 22707,   -444, -19601,

/* 580 */
3, 1,
  -615,  23609, -18500,
  -642,  23547, -18578,
  -715,  23572, -18544,

/* 581 */
3, 1,
 -7610,  27327,   9765,
 -7524,  27336,   9804,
 -7513,  27370,   9719,

/* 582 */
3, 1,
  3275,  28106,   9967,
  3341,  28140,   9847,
  3275,  28132,   9893,

/* 583 */
3, 1,
 -1798,  26125, -14637,
 -1923,  26078, -14706,
 -1863,  26103, -14669,

/* 584 */
3, 1,
  3404,  28154,   9786,
  3420,  28188,   9682,
  3337,  28185,   9720,

/* 585 */
3, 1,
-19236, -22431,   5182,
-19331, -22350,   5178,
-19290, -22398,   5119,

/* 586 */
3, 1,
 16386,  -1104,  25106,
 16313,  -1022,  25156,
 16289,  -1074,  25170,

/* 587 */
3, 1,
 19553,  -4260, -22350,
 19616,  -4311, -22285,
 19547,  -4355, -22337,

/* 588 */
3, 1,
-22905,  18425,   5990,
-22809,  18529,   6037,
-22842,  18494,   6019,

/* 589 */
3, 1,
-12241,  25010, -11164,
-12358,  24940, -11192,
-12316,  24982, -11146,

/* 590 */
3, 1,
 -6089, -28902,  -5253,
 -6055, -28888,  -5370,
 -6012, -28910,  -5299,

/* 591 */
3, 1,
 14736,  -4824, -25682,
 14693,  -4930, -25687,
 14653,  -4867, -25721,

/* 592 */
3, 1,
 19044,  17073, -15679,
 19138,  16965, -15682,
 19074,  17019, -15701,

/* 593 */
3, 1,
-16277,  25021,   3001,
-16379,  24963,   2923,
-16347,  24978,   2982,

/* 594 */
3, 1,
  3248,  24619,  16833,
  3210,  24543,  16951,
  3241,  24575,  16899,

/* 595 */
3, 1,
-19337, -22287,   5420,
-19319, -22272,   5542,
-19373, -22247,   5453,

/* 596 */
3, 1,
  3510,  24558,  16869,
  3557,  24490,  16958,
  3593,  24526,  16899,

/* 597 */
3, 1,
 -6842,  29209,    -35,
 -6965,  29180,    -20,
 -6900,  29196,     25,

/* 598 */
3, 1,
-15937,  22907, -11013,
-16056,  22845, -10969,
-16001,  22884, -10968,

/* 599 */
3, 1,
 27779,  11315,   -526,
 27730,  11436,   -549,
 27739,  11414,   -505,

/* 600 */
3, 1,
-12034,  25103, -11183,
-12097,  25045, -11243,
-12138,  25050, -11188,

/* 601 */
3, 1,
 11603,  -4113, -27358,
 11589,  -4216, -27348,
 11525,  -4163, -27383,

/* 602 */
3, 1,
 12813,  -2626, -26999,
 12809,  -2758, -26987,
 12773,  -2687, -27012,

/* 603 */
3, 1,
-25308,   8431,  13728,
-25270,   8388,  13823,
-25269,   8477,  13771,

/* 604 */
3, 1,
-25475,   7114,  14157,
-25444,   7234,  14152,
-25486,   7172,  14107,

/* 605 */
3, 1,
 13199, -12085, -24077,
 13269, -11977, -24093,
 13274, -12037, -24061,

/* 606 */
3, 1,
-14219,  23894, -11265,
-14304,  23809, -11338,
-14278,  23849, -11286,

/* 607 */
3, 1,
  4551, -23163, -18514,
  4580, -23240, -18410,
  4531, -23215, -18454,

/* 608 */
3, 1,
  5199,  -9999, -27803,
  5274,  -9989, -27792,
  5195, -10081, -27774,

/* 609 */
3, 1,
 -3465, -29255,  -5667,
 -3515, -29268,  -5572,
 -3541, -29246,  -5667,

/* 610 */
3, 1,
 20448,  -6320,  21022,
 20522,  -6372,  20935,
 20511,  -6309,  20964,

/* 611 */
3, 1,
-11210, -27380,   4968,
-11277, -27333,   5074,
-11270, -27348,   5004,

/* 612 */
3, 1,
 -7114,  29104,  -1523,
 -7145,  29090,  -1648,
 -7171,  29087,  -1587,

/* 613 */
3, 1,
 11126,  17559,  21631,
 11134,  17448,  21717,
 11138,  17492,  21679,

/* 614 */
3, -1,
-17516,  22482,  -9368,
-17553,  22438,  -9404,
-17476,  22529,  -9329,

/* 615 */
3, 1,
 23571,  -1939, -18457,
 23503,  -1905, -18547,
 23540,  -1864, -18504,

/* 616 */
3, 1,
 -6394, -28910,  -4832,
 -6421, -28885,  -4944,
 -6353, -28909,  -4893,

/* 617 */
3, 1,
  5794,  26057,  13692,
  5738,  26012,  13800,
  5796,  26020,  13762,

/* 618 */
3, 1,
-23934,  17129,   5813,
-23966,  17093,   5783,
-23887,  17178,   5861,

/* 619 */
3, 1,
-23357,    -76,  18827,
-23413,   -173,  18756,
-23372,   -148,  18808,

/* 620 */
3, 1,
  7231,  -5628, -28566,
  7114,  -5606, -28600,
  7178,  -5572, -28591,

/* 621 */
3, -1,
  8011,  -2165,  28829,
  7925,  -2185,  28852,
  7967,  -2257,  28835,

/* 622 */
3, 1,
-17637, -23714,   5158,
-17745, -23644,   5107,
-17695, -23678,   5120,

/* 623 */
3, 1,
 21913,  -8820,  18494,
 21979,  -8702,  18471,
 21945,  -8748,  18491,

/* 624 */
3, 1,
  9869,  19293,  20746,
  9784,  19255,  20821,
  9839,  19231,  20817,

/* 625 */
3, 1,
 22899,  -4077, -18947,
 22873,  -4163, -18960,
 22836,  -4111, -19017,

/* 626 */
3, 1,
-14038,  23901, -11476,
-14145,  23829, -11493,
-14110,  23868, -11455,

/* 627 */
3, 1,
  4353,  24653,  16531,
  4422,  24592,  16603,
  4434,  24633,  16540,

/* 628 */
3, 1,
-18051, -23470,   4832,
-18081, -23422,   4950,
-18091, -23428,   4883,

/* 629 */
3, 1,
 28220,  10019,  -1806,
 28243,   9937,  -1889,
 28218,  10009,  -1886,

/* 630 */
3, 1,
-20490, -21140,   5764,
-20495, -21108,   5864,
-20539, -21089,   5779,

/* 631 */
3, 1,
  3983,  28240,   9309,
  3995,  28275,   9196,
  3943,  28269,   9236,

/* 632 */
3, 1,
-18699, -22936,   4930,
-18790, -22869,   4897,
-18753, -22906,   4861,

/* 633 */
3, 1,
   627,  18932,  23264,
   543,  18870,  23316,
   628,  18877,  23308,

/* 634 */
3, 1,
 19354,  14991,  17340,
 19404,  14893,  17368,
 19418,  14939,  17313,

/* 635 */
3, 1,
-28747,   8411,   1693,
-28725,   8461,   1814,
-28730,   8457,   1755,

/* 636 */
3, 1,
 -8901,  26791,  10151,
 -8903,  26830,  10046,
 -8944,  26816,  10046,

/* 637 */
3, 1,
 -1847,  24835,  16728,
 -1874,  24782,  16803,
 -1790,  24801,  16784,

/* 638 */
3, 1,
-10396,  25971,  10836,
-10312,  25983,  10887,
-10357,  26004,  10794,

/* 639 */
3, 1,
 -1746,  26561,  13836,
 -1700,  26507,  13946,
 -1696,  26534,  13896,

/* 640 */
3, -1,
-16548,  24985,  -1391,
-16518,  24997,  -1514,
-16558,  24974,  -1470,

/* 641 */
3, 1,
-23092,   1143,  19117,
-23121,   1046,  19087,
-23072,   1066,  19145,

/* 642 */
3, -1,
 -9616,  27575,  -6867,
 -9702,  27557,  -6819,
 -9621,  27592,  -6791,

/* 643 */
3, 1,
    37,  -8773, -28689,
   -46,  -8684, -28716,
    24,  -8708, -28708,

/* 644 */
3, 1,
 -5877,  24660, -16042,
 -5848,  24597, -16149,
 -5889,  24616, -16106,

/* 645 */
3, 1,
 -7063,  29124,   1383,
 -7169,  29100,   1337,
 -7157,  29101,   1387,

/* 646 */
3, 1,
  9491, -28294,   3062,
  9579, -28259,   3111,
  9551, -28264,   3151,

/* 647 */
3, 1,
-10563,  28011,  -1955,
-10655,  27974,  -1986,
-10653,  27979,  -1924,

/* 648 */
3, 1,
-23006,    339,  19251,
-23057,    259,  19192,
-23005,    265,  19253,

/* 649 */
3, -1,
 24368,  17193,  -3258,
 24408,  17126,  -3310,
 24354,  17197,  -3335,

/* 650 */
3, 1,
 -8017,  28176,   6466,
 -8104,  28140,   6518,
 -8032,  28155,   6542,

/* 651 */
3, 1,
-26550,  11424,   8038,
-26521,  11404,   8159,
-26522,  11440,   8106,

/* 652 */
3, 1,
 28996,   6412,  -4254,
 28967,   6524,  -4285,
 28980,   6495,  -4237,

/* 653 */
3, 1,
-11839,   8554,  26204,
-11778,   8581,  26223,
-11885,   8599,  26169,

/* 654 */
3, 1,
-20098, -21617,   5362,
-20129, -21564,   5463,
-20147, -21562,   5405,

/* 655 */
3, 1,
 21155,   4033, -20886,
 21195,   3916, -20867,
 21160,   3950, -20896,

/* 656 */
3, 1,
  5515,  20897,  20806,
  5618,  20829,  20847,
  5581,  20864,  20822,

/* 657 */
3, 1,
-29988,   -222,   -832,
-29990,   -172,   -771,
-29987,   -150,   -871,

/* 658 */
3, 1,
  5034,  26084,  13938,
  5055,  26035,  14022,
  5109,  26045,  13984,

/* 659 */
3, 1,
  1691,  19298,  22907,
  1602,  19301,  22911,
  1683,  19247,  22951,

/* 660 */
3, 1,
  2119,  26865,  13182,
  2003,  26862,  13207,
  2061,  26846,  13231,

/* 661 */
3, 1,
 10789,  18377,  21116,
 10686,  18371,  21174,
 10748,  18342,  21167,

/* 662 */
3, 1,
-11870, -26301,   8207,
-11843, -26282,   8308,
-11908, -26268,   8257,

/* 663 */
3, 1,
-18344, -23246,   4807,
-18428, -23172,   4845,
-18401, -23206,   4787,

/* 664 */
3, 1,
-11295,  25251, -11610,
-11360,  25193, -11673,
-11375,  25214, -11613,

/* 665 */
3, 1,
  6300,  20443,  21033,
  6423,  20429,  21010,
  6387,  20448,  21002,

/* 666 */
3, 1,
 29102,    725,  -7249,
 29129,    728,  -7138,
 29118,    683,  -7190,

/* 667 */
3, 1,
-29997,   -152,   -412,
-29998,   -130,   -330,
-29997,    -78,   -415,

/* 668 */
3, 1,
-28040,  10545,   1595,
-28072,  10474,   1501,
-28068,  10478,   1556,

/* 669 */
3, 1,
 11026,  18001,  21316,
 10929,  17970,  21392,
 10976,  17971,  21368,

/* 670 */
3, 1,
 24332,   1794, -17457,
 24364,   1895, -17401,
 24365,   1826, -17407,

/* 671 */
3, 1,
  4781,  16690,  24466,
  4685,  16710,  24471,
  4717,  16651,  24505,

/* 672 */
3, 1,
 21656,  -5891, -19908,
 21677,  -5775, -19919,
 21693,  -5813, -19891,

/* 673 */
3, 1,
-19012, -22658,   5013,
-19095, -22601,   4959,
-19054, -22639,   4944,

/* 674 */
3, -1,
-25345,  15903,   2173,
-25412,  15797,   2170,
-25397,  15818,   2184,

/* 675 */
3, 1,
 22404,  -4219, -19500,
 22448,  -4297, -19432,
 22396,  -4274, -19498,

/* 676 */
3, 1,
-10163,  28146,   2130,
-10252,  28117,   2078,
-10231,  28120,   2147,

/* 677 */
3, 1,
  -725,  25703,  15454,
  -832,  25722,  15417,
  -809,  25697,  15461,

/* 678 */
3, 1,
 25446,   6214, -14625,
 25448,   6119, -14661,
 25420,   6157, -14694,

/* 679 */
3, 1,
-18014, -23519,   4728,
-18082, -23452,   4803,
-18070, -23470,   4757,

/* 680 */
3, 1,
  8350,  18419,  22159,
  8436,  18352,  22182,
  8428,  18397,  22148,

/* 681 */
3, 1,
-16265,  24998,   3250,
-16354,  24943,   3223,
-16343,  24945,   3268,

/* 682 */
3, 1,
-29435,   3954,   4235,
-29442,   3852,   4278,
-29432,   3910,   4298,

/* 683 */
3, 1,
 14345,  -4396, -25979,
 14343,  -4516, -25959,
 14326,  -4471, -25976,

/* 684 */
3, 1,
-20159, -21497,   5615,
-20206, -21434,   5683,
-20217, -21441,   5619,

/* 685 */
3, 1,
 17291, -23956,   5209,
 17268, -23996,   5100,
 17301, -23964,   5141,

/* 686 */
3, 1,
  6171,  20591,  20926,
  6279,  20567,  20918,
  6254,  20600,  20893,

/* 687 */
3, 1,
 -8736, -28700,    -52,
 -8770, -28689,     40,
 -8808, -28678,    -12,

/* 688 */
3, 1,
 -5134,  25663, -14664,
 -5071,  25629, -14746,
 -5121,  25622, -14741,

/* 689 */
3, 1,
 23474,  -4238, -18194,
 23403,  -4284, -18274,
 23424,  -4241, -18258,

/* 690 */
3, 1,
-12945,  26676,   4562,
-12941,  26693,   4471,
-12992,  26655,   4551,

/* 691 */
3, 1,
 11880, -13958, -23749,
 11878, -13859, -23809,
 11905, -13887, -23778,

/* 692 */
3, 1,
  9893,  18457,  21482,
  9960,  18385,  21512,
  9977,  18416,  21478,

/* 693 */
3, 1,
-14530,  23658, -11366,
-14565,  23598, -11446,
-14588,  23609, -11393,

/* 694 */
3, 1,
-17616, -23753,   5046,
-17709, -23692,   5009,
-17676, -23719,   4999,

/* 695 */
3, 1,
 25086,  -5507, -15503,
 25035,  -5496, -15589,
 25058,  -5452, -15568,

/* 696 */
3, 1,
-15610, -24492,   7515,
-15622, -24508,   7437,
-15570, -24510,   7538,

/* 697 */
3, 1,
-15472,  22928, -11615,
-15530,  22877, -11639,
-15545,  22901, -11571,

/* 698 */
3, 1,
-12165,  24913, -11461,
-12131,  24885, -11557,
-12179,  24873, -11533,

/* 699 */
3, 1,
  5310,  21296,  20452,
  5331,  21230,  20516,
  5377,  21242,  20491,

/* 700 */
3, -1,
 17800,  23716,  -4555,
 17858,  23655,  -4640,
 17827,  23682,  -4619,

/* 701 */
3, 1,
 18987,  -4163,  22851,
 19043,  -4074,  22820,
 18989,  -4105,  22860,

/* 702 */
3, 1,
-13833,  24181, -11133,
-13829,  24134, -11240,
-13850,  24141, -11197,

/* 703 */
3, 1,
  6651,  29245,   -700,
  6701,  29234,   -696,
  6605,  29254,   -756,

/* 704 */
3, 1,
-25607,   5901,  14473,
-25665,   5849,  14391,
-25638,   5846,  14440,

/* 705 */
3, 1,
-19397, -22308,   5108,
-19396, -22283,   5222,
-19410, -22280,   5180,

/* 706 */
3, 1,
-23259,   -297,  18946,
-23312,   -357,  18879,
-23273,   -367,  18927,

/* 707 */
3, 1,
-13405,  24297, -11400,
-13394,  24263, -11486,
-13444,  24247, -11460,

/* 708 */
3, 1,
 25842,  -4398, -14590,
 25839,  -4497, -14565,
 25818,  -4470, -14610,

/* 709 */
3, 1,
-25303,  12454, -10231,
-25360,  12402, -10153,
-25336,  12443, -10161,

/* 710 */
3, 1,
 -8255,  26088, -12300,
 -8173,  26082, -12367,
 -8229,  26067, -12362,

/* 711 */
3, 1,
  6152,  -8008, -28249,
  6063,  -7968, -28280,
  6126,  -7951, -28271,

/* 712 */
3, 1,
-25934,  14888,   2405,
-25970,  14841,   2304,
-25962,  14849,   2341,

/* 713 */
3, 1,
 -6774,  29199,  -1229,
 -6789,  29191,  -1338,
 -6811,  29188,  -1297,

/* 714 */
3, 1,
 -1560,  24786,  16830,
 -1570,  24733,  16907,
 -1517,  24750,  16886,

/* 715 */
3, -1,
-21338,  21065,   -960,
-21383,  21024,   -863,
-21364,  21043,   -882,

/* 716 */
3, 1,
 -5625,  24695, -16078,
 -5614,  24654, -16145,
 -5678,  24649, -16130,

/* 717 */
3, 1,
-26663,  12045,   6635,
-26672,  11975,   6725,
-26661,  12013,   6698,

/* 718 */
3, 1,
-27183,  11286,   5804,
-27186,  11232,   5896,
-27171,  11276,   5879,

/* 719 */
3, 1,
-20085, -21491,   5891,
-20148, -21425,   5919,
-20146, -21441,   5868,

/* 720 */
3, 1,
 11920, -13784, -23831,
 11942, -13686, -23876,
 11957, -13714, -23853,

/* 721 */
3, 1,
-19179, -22536,   4928,
-19213, -22489,   5011,
-19226, -22490,   4954,

/* 722 */
3, 1,
  -355,  23212,  19002,
  -447,  23223,  18987,
  -427,  23190,  19027,

/* 723 */
3, 1,
 10541,  18339,  21273,
 10463,  18306,  21341,
 10505,  18298,  21326,

/* 724 */
3, 1,
-14382,  25139,   7820,
-14472,  25083,   7836,
-14434,  25098,   7857,

/* 725 */
3, 1,
-17775, -23685,   4805,
-17836, -23625,   4875,
-17826, -23641,   4834,

/* 726 */
3, 1,
 15192,   -711, -25859,
 15156,   -799, -25877,
 15134,   -752, -25892,

/* 727 */
3, 1,
-25173,   6788,  14841,
-25170,   6869,  14808,
-25200,   6824,  14777,

/* 728 */
3, 1,
 23886,   -136, -18151,
 23919,   -196, -18106,
 23881,   -216, -18156,

/* 729 */
3, 1,
-17001,  21978,  11312,
-17064,  21907,  11354,
-17040,  21917,  11370,

/* 730 */
3, 1,
 11428,  -4389, -27389,
 11450,  -4488, -27364,
 11416,  -4465, -27381,

/* 731 */
3, 1,
-14644,  23549, -11447,
-14691,  23491, -11504,
-14708,  23502, -11460,

/* 732 */
3, 1,
 20716,  -6655,  20653,
 20742,  -6675,  20621,
 20731,  -6583,  20661,

/* 733 */
3, 1,
-27252,   6392,  10793,
-27252,   6313,  10838,
-27236,   6338,  10864,

/* 734 */
3, 1,
  8257,  18817,  21858,
  8231,  18761,  21915,
  8272,  18744,  21914,

/* 735 */
3, 1,
 17728,  -4370, -23804,
 17659,  -4413, -23847,
 17657,  -4373, -23856,

/* 736 */
3, 1,
  7081,  29143,   -744,
  7127,  29133,   -711,
  7111,  29134,   -804,

/* 737 */
3, 1,
 20340,  -6075, -21198,
 20282,  -6021, -21269,
 20306,  -6026, -21245,

/* 738 */
3, 1,
-10500, -27772,   4297,
-10487, -27765,   4375,
-10544, -27747,   4351,

/* 739 */
3, 1,
-21551,  16797, -12387,
-21612,  16772, -12313,
-21592,  16799, -12312,

/* 740 */
3, 1,
-23937,  14156, -11253,
-23897,  14198, -11285,
-23926,  14126, -11313,

/* 741 */
3, 1,
  2497,  24497,  17137,
  2528,  24549,  17058,
  2493,  24542,  17072,

/* 742 */
3, 1,
 21770,  -2150, -20529,
 21709,  -2216, -20586,
 21723,  -2188, -20574,

/* 743 */
3, 1,
-10876, -27085,   6937,
-10852, -27070,   7031,
-10890, -27062,   7002,

/* 744 */
3, 1,
-26625,  11639,   7461,
-26627,  11581,   7543,
-26614,  11615,   7534,

/* 745 */
3, -1,
-25621,  14760,  -5070,
-25629,  14776,  -4983,
-25602,  14798,  -5057,

/* 746 */
3, 1,
-16344,  22674, -10897,
-16433,  22621, -10874,
-16412,  22635, -10877,

/* 747 */
3, 1,
-15599,  23126, -11040,
-15659,  23073, -11065,
-15673,  23082, -11027,

/* 748 */
3, 1,
  2618,  27824,  10908,
  2667,  27843,  10848,
  2624,  27854,  10829,

/* 749 */
3, -1,
 13838,  15180,  21865,
 13908,  15114,  21867,
 13911,  15136,  21849,

/* 750 */
3, 1,
 29104,   5954,  -4186,
 29079,   6043,  -4229,
 29088,   6022,  -4197,

/* 751 */
3, -1,
-17298,  24161,  -4125,
-17307,  24139,  -4219,
-17326,  24131,  -4183,

/* 752 */
3, 1,
  7494,  29029,   1081,
  7523,  29023,   1045,
  7443,  29044,   1026,

/* 753 */
3, -1,
-19537, -11007,  19928,
-19569, -10943,  19932,
-19599, -10935,  19907,

/* 754 */
3, 1,
-18953, -22734,   4895,
-18996, -22685,   4954,
-19004, -22689,   4904,

/* 755 */
3, 1,
 13593,  -5535, -26165,
 13507,  -5562, -26204,
 13521,  -5539, -26201,

/* 756 */
3, -1,
-19136,  21815,  -7612,
-19209,  21755,  -7598,
-19203,  21767,  -7579,

/* 757 */
3, 1,
-24002,  17079,   5677,
-24030,  17072,   5578,
-24024,  17073,   5602,

/* 758 */
3, 1,
-26057,  14705,  -2194,
-26085,  14644,  -2268,
-26079,  14660,  -2224,

/* 759 */
3, 1,
-25874,   9131,  12130,
-25837,   9128,  12212,
-25833,   9154,  12201,

/* 760 */
3, -1,
-22516,  16997, -10205,
-22582,  16938, -10156,
-22568,  16954, -10162,

/* 761 */
3, 1,
 15992,   -257,  25381,
 15990,   -162,  25383,
 15972,   -205,  25394,

/* 762 */
3, 1,
 -8284,  26137, -12175,
 -8230,  26121, -12246,
 -8253,  26111, -12251,

/* 763 */
3, 1,
-20414, -21222,   5734,
-20404, -21210,   5815,
-20435, -21186,   5793,

/* 764 */
3, 1,
-15647,  23076, -11075,
-15709,  23018, -11108,
-15709,  23033, -11078,

/* 765 */
3, 1,
-28391,   9662,   -763,
-28401,   9625,   -851,
-28403,   9624,   -814,

/* 766 */
3, 1,
 23132,   6353,  18016,
 23192,   6324,  17948,
 23179,   6347,  17957,

/* 767 */
3, -1,
-24613,  16950,   2623,
-24657,  16892,   2584,
-24641,  16907,   2639,

/* 768 */
3, -1,
 10870, -14991,  23603,
 10905, -15056,  23545,
 10912, -15035,  23556,

/* 769 */
3, 1,
-27204,  11625,   4977,
-27209,  11578,   5059,
-27204,  11598,   5043,

/* 770 */
3, 1,
-26269,  14142,  -3158,
-26297,  14076,  -3216,
-26298,  14079,  -3194,

/* 771 */
3, 1,
  2537,  27833,  10903,
  2517,  27804,  10982,
  2540,  27806,  10973,

/* 772 */
3, 1,
-27160,  11434,   5619,
-27160,  11399,   5690,
-27148,  11427,   5695,

/* 773 */
3, 1,
 29168,   5584,  -4248,
 29158,   5656,  -4221,
 29165,   5638,  -4196,

/* 774 */
3, 1,
 29735,   1076,  -3832,
 29738,   1144,  -3785,
 29740,   1113,  -3777,

/* 775 */
3, -1,
 -1224,  25269,  16124,
 -1281,  25233,  16176,
 -1271,  25234,  16176,

/* 776 */
3, 1,
-28530,   9221,   1000,
-28508,   9285,   1044,
-28508,   9286,   1027,
0,

};
