#!/bin/sh -
#
# $Id: newvers.sh,v 5.2 90/06/23 22:21:21 jsp Rel $
#
# Copyright (c) 1989 Jan-Simon Pendry
# Copyright (c) 1989 Imperial College of Science, Technology & Medicine
# Copyright (c) 1989 The Regents of the University of California.
# All Rights Reserved.
#
# This code is derived from software contributed to Berkeley by
# Jan-Simon Pendry at Imperial College, London.
#
# Redistribution and use in source and binary forms are permitted provided
# that: (1) source distributions retain this entire copyright notice and
# comment, and (2) distributions including binaries display the following
# acknowledgement:  ``This product includes software developed by the
# University of California, Berkeley and its contributors'' in the
# documentation or other materials provided with the distribution and in
# all advertising materials mentioning features or use of this software.
# Neither the name of the University nor the names of its contributors may
# be used to endorse or promote products derived from this software without
# specific prior written permission.
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	%W% (Berkeley) %G%
#
PATH=/usr/ucb:/bin:/usr/bin
if [ $# -ne 1 ]; then echo "Usage: newvers program" >&2; exit 1; fi
version="version.$1"
if [ ! -r $version ]; then echo 0 > $version; chmod 444 $version; fi
v=`cat $version`
u=${USER-${LOGNAME-root}}
h=`hostname`
#h=`expr "$h" : '\([^.]*\)'`
t=`date`
r=`cat ../config/RELEASE`
c=`sed 's/$/\\\\n\\\\/' ../text/COPYRIGHT`
if [ -z "$r" -o -z "$c" ]; then
	echo ERROR: config file missing >&2
	exit 1
fi
rm -f vers.$1.c
cat > vers.$1.c << %%
char version[] = "\\
${c}
$1 ${r} #${v}: ${t}\\n\\
Built by ${u}@${h}";
%%
rm -f $version
/bin/echo `expr ${v} + 1` > $version
chmod 444 $version
