/*
 *                    Copyright (C) Shingo NISHIOKA, 1991
 *                       nishioka@sanken.osaka-u.ac.jp
 *            Everyone is permitted to do anything on this program
 *         including copying, transplanting, debugging, and modifying.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "ndtp.h"

#define BUFSIZE 4096

main(argc,argv)
char *argv[];
{
	int width;
	fd_set readfds, writefds, exceptfds;

	char buf[BUFSIZE];
	int s;
	width = getdtablesize();

	if(argc!=2) {
		fprintf(stderr,"usage %s host\n",argv[0]);
		exit(1);
	}
	s = iclient_init(argv[1]);
	for(;;) {
		int l;

		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(0,&readfds);
		FD_SET(s,&readfds);
		select(width,&readfds,&writefds,&exceptfds,NULL);
		if(FD_ISSET(s,&readfds)) {
			l = read(s,buf,BUFSIZE);
			buf[l] = '\0';
			if(l==0) break;
			printf("%s",buf);
		}
		/* NEVER remove 'else' from next line. */
		else if(FD_ISSET(0,&readfds)) {
			fgets(buf,BUFSIZE,stdin);
			write(s,buf,strlen(buf));
		}
	}
	printf("Connection closed\n");
	close(s);
}

iclient_init(remote)
char	*remote;
{
	int 	s;
	struct sockaddr_in	peeraddr_in;
	struct hostent	*hp;
	struct servent	*sp;

	bzero( (char *)&peeraddr_in, sizeof(struct sockaddr_in) ) ;

	peeraddr_in.sin_family = AF_INET ;
 	hp = gethostbyname( remote ) ;
	if( hp == NULL ) {
		perror( "iclient_init: " );
		fprintf( stderr, "%s is not found in /etc/hosts\n", remote );
		exit(1) ;
	}
	peeraddr_in.sin_addr.s_addr=((struct in_addr *)(hp->h_addr))->s_addr ;

 	sp = getservbyname( SERVICE, "tcp" ) ;
	if( sp == NULL )  {
		perror( "in iclient_init" );
		fprintf( stderr, "%s is not found in /etc/services\n", SERVICE );
		exit(1) ;
	}
	peeraddr_in.sin_port = sp->s_port ;

	s = socket( AF_INET, SOCK_STREAM, 0 ) ;
	if( s == -1 )  {
		perror( "Unable to create a socket /iclient_init\n" ) ;
		exit(1) ;
	}

	if( connect( s,&peeraddr_in, sizeof(struct sockaddr_in) )==-1 )  {
		perror( "Unable to connect /iclient_init\n" ) ;
		exit(1) ;
	}
	return s;
}
