/*
 *                    Copyright (C) Shingo NISHIOKA, 1991
 *                       nishioka@sanken.osaka-u.ac.jp
 *            Everyone is permitted to do anything on this program
 *         including copying, transplanting, debugging, and modifying.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "ndtp.h"

#define BUFSIZE 4096

main(argc,argv)
char *argv[];
{
	char buf[BUFSIZE];
	int s;
	int l;

	if(argc!=2) {
		char *p;
		p=argv[0]+strlen(argv[0]);
		for(; argv[0]<p && *(p-1)!='/'; p--) ;
		fprintf(stderr,"Usage: %s hostname\n",p);
		exit(1);
	}
	s = iclient_init(argv[1]);
	write(s,"u\n",2);
	while(l=read(s,buf,BUFSIZE)) {
		buf[l]='\0';
		if(buf[0]!='$') {
			fputs(buf,stdout);
		}
		if(!strncmp(buf,"$$",2)) break;
	}
	close(s);
}

iclient_init(remote)
char	*remote;
{
	int 	s;
	struct sockaddr_in	peeraddr_in;
	struct hostent	*hp;
	struct servent	*sp;

	bzero( (char *)&peeraddr_in, sizeof(struct sockaddr_in) ) ;

	peeraddr_in.sin_family = AF_INET ;
 	hp = gethostbyname( remote ) ;
	if( hp == NULL ) {
		perror( "iclient_init: " );
		fprintf( stderr, "%s is not found in /etc/hosts\n", remote );
		exit(1) ;
	}
	peeraddr_in.sin_addr.s_addr=((struct in_addr *)(hp->h_addr))->s_addr ;

 	sp = getservbyname( SERVICE, "tcp" ) ;
	if( sp == NULL )  {
		perror( "in iclient_init" );
		fprintf( stderr, "%s is not found in /etc/services\n", SERVICE );
		exit(1) ;
	}
	peeraddr_in.sin_port = sp->s_port ;

	s = socket( AF_INET, SOCK_STREAM, 0 ) ;
	if( s == -1 )  {
		perror( "Unable to create a socket /iclient_init\n" ) ;
		exit(1) ;
	}

	if( connect( s,&peeraddr_in, sizeof(struct sockaddr_in) )==-1 )  {
		perror( "Unable to connect /iclient_init\n" ) ;
		exit(1) ;
	}
	return s;
}
