#include "ndtp.h"
#include <sys/types.h>
#include <sys/param.h>
#include <sys/syslog.h>
#include <sys/socket.h>
#include <stdio.h>
#include <strings.h>

/*
 * host_access -- This code is derived from nntp1.5.11
 */
static	char		*accessfile = ACCESSFILE;

int
host_access(s)
int s;
{
	int		sockt;
	int		length;
	struct sockaddr	sa;
	int		match = 0;
	int		access = 1;
	char		hostornet[MAXHOSTNAMELEN];
	char		host_name[MAXHOSTNAMELEN];
	char		hostname[MAXHOSTNAMELEN];
	char		net_name[MAXHOSTNAMELEN];
	char		snet_name[MAXHOSTNAMELEN];
	char		line[MAXBUFLEN];
	register char	*cp;
	register FILE	*acs_fp;

#ifdef DEBUG
	return;
#endif

	sockt = s;
	length = sizeof (sa);

	if (getpeername(sockt, &sa, &length) < 0) {
		if (isatty(sockt)) {
			(void) strcpy(hostname, "stdin");
		} else {
#ifdef SYSLOG
			syslog(LOG_ERR, "host_access: getpeername: %m");
#endif
			(void) strcpy(hostname, "unknown");
		}
		exit(1);
	}

	switch (sa.sa_family) {
	case AF_INET:
		inet_netnames(sockt, &sa, net_name, snet_name, host_name);
		break;

	default:
#ifdef SYSLOG
		syslog(LOG_ERR, "unknown address family %ld", sa.sa_family);
#endif
		exit(1);
	};

	/* Normalize host name to lower case */

	for (cp = host_name; *cp; cp++)
		if (isupper(*cp))
			*cp = tolower(*cp);

#ifdef SYSLOG
	syslog(LOG_INFO, "%s connect\n", host_name);
#endif
	(void) strcpy(hostname, host_name);

	acs_fp = fopen(accessfile, "r");
	if (acs_fp == NULL) {
#ifdef SYSLOG
		syslog(LOG_ERR, "access: fopen %s: %m", accessfile);
#endif
		exit(1);
	}

	while (fgets(line, sizeof(line), acs_fp) != NULL) {
		if ((cp = index(line, '\n')) != NULL)
			*cp = '\0';
		if ((cp = index(line, '#')) != NULL)
			*cp = '\0';
		if (*line == '\0')
			continue;

		(void)sscanf(line, "%s",hostornet);

#ifdef DOMAINMATCH
 		if (domainmatch(hostornet, host_name)) {
#else
		if (!strcasecmp(hostornet, host_name)) {
#endif
			access = 0;	
			break;
		}

	}
	(void) fclose(acs_fp);
	return(access);
}

#ifdef DOMAINMATCH

domainmatch(domainsuffix,hostname)
char *domainsuffix,*hostname;
{
 	char *i;
	int dlen;
#ifdef SYSLOG
	char * lineptr;
	lineptr = domainsuffix;
#endif

	if (!strcasecmp(domainsuffix,hostname)) 
		return (1);

	if (*domainsuffix++ != '*')
		return (0);

	if (*domainsuffix++ != '.' ){
#ifdef SYSLOG
		syslog(LOG_ERR, "%s: no period following asterisk: %s",
			 accessfile, lineptr);
#endif
		return (0);
	}
	dlen = strlen(domainsuffix);

	hostname += (strlen(hostname)-strlen(domainsuffix));

	if (!strcasecmp(domainsuffix,hostname)) 
		return (1);

	return (0);
}
#endif DOMAINMATCH
