/*
 *                    Copyright (C) Shingo NISHIOKA, 1991
 *                       nishioka@sanken.osaka-u.ac.jp
 *            Everyone is permitted to do anything on this program
 *         including copying, transplanting, debugging, and modifying.
 */

#include <stdio.h>
#include "cdrom.h"
#include "dict.h"

#define TRUE 1
#define FALSE 0

#define HONMON 0x00
#define ALFAINDEX 0x91
#define KANAINDEX 0x90
#define ALFABINDEX 0x71
#define KANABINDEX 0x70
#define ZYOUKENINDEX 0x80
#define OKUDUKE 0x02
#define HANREI 0x01

#define TWOBYTEUINT(b) ((((unsigned int)*(b))<<8) + ((unsigned int)*((b)+1)))
#define FOURBYTEUINT(b) \
	((((unsigned int)*((b)+0))<<24) + (((unsigned int)*((b)+1))<<16) + \
	 (((unsigned int)*((b)+2))<<8)  + (((unsigned int)*((b)+3))<<0 ))

static int cur_s;

/* for reg_jisstrsub */
#define WHOLE	1		/* zentai ga match */
#define SHORT	2		/* mizikai hou no nagasade nstrcmp suru */

char *index();

#ifdef ALONE
main(argc,argv)
int argc;
char *argv[];
{
	FILE *in;
	Dict dict;

	if(argc!=2) {
		fprintf(stderr,"Usage: %s file\n",argv[0]);
		exit(1);
	}
	if(!(in=fopen(argv[1],"r"))) {
		fprintf(stderr,"Cannot open file %s\n",argv[1]);
		exit(1);
	}
	init_dic(&dict,in);

	for(;;) {
		static char s[128];
		printf("command:");
		gets(s);
		exec_newcommands(dict,s,1);
	}
}
#endif

exec_newcommands(dict,s,stream)
Dict *dict;
char *s;
{
	int frm,ofs;
	int idx;
	char *p;

	cur_s = stream;

	for(p=s; *p && *p!='\n'; p++) ; 
	*p = '\0';

	switch(*s) {
	case 'P':
		switch(*(s+1)) {
		case 'a': idx = ALFAINDEX; break;
		case 'A': idx = ALFABINDEX; break;
		case 'k': idx = KANAINDEX; break;
		case 'K': idx = KANABINDEX; break;
		default:
			write(cur_s,"$?\n",3);
			return;
		}
		write(cur_s,"$0\n",3);
		findentry(dict,s+2,idx);
		write(cur_s,"$$\n",3);
		break;
	case 'F':
		sscanf(s+1,"%x",&frm);
		write(cur_s,"$F",2);
		showhonmon(dict,frm,0,TRUE);
		break;
	case 'S':
		sscanf(s+1,"%x",&frm);
		s=index(s,':');
		if(s==NULL) {
			write(cur_s,"$?\n",3);
			return;
		}
		sscanf(s+1,"%x",&ofs);
		write(cur_s,"$1\n",3);
		showhonmon(dict,frm,ofs,FALSE);
		write(cur_s,"$$\n",3);
		break;
	case 'I':
		write(cur_s,"$I\n",3);
		query_index(dict);
		write(cur_s,"$$\n",3);
		break;
	}
}

query_index(dict)
Dict *dict;
{
	Index *p;
	static char str[16];

	for(p=dict->index; p!=NULL; p=p->next) {
		switch(p->type) {
		case HONMON:
			sprintf(str,"HO %x\n",p->start);
			break;
		case ALFAINDEX:
			sprintf(str,"IA %x\n",p->start);
			break;
		case KANAINDEX:
			sprintf(str,"IK %x\n",p->start);
			break;
		case ALFABINDEX:
			sprintf(str,"BA %x\n",p->start);
			break;
		case KANABINDEX:
			sprintf(str,"BK %x\n",p->start);
			break;
		case ZYOUKENINDEX:
			sprintf(str,"ZI %x\n",p->start);
			break;
		case OKUDUKE:
			sprintf(str,"OK %x\n",p->start);
			break;
		case HANREI:
			sprintf(str,"HA %x\n",p->start);
			break;
		default: continue;
		}
		write(cur_s,str,strlen(str));
	}
}

init_dic(dict,stream)
Dict *dict;
FILE *stream;
{
#define BS 16
	static unsigned char b[BS];
	static unsigned char null[BS];
	int e;
	Index *new;

	dict->stream = stream;

	bzero(null,BS);
	seekframe(dict->stream,1);

	if(fread(b,BS,1,dict->stream)!=1) return -1;

	e = TWOBYTEUINT(b);

#ifdef DEBUG
	printf("%d\n",e);
#endif

	dict->index = NULL;

	for(; e>0; e--) {
		if(fread(b,BS,1,dict->stream)!=1) return -1;
		if(!bcmp(b,null,BS)) break;

		new = (Index *)calloc(1,sizeof(Index));
		new->type = b[0];
		new->start = FOURBYTEUINT(b+2);
		new->next = dict->index;
		dict->index = new;
	}
	return 0;
}

seekframe(stream,f)
FILE *stream;
{
	fseek(stream, (long)(f-1)*FRAMESIZE , 0);
}

findentry(dict,ent,type)
Dict *dict;
unsigned char *ent;
{
	Index *p;
	unsigned char buf[128],key[128],realkey[128];

	for(p=dict->index; p!=NULL && p->type!=type; p=p->next) ;
	if(p==NULL) return;

	strcpy(buf,ent);
	nstringupcase(buf);

	han2zen(buf,key);
	nstripmsb(key);

	han2zen(buf,realkey);
	nstripmsb(realkey);

	njisnormalize(key);

	n_special_zen2han(key);
	n_special_zen2han(realkey);

#ifdef DEBUG
	for(i=0; key[i]||key[i+1]; i++) ;
	printf("key(%d)=",i);
	putnstr(key,i);
	for(i=0; realkey[i]||realkey[i+1]; i++) ;
	printf("\nrealkey(%d)=",i);
	putnstr(realkey,i);
	printf("\n");
#endif

	findentry_int(dict,key,realkey,p->start);
}

unsigned char *
readidx(dict,q,match,midasi)
Dict *dict;
unsigned char *q;
{
	static char buf[16];
	if(match) {
		int frm,ofs;
		if(midasi) {
			frm=TWOBYTEUINT(q+8);
			ofs=TWOBYTEUINT(q+10);
			showmidasi(dict,frm,ofs);
			write(cur_s,"\n",1);
		}
		frm=TWOBYTEUINT(q+2);
		ofs=TWOBYTEUINT(q+4);
		sprintf(buf,"%x:%x\n",frm,ofs);
		write(cur_s,buf,strlen(buf));
	}
	if(midasi) return q+12;
	else return q+6;
}

findentry_int(dict,key,realkey,frm)
Dict *dict;
unsigned char *key,*realkey;
{
	/* auto */
	unsigned char frame[FRAMESIZE+2];
	static char msg[32];

#ifdef DEBUG
	printf("FRAME=%x\n",frm);
#endif

	frame[FRAMESIZE] = frame[FRAMESIZE+1] = '\0'; /* sentinel */

	do {
		seekframe(dict->stream,frm++);
		fread(frame,FRAMESIZE,1,dict->stream);
		if((frame[0]&0x10) && frame[1]!=0) {
			/* koteityou assyuku type */
			sprintf(msg,"$^C,frm=%x\n",frm-1);
			write(cur_s,msg,strlen(msg));
		}
		if(!(frame[0]&0x10) && frame[1]!=0) {
			/* koteityou assyuku type */
			int i,s,e;
			unsigned char *q;

			s=frame[1];
			e=TWOBYTEUINT(frame+2);
#ifdef DEBUG
			printf("kotei[2]: e=%d\n",e);
#endif
			for(i=0; i<e; i++) {
				q=frame+4+i*(s+4);
#ifdef DEBUG
				printf("%d:",i);
				putnstr(q,s);
				printf("\n");
#endif
				if(reg_jisstrsub(key,q,SHORT)<=0) {
					findentry_int(dict,key,realkey,FOURBYTEUINT(q+s));
				}
				if(reg_jisstrsub(key,q,SHORT)<0) {
					return;
				}
			}
		}
		else if(frame[1]==0) {
			int i,e,s;
			unsigned char *q;
			int subentnum;
			int match;

			subentnum=0;
			match=FALSE;
			e=TWOBYTEUINT(frame+2);
#ifdef DEBUG
			printf("kahen: e=%d\n",e);
#endif
			q=frame+4;
			for(i=0; i<e || subentnum>0; i++) {
				if(subentnum==0) match=FALSE;
				if(*q==0x80) {
					s = *(q+1);
					q+=2;
					subentnum=TWOBYTEUINT(q);
#ifdef DEBUG
					printf("subentnum=%d\n",subentnum);
#endif
					if(subentnum==0) {
						q+=2;
						subentnum=TWOBYTEUINT(q);
#ifdef DEBUG
						printf("key80(00)=");
#endif
						q+=2;
#ifdef DEBUG
						putnstr(q,s);
						putchar('\n');
#endif
						q+=s;
						q+=6;

					}
					else {
						q+=2;
#ifdef DEBUG
						printf("key80=");
						putnstr(q,s);
						putchar('\n');
						printf("No index\n");
#endif
						q+=s;
					}
				}
				else if(*q==0x00 && *(q+1)==0x00) {
#ifdef DEBUG
					printf("#Newpage\n");
#endif
					seekframe(dict->stream,frm);
					fread(frame,FRAMESIZE,1,dict->stream);
					q=frame+4;
				}
				else if(*q==0xc0 || *q==0x00) {
					if(subentnum>0) subentnum--;
					s = *(q+1);
#ifdef DEBUG
					printf("key%02x=",*q);
#endif
					if(s==0) {
						q++;
#ifdef DEBUG
						printf("null");
						putchar('\n');
#endif
						q=readidx(dict,q,match,FALSE);
					}
					else {
						q+=2;
#ifdef DEBUG
						putnstr(q,s);
#endif
						if(!match) {
							match=!reg_jisstrsub(realkey,q,WHOLE);
						}
						q+=s;
#ifdef DEBUG
						putchar('\n');
#endif
						q=readidx(dict,q,match,TRUE);
						match=FALSE;
					}
				}
				else if(*q<=0x7f) {
					if(subentnum>0) subentnum--;
					s = *q;
					q++;
#ifdef DEBUG
					printf("key7f=");
					putnstr(q,s);
#endif
					if(!match) {
						match=!reg_jisstrsub(realkey,q,WHOLE);
					}
#ifdef DEBUG
					putchar('\n');
#endif
					q+=s;
					q=readidx(dict,q,match,TRUE);
					match=FALSE;
				}
				else {
					sprintf(msg,"$^*q=%x,frm=%x\n",*q,frm-1);
					write(cur_s,msg,strlen(msg));
					return;
				}
			}
#ifdef DEBUG
			if(subentnum) {
				printf("!subentnum\n");
			}
			if(q>=frame+FRAMESIZE) {
				printf("!q\n");
			}
#endif
		}
		else {
			sprintf(msg,"$^F=%x,frm=%x\n",frame[0],frm-1);
			write(cur_s,msg,strlen(msg));
		}
	} while(frame[0]&0x20==0);
}

showmidasi(dict,frm,ofs)
Dict *dict;
{
	int hi,lo;

#ifdef DEBUG
	printf("%x,%x\n",frm,ofs);
#endif

	seekframe(dict->stream,frm);
	fseek(dict->stream,(long)ofs,1);
	hi = getc(dict->stream);
	lo = getc(dict->stream);
	do {
		if(hi!=0x1f) puteucz2h(cur_s,hi,lo);
		hi = getc(dict->stream);
		lo = getc(dict->stream);
	} while(!(hi==0x1f && lo==0x0a));
#ifdef DEBUG
	printf("\n");
#endif
}

showhonmon(dict,frm,ofs,raw)
Dict *dict;
{
	int hi,lo;
	static char frame[FRAMESIZE];

#ifdef DEBUG
	printf("%x,%x\n",frm,ofs);
#endif

	seekframe(dict->stream,frm);
	if(raw) {
		fread(frame,FRAMESIZE,1,dict->stream);
		write(cur_s,frame,FRAMESIZE);
	}
	else {
		fseek(dict->stream,(long)ofs,1);
		hi = getc(dict->stream);
		lo = getc(dict->stream);
		while(!(hi==0x00 && lo==0x00) &&
		      !(hi==0x1f && lo==0x41)) {
			hi = getc(dict->stream);
			lo = getc(dict->stream);
		}
		while((hi==0x00 && lo==0x00) ||
		      (hi==0x1f && lo==0x41)) {
			hi = getc(dict->stream);
			lo = getc(dict->stream);
		}
		while(!(hi==0x00 && lo==0x00) &&
		      !(hi==0x00 && lo==0x01)) {
			if(hi!=0x1f) puteucz2h(cur_s,hi,lo);
			hi = getc(dict->stream);
			lo = getc(dict->stream);
		}
	}
	write(cur_s,"\n",1);
}
