/*
 *                    Copyright (C) Shingo NISHIOKA, 1991
 *                       nishioka@sanken.osaka-u.ac.jp
 *            Everyone is permitted to do anything on this program
 *         including copying, transplanting, debugging, and modifying.
 */

static char *rcsid="$Id: main.c,v 2.5 91/12/23 15:48:07 nishioka Exp Locker: nishioka $";

#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/signal.h>

#ifdef DEBUG
int debug;
#endif

main(argc,argv)
int argc;
char *argv[];
{
	int tmpttyfd;

#ifdef DEBUG
	if(argc!=2) {
		fprintf(stderr,"Usage: %s [0-2]\n",argv[0]);
		exit(1);
	}

	debug = atoi(argv[1]);
	fprintf(stderr,"Debug Level: %d\n",debug);
#endif

#ifdef DEBUG
	if(debug>=2) {
#endif
#ifdef STANDALONE
		setuid(geteuid());
		if ((tmpttyfd = open("/dev/tty", O_RDWR)) >= 0) {
			ioctl(tmpttyfd, TIOCNOTTY, 0);
			(void) close(tmpttyfd);
		}
		tmpttyfd = open("/", O_RDONLY);
		if (tmpttyfd >= 0) {
			if (tmpttyfd != 0) {      /* should never happen */
				(void) dup2(tmpttyfd, 0);
				(void) close(tmpttyfd);
			}
			(void) dup2(0, 1);
			(void) dup2(1, 2);
		}
#endif /* STANDALONE */
#ifdef DEBUG
	}
#endif

	iserver_init();
#ifdef STANDALONE
	dic_inits();
#endif
	command_loop();
	return 0;
}

write_server_version(s)
int s;
{
	static char *rev="$v$Revision: 2.5 $ $Date: 91/12/23 15:48:07 $\n";
	write(s,rev,strlen(rev));
}
