/*
 *                    Copyright (C) Shingo NISHIOKA, 1991
 *                       nishioka@sanken.osaka-u.ac.jp
 *            Everyone is permitted to do anything on this program
 *         including copying, transplanting, debugging, and modifying.
 */

#include <stdio.h>

/* for reg_jisstrsub */
#define WHOLE	1		/* zentai ga match */
#define SHORT	2		/* mizikai hou no nagasade nstrcmp suru */

#ifdef DEBUG
putnstr(q,s)
char *q;
{
	int k;
	int hi,lo;

	for(k=0; k<s/2; k++) {
		hi = *(q+k*2)&0x7f;
		lo = *(q+k*2+1)&0x7f;
		if(hi) {
			puteuc(hi,lo,stdout);
		}
		else if(lo) {
			putchar(lo);
		}
	}
}
#endif

reg_jisstrsub(s,t,r)
unsigned char *s, *t;
int r;
{
	unsigned int ss,tt;

	for(; ; s+=2,t+=2) {
		ss = (*s&0x7f)<<8|*(s+1)&0x7f;
		tt = (*t&0x7f)<<8|*(t+1)&0x7f;

		if(r==SHORT && (ss=='*' || ss=='?')) {
			return 0;
		}
		if(r==WHOLE && (ss=='*')) {
			return 0;
		}
		if(!ss || !tt) break;
		if(r==WHOLE && (ss=='?')) {
			continue;
		}
		if(ss!=tt) break;
	}
	return ss-tt;
}

han2zen(h,z)
char *h,*z;
{
	for(; *h; h++) {
		if('A'<=*h && *h<='Z' ||
		   '0'<=*h && *h<='9') {
			*z++ = 0x23;
			*z++ = *h;
		}
		else if(*h=='*' || *h=='?') {
			*z++ = '\0';
			*z++ = *h;
		}
		else {
			*z++ = *h;
		}
	}
	*z++='\0';
	*z++='\0';
}

nstringupcase(s)
char *s;
{
	for(; *s; s++) {
		if('a'<=*s && *s<='z') {
			*s = *s-'a'+'A';
		}
	}
}

/* 
 * '?' to '*' wo hankaku mozini henkan
 */
n_special_zen2han(s)
char *s;
{
	for(; *s||*(s+1); s+=2) {
		if(*s==0x21 && *(s+1)==0x76) {
			*s = '\0';
			*(s+1) = '*';
		}
		if(*s==0x21 && *(s+1)==0x29) {
			*s = '\0';
			*(s+1) = '?';
		}
	}
}

#ifdef DEBUG
/*
 * EUC, '*', '?' nomi kara naru moziretu no msb wo hagitoru.
 * '*', '?' ha sorezore '\0*', '\0?' ni henkan suru.
 */
neuc2jis(s)
char *s;
{
	for(; *s; ) {
		if(*s&0x80) {
			*s++ &= 0x7f;
			*s++ &= 0x7f;
		}
		else if(*s=='*' || *s=='?') {
			int l;
			l=strlen(s+1)+1;
			while(l>0) {
				*(s+1+l) = *(s+l);
				l--;
			}
			if(*s=='*') {
				*s++=0x21;
				*s++=0x76;
			}
			else if(*s=='?') {
				*s++=0x21;
				*s++=0x29;
			}
			else {
				*s+=2;
			}
		}
		else {
			s++;
		}
	}
}
#endif

struct _conv_tbl {
	int oldhi,oldlo;
	int newhi,newlo;
};

struct _conv_tbl conv_tbl[] = {
{0x24,0x21, 0x24,0x22},		/* a */
{0x24,0x23, 0x24,0x24},		/* i */
{0x24,0x25, 0x24,0x26},		/* u */
{0x24,0x27, 0x24,0x28},		/* e */
{0x24,0x29, 0x24,0x2a},		/* o */
{0x24,0x43, 0x24,0x44},		/* tu */
{0x24,0x63, 0x24,0x64},		/* ya */
{0x24,0x65, 0x24,0x66},		/* yu */
{0x24,0x67, 0x24,0x68},		/* yo */
{0x24,0x6e, 0x24,0x6f},		/* wa */

{0x24,0x2c, 0x24,0x2b},		/* ga */
{0x24,0x2e, 0x24,0x2d},		/* gi */
{0x24,0x30, 0x24,0x2f},		/* gu */
{0x24,0x32, 0x24,0x31},		/* ge */
{0x24,0x34, 0x24,0x33},		/* go */

{0x24,0x36, 0x24,0x35},		/* za */
{0x24,0x38, 0x24,0x37},		/* zi */
{0x24,0x3a, 0x24,0x39},		/* zu */
{0x24,0x3c, 0x24,0x3b},		/* ze */
{0x24,0x3e, 0x24,0x3d},		/* zo */

{0x24,0x40, 0x24,0x3f},		/* da */
{0x24,0x42, 0x24,0x41},		/* di */
{0x24,0x45, 0x24,0x44},		/* du */
{0x24,0x47, 0x24,0x46},		/* de */
{0x24,0x49, 0x24,0x48},		/* do */

{0x24,0x50, 0x24,0x4f},		/* ba */
{0x24,0x53, 0x24,0x52},		/* bi */
{0x24,0x56, 0x24,0x55},		/* bu */
{0x24,0x59, 0x24,0x58},		/* be */
{0x24,0x5c, 0x24,0x5b},		/* bo */

{0x24,0x51, 0x24,0x4f},		/* pa */
{0x24,0x54, 0x24,0x52},		/* pi */
{0x24,0x57, 0x24,0x55},		/* pu */
{0x24,0x5a, 0x24,0x58},		/* pe */
{0x24,0x5d, 0x24,0x5b},		/* po */
};

njisnormalize(s)
unsigned char *s;
{
	for(; *s||*(s+1); s+=2) {
		unsigned int hi,lo;
		int i;

		hi = *s&0x7f, lo = *(s+1)&0x7f;
		if(hi==0x25) {	/* first, katakana->hirakana */
			if(lo==0x75) { /* ka */
				*s = 0x24, *(s+1)=0x2b;
			}
			else if(lo==0x76) { /* ke */
				*s = 0x24, *(s+1)=0x31;
			}
			else {	/* katakana->hirakana */
				*s = 0x24;
			}
		}

		/* next, try small hirakana->normal hirakana */
		/* this operation must follow the katakana->hirakana */
		/* as the previous operation may generate small hirakana */
		hi = *s&0x7f, lo = *(s+1)&0x7f;
		for(i=0; i<sizeof(conv_tbl)/sizeof(struct _conv_tbl); i++) {
			if(hi==conv_tbl[i].oldhi &&
			   lo==conv_tbl[i].oldlo) {
				*s = conv_tbl[i].newhi;
				*(s+1) = conv_tbl[i].newlo;
				break;
			}
		}

		/* last, convert a '-' to a vowel */
		if(hi==0x21 && lo==0x3c) { /* - */
			unsigned int phi,plo;
			phi = *(s-2)&0x7f, plo = *(s-1)&0x7f;
			if(phi==0x24) {
				/* previous character is not hirakana */
				switch(plo) {
				case 0x22: /* a */
				case 0x2b: /* ka */
				case 0x35: /* sa */
				case 0x3f: /* ta */
				case 0x4a: /* na */
				case 0x4f: /* ha */
				case 0x5e: /* ma */
				case 0x64: /* ya */
				case 0x69: /* ra */
				case 0x6f: /* wa */
					*s=0x24;
					*(s+1)=0x22;
					break;
				case 0x24: /* i */
				case 0x2d: /* ki */
				case 0x37: /* si */
				case 0x41: /* ti */
				case 0x4b: /* ni */
				case 0x52: /* hi */
				case 0x5f: /* mi */
				case 0x6a: /* ri */
				case 0x70: /* wi */
					*s=0x24;
					*(s+1)=0x24;
					break;
				case 0x26: /* u */
				case 0x2f: /* ku */
				case 0x39: /* su */
				case 0x44: /* tu */
				case 0x4c: /* nu */
				case 0x55: /* hu */
				case 0x60: /* mu */
				case 0x66: /* yu */
				case 0x6b: /* ru */
					*s=0x24;
					*(s+1)=0x26;
					break;
				case 0x28: /* e */
				case 0x31: /* ke */
				case 0x3b: /* se */
				case 0x46: /* te */
				case 0x4d: /* ne */
				case 0x58: /* he */
				case 0x61: /* me */
				case 0x6c: /* re */
				case 0x71: /* we */
					*s=0x24;
					*(s+1)=0x28;
					break;
				case 0x2a: /* o */
				case 0x33: /* ko */
				case 0x3d: /* so */
				case 0x48: /* to */
				case 0x4e: /* no */
				case 0x5b: /* ho */
				case 0x62: /* mo */
				case 0x68: /* yo */
				case 0x6d: /* ro */
				case 0x72: /* wo */
					*s=0x24;
					*(s+1)=0x2a;
					break;
				case 0x73: /* n */
					*s=0x24;
					*(s+1)=0x73;
				default:
					break;
				}
			}
			/* else cannot convert! */
		}
	}
}

#ifdef DEBUG
puteuc(hi,lo,stream)
FILE *stream;
{
	if(0x21<=hi && hi<0x7f &&
	   0x21<=lo && lo<0x7f) {
		fprintf(stream,"%c%c",hi&0x7f|0x80,lo&0x7f|0x80);
	}
	else {
		fprintf(stream,"##");
	}
}
#endif

nstripmsb(s)
unsigned char *s;
{
	for(; *s; s++) {
		*s &= 0x7f;
	}
}

puteucz2h(s,hi,lo)
int s;
unsigned int hi,lo;
{
	static char buf[32];

	if(hi==0x23 && 
	   0x21<=lo && lo<0x7f &&
	   lo!='#') {		/* zenkaku mozi -> hankaku mozi */
		sprintf(buf,"%c",lo&0x7f);
	}
	else if(hi==0x21 && 
		0x21<=lo && lo<0x7f) {
		switch(lo) {
		case 0x21:
			strcpy(buf," ");
			break;
		case 0x47:
			strcpy(buf,"'");
			break;
		case 0x4a:
			strcpy(buf,"(");
			break;
		case 0x4b:
			strcpy(buf,")");
			break;
		case 0x4e:
			strcpy(buf,"[");
			break;
		case 0x4f:
			strcpy(buf,"]");
			break;
		default:
			sprintf(buf,"%c%c",hi&0x7f|0x80,lo&0x7f|0x80);
			break;
		}
	}
	else if(0x21<=hi && hi<0x7f &&
		0x21<=lo && lo<0x7f) { /* JIS kanji mozi */
		sprintf(buf,"%c%c",hi&0x7f|0x80,lo&0x7f|0x80);
	}
	else if(hi==0xa1) {	/* KAIGYOU or character-style control */
		switch(lo) {
		case 0x21:
			strcpy(buf," ");
			break;
		case 0x22:	/* [ (for eiwa) */
			strcpy(buf," {");
			break;
		case 0x23:	/* [ (for eiwa) */
			strcpy(buf,"} ");
			break;
		case 0x25:	/* e no hikkuri kaetta yatu (ability)*/
			strcpy(buf,"#e");
			break;
		case 0x26:
			strcpy(buf,":");
			break;
		case 0x27:	/* c no gyaku (cotton) */
			strcpy(buf,"#o");
			break;
		case 0x28:	/* e + r no katamuita yatu (art) */
			strcpy(buf,"#/er/");
			break;
		case 0x2a:	/* hige no nai a (alms) */
			strcpy(buf,"#a");
			break;
		case 0x29:	/* ae (ask) */
			strcpy(buf,"#/ae(:)/");
			break;
		case 0x30:	/* ae (hat) */
			strcpy(buf,"#/ae/");
			break;
		case 0x2b:	/* s no nagai yatu (ship) */
			strcpy(buf,"#s");
			break;
		case 0x2c:	/* v no hikkuri kaetta yatu (up) */
			strcpy(buf,"#v");
			break;
		case 0x2d:	/* measure */
			strcpy(buf,"#g");
			break;
		case 0x2e:	/* ng */
			strcpy(buf,"#/ng/");
			break;
		case 0x2f:	/* (think) */
			strcpy(buf,"#t");
			break;
		case 0x31:	/* (this) */
			strcpy(buf,"#d");
			break;
		case 0x35:	/* following character has accent */
			strcpy(buf,"#'");
			break;
		case 0x36:	/* following character has week accent */
			strcpy(buf,"#`");
			break;
		case 0x42:
			strcpy(buf,"(C)");
			break;
		case 0x43:
			strcpy(buf,"(U)");
			break;
		default:
			if(lo>=0x6b) {
				/* currently beleived as 
				   1. beginning of kanji-midasi (waei)
				   2. beginning of pronunciation (eiwa)
				   just ignore. */
				strcpy(buf,"");
			}
			else {
				sprintf(buf,"#x%02x#x%02x",hi,lo);
			}
			break;
		}
#ifdef DEBUG
		sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
	}
	else if(hi==0xa2) {	/* special control */
		switch(lo) {
		case 0x2c:	/* ??? (eiwa) */
			strcpy(buf," ");
			break;
		case 0x2d:	/* ??? (eiwa) */
			strcpy(buf," ");
			break;
		case 0x2e:	/* ??? (eiwa) */
			strcpy(buf," ");
			break;

		case 0x27:
			strcpy(buf,"\015\005");
			break;
		case 0x28:
			strcpy(buf," ");
			break;
		default:
			strcpy(buf,"");
#ifdef DEBUG
			sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
			break;
		}
#ifdef DEBUG
		sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
	}
	else if(hi==0xa4) {
		switch (lo) {
		case ';': /* [ */
			sprintf(buf,"%c%c",0x21|0x80,0x58|0x80);
			break;
		case '<': /* ] */
			sprintf(buf,"%c%c",0x21|0x80,0x59|0x80);
			break;
		case '>': /* => */
			sprintf(buf,"%c%c",0x22|0x80,0x4d|0x80);
			break;
		case '&': /* repeat char */
			sprintf(buf,"%c%c",0x21|0x80,0x35|0x80);
			break;
		case '$': /* repeat1 char */
			sprintf(buf,"%c%c",0x21|0x80,0x39|0x80);
			break;
		case '#': /* repeat2 char */
			sprintf(buf,"%c%c",0x21|0x80,0x39|0x80);
			break;
		case 'U': /* bonzi U */
		case 'J': /* ? */
		case '"':
		case '*':
		case '/':
		case '!':
		case 'X':
		case '6':
		case 'C':
			sprintf(buf,"%c%c",0x22|0x80,0x23|0x80);
			break;
		default:
			sprintf(buf,"#xa4#x%02x",lo);
			break;
		}
#ifdef DEBUG
		sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
	}
	else if(hi==0x00) {
		switch(lo) {
		case 0x00:	/* begin midasi */
		case 0x01:	/* end entry */
			strcpy(buf,"");
			break;
		case 0x02:	/* begin body */
			strcpy(buf,"\015\005");
			break;
		case 0x05:	/* next-paragraph (kojien) */
			strcpy(buf,"\015\005");
			break;
		default:
			strcpy(buf,"");
#ifdef DEBUG
			sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
			break;
		}
#ifdef DEBUG
		sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
	}
	else if(hi==0x01) {	/* special contorl? just ignore, now */
		switch(lo) {
		case 0x30:	/* begin hiragana midasi (kojien) */
			strcpy(buf,"");
			break;
		default:
			strcpy(buf,"");
#ifdef DEBUG
			sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
#ifdef DEBUG
			sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
		}
	}
	else if(hi==0x02) {	/* special contorl? just ignore, now */
		switch(lo) {
		case 0x60:	/* begin midasi (kojien) */
			strcpy(buf,"");
			break;
		default:
			strcpy(buf,"");
#ifdef DEBUG
			sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
			break;
		}
#ifdef DEBUG
		sprintf(buf,"#x%02x#x%02x",hi,lo);
#endif
	}
	else {
		sprintf(buf,"#x%02x#x%02x",hi,lo);
	}
	write(s,buf,strlen(buf));
}
