/* Functions for multi-byte support.
   Created for gawk multi-byte extension May, 1993 by t^2 (Takahiro Tanimoto)
   Last change: Jul. 2, 1993 by t^2  */
#include "awk.h"

int
#ifdef __STDC__
mbstrncasecmp(const char *s1, const char *s2, size_t n)
#else
mbstrncasecmp(s1, s2, n)
     const char *s1, *s2;
     size_t n;
#endif
{
  int c1;

  while (n--) {
    if ((c1 = (unsigned char)*s1++) == 0)
      return -(unsigned char)*s2;
    if (!ismbchar(c1)) {
      if ((c1 = ((unsigned char)casetable[c1]
		 - (unsigned char)casetable[(unsigned char)*s2++])) != 0)
	return c1;
    }
    else {
      if ((c1 -= (unsigned char)*s2++) != 0)
	return c1;
      if (!n--)
	break;
      if ((c1 = (unsigned char)*s1++) == 0)
	return -(unsigned char)*s2;
      if ((c1 -= (unsigned char)*s2++) != 0)
	return c1;
    }
  }
  return 0;
}

int
#ifdef __STDC__
mbmemcmp(const void *p1, size_t n1, const void *p2, size_t n2)
#else
mbmemcmp(p1, n1, p2, n2)
     const void *p1, *p2;
     size_t n1, n2;
#endif
{
  const unsigned char *s1 = p1, *s2 = p2;
  unsigned char c1;

  for (; ; ) {
    if (!n1--)
      return n2 ? -1 : 0;
    if (!n2--)
      return 1;
    if ((c1 = *s1++) != *s2++)
      break;
    if (!ismbchar(c1))
      continue;
    if (!n1--)
      return n2 ? -1 : 0;
    if (!n2--)
      return 1;
    if (*s1++ != *s2++)
      return (int)*--s1 - *--s2;
  }
  --s2;
  if (ismbchar(c1))
    return ismbchar(*s2) ? (int)c1 - *s2 : 1;
  return ismbchar(*s2) ? -1 : (int)c1 - *s2;
}
