/* $Id: redir.c,v 1.1 1994/08/29 04:30:54 tt Rel $
 *
 * redir -- Command Redirector version 1.0
 *
 * Copyright (c) 1994 t^2
 * All rights reserved.
 */
#include <fcntl.h>
#include <io.h>
#include <process.h>

int
main(int argc, char **argv)
{
  int i;
  const char *p, *q;
  int fd, nfd;
  enum {OUT, IN, APPEND, ERR} mode;

  for (i = 1; i < argc; i++) {
    p = argv[i];
    if (*p++ != '-')
      break;
    if (p[0] == '-' || p[1] == '\0')
      break;
    /* 쥯Ȼؼ */
    mode = OUT;
    fd = (int)strtoul(p, (char **)&q, 0); /* ǥץ */
    if (p == q)
      mode = ERR;
    p = q;
    if (*p == '\0')
      p = argv[++i];
    else {
      if (*p == '+') {
	p++;
	if (mode != ERR) mode = APPEND;
      }
      else if (*p == '-') {
	p++;
	if (mode != ERR) mode = IN;
      }
      else if (*p == ':') {
	p++;
	nfd = (int)strtoul(p, (char **)&q, 0);
	if (p != q && *q == '\0')
	  if (mode != ERR) dup2(nfd, fd);
	continue;
      }
      if (*p == '=')
	p++;
    }
    if (*p == '\0')
      mode = ERR;
    switch (mode) {
    case OUT:
      nfd = open(p, O_WRONLY | O_CREAT | O_TRUNC, 0666);
      break;
    case IN:
      nfd = open(p, O_RDONLY);
      break;
    case APPEND:
      nfd = open(p, O_WRONLY | O_CREAT | O_APPEND, 0666);
      if (nfd >= 0) lseek(nfd, 0L, 2);
      break;
    default:
      nfd = -1;
      break;
    }
    if (nfd >= 0) {
      dup2(nfd, fd);
      close(nfd);
    }
  }
  if (i < argc) {
    argv += i;
    execvp(argv[0], argv);
    return 255;
  }
  return 0;
}
