#include <stdio.h>

#define WCTABLE_OFFSET 0xa1
#define WCTABLE_SIZE 94

#ifndef BUFSIZ
#  define BUFSIZ 1024
#endif


main(argc, argv)
int argc;
char *argv[];
{
  int ku, ten;
  unsigned short wc;
  char *metric, *type, header[BUFSIZ];

  if (argc != 3) {
      fprintf(stderr, "Usage:  cat <header> | createM <metric> <type>\n");
      exit (1);
  }
  metric = argv[1];
  type = argv[2];

  while (fgets(header, BUFSIZ, stdin) != NULL) {
      fputs(header, stdout);
  }

  printf("charset\n");
  for (ku = 0; ku < WCTABLE_SIZE; ku++) {
    for (ten = 0; ten < WCTABLE_SIZE; ten++) {
      wc = ((ku + WCTABLE_OFFSET) << 8) & 0xff00;
      wc |= (ten + WCTABLE_OFFSET) & 0xff;
      if (wc >= 0xa2af && wc <= 0xa2b9 ||
	  wc >= 0xa2c2 && wc <= 0xa2c9 ||
	  wc >= 0xa2d1 && wc <= 0xa2db ||
	  wc >= 0xa2eb && wc <= 0xa2f1 ||
	  wc >= 0xa2fa && wc <= 0xa2fd ||
	  wc >= 0xa3a1 && wc <= 0xa3af ||
	  wc >= 0xa3ba && wc <= 0xa3c0 ||
	  wc >= 0xa3db && wc <= 0xa3e0 ||
	  wc >= 0xa3fb && wc <= 0xa3fe ||
	  wc >= 0xa4f4 && wc <= 0xa4fe ||
	  wc >= 0xa5f7 && wc <= 0xa5fe ||
	  wc >= 0xa6b9 && wc <= 0xa6c0 ||
	  wc >= 0xa6d9 && wc <= 0xa6fe ||
	  wc >= 0xa7c2 && wc <= 0xa7d0 ||
	  wc >= 0xa7f2 && wc <= 0xa7fe ||
	  wc >= 0xa8c1 && wc <= 0xaffe ||
	  wc >= 0xcfd4 && wc <= 0xcffe)
	continue;
      else if (wc >= 0xf4a5)
	goto done;
      else {
	  putchar(ku + WCTABLE_OFFSET);
	  putchar(ten + WCTABLE_OFFSET);
	  printf("\t%s\t%s\t%#x\n", metric, type, wc);
      }
    }
  }
 done:
  exit(0);
}  
