.\" -*- nroff -*-
.de TQ
.br
.ns
.TP \\$1
..
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH GROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff \- front end for the groff document formatting system
.SH SYNOPSIS
.B groff
[
.B \-tpeszaivhblCENRVXZ
]
[
.BI \-w name
]
[
.BI \-W name
]
[
.BI \-m name
]
[
.BI \-F dir
]
[
.BI \-T dev
]
[
.BI \-f fam
]
[
.BI \-M dir
]
[
.BI \-d cs
]
[
.BI \-r cn
]
[
.BI \-n num
]
[
.BI \-o list
]
[
.BI \-P arg
]
[
.IR files \|.\|.\|.\|
]
.SH DESCRIPTION
.B groff
is a front-end to the groff document formatting system.
Normally it runs the
.B @g@troff
program and a postprocessor appropriate for the selected
device.
Available devices are:
.TP
.B ps
For PostScript printers and previewers
.TP
.B dvi
For TeX dvi format
.TP
.B X75
For a 75 dpi X11 previewer
.TP
.B X100
For a 100dpi X11 previewer
.TP
.B ascii
For typewriter-like devices
.TP
.B latin1
For typewriter-like devices using the ISO Latin-1 character set.
.TP
.B nippon
For typewriter-like devices using the Japanese-EUC character set.
.LP
The postprocessor to be used for a device is specified by the
.B postpro
command in the device description file.
This can be overridden with the
.B \-X
option.
.LP
The default device is
.BR @DEVICE@ .
It can optionally preprocess with any of
.BR @g@pic ,
.BR @g@eqn ,
.BR @g@tbl ,
.BR @g@refer ,
or
.B @g@soelim.
.LP
Options without an argument can be grouped behind a single
.BR \- .
A filename of
.B \-
denotes the standard input.
.LP
The
.B grog
command can be used to guess the correct groff command to use to
format a file.
.SH OPTIONS
.TP
.B \-h
Print a help message.
.TP
.B \-e
Preprocess with @g@eqn.
.TP
.B \-t
Preprocess with @g@tbl.
.TP
.B \-p
Preprocess with @g@pic.
.TP
.B \-s
Preprocess with @g@soelim.
.TP
.B \-R
Preprocess with @g@refer.
No mechanism is provided for passing arguments to 
.B @g@refer
because most @g@refer options have equivalent commands
which can be included in the file.
See
.BR @g@refer (@MAN1EXT@)
for more details.
.TP
.B \-v
Make programs run by
.B groff
print out their version number.
.TP
.B \-V
Print the pipeline on stdout instead of executing it.
.TP
.B \-z
Suppress output from
.BR @g@troff .
Only error messages will be printed.
.TP
.B \-Z
Do not postprocess the output of
.BR @g@troff .
Normally
.B groff
will automatically run the appropriate postprocessor.
.TP
.BI \-P arg
Pass
.I arg
to the postprocessor.
Each argument should be passed with a separate
.B \-P
option.
Note that
.B groff
does not prepend
.B \-
to
.I arg
before passing it to the postprocessor.
.TP
.B \-l
Send the output to a printer.
The command used for this is specified by the
.B print
command in the device description file.
.TP
.BI \-L arg
Pass
.I arg
to the spooler.
Each argument should be passed with a separate
.B \-L
option.
Note that
.B groff
does not prepend
.B \-
to
.I arg
before passing it to the postprocessor.
.TP
.BI \-T dev
Prepare output for device
.IR dev .
The default device is
.BR @DEVICE@ .
.TP
.B \-X
Preview with
.B gxditview
instead of using the usual postprocessor.
This is unlikely to produce good results except with
.BR \-Tps .
.TP
.B \-N
Don't allow newlines with eqn delimiters.
This is the same as the
.B \-N
option in
.BR @g@eqn .
.TP
.B \-a
.TQ
.B \-b
.TQ
.B \-i
.TQ
.B \-C
.TQ
.B \-E
.TQ
.BI \-w name
.TQ
.BI \-W name
.TQ
.BI \-m name
.TQ
.BI \-o list
.TQ
.BI \-d cs
.TQ
.BI \-r cn
.TQ
.BI \-F dir
.TQ
.BI \-M dir
.TQ
.BI \-f fam
.TQ
.BI \-n num
These are as described in
.BR @g@troff (@MAN1EXT@) .
.SH ENVIRONMENT
.TP
.SM
.B GROFF_COMMAND_PREFIX
If this is set
.IR X ,
then
.B groff
will run
.IB X troff
instead of
.BR @g@troff .
This also applies to
.BR tbl ,
.BR pic ,
.BR eqn ,
.B refer
and
.BR soelim .
It does not apply to
.BR grops ,
.BR grodvi ,
.BR grotty
and
.BR gxditview .
.TP
.SM
.B GROFF_TMAC_PATH
A colon separated list of directories in which to search for
macro files.
.TP
.SM
.B GROFF_TYPESETTER
Default device.
.TP
.SM
.B GROFF_FONT_PATH
A colon separated list of directories in which to search for the
.BI dev name
directory.
.TP
.SM
.B PATH
The search path for commands executed by
.BR groff .
.TP
.SM
.B GROFF_TMPDIR
The directory in which temporary files will be created.
If this is not set and
.B
.SM TMPDIR
is set, temporary files will be created in that directory.
Otherwise temporary files will be created in
.BR /tmp .
The
.BR grops (@MAN1EXT@)
and
.BR @g@refer (@MAN1EXT@)
commands can create temporary files.
.SH FILES
.Tp \w'\fB@FONTDIR@/dev\fIname\fB/DESC'u+3n
.BI @FONTDIR@/dev name /DESC
Device description file for device
.IR name .
.TP
.BI @FONTDIR@/dev name / F
Font file for font
.I F
of device
.IR name .
.SH AUTHOR
James Clark <jjc@jclark.com>
.SH BUGS
Report bugs to bug-groff@prep.ai.mit.edu.
Include a complete, self-contained example
that will allow the bug to be reproduced,
and say which version of groff you are using.
.SH COPYRIGHT
Copyright \(co 1989, 1990, 1991, 1992 Free Software Foundation, Inc.
.LP
groff is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.
.LP
groff is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.
.LP
You should have received a copy of the GNU General Public License along
with groff; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.SH AVAILABILITY
The most recent released version of groff is always available for
anonymous ftp from prep.ai.mit.edu (18.71.0.38) in the directory
pub/gnu.
.SH "SEE ALSO"
.BR grog (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR @g@soelim (@MAN1EXT@) ,
.BR @g@refer (@MAN1EXT@),
.BR grops (@MAN1EXT@),
.BR grodvi (@MAN1EXT@),
.BR grotty (@MAN1EXT@),
.BR gxditview (@MAN1EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_ms (@MAN7EXT@),
.BR groff_me (@MAN7EXT@),
.BR groff_char (@MAN7EXT@)
