// -*- C++ -*-
/* Copyright (C) 1994 Free Software Foundation, Inc.
     Written by Toshiyuki Kitagawa (kitagawa@bsd2.kb.nec.co.jp)

This file is part of groff.

groff is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

groff is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with groff; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


#ifndef _WCHAR_H
#define _WCHAR_H

typedef unsigned short	wchar;

static const int WCTABLE_OFFSET = 0xa1;
static const int WCTABLE_SIZE = 94;
static const int EUCMASK = 0x8080;


inline int is_euc_code(wchar wc)
{
  return((wc & EUCMASK) == EUCMASK);
}

inline int is_euc_byte(unsigned char c)
{
  return(c >= 0xa1 && c <= 0xfe);
}

inline wchar make_euc_code(unsigned char ubyte, unsigned char lbyte)
{
  wchar wc;

  wc = (ubyte & 0xff) << 8;
  wc |= (lbyte & 0xff);
  return(wc);
}

inline unsigned int euc_ubyte(wchar wc)
{
  return((unsigned int)((wc >> 8) & 0xff));
}

inline unsigned int euc_lbyte(wchar wc)
{
  return((unsigned int)(wc & 0xff));
}

inline wchar calc_euccode(int ku, int ten)
{
  wchar code = 0;

  code = ((ku + WCTABLE_OFFSET) << 8) & 0xff00;
  code |= (ten + WCTABLE_OFFSET) & 0xff;
  return (code);
}
#endif	/* _WCHAR_H */
