/* Copyright (C) 1991 Aladdin Enterprises.  All rights reserved.  
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gdevepag.c */
/* ESC/Page driver for Ghostscript */
#include "gdevprn.h"

#define X_DPI 300
#define Y_DPI 300
#define LINE_SIZE ((2960+7) / 8)	/* bytes per line */

/* The device descriptors */
private dev_proc_print_page(epag_print_page);

gx_device_printer gs_epag_device =
  prn_device(prn_std_procs, "epag",
	83,				/* width_10ths, 8.3" */
	117,				/* height_10ths, 11.7" */
	X_DPI, Y_DPI,
	0.16, 0.20, 0.32, 0.20,		/* margins */
	1, epag_print_page);

/* ------ Internal routines ------ */

#define ESC 0x1b
#define GS  0x1d
#define CSI 0233

static char can_inits[] ={
  GS, 'r', 'h', 'E',                               /* hard reset */
  GS, '0', ';', '0', '.', '2', '4', 'm', 'u', 'E', /* Ǿñ 1/300' */
  GS, '0', 'p', 'o', 'E',                          /* landscape */
  GS, '1', 'm', 'm', 'E',                          /* ڡ⡼ */
  GS, '0', ';', '3', '0', '0', ';', '3', '0', '0', 'd', 'r', 'E',
  GS, '3', 'b', 'c', 'I',                          /* ̷ */
};

/* Send the page to the printer.  */
private int
epag_print_page(gx_device_printer *pdev, FILE *prn_stream)
{
  char data[LINE_SIZE*2];
  char buf[LINE_SIZE*2];
  char *out_data;
  int out_count;
  int c_size;
  
#define GS_print(str) fprintf(prn_stream, str, GS)
#define GS_print_1(str,arg) fprintf(prn_stream, str, GS, arg)

  /* initialize */
  fwrite(can_inits, sizeof(can_inits), 1, prn_stream);

  /* Send each scan line in turn */
  {	int lnum;
	int line_size = gdev_mem_bytes_per_scan_line((gx_device *)pdev);
	byte rmask = (byte)(0xff << (-pdev->width & 7));

	for ( lnum = 0; lnum < pdev->height; lnum++ )
	  {	char *end_data = data + line_size;
		int s;

		s = gdev_prn_copy_scan_lines(pdev, lnum,
						(byte *)data, line_size);
		/* Mask off 1-bits beyond the line width. */
		end_data[-1] &= rmask;
		/* Remove trailing 0s. */
		while ( end_data > data && end_data[-1] == 0 )
		  end_data--;
		if ( end_data != data ) {	
		  int num_cols = 0;

		  out_data = data;
		  while(out_data < end_data && *out_data == 0) {
		    num_cols += 8;
		    out_data++;
		  }
		  out_count = end_data - out_data;

		  /* move down */
		  GS_print_1("%c%dY", lnum);
		  /* move across */
		  GS_print_1("%c%dX", num_cols);

		  /*  */

		  c_size = data_compress(out_data, end_data, buf);
		  
		  /* transfer raster graphics */
		  fprintf(prn_stream, "%c%d;%d;1;0bi{I",
			  GS,  c_size, out_count * 8 );

		  /* send the row */
		  fwrite(buf, sizeof(char), c_size, prn_stream);
		}
	      }
      }
  /* eject page */
  fprintf(prn_stream, "\014");
  return 0;
}

/*@fn data_compress(out_data, end_data, buf)
 *@f1 ǡ򰵽̤buf˽񤭹
 *@fr ̸ΥХȿ֤
 */
data_compress(out_data, end_data, buf)
    char *out_data;      /*  ǡƬ  */
    char *end_data;      /*  ǡκǸܣ  */ 
    char *buf;           /*  ̸Υǡ񤭹  */
{
  char *p;              /* ɤ߽Фݥ       */
  char *q;              /* 񤭹ߥݥ       */
  int  pdata;           /* Ǹ˽񤭹ǡ */
  int  cdata;           /* ܥǡ             */
  int  count;           /* ǡԡȿ ݣ  */
  
  p = out_data;
  q = buf;
  pdata = 9999;          /* 褷ưפʤǡ */
  count = 0;
  
  while(p < end_data){
    cdata = *p++;
    if(cdata == pdata){   /*  */
      count++;
      if(count == 256){   /* ǡ졢 եå */
	*q++ = pdata;
	*q++ = count - 1;
	count = 0;
	pdata = 9999;     /* 褷ưפʤǡ */
      }
    }
    else{                 /* ΥǡȰ㤦 */
      if(count > 0){      /* եå       */
	*q++ = pdata;
	*q++ = count-1;
	count = 0;
      }
      *q++ = pdata = cdata;
    }
  }
  if(count >0){           /* ΥǡĤäƤ  */
    *q++ = pdata;         /* եå                      */
    *q++ = count - 1;
  }
  return(q-buf);
}

