/*
 * kfutil.c --- kanji font utilities
 *
 * Copyright (C) 1992 Norio Katayama.
 * Apr. 23, 1992 Programmed by N.Katayama (katayama@nacsis.ac.jp)
 */

#include "ghost.h"
#include "oper.h"
#include "errors.h"
#include "gsmatrix.h"

/*
 * Adjustment for Vertical Kanji
 */

private int
move(floatp dx, floatp dy, gs_rect *pbbox, gs_matrix *pmat)
{
	gs_matrix tmat;

	gs_make_translation(dx, dy, &tmat);
	gs_matrix_multiply(pmat, &tmat, pmat);
	gs_point_transform(pbbox->p.x, pbbox->p.y, &tmat, &pbbox->p);
	gs_point_transform(pbbox->q.x, pbbox->q.y, &tmat, &pbbox->q);
	return 0;
}

private int
roll(floatp xcl, floatp ycl, gs_rect *pbbox, gs_matrix *pmat)
{
	floatp lly, ury;
	gs_matrix mat, tmat;
	static gs_matrix rmat =
		{ constant_matrix_body(0.0, -1.0, 1.0, 0.0, 0.0, 0.0) };

	gs_make_translation(xcl - ycl, xcl + ycl, &tmat);
	gs_matrix_multiply(&rmat, &tmat, &mat);

	gs_matrix_multiply(pmat, &mat, pmat);
	gs_point_transform(pbbox->p.x, pbbox->p.y, &mat, &pbbox->p);
	gs_point_transform(pbbox->q.x, pbbox->q.y, &mat, &pbbox->q);
	lly = pbbox->q.y;
	ury = pbbox->p.y;
	pbbox->p.y = lly;
	pbbox->q.y = ury;
	return 0;
}

private int
mirror(floatp xcl, floatp ycl, gs_rect *pbbox, gs_matrix *pmat)
{
	gs_point temp;
	gs_matrix mat, tmat;
	static gs_matrix mmat =
		{ constant_matrix_body(0.0, -1.0, -1.0, 0.0, 0.0, 0.0) };

	gs_make_translation(xcl + ycl, xcl + ycl, &tmat);
	gs_matrix_multiply(&mmat, &tmat, &mat);

	gs_matrix_multiply(pmat, &mat, pmat);
	gs_point_transform(pbbox->p.x, pbbox->p.y, &mat, &pbbox->p);
	gs_point_transform(pbbox->q.x, pbbox->q.y, &mat, &pbbox->q);
	temp = pbbox->p;
	pbbox->p = pbbox->q;
	pbbox->q = temp;
	return 0;
}

#define MOVE(dx, dy)	move(dx, dy, pbbox, pmat)
#define LEFT	move(- pbbox->p.x, 0.0, pbbox, pmat)
#define RIGHT	move(xcl*2.0 - pbbox->q.x, 0.0, pbbox, pmat)
#define TOP	move(0.0, ycl*2.0 - pbbox->q.y, pbbox, pmat)
#define BOTTOM	move(0.0, - pbbox->p.y, pbbox, pmat);
#define HCENTER	move(xcl - (pbbox->p.x + pbbox->q.x)/2.0, 0.0, pbbox, pmat)
#define VCENTER	move(0.0, ycl - (pbbox->p.y + pbbox->q.y)/2.0, pbbox, pmat)
#define ROLL	roll(xcl, ycl, pbbox, pmat)
#define MIRROR	mirror(xcl, ycl, pbbox, pmat)

int
kf_vmatrix(int jis_code, floatp xcl, floatp ycl, 
	   gs_rect *pbbox, gs_matrix *pmat)
{
	gs_make_identity(pmat);

	switch(jis_code) {

	case 0x2122: RIGHT; TOP; MOVE(-100.0, 0.0); break;
	case 0x2123: RIGHT; TOP; MOVE(-100.0, 0.0); break;
	case 0x2131: ROLL; RIGHT; VCENTER; break;
	case 0x2132: ROLL; LEFT; VCENTER; break;
	case 0x213c: MIRROR; HCENTER; VCENTER; break;
	case 0x213d: ROLL; HCENTER; VCENTER; break;

	case 0x213e: ROLL; HCENTER; VCENTER; break;
	case 0x2141: MIRROR; HCENTER; VCENTER; break;
	case 0x2142: ROLL; HCENTER; VCENTER; break;
	case 0x2143: ROLL; HCENTER; VCENTER; break;
	case 0x2144: ROLL; HCENTER; VCENTER; break;
	case 0x2145: ROLL; HCENTER; VCENTER; break;

	case 0x214a: ROLL; HCENTER; BOTTOM; break;
	case 0x214b: ROLL; HCENTER; TOP; break;
	case 0x214c: ROLL; HCENTER; BOTTOM; break;
	case 0x214d: ROLL; HCENTER; TOP; break;
	case 0x214e: ROLL; HCENTER; BOTTOM; break;
	case 0x214f: ROLL; HCENTER; TOP; break;

	case 0x2150: ROLL; HCENTER; BOTTOM; break;
	case 0x2151: ROLL; HCENTER; TOP; break;
	case 0x2152: ROLL; HCENTER; BOTTOM; break;
	case 0x2153: ROLL; HCENTER; TOP; break;
	case 0x2154: ROLL; HCENTER; BOTTOM; break;
	case 0x2155: ROLL; HCENTER; TOP; break;

	case 0x2156: ROLL; RIGHT; BOTTOM; break;
	case 0x2157: ROLL; LEFT; TOP; break;
	case 0x2158: ROLL; RIGHT; BOTTOM; break;
	case 0x2159: ROLL; LEFT; TOP; break;
	case 0x215a: ROLL; HCENTER; BOTTOM; break;
	case 0x215b: ROLL; HCENTER; TOP; break;

	case 0x222e: ROLL; HCENTER; VCENTER; break;
	case 0x2421: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2423: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2425: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2427: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2429: HCENTER; MOVE(100.0, 0.0); VCENTER; break;

	case 0x2443: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2463: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2465: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2467: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x246e: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2521: HCENTER; MOVE(100.0, 0.0); VCENTER; break;

	case 0x2523: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2525: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2527: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2529: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2543: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2563: HCENTER; MOVE(100.0, 0.0); VCENTER; break;

	case 0x2565: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2567: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x256e: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2575: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	case 0x2576: HCENTER; MOVE(100.0, 0.0); VCENTER; break;
	default: 
		return 0;
	};
	return 1;
}

int
kf_is_vchar(int jis_code)
{
	switch(jis_code) {
	case 0x2122: case 0x2123: case 0x2131: case 0x2132: case 0x213c: 
	case 0x213d: case 0x213e: case 0x2141: case 0x2142: case 0x2143:
	case 0x2144: case 0x2145: case 0x214a: case 0x214b: case 0x214c:
	case 0x214d: case 0x214e: case 0x214f: case 0x2150: case 0x2151:
	case 0x2152: case 0x2153: case 0x2154: case 0x2155: case 0x2156:
	case 0x2157: case 0x2158: case 0x2159: case 0x215a: case 0x215b:
	case 0x222e: case 0x2421: case 0x2423: case 0x2425: case 0x2427:
	case 0x2429: case 0x2443: case 0x2463: case 0x2465: case 0x2467:
	case 0x246e: case 0x2521: case 0x2523: case 0x2525: case 0x2527:
	case 0x2529: case 0x2543: case 0x2563: case 0x2565: case 0x2567:
	case 0x256e: case 0x2575: case 0x2576:
		return 1;
	default: 
		return 0;
	};
}
