/* add.c -- simple filter for 8 bit images or any 8 bit "smooth" data
 * Written by Arthur David Olson <ado@elsie.nci.nih.gov>
 *
 * add is the reverse filter of sub (see sub.c). It simply reads on stdin
 * differences between successive bytes and writes to stdout the raw bytes.
 * sub can improve compression of 8 bit images or any 8 bit "smooth" data.
 * For compression, use:
 *   sub < raw_data | gzip > data.sub.gz
 * For decompression, use:
 *   gunzip < data.sub.gz | add > raw_data
 *
 * This program can easily be extended to handle 24 bit images, or 16 bit
 * sound samples, or sequences of slowly varying floating point numbers.
 */

#include "stdio.h"

main()
{
    int	c;
    int	prevc = 0;

    while ((c = getchar()) != EOF) {
	prevc += c;
	(void) putchar(prevc & 0xff);
    }
    exit(0);
    return 0; /* just to avoid warnings */
}
