/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef nls_locale_h
#define nls_locale_h

#include <NLS/enter-scope.h>
#include <OS/enter-scope.h>

class String;
class UniqueString;
class LocaleRepTable;

class LocaleRep {
  public:
    LocaleRep();
    ~LocaleRep();

  public:
    UniqueString*		name_;
    UniqueString*		codeset_;
};

class Locale {
  public:
    static const Locale& setlocale ();
    static const Locale& setlocale (const char*);
    static const Locale& setlocale (const String&);
    static const Locale& setlocale (const Locale&);

  public:
    Locale (const char*);
    Locale (const String&);
    Locale (const Locale&);

  public:
    const UniqueString& name () const;
    const UniqueString& codeset () const;

  private:
    LocaleRep* rep (const String&);

  private:
    const LocaleRep		*rep_;
    
  private:
    static Locale		*default_;
    static LocaleRepTable	*table_;
};

inline const UniqueString& Locale::name () const {
    return *rep_->name_;
}

inline const UniqueString& Locale::codeset () const {
    return rep_->codeset_ ? (*rep_->codeset_) : *rep_->name_;
}

#endif
