/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef nls_wcharbuf_h
#define nls_wcharbuf_h

#include <NLS/enter-scope.h>

class WChar;
class WString;
class WCharList;
class WRegexp;

class WCharBuffer {
  public:
    WCharBuffer(int size = 0);
    virtual ~WCharBuffer();

  public:
    int Length();
    int Dot();
    int Dot(int);
    
  public:
    /* edit function */
    virtual void Insert (const WChar&);
    virtual void Insert (const WString&);
    virtual void Delete (int count = 1);
    virtual void Clear ();
    
  public:
    /* move dot function. these return dot */

    virtual int PreviousCharacter (int = 1);
    virtual int NextCharacter (int = 1);
    virtual int PreviousLine (int = 1);
    virtual int NextLine (int = 1);

    virtual int BeginningOfWord ();
    virtual int EndOfWord ();
    virtual int BeginningOfPreviousWord ();
    virtual int BeginningOfNextWord ();
    virtual int EndOfPreviousWord ();
    virtual int EndOfNextWord ();

    virtual int BeginningOfLine ();
    virtual int EndOfLine ();
    virtual int BeginningOfNextLine ();
    virtual int EndOfNextLine();
    virtual int BeginningOfPreviousLine ();
    virtual int EndOfPreviousLine ();

    virtual int BeginningOfBuffer ();
    virtual int EndOfBuffer ();

    virtual int GotoBeginningOfLine(int);
    virtual int GotoEndOfLine(int);
    virtual int LineOffset ();
    virtual int LineNumber ();

    virtual int SearchForward(WRegexp&);
    virtual int SearchBackward(WRegexp&);
    
  public:
    virtual WChar Item ();
    virtual WChar Item (int);
    virtual const WString Text (int dot = 0, int length = -1);
    virtual int LinesBetween(int, int);

  public:
    virtual void DefineWord (const WString&);

  protected:
    virtual void FixGap();

  private:
    WCharList	*prefix_;
    WCharList	*suffix_;
    WCharList	*work_;
    WRegexp	*word_;
    int		dot_;
    int		length_;

    int		lastdot_;
    int		lastnum_;
};

inline int WCharBuffer::Dot() { return dot_; }
inline int WCharBuffer::Length() { return length_; }

#endif
